<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgRoleInfo" %>

<%@ page import="com.eg.MappingNameSorter" %>

<%@ page import="com.egurkha.ini.IniUI" %>

<%@ page import="com.eg.EgName" %>

<%@ page import="com.eg.EgSpecsInfo" %>

<%@ page import="com.eg.EgThresholdInfo" %>



<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>



<%

	IniUI iniUI = IniUI.getInstance();

	String userLanguage = iniUI.getDefaultLanguage();

	if (_user != null)

	{

		userLanguage = _user.getLanguage();

	}

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);



	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);

	IniFile tablesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tables.ini");

	IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

	IniFile testsIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");

	IniFile reportIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_report.ini");



	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");


	String[] capacityTestsDetails = testsIniFile.getVariables("CAPACITY_TESTS");
	ArrayList aListCapacityTestsEnabled = new ArrayList();
	ArrayList aListCapacityTestsDisabled = new ArrayList();
	for (int i=0;i<capacityTestsDetails.length;i++)
	{
		String strCapacityTestDetail = capacityTestsDetails[i];
		String strValue = testsIniFile.getValue("CAPACITY_TESTS",strCapacityTestDetail);
		if (strValue.equalsIgnoreCase("yes") || 
			strValue.equalsIgnoreCase("true") || 
			strValue.equalsIgnoreCase("y"))
		{
			aListCapacityTestsEnabled.add(strCapacityTestDetail);
		}
		else
		{
			aListCapacityTestsDisabled.add(strCapacityTestDetail);
		}
	}

	String componentType = request.getParameter("componentType");
	componentType = (componentType == null || componentType.equals("-1"))?"":componentType;

	String previousComponentType = request.getParameter("previousComponentType");
	previousComponentType = (previousComponentType == null)?"":previousComponentType;

	String testName = request.getParameter("testName");
	testName = (testName != null && !testName.equals("-1"))?testName:"";

	String previousTestName = request.getParameter("previousTestName");
	previousTestName = (previousTestName != null && !previousTestName.equals("-1"))?previousTestName:"";

	ArrayList aListEnabledTestForCompType = new ArrayList();
	if (!componentType.equals(""))
	{
		aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
	}

	String showAllTests = "selected";
	String showCETests = "";
	String cpctEnabledTest = request.getParameter("cpctEnabledTest");
	if (aListEnabledTestForCompType != null && aListEnabledTestForCompType.size() > 0)
	{
		if (cpctEnabledTest != null && cpctEnabledTest.equalsIgnoreCase("true"))
		{
			showAllTests = "";
			showCETests = "selected";

			ArrayList aListTemp = new ArrayList();
			for (int i=0;i<aListEnabledTestForCompType.size();i++)
			{
				String str = (String)aListEnabledTestForCompType.get(i);
				if (aListCapacityTestsEnabled.contains(str))
				{
					aListTemp.add(str);
				}
			}

			aListEnabledTestForCompType = aListTemp;
		}
	}

	String capacityTestStatus = request.getParameter("capacityTestStatus");
	if (!testName.equals("") && !previousTestName.equals(""))
	{
		if (!testName.equals(previousTestName))
		{
			capacityTestStatus = null;
		}
	}

	if (componentType.equals(""))
	{
		testName = "";
	}

	if (!componentType.equals("") && !previousComponentType.equals(""))
	{
		if (!previousComponentType.equals(componentType))
		{
			testName = "";
		}
		else if (!aListCapacityTestsEnabled.contains(testName))
		{
			if (cpctEnabledTest != null && cpctEnabledTest.equalsIgnoreCase("true"))
			{
				testName = "";
			}
		}
	}

	if (aListEnabledTestForCompType != null && aListEnabledTestForCompType.size() > 0)
	{
		aListEnabledTestForCompType = sorter.getSortedTestList(aListEnabledTestForCompType);
	}

	String[] measureLayerTable = tablesIniFile.getVariables("MEASUREMENT_LAYER_TABLE");

	int tableSize = measureLayerTable.length;

	TreeMap tmapTestAndMeasures = new TreeMap();

	for (int i=0;i<tableSize;i++)

	{

		String strPattern = measureLayerTable[i];

		int colonIdx = strPattern.indexOf(":");

		String strTestName = strPattern.substring(0,colonIdx);

		String strTestMeasure = strPattern.substring(colonIdx+1);

		ArrayList aListTemp = (ArrayList)tmapTestAndMeasures.get(strTestName);

		if (aListTemp == null)

		{

			aListTemp = new ArrayList();

			aListTemp.add(strTestMeasure);

			tmapTestAndMeasures.put(strTestName,aListTemp);

		}

		else

		{

			aListTemp.add(strTestMeasure);

		}

	}



	String[] testMeasuresValues = thresholdInfo.getMeasurementsForTest(testName);

	ArrayList aListMeasures = null;

	if (testMeasuresValues != null)

	{

		aListMeasures = new ArrayList(Arrays.asList(testMeasuresValues));

	}



	String[] percentiles = servicesIniFile.getVariables("CAPACITY_PLANNING_PERCENTILE");

	ArrayList aListPercentiles = null;

	if (testName.length() > 0 && aListMeasures != null)

	{

		aListPercentiles = new ArrayList(Arrays.asList(percentiles));

	}


	ArrayList aListResultantDetails = null;
	if (aListMeasures != null && testName.length() > 0)
	{
		aListResultantDetails = new ArrayList();

		for (int i=0;i<aListMeasures.size();i++)
		{
			String strMeasure = (String)aListMeasures.get(i);
			String tempValue = testsIniFile.getValue("CAPACITY_PLANNING_PERCENTILE",testName + ":" + strMeasure);

			String strPercentileValue = null;
			String strReportView = null;
			if (tempValue == null || tempValue.length() == 0)
			{
				strPercentileValue = "Default";
				strReportView = "XP";
			}
			else
			{
				strPercentileValue = tempValue;
				strReportView = reportIniFile.getValue("CAPACITY_PLANNING",testName + ":" + strMeasure);
				if (strReportView == null || strReportView.length() == 0)
				{
					strReportView = "XP";
				}
			}

			aListResultantDetails.add(strMeasure);
			aListResultantDetails.add(strPercentileValue);
			aListResultantDetails.add(strReportView);
		}

		session.setAttribute("aListMeasures",aListMeasures);
	}

%>



<html>

<head>

<egui:skin ui="admin"/>
<script language="javascript"> 



function callPage()

{

	var thisForm = document.reportsettingform;

	thisForm.method = "post";

	thisForm.action = "EgReportSetting.jsp";

	thisForm.submit();

}



function apply()

{

	var thisForm = document.reportsettingform;
	var allowToUpdate = true;
	var allowtoValidate = false;

	if (allowToUpdate)
	{
		thisForm.method = "post";
		thisForm.action = "EgReportSettingp.jsp";
		thisForm.submit();
	}
}



function changePercentile(value,testName)
{
	var thisForm = document.reportsettingform;
	var answer = confirm('<egui:intnl text="admin.percentile.Do you want to apply this percentile policy to all measures of"/>' + ' ' + testName + '?');
	if (answer)
	{
		for (var i=0;i<thisForm.elements.length;i++)
		{
			if (thisForm.elements[i].type == "select-one")
			{
				if (thisForm.elements[i].name.indexOf("_percentileType") > -1)
				{
					thisForm.elements[i].value = value;
				}
			}
		}
	}
}
</script>

</head>



<body style="overflow:auto" id="space6">

<form name="reportsettingform" method="post" action="" style="margin:0px">

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<tr>
		<td height="0" align="left"  class="eg_cellbglits" colspan="2"> 
			<table align="center" cellspacing="0" cellpadding="4" border="0">
				<tr>
					<td height="24" nowrap><egui:intnl text="admin.percentile.This panel allows the user to enable/disable tests for capacity planning and associate percentile policy, report view for its measures"/>.</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td background="/final/admin/eg_images/in_titleshadowbg1.gif" height="7" id="eg_blankspace" width="100%" colspan="2">&nbsp;</td>
	</tr>

	<tr>
		<td class="eg_blankspace" height="15">&nbsp;</td>
	</tr>
	<tr>

		<td width="100%" id="eg_whitebg" align="center" valign="middle">

			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">

				<tr>

					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>

					<td height="6" id="eg_subcontentbg" ><img src="/final/admin/eg_images/spacer.gif" height="6"></td>

					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>

				</tr>
				<tr>

					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>

					<td align="center" id="eg_subcontentbg" nowrap >

						<table border="0" cellspacing="0" cellpadding="0" width="100%" align="center"><col width="15%"><col width="35%"><col width="15%"><col width="35%">
							<tr>
								<td align="right" style="padding-left:5px"><egui:intnl text="admin.percentile.Component Type"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" >&nbsp;&nbsp;<select name="componentType" id="componentType" style="width:230px" onchange="javascript:callPage()">
<%
	if (listComponentTypes.size() > 0)
	{
%>
		<option value="-1"><egui:intnl text="admin.common.Choose a component type"/></option>
<%
	}
	else
	{
%>
		<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}
	//EgName class is used to hold name and its localised name.
	for (int j=0; j<listComponentTypes.size(); j++)
	{
		EgName nameObj = (EgName)listComponentTypes.get(j);
		String actualname = nameObj.getActualName();
		String localname = nameObj.getLocalName();
		if (actualname.equals(componentType))
		{
%>
			<option value="<%=actualname%>" selected><%=localname%></option>
<%
		}
		else
		{
%>
			<option value="<%=actualname%>"><%=localname%></option>
<%
		}
	}
%>
									</select>
								</td>
								<td align="right" style="padding-left:5px"><egui:intnl text="admin.percentile.Show Tests"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright">&nbsp;&nbsp;<select name="cpctEnabledTest" id="cpctEnabledTest" style="width:230px" onChange="javascript:callPage()">
									<option value="false" <%=showAllTests%>><egui:intnl text="admin.percentile.All"/></option>
									<option value="true" <%=showCETests%>><egui:intnl text="admin.percentile.Capacity enabled"/></option>
								</select>
								</td>
							</tr>
							<tr>
								<td colspan="4">&nbsp;</td>
							</tr>
							<tr>

								<td align="right" style="padding-left:5px">&nbsp;&nbsp;</td>

								<td id="eg_subcontentbg" align="left" class="paddingright">&nbsp;&nbsp;</td>
								<td align="right" style="padding-left:5px"><egui:intnl text="admin.percentile.Test Name"/>&nbsp;:&nbsp;</td>

								<td id="eg_subcontentbg" align="left" class="paddingright" >&nbsp;&nbsp;<select name="testName" id="testName" style="width:230px" onchange="javascript:callPage()">

<%

	if (aListEnabledTestForCompType.size() > 0)
	{

%>

		<option value="-1"><egui:intnl text="admin.common.Choose a test"/></option>

<%

	}
	else

	{

%>

		<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>

<%

	}


	//EgName class is used to hold name and its localised name.

	for (int j=0; j<aListEnabledTestForCompType.size(); j++)
	{

		EgName nameObj = (EgName)aListEnabledTestForCompType.get(j);

		String strTestName = nameObj.getActualName();

		String strTestDisplayValue = nameObj.getLocalName();

		if (testName != null && strTestName.equals(testName))
		{

%>

			<option value="<%=strTestName%>" selected><%=strTestDisplayValue%></option>
<%

		}
		else
		{

%>

			<option value="<%=strTestName%>"><%=strTestDisplayValue%></option>
<%

		}
	}

%>

								</select>

								</td>


							</tr>

							<tr>
								<td colspan="4">&nbsp;</td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr>

					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>

					<td id="eg_subcontentbg" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>

				</tr>

			</table>

		</td>

	</tr>

	<tr>

		<td>&nbsp;</td>

	</tr>

<%
	if (testName.length() > 0)
	{
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" class="">
<%
		String strEnabled = "";
		String strDisabled = "";
		if (capacityTestStatus == null)
		{
			if (aListCapacityTestsEnabled.contains(testName))
			{
				strEnabled = "checked";
				strDisabled = "";
			}
			else
			{
				strEnabled = "";
				strDisabled = "checked";
			}
		}
		else
		{
			if (capacityTestStatus.equals("yes"))
			{
				strEnabled = "checked";
				strDisabled = "";
			}
			else
			{
				strEnabled = "";
				strDisabled = "checked";
			}
		}
%>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" ><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr>
					<td id="eg_subcontentbg">&nbsp;</td>
					<td align="center" id="eg_subcontentbg" nowrap>

						<table align="center" border="0" width="100%">
							<tr>
								<td><egui:intnl text="admin.percentile.Capacity Planning"/></td>
								<td>:</td>
								<td>
									<table cellspacing="0" cellpadding="2" border="0">
										<tr>
											<td align="left"><input type="radio"class="eg_input" name="capacityTestStatus" value="yes" <%=strEnabled%> onclick='javascript:callPage()'></td>
											<td align="left"><egui:intnl text="admin.percentile.Enable"/></td>
											<td align="left"><input type="radio"class="eg_input" name="capacityTestStatus" value="no" <%=strDisabled%> onclick='javascript:callPage()'></td>
											<td align="left"><egui:intnl text="admin.percentile.Disable"/></td>
										</tr>
									</table>
								</td>
								<td >&nbsp;</td>
							</tr>
						</table>
					</td>
					<td id="eg_subcontentbg">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>

				<tr>
					<td height="70%" colspan="3">&nbsp;&nbsp;&nbsp;</td>
				</tr>
<%
		if (aListMeasures != null && aListMeasures.size() > 0)
		{
%>
				<tr>
					<td colspan="3">
						<table border="0" width="100%" align="center" cellspacing="0" cellpadding="0px" ><col width="6px"><col width="300px"><col width="300px"><col width="200px"><col width="6px">
							<tr>
								<td width="6" id="subhead_left" height="20" ><img src="/final/admin/eg_images/spacer.gif" border="0" width="6" height="20">
								</td>
								<td class="eg_subheadbg_lower" style="padding-left:4px;border-left-width:0px"><strong> <egui:intnl text="admin.percentile.Measure"/></strong></td>
								<td class="eg_subheadbg_lower" style="padding-left:4px"><strong> <egui:intnl text="admin.percentile.Percentile Policy"/></strong></td>
								<td class="eg_subheadbg_lower" style="padding-left:4px;border-right-width:0px"><strong><egui:intnl text="admin.percentile.Report View"/></strong></td>
								<td width="6" id="subhead_right" ><img src="/final/admin/eg_images/spacer.gif" border="0" width="6" height="20">
								</td>
							</tr>
<%
			for (int i=0;i<aListMeasures.size();i++)
			{
				String strMeasure = (String)aListMeasures.get(i);
				String strDisplayValue = _mapping.getMeasureDescription(testName,strMeasure);
				int idx1 = aListResultantDetails.indexOf(strMeasure);
				String tempPercentile = null;
				String tempReportView = null;
				if (idx1 > -1)
				{
					tempPercentile = (String)aListResultantDetails.get(idx1+1);
					tempReportView = (String)aListResultantDetails.get(idx1+2);
				}

				if (tempPercentile == null)
				{
					tempPercentile = "Default";
				}

				if (tempReportView == null)
				{
					tempReportView = "XP";
				}
%>
							<tr>
								<td align="center" class="linebottomleft eg_innerbody" height="24px">&nbsp;</td>
								<td align="left" wrap = "true" class = "linebottomright eg_innerbody" style="padding-right:4px"><%=strDisplayValue%>
								</td>
								<td align="center" wrap="true" class = "linebottomright eg_innerbody padding4">
<%
				if (strDisabled.equalsIgnoreCase("checked"))
				{
%>

									<select name="<%=strMeasure + "_percentileType"%>" class="list" style="width:260px" disabled>

<%
				}
				else
				{
					if (i == 0)
					{
						if (aListMeasures.size() == 1)
						{
%>
									<select name="<%=strMeasure + "_percentileType"%>" class="list" style="width:260px">

<%
						}
						else
						{
%>
									<select name="<%=strMeasure + "_percentileType"%>" class="list" style="width:260px" onchange="javascript:changePercentile(this.value,'<%=_mapping.getTestDescription(testName)%>');">

<%
						}
					}
					else
					{
%>
									<select name="<%=strMeasure + "_percentileType"%>" class="list" style="width:260px">

<%
					}
				}
				if (aListPercentiles == null || aListPercentiles.size() == 0)
				{
%>
					<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
				}
				else
				{
					for (int j=0; j<aListPercentiles.size(); j++)
					{
						String strPercentile = (String)aListPercentiles.get(j);

						if (tempPercentile.equals(strPercentile))
						{
%>
							<option value="<%=strPercentile%>" selected><%=strPercentile%></option>
<%
						}
						else
						{
%>
							<option value="<%=strPercentile%>"><%=strPercentile%></option>
<%
						}
					}
				}
%>
									</select>
								</td>

								<td align="center" wrap = "true" class = "linebottom padding4 eg_innerbody">
<%
				if (strDisabled.equalsIgnoreCase("checked"))
				{
%>
								<select name="<%=strMeasure + "_reportView"%>" class="list" style="width:260px" disabled>
<%
				}
				else
				{
%>
								<select name="<%=strMeasure + "_reportView"%>" class="list" style="width:260px">
<%
				}
				if (tempReportView.equalsIgnoreCase("XP"))
				{
%>

									<option value="MP"><egui:intnl text="admin.percentile.Minimum"/></option>
									<option value="XP" selected><egui:intnl text="admin.percentile.Maximum"/></option>
<%
				}
				else
				{
%>

									<option value="MP" selected><egui:intnl text="admin.percentile.Minimum"/></option>
									<option value="XP"><egui:intnl text="admin.percentile.Maximum"/></option>
<%
				}
%>
									</select>
								</td>
								<input type="hidden" name="$_<%=strMeasure + "_reportView"%>" value="<%=tempReportView.equalsIgnoreCase("XP")?"Maximum":"Minimum"%>">
								<input type="hidden" name="$_<%=strMeasure + "_percentileType"%>" value="<%=tempPercentile%>">
								<td align="center" wrap = "true" class="linebottomright eg_innerbody">&nbsp;</td>
							</tr>
<%
			}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td colspan="3" id="eg_blankspace" height="10" class="eg_whitebg">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="3" align="center" id="eg_whitebg"><input type="button" name="updatebutton" value='Update' onClick="javascript:apply()" name="update" class="eg_back">
				</tr>
				<tr>
					<td colspan="3" id="eg_blankspace" height="10" class="eg_whitebg">&nbsp;</td>
				</tr>
<%
		}
%>
			</table>
		</td>
		<input type="hidden" name="previousComponentType" value="<%=componentType%>">
		<input type="hidden" name="previousTestName" value="<%=testName%>">
	</tr>

	<tr>
		<td>&nbsp;&nbsp;&nbsp;</td>
	</tr>
<%
	}
%>
</table>

</form>

</body>

</html>
<%
	String from = "";
	if(testName != null && testName.length() > 0)
	{
		from = "/final/admin/EgReportSetting.jsp?componentType="+componentType+"&cpctEnabledTest="+cpctEnabledTest+"&testName="+testName;
		session.setAttribute("adminLastAccessedURL","/final/admin/EgReportCustomSetting.jsp?showOnly=2&from="+from);
	}
	else
	{
		from = "/final/admin/EgReportSetting.jsp";
		session.setAttribute("adminLastAccessedURL","/final/admin/EgReportCustomSetting.jsp?showOnly=2&from="+from);
	}
%>



