<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import="java.util.*" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%
	String disName = request.getParameter("disName");
	String domainName = request.getParameter("domainName");
	ArrayList error = (ArrayList)session.getAttribute("domainError");
	ArrayList disError = getErrorMessage(error);
%>
<html>
<head>
<title>Root Cause Analysis</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui="admin"/>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
</head>
<body>
<table border="0" cellpadding="0" cellspacing="0" width="100%">
	<tr>
		<td id="tdborder1" class="whitefont" height="55" width="100%"><H1>&nbsp;&nbsp;&nbsp;Root Cause</H1></td>
	</tr>
	<tr>
		<td width="97%" align="center" style="padding-top:10px;" >
			<table border="0" cellpadding="4" cellspacing="0" width="97%" id="cell_border1">
				<tr>
					<td id=""  align="left" nowrap><b><egui:intnl text="admin.auth.Display Name" /><b></td>
					<td >&nbsp;:</td>
					<td id="" align="left" nowrap><b><%=disName%><b></td>
					<td >&nbsp;</td>
					<td id="" align="right" nowrap><b><egui:intnl text="admin.auth.Domain Name" /><b></td>
					<td >&nbsp;:</td>
					<td id="" align="left" nowrap><b><%=domainName%><b></td>
				</tr>
				<tr>
					<td id="" align="left" nowrap><b><egui:intnl text="admin.auth.Error Type" /><b></td>
					<td >&nbsp;:</td>
					<td id="" align="left" nowrap><b><%=(!(disError.get(1).toString()).equals("") && (disError.get(1).toString()).length() > 0)?disError.get(1):"-"%><b></td>
					<td >&nbsp;</td>
					<td id="" align="right" nowrap><b><egui:intnl text="admin.auth.Error Code" /><b></td>
					<td >&nbsp;:</td>
					<td id="" align="left" nowrap><b><%=(!(disError.get(2).toString()).equals("") && (disError.get(2).toString()).length() > 0)?disError.get(2):"-"%><b></td>
				</tr>
				<tr>
				<td style="background:#fff;border-width: 1px 0px 0px 0px" id="cell_border1" colspan="7" >
					<div>
						<table border="0" cellpadding="5" cellspacing="0" width="100%">
							<tr>
<%
	String rootErr = (String)disError.get(0);
	if (rootErr != null && !rootErr.equals("") && rootErr.length() > 0)
	{
		String val = (String)disError.get(0);
		if (val != null && val.equalsIgnoreCase("USER_EXCEPTION"))
		{
			val = "<div  align='center' height='300px'><b>The specified username is not available in domain server</b>.</div>";
		}
%>
								<td>
									<%=val%>
								</td>
<%
	}
	else
	{
%>
								<td height="300px" align="center">
									<b><egui:intnl text="admin.auth.The root cause could not be found" />. <egui:intnl text="admin.auth.For more information" />,&nbsp;<egui:intnl text="admin.auth.please check the manager error log" />.</b>
								<td>
<%
	}
%>
							</tr>
						</table>
					</div>
				</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td height="10">&nbsp;</td>
	</tr>
</table>
</body>
</html>
<%!
	private ArrayList getErrorMessage(ArrayList stausList)
	{
		String kdcNotFound = "";
		String errCode = "";
		String rootCause = "";
		String errorStr = "";
		String errorType = "";
		ArrayList errorResult = new ArrayList();
		if (stausList == null)
		{
			stausList = new ArrayList();
		}

		if(stausList.contains("EXCEPTION"))
		{
			int idx = stausList.indexOf("EXCEPTION");
			Exception e =(Exception)stausList.get(idx+1);
			rootCause = (String)e.getMessage();
			errorStr = e.toString();
			StringBuffer buf = new StringBuffer();
			buf.append(errorStr);
			buf.append("\n");
			StackTraceElement[] err = e.getStackTrace();
			for (int lcv = 0; lcv < err.length; lcv++)
			{
				buf.append("\n");
				buf.append(err[lcv].toString());
			}
			errorStr = buf.toString();
			errorType = errorStr.substring(0,errorStr.indexOf(":"));
			if (errorStr.startsWith("javax.naming.AuthenticationException"))
			{
				String errMessage = e.getMessage();
				StringTokenizer strTokens = new StringTokenizer(errMessage,",");
				while(strTokens.hasMoreTokens())
				{
					String tok = strTokens.nextToken();
					if (tok.startsWith(" data "))
					{
						errCode = tok.substring(tok.indexOf(" ",1)+1);
					}
				}
			}
			else if (errorStr.startsWith("javax.naming.AuthenticationNotSupportedException"))
			{
				String errMessage = e.getMessage();
				if (errMessage.indexOf("error code") != -1)
				{
					String temp = errMessage.substring(errMessage.indexOf("error code")+11);
					char charData = temp.charAt(0);
					errCode = Character.toString(charData);
				}
			}
		}
		else if (stausList.contains("KERBEROS"))
		{
			int idx = stausList.indexOf("KERBEROS");
			errorStr =(String )stausList.get(idx+1);
			Object krbObj = null;
			if (stausList.size() > 2)
			{
				krbObj = stausList.get(idx+2);
			}

			if (krbObj != null && krbObj instanceof Exception)
			{
				Exception e =(Exception)stausList.get(idx+2);
				errorStr = e.toString();
				rootCause = (String)e.getMessage();
				errorStr = e.toString();
				if (errorStr != null && errorStr.startsWith("java.lang.Exception:"))
				{
					errorStr = errorStr.substring(errorStr.indexOf("java.lang.Exception:")+21);
				}
				StringBuffer buf = new StringBuffer();
				buf.append(errorStr);
				StackTraceElement[] err = e.getStackTrace();
				for (int lcv = 0; lcv < err.length; lcv++)
				{
					buf.append("\n");
					buf.append(err[lcv].toString());
				}
				errorStr = buf.toString();
				errorType = errorStr.substring(0,errorStr.indexOf(":"));
			}

			if (errorStr.startsWith("javax.naming.AuthenticationException"))
			{
				StringTokenizer strTokens = new StringTokenizer(errorStr,",");
				while(strTokens.hasMoreTokens())
				{
					String tok = strTokens.nextToken();
					if (tok.startsWith(" data "))
					{
						errCode = tok.substring(tok.indexOf(" ",1)+1);
					}
				}
			}
			else if (errorStr.startsWith("PRE_EXCEPTION"))
			{
				int idxy = stausList.indexOf("PRE_EXCEPTION");
				Exception e =(Exception)stausList.get(idxy+1);
				errorStr = e.toString();
				rootCause = (String)e.getMessage();
				errorStr = e.toString();
				StringBuffer buf = new StringBuffer();
				buf.append(errorStr);
				StackTraceElement[] err = e.getStackTrace();
				for (int lcv = 0; lcv < err.length; lcv++)
				{
					buf.append("\n");
					buf.append(err[lcv].toString());
				}
				errorStr = buf.toString();
				errorType = errorStr.substring(0,errorStr.indexOf(":"));
				if (errorStr.startsWith("javax.naming.AuthenticationException"))
				{
					StringTokenizer strTokens = new StringTokenizer(errorStr,",");
					while(strTokens.hasMoreTokens())
					{
						String tok = strTokens.nextToken();
						if (tok.startsWith(" data "))
						{
							errCode = tok.substring(tok.indexOf(" ",1)+1);
						}
					}
				}
				else if (errorStr.startsWith("javax.naming.AuthenticationNotSupportedException"))
				{
					String errMessage = e.getMessage();
					if (errMessage != null && errMessage.indexOf("error code") != -1)
					{
						String temp = errMessage.substring(errMessage.indexOf("error code")+11);
						char charData = temp.charAt(0);
						errCode = Character.toString(charData);
					}
				}
			}
			
		}
		errorResult.add(errorStr);
		errorResult.add(errorType);
		errorResult.add(errCode);
		return errorResult;
	}
%>