<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.eg.*"%>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "net.sf.json.*"%>
<jsp:useBean id="DiscBean" scope="page" class="egurkha.ServiceBean"/>
<jsp:useBean id="port" scope="page" class="egurkha.ServiceBean"/>
<jsp:useBean id="configTopo" scope="page" class="egurkha.ConfigTopology"/>

<%!
	String[] icmpoptions = new String[2];
	public void jspInit()
	{
		icmpoptions[0] = "Yes";
		icmpoptions[1] = "No";
	}

	public ArrayList getvCenterDetails()
	{
		// 1) Going to iterate eg_agents.ini thru remote agents sections
		// 2) Under each remote agent,Collecting all vars & vals
		// 3) If any val has "-virtual_center" param then parse the val to collect the vCenter name and var for ESX name
		IniFile agentsIni = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_agents.ini");
		EgExternalInfo ext = new EgExternalInfo("manager");
		String[] rmtAgents = ext.getAllRemoteAgents();
		int remLen = rmtAgents.length;
		String vCenterParam = "-virtual_center";
		int vCParamLen = vCenterParam.length();
		HashMap vcEsxMap = new HashMap();
		HashMap vCRmtAgentMap = new HashMap();
				
		for (int r=0; r<remLen; r++)
		{
			String rmtAgent = rmtAgents[r];
			String[] allVars =  agentsIni.getVariables(rmtAgent);
			Vector allValues = agentsIni.getAllValues(rmtAgent);
			if (allValues != null)
			{
				int allValuesSize = allValues.size(); 
				for(int a=0; a<allValuesSize; a++)
				{
					String value = allValues.get(a).toString();
					int vCIdx =  value.indexOf(vCenterParam);
					if (vCIdx != -1)
					{
						String vCname =  value.substring(vCIdx+vCParamLen).trim();
						vCname = vCname.substring(0,vCname.indexOf(" ")).trim();
						if (vCname.trim().equalsIgnoreCase("none"))
							continue;
						String esxname = allVars[a];
						if (esxname.endsWith(":NULL"))
						{
							esxname = esxname.substring(0,esxname.indexOf(":NULL"));
						}
						esxname = esxname.substring(esxname.lastIndexOf(":")+1);
						//vcEsxMap
						if (vcEsxMap.containsKey(vCname))
						{
							ArrayList exsList = (ArrayList)vcEsxMap.get(vCname);
							if (!exsList.contains(esxname))
							{
								exsList.add(esxname);
							}
							vcEsxMap.put(vCname,exsList);
						}
						else
						{
							ArrayList exsList = new ArrayList();
							exsList.add(esxname);
							vcEsxMap.put(vCname,exsList);
						}

						//vCRmtAgentMap
						if (vCRmtAgentMap.containsKey(vCname))
						{
							ArrayList rmtList = (ArrayList)vCRmtAgentMap.get(vCname);
							if (!rmtList.contains(rmtAgent))
							{
								rmtList.add(rmtAgent);
							}
							vCRmtAgentMap.put(vCname,rmtList);
						}
						else
						{
							ArrayList rmtList = new ArrayList();
							rmtList.add(rmtAgent);
							vCRmtAgentMap.put(vCname,rmtList);
						}						
					}
				}
			}
		}
		// vcRemEsxMap > vCName={remEsxMap}
		// remEsxMap > remoteAgent= Esx1,Esx2,... // Esx hosts (below this vCenter) managed by this remote agent
		HashMap vcRemEsxMap = new HashMap();
		Iterator it = vcEsxMap.keySet().iterator();
		while(it.hasNext())
		{
			String vc = it.next().toString();
			ArrayList esxList = (ArrayList)vcEsxMap.get(vc);
			HashMap remEsxMap = new HashMap();
			for (int e=0; e<esxList.size(); e++)
			{
				String esx = (String)esxList.get(e);
				String rem = ext.getRemoteAgentForHost(esx);
				if (remEsxMap.containsKey(rem))
				{
					ArrayList tmpEsxList = (ArrayList)remEsxMap.get(rem);
					if (!tmpEsxList.contains(esx))
					{
						tmpEsxList.add(esx);
						remEsxMap.put(rem,tmpEsxList);
					}
				}
				else
				{
					ArrayList tmpEsxList = new ArrayList();
					tmpEsxList.add(esx);
					remEsxMap.put(rem,tmpEsxList);
				}				
			}
			vcRemEsxMap.put(vc,remEsxMap);
		}
		
		ArrayList result = new ArrayList();
		result.add(vcEsxMap);
		result.add(vCRmtAgentMap);
		result.add(vcRemEsxMap);
		
		return result;	
	}
%>

<%
	JSONObject rootObj = new JSONObject();
	JSONObject hiddenFields = new JSONObject();
	JSONObject generalSettings = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);
	String refferalURL = request.getParameter("refferalURL");
	String showModify = request.getParameter("showModify");
	String actionType = request.getParameter("actionType");
	String platform = request.getParameter("platform");
	String frmLocation = request.getParameter("frmLocation");
	String discovery_state = "";
	String prev_rediscoverDeleteComponent = "";
	String prev_snmpEngineID = "";
	String DiscoverySNMPVersion = "";
	String prev_dataOverTcp = "";
	discovery_state = (String) session.getValue("discovery_state");
	String isRedirected = request.getParameter("isRedirected");
	if (actionType == null || actionType.equalsIgnoreCase("null"))
	{
		actionType = "";
	}
	String virtualType = (String)request.getParameter("virtualType");
	if (virtualType == null)
	{
		virtualType = "vCenters";
	}

	String selectedNode = request.getParameter("selectedNode");
	if (selectedNode == null || selectedNode.equals("null") || selectedNode.length() == 0)
	{
		selectedNode = "node1";
	}

	String eg_inifile = "eg_ui.ini";
	String egUIDir = EgInstallInfo.getInstallDir() + "/manager/config/";
	String updateValue = request.getParameter("updateValue");
	if (updateValue != null && updateValue.equalsIgnoreCase("yes"))
	{
		String discovery_val = request.getParameter("discovery_val");
		IniFile discoveryIniFileWr = null;
		discoveryIniFileWr = EgConfigFilesSync.getInstance(egUIDir + eg_inifile,true);
		discoveryIniFileWr.setValue("EASE_OF_USE","managerDiscovery",discovery_val);
		discoveryIniFileWr.saveFile();
		EgConfigFilesSync.releaseInstance(discoveryIniFileWr);
		
		IniFile serviceIni = EgConfigFilesSync.getInstance(egUIDir + "eg_services.ini");
		if (discovery_val != null)
		{
			if (discovery_val.toLowerCase().equals("disabled"))
			{
				serviceIni.setValue("MISC_ARGS","Rediscoveryperiod","0");
			}
			else
			{
				serviceIni.setValue("MISC_ARGS","Rediscoveryperiod","60");
			}
			serviceIni.saveFile();
		}
		EgConfigFilesSync.releaseInstance(serviceIni);
	}
	IniFile discoveryUI = new IniFile(egUIDir + eg_inifile);
	String managerDiscovery = discoveryUI.getValue("EASE_OF_USE","managerDiscovery");
	if (managerDiscovery == null || managerDiscovery.length() == 0)
	{
		managerDiscovery = "enabled";
	}
	if (managerDiscovery.equalsIgnoreCase("enabled") || managerDiscovery.equalsIgnoreCase("enable"))
	{
		rootObj.put("ManagerDiscovery","Enabled");
	}
	else
	{
		rootObj.put("ManagerDiscovery","Disabled");
	}

	//String envIPRange = EgIPv4Range.getIPv4Range();
	String envIPRange = EgIPAddressStack.fetchLocalIPRange();
	if (envIPRange == null) envIPRange = "";
	rootObj.put("EgIPAddressStack",envIPRange);

	String discBase,periodIndex,discTimeoutIndex,icmpfordiscovery,selectedDiscCompCase;
	DiscBean.createAdmin();
	discBase = DiscBean.getDiscBase();
	selectedDiscCompCase = DiscBean.getDiscoverComponentCase();
	periodIndex = DiscBean.getRdperiod();
	String autoManageStr = DiscBean.getAutomanage();
	String thisIsDHCP = DiscBean.getDHCPInfo();
	
	String patternType = "";
	String wildcardPattern = "";
	//String needFQDN = DiscBean.getFQDNInfo();
	if(periodIndex.equals("0"))
	{
		generalSettings.put("selectedPeriodIndex","0");
	}
	else if (periodIndex.equals("30"))
	{
		generalSettings.put("selectedPeriodIndex","30");
	}
	else if (periodIndex.equals("60"))
	{
		generalSettings.put("selectedPeriodIndex","60");
	}
	else if (periodIndex.equals("180"))
	{
		generalSettings.put("selectedPeriodIndex","180");
	}
	else if (periodIndex.equals("360"))
	{
		generalSettings.put("selectedPeriodIndex","360");
	}
	else if (periodIndex.equals("1440"))
	{
		generalSettings.put("selectedPeriodIndex","1440");
	}
	else if (periodIndex.equals("10080"))
	{
		generalSettings.put("selectedPeriodIndex","10080");
	}

	discTimeoutIndex = DiscBean.getdiscTimeout();
	int discovery_timeout = 250;
	if(discTimeoutIndex !=null && discTimeoutIndex.length() > 0){
		try{
			discovery_timeout = Integer.parseInt(discTimeoutIndex);
		}
		catch(Exception e){
			discovery_timeout = 250;
		}
	}
	icmpfordiscovery = DiscBean.getIcmpForDiscovery();
	String from="";
	from=request.getParameter("from");
	if (from == null) from = "";

	String sub = "";
	if ( from != null && from.startsWith("hmc"))
		sub = "HMC";
	else if (from != null && from.startsWith("cloud"))
		sub = "PUBLIC_CLOUDS";
	else if (from != null && from.startsWith("nutanix"))
		sub = "NUTANIX";
	else 
		sub = "VIRTUAL_CENTER";
	String uiFile = "eg_services.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	IniFile testIniFile = new IniFile(s_iniFile_dir + uiFile);
	String memory=testIniFile.getValue("EXEC","VcDiscover_Mem");
	if(memory!=""&&memory.length()>0)
	memory = memory.substring(0,memory.indexOf("M"));
	else
	memory="";

	//String[] allValues = testIniFile.getLinesUnderSubject(sub);
	String[] allValues = new String[0];
	Vector vecTemp = testIniFile.getAllValues(sub);
	if (vecTemp != null && !vecTemp.isEmpty())
	{
		allValues = (String[])vecTemp.toArray(allValues);
	}
	String[] allVCs = testIniFile.getVariables(sub);

	String un = "";
	String pw = "";
	String hn = "";
	String ssl = "";
	String isdis = "";
	String ip="";
	String isSsl="";
	String isDiscovery="";
	String uName="";
	String uPass="";
	String webPort = "";
	String hName = "";
	String account = "";
	String mgrtype = "false";
	//String srvType= "";
	//String serverType= "";
	Hashtable allData = new Hashtable();

	if (!from.equalsIgnoreCase("changeSettings"))
	{
		JSONArray virtualTypesArr = new JSONArray();
		JSONObject virtualTypesObj= new JSONObject();
		JSONArray actionsArr = new JSONArray();
		JSONObject actionsObj = new JSONObject();

		virtualTypesObj.put("displayField",_mapping.getTextDescription("admin.discovery.vSphere/ESX Hosts"));
		virtualTypesObj.put("valueField","vCenters");
		virtualTypesArr.add(virtualTypesObj);
		virtualTypesObj= new JSONObject();

		virtualTypesObj.put("displayField",_mapping.getTextDescription("admin.discovery.pSeries Servers"));
		virtualTypesObj.put("valueField","HMCs");
		virtualTypesArr.add(virtualTypesObj);
		virtualTypesObj= new JSONObject();

		virtualTypesObj.put("displayField",_mapping.getTextDescription("admin.discovery.RHEV Hypervisors"));
		virtualTypesObj.put("valueField","RHEV");
		virtualTypesArr.add(virtualTypesObj);
		virtualTypesObj= new JSONObject();

		virtualTypesObj.put("displayField",_mapping.getTextDescription("admin.discovery.Nutanix Infrastructure")); 
		virtualTypesObj.put("valueField","Nutanix");
		virtualTypesArr.add(virtualTypesObj);
		virtualTypesObj= new JSONObject();

		virtualTypesObj.put("displayField",_mapping.getTextDescription("admin.discovery.Citrix XenServers")); 
		virtualTypesObj.put("valueField","CtxXenPool");
		virtualTypesArr.add(virtualTypesObj);
		virtualTypesObj= new JSONObject();
		
		virtualTypesObj.put("displayField",_mapping.getTextDescription("admin.discovery.Oracle VM Manager")); 
		virtualTypesObj.put("valueField","OracleVM");
		virtualTypesArr.add(virtualTypesObj);
		virtualTypesObj= new JSONObject();

		rootObj.put("virtualCategory",virtualTypesArr);

		JSONArray mapVirtualServersArr = new JSONArray();
		JSONObject mapVirtualServers = new JSONObject();
		//if (virtualType.equalsIgnoreCase("vCenters"))
		{
			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.View configured vCenters"));
			mapVirtualServers.put("valueField","View");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Add new vCenter"));
			mapVirtualServers.put("valueField","Add");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Modify configured vCenters"));
			mapVirtualServers.put("valueField","Modify");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Delete configured vCenters"));
			mapVirtualServers.put("valueField","Delete");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Configure memory settings for discovery"));
			mapVirtualServers.put("valueField","Configure");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.View remote agents mapping"));
			mapVirtualServers.put("valueField","RemoteAgent");
			mapVirtualServersArr.add(mapVirtualServers);


			rootObj.put("vCenters",mapVirtualServersArr);
		}
		//else if (virtualType.equalsIgnoreCase("HMCs"))
		{
			mapVirtualServersArr = new JSONArray();
			mapVirtualServers = new JSONObject();
			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.View configured HMCs"));
			mapVirtualServers.put("valueField","View");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Add new HMC"));
			mapVirtualServers.put("valueField","Add");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Modify configured HMCs"));
			mapVirtualServers.put("valueField","Modify");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Delete configured HMCs"));
			mapVirtualServers.put("valueField","Delete");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();
			rootObj.put("HMCs",mapVirtualServersArr);
		}
		//else if (virtualType.equalsIgnoreCase("RHEV"))
		{
			mapVirtualServersArr = new JSONArray();
			mapVirtualServers = new JSONObject();
			
			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.View configured RHEV managers"));
			mapVirtualServers.put("valueField","View");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Add new RHEV manager"));
			mapVirtualServers.put("valueField","Add");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Modify configured RHEV managers"));
			mapVirtualServers.put("valueField","Modify");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Delete configured RHEV managers"));
			mapVirtualServers.put("valueField","Delete");
			mapVirtualServersArr.add(mapVirtualServers);
			rootObj.put("RHEV",mapVirtualServersArr);
		}
		//else if (virtualType.equalsIgnoreCase("NUTANIX"))
		{
			mapVirtualServersArr = new JSONArray();
			mapVirtualServers = new JSONObject();
			
			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.View Nutanix Prism Manager"));
			mapVirtualServers.put("valueField","View");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Add Nutanix Prism Manager"));
			mapVirtualServers.put("valueField","Add");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Modify Nutanix Prism Manager"));
			mapVirtualServers.put("valueField","Modify");
			mapVirtualServersArr.add(mapVirtualServers);
			mapVirtualServers = new JSONObject();

			mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Delete Nutanix Prism Manager"));
			mapVirtualServers.put("valueField","Delete");
			mapVirtualServersArr.add(mapVirtualServers);
			rootObj.put("NUTANIX",mapVirtualServersArr);
		}

		//Citrix XenServer/VDI via Citrix Xen Server Pool
		mapVirtualServersArr = new JSONArray();
		mapVirtualServers = new JSONObject();
		
		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.View configured Citrix XenServers"));
		mapVirtualServers.put("valueField","View");
		mapVirtualServersArr.add(mapVirtualServers);
		mapVirtualServers = new JSONObject();

		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Add new Citrix XenServer"));
		mapVirtualServers.put("valueField","Add");
		mapVirtualServersArr.add(mapVirtualServers);
		mapVirtualServers = new JSONObject();

		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Modify configured Citrix XenServers"));
		mapVirtualServers.put("valueField","Modify");
		mapVirtualServersArr.add(mapVirtualServers);
		mapVirtualServers = new JSONObject();

		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Delete configured Citrix XenServers"));
		mapVirtualServers.put("valueField","Delete");
		mapVirtualServersArr.add(mapVirtualServers);
		rootObj.put("CtxXenPool",mapVirtualServersArr);
		
		//Oracle VM Manager
		mapVirtualServersArr = new JSONArray();
		mapVirtualServers = new JSONObject();
		
		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.View configured Oracle VM Managers"));
		mapVirtualServers.put("valueField","View");
		mapVirtualServersArr.add(mapVirtualServers);
		mapVirtualServers = new JSONObject();

		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Add new Oracle VM Manager"));
		mapVirtualServers.put("valueField","Add");
		mapVirtualServersArr.add(mapVirtualServers);
		mapVirtualServers = new JSONObject();

		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Modify configured Oracle VM Manager"));
		mapVirtualServers.put("valueField","Modify");
		mapVirtualServersArr.add(mapVirtualServers);
		mapVirtualServers = new JSONObject();

		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Delete configured Oracle VM Managers"));
		mapVirtualServers.put("valueField","Delete");
		mapVirtualServersArr.add(mapVirtualServers);
		rootObj.put("OracleVM",mapVirtualServersArr);


		//if (virtualType.equalsIgnoreCase("vCenters"))
		//{
			JSONObject vCenterLabels = new JSONObject();
			vCenterLabels.put("ipAdd",_mapping.getTextDescription("admin.discovery.vCenter identity (IP or Host name)"));
			vCenterLabels.put("ipModify",_mapping.getTextDescription("admin.discovery.vCenter identity (IP or Host name)"));
			vCenterLabels.put("ssl",_mapping.getTextDescription("admin.discovery.Use SSL to connect to vCenter"));
			vCenterLabels.put("webport",_mapping.getTextDescription("admin.discovery.Web Port"));
			vCenterLabels.put("isDiscovery",_mapping.getTextDescription("admin.discovery.Discover ESX hosts using this vCenter"));
			vCenterLabels.put("uname",_mapping.getTextDescription("admin.discovery.Username to connect to vCenter"));
			vCenterLabels.put("pass",_mapping.getTextDescription("admin.discovery.Password for the user"));
			vCenterLabels.put("confpasswd",_mapping.getTextDescription("admin.discovery.Confirm password for the user"));
			rootObj.put("vCenterLabels",vCenterLabels);
		//}
		//else if (virtualType.equalsIgnoreCase("HMCs"))
		//{
			JSONObject HMCLabels = new JSONObject();
			HMCLabels.put("ipAdd",_mapping.getTextDescription("admin.discovery.IP address of Hardware management console"));
			HMCLabels.put("ipModify",_mapping.getTextDescription("admin.discovery.IP address of Hardware management console"));
			HMCLabels.put("hName",_mapping.getTextDescription("admin.discovery.Host Name of Hardware management console"));
			HMCLabels.put("ssl",_mapping.getTextDescription("admin.discovery.Use SSL to connect to HMC"));
			HMCLabels.put("isDiscovery",_mapping.getTextDescription("admin.discovery.Discover pSeries servers using this HMC"));
			HMCLabels.put("uname",_mapping.getTextDescription("admin.discovery.Username to connect to HMC")+" ( i.e hscroot )");
			HMCLabels.put("pass",_mapping.getTextDescription("admin.discovery.Password for the user"));
			HMCLabels.put("confpasswd",_mapping.getTextDescription("admin.discovery.Confirm password for the user"));
			rootObj.put("HMCLabels",HMCLabels);
		//}
		//else if ()
		//{
			JSONObject nutanixLabels = new JSONObject();
			nutanixLabels.put("ipAdd",_mapping.getTextDescription("admin.discovery.Nutanix Prism Manager identity (IP or Host Name)"));
			nutanixLabels.put("ipModify",_mapping.getTextDescription("admin.discovery.Nutanix Prism Manager identity (IP or Host Name)"));			
			nutanixLabels.put("ssl",_mapping.getTextDescription("admin.discovery.Use SSL to connect to Nutanix Prism Manager"));
			nutanixLabels.put("webport",_mapping.getTextDescription("admin.discovery.Web Port"));
			nutanixLabels.put("mgrtype",_mapping.getTextDescription("admin.discovery.Nutanix Prism Manager type"));
			nutanixLabels.put("isDiscovery",_mapping.getTextDescription("admin.discovery.Discover Hypervisors"));
			nutanixLabels.put("uname",_mapping.getTextDescription("admin.discovery.Username to connect to Nutanix Prism Manager"));
			nutanixLabels.put("pass",_mapping.getTextDescription("admin.discovery.Password for the user"));
			nutanixLabels.put("confpasswd",_mapping.getTextDescription("admin.discovery.Confirm password for the user"));
			/*nutanixLabels.put("hName",_mapping.getTextDescription("admin.discovery.Host Name of Nutanix Prism"));*/
			rootObj.put("nutanixLabels",nutanixLabels);
		//}

		JSONArray esxSSLFactory = new JSONArray();
		JSONObject esxSSL = new JSONObject();
		esxSSL.put("displayField",_mapping.getTextDescription("admin.discovery.Yes"));
		esxSSL.put("valueField","True");
		esxSSLFactory.add(esxSSL);

		esxSSL = new JSONObject();
		esxSSL.put("displayField",_mapping.getTextDescription("admin.discovery.No"));
		esxSSL.put("valueField","False");
		esxSSLFactory.add(esxSSL);

		JSONArray isDiscoveryArr = new JSONArray();
		JSONObject isDiscoveryObj = new JSONObject();
		isDiscoveryObj.put("displayField",_mapping.getTextDescription("admin.discovery.Yes"));
		isDiscoveryObj.put("valueField",_mapping.getTextDescription("admin.discovery.Yes"));
		isDiscoveryArr.add(isDiscoveryObj);

		isDiscoveryObj = new JSONObject();
		isDiscoveryObj.put("displayField",_mapping.getTextDescription("admin.discovery.No"));
		isDiscoveryObj.put("valueField",_mapping.getTextDescription("admin.discovery.No"));
		isDiscoveryArr.add(isDiscoveryObj);

		/*JSONArray serverTypeArr = new JSONArray();
		JSONObject serverTypeObj = new JSONObject();
		serverTypeObj.put("displayField",_mapping.getTextDescription("admin.discovery.Desktop VMs"));
		serverTypeObj.put("valueField","DesktopVMs");
		serverTypeArr.add(serverTypeObj);

		serverTypeObj = new JSONObject();
		serverTypeObj.put("displayField",_mapping.getTextDescription("admin.discovery.Server VMs"));
		serverTypeObj.put("valueField","ServerVMs");
		serverTypeArr.add(serverTypeObj);

		serverTypeObj = new JSONObject();
		serverTypeObj.put("displayField",_mapping.getTextDescription("admin.discovery.Desktop and Server VMs"));
		serverTypeObj.put("valueField","DesktopandServer");
		serverTypeArr.add(serverTypeObj);*/
		rootObj.put("SSLTemplate",esxSSLFactory);
		rootObj.put("DiscoveryTemplate",isDiscoveryArr);
		//rootObj.put("ServerTypeTemplate",serverTypeArr);

		mapVirtualServersArr = new JSONArray();
		mapVirtualServers = new JSONObject();
		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.View configured AWS Clouds"));
		mapVirtualServers.put("valueField","VIEWCLOUD");
		mapVirtualServersArr.add(mapVirtualServers);
		mapVirtualServers = new JSONObject();

		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Add new AWS Cloud"));
		mapVirtualServers.put("valueField","ADDCLOUD");
		mapVirtualServersArr.add(mapVirtualServers);
		mapVirtualServers = new JSONObject();

		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Modify configured AWS Clouds"));
		mapVirtualServers.put("valueField","MODIFYCLOUD");
		mapVirtualServersArr.add(mapVirtualServers);
		mapVirtualServers = new JSONObject();

		mapVirtualServers.put("displayField",_mapping.getTextDescription("admin.discovery.Delete configured AWS Clouds"));
		mapVirtualServers.put("valueField","DELETECLOUD");
		mapVirtualServersArr.add(mapVirtualServers);
		rootObj.put("publicClouds",mapVirtualServersArr);

		JSONObject fieldLabels = new JSONObject();
		fieldLabels.put("accountAdd",_mapping.getTextDescription("admin.discovery.AWS Cloud account name"));
		fieldLabels.put("accountModify",_mapping.getTextDescription("admin.discovery.AWS Cloud account name"));
		fieldLabels.put("isDiscovery",_mapping.getTextDescription("admin.discovery.Discover AWS Cloud regions"));
		fieldLabels.put("accessKey",_mapping.getTextDescription("admin.discovery.Access key to connect to AWS Cloud"));
		fieldLabels.put("confAccessKey",_mapping.getTextDescription("admin.discovery.Confirm access key to connect to AWS Cloud"));
		fieldLabels.put("secretKey",_mapping.getTextDescription("admin.discovery.Secret key to connect to AWS Cloud"));
		fieldLabels.put("confSecretKey",_mapping.getTextDescription("admin.discovery.Confirm secret key to connect to AWS Cloud"));
		rootObj.put("cloudLabels",fieldLabels);
	}

	if(from.equals("add")||from.equals("delete")||from.equals("modify") || from.equals("view")||from.equals("hmcAdd")||from.equals("hmcDelete")||from.equals("hmcModify") || from.equals("hmcView")||from.equals("nutanixAdd")||from.equals("nutanixDelete")||from.equals("nutanixModify") || from.equals("nutanixView"))
	{
		ip = request.getParameter("ipAdd");
		StringTokenizer st = null;
		StringTokenizer st1 = null;
		//Hashtable allData = new Hashtable();

		if(allValues!=null&&allValues.length>0)
		{
			for(int i=0;i<allValues.length;i++)
			{
				String str = allValues[i];
				if (str == null || str.trim().length() == 0)
				{
					continue;
				}
				//st = new StringTokenizer(str,"=");
				//String s1 = st.nextToken();
				//String s2 = st.nextToken();
				ArrayList content = new ArrayList();
				//if(s2!=null)
				//{
					//st1 = new StringTokenizer(s2,"#");
				st1 = new StringTokenizer(str,"#");

				if (from.startsWith("nutanix"))
				{
					int count = st1.countTokens();
					if (st1.hasMoreTokens())
					{
						ssl = st1.nextToken();
						un = st1.nextToken();
						pw = st1.nextToken();
						isdis = st1.nextToken();
						webPort = st1.nextToken();

						if (count == 6)
						{
							mgrtype =  st1.nextToken();
						}

					}
				}
				else
				{
					if (st1.hasMoreTokens() && st1.countTokens() == 5)
					{
						ssl = st1.nextToken();
						un = st1.nextToken();
						pw = st1.nextToken();
						isdis = st1.nextToken();
						if(from.startsWith("hmc"))
							hn = st1.nextToken();
						else
							webPort = st1.nextToken();
						//if(from.startsWith("modify") || from.equals("view") || from.equals("delete"))
							//srvType = st1.nextToken();
					}
				}
				//}
				pw = EgCrypt.decrypt(pw);
				content.add(ssl);
				content.add(isdis);
				content.add(un);
				content.add(pw);
				if(from.startsWith("hmc"))
				{
					content.add(hn);
				}
				else
				{
					content.add(webPort);
				}

				if (from.startsWith("nutanix"))
				{
					content.add(mgrtype);
				}
				//if(from.startsWith("modify") || from.equals("view") || from.equals("delete"))
					//content.add(srvType);				
				//allData.put(s1,content);
				allData.put(allVCs[i],content);
			}
		}

		if(ip!=null&&!from.equals("add") && !from.equals("hmcAdd") && !from.equals("nutanixAdd") )
		{
			ArrayList content = (ArrayList)allData.get(ip);
			if(from.startsWith("hmc"))
			{
				isSsl=(String)content.get(0);
				isDiscovery=(String)content.get(1);
				uName=(String)content.get(2);
				uPass=(String)content.get(3);
				hName = (String)content.get(4);
			}
			/*else if(from.startsWith("modify"))
			{
				isSsl=(String)content.get(0);
				isDiscovery=(String)content.get(1);
				uName=(String)content.get(2);
				uPass=(String)content.get(3);
				webPort = (String)content.get(4);
				serverType = (String)content.get(5);
			}*/
			else
			{
				isSsl=(String)content.get(0);
				isDiscovery=(String)content.get(1);
				uName=(String)content.get(2);
				uPass=(String)content.get(3);
				webPort = (String)content.get(4);
				if (content.size() > 5)
				{
					mgrtype = (String)content.get(5);
				}
			}
		}
	}
	else if (from.startsWith("cloud"))//Added by karthika 
	{
		account=request.getParameter("account");
		StringTokenizer st = null;
		StringTokenizer st1 = null;
		//Hashtable allData = new Hashtable();
		
		if(allValues!=null&&allValues.length>0)
		{
			for(int i=0;i<allValues.length;i++)
			{
				String str = allValues[i];
				if (str == null || str.trim().length() == 0)
				{
					continue;
				}
				//st = new StringTokenizer(str,"=");
				//String s1 = st.nextToken();
				//String s2 = st.nextToken();
				ArrayList content = new ArrayList();
				//if(s2!=null)
				//{
					//st1 = new StringTokenizer(s2,"#");
					st1 = new StringTokenizer(str,"#");
					if (st1.hasMoreTokens() && st1.countTokens() == 3)
					{
						un = st1.nextToken();
						pw = st1.nextToken();
						isdis = st1.nextToken();
					}
				//}
				un = EgCrypt.decrypt(un);
				pw = EgCrypt.decrypt(pw);
				content.add(un);
				content.add(pw);
				content.add(isdis);
				//allData.put(s1,content);
				allData.put(allVCs[i],content);
			}
		}
		

		if(account!=null)
		{
			ArrayList content = (ArrayList)allData.get(account);
			uName=(String)content.get(0);
			uPass=(String)content.get(1);
			isDiscovery=(String)content.get(2);
		}
	}//cloud ends here
//	if (uPass != null && uPass.length() > 0)
//	{
//		uPass = StringUtils.replace(uPass,"\"","&#34;");
//	}

	String[] ip_sec=DiscBean.getIpranges();
	StringBuffer IPBuffer = new StringBuffer(ip_sec.length*30);
	if(ip_sec.length > 2)
	{
		for(int x=1;x<ip_sec.length;x++)
		{
			IPBuffer.append(ip_sec[x].trim());
			IPBuffer.append(",");
		}
	}
	else if(ip_sec.length > 1)
	{
		IPBuffer.append(ip_sec[1].trim());
	}

	IniFile infraPtr = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
	String DiscOptions = request.getParameter("DiscOptions");
	String server_manage_types[] = request.getParameterValues("ServerDisplay");
	String automanage_srvr_types[] = request.getParameterValues("AutomanageSrvrDisplay");
	String loadCount = request.getParameter("LoadCount");
	
	if(DiscOptions==null || DiscOptions.length()==0) DiscOptions = "all";	
	String categoryOptions="";
	StringBuffer categoryBuff = new StringBuffer();
	StringTokenizer stz = new StringTokenizer(DiscOptions,",");
	while(stz.hasMoreTokens())
	{
		String tok = stz.nextToken();
		if(tok.equalsIgnoreCase("all"))
		{
			DiscOptions = "all";
			break;
		}
	}
	if(DiscOptions.equalsIgnoreCase("all"))
	{
		String[] categVar = infraPtr.getSubjects();
		if(categVar!=null && categVar.length>0)
		{
			for(int i=0;i<categVar.length;i++)
			{
				String var = (String)categVar[i];
				categoryBuff.append(var);
				categoryBuff.append(",");
			}
		}
		categoryBuff.append("OTHERS");
		categoryOptions = categoryBuff.toString();
	}
	else categoryOptions = DiscOptions;

	String cfgIP = IPBuffer.toString().trim();
	if (from.equals("changeSettings") || 
		from.equals("changePorts") || 
		from.equals("changeSnmp") || 
		from.equals("memory") || 
		from.equals("commonSettings"))
	{
		boolean isActivePortEnabled = false;
		ArrayList srvTypeList = new ArrayList();
		ArrayList nonActvSrvTypeList = new ArrayList();
		ArrayList portList = new ArrayList();
		configTopo.createFile("eg_services.ini");
		if(from.equals("changePorts") || from.equals("commonSettings"))
		{
			String activePort = request.getParameter("activePorts");
			if(activePort != null && activePort.equalsIgnoreCase("true"))
			{
				isActivePortEnabled = true;
			}
		}
		String[] servers = configTopo.getVariables("DISCOVERY_SPECIFICATION");

		if (servers != null)
		{
			for (int i=0; i<servers.length; i++)
			{
				String varServer = servers[i];
				if (varServer.startsWith("Format:"))
				{
					continue;
				}
				String val = configTopo.getValues("DISCOVERY_SPECIFICATION", varServer);
				val = val.toLowerCase();
				if (val.startsWith("nodiscovery,") || val.endsWith("-port null"))
				{
					continue;
				}
				if (varServer.startsWith("#"))
				{
					varServer = varServer.substring(1);
					if(isActivePortEnabled)
					{
						nonActvSrvTypeList.add(varServer);
					}
				}
				srvTypeList.add(varServer);

				String tmpPort = val.substring(val.indexOf("-port")+5).trim();
				if (tmpPort.indexOf(":") > 0)
				{
					tmpPort = tmpPort.replace(':',',');
				}
				portList.add(tmpPort);
			}
		}

		port.createAdmin();
		String strCommunityStrings = port.getCommunityStrings();
		if(strCommunityStrings != null && strCommunityStrings.indexOf(":") >= 0)
		{
			strCommunityStrings = strCommunityStrings.replace(':',',');
		}


		ArrayList serverList = new ArrayList();
		
		String userLanguage = _user.getLanguage();
		IniUI  iniUI = IniUI.getInstance();
		if (userLanguage == null)
			userLanguage = iniUI.getDefaultLanguage();

		MappingNameSorter sorter = new MappingNameSorter(userLanguage);
		serverList = sorter.getSortedCompTypeList(srvTypeList);

		// Active Direcotry Subnets or manual IP range
		IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_authenticate.ini");
		String[] domains=iniFile.getSubjects();
		String useADDiscovery = "no";
		useADDiscovery = request.getParameter("useADDiscovery");
		String actDomain = request.getParameter("sDomain");
		String actSite = request.getParameter("sSite");
		String actSubnet = request.getParameter("sSubnet");
		if(useADDiscovery == null || useADDiscovery.length() == 0)
		{
			useADDiscovery = "no";
		}
		boolean isDomainConfigured = false;
		if(domains.length == 0)
		{
			isDomainConfigured = false;
		}
		else
		{
			isDomainConfigured = true;
		}
		boolean usingADDiscovery = (useADDiscovery.equals("yes"));

		// Finding IP ranges
		String[] ipranges=port.getIpranges();
		StringBuffer ipRange = new StringBuffer(ipranges.length*30);
		String range = null;
		String readOnly = "";

		if (!usingADDiscovery)
		{
			if(ipranges.length > 2)
			{
				for(int x=1;x<ipranges.length;x++)
				{
					ipRange.append(ipranges[x].trim());
					ipRange.append("\n");
				}
			}
			else if(ipranges.length > 1)
			{
				ipRange.append(ipranges[1].trim());
			}
			range = ipRange.toString().trim();
		}
		else
		{
			range = "";
			readOnly = "readonly";
		}
		// To remove the aggregate comp types from the servers List
		EgAggregateInfo aggInfo = new EgAggregateInfo("manager");
		Vector aggTypes = aggInfo.getAggregateTypes();
		aggInfo = null;

		String[] server_types = port.getAllValidServerTypesForDiscovery();//port.getValidServerTypesForDiscovery();
		String[] server_types_automanage = port.getDiscServerTypesForAutomanage();

		ArrayList compList = new ArrayList();
		ArrayList server_list = new ArrayList();
		ArrayList server_list_disp = new ArrayList();
		ArrayList automanage_server_list = new ArrayList();
		ArrayList manageSrvrListShow = new ArrayList();
		ArrayList automanageSrvrListShow = new ArrayList();

		if(categoryOptions!=null)
		{
			categoryOptions = categoryOptions.trim();
			StringTokenizer st = new StringTokenizer(categoryOptions,",");
			while(st.hasMoreTokens())
			{
				String token = (String)st.nextToken();
				String[] filteredServerTypes= getServerTypesBasedOnPriority(token,server_types,infraPtr);
				String[] filteredAutomanageSrvTypes= getServerTypesBasedOnPriority(token,server_types_automanage,infraPtr); //for automanage components
				for(int j=0;j<filteredServerTypes.length;j++)
				{
					if(filteredServerTypes[j] == null) continue;
					if(filteredServerTypes[j].startsWith("#"))
					{
						compList.add(filteredServerTypes[j].substring(1));
					}
					else
					{
						compList.add(filteredServerTypes[j]);
						server_list.add(filteredServerTypes[j]);
						server_list_disp.add(filteredServerTypes[j]);
					}
				}
				/* New Feed on Nov-2016 by Meena.V
				 * To get automanage components
				 */
				for(int j=0;j<filteredAutomanageSrvTypes.length;j++)
				{
					String autoManageServ = filteredAutomanageSrvTypes[j];
					if(autoManageServ == null || autoManageServ.startsWith("#")) 
					{
						continue;
					}
					
					automanage_server_list.add(autoManageServ);
				}
				
				if (server_manage_types != null)
				{
					String[] filteredServerTypesShow= getServerTypesBasedOnPriority(token,server_manage_types,infraPtr);
					for(int j=0;j<filteredServerTypesShow.length;j++)
					{
						String servTypes = filteredServerTypesShow[j];
						if(servTypes == null || servTypes.startsWith("#")) 
						{
							continue;
						}

						manageSrvrListShow.add(servTypes);
					}
				}

				if (automanage_srvr_types != null)
				{
					String[] filteredAutomanageSrvrTypesShow= getServerTypesBasedOnPriority(token,automanage_srvr_types,infraPtr);
					for(int j=0;j<filteredAutomanageSrvrTypesShow.length;j++)
					{
						String automanageSrvTypes = filteredAutomanageSrvrTypesShow[j];
						if(automanageSrvTypes == null || automanageSrvTypes.startsWith("#")) 
						{
							continue;
						}

						automanageSrvrListShow.add(automanageSrvTypes);
					}
				}
			}
		}

		if(aggTypes != null && compList != null)
		{
			compList.removeAll(aggTypes);
		}
		hiddenFields.put("actionType",actionType);

		rootObj.put("from",from);
		if(from.equals("changeSettings"))
		{
			if (useADDiscovery.equals("yes"))
			{
				generalSettings.put("ADDiscovery","yes");
			}
			else
			{
				generalSettings.put("ADDiscovery","no");
			}

			JSONArray domainsList = new JSONArray();
			if(domains !=null )
			{
				JSONObject tmpObj = new JSONObject();
				tmpObj.put("displayField",_mapping.getTextDescription("admin.user.Choose a domain"));
				tmpObj.put("valueField","none");
				domainsList.add(tmpObj);
				for(int i=0;i<domains.length;i++)
				{
					tmpObj = new JSONObject();
					String domain = domains[i];
					tmpObj.put("displayField",domain);
					tmpObj.put("valueField",domain);
					domainsList.add(tmpObj);
					
				}
			}
			generalSettings.put("ADdomain",domainsList);
			JSONArray ADSite = new JSONArray();
			JSONObject ADSiteObj = new JSONObject();
			ADSiteObj.put("valueField","none");
			ADSiteObj.put("displayField",_mapping.getTextDescription("admin.user.Not Applicable"));
			ADSite.add(ADSiteObj);
			generalSettings.put("ADSite",ADSite);

			JSONArray ADSubnet = new JSONArray();
			JSONObject ADSubnetObj = new JSONObject();
			ADSubnetObj.put("valueField","none");
			ADSubnetObj.put("displayField",_mapping.getTextDescription("admin.user.Not Applicable"));
			ADSubnet.add(ADSubnetObj);
			generalSettings.put("ADSubnet",ADSubnet);

			generalSettings.put("iprange",range);
			JSONArray networkTypeArr = new JSONArray();
			JSONObject networkTypeObj = new JSONObject();
			networkTypeObj.put("displayField",_mapping.getTextDescription("admin.discovery.LAN"));
			networkTypeObj.put("valueField","250");
			networkTypeArr.add(networkTypeObj);

			networkTypeObj = new JSONObject();
			networkTypeObj.put("displayField",_mapping.getTextDescription("admin.discovery.WAN"));
			networkTypeObj.put("valueField","2000");
			networkTypeArr.add(networkTypeObj);
			generalSettings.put("disctimeout",networkTypeArr);
			if (discovery_timeout <= 250)
			{
				generalSettings.put("selectedDisctimeout","LAN");
			}
			else
			{
				generalSettings.put("selectedDisctimeout","WAN");
			}

			//for(int i=0;i<icmpoptions.length;i++)
			//{
				if(icmpoptions[0].equalsIgnoreCase(icmpfordiscovery))
				{
					generalSettings.put("icmp",icmpoptions[0]);
				}
				else
				{
					generalSettings.put("icmp",icmpoptions[1]);
				}
			//}

			JSONArray discoveryPeriodArr = new JSONArray();
			JSONObject re_period = new JSONObject();
			re_period.put("displayField","30 "+_mapping.getTextDescription("admin.common.Mins"));
			re_period.put("valueField","30");
			discoveryPeriodArr.add(re_period);
			re_period = new JSONObject();

			re_period.put("displayField","1 "+_mapping.getTextDescription("admin.common.Hour"));
			re_period.put("valueField","60");
			discoveryPeriodArr.add(re_period);
			re_period = new JSONObject();

			re_period.put("displayField","3 "+_mapping.getTextDescription("admin.common.Hours"));
			re_period.put("valueField","180");
			discoveryPeriodArr.add(re_period);
			re_period = new JSONObject();

			re_period.put("displayField","6 "+_mapping.getTextDescription("admin.common.Hours"));
			re_period.put("valueField","360");
			discoveryPeriodArr.add(re_period);
			re_period = new JSONObject();

			re_period.put("displayField","1 "+_mapping.getTextDescription("admin.common.Day"));
			re_period.put("valueField","1440");
			discoveryPeriodArr.add(re_period);
			re_period = new JSONObject();

			re_period.put("displayField","1 "+_mapping.getTextDescription("admin.common.Week"));
			re_period.put("valueField","10080");
			discoveryPeriodArr.add(re_period);
			re_period = new JSONObject();

			re_period.put("displayField",_mapping.getTextDescription("admin.common.None"));
			re_period.put("valueField","0");
			discoveryPeriodArr.add(re_period);
			re_period = new JSONObject();
			generalSettings.put("period",discoveryPeriodArr);

			//if(thisIsDHCP != null && thisIsDHCP.equalsIgnoreCase("yes"))
			//{
			//	generalSettings.put("dhcp","yes");
			//}
			//else
			//{
			//	generalSettings.put("dhcp","no");
			//}
			generalSettings.put("Community",strCommunityStrings);

			String  rediscoverDeletedComponents = testIniFile.getValue("MISC_ARGS","RediscoverDeletedComponents");
			if (rediscoverDeletedComponents == null || rediscoverDeletedComponents.length() == 0)
			{
				rediscoverDeletedComponents = "no";
			}
			if(rediscoverDeletedComponents == "No" || rediscoverDeletedComponents.equalsIgnoreCase("no"))
			{
				prev_rediscoverDeleteComponent = "No";
			}
			else
			{
				prev_rediscoverDeleteComponent = "Yes";
			}
			generalSettings.put("rediscoverDeletedComponents",rediscoverDeletedComponents);

			String  snmpEngineID = testIniFile.getValue("MISC_ARGS","SnmpEngineID");
			if (snmpEngineID == null || snmpEngineID.length() == 0)
			{
				snmpEngineID = "no";
			}
			if(snmpEngineID.equalsIgnoreCase("no"))
			{
				prev_snmpEngineID = "No";
			}
			else
			{
				prev_snmpEngineID = "Yes";
			}
			generalSettings.put("snmpEngineID",snmpEngineID);
			
			// snmpv3 properties starts
			DiscoverySNMPVersion = testIniFile.getValue("MISC_ARGS","DiscoverySNMPVersion");
			if (DiscoverySNMPVersion == null || DiscoverySNMPVersion.length() == 0)
			{
				DiscoverySNMPVersion = "v1";
			}
			generalSettings.put("DiscoverySNMPVersion",DiscoverySNMPVersion);
			String dataOverTcp = testIniFile.getValue("MISC_ARGS","DataOverTcp");
			if (dataOverTcp == null || dataOverTcp.length() == 0)
			{
				dataOverTcp = "no";
			}
			if(dataOverTcp == "No" || dataOverTcp.equalsIgnoreCase("no"))
			{
				prev_dataOverTcp = "No";
			}
			else
			{
				prev_dataOverTcp = "Yes";
			}
			generalSettings.put("dataOverTcp",dataOverTcp);
			if (DiscoverySNMPVersion.equalsIgnoreCase("v3"))
			{
				String snmpMgrContext = testIniFile.getValue("MISC_ARGS","SnmpMgrContext");
				String snmpUserName = testIniFile.getValue("MISC_ARGS","SnmpUserName");
				String SnmpUserPass = testIniFile.getValue("MISC_ARGS","SnmpUserPass");
				String snmpAuthType = testIniFile.getValue("MISC_ARGS","SnmpAuthType");
				String encType = testIniFile.getValue("MISC_ARGS","EncType");

				generalSettings.put("snmpMgrContext",snmpMgrContext);
				generalSettings.put("snmpUserName",snmpUserName);
				generalSettings.put("SnmpUserPass",EgCrypt.olddecrypt(SnmpUserPass));
				generalSettings.put("snmpAuthType",snmpAuthType);
				generalSettings.put("encType",encType);
				if (encType != null && encType.equalsIgnoreCase("yes"))
				{
					String snmpEncAuth = testIniFile.getValue("MISC_ARGS","SnmpEncAuth");
					String snmpEncPass = testIniFile.getValue("MISC_ARGS","SnmpEncPass");
					generalSettings.put("snmpEncAuth",snmpEncAuth);
					generalSettings.put("snmpEncPass",EgCrypt.olddecrypt(snmpEncPass));
				}
			}
			// snmpv3 properties ends
		}
		else if (from.equals("commonSettings") || from.equals("changePorts"))
		{
			JSONArray availSrvrArray = new JSONArray();
			if (selectedNode.equals("node10") || selectedNode.equals("common")) //Common Settings
			{
				if (server_list.size() == 0)
				{
					//server_list.addAll(compList);
				}

				ArrayList list = new ArrayList();
				JSONArray tmpList = new JSONArray();
				JSONObject tmpObject = new JSONObject();
				JSONObject availSrvrObj = new JSONObject();
				JSONArray allSrvrArray = new JSONArray();
				JSONArray discSrvrArray = new JSONArray();
				int colCount = 0;
				String tmpString = "";
				ArrayList cmpDiscoveryList = new ArrayList();

				server_list = sorter.getSortedCompTypeList(server_list);
				for (int i = 0;i<server_list.size();i++)
				{
					colCount++;
					EgName nameObj = (EgName)server_list.get(i);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					availSrvrObj.put("displayField",tmpDis);
					availSrvrObj.put("valueField",tmpVal);
					availSrvrArray.add(availSrvrObj);
					discSrvrArray.add(availSrvrObj);
					cmpDiscoveryList.add(tmpDis);
					
					if (colCount == 3)
					{
						tmpObject.put("col_"+colCount , tmpDis);
						tmpList.add(tmpObject);
						tmpObject = new JSONObject();
						colCount = 0;
					}
					else
					{
						tmpObject.put("col_"+colCount , tmpDis);
					}

					if (tmpString.equals(""))
					{
						tmpString = tmpVal;
					}
					else
					{
						tmpString = tmpString + "," + tmpVal;
					}
				}
				if (colCount == 1)
				{
					tmpObject.put("col_2","");
					tmpObject.put("col_3","");
					tmpList.add(tmpObject);
				}
				if (colCount == 2)
				{
					tmpObject.put("col_3","");
					tmpList.add(tmpObject);
				}

				generalSettings.put("compDiscList",cmpDiscoveryList);
				generalSettings.put("seletedServerList",tmpString);
				generalSettings.put("configuredServersList",tmpList);
				generalSettings.put("configuredServersCount",server_list.size());

				JSONObject serverCategory = new JSONObject();
				JSONArray serverCategoryArr = new JSONArray();
				generalSettings.put("isAllSelected",DiscOptions);

				serverCategory.put("displayField",_mapping.getTextDescription("admin.discovery.ALL"));
				serverCategory.put("valueField","all");
				serverCategoryArr.add(serverCategory);

				String[] servertypes=DiscBean.getAllValidServerTypesForDiscovery();//DiscBean.getValidServerTypesForDiscovery();
				ArrayList serverGrps = getAllServerGroups(servertypes);
				for(int i=0; i<serverGrps.size(); i++)
				{
					serverCategory = new JSONObject();
					String tmpServerGrp = (String)serverGrps.get(i);
					serverCategory.put("valueField",tmpServerGrp);
					serverCategory.put("displayField",getCapitalizedCategory(tmpServerGrp));
					serverCategoryArr.add(serverCategory);
				}
				generalSettings.put("serverCategoryArr",serverCategoryArr);
			
				JSONArray discBaseArr = new JSONArray();
				JSONObject discBaseObj = new JSONObject();
				discBaseObj.put("displayField",_mapping.getTextDescription("admin.discovery.IP address"));
				discBaseObj.put("valueField","IP");
				discBaseArr.add(discBaseObj);
				discBaseObj = new JSONObject();

				discBaseObj.put("displayField",_mapping.getTextDescription("admin.discovery.Host name"));
				discBaseObj.put("valueField","DNS");
				discBaseArr.add(discBaseObj);
				if (discBase.equalsIgnoreCase("IP"))
				{
					generalSettings.put("seletedDiscBase","IP");
				}
				else
				{
					generalSettings.put("seletedDiscBase","DNS");
				}
				generalSettings.put("discbase",discBaseArr);

				generalSettings.put("discCompUsingCase",selectedDiscCompCase);

				JSONArray portArr = new JSONArray();
				JSONArray gridPtn = new JSONArray();
				for(int k=0;k<serverList.size();k++)
				{
					JSONObject tmpPort = new JSONObject();
					EgName nameObj = (EgName)serverList.get(k);
					String tmpVal = nameObj.getActualName();	
					String tmpDis = nameObj.getLocalName();	
					int index = srvTypeList.indexOf(tmpVal);
					String portNo = (String)portList.get(index);
					tmpPort.put("displayField",tmpDis);
					tmpPort.put("valueField",tmpVal);
					tmpPort.put("port",portNo);
					portArr.add(tmpPort);
				}
				generalSettings.put("Port",portArr);

				int count = 0;
				compList = sorter.getSortedCompTypeList(compList);
				JSONArray serverTypesArr = new JSONArray();
				for (int i=0;i<compList.size();i++)
				{
					JSONObject tmServer = new JSONObject();
					EgName tmpServer = (EgName)compList.get(i);
					String actualName = (String)tmpServer.getActualName();
					String displayName = (String)tmpServer.getLocalName();
					tmServer.put("displayField",displayName);
					tmServer.put("valueField",actualName);
					serverTypesArr.add(tmServer);
				}
				
				generalSettings.put("c_types",serverTypesArr);

				JSONArray selectedSrvrTypesArr = new JSONArray();
				if (server_manage_types != null && server_manage_types.length > 0)
				{
					manageSrvrListShow = sorter.getSortedCompTypeList(manageSrvrListShow);
					JSONObject tempSrvr = new JSONObject();
					for(int m=0; m<manageSrvrListShow.size(); m++)
					{
						EgName nameObj1 = (EgName)manageSrvrListShow.get(m);
						String tmpVal1 = nameObj1.getActualName();
						String tmpDis1 = nameObj1.getLocalName();
						tempSrvr.put("displayField",tmpDis1);
						tempSrvr.put("valueField",tmpVal1);
						selectedSrvrTypesArr.add(tempSrvr);
					}
					generalSettings.put("discSrvrArray",selectedSrvrTypesArr);
					serverTypesArr.removeAll(selectedSrvrTypesArr);
				}
				else if (server_manage_types == null && loadCount != null)
				{
					if (loadCount.equalsIgnoreCase("0"))
					{
						generalSettings.put("discSrvrArray",discSrvrArray);
						serverTypesArr.removeAll(discSrvrArray);
					}
				}
				else
				{
					discSrvrArray.clear();
					generalSettings.put("discSrvrArray",discSrvrArray);
				}
				generalSettings.put("allSrvrArray",serverTypesArr);

				if(thisIsDHCP != null && (thisIsDHCP.equalsIgnoreCase("yes") || thisIsDHCP.equalsIgnoreCase("true")))
				{
					generalSettings.put("dhcp","yes");
				}
				else
				{
					generalSettings.put("dhcp","no");
				}

				hiddenFields.put("$_discBase",discBase);
				hiddenFields.put("$_discCompUsingCase",selectedDiscCompCase);
				hiddenFields.put("$_dhcpEnv",thisIsDHCP);
			}

			if (from.equals("changePorts") || selectedNode.equals("node17") || selectedNode.equals("commonTCP")) //TCP Ports
			{
				JSONArray portArr = new JSONArray();
				JSONArray allPortArr = new JSONArray();
				for(int k=0;k<serverList.size();k++)
				{
					JSONObject tmpPort = new JSONObject();
					EgName nameObj = (EgName)serverList.get(k);
					String tmpVal = nameObj.getActualName();	
					String tmpDis = nameObj.getLocalName();	
					int index = srvTypeList.indexOf(tmpVal);
					String portNo = (String)portList.get(index);
					tmpPort.put("displayField",tmpDis);
					tmpPort.put("valueField",tmpVal);
					tmpPort.put("port",portNo);
					allPortArr.add(tmpPort);
					if(isActivePortEnabled && !nonActvSrvTypeList.contains(tmpVal))
					{
						portArr.add(tmpPort);
					}
				}
				if(isActivePortEnabled)
				{
					generalSettings.put("Port",portArr);
				}
				else
				{
					generalSettings.put("Port",allPortArr);
				}
				generalSettings.put("AllPorts",allPortArr);
			}

			if (selectedNode.equals("node18") || selectedNode.equals("commonAutomanage")) //Auto-manage
			{
				//automanage option moved to common settings
				JSONObject availSrvrObj = new JSONObject();
				generalSettings.put("autoManageStr",autoManageStr);
				String discoveryIncludeOrExcludePatten = testIniFile.getValue("MISC_ARGS","DiscoveryIncludeOrExcludePatten");
				if (discoveryIncludeOrExcludePatten == null || discoveryIncludeOrExcludePatten.length() == 0)
				{
					discoveryIncludeOrExcludePatten = "";
					patternType = "Include";
					generalSettings.put("pattentype",patternType);
					generalSettings.put("wildcardpatten",wildcardPattern);
				}
				else
				{
					StringTokenizer pattens = new StringTokenizer(discoveryIncludeOrExcludePatten,"|$|");
					patternType = pattens.nextToken();
					generalSettings.put("pattentype",patternType);
					if (pattens.hasMoreTokens())
					{
						wildcardPattern = pattens.nextToken();
						generalSettings.put("wildcardpatten",wildcardPattern);
					}
					else
					{
						generalSettings.put("wildcardpatten",wildcardPattern);
					}
				}
				server_list = sorter.getSortedCompTypeList(server_list);
				for (int i = 0;i<server_list.size();i++)
				{
					EgName nameObj = (EgName)server_list.get(i);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					availSrvrObj.put("displayField",tmpDis);
					availSrvrObj.put("valueField",tmpVal);
					availSrvrArray.add(availSrvrObj);
				}
				/*
				 * New feed on Nov-2016 by Meena.V
				 * For automanage component view & selection during components discovery
				 */
				automanage_server_list = sorter.getSortedCompTypeList(automanage_server_list);
				JSONArray tmpAutomanageList = new JSONArray();
				JSONObject tmpAutomanageObject = new JSONObject();
				JSONObject automanageSrvrObj = new JSONObject();
				JSONArray automanageSrvrArray = new JSONArray();
				int col_Count = 0;
				String tmpAutomanageString = "";
				ArrayList cmpManageList = new ArrayList();
				for (int i = 0;i<automanage_server_list.size();i++)
				{
					col_Count++;
					EgName nameAutomanageObj = (EgName)automanage_server_list.get(i);
					String tmpAutomanageVal = nameAutomanageObj.getActualName();
					String tmpAutomanageDis = nameAutomanageObj.getLocalName();
					automanageSrvrObj.put("displayField",tmpAutomanageDis);
					automanageSrvrObj.put("valueField",tmpAutomanageVal);
					automanageSrvrArray.add(automanageSrvrObj);
					cmpManageList.add(tmpAutomanageDis);
					if (col_Count == 3)
					{
						tmpAutomanageObject.put("col_"+col_Count , tmpAutomanageDis);
						tmpAutomanageList.add(tmpAutomanageObject);
						tmpAutomanageObject = new JSONObject();
						col_Count = 0;
					}
					else
					{
						tmpAutomanageObject.put("col_"+col_Count , tmpAutomanageDis);
					}

					if (tmpAutomanageString.equals(""))
					{
						tmpAutomanageString = tmpAutomanageVal;
					}
					else
					{
						tmpAutomanageString = tmpAutomanageString + "," + tmpAutomanageVal;
					}
				}
				if (col_Count == 1)
				{
					tmpAutomanageObject.put("col_2","");
					tmpAutomanageObject.put("col_3","");
					tmpAutomanageList.add(tmpAutomanageObject);
				}
				if (col_Count == 2)
				{
					tmpAutomanageObject.put("col_3","");
					tmpAutomanageList.add(tmpAutomanageObject);
				}
				
				generalSettings.put("selectedAutomanageSrvrsList",tmpAutomanageString);
				generalSettings.put("configuredAutomanageSrvrList",tmpAutomanageList);
				generalSettings.put("configuredAutomanageSrvrsCount",automanage_server_list.size());
				generalSettings.put("cmpManageList",cmpManageList);

				JSONObject srvrCategory = new JSONObject();
				JSONArray srvrCategoryArr = new JSONArray();
				generalSettings.put("isAllSelected",DiscOptions);
				srvrCategory.put("displayField",_mapping.getTextDescription("admin.discovery.ALL"));
				srvrCategory.put("valueField","all");
				srvrCategoryArr.add(srvrCategory);

				String[] automanageServertypes = (String[])server_list_disp.toArray(new String[server_list_disp.size()]);
				ArrayList automanageServerGrps = getAllServerGroups(automanageServertypes);			
				for(int i=0; i<automanageServerGrps.size(); i++)
				{
					srvrCategory = new JSONObject();
					String tmpSrvrGrp = (String)automanageServerGrps.get(i);
					srvrCategory.put("valueField",tmpSrvrGrp);
					srvrCategory.put("displayField",getCapitalizedCategory(tmpSrvrGrp));
					srvrCategoryArr.add(srvrCategory);
				}
				generalSettings.put("srvrCategoryArr",srvrCategoryArr);

				server_list_disp = sorter.getSortedCompTypeList(server_list_disp);
				JSONArray srvrTypesArr = new JSONArray();
			
				for (int i=0;i<server_list_disp.size();i++)
				{
					JSONObject tmServer = new JSONObject();
					EgName tmpServer = (EgName)server_list_disp.get(i);				
					String actualName = (String)tmpServer.getActualName();
					String displayName = (String)tmpServer.getLocalName();
					tmServer.put("displayField",displayName);
					tmServer.put("valueField",actualName);
					srvrTypesArr.add(tmServer);
				}
				generalSettings.put("c_types2",srvrTypesArr);

				JSONArray selAutomanageSrvrTypesArr = new JSONArray();
				if (automanage_srvr_types != null && automanage_srvr_types.length >0)
				{
					automanageSrvrListShow = sorter.getSortedCompTypeList(automanageSrvrListShow);
					JSONObject tempSrvr2 = new JSONObject();
					for(int m=0; m<automanageSrvrListShow.size(); m++)
					{
						EgName nameObj2 = (EgName)automanageSrvrListShow.get(m);
						String tmpVal2 = nameObj2.getActualName();
						String tmpDis2 = nameObj2.getLocalName();
						tempSrvr2.put("displayField",tmpDis2);
						tempSrvr2.put("valueField",tmpVal2);
						selAutomanageSrvrTypesArr.add(tempSrvr2);
					}
					generalSettings.put("automanageSrvrArray",selAutomanageSrvrTypesArr);
					availSrvrArray.removeAll(selAutomanageSrvrTypesArr);
				}
				else if (automanage_srvr_types == null && loadCount != null)
				{
					if (loadCount.equalsIgnoreCase("0"))
					{
						generalSettings.put("automanageSrvrArray",automanageSrvrArray);
						availSrvrArray.removeAll(automanageSrvrArray);
					}
				}
				else
				{
					automanageSrvrArray.clear();
					generalSettings.put("automanageSrvrArray",automanageSrvrArray);
				}
				generalSettings.put("availSrvrArray",availSrvrArray);
				/*
				 * automanage component view & selection ends here
				 */
				 hiddenFields.put("$_AutoManage",autoManageStr);
				hiddenFields.put("$_Pattentype",patternType);
				hiddenFields.put("$_Wildcardpatten",wildcardPattern);
			}
		}

		hiddenFields.put("$_periodIndex",periodIndex);
		hiddenFields.put("$_discTimeoutIndex",discTimeoutIndex);
		hiddenFields.put("$_icmpfordiscovery",icmpfordiscovery);
		hiddenFields.put("$_Community",strCommunityStrings);
		hiddenFields.put("$_rediscoverComponents",prev_rediscoverDeleteComponent);
		hiddenFields.put("$_EngineID",prev_snmpEngineID);
		hiddenFields.put("$_dataOverTcp",prev_dataOverTcp);
		hiddenFields.put("$_DiscoverySNMPVersion",DiscoverySNMPVersion);
		hiddenFields.put("$_iprange",range);
		rootObj.put("generalSettings",generalSettings);

		String showCredential = request.getParameter("showCredential");
		if(showCredential == null || showCredential.length() == 0)
		{
			showCredential = "no";
		}
		boolean showCredentialSettings = (showCredential.equals("yes"));
		rootObj.put("showCredentialSettings",new Boolean(showCredentialSettings));


		String winCredentials=testIniFile.getValue("DISCOVERY_CREDENTIAL","Windows");	
		String winuserName = winCredentials.substring(0,winCredentials.indexOf(","));
		String userName="";
		String domainName="none";
		if(winuserName.indexOf("\\")>-1)
		{
			domainName = winuserName.substring(0,winuserName.indexOf("\\"));
			userName = winuserName.substring(winuserName.indexOf("\\")+1);
		}
		else userName=winuserName;
		String winpassword = winCredentials.substring(winCredentials.indexOf(",")+1);
		if(!winpassword.equals("none"))
			winpassword = EgCrypt.decrypt(winpassword);

		rootObj.put("winuser",userName);
		rootObj.put("winpassword",winpassword);
		rootObj.put("windomain",domainName);

		String sshCredentials=testIniFile.getValue("DISCOVERY_CREDENTIAL","SSH");
		String sshuserName = sshCredentials.substring(0,sshCredentials.indexOf(","));
		String sshpassword = sshCredentials.substring(sshCredentials.indexOf(",")+1);
		if(!sshpassword.equals("none"))
			sshpassword = EgCrypt.decrypt(sshpassword);

		rootObj.put("sshuserName",sshuserName);
		rootObj.put("sshpassword",sshpassword);

		String isFlagEnabled = testIniFile.getValue("DISCOVERY_CREDENTIAL","FlagEnabled");
		if (isFlagEnabled == null) isFlagEnabled = "no";
		rootObj.put("isFlagEnabled",isFlagEnabled);

		String duplicates=testIniFile.getValue("DISCOVERY_SETTINGS","allowDuplicates");
		rootObj.put("allowDuplicates",duplicates);
		hiddenFields.put("$_AllowDuplicates",duplicates);

		rootObj.put("hiddenFields",hiddenFields);
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscoveryPane.jsp?selectedNode="+selectedNode);
		out.println(rootObj.toString());
		return ;
	}

	if(from.equals("hmcAdd")||(from.equals("hmcModify") && allVCs.length > 0))
	{
		hiddenFields.put("refferalURL",refferalURL);
		JSONObject hmcServers = new JSONObject();
		hmcServers.put("from",from);
		if(from.equals("hmcModify"))
		{
			JSONArray hmcServerArr = new JSONArray();
			JSONObject hmcServerObj = new JSONObject();
			hmcServerObj.put("displayField",_mapping.getTextDescription("admin.discovery.Choose HMC IP address"));
			hmcServerObj.put("valueField","Choose HMC IP address");
			hmcServerArr.add(hmcServerObj);

			if(allVCs!=null&&allVCs.length>0)
			{
				for(int i=0;i<allVCs.length;i++)
				{
					hmcServerObj = new JSONObject();
					hmcServerObj.put("displayField",allVCs[i]);
					hmcServerObj.put("valueField",allVCs[i]);
					hmcServerArr.add(hmcServerObj);
					if (allVCs[i].equals(ip))
					{
						hmcServers.put("seletedHmcServer",ip);
					}
				}
			}
			JSONObject seletedServerDetails = new JSONObject();
			if (hName.equals("$unconfigured"))
			{
				hName = "-";
			}
			seletedServerDetails.put("hName",hName);
			hiddenFields.put("$_hName",hName);

			JSONArray hmcSSLFactory = new JSONArray();
			JSONObject hmcSSL = new JSONObject();
			hmcSSL.put("displayField",_mapping.getTextDescription("admin.discovery.No"));
			hmcSSL.put("valueField","False");
			hmcSSLFactory.add(hmcSSL);

			hmcSSL = new JSONObject();
			hmcSSL.put("displayField",_mapping.getTextDescription("admin.discovery.Yes"));
			hmcSSL.put("valueField","True");
			hmcSSLFactory.add(hmcSSL);
			hiddenFields.put("$_ssl",isSsl.equalsIgnoreCase("True")?"Yes":"No");
			seletedServerDetails.put("ssl",hmcSSLFactory);
			seletedServerDetails.put("isSSLSelected","selected");
			if (isSsl.equalsIgnoreCase("False"))
			{
				seletedServerDetails.put("isSSLSelected","");
			}

			JSONArray isDiscoveryArr = new JSONArray();
			JSONObject isDiscoveryObj = new JSONObject();
			isDiscoveryObj.put("displayField",_mapping.getTextDescription("admin.discovery.Yes"));
			isDiscoveryObj.put("valueField","Yes");
			isDiscoveryArr.add(hmcSSL);

			isDiscoveryObj = new JSONObject();
			isDiscoveryObj.put("displayField",_mapping.getTextDescription("admin.discovery.No"));
			isDiscoveryObj.put("valueField","No");
			isDiscoveryArr.add(isDiscoveryObj);
			hiddenFields.put("$_isDiscovery",isDiscovery.equalsIgnoreCase("Yes")?"Yes":"No");
			seletedServerDetails.put("isDiscovery",isDiscoveryArr);
			seletedServerDetails.put("isDiscoverySelected","selected");
			if (isDiscovery.equalsIgnoreCase("No") || isDiscovery.equalsIgnoreCase("false"))
			{
				seletedServerDetails.put("isDiscoverySelected","");
			}
			
			if (uName.equals("$unconfigured"))
			{
				uName = "-";
			}
			if (uPass.equals("$unconfigured"))
			{
				uPass = "-";
			}
			seletedServerDetails.put("uname",uName);
			hiddenFields.put("$_uname",uName);
			seletedServerDetails.put("pass",uPass);
			//hiddenFields.put("$_uname",uName);
			seletedServerDetails.put("confpasswd",uPass);
			hiddenFields.put("$_confpasswd",uPass);

			hmcServers.put("hmcServers",hmcServerArr);
			hmcServers.put("seletedServerDetails",seletedServerDetails);
			hmcServers.put("gridTitle",_mapping.getTextDescription("admin.discovery.Hardware management console (HMC) "));
			rootObj.put("hmcDetails",hmcServers);
		}
	}
	else if(from.equals("add")||(from.equals("modify")&&(allVCs.length>0)))
	{
		String componentType = "VmEsx_i_server";
		String testName = request.getParameter("testName");
		testName = (testName == null)?"":testName;
		String validationTitle=_mapping.getTextDescription("admin.common.Validating monitoring settings for")+" ";
		String validationURL="/final/admin/validateApplicationServerCredentails.jsp";
		String paramsForValidationURL="action=pickAgentToValidate&taskName=VmEsx_i_server&componentType="+componentType;


		EgServicesInfo servicesInfo = new EgServicesInfo("manager");
		boolean isAllowHostName = servicesInfo.isAllowHostNames();
		IniFile egTestParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
		String requiredParamNames="";
		String paramForDisplayingValidateButton="";
		requiredParamNames=egTestParamIni.getValue("VALIDATIONS_FIELDS","VmEsx_i_server:Default");
		String specificValidationFieldsForTest=egTestParamIni.getValue("VALIDATIONS_FIELDS",testName);
		if(specificValidationFieldsForTest!=null && (!specificValidationFieldsForTest.equals("") && !specificValidationFieldsForTest.equalsIgnoreCase("null")))
		{
			requiredParamNames=requiredParamNames+","+specificValidationFieldsForTest;
		}
		StringBuffer sbreqValsForValidation=new StringBuffer(256);
		if(requiredParamNames!=null && !requiredParamNames.equals(""))
		{
			StringTokenizer stkvFields=new StringTokenizer(requiredParamNames,",");
			while(stkvFields.hasMoreTokens())
			{
				String fieldName=stkvFields.nextToken();
				fieldName=fieldName.toLowerCase();
				sbreqValsForValidation.append(fieldName+",");
			}
		}
		requiredParamNames=sbreqValsForValidation.toString()+"componentcredentialsneededtodovalidation";
		if(requiredParamNames!=null && requiredParamNames.endsWith(","))
			requiredParamNames=requiredParamNames.substring(0,(requiredParamNames.length()-1));

		paramForDisplayingValidateButton=egTestParamIni.getValue("VALIDATION_BUTTON_LOCATION",testName);
		if(paramForDisplayingValidateButton!=null && (paramForDisplayingValidateButton.equals("") || paramForDisplayingValidateButton.equalsIgnoreCase("null")))
		{
			paramForDisplayingValidateButton=egTestParamIni.getValue("VALIDATION_BUTTON_LOCATION",componentType+":Default");
		}
		requiredParamNames=requiredParamNames+",passwordconfirmpassword";


		String allowedParams = egTestParamIni.getValue("SPECIAL_CHARACTERS","Parameters");
		//String[] tcKeywords = new String[0];
		//ArrayList aListTcKeywordsLowerCase = new ArrayList();
		//tcKeywords=egTestParamIni.getVariables("TEST_CONFIGURATION_PARAM_VALUE_KEYWORDS");
		//String strTcKeywords = "";
		//List listTcKeywords = Arrays.asList(tcKeywords);
		//strTcKeywords = listTcKeywords.toString();
		//strTcKeywords = strTcKeywords.substring(1,strTcKeywords.length()-1);
		//strTcKeywords = StringUtils.replace(strTcKeywords,", ",",");
		String componentCredentialsNeededToDoValidation="";

		hiddenFields.put("allowedParams",allowedParams);
		//hiddenFields.put("strTcKeywords",strTcKeywords);
		hiddenFields.put("refferalURL",refferalURL);
		hiddenFields.put("componentcredentialsneededtodovalidation",componentCredentialsNeededToDoValidation);
		
		JSONObject esxServers = new JSONObject();
		JSONObject seletedServerDetails = new JSONObject();
		if(from.equals("modify"))
		{
			JSONArray esxServerArr = new JSONArray();
			JSONObject esxServerObj = new JSONObject();
			esxServerObj.put("displayField",_mapping.getTextDescription("admin.discovery.Choose vCenter"));
			esxServerObj.put("valueField","Choose vCenter");
			esxServerArr.add(esxServerObj);
			if(allVCs!=null&&allVCs.length>0)
			{
				for(int i=0;i<allVCs.length;i++)
				{
					esxServerObj = new JSONObject();
					esxServerObj.put("displayField",allVCs[i]);
					esxServerObj.put("valueField",allVCs[i]);
					esxServerArr.add(esxServerObj);
					if (allVCs[i].equals(ip))
					{
						esxServers.put("seletedEsxServer",ip);
					}
				}
			}
			esxServers.put("ipAdd",esxServerArr);
			//seletedServerDetails.put("hName",hName);
			//hiddenFields.put("$_hName",hName);

			JSONArray esxSSLFactory = new JSONArray();
			JSONObject esxSSL = new JSONObject();
			esxSSL.put("displayField",_mapping.getTextDescription("admin.discovery.Yes"));
			esxSSL.put("valueField","True");
			esxSSLFactory.add(esxSSL);

			esxSSL = new JSONObject();
			esxSSL.put("displayField",_mapping.getTextDescription("admin.discovery.No"));
			esxSSL.put("valueField","False");
			esxSSLFactory.add(esxSSL);
			seletedServerDetails.put("ssl",esxSSLFactory);
			hiddenFields.put("$_ssl",isSsl.equalsIgnoreCase("True")?"Yes":"No");
			seletedServerDetails.put("isSSLSelected","selected");
			if (isSsl.equalsIgnoreCase("False"))
			{
				seletedServerDetails.put("isSSLSelected","");
			}

			if (webPort != null)//For Initial loading
			{
				if (isSsl != null && isSsl.equals(""))
				{
					webPort = "443";
				}
			}
			seletedServerDetails.put("webport",webPort);
			hiddenFields.put("$_webport",webPort);

			JSONArray isDiscoveryArr = new JSONArray();
			JSONObject isDiscoveryObj = new JSONObject();
			isDiscoveryObj.put("displayField",_mapping.getTextDescription("admin.discovery.Yes"));
			isDiscoveryObj.put("valueField","Yes");
			isDiscoveryArr.add(isDiscoveryObj);

			isDiscoveryObj = new JSONObject();
			isDiscoveryObj.put("displayField",_mapping.getTextDescription("admin.discovery.No"));
			isDiscoveryObj.put("valueField","No");
			isDiscoveryArr.add(isDiscoveryObj);
			seletedServerDetails.put("isDiscovery",isDiscoveryArr);
			hiddenFields.put("$_isDiscovery",isDiscovery.equalsIgnoreCase("Yes")?"Yes":"No");
			seletedServerDetails.put("isDiscoverySelected","selected");
			if (isDiscovery.equalsIgnoreCase("No") || isDiscovery.equalsIgnoreCase("false") )
			{
				seletedServerDetails.put("isDiscoverySelected","");
			}

			/*JSONArray serverTypeArr = new JSONArray();
			JSONObject serverTypeObj = new JSONObject();
			serverTypeObj = new JSONObject();
			serverTypeObj.put("displayField",_mapping.getTextDescription("admin.discovery.Desktop VMs"));
			serverTypeObj.put("valueField","DesktopVMs");
			serverTypeArr.add(serverTypeObj);

			serverTypeObj = new JSONObject();
			serverTypeObj.put("displayField",_mapping.getTextDescription("admin.discovery.Server VMs"));
			serverTypeObj.put("valueField","ServerVMs");
			serverTypeArr.add(serverTypeObj);

			serverTypeObj.put("displayField",_mapping.getTextDescription("admin.discovery.Desktop and Server VMs"));
			serverTypeObj.put("valueField","DesktopandServer");
			serverTypeArr.add(serverTypeObj);
			seletedServerDetails.put("servertype",serverTypeArr);
			if(serverType.equalsIgnoreCase("DesktopVMs"))
			{
				hiddenFields.put("$_servertype","DesktopVMs");
			}
			else if(serverType.equalsIgnoreCase("ServerVMs"))
			{
				hiddenFields.put("$_servertype","ServerVMs");
			}
			else
			{
				hiddenFields.put("$_servertype","DesktopandServer");
			}*/

			if (uName.equals("$unconfigured"))
			{
				uName = "-";
			}
			if (uPass.equals("$unconfigured"))
			{
				uPass = "-";
			}
			if(uName.indexOf("~eGHash~")>=0)
			{
				uName = StringUtils.replace(uName,"~eGHash~","#");
			}
			seletedServerDetails.put("uname",uName);
			hiddenFields.put("$_uname",uName);
			seletedServerDetails.put("pass",uPass);
			//hiddenFields.put("$_uname",uName);
			seletedServerDetails.put("confpasswd",uPass);
			hiddenFields.put("$_confpasswd",uPass);
			seletedServerDetails.put("validationButton","true");
			
			JSONObject validationCredentials = new JSONObject();
			validationCredentials.put("validationTitle",validationTitle);
			validationCredentials.put("specificConfiguration","specificConfiguration");
			validationCredentials.put("validationURL",validationURL);
			validationCredentials.put("pickAgentToValidate","pickAgentToValidate");
			validationCredentials.put("paramsForValidationURL",paramsForValidationURL);
			validationCredentials.put("isAllowHostName",isAllowHostName);
			validationCredentials.put("requiredParamNames",requiredParamNames);
			seletedServerDetails.put("validationCredentials",validationCredentials);
			esxServers.put("deletevCenterServers",esxServerArr);
			esxServers.put("seletedServerDetails",seletedServerDetails);
			rootObj.put("vCenterDetails",esxServers);
		}
	}
	else if(from.equals("nutanixAdd")||(from.equals("nutanixModify") && allVCs.length > 0))
	{
		hiddenFields.put("refferalURL",refferalURL);
		JSONObject nutanixServers = new JSONObject();
		nutanixServers.put("from",from);
		if(from.equals("nutanixModify"))
		{
			JSONArray nutanixServerArr = new JSONArray();
			JSONObject nutanixServerObj = new JSONObject();
			nutanixServerObj.put("displayField",_mapping.getTextDescription("admin.discovery.Choose Nutanix Prism Manager"));
			nutanixServerObj.put("valueField","Choose Nutanix Prism");
			nutanixServerArr.add(nutanixServerObj);			
			if(allVCs!=null&&allVCs.length>0)
			{				
				for(int i=0;i<allVCs.length;i++)
				{					
					nutanixServerObj = new JSONObject();
					nutanixServerObj.put("displayField",allVCs[i]);
					nutanixServerObj.put("valueField",allVCs[i]);
					nutanixServerArr.add(nutanixServerObj);
					if (allVCs[i].equals(ip))
					{
						nutanixServers.put("seletedNutanixServer",ip);
					}
				}
			}
			JSONObject seletedServerDetails = new JSONObject();
			if (hName.equals("$unconfigured"))
			{
				hName = "-";
			}
			seletedServerDetails.put("hName",hName);
			hiddenFields.put("$_hName",hName);

			JSONArray nutanixSSLFactory = new JSONArray();
			JSONObject nutanixSSL = new JSONObject();
			nutanixSSL.put("displayField",_mapping.getTextDescription("admin.discovery.No"));
			nutanixSSL.put("valueField","False");
			nutanixSSLFactory.add(nutanixSSL);

			nutanixSSL = new JSONObject();
			nutanixSSL.put("displayField",_mapping.getTextDescription("admin.discovery.Yes"));
			nutanixSSL.put("valueField","True");
			nutanixSSLFactory.add(nutanixSSL);
			hiddenFields.put("$_ssl",isSsl.equalsIgnoreCase("True")?"Yes":"No");
			seletedServerDetails.put("ssl",nutanixSSLFactory);
			seletedServerDetails.put("isSSLSelected","selected");
			if (isSsl.equalsIgnoreCase("False"))
			{
				seletedServerDetails.put("isSSLSelected","");
			}
			if (webPort != null)//For Initial loading
			{
				if (isSsl != null && isSsl.equals(""))
				{
					webPort = "9440";
				}
			}			
			seletedServerDetails.put("webport",webPort);
			hiddenFields.put("$_webport",webPort);
			seletedServerDetails.put("mgrtype",mgrtype);
			hiddenFields.put("$_mgrtype",mgrtype);
			JSONArray isDiscoveryArr = new JSONArray();
			JSONObject isDiscoveryObj = new JSONObject();
			isDiscoveryObj.put("displayField",_mapping.getTextDescription("admin.discovery.Yes"));
			isDiscoveryObj.put("valueField","Yes");
			isDiscoveryArr.add(nutanixSSL);

			isDiscoveryObj = new JSONObject();
			isDiscoveryObj.put("displayField",_mapping.getTextDescription("admin.discovery.No"));
			isDiscoveryObj.put("valueField","No");
			isDiscoveryArr.add(isDiscoveryObj);
			hiddenFields.put("$_isDiscovery",isDiscovery.equalsIgnoreCase("Yes")?"Yes":"No");
			seletedServerDetails.put("isDiscovery",isDiscoveryArr);
			seletedServerDetails.put("isDiscoverySelected","selected");
			if (isDiscovery.equalsIgnoreCase("No") || isDiscovery.equalsIgnoreCase("false"))
			{
				seletedServerDetails.put("isDiscoverySelected","");
			}
			
			if (uName.equals("$unconfigured"))
			{
				uName = "-";
			}
			if (uPass.equals("$unconfigured"))
			{
				uPass = "-";
			}
			seletedServerDetails.put("uname",uName);
			hiddenFields.put("$_uname",uName);
			seletedServerDetails.put("pass",uPass);
			//hiddenFields.put("$_uname",uName);
			seletedServerDetails.put("confpasswd",uPass);
			hiddenFields.put("$_confpasswd",uPass);

			nutanixServers.put("nutanixServers",nutanixServerArr);
			nutanixServers.put("seletedServerDetails",seletedServerDetails);
			nutanixServers.put("gridTitle",_mapping.getTextDescription("admin.discovery.Hardware management console "));
			rootObj.put("nutanixDetails",nutanixServers);
		}
	}

	if((from.equalsIgnoreCase("view") || from.equalsIgnoreCase("delete"))  && allVCs.length>0)
	{
		hiddenFields.put("refferalURL",refferalURL);
		JSONObject deletevCenterServers = new JSONObject();
		JSONArray vCenterArr = new JSONArray();
		JSONArray vCHiddenArr = new JSONArray();
		JSONObject columns = new JSONObject();

		HashMap vcEsxMap = new HashMap();

		if (from.equalsIgnoreCase("delete"))
		{
			columns.put("delOption","");

			ArrayList resultList = getvCenterDetails();
			vcEsxMap = (HashMap)resultList.get(0);
		}
		columns.put("vCenter IP/Host",_mapping.getTextDescription("admin.discovery.vCenter IP/Host"));
		columns.put("SSL",_mapping.getTextDescription("admin.discovery.SSL"));
		columns.put("Web Port",_mapping.getTextDescription("admin.discovery.Web Port"));
		columns.put("Discovery Enabled",_mapping.getTextDescription("admin.discovery.Discovery Enabled"));
		columns.put("User",_mapping.getTextDescription("admin.discovery.User"));
		//columns.put("VMs Type",_mapping.getTextDescription("admin.discovery.VMs Type"));

		JSONObject vCenterConfiguredObj = new JSONObject();

		for(int v=0; v<allVCs.length; v++)
		{
			JSONObject vCenterObj = new JSONObject();
			String vCenterIP=allVCs[v];
			ArrayList content = (ArrayList)allData.get(vCenterIP);
			isSsl= (String)content.get(0);
			if(isSsl.equalsIgnoreCase("True"))
				isSsl="Yes";
			else
				isSsl="No";
			isDiscovery=(String)content.get(1);
			uName=(String)content.get(2);
			if(uName.indexOf("~eGHash~")>=0)
			{
				uName = StringUtils.replace(uName,"~eGHash~","#");
			}
			if(from.startsWith("hmc"))
				hName = (String)content.get(4);
			else
				webPort = (String)content.get(4);
			/*if(from.startsWith("view") || from.equalsIgnoreCase("delete"))
				srvType = (String)content.get(5);
			String temp_srvType="Server VMs";
			if(srvType.equalsIgnoreCase("ServerVMs"))
			{
				temp_srvType = "Server VMs";
			}
			else if(srvType.equalsIgnoreCase("DesktopVMs"))
			{
				temp_srvType = "Desktop VMs";
			}
			else if(srvType.equalsIgnoreCase("DesktopandServer"))
			{
				temp_srvType = "Desktop and Server VMs";
			}*/

			if (from.equalsIgnoreCase("delete"))
			{
				vCenterConfiguredObj.put(vCenterIP,false);
				if (vcEsxMap != null && vcEsxMap.containsKey(vCenterIP))
				{
					ArrayList tmpList = (ArrayList)vcEsxMap.get(vCenterIP);
					if (tmpList != null && !tmpList.isEmpty())
					{
						vCenterConfiguredObj.put(vCenterIP,true);
					}
				}
			}
			vCenterObj.put("vCenter IP/Host",vCenterIP);
			vCenterObj.put("SSL",isSsl);
			vCenterObj.put("Web Port",webPort);
			vCenterObj.put("delOption",vCenterIP);
			if(isDiscovery.equalsIgnoreCase("yes"))
			{
				vCenterObj.put("Discovery Enabled","Yes");
			}
			else
			{
				vCenterObj.put("Discovery Enabled","No");
			}
			if (uName.equals("$unconfigured"))
			{
				uName = "-";
			}
			vCenterObj.put("User",uName);
			//vCenterObj.put("VMs Type",temp_srvType);
			vCenterArr.add(vCenterObj);
			vCHiddenArr.add(vCenterIP);
		}
		deletevCenterServers.put("vCHiddenArr",vCHiddenArr);
		deletevCenterServers.put("deletevCenterServers",vCenterArr);
		deletevCenterServers.put("columns",columns);
		deletevCenterServers.put("gridTitle",_mapping.getTextDescription("admin.discovery.vCenters"));
		rootObj.put("vCenterConfiguredObj",vCenterConfiguredObj);
		rootObj.put("vCenterDetails",deletevCenterServers);
	}

	if((from.equalsIgnoreCase("hmcView") || from.equalsIgnoreCase("hmcDelete"))  && allVCs.length>0)
	{
		hiddenFields.put("refferalURL",refferalURL);
		JSONObject hmcServers = new JSONObject();
		JSONArray hmcArr = new JSONArray();
		JSONArray hmcHiddenArr = new JSONArray();

		JSONObject columns = new JSONObject();
		if (from.equalsIgnoreCase("hmcDelete"))
		{
			columns.put("delOption","");
		}
		columns.put("HMC IP",_mapping.getTextDescription("admin.discovery.HMC IP"));
		columns.put("HMC Host Name",_mapping.getTextDescription("admin.discovery.HMC Host Name"));
		columns.put("SSL",_mapping.getTextDescription("admin.discovery.SSL"));
		columns.put("Discovery Enabled",_mapping.getTextDescription("admin.discovery.Discovery Enabled"));
		columns.put("User",_mapping.getTextDescription("admin.discovery.User"));

		for(int v=0;v<allVCs.length;v++)
		{
			JSONObject hmcObj = new JSONObject();
			String vCenterIP=allVCs[v];
			ArrayList content = (ArrayList)allData.get(vCenterIP);
			isSsl= (String)content.get(0);
			if(isSsl.equalsIgnoreCase("True"))
				isSsl="Yes";
			else
				isSsl="No";
			isDiscovery=(String)content.get(1);
			uName=(String)content.get(2);
			if(from.startsWith("hmc"))
				hName = (String)content.get(4);
			else
				webPort = (String)content.get(4);

			hmcObj.put("HMC IP",vCenterIP);
			if (hName.equals("$unconfigured"))
			{
				hName = "-";
			}
			hmcObj.put("HMC Host Name",hName);
			hmcObj.put("SSL",isSsl);
			hmcObj.put("delOption",vCenterIP);
			if(isDiscovery.equalsIgnoreCase("yes"))
			{
				hmcObj.put("Discovery Enabled","Yes");
			}
			else
			{
				hmcObj.put("Discovery Enabled","No");
			}
			if (uName.equals("$unconfigured"))
			{
				uName = "-";
			}
			hmcObj.put("User",uName);
			hmcArr.add(hmcObj);
			hmcHiddenArr.add(vCenterIP);
		}
		hmcServers.put("vCHiddenArr",hmcHiddenArr);
		hmcServers.put("hmcServers",hmcArr);
		hmcServers.put("columns",columns);
		hmcServers.put("gridTitle",_mapping.getTextDescription("admin.discovery.Hardware management console (HMC) "));
		rootObj.put("hmcDetails",hmcServers);
	}
	if((from.equalsIgnoreCase("nutanixView") || from.equalsIgnoreCase("nutanixDelete"))  && allVCs.length>0)
	{
		hiddenFields.put("refferalURL",refferalURL);
		JSONObject nutanixServers = new JSONObject();
		JSONArray nutanixArr = new JSONArray();
		JSONArray nutanixHiddenArr = new JSONArray();

		JSONObject columns = new JSONObject();
		if (from.equalsIgnoreCase("nutanixDelete"))
		{
			columns.put("delOption","");
		}
		columns.put("Nutanix IP",_mapping.getTextDescription("admin.discovery.Prism IP/HostName"));
		columns.put("Web Port",_mapping.getTextDescription("admin.discovery.Web Port"));
		columns.put("Manager Type",_mapping.getTextDescription("admin.discovery.Manager Type"));
		columns.put("SSL",_mapping.getTextDescription("admin.discovery.SSL"));
		columns.put("Discovery Enabled",_mapping.getTextDescription("admin.discovery.Discovery Enabled"));
		columns.put("User",_mapping.getTextDescription("admin.discovery.User"));

		for(int v=0;v<allVCs.length;v++)
		{
			JSONObject nutanixObj = new JSONObject();
			String nutanixIP=allVCs[v];
			String dispValOfMgrtype = "Nutanix Prism Element";
			ArrayList content = (ArrayList)allData.get(nutanixIP);			
			isSsl= (String)content.get(0);
			if(isSsl.equalsIgnoreCase("True"))
				isSsl="Yes";
			else
				isSsl="No";
			isDiscovery=(String)content.get(1);
			uName=(String)content.get(2);
			if(from.startsWith("hmc"))
				hName = (String)content.get(4);
			else
				webPort = (String)content.get(4);

			if(content.size() > 5)
			{
				mgrtype = (String)content.get(5);
				if (mgrtype.equalsIgnoreCase("true"))
				{
					dispValOfMgrtype = "Nutanix Prism Central";
				}
			}
			nutanixObj.put("Nutanix IP",nutanixIP);
			if (hName.equals("$unconfigured"))
			{
				hName = "-";
			}
			nutanixObj.put("Nutanix Host Name",hName);
			nutanixObj.put("Web Port",webPort);
			nutanixObj.put("SSL",isSsl);
			nutanixObj.put("delOption",nutanixIP);
			nutanixObj.put("Manager Type",dispValOfMgrtype);
			if(isDiscovery.equalsIgnoreCase("yes"))
			{
				nutanixObj.put("Discovery Enabled","Yes");
			}
			else
			{
				nutanixObj.put("Discovery Enabled","No");
			}
			if (uName.equals("$unconfigured"))
			{
				uName = "-";
			}
			nutanixObj.put("User",uName);
			nutanixArr.add(nutanixObj);
			nutanixHiddenArr.add(nutanixIP);
		}
		nutanixServers.put("vCHiddenArr",nutanixHiddenArr);
		nutanixServers.put("nutanixServers",nutanixArr);
		nutanixServers.put("columns",columns);
		nutanixServers.put("gridTitle",_mapping.getTextDescription("admin.discovery.Nutanix Prism Manager Preferences "));
		rootObj.put("nutanixDetails",nutanixServers);
	}

	if(from.equals("cloudAdd")|| (from.equals("cloudModify")&&(allVCs.length>0)))
	{
		hiddenFields.put("refferalURL",refferalURL);
		JSONObject cloudServers = new JSONObject();
		JSONObject seletedServerDetails = new JSONObject();
		if(from.equals("cloudModify"))
		{
			JSONArray cloudServerArr = new JSONArray();
			JSONObject cloudServerObj = new JSONObject();
			cloudServerObj.put("displayField",_mapping.getTextDescription("admin.discovery.Choose account"));
			cloudServerObj.put("valueField","Choose account");
			cloudServerArr.add(cloudServerObj);
			if(allVCs!=null&&allVCs.length>0)
			{
				for(int i=0;i<allVCs.length;i++)
				{
					cloudServerObj = new JSONObject();
					cloudServerObj.put("displayField",allVCs[i]);
					cloudServerObj.put("valueField",allVCs[i]);
					cloudServerArr.add(cloudServerObj);
					if (allVCs[i].equals(account))
					{
						cloudServers.put("selectedCloudAccount",account);
					}
				}
			}
			JSONArray isDiscoveryArr = new JSONArray();
			JSONObject isDiscoveryObj = new JSONObject();
			isDiscoveryObj.put("displayField",_mapping.getTextDescription("admin.discovery.Yes"));
			isDiscoveryObj.put("valueField","Yes");
			isDiscoveryArr.add(isDiscoveryObj);

			isDiscoveryObj = new JSONObject();
			isDiscoveryObj.put("displayField",_mapping.getTextDescription("admin.discovery.No"));
			isDiscoveryObj.put("valueField","No");
			isDiscoveryArr.add(isDiscoveryObj);
			seletedServerDetails.put("isDiscovery",isDiscoveryArr);
			hiddenFields.put("$_isDiscovery",isDiscovery.equalsIgnoreCase("Yes")?"Yes":"No");
			seletedServerDetails.put("isDiscoverySelected","selected");
			if (isDiscovery.equalsIgnoreCase("No") || isDiscovery.equalsIgnoreCase("false"))
			{
				seletedServerDetails.put("isDiscoverySelected","");
			}
			seletedServerDetails.put("accessKey",uName);
			hiddenFields.put("$_accessKey",uName);
			seletedServerDetails.put("confAccessKey",uName);
			hiddenFields.put("$_accessKey",uName);
			seletedServerDetails.put("secretKey",uPass);
			seletedServerDetails.put("confSecretKey",uPass);
			hiddenFields.put("$_secretKey",uPass);
			cloudServers.put("cloudServers",cloudServerArr);
			cloudServers.put("seletedServerDetails",seletedServerDetails);
			rootObj.put("cloudDetails",cloudServers);
		}
	}
	if((from.equalsIgnoreCase("cloudView") || from.equalsIgnoreCase("cloudDelete"))  && allVCs.length>0)
	{
		hiddenFields.put("refferalURL",refferalURL);
		JSONObject cloudServers = new JSONObject();
		JSONArray cloudArr = new JSONArray();
		JSONArray cloudHiddenArr = new JSONArray();
		JSONObject columns = new JSONObject();
		if (from.equalsIgnoreCase("cloudDelete"))
		{
			columns.put("delOption","");
		}
		columns.put("AWS Cloud account",_mapping.getTextDescription("admin.discovery.AWS Cloud account"));
		columns.put("Discovery Enabled",_mapping.getTextDescription("admin.discovery.Discovery Enabled"));
		for(int v=0;v<allVCs.length;v++)
		{
			JSONObject couldObj = new JSONObject();
			String vCenterIP=allVCs[v];
			ArrayList content = (ArrayList)allData.get(vCenterIP);
			isDiscovery=(String)content.get(2);
			uName=(String)content.get(0);

			couldObj.put("AWS Cloud account",vCenterIP);
			couldObj.put("delOption",vCenterIP);
			if(isDiscovery.equalsIgnoreCase("yes"))
			{
				couldObj.put("Discovery Enabled","Yes");
			}
			else
			{
				couldObj.put("Discovery Enabled","No");
			}
			cloudArr.add(couldObj);
			cloudHiddenArr.add(vCenterIP);
		}
		cloudServers.put("cloudServers",cloudArr);
		cloudServers.put("columns",columns);
		cloudServers.put("gridTitle",_mapping.getTextDescription("admin.discovery.AWS Cloud Accounts "));
		cloudServers.put("vCHiddenArr",cloudHiddenArr);
		rootObj.put("cloudDetails",cloudServers);
	}
	if (from != null && from.equalsIgnoreCase("EnableDisableDiscovery"))
	{
		JSONArray disArr = new JSONArray();
		JSONObject columns = new JSONObject();
		columns.put("col1",_mapping.getTextDescription("admin.discovery.Discovery Option"));
		columns.put("col2",_mapping.getTextDescription("admin.discovery.Enabled?"));
		boolean isDiscoveryEnabled = false;
		String tooltip = "Manager discovery is currently disabled for your environment, Click here to enable.";
		if (managerDiscovery.equalsIgnoreCase("enabled") || managerDiscovery.equalsIgnoreCase("enable"))
		{
			isDiscoveryEnabled = true;
			tooltip = "Manager discovery is currently enabled for your environment, Click here to disable.";
		}
		JSONObject discoveryObj = new JSONObject();
		discoveryObj.put("col1",_mapping.getTextDescription("admin.discovery.IP range discovery"));
		discoveryObj.put("col2",new Boolean(isDiscoveryEnabled));
		disArr.add(discoveryObj);
		rootObj.put("columns",columns);
		rootObj.put("tooltip",tooltip);
		rootObj.put("managerActions",disArr);
	}

	if(allVCs.length==0&&(from.equalsIgnoreCase("cloudDelete")||from.equalsIgnoreCase("cloudView")||from.equalsIgnoreCase("cloudModify")))
	{
		JSONObject cloudServers = new JSONObject();
		JSONArray cloudArr = new JSONArray();
		cloudServers.put("cloudServers",cloudArr);
		rootObj.put("cloudDetails",cloudServers);
		rootObj.put("emptyMessage",_mapping.getTextDescription("admin.discovery.No AWS Cloud accounts are available currently"));
		
	}
	else if(allVCs.length==0&&(from.equalsIgnoreCase("hmcDelete")||from.equalsIgnoreCase("hmcView")||from.equalsIgnoreCase("hmcModify")))
	{
		JSONObject hmcServers = new JSONObject();
		JSONArray hmcArr = new JSONArray();
		hmcServers.put("hmcServers",hmcArr);
		rootObj.put("hmcDetails",hmcServers);
		rootObj.put("emptyMessage",_mapping.getTextDescription("admin.discovery.No HMC servers are available currently"));
	}
	else if(allVCs.length==0&&(from.equalsIgnoreCase("delete")||from.equalsIgnoreCase("view")||from.equalsIgnoreCase("modify")))
	{
		JSONObject deletevCenterServers = new JSONObject();
		JSONArray vCenterArr = new JSONArray();
		deletevCenterServers.put("deletevCenterServers",vCenterArr);
		rootObj.put("vCenterDetails",deletevCenterServers);
		rootObj.put("emptyMessage",_mapping.getTextDescription("admin.discovery.No vCenter servers are available currently"));
	}
	else
	if(allVCs.length==0&&(from.equalsIgnoreCase("nutanixDelete")||from.equalsIgnoreCase("nutanixView")||from.equalsIgnoreCase("nutanixModify")))
	{
		//new changes....
		JSONObject nutanixServers = new JSONObject();
		JSONArray nutanixArr = new JSONArray();
		nutanixServers.put("nutanixServers",nutanixArr);
		rootObj.put("nutanixDetails",nutanixServers);
		rootObj.put("emptyMessage",_mapping.getTextDescription("admin.discovery.No nutanix prism manager are available currently"));		
	}
	hiddenFields.put("platform",platform);
	hiddenFields.put("frmLocation",frmLocation);
	rootObj.put("hiddenFields",hiddenFields);
	session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscoveryPane.jsp?selectedNode="+selectedNode);
	out.println(rootObj.toString());
%>

<%!
	public ArrayList udServers = new ArrayList();
	public ArrayList tempServers = new ArrayList();


	public String[] getServerTypesBasedOnPriority(String categoryOption,String [] validServerTypes,IniFile infraPtr)
	{
		String [] result= null;
		if(categoryOption.equalsIgnoreCase("others"))
		{
			ArrayList serversGrpList = getOtherServers(validServerTypes);
			result=new String[serversGrpList.size()];
			for(int j=0;j<serversGrpList.size();j++)
			{
				String otherServer=(String)serversGrpList.get(j);
				result[j]=new String(otherServer);
			}
		}
		else
		{
			//String [] validServerTypes = getValidServerTypesForDiscovery();
			List validServerList = Arrays.asList(validServerTypes);			
			String [] thisvars=infraPtr.getVariables(categoryOption);		
			if(thisvars!=null)
			{
				result=new String[thisvars.length];
				for(int t=0; t<thisvars.length; t++)
				{
					String thisComp = (String)thisvars[t];		
					if(validServerList.contains(thisComp)){
						result[t]=new String(thisComp);					
					}
					else if(validServerList.contains("#"+thisComp)){
						result[t]=new String("#"+thisComp);
					}
				}
			}
		}
		return result;			
	}

	public ArrayList allServerTypes(String[] validServerTypes)
	{
		IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
		ArrayList resultList=new ArrayList();
		ArrayList allServerGrps = getAllServerGroups(validServerTypes);
		for(int a=0;a<allServerGrps.size();a++)
		{
			String categoryOption = (String)allServerGrps.get(a);
			String[] result = getServerTypesBasedOnPriority(categoryOption,validServerTypes,iniFile);
			for(int r=0;r<result.length;r++)
			{
				resultList.add(result[r]);
			}
		}
		return resultList;
	}
	
	public ArrayList getAllServerGroups(String[] servertypes)
	{
		List validServerList = Arrays.asList(servertypes);	
		ArrayList grp = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects = iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				String subject = Subjects[i];
				String[] allVariables = iniFile.getVariables(subject);
				if(allVariables==null || allVariables.length==0)
					continue;
				
				boolean hasVar = false;
				for(int g=0;g<allVariables.length;g++)
				{
					String variable = allVariables[g];
					if(validServerList.contains(variable) || validServerList.contains("#"+variable))
						hasVar = true;
				}
				if(!hasVar) continue;
				grp.add(subject);
			}
			Collections.sort(grp,String.CASE_INSENSITIVE_ORDER);
			grp.remove("AGGREGATES");
			ArrayList otherServers = getOtherServers(servertypes);
			if(otherServers!=null && otherServers.size()>0)
				grp.add("OTHERS");
			return grp;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return new ArrayList();
		}
	}
	public String getCapitalizedCategory(String categoryName)
	{
		StringBuffer buff = new StringBuffer();
		int j = 0;
		if (categoryName != null)
		{
			//for (int i = 0;i<grps.size();i++ )
			//{
				//String val = (String)grps.get(i);
				
				if (categoryName.equalsIgnoreCase("JAVAAPP_SERVERS")){
					categoryName = "JAVA_APPLICATION_SERVERS";
				}
				if (categoryName.indexOf("_") != -1)
				{
					categoryName = StringUtils.replace(categoryName,"_"," ");
				}
				StringTokenizer tokens = new StringTokenizer(categoryName," ");
				while(tokens.hasMoreTokens())
				{
					String token = tokens.nextToken();
					token = token.trim();
					token = token.toLowerCase();
					String sub = token.substring(1);
					String initial = (token.substring(0,1)).toUpperCase();
					if (token.equalsIgnoreCase("UPS"))
					{
						initial = "UPS";
					}
					else
					{
						initial = initial + sub;
					}
					if (j == 0)
					{
						buff.append(initial);
					}
					else
					{
						buff.append(" ");
						buff.append(initial);
					}
					j++;
				}
			//}
		}
		return buff.toString();
	}
	
	public void getAllInfraServers()
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				if (Subjects[i] != null && Subjects[i].equalsIgnoreCase("AGGREGATES"))
				{
					continue;
				}

				String [] variables = iniFile.getVariables(Subjects[i]);
				for (int j = 0;j<variables.length;j++)
				{
					if(!tempServers.contains(variables[j]))
						tempServers.add(variables[j]);
				}
			}
		}
		catch (Exception e)
		{
		}
	}
	public ArrayList getOtherServers(String[] servertypes)
	{
		List validServerList = Arrays.asList(servertypes);
		getAllInfraServers();
		ArrayList serverList = new ArrayList();
		EgDiscInfo egDisc = new EgDiscInfo("manager");
		String[] otherServers = egDisc.getComponentTypes();
		if (otherServers == null || otherServers.length == 0)
		{
			return new ArrayList();
		}

		for(int i=0; i<otherServers.length; i++)
		{
			String otherServer = otherServers[i];
			if (!otherServer.equals("Site_servers"))
			{
				if (!tempServers.contains(otherServer))
				{
					if(validServerList.contains(otherServer))
						serverList.add(otherServer);
					else if(validServerList.contains("#"+otherServer))
						serverList.add("#"+otherServer);
				}
			}
		}
		return serverList;
	}
%>




