<%@ include file="../../EgTrackerAJSON.jsp"%>

<%@ page import = "egurkha.ServiceBean"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "net.sf.json.JSONObject"%>

<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<jsp:useBean id="DiscBean" scope="page" class="egurkha.ServiceBean"/>

<%
/*
*	Processing page for Storage platform node in Discovery tree.
*	ini File : eg_services.ini, subject : EMC_XtremIO_4x 
*/
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();

	EgDiscInfo discInfo = new EgDiscInfo("manager");

	String storagePlatform = "EMC_XtremIO_4x";

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Discovery");

	String ipLabel = "XMS identity (IP or Host name)";
	String sslLabel = "Use SSL to connect to XMS";
	String discoverLabel = "Discover EMC XtremIO hosts using this XMS";
	String userLabel = "Username to connect to XMS";
	String pwdLabel = "Password for the user";

	String from = request.getParameter("from");
	String ip = request.getParameter("ip");	
	String ssl = request.getParameter("ssl");
	String discover = request.getParameter("discover");
	String user = request.getParameter("user");
	String pwd = request.getParameter("pwd");

	rootJson.put("success","false");
	
	if(from != null && from.equalsIgnoreCase("xmsAdd"))
	{
		auditLogThread.setValue("Activity","Add XMS discovery");
		if(ip != null && ip.length() > 0)
		{
			ssl = (ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))? "Yes" :"No";
			discover = (discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))? "Yes" :"No";

			pwd = EgCrypt.encrypt(pwd);

			String value = ssl + "#" +  user + "#" + pwd + "#" + discover;
			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			services.setValue(storagePlatform,ip,value);
			services.saveFile();
			EgConfigFilesSync.releaseInstance(services);

			auditLogThread.setCurrentValue("00~~"+ipLabel,ip);
			auditLogThread.setCurrentValue("01~~"+sslLabel,ssl);
			auditLogThread.setCurrentValue("02~~"+discoverLabel,discover);
			auditLogThread.setCurrentValue("03~~"+userLabel,user);
			auditLogThread.setCurrentValue("04~~"+pwdLabel,"*****");

			auditLogThread.setValue("Description","XMS preferences have been added successfully");
			auditLogThread.sendItToDB();
			
			DiscBean.createAdmin();
			String autoManage = DiscBean.getAutomanage();
			autoManage = (autoManage == null || autoManage.length() == 0)?"No":autoManage;
			EgDiscoveryAutoManager autoManagerDisc = new EgDiscoveryAutoManager();
			String discovery = request.getParameter("discovery");
			if(discovery != null && (discovery.equalsIgnoreCase("true") || discovery.equalsIgnoreCase("yes")))
			{
				//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
				IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
				ServiceBean serviceBean = new ServiceBean();
				serviceBean.stopDiscovery();
				serviceBean.startDiscovery("11",true);
				EgConfigFilesSync.releaseInstance(infraIni);
				if (autoManage.equalsIgnoreCase("yes") || autoManage.equalsIgnoreCase("true"))
				{
					DiscoveryLicenseController.sesstionID = request.getSession().getId();
					DiscoveryLicenseController.userID = _user.getLoginID();
					autoManagerDisc.startAutoManager();
				}
			}

			rootJson.put("success","true");

		}
	}
	else if(from != null && from.equalsIgnoreCase("xmsModify"))
	{
		auditLogThread.setValue("Activity","Modify XMS discovery");
		if(ip != null && ip.length() > 0)
		{
			String $_ssl = request.getParameter("$_ssl");			
			String $_discover = request.getParameter("$_discover");
			String $_user = request.getParameter("$_user");
			String $_pwd = request.getParameter("$_pwd");

			boolean setAudit = false;
			boolean updateAgents = false;

			if($_ssl != null && !$_ssl.equalsIgnoreCase(ssl))
			{
				auditLogThread.setPreviousValue("00~~"+sslLabel,$_ssl);
				auditLogThread.setCurrentValue("00~~"+sslLabel,ssl);
				setAudit = true;
				updateAgents = true;
			}

			if($_discover != null && !$_discover.equalsIgnoreCase(discover))
			{
				auditLogThread.setPreviousValue("01~~"+discoverLabel,$_discover);
				auditLogThread.setCurrentValue("01~~"+discoverLabel,discover);
				setAudit = true;
			}

			if($_user != null && !$_user.equalsIgnoreCase(user))
			{
				auditLogThread.setPreviousValue("03~~"+userLabel,$_user);
				auditLogThread.setCurrentValue("03~~"+userLabel,user);
				setAudit = true;
				updateAgents= true;
			}

			if($_pwd != null && !$_pwd.equalsIgnoreCase(pwd))
			{
				auditLogThread.setPreviousValue("04~~"+pwdLabel,"*****");
				auditLogThread.setCurrentValue("04~~"+pwdLabel,"********");
				setAudit = true;
				updateAgents = true;
			}

			ssl = (ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))? "Yes" :"No";

			discover = (discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))? "Yes" :"No";

			pwd = EgCrypt.encrypt(pwd);

			String value = ssl + "#" +  user + "#" + pwd + "#" + discover;			
			
			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			services.setValue(storagePlatform,ip,value);
			services.saveFile();
			EgConfigFilesSync.releaseInstance(services);

			auditLogThread.setValue("Description","XMS for "+ip+" preferences have been modified successfully");
			auditLogThread.sendItToDB();

			if(updateAgents)
			{
				boolean managedState = false;
				String[] xmsComps = discInfo.getAllServersOfType("EMC_XtremIO_4x");
				for (int i = 0; i < xmsComps.length; i++)
				{
					String xmsComp = xmsComps[i];
					if(xmsComp.startsWith("Format") || xmsComp.startsWith("#"))
						continue;
					String xmsCompValue[] = discInfo.getFieldValuesForServer("EMC_XtremIO_4x",xmsComp);
					ArrayList xmsCompValueList = new ArrayList();
					for (int j = 0; j < xmsCompValue.length; j++)
					{
						xmsCompValueList.add(xmsCompValue[j].toLowerCase());
					}
					if(xmsCompValueList.contains(ip.toLowerCase()))
					{
						EgExternalInfo externalInfo = new EgExternalInfo("manager");
						String xms = xmsComp.substring(xmsComp.indexOf(":")+1);
						xms = xms.substring(0,xms.indexOf(":"));
						List agents = externalInfo.getAgentsForHost(xms);
						if(agents != null)
						{
							IniFile agentIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
							for(int k = 0; k < agents.size(); k++)
							{
								String agent = (String) agents.get(k);
								String[] agentTests = agentIni.getVariables(agent);
								if(agentTests != null)
								{
									for(int l = 0; l < agentTests.length; l++)
									{
										String testNameVar = agentTests[l];
										String testValue = agentIni.getValue(agent,testNameVar);

										if(testValue.indexOf("-XtremIO_user") > -1)
										{
											String host = testValue.substring(testValue.indexOf("-host")+5).trim();
											host = host.substring(0,host.indexOf(" -XtremIO_user")).trim();
											String testVarLower = testNameVar.toLowerCase();

											if(testVarLower.indexOf(":"+ip.toLowerCase()+":") > 0 || 
												testVarLower.endsWith(":"+ip.toLowerCase()) || 
												host.equalsIgnoreCase(ip))
											{
												int unLen = "-XtremIO_user".length();
												if(testValue.indexOf("-XtremIO_user") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-XtremIO_user")+unLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-XtremIO_user")+unLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													testValue = value1+" "+user+" "+value2;
												}

												int pwdLen = "-XtremIO_password".length();
												if(testValue.indexOf("-XtremIO_password") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-XtremIO_password")+pwdLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-XtremIO_password")+pwdLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													testValue = value1+" "+pwd+" "+value2;
												}

												int sslLen = "-ssl".length();
												if(testValue.indexOf("-ssl") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-ssl")+sslLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-ssl")+sslLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													ssl = (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True"))? "true" :"false";
													testValue = value1+" "+ssl+" "+value2;
												}
												agentIni.setValue(agent,testNameVar,testValue);
											}
										}
									}
								}
							}
							agentIni.saveFile();
							EgConfigFilesSync.releaseInstance(agentIni);
						}
					}
				}
			}

			String discovery = request.getParameter("discovery");
			if(discovery != null && (discovery.equalsIgnoreCase("true") || discovery.equalsIgnoreCase("yes")))
			{
				//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
				IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
				ServiceBean serviceBean = new ServiceBean();
				serviceBean.stopDiscovery();
				serviceBean.startDiscovery("11",true);
				EgConfigFilesSync.releaseInstance(infraIni);
			}

			rootJson.put("success","true");
		}
	}
	else if(from != null && from.equalsIgnoreCase("delStoragePlatform"))
	{
		auditLogThread.setValue("Activity","Delete XMS discovery");

		boolean success = false;
		boolean managedState = false;

		String xmsIPs = request.getParameter("xmsIps");		
		ArrayList allCompFieldLists = new ArrayList();
		ArrayList dontDelete = new ArrayList();
		if(xmsIPs != null && xmsIPs.length() > 0)
		{
			IniFile discFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini");
			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			IniFile xmsMapping = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_xmsmapping.ini");

			String[] xmsCompArr = discFile.getVariables("EMC_XtremIO_4x");
			if(xmsCompArr != null)
			{
				for(int i = 0; i < xmsCompArr.length; i++)
				{
					String xmsCompVar = xmsCompArr[i];
					if(xmsCompVar.startsWith("#") || xmsCompVar.startsWith("Format"))
						continue;
					String fieldValue = discFile.getValue("EMC_XtremIO_4x",xmsCompVar);
					StringTokenizer st = new StringTokenizer(fieldValue,",");
					while(st.hasMoreTokens())
					{
						allCompFieldLists.add(st.nextToken());
					}
				}
			}

			StringTokenizer st = new StringTokenizer(xmsIPs,",");
			while(st.hasMoreTokens())
			{
				String xmsIP = st.nextToken();
				if(allCompFieldLists.contains(xmsIP))
				{
					dontDelete.add(xmsIP);
				}
				else
				{
					services.deleteValue(storagePlatform,xmsIP);
					xmsMapping.deleteSubject(xmsIP);

					auditLogThread.setCurrentValue("Deleted XMS IP/Host",xmsIP);
					success = true;
				}
			}
			services.saveFile();
			xmsMapping.saveFile();

			EgConfigFilesSync.releaseInstance(services);
			EgConfigFilesSync.releaseInstance(xmsMapping);

			if(success)
			{
				auditLogThread.setCurrentValue("ColumnName","Deleted XMS");
				auditLogThread.setValue("Description","The XMS IP/Hosts have been deleted");
				auditLogThread.sendItToDB();
			}

			if(dontDelete.size() == 0)
			{
				if(success)
				{
					rootJson.put("requestStatus","success");

					JSONObject resultMsg = new JSONObject();
					resultMsg.put("title",_mapping.getTextDescription("admin.discovery.Storage Platform Settings"));
					resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.XMS preference(s) deleted successfully"));
					rootJson.put("result",resultMsg);
				}
				else
				{
					rootJson.put("requestStatus","failed");

					JSONObject errorObj = new JSONObject();
					errorObj.put("title",_mapping.getTextDescription("admin.discovery.Storage Platform Settings"));
					errorObj.put("message1",_mapping.getTextDescription("admin.discovery.Error in XMS preference(s) deletion"));
					rootJson.put("errors",errorObj);
				}
			}
			else
			{
				String dontDeleteStr = dontDelete.toString();
				dontDeleteStr = dontDeleteStr.substring(1,dontDeleteStr.length() -1);
				rootJson.put("requestStatus","failed");

				JSONObject errorObj = new JSONObject();
				errorObj.put("title",_mapping.getTextDescription("admin.discovery.Storage Platform Settings"));
				errorObj.put("message1",_mapping.getTextDescription("admin.discovery.You cannot delete the following")+" XMS preference(s) "+dontDeleteStr+". "+_mapping.getTextDescription("admin.discovery.One/more tests have been configured to use on this Storage Platform Server"));
				rootJson.put("errors",errorObj);
			}
		}
	}

	out.println(rootJson.toString());

%>

