<%
/******************************************************************************
*	Name		:	EgTestInfo.jsp
*	Purpose		:	This page enlists all the tests currently
				running and also associated with some info.
				This also enables the admin user to select a
				particular test to enable or disable its
				associated info.
*	Version         :       1.0
*	CreationDate	:	10/08/2001
*	LastModified	:       
			10/08/2001
			11/08/2001			Added a method removeToken() to override info from db by info from file
			30/12/2003	Arun	Removes :NULL from server names

						THIS CODE HAS GENERIC QUERIES
*	Author		:	Bharath G
*	Design Changes		:		Jaiwin
******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="java.sql.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.util.Date"%>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import="com.eg.EgTestInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import ="egurkha.EgDbAdapterUI"%>
<%@ page import ="com.eg.EgDbAdapterTypeUI"%>
<%@ page import =" com.eg.EgRoleInfo"%> <!-- This is included by JJ -->
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.eg.EgDateInfo"%>

<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	EgDbAdapterUI egDb;
%>
<%!
	String arrayTimePeriod[]={"30 mins", "1 hour","3 hours","6 hours","12 hours","1 day","3 days","5 days","1 week","2 weeks","3 weeks","4 weeks","Any time"};
	long defaultValue = 60000;
%>
<jsp:useBean id="configBean" scope="request" class="egurkha.ConfigBean" />

<%
	User user=registry.getUser(session.getId());
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String whoami = "manager";
	EgSpecsInfo specsInfo = new EgSpecsInfo(whoami);
	EgDiscInfo discInfo = new EgDiscInfo(whoami);
	EgTestInfo testInfo = new EgTestInfo(whoami);
	EgRoleInfo egRoleInfo=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ
	String new_servers[] = egRoleInfo.getServerTypes();//JJ
	String server = request.getParameter("server");
	String comp = request.getParameter("comp");
	String [] serverTypes = null;
	String [] compList = null;

	String disabled = "";
	String selection = request.getParameter("duration");
	if(selection == null || selection.length() == 0)
	{
		selection = "1 week";
	}
	String onsubmit = request.getParameter("onsubmit");
	String userLanguage = "";
	long duration = 0l;
	if (selection!=null && !selection.equalsIgnoreCase("Default"))
	{
		if(selection.equals("30 mins"))
		{
			duration = 1 * 30 * defaultValue;
		}
		else if(selection.equals("1 hour"))
		{
			duration = 1 * 60 * defaultValue;
		}
		else if(selection.equals("3 hours"))
		{
			duration = 3 * 60 * defaultValue;
		}
		else if(selection.equals("6 hours"))
		{
			duration = 6 * 60 * defaultValue;
		}
		else if(selection.equals("12 hours"))
		{
			duration = 12 * 60 * defaultValue;
		}
		else if(selection.equals("1 day"))
		{
			duration = 24 * 60 * defaultValue;
		}
		else if(selection.equals("3 days"))
		{
			duration =  3 * 24 * 60 * defaultValue;
		}
		else if(selection.equals("5 days"))
		{
			duration = 5 * 24 * 60 * defaultValue;
		}
		else if(selection.equals("1 week"))
		{
			duration = 7 * 24 * 60 * defaultValue;
		}
		else if(selection.equals("2 weeks"))
		{
			duration = 2 * 7 * 24 * 60 * defaultValue;
		}
		else if(selection.equals("3 weeks"))
		{
			duration = 3 * 7 * 24 * 60 * defaultValue;
		}
		else if(selection.equals("4 weeks"))
		{
			duration = 4 * 7 * 24 * 60 * defaultValue;
		}
		else if(selection.equals("Any time"))
		{
			duration=0l;
		}
	}
// for db optimization 
	EgExternalInfo extInfo =new EgExternalInfo("manager");
	EgServicesInfo egserInfo = new EgServicesInfo("manager");
	String compB = "";
	boolean uniqueHostSystemData = egserInfo.isUniqueHostSystemData();
	Hashtable hash = extInfo.getInternalAgentMap();

	ResultSet rs = null;
	ResultSet rs1 = null;
	String[] ComponentsType=egRoleInfo.getServerTypes();
	ArrayList a_ComponentsType = new ArrayList();
	String [] s_arr = null;
	for(int z=0;z < ComponentsType.length;z++)
	{
		s_arr = egRoleInfo.getAllServersOfType(ComponentsType[z]);
		if(s_arr.length > 0)
		{
			a_ComponentsType.add(ComponentsType[z]);
		}
	}
	/*-----------This code for single and double byte language support------start-------*/
	String buttonWidth="";

	if(trackerLanguage!=null && (trackerLanguage.equals("en_US") || trackerLanguage.equals("ch_CH") || trackerLanguage.equals("ja_JP") || trackerLanguage.equals("ko_KR") || trackerLanguage.equals("th_TH")))
	{
		buttonWidth="width:110px;";
	}
	else if(trackerLanguage!=null && (trackerLanguage.equals("fr_FR") || trackerLanguage.equals("de_DE") || trackerLanguage.equals("es_ES") || trackerLanguage.equals("it_IT") || trackerLanguage.equals("pt_BR")))
	{
		buttonWidth="width:160px;";
	}
	/*-----------This code for single and double byte language support-----End--------*/
%>

<html>
<head>
<egui:skin ui = "admin"/>
<SCRIPT LANGUAGE="JAVASCRIPT">

function listselect()
{
	var thisForm = document.list;
	var serType = document.getElementById("servertypes").value
	if(serType == -1 || serType == "undefined")
		window.location.href = "EgTestInfo.jsp";
	else
		window.location.href = "EgTestInfo.jsp?server=" +encodeURI(serType);
}

function compselect()
{
	var thisForm = document.list;
	var serType = document.getElementById("servertypes").value
	var compType = document.getElementById("comptypes").value
	if(serType == -1)
		window.location.href = "EgTestInfo.jsp";
	else if(compType == -1)
		window.location.href = "EgTestInfo.jsp?server=" +encodeURI(serType);
	else
		window.location.href = "EgTestInfo.jsp?server=" +
				encodeURI(serType) +"&comp=" +encodeURI(compType);
}

</SCRIPT>

<script language="JavaScript1.2">
function dispalert()
{
	alert('<egui:intnl text="admin.test.Please select a component type"/>');
}
function timeselect()
{
	var thisForm = document.list;
	var serType = thisForm.servertypes.options
			[thisForm.servertypes.selectedIndex].value;
	var compType = thisForm.comptypes.options
			[thisForm.comptypes.selectedIndex].value;
	for(i=0;i< thisForm.timeperiod.length;i++)
	{
		if(thisForm.timeperiod[i].selected)
		{
			var val = thisForm.timeperiod[i].value;
		}
	}
	window.location.href = "EgTestInfo.jsp?server="+encodeURI(serType)+"&comp="+encodeURI(compType)+"&duration=" +encodeURI(val);
}
</script>
</head>

<!-- <body bgcolor="#FFFFFF" leftmargin="0" topmargin="20" marginwidth="0" marginheight="20"> -->

<body style="overflow:auto" id="space6" scroll="auto">
<form name="list" method="post" action="EgUpdateInfo.jsp" style="margin:0px">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
<%
	session.setAttribute("egPageDesc","EgTestInfo.jsp");
%>
	<jsp:include page="listSearch.jsp?title=AGENTS - TEST DESCRIPTORS&leftString=&subtitle=false&searchBox=false"/>
		<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" id="eg_subcontentbg">
<%
	if (a_ComponentsType.size()>0)
	{
%>
				<tr>
					<td width="7" height="6" class="eg_subcontentbg" id="inner_top_left"><img width="7" border="0" height="6" src="/final/admin/eg_images/spacer.gif"></td>
					<td width="100%" height="6" colspan="3" id="eg_subcontentbg"><img height="6" src="/final/admin/eg_images/spacer.gif"></td> 
					<td width="7" height="6" class="eg_subcontentbg" id="inner_top_right"><img width="7" border="0" height="6" src="/final/admin/eg_images/spacer.gif"></td>
				</tr>
				<tr>
					<td align="right" nowrap> &nbsp;&nbsp;&nbsp;<egui:intnl text="admin.test.Component type"/> : &nbsp;</td>
					<td align="left" nowrap height="20"> <select id='servertypes' name='servertypes' onchange='JavaScript:listselect()'> <option value="-1"><egui:intnl text="admin.common.Choose a server type"/></option>
<%
		server = (server != null)?server:"";	
		String s_tmp = "";
		ArrayList serverList = new ArrayList();

		for(int i=0; i< a_ComponentsType.size(); i++)
		{
			s_tmp = (String)a_ComponentsType.get(i);
			if(!s_tmp.equals("Site_servers"))
				serverList.add(s_tmp);
		}
		userLanguage = _user.getLanguage();
		IniUI  iniUI = IniUI.getInstance();
		if (userLanguage == null)
			userLanguage = iniUI.getDefaultLanguage();

		MappingNameSorter sorter = new MappingNameSorter(userLanguage);
		serverList = sorter.getSortedCompTypeList(serverList );

		for(int j=0;j<serverList.size();j++)
		{
			EgName nameObj = (EgName)serverList .get(j);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();

			if(tmpVal.equals(server))
			{
%>
					<option value="<%=tmpVal%>" selected><%=tmpDis%>
<%
			}
			else
			{
%>
					<option value="<%=tmpVal%>"><%=tmpDis%>
<%
			}
		}
%>
					</select>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
					<td>&nbsp; </td>
					<td align='right' nowrap><egui:intnl text="admin.test.Component name"/>&nbsp;:&nbsp;</td>
					<td valign='middle' style="width:300" id="form_spacing" class="paddingright" nowrap align="left"><select id='comptypes' name='comptypes' onchange='JavaScript:compselect();' style=' width:275px; '>
<%
		if(server == null || server.length() == 0)
		{
%>
						<option value="-1"><egui:intnl text="admin.test.No components"/></option> 
<%
		}
		else
		{
			compList = egRoleInfo.getAllServersOfType(server);
			if(compList == null || compList.length == 0)
			{
%>
						<option value="-1"><egui:intnl text="admin.test.No components"/></option>
<%
			}
			else
			{
%>
						<option value="-1"><egui:intnl text="admin.test.Select a component"/></option>
<%
				Vector v_final = new Vector();
				for (int i=0;i<compList.length;i++)
				{
					String s_tmpFinal = (String) compList[i];
					String s_temp = s_tmpFinal.substring(s_tmpFinal.indexOf(":")+1);
					v_final.add(s_temp + "@" + s_tmpFinal);
				}
				Collections.sort(v_final,String.CASE_INSENSITIVE_ORDER);
				for(int i=0; i<v_final.size(); i++)
				{
					String vectVal = (String) v_final.get(i);
					String dispVal =  vectVal.substring(0,vectVal.indexOf("@"));
					String optVal = vectVal.substring(vectVal.indexOf("@")+1);
					dispVal = Server.getServerNameWithoutPort(dispVal, false);
					if(comp != null)
					{
						if(optVal.equals(comp))
						{
%>
							<option value="<%= optVal %>" selected><%= dispVal%></option>
<%
							continue;
						}
					}
%>
							<option value="<%=optVal %>"><%= dispVal %></option>
<%
				}
			}
		}
%>
						</select>
					</td>

				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
				</tr>
			</table>
				
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" id="eg_subcontentbg">
				<tr>
					<td colspan="6" id="eg_blankspace" class="eg_whitebg" height="10" nowrap>
				</td>
				</tr>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td> 
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
<%
		if((server == null || server.length() == 0) || (comp == null || comp.length() == 0))
		{
			disabled = "disabled";
		}
%>
								<td colspan="2" class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
								<td align='right' width="50%" nowrap><egui:intnl text="admin.test.Show active descriptors for "/>&nbsp;:&nbsp;</td>
								<td valign='middle' width="50%" id="form_spacing" nowrap align="left">
									<select id='timeperiod' name='timeperiod' onchange='JavaScript:timeselect()' style='width:80px;' <%=disabled%>>
<%
				for(int ti=0;ti<arrayTimePeriod.length;ti++)
				{
					String timeDis = arrayTimePeriod[ti];
						if(timeDis.equals(selection))
						{
%>
							<option value="<%= arrayTimePeriod[ti] %>" selected ><%= arrayTimePeriod[ti]%></option>
<%
							}
							else
							{
%>
							<option value="<%= arrayTimePeriod[ti] %>" ><%= arrayTimePeriod[ti]%></option>
<%
							}
				}
%>
						</select>&nbsp;&nbsp;&nbsp;&nbsp;
					</td>
					<td class="eg_subcontentbg" width="30%" id="form_spacing">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
			<br>
		</td>
	</tr>
</table>
<%
	}else
	{
%>
<table cellspacing="0" cellpadding="0" border="0">
	<tr>
		<td align="center" width="10%" nowrap colspan="4" height="450" id="eg_errorsmall">
							<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br>
									&nbsp;&nbsp;&nbsp;<egui:intnl text="admin.test.No components available"/>
		</td>
	</tr>
</table>
<%
	}
%>
<%
		if(comp != null)
		{
%>
			<!-- Replacing Data/Table starts -->
			<table width='85%' align='center' cellspacing='0' cellpadding='0' border='0' class="eg_subhead" nowrap>
<%
			egDb=EgDbAdapterTypeUI.getObject();
			boolean isConnected = false;
			String status = egDb.setConnection();
			if(status.equals("CONNECTED"))
			{
				isConnected = true;
			}
			if(!isConnected)
			{
%>
				<tr>
					<td colspan="4" class="form_border" nowrap><center> <b><egui:intnl text="admin.test.Db connection failed"/> ! ! ! </b> </center></td>
				</tr>
<%
			}
			else
			{
				int ind = comp.indexOf(":");
				String compTy = comp.substring(0,ind);
				String compA = comp.substring(ind+1)+ ":" + comp.substring(0,ind);
				ind = compA.indexOf(":");
				String s_hostSysName = compA.substring(0, ind);
				if(uniqueHostSystemData && hash.containsKey(s_hostSysName))
					s_hostSysName =(String)hash.get(s_hostSysName);
				compB =s_hostSysName+ ":NULL:Host_system";
				String query;
				String measure_last_query="";
				EgDateInfo dateInfo = new EgDateInfo();
				java.text.SimpleDateFormat sdf=new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				Date  now = dateInfo.egetRealDate();
				long nowdateandtime = now.getTime();
				nowdateandtime-=duration;
				String convertDate = dateInfo.egetDate(nowdateandtime);
				if(EgDbInfo.isSqlAdapter)
				{
					query = "SELECT distinct(info), test_name " +
					"FROM metatest WITH (NOLOCK) WHERE comp_name + ':' + comp_type in ('" + compA + "','"+compB+"')";
				}
				else
				{
					query = "SELECT distinct(info), test_name " +
					"FROM metatest WHERE comp_name || ':' || comp_type in ('" + compA + "','"+compB+"')";
				}
				Hashtable ht = new Hashtable();
				Hashtable ht_measure_last = new Hashtable();
				ArrayList testAl = new ArrayList();
				ArrayList infoArrList = new ArrayList();
				ArrayList measure_last_test = new ArrayList();
				int j = 0;
				int q = 0;
				
				try
				{
					String nickName = compA.substring(0,compA.indexOf(":"));
					String port = "";
					if(compA.endsWith("Oracle_server"))
					{
						String msmtTemp = compA.substring(0,compA.indexOf(":Oracle_server"));
						port = msmtTemp.substring(msmtTemp.indexOf(":")+1,msmtTemp.lastIndexOf(":"));
					}
					else
					{
						port = compA.substring(compA.indexOf(":")+1,compA.lastIndexOf(":"));
					}
					rs = egDb.SelectExec(query);
					while(rs.next())
					{
						String test = rs.getString(2);	
						if(test.equals
							("WebSiteTransactionTest"))
							continue;
						if(test.equals
							("WebLogicEjbTest"))
							continue;
						if(test.equals
							("WsEjbTest"))
							continue;
						if(EgInstallInfo.isConfigTest(test))
							continue;
						String info = rs.getString(1);
						if(comp.startsWith("Oracle_server"))
						{
							ind = info.indexOf("+");
							info = info.substring(ind);
						}
						if(info.length() < 2)
							continue;
						j++;
						info = info.substring(1);
						infoArrList.add(info);
						int index = testAl.indexOf(test);
						if(index >= 0)
						{
							String temp = (String) ht.get(test);
							ht.put(test, temp+",  "+info);
							continue;
						}
						testAl.add(test);
						ht.put(test, info);
					}
					rs.close();
					if(duration > 0)
					{
						measure_last_query = egDb.getDetailsFromMeasureLast(nickName, port,"test");
						rs1 = egDb.SelectExec(measure_last_query);
						while(rs1.next())
						{
							String test = rs1.getString(1);	
							String trgt_host = rs1.getString(2);	
							String port_no = rs1.getString(3);	
							String msmt_time = rs1.getString(5);
							Date msmtDate =sdf.parse(msmt_time);
							long msmtDateandTime = msmtDate.getTime();
							if(nowdateandtime > msmtDateandTime)
								continue;
							if(test.equals
								("WebSiteTransactionTest"))
								continue;
							if(test.equals
								("WebLogicEjbTest"))
								continue;
							if(test.equals
								("WsEjbTest"))
								continue;
							if(EgInstallInfo.isConfigTest(test))
								continue;
							String info = rs1.getString(4);
							String sid = null;
							if(comp.startsWith("Oracle_server"))
							{
								ind = info.indexOf("+");
								sid = info.substring(0,ind);
								info = info.substring(ind);
							}
							if(info.length() < 2)
								continue;
							info = info.substring(1);
							if(!infoArrList.contains(info))
							{
								continue;
							}
							String keyVal = "";
							if(sid !=null && sid.length() > 0)
							{
								keyVal = test+"~|~"+trgt_host+":"+port_no+":"+sid;
							}
							else
							{
								keyVal = test+"~|~"+trgt_host+":"+port_no;
							}
							int index = measure_last_test.indexOf(keyVal);
							if(index >= 0)
							{
								String newValue = "";
								String tempKeyVal = (String) ht_measure_last.get(keyVal);
								if(tempKeyVal.indexOf(",") == -1 && tempKeyVal.endsWith(info))
								{
									Date existDate =sdf.parse(tempKeyVal.substring(0,tempKeyVal.indexOf("~|~")));
									long existDateandTime = existDate.getTime();
									if(existDateandTime > msmtDateandTime)
									{
										newValue = tempKeyVal;
									}
									else
									{
										newValue = msmt_time+"~|~"+info;
									}
									ht_measure_last.put(keyVal, newValue);
									continue;
								}
								else if(tempKeyVal.indexOf(",") != -1)
								{
									boolean isInfoMatch =false;
									StringTokenizer stVal = new StringTokenizer(tempKeyVal,",");
									while(stVal.hasMoreTokens())
									{
										String tempToken = (String) stVal.nextToken();
										if(tempToken.endsWith(info))
										{
											isInfoMatch = true;
											Date existDate =sdf.parse(tempToken.substring(0,tempToken.indexOf("~|~")));
											long existDateandTime = existDate.getTime();
											if(existDateandTime > msmtDateandTime)
											{
												newValue +=","+tempToken;
											}
											else
											{
												newValue +=","+msmt_time+"~|~"+info;
											}
										}
										else
										{
											newValue +=","+tempToken;
										}

									}
									if(isInfoMatch)
									{
										newValue = newValue.substring(1);
										ht_measure_last.put(keyVal, newValue);
										continue;
									}
									else
									{
										newValue = newValue.substring(1);
										ht_measure_last.put(keyVal, newValue+","+msmt_time+"~|~"+info);
										continue;
									}
								}
								else
								{
									ht_measure_last.put(keyVal, tempKeyVal+","+msmt_time+"~|~"+info);
									continue;
								}

							}
							measure_last_test.add(keyVal);
							ht_measure_last.put(keyVal, msmt_time+"~|~"+info);
						}
						rs1.close();
					}
					egDb.releaseConnection(false);
					EgDbAdapterTypeUI.releaseObject(egDb);
				}
				catch(Exception e)
				{
					if(rs != null)
						rs.close();
					if(rs1 != null)
						rs1.close();
					egDb.releaseConnection(true);
					EgDbAdapterTypeUI.releaseObject(egDb);
				}
				ArrayList al = testInfo.getTestInfoFor(compA, server);
				for(int k=0; k<al.size(); k++)
				{
					String str = (String) al.get(k);
					int in = str.indexOf("=");
					String test = str.substring(0, in);
					if(test.equals("WebLogicEjbTest"))
						continue;
					if(test.equals("WsEjbTest"))
						continue;
					String info = str.substring(in + 1);
					info = getSpace(info);
					if(ht.containsKey(test))
					{
						String tempInfo = (String) ht.get(test);
						tempInfo = removeToken(tempInfo, info);
						ht.put(test, tempInfo + "0eGHash1" + info);
						continue;
					}
					ht.put(test, "0eGHash1" + info);
				}
				String[] arrDefaultTests = specsInfo.getDefaultTestsForServer(server);
				List defaultTestslist = new ArrayList();
					// Check whether the test is related to its serverType / compType
				if (arrDefaultTests != null)
				{
					defaultTestslist = Arrays.asList(arrDefaultTests); 
					String strKey = "";
					Enumeration enumHtKeys = ht.keys();
					while(enumHtKeys.hasMoreElements())
					{
						strKey =(String) enumHtKeys.nextElement();
						if(!defaultTestslist.contains(strKey))
						{
							ht.remove(strKey);
						}
					}
				}
				Hashtable tempMeasureLast = new Hashtable();
				if(ht!=null && duration > 0)
				{
					Enumeration enumMeasureKeys = ht_measure_last.keys();
					while(enumMeasureKeys.hasMoreElements())
					{
						String strKeyMeasLast =(String) enumMeasureKeys.nextElement();
						String measTest = strKeyMeasLast.substring(0,strKeyMeasLast.indexOf("~|~"));
						String measCompType = strKeyMeasLast.substring(strKeyMeasLast.indexOf("~|~")+3);
						String sid = measCompType.substring(measCompType.indexOf(":")+1);
						String port = sid;
						if(!ht.containsKey(measTest) || !defaultTestslist.contains(measTest) || !compA.equalsIgnoreCase(measCompType))
						{
							String strNick = measCompType.substring(0,measCompType.indexOf(":"));
							measCompType +=":"+server;// measCompType
							String tempComp = strNick+":NULL:Host_system";
							if(!compA.equalsIgnoreCase(measCompType) && !compB.equalsIgnoreCase(tempComp))
							{
								ht_measure_last.remove(strKeyMeasLast);
								continue;
							}
							else if(sid.indexOf(":") != -1)
							{
								sid = sid.substring(sid.indexOf(":"))+":";
								if(compA.indexOf(sid) == -1)
								{
									ht_measure_last.remove(strKeyMeasLast);
									continue;
								}
							}
							if(!compA.equalsIgnoreCase(measCompType) || !compB.equalsIgnoreCase(tempComp))
							{
								if(port.indexOf(":") != -1)
								{
									port = port.substring(0,port.indexOf(":"));
								}
								if(specsInfo.isPortRelevantForTest(measTest) && port.equals("NULL"))
								{
									ht_measure_last.remove(strKeyMeasLast);
									continue;
								}
							}
						}
					}
					Iterator itrTempWithMeasTime =(ht_measure_last.keySet()).iterator();
					ArrayList aListTestsListWithMeasTime = new ArrayList();
					while(itrTempWithMeasTime.hasNext())
					{
						String tempTest = (String)itrTempWithMeasTime.next();
						aListTestsListWithMeasTime.add(tempTest);
					}
					for(int mt = 0;mt<aListTestsListWithMeasTime.size();mt++)
					{
						String strValMeasLast = (String) aListTestsListWithMeasTime.get(mt);
						String measLastTest = strValMeasLast.substring(0,strValMeasLast.indexOf("~|~"));
						if(ht.containsKey(measLastTest))
						{
							String tempTestValue = (String) ht_measure_last.get(strValMeasLast);
							ArrayList tempList = new ArrayList();
							if(tempTestValue.indexOf(",") != -1)
							{
								StringTokenizer st = new StringTokenizer(tempTestValue,",");
								while(st.hasMoreTokens())
								{
									String tempValue = (String) st.nextToken();
									tempList.add(tempValue);
								}
							}
							else
							{
								tempList.add(tempTestValue);
							}
							for(int i=0;i<tempList.size();i++)
							{
								String msmtInfo = (String) tempList.get(i);
								String msmt_info = msmtInfo.substring(msmtInfo.indexOf("~|~")+3);
								if(tempMeasureLast.containsKey(measLastTest))
								{
									String temp = (String) tempMeasureLast.get(measLastTest);
									tempMeasureLast.put(measLastTest,temp+",  "+msmt_info);
									continue;
								}
								tempMeasureLast.put(measLastTest,msmt_info);
							}
						}
					}
					ArrayList disabledAList = testInfo.getTestInfoFor(compA, server);
					for(int dis=0; dis<disabledAList.size(); dis++)
					{
						String disableData = (String) disabledAList.get(dis);
						int idx = disableData.indexOf("=");
						String disableTest = disableData.substring(0, idx);
						if(disableTest.equals("WebLogicEjbTest"))
							continue;
						if(disableTest.equals("WsEjbTest"))
							continue;
						String disableInfo = disableData.substring(idx + 1);
						disableInfo = getSpace(disableInfo);
						if(tempMeasureLast.containsKey(disableTest))
						{
							String tempDisableInfo = (String) tempMeasureLast.get(disableTest);
							tempDisableInfo = removeToken(tempDisableInfo, disableInfo);
							tempMeasureLast.put(disableTest, tempDisableInfo + "0eGHash1" + disableInfo);
							continue;
						}
						tempMeasureLast.put(disableTest, "0eGHash1" + disableInfo);
					}
				}
				if(duration > 0)   //for Any time period
				{
					ht = new Hashtable(tempMeasureLast);
				}
				if(ht.size() == 0)
				{
%>
				<tr>
					<td class="eg_whitebg" height="200" colspan="4">&nbsp; </td>
				</tr>
				<tr>
					<td id="eg_whitebg" nowrap height='25' colspan="4">
						<center> <img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><egui:intnl text="admin.test.No tests with descriptors for this component"/> !!! </center>
					</td>
				</tr>
<%
				}
				else
				{
					//sorting based on ui test name - starts
					Iterator itrTemp =(ht.keySet()).iterator();
					ArrayList aListTestsList = new ArrayList();
					while(itrTemp.hasNext())
					{
						String tempTest = (String)itrTemp.next();
						aListTestsList.add(tempTest);
					}
					MappingNameSorter sorter = new MappingNameSorter(userLanguage);
					aListTestsList = sorter.getSortedTestList(aListTestsList);
					//sorting based on ui test name - ends

					String test = null;
					String info = null;
					Iterator it = new TreeSet(ht.keySet()).iterator();
					int nameCount = 0;
					for (int k=0; k<aListTestsList.size(); k++)
					{
						EgName nameObj = (EgName)aListTestsList.get(k);
						test = nameObj.getActualName();
						info = (String)ht.get(test);
%>
				<tr>
					<td width="100%" background="eg_images/in_topleftbg.gif" id="eg_blankspace" height="10" colspan="4">&nbsp;</td>
				</tr>

				<tr>
					<td height="22" colspan="4">
						<table width="100%" border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td>
									<table align="center" border="0" cellpadding="0" cellspacing="0" height="22" width="100%">
										<tr>
											<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%">
												<table border="0" width="100%" cellpadding="0" cellspacing="0">
													<tr>
														<td width="90%"><b><egui:intnl test="<%= test %>"/></b> </td>
														<td width="10%"> <input type="button"  style="<%=buttonWidth%>;height: 20px;" class="eg_lightbutton" value='<egui:intnl text="admin.test.Enable / Disable"/>' onClick="javascript:window.location.href='EgUpdateInfo.jsp?server=<%=EgURLEncoder.encode(server,"UTF-8") %>&comp=<%=EgURLEncoder.encode(comp,"UTF-8") %>&duration=<%=EgURLEncoder.encode(selection,"UTF-8") %>&test=<%= test %>&from=testinfo'"></td>
													</tr>
												</table>
											</td>
											<td id="subhead_right" width="7" > <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										</tr>
									</table>	
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td align='left' colspan="4">
<%
						String enInfo = "";
						String disInfo = "";
						int r = info.indexOf("0eGHash1");
						int sepLen = "0eGHash1".length();
						if(r >= 0)
						{
							enInfo = info.substring(0, r);
							disInfo = info.substring(r+sepLen);
						}
						else
						{
							enInfo = info;
						}
						nameCount++;
						
						/* BEGIN code to sort disInfo */
						al = tokenizeInfo(disInfo);
						Object[] infoArray = al.toArray();
						Arrays.sort(infoArray, new Comparator()
						{
							public int compare(Object o1, Object o2)
							{
								return (((String) o1).toLowerCase().
								compareTo(((String) o2).toLowerCase()));
							}
						});
						
						disInfo = "";
						for(int i=0;i<infoArray.length;i++)
						{
							disInfo += infoArray[i] +", ";
						}
						if(disInfo != null && disInfo.length() != 0)
							disInfo = disInfo.substring(0,disInfo.length()-1);
						/* END code to sort disInfo */
%>
						<table width='100%' align='center' cellspacing='0' cellpadding='0' border='0' style="table-layout:fixed"><col width="10%"><col width="90%">
							<tr>
								<td width="10%" align='center' class="form_border" id="eg_subcontentbg" nowrap valign="top"><br><strong><egui:intnl text="admin.test.Enabled"/></strong></td>
								<td width="90%" align='left'  class="form_border" id="eg_subcontentbg" valign="top" ><%= breakString(enInfo,mappingInfo) %></td>
							</tr>
							<tr>
								<td width="10%" align='center' class="form_spacing" id="eg_subcontentbg" class="eg_subcontent" nowrap valign="top"><br><strong><egui:intnl text="admin.test.Disabled"/></strong></td>
								<td class="form_spacing" width="90%" align='left' id="eg_subcontentbg"> <%= breakString(disInfo,mappingInfo) %></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
<%
	session.setAttribute("tempMeasureLast",tempMeasureLast);
					}
				}
			}
%>

			</table>
			<br>
				<!-- Replicating Data/Table Ends -->
<%
		}
%>

		
</form>
</body>
</html>
<%!
	public String breakString(String str,EgMappingInfo mappingInfo)
	{
		if(str == null || str.length() == 0)
			return "<br>--"+" "+mappingInfo.getTextDescription("admin.test.None") +"--<br>";
			
		StringTokenizer st = new StringTokenizer(str, ",");
		int count = st.countTokens();
		if(count < 1)
			return "<br>--"+" "+mappingInfo.getTextDescription("admin.test.None") +"--<br>";
		String tmpStr = null;
		String finalStr = "";
		String nextStr = "";
		boolean add = false;
		for(int i=0; i<count; i++)
		{
			tmpStr = st.nextToken();  //.trim(); 
			if(tmpStr.length() + nextStr.length() < 140)
			{
				nextStr += tmpStr + ",";
			}
			else
			{
				if(nextStr.length() == 0)
				{
					nextStr = tmpStr;
					finalStr += nextStr + "&nbsp; ";
					nextStr = "";
				}
				else
				{
					finalStr += nextStr + "&nbsp; ";
					nextStr = tmpStr + ",";
					
				}
			}
		}

		finalStr += nextStr;
		if(finalStr.endsWith(","))
		{
			finalStr = finalStr.substring(0, finalStr.length()-1);
		}
		finalStr = "<br>"+ finalStr  +"<br>" ;
		return finalStr;
	}

	public ArrayList tokenizeInfo(String str)
	{
		ArrayList al = new ArrayList();
		StringTokenizer st = new StringTokenizer(str, ",");
		int count = st.countTokens();
		for(int i=0; i<count; i++)
		{
			al.add(st.nextToken().trim());
		}
		return al;
	}

	public String removeToken(String dbString, String fileString)
	{
		ArrayList dbAl = tokenizeInfo(dbString);
		ArrayList fileAl = tokenizeInfo(fileString);
		if(dbAl == null || dbAl.size() == 0)
			return dbString;
		if(fileAl == null || fileAl.size() == 0)
			return dbString;
		boolean changed = false;
		for(int i=0; i<dbAl.size(); i++)
		{
			String temp = (String) dbAl.get(i);
			if(fileAl.indexOf(temp) >= 0)
			{
				dbAl.remove(i);
				i--;
				changed = true;
			}
		}
		if(!changed)
			return dbString;
		String str = "";
		for(int i=0; i<dbAl.size(); i++)
		{
			str += (String) dbAl.get(i) + ", ";
		}
		if(str.length() > 1)
			str = str.substring(0, str.length()-2);
		return str;
	}

	public String getSpace(String str)
	{
		if(str == null || str.length() == 0)
			return "";
		StringTokenizer st = new StringTokenizer(str, ",");
		if(st.countTokens() == 0)
			return "";
		String temp = "";
		while(st.hasMoreTokens())
		{
			temp += st.nextToken() + ", ";
		}
		temp = temp.substring(0, temp.length()-2);
		return temp;
	}
%>
<%
	if(request.getQueryString()!=null)
		session.setAttribute("adminLastAccessedURL","/final/admin/EgTestInfo.jsp?"+request.getQueryString());
	else
		session.setAttribute("adminLastAccessedURL","/final/admin/EgTestInfo.jsp");
%>
