<%
/*****************************************************************************************************
*	Name			:	EgThreshDetail.jsp
*	Version			:	eG 4.0
*	Purpose			:	To display threshold details
*	Creation Date	:	01-02-2005.
*	Author			:	Thirumal Azhagan .T
*	Modifid			:	Monday, March 27, 2006 T.Thirumal Azhagan - UI Changes related to MIX policy.
*	Last Modified	:	Friday, March 31,2006 by James Thomas. P
*	Design Changes	:	Jaiwin
  *****************************************************************************************************/
%>

<%@ page errorPage = "EgProbs.jsp" %>
<%@ include file = "EgTrackerA.jsp" %>

<%@ page import = "java.io.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "com.eg.EgName" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgRoleInfo" %> <!-- JJ -->
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgTesterInfo" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgThresholdInfo" %>
<%@ page import = "com.eg.MappingNameSorter" %>
<%@ page import = "com.eg.EgServerGroupBean" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.pdfmaker.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.egurkha.util.StringUtils" %>

<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	EgDateInfo egDate = new EgDateInfo();
	EgServerGroupBean descGrp = new EgServerGroupBean();
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	ArrayList globalThresholds=testerInfo.getGlobalThresholds();
	//String date = egDate.egetDate();
	Vector v_con = new Vector();
	Vector contForparamAndData = new Vector();
	Hashtable h_container = new Hashtable();
	Hashtable hashForPDF = new Hashtable();
	String s_ForCmd = "Threshold";
	String s_forPdfTitle="";
	String defValue = "none";
	String[] val = new String[5];
	EgThresholdInfo threshInfo = new EgThresholdInfo("manager"); 
	EgDiscInfo disc_info = new EgDiscInfo("manager");
	EgSpecsInfo specs_info = new EgSpecsInfo("manager");
	EgTablesInfo tables_info=new EgTablesInfo("manager");
	List defaultPolicies=new ArrayList();
	defaultPolicies.add("immediate");
	defaultPolicies.add("shortterm");
	defaultPolicies.add("standard");
	defaultPolicies.add("longterm");
	defaultPolicies.add("not applicable");

	String uiFile = "eg_ui.ini";
	String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(iniFileDir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	Date date = new Date(System.currentTimeMillis());
	String currentDateTime = DateUtil.formatDate(date,currentDateFormat+" HH:mm:ss");

	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	EgRoleInfo egRoleInfo=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ

	String s_threshType = request.getParameter("eg_threshType");
	String s_compType = request.getParameter("eg_compType");
	String s_host = request.getParameter("eg_host");
	String req_test = request.getParameter("eg_test");
	String fromCompType = request.getParameter("fromCT");
	String onSubmitPage = request.getParameter("onSubmit");
	fromCompType=(fromCompType==null?"true":fromCompType);
	
	s_threshType = (!StringUtils.isNull(s_threshType) && s_threshType.length()>0 ? s_threshType:"");
	s_compType = (!StringUtils.isNull(s_compType) && s_compType.length()>0 ? s_compType:"");
	s_host = (!StringUtils.isNull(s_host) && s_host.length()>0 ? s_host:"");
	req_test = (!StringUtils.isNull(req_test) && req_test.length()>0 ? req_test:"");

	boolean isShowMeasWithoutThresholds = false;
	String showMeasWithoutThreshVal = egUI.getValue("MISC_ARGS","SHOW_MEASURES_WITHOUT_THRESHOLDS");
	if(!StringUtils.isNull(showMeasWithoutThreshVal) && showMeasWithoutThreshVal.equalsIgnoreCase("yes"))
	{
		isShowMeasWithoutThresholds = true;
	}

	if(fromCompType.equalsIgnoreCase("true"))
	{
		s_threshType = "All";
	}

	if(s_threshType==null)
	{
		s_threshType = "All";
	}
	if(req_test==null)
	{
		req_test="All";
	}

	String s_pdf = request.getParameter("PDF");
	String tmp=(String)request.getQueryString();
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String htmlFileName =mngrIProc+"/final/admin/EgPrintThreshDetailView.jsp;jsessionid="+session.getId()+"?"+tmp+"&print=pdfpage";
	session.setAttribute("PDF_URL",htmlFileName);
	session.setAttribute("REPORT_NAME","Thresholds_View");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");


	String arr_threshTypes[] = {"All","Descriptor","Specific","Group","Fixed","Default"};
	ArrayList thresholdTypes = new ArrayList(Arrays.asList(arr_threshTypes));
	Vector v_allComps = new Vector(disc_info.getAllManagedComponents());
	Vector v_compTypes = new Vector();
	Vector v_components = new Vector();
	Vector v_matchTypes = new Vector();
	ArrayList commonList = null;

	boolean isGlobalContainTest = false;
	boolean isGlobalContainAllTest = false;
	boolean isGlobalConSpecificTest = false;
	boolean isReqTestAll = req_test.equalsIgnoreCase("All");
	boolean global = (globalThresholds!=null && globalThresholds.size()>0);
	ArrayList serverList = null;
	
	String[] compTypes = egRoleInfo.getServerTypes();
	if (compTypes != null && compTypes.length >0)
	{
		for (int i=0;i<compTypes.length;i++)
		{
			ArrayList aListEnabledPTestForCompType = new ArrayList();
			aListEnabledPTestForCompType = specs_info.getEnabledTests(compTypes[i],false);
			if (aListEnabledPTestForCompType.size()>0 && !v_compTypes.contains(compTypes[i]))
			{
				v_compTypes.add(compTypes[i]);
			}
		}
	}

	if (v_compTypes != null && v_compTypes.size() > 0)
	{
		serverList = new ArrayList(v_compTypes);
		serverList = sorter.getSortedCompTypeList(serverList);
	}

//	if (s_compType == null)
//	{
//		if (v_compTypes != null && v_compTypes.size() > 0)
//		{
//			EgName nameObj = (EgName)serverList.get(0);
//			s_compType = nameObj.getActualName();
//		}
//		else
//		{
//			s_compType = "All";
//		}
//	}

	boolean isCompTypeAll = (s_compType != null && s_compType.equalsIgnoreCase("All"));

	if(!StringUtils.isNull(s_compType)  && !s_compType.equals("-1"))
	{
		if(global)
		{
			//if(!isCompTypeAll)
			{
				if(isReqTestAll)
				{
					String tests[] = specs_info.getTestsForServer(s_compType);
					commonList = new ArrayList(Arrays.asList(tests));
					isGlobalContainAllTest = globalThresholds.containsAll(commonList);
					isGlobalConSpecificTest = isListContainsTest(globalThresholds,commonList);
					isGlobalConSpecificTest = !isGlobalConSpecificTest;
				}
				else
				{
					isGlobalContainTest = globalThresholds.contains(req_test);
					isGlobalConSpecificTest = !isGlobalContainTest;
				}
				if(isGlobalContainAllTest || isGlobalContainTest)
				{
					thresholdTypes.clear();
					thresholdTypes.add("Fixed");
				}
				if(isGlobalConSpecificTest)
				{
					thresholdTypes.remove(thresholdTypes.indexOf("Fixed"));
				}
			}
		}
		else
		{
			thresholdTypes.remove(thresholdTypes.indexOf("Fixed"));
		}
	}

	if (!StringUtils.isNull(s_compType) && s_compType.equalsIgnoreCase("ALL"))
	{
		commonList = egRoleInfo.getAllServers();
	}
	else if(!StringUtils.isNull(s_compType) && !s_compType.equals("-1"))
	{
		String[] compsforType = egRoleInfo.getAllServersOfType(s_compType);
		commonList = new ArrayList(Arrays.asList(compsforType));
	}

	if(commonList != null && commonList.size() > 0)
	{
		for(int i = 0;i < commonList.size();i++)
		{
			String temp = (String)commonList.get(i);
			int ind = temp.indexOf(":");
			String s_compTy = temp.substring(0,ind);
			String s_compName = temp.substring(ind+1);
			v_components.add(s_compName);
			v_matchTypes.add(s_compTy+'#'+s_compName);
		}
	}

	Collections.sort(v_components,String.CASE_INSENSITIVE_ORDER);
	if (s_host == null)
	{
		if (v_components != null && v_components.size() > 0)
		{
			s_host = (String)v_components.get(0);
		}
		else
		{
			s_host = "All";
		}
	}
	
	// Updated by JJ
	Vector v_allTests = new Vector();
	boolean isAllCompType = false;

	if (!StringUtils.isNull(s_compType) && s_compType.equalsIgnoreCase("All"))
	{
		isAllCompType = true;
		for (int i=0; i<v_compTypes.size();i++)
		{
			String arr_tests[]= specs_info.getTestsForServer((String)v_compTypes.get(i));
			if (arr_tests !=null && arr_tests.length > 0)
			{
				for(int j=0;j<arr_tests.length;j++)
				{
					if(!v_allTests.contains(arr_tests[j]))
					{
						v_allTests.add(arr_tests[j]);
					}
				}
			}
		}
	}
	else if(!StringUtils.isNull(s_compType) && !s_compType.equals("-1"))
	{
		String arr_tests[]= specs_info.getTestsForServer(s_compType);
		if (arr_tests !=null && arr_tests.length > 0)
		{
			for(int j=0;j<arr_tests.length;j++)
			{
				if(!v_allTests.contains(arr_tests[j]))
				{
					v_allTests.add(arr_tests[j]);
				}
			}
		}
	}

	//remove config tests
	TestBean testBean = new TestBean(true);
	ArrayList configTests = testBean.getAllConfigTests();
	v_allTests.removeAll(configTests);

	TreeMap tm_threshData = new TreeMap();

	/*boolean isAllThresh = s_threshType.equalsIgnoreCase("All");
	boolean isDefaultThresh = isAllThresh || s_threshType.equalsIgnoreCase("Default");
	boolean isSpecificThresh = isAllThresh || s_threshType.equalsIgnoreCase("Specific");
	boolean isDescThresh = isAllThresh || s_threshType.equalsIgnoreCase("Descriptor");
	boolean isFixedThresh = isAllThresh || s_threshType.equalsIgnoreCase("Fixed");*/
	
	boolean isAllThresh = s_threshType.equalsIgnoreCase("All");
	boolean isDefaultThresh = s_threshType.equalsIgnoreCase("Default");
	boolean isDefThreshTemp = isDefaultThresh;
	boolean isSpecificThresh = s_threshType.equalsIgnoreCase("Specific");
	boolean isGroupThresh = s_threshType.equalsIgnoreCase("Group");
	boolean isDescThresh = s_threshType.equalsIgnoreCase("Descriptor");
	boolean isFixedThresh = s_threshType.equalsIgnoreCase("Fixed");
	boolean isFixThreshTemp =isFixedThresh;


	//***************For PDF Sub Title*****************

	boolean isCompTypeEnabled = !s_compType.equalsIgnoreCase("All");
	boolean isCompNameEnabled = !s_host.equalsIgnoreCase("All") && isCompTypeEnabled;
	boolean isTestNameEnabled = !req_test.equalsIgnoreCase("All") && isCompNameEnabled;

	if (isAllThresh)
	{
		if(isCompNameEnabled && isCompTypeEnabled && isTestNameEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+ ":" + removeNull(s_host) +": "+_mapping.getTestDescription(req_test)+" ("+ currentDateTime +")";
		else if (isCompNameEnabled && isCompTypeEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+ ":" +removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompNameEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component")+"  : " +removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompTypeEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component Type")+"  : " +_mapping.getComponentTypeDescription(s_compType) +" ("+ currentDateTime +")";
		else
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.All Components")+" ("+ currentDateTime +")";
	}
	else if(isDefaultThresh)
	{
		if(isCompNameEnabled && isCompTypeEnabled && isTestNameEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Default Settings for")+" "+_mapping.getComponentTypeDescription(s_compType)+ ":" + removeNull(s_host) +": "+_mapping.getTestDescription(req_test)+" ("+ currentDateTime +")";
		else if (isCompNameEnabled && isCompTypeEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Default Settings for")+" "+_mapping.getComponentTypeDescription(s_compType)+ ":" + removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompNameEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Default Settings for Component")+" "+ removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompTypeEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Default Settings for Component Type")+" "+ _mapping.getComponentTypeDescription(s_compType) +" ("+ currentDateTime +")";
		else
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Default Settings")+" ("+ currentDateTime +")";
	}
	else if(isSpecificThresh)
	{
		if(isCompNameEnabled && isCompTypeEnabled && isTestNameEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+ ":" + removeNull(s_host) +": "+_mapping.getTestDescription(req_test)+" ("+ currentDateTime +")";
		else if (isCompNameEnabled && isCompTypeEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+":"+ removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompNameEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component")+"  : "+ removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompTypeEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component Type")+"  : "+ _mapping.getComponentTypeDescription(s_compType) +" ("+ currentDateTime +")";
		else
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.All Specific Components")+" ("+ currentDateTime +")";
	}
	else if(isDescThresh)
	{
		if(isCompNameEnabled && isCompTypeEnabled && isTestNameEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+ ":" + removeNull(s_host) +": "+_mapping.getTestDescription(req_test)+" ("+ currentDateTime +")";
		else if (isCompNameEnabled && isCompTypeEnabled)
			s_forPdfTitle = _mapping.getComponentTypeDescription(s_compType)+":"+ removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompNameEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component")+"  : "+ removeNull(s_host) +" ("+ currentDateTime +")";
		else if(isCompTypeEnabled)
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.Component Type")+"  : "+ _mapping.getComponentTypeDescription(s_compType) +" ("+ currentDateTime +")";
		else
			s_forPdfTitle = _mapping.getTextDescription("admin.threshold.All Descriptor Components")+" ("+ currentDateTime +")";
	}
	else
		s_forPdfTitle =  _mapping.getTextDescription("admin.threshold.Threshold Report")+" ("+ currentDateTime +")";

	if(isCompNameEnabled && isCompTypeEnabled && isTestNameEnabled && s_forPdfTitle.length()>80)
		s_forPdfTitle=s_forPdfTitle.substring(0,s_forPdfTitle.lastIndexOf("("))+"\n ("+ currentDateTime +")";

	//new changes (13Jul2007)

	ArrayList selectedTests = new ArrayList(v_allTests);
	if(!StringUtils.isNull(req_test) && !req_test.equalsIgnoreCase("All"))
	{
		v_allTests.clear();
		v_allTests.add(req_test);
	}

	String[] userThreshvariables = null;
	if(isSpecificThresh || (isAllThresh))
	{
		userThreshvariables =  threshInfo.getUserThresholds();
		/*
		ArrayList userThreshTests = new ArrayList();
		for(int i=0; i<userThreshvariables.length; i++)
		{
			String variableLocal = userThreshvariables[i];
			if(variableLocal != null)
			{
				int pos = variableLocal.indexOf(":");
				if(pos >= 0)
				{
					String test = variableLocal.substring(0,pos);
					if(!userThreshTests.contains(test))
					{
						userThreshTests.add(test);
					}
				}
			}
		}
		v_allTests.retainAll(userThreshTests);
		*/
	}
	//end

	String finn = request.getParameter("fin");
	if (finn != null && finn.equals("yes"))
	{
		for(int i=0;i<v_allTests.size();i++)
		{
			String s_test = (String)v_allTests.get(i);
			boolean contain = global && globalThresholds.contains(s_test);
			boolean isAvailThreshVal = false;
			
			Vector v_data= new Vector();
			if(isAllThresh)
			{
				if(contain)
				{
					isFixedThresh = true;
					isDescThresh = false;
					isDefaultThresh = false;
					isSpecificThresh = false;
					isGroupThresh = false;
				}
				else
				{
					isDescThresh = true;
					isDefaultThresh = true;
					isSpecificThresh = true;
					isGroupThresh = true;
					isFixedThresh = false;
				}
			}
			else if (!isFixedThresh && contain)
			{
				continue;
			}
			//for Global Threshold (17 Jul 2007)
			if(isFixedThresh)
			{
				if(contain)
				{
					String s_val = threshInfo.getDefaultThresholdValue(s_test);
					if(s_val !=null && !s_val.equals(""))
					{
						isAvailThreshVal = isSetThresholdValues(s_val);
						if(isShowMeasWithoutThresholds || isAvailThreshVal)
						{
							v_data.add("Fixed");
							v_data.add(s_val);
						}
					}
				}
			}
			if(isDefaultThresh)
			{
				String s_val = threshInfo.getDefaultThresholdValue(s_test);
				if(s_val!=null && !s_val.equals(""))
				{
					isAvailThreshVal = isSetThresholdValues(s_val);
					if(isShowMeasWithoutThresholds || isAvailThreshVal)
					{
						v_data.add("Default");
						v_data.add(s_val);
					}
				}
			}

			if(isSpecificThresh || isDescThresh || isGroupThresh)
			{
				Vector v_comps = null;
				if(!s_host.equalsIgnoreCase("All"))
				{
					v_comps = new Vector();
					v_comps.add(s_host);
				}
				else
				{
					v_comps =(Vector) v_components.clone();
				}
				Vector v_specData = new Vector();
				Vector v_descData = new Vector();
				Vector v_allData = new Vector();
				for(int j=0;j<v_comps.size();j++)
				{
					if (j>=v_matchTypes.size())
						break;
					if (isAllCompType)
					{
						String t = (String) v_matchTypes.get(j);
						int ind = t.indexOf('#');
						t = t.substring(0,ind);
						if (!specs_info.isTestRelevantForServer (t,s_test) ||contain)
						{
							continue;
						}
					}
					String s_component = (String)v_comps.get(j);
					String s_userThreshKey = s_test;
					String s_descThreshKey = s_test;

					StringTokenizer st = new StringTokenizer(s_component,":");
					String s_cmp = st.nextToken();
					String s_port = st.nextToken();

					String s_sid = null;
					if(st.hasMoreTokens())
						s_sid = st.nextToken();

					boolean isPortRelevantForTest =specs_info.isPortRelevantForTest(s_test);
					boolean isInfoRelevantForTest =false;

					if (s_compType.equalsIgnoreCase("All"))
					{
						isInfoRelevantForTest = (s_sid!=null && specs_info.isInfoRelevantForTest(s_test));
					}
					else
					{
						isInfoRelevantForTest = (s_sid!=null && specs_info.isInfoRelevantForTest(s_test,s_compType));
					}
					if(isSpecificThresh)
					{
						String s_key = s_cmp;
						if(isPortRelevantForTest)
							s_key += ":" + s_port;
						if(isInfoRelevantForTest)
							s_key += ":" + s_sid;

						String s_title = s_key;
						if(v_specData.contains(s_title))
							continue;
						s_key = s_test + ":" + s_key;
						//************june 24******
						String s_val = "";

						//new change
						boolean check = false;
						if(userThreshvariables != null)
						{
							for(int inc=0; inc <userThreshvariables.length; inc++)
							{
								String localvar = userThreshvariables[inc];
								if(localvar != null && localvar.equals(s_key))
								{
									check = true;
									break;
								}
							}
						}
						//end
						if(check)
						{
							s_val = threshInfo.getUserThresholdValue(s_key);
						}
						//if(s_val == null || s_val.equals(""))
						//{
						//	s_val = descGrp.getThresholdsFromInfoGroupIni(s_key,false);
						//}
						//***********
						if(s_val!=null && !s_val.equals(""))
						{
							s_title = removeNull(s_title);
							if(isAllThresh)
							{
								s_title =s_title+" [Specific]" ;
							}
							isAvailThreshVal = isSetThresholdValues(s_val);
							if(isShowMeasWithoutThresholds || isAvailThreshVal)
							{
								v_specData.add(s_title);
								v_specData.add(s_val);
							}
						}
					}

					if(isDescThresh)
					{
						String s_key = s_cmp;
						String all_key="";
						String all_val="";
						String all_title="";
						if(isPortRelevantForTest)
							s_key += ":" + s_port;
						else
							s_key += ":NULL";
						if(isInfoRelevantForTest)
							s_key += ":" + s_sid;
						String s_title = "";//s_key;
						String inf = "";
						all_title = s_key;
						Vector v_info = threshInfo.getInfosForThresholds(s_test, s_key);
						s_key = s_test + ":" + s_key;
						all_key = s_key;
						if(v_info!=null && v_info.size()>0)
						{
							for(int k=0;k<v_info.size();k++)
							{
								String s_info = (String)v_info.get(k);
								if(s_info.indexOf('+')!=-1)
									s_info = s_info.substring(s_info.indexOf('+')+1);

								String s_orgKey = s_key + "#" + s_info;
								String s_val = "";
								s_val = threshInfo.getDescThresholdValue(s_orgKey);
								//if(s_val == null || s_val.equals(""))
								//{
								//	s_val = descGrp.getThresholdsFromInfoGroupIni(s_orgKey,false);
								//}
								if(s_val!=null && !s_val.equals(""))
								{
									s_title = s_key.substring(s_key.indexOf(":")+1);
									s_title = removeNull(s_title);
									String tmpInfo = s_info;
									if (tmpInfo.indexOf("0eGHash1") > -1)
									{
										tmpInfo = StringUtils.replace(tmpInfo,"0eGHash1","#");
									}
									s_title = s_title+"#" + tmpInfo;
									if(isAllThresh)
									{
										s_title =s_title+" [Descriptor]";
									}
									isAvailThreshVal = isSetThresholdValues(s_val);
									if(isShowMeasWithoutThresholds || isAvailThreshVal)
									{
										v_descData.add(s_title);
										v_descData.add(s_val);
									}
								}
							}
						}
						//if(v_allData.contains(all_title))
						//	continue;
						//all_val = descGrp.getThresholdsFromInfoGroupIni(all_key,false);
						//if(all_val!=null && !all_val.equals(""))
						//{
						//	all_title = removeNull(all_title);
						//	all_title =all_title+" [Group]";
						//	v_allData.add(all_title);
						//	v_allData.add(all_val);
						//}
					}// end of isDescThresh

					if(isGroupThresh)
					{
						String s_key = s_cmp;
						String grp_key="";
						String grp_val="";
						String grp_title="";
						if(isPortRelevantForTest)
							s_key += ":" + s_port;
						else
							s_key += ":NULL";
						if(isInfoRelevantForTest)
							s_key += ":" + s_sid;
						String s_title = "";//s_key;
						String inf = "";
						grp_title = s_key;
						//Vector v_info = threshInfo.getInfosForThresholds(s_test, s_key);
						s_key = s_test + ":" + s_key;
						grp_key = s_key;
						
						if(v_allData.contains(grp_title))
							continue;
						grp_val = descGrp.getThresholdsFromInfoGroupIni(grp_key,false);
						if(grp_val!=null && !grp_val.equals(""))
						{
							grp_title = removeNull(grp_title);
							grp_title =grp_title+" [Group]";
							isAvailThreshVal = isSetThresholdValues(grp_val);
							if(isShowMeasWithoutThresholds || isAvailThreshVal)
							{
								v_allData.add(grp_title);
								v_allData.add(grp_val);
							}
						}
					}// end of isDescThresh
				}
				if(v_specData.size()>0) v_data.addAll(v_specData);
				if(v_descData.size()>0) v_data.addAll(v_descData);
				if(v_allData.size()>0) v_data.addAll(v_allData);
			}
			if(v_data.size() > 0)
			{
				tm_threshData.put(s_test,v_data);
				for (int x=1;x<v_data.size();x+=2)
				{
					Vector v_tokens = new Vector();
					String tok = (String) v_data.get(x);
//					StringTokenizer strToken = new StringTokenizer(tok,",");
//					while (strToken.hasMoreTokens())
//					{
//						String tt = (String)strToken.nextToken();
//						StringTokenizer st1 = new StringTokenizer(tt,":");
//						v_tokens.add(st1.nextToken());
//						String s_policy = st1.nextToken();
//						v_tokens.add(st1.nextToken());
//						v_tokens.add(st1.nextToken());
//						v_tokens.add(s_policy);
//						v_tokens.add(st1.nextToken());
//					}
//System.out.println("[New VIew Thresholds]  tok  : "+v_tokens);
					v_data.setElementAt(tok,x);
				}
			}
		}
	}
%>
<egui:skin ui = "admin"/>
<html>
<title>Default Threshold</title>
<head>
<script language="JavaScript1.2" src="/final/admin/eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="javascript">
	function saveMe()
	{
		getPdf('<%=admin_Skin%>');
	}

	function callMe()
	{
		var pdf = "true";
		var thisForm = document.EgThresholdDetail;

		var comp_type = thisForm.eg_compType.options[thisForm.eg_compType.selectedIndex].value;
		var host = thisForm.eg_host.options[thisForm.eg_host.selectedIndex].value;
		var s_test = thisForm.eg_test.options[thisForm.eg_test.selectedIndex].value;
		var thresh = thisForm.eg_threshType.options[thisForm.eg_threshType.selectedIndex].value;
		if (comp_type == "-1")
		{
			alert('<egui:intnl text="admin.test.Please choose a component type"/>');
			return;
		}
		else if (host == "-1")
		{
			alert('<egui:intnl text="admin.test.Please choose a component"/>');
			return;
		}
		else if (s_test == "-1")
		{
			alert('<egui:intnl text="admin.test.Please choose a test"/>');
			return;
		}
		//thisForm.sub.value = '<egui:intnl text="admin.common.Submitting"/>...';
		//thisForm.sub.disabled = true;
		window.location.href = "EgThreshDetailView.jsp?fin=yes&eg_host="+encodeURI(host)+"&eg_compType="+encodeURI(comp_type)+"&eg_threshType="+encodeURI(thresh)+"&PDF="+pdf+"&eg_test="+encodeURI(s_test)+"&fromCT=false";
	}



	function threshSubmitSelect(action)
	{
		var thisForm = document.EgThresholdDetail;
		var url = "EgThreshDetailView.jsp?";
		var pdf = "true";

		if (action == 'submit')
		{
			var params = "";
			var tempurl = "";
			var comp_type = thisForm.eg_compType.options[thisForm.eg_compType.selectedIndex].value;
			var host = thisForm.eg_host.options[thisForm.eg_host.selectedIndex].value;
			var s_test = thisForm.eg_test.options[thisForm.eg_test.selectedIndex].value;
			var thresh = thisForm.eg_threshType.options[thisForm.eg_threshType.selectedIndex].value;
			if (comp_type == "-1")
			{
				alert('<egui:intnl text="admin.test.Please choose a component type"/>');
				return;
			}
			else if (host == "-1")
			{
				alert('<egui:intnl text="admin.test.Please choose a component"/>');
				return;
			}
			else if (s_test == "-1")
			{
				alert('<egui:intnl text="admin.test.Please choose a test"/>');
				return;
			}
			else if (thresh == "-1")
			{
				alert('<egui:intnl text="admin.test.Please choose a threshold type"/>');
				return;
			}
			//thisForm.sub.value = '<egui:intnl text="admin.common.Submitting"/>...';
			//thisForm.sub.disabled = true;
			var layerDIV = document.getElementById('testViewDet');
			var image_load="indicator_medium.gif";
			layerDIV.innerHTML = "<table width=100%><tr><td align=center ><img src=/final/monitor/eg_images/"+image_load+"></td></tr></table>";
			url = url+"fin=yes&onSubmit=true&eg_host="+encodeURI(host)+"&eg_compType="+encodeURI(comp_type)+"&eg_threshType="+encodeURI(thresh)+"&PDF="+pdf+"&eg_test="+encodeURI(s_test)+"&fromCT=false";
			createAJAX();
			if (url.indexOf("?") > -1)
			{
				params=url.substring(url.indexOf("?")+1);
				tempurl=url.substring(0,url.indexOf("?"));
			}
			else
			{
				tempurl=url;
			}
			xmlhttp.open('POST',tempurl,true);
			xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
			xmlhttp.setRequestHeader('Content-length',params.length);
			xmlhttp.setRequestHeader('Connection','close');
			xmlhttp.onreadystatechange = function() {
				if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
				{
					var response = xmlhttp.responseText;
					layerDIV.innerHTML =response;
				}
			}
			xmlhttp.send(params);
		}
	}

	function createAJAX() 
	{
		try
		{
			this.xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				this.xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (err)
			{
				this.xmlhttp = null;
			}
		}
		if (!this.xmlhttp && typeof XMLHttpRequest != "undefined")
			this.xmlhttp = new XMLHttpRequest();
		if (!this.xmlhttp)
		{
			this.connectionEstablished = false; 
		}
	}

	function goTo(op)
	{
		var thisForm = document.EgThresholdDetail;

		var comp_type = thisForm.eg_compType.options[thisForm.eg_compType.selectedIndex].value;
		var host = thisForm.eg_host.options[thisForm.eg_host.selectedIndex].value;
		var s_test = thisForm.eg_test.options[thisForm.eg_test.selectedIndex].value;
		var thresh = thisForm.eg_threshType.options[thisForm.eg_threshType.selectedIndex].value;
		if(comp_type == -1 || comp_type == "undefined")
		{
			window.location.href = "EgThreshDetailView.jsp?reqfrom=navlink";
		}
		else
		{
			window.location.href = "EgThreshDetailView.jsp?eg_compType="+encodeURI(comp_type);
		}
	}

	function printData()
	{
		parent.openWindow("/final/admin/EgPrintThreshDetailView.jsp?print=printpage","PrintWindow","width=1014,height=603,left=0,top=109,scrollbars=yes,resizable=no");
	}

	function call()
	{
		var sDownLoad = document.getElementById("download");
		if (sDownLoad != null && sDownLoad.style.display == 'block')
		{
			sDownLoad.style.display = 'none';
			sDownLoad.style.visibility = "hidden";
			document.EgThresholdDetail.sub.disabled = false;
		}
	}

	function csvData()
	{
		thisForm = document.forms[0];
		thisForm.action = '../servlet/com.eg.EgCSVController';
		thisForm.submit();
	}

	function savePdf(admin_Skin)
	{
		var blankPage = "";
		if(location.protocol=="https:") blankPage="/final/blank.html";
		var win=parent.openWindow(blankPage,"SaveWindow","width=400,height=150,left=300,top=200,scrollbars=no,resizable=no");
		win.document.write("<html>");
		win.document.write("<title>Downloading</title>");
		win.document.write("<frameset rows= '0%,0%,*' frameborter='NO' border='0' framespacing='0'>");
		win.document.write("<frame src='/final/servlet/com.eg.EgPdfDownloadC' frameborder=0 noresize scrolling=no name='Data'>");
		win.document.write("<frame src='/final/admin/EgSaveStatus.jsp' frameborder=0 noresize scrolling=auto>");
		win.document.write("<frame src='" + blankPage + "' frameborder=0 noresize scrolling=auto name='statusPanel'>");
		win.document.write("</frameset>");
		win.document.write("</html>");
		win.frames[2].document.open("text/html","replace");
		win.frames[2].document.write('<html><head>');
		win.frames[2].document.write('<link rel="stylesheet" href="/final/admin/eg_styles/adminstyle_'+admin_Skin+'.css" />');
		win.frames[2].document.write('</head><body id="eg_morelight"><br><br><h4 align="center" style="font-family: Verdana,Arial; font-size: 15px; color: #000000;"><img src="/final/reporter/images/load_round.gif"><br><br>Downloading! Please wait...</h4></body></html>');
		win.frames[2].document.close();
	}


	function compselect()
	{
		var thisForm = document.EgThresholdDetail;
		var comp_type = thisForm.eg_compType.options[thisForm.eg_compType.selectedIndex].value;
		var host = thisForm.eg_host.options[thisForm.eg_host.selectedIndex].value;
		var s_test = thisForm.eg_test.options[thisForm.eg_test.selectedIndex].value;
		var thresh = thisForm.eg_threshType.options[thisForm.eg_threshType.selectedIndex].value;
		if(comp_type == -1)
		{
			window.location.href = "EgThreshDetailView.jsp?reqfrom=navlink";
		}
		else if(comp_type != -1 && host == -1)
		{
			window.location.href = "EgThreshDetailView.jsp?eg_compType="+encodeURI(comp_type);
		}
		else
		{
			window.location.href = "EgThreshDetailView.jsp?eg_compType="+encodeURI(comp_type)+"&eg_host="+encodeURI(host);
		}
	}

	function testselect()
	{
		var thisForm = document.EgThresholdDetail;
		var comp_type = thisForm.eg_compType.options[thisForm.eg_compType.selectedIndex].value;
		var host = thisForm.eg_host.options[thisForm.eg_host.selectedIndex].value;
		var s_test = thisForm.eg_test.options[thisForm.eg_test.selectedIndex].value;
		var thresh = thisForm.eg_threshType.options[thisForm.eg_threshType.selectedIndex].value;
		if(comp_type == -1)
		{
			window.location.href = "EgThreshDetailView.jsp?reqfrom=navlink";
		}
		else if(comp_type != -1 && host == -1)
		{
			window.location.href = "EgThreshDetailView.jsp?eg_compType="+encodeURI(comp_type);
		}
		else if(comp_type != -1 && host != -1 && s_test == -1)
		{
			window.location.href = "EgThreshDetailView.jsp?eg_compType="+encodeURI(comp_type)+"&eg_host="+encodeURI(host);
		}
		else 
		{
			window.location.href = "EgThreshDetailView.jsp?eg_compType="+encodeURI(comp_type)+"&eg_host="+encodeURI(host)+"&eg_test="+encodeURI(s_test)+"&fromCT=false";
		}
	}
	function threshselect()
	{
		var thisForm = document.EgThresholdDetail;
		var comp_type = thisForm.eg_compType.options[thisForm.eg_compType.selectedIndex].value;
		var host = thisForm.eg_host.options[thisForm.eg_host.selectedIndex].value;
		var s_test = thisForm.eg_test.options[thisForm.eg_test.selectedIndex].value;
		var thresh = thisForm.eg_threshType.options[thisForm.eg_threshType.selectedIndex].value;
		if(comp_type == -1)
		{
			window.location.href = "EgThreshDetailView.jsp?reqfrom=navlink";
		}
		else if(comp_type != -1 && host == -1)
		{
			window.location.href = "EgThreshDetailView.jsp?eg_compType="+encodeURI(comp_type);
		}
		else if(comp_type != -1 && host != -1 && s_test == -1)
		{
			window.location.href = "EgThreshDetailView.jsp?eg_compType="+encodeURI(comp_type)+"&eg_host="+encodeURI(host);
		}
		else if(comp_type != -1 && host != -1 && s_test != -1 && thresh == -1)
		{
			window.location.href = "EgThreshDetailView.jsp?eg_compType="+encodeURI(comp_type)+"&eg_host="+encodeURI(host)+"&eg_test="+encodeURI(s_test);
		}
		else
		{
			window.location.href = "EgThreshDetailView.jsp?eg_compType="+encodeURI(comp_type)+"&eg_host="+encodeURI(host)+"&eg_test="+encodeURI(s_test)+"&eg_threshType="+encodeURI(thresh)+"&fromCT=false";
		}
	}
</script>
</head>
<%
	if (onSubmitPage == null)
	{
%>

<body style="overflow:auto" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onLoad="call();">
<form name="EgThresholdDetail" method="post" action="EgThreshDetail.jsp" style="margin:0px">
<input type="hidden" name="threshDisp" value="">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">

	<jsp:include page='<%="listSearch.jsp?title=THRESHOLDS VIEW&leftString=Add User&backButton=false&subtitle=false"%>'/>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="6"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td class="eg_subcontentbg" id="form_border">&nbsp; </td> 
					<td align="left" width="130" class="eg_subcontentbg" nowrap height="20" id="form_border">&nbsp;<egui:intnl text="admin.threshold.Component type "/></td>
					<td width="5" class="eg_subcontentbg" id="form_border">:</td>
					<td class="eg_subcontentbg" id="form_border"> &nbsp;&nbsp;&nbsp;&nbsp; <select name="eg_compType" onChange ='javascript:goTo("comptype")' style='width:220px;'>
<%
	if(v_compTypes.size() == 0)
	{
%>
						<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}
	else
	{
%>
						<option value="-1"><egui:intnl text="admin.common.Choose a component type"/></option>
<%
		for(int i=0;i<serverList.size();i++)
		{
			EgName nameObj = (EgName)serverList.get(i);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();
			if(tmpVal.equals(s_compType))
			{
%>
						<option value="<%=tmpVal%>" selected><%=tmpDis%></option>
<%
			}
			else
			{
%>
						<option value="<%=tmpVal%>"><%=tmpDis%></option>
<%
			}
		}
	}
%>
					</select>
					</td>
					<td align="left" class="eg_subcontentbg" nowrap height="20" id="form_border" width="130">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<egui:intnl text="admin.threshold.Component name"/></td>
					<td class="eg_subcontentbg" id="form_border">:</td>
					<td class="eg_subcontentbg" id="form_border">&nbsp;&nbsp;&nbsp;&nbsp;
					<select name="eg_host" style='width:190px;' onChange ='javascript:compselect()'>
<%
	String s_tmpname="";
	String s_tmpname1 = "";
	if(v_compTypes.size() == 0)
	{
%>
						<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}
	else
	{
		if(v_components == null || v_components.size() == 0)
		{
%>
						<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>

<%
		}
		else
		{
%>
						<option value="-1"><egui:intnl text="admin.test.Select a component"/></option>
<%
			if(v_components.size() > 1)
			{
%>
						<option value="All" <%=(s_host.equals("All"))?"selected":""%>><egui:intnl text="admin.common.All"/></option>
<%
			}

			for(int i=0;i<v_components.size();i++)
			{
				s_tmpname=(String)v_components.get(i);
				//new change
				if(s_tmpname.lastIndexOf(":") >= 0)
				{
					s_tmpname1 = s_tmpname.substring(s_tmpname.lastIndexOf(":")+1);
					if(s_tmpname1 != null && s_tmpname1.equalsIgnoreCase("NULL"))
					{
						s_tmpname1 = s_tmpname.substring(0,s_tmpname.lastIndexOf(":"));
					}
					else
						s_tmpname1 = s_tmpname;
				}
				else
					s_tmpname1 = s_tmpname;
				if(s_tmpname.equals(s_host))
				{
%>
							<option value="<%=s_tmpname%>" selected><%=s_tmpname1%></option>
<%
				}
				else
				{
%>
							<option value="<%=s_tmpname%>"><%=s_tmpname1%></option>
<%
				}
			}
		}
	}
%>
					</select>
					</td>
					<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
				</tr>

				<tr>
					<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
					<td align="laft" width="130" class="eg_subcontentbg" nowrap height="20" id="form_spacing">&nbsp;<egui:intnl text="admin.threshold.Test name"/></td><td class="eg_subcontentbg" id="form_spacing">:</td>
					<td class="eg_subcontentbg" id="form_spacing"> &nbsp;&nbsp;&nbsp;&nbsp;
						<select name="eg_test" style='width:220px;' onchange="javascript:testselect();">
<%
	if(v_compTypes.size() == 0)
	{
%>
							<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}
	else if(StringUtils.isNull(s_host) || s_host.equals("-1"))
	{
%>
							<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>

<%
	}
	else if (!isAllCompType || v_components.size() == 1)
	{
		if(selectedTests.size()>0)
		{
%>
					<option value="-1"><egui:intnl text="admin.test.Select a test name"/></option>
					<option value="All" <%=req_test.equalsIgnoreCase("All")?"selected":""%>><egui:intnl text="admin.threshold.All"/></option>
<%
		}
		else if(selectedTests.size() == 0)
		{
%>
							<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%

		}
			ArrayList sortedTestList = new ArrayList(selectedTests);
			sortedTestList = sorter.getSortedTestList(sortedTestList);
			for(int i=0;i<sortedTestList.size();i++)
			{
				EgName nameObj = (EgName)sortedTestList.get(i);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();
%>
							<option value="<%=tmpVal%>" <%=(req_test.equalsIgnoreCase(tmpVal))?"selected":""%>><%=tmpDis%></option>
<%			}
	}
	else
	{
%>
							<option value="All"><egui:intnl text="admin.threshold.All"/></option>
<%
	}
%>
						</select>
					</td>
					<td align="left" width="130" class="eg_subcontentbg" nowrap height="20" id="form_spacing">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<egui:intnl text="admin.threshold.Threshold"/></td>
					<td class="eg_subcontentbg" id="form_spacing">:</td>
					<td class="eg_subcontentbg" id="form_spacing"> &nbsp;&nbsp;&nbsp;&nbsp;
						<select name="eg_threshType" style='width:190px;' onchange="javascript:threshselect();">
<%
	if(v_compTypes.size() == 0)
	{
%>
						<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
	}
	else
	{
		if(StringUtils.isNull(req_test) || req_test.equals("-1")) 
		{

%>
					<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}
		else
		{
%>
					<option value="-1"><egui:intnl text="admin.test.Select a threshold type"/></option>
<%
			arr_threshTypes = (String[])thresholdTypes.toArray(new String[0]);
			for (int x=0;x<arr_threshTypes.length;x++)
			{
				String threshTypeVal = arr_threshTypes[x];
				if (threshTypeVal.equalsIgnoreCase(s_threshType))
				{
%>
							<option value="<%=threshTypeVal%>" selected> <%=threshTypeVal%></option>
<%
				}
				else
				{
%>
							<option value="<%=threshTypeVal%>"><%=threshTypeVal%></option>
<%
				}
			}
		}
	}
%>
<%
						//out.println(HtmlUtils.setSelectOptions(arr_threshTypes, s_threshType));
%>
						</select>
					</td>
					<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="6" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td height="10" id="eg_blankspace">&nbsp;</td>
				</tr>
<%
	String disabled = "";
	if(v_compTypes.size() == 0)
	{
		disabled = "disabled";
	}
%>
				<tr>
					<td colspan="8" align="center" id="eg_subhead"  nowrap height="20"><input type="button" name="sub" value='<egui:intnl text="admin.threshold.Submit"/>' style="width: 80px;" id="eg_back" onClick="javascript:threshSubmitSelect('submit')" <%=disabled%>></td>
				</tr>
				<tr>
					<td colspan="8" height="370" valign="top">
						<div id="testViewDet" style="position:relative;width:100%;border:0px solid #ff0000; height:370px"></div>
						<!-- <td colspan="3" height="390" width="100%"> -->
					</td>
				</tr>

			</table>
		</td>
	</tr>
	<tr>
		<td id="eg_blankspace" height="10">&nbsp;</td>
	</tr>
</table>

<%
		if(request.getQueryString()!=null)
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgThreshDetailView.jsp?"+request.getQueryString());
		}
		else
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgThreshDetailView.jsp");
		}
	}
	else if(!StringUtils.isNull(onSubmitPage) && onSubmitPage.equals("true"))
	{
%>
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<tr>
		<td>
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed">
<%
	if (s_pdf != null && s_pdf.equalsIgnoreCase("true") && tm_threshData.size()>0)
	{
%>
				<tr>
					<td width="100%">
						<table cellspacing="0" cellpadding="3" width="100%" border="0">
							<tr>
								<td align="left" width="100%" id="eg_title">&nbsp;</td>
								<td align="right" valign="middle" width="25"><a class="head"><img class="mouse" src="/final/admin/eg_images/<%=admin_Skin%>/print_audit.gif" border="0" title="PRINT" onClick="javascript:printData();"></a></td>
								<td  width="25" nowrap align="center"><a class="head"><img class="mouse" src="../admin/eg_images/<%=admin_Skin%>/pdf_audit.gif" border="0" title="SAVE" onClick="javascript:savePdf('<%=admin_Skin%>');"></a></td>
								<td  width="25" nowrap><a class="head"><img class="mouse" src="../admin/eg_images/<%=admin_Skin%>/csv_audit.gif" border="0" title="CSV" onClick="javascript:csvData();"></a></td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}

	//ArrayList printData = new ArrayList();
	//printData.add(s_forPdfTitle);
	if (finn != null && finn.equals("yes"))
	{
		if(tm_threshData.size() > 0)
		{
			// pdf work
			ArrayList tableList = new ArrayList();
			EgPdfData pdfData = new EgPdfData();
			EgReportAttributes reportAttributes = new EgReportAttributes();
			reportAttributes.setMainTitle(mappingInfo.getTextDescription("admin.threshold.Threshold Report"));
			reportAttributes.setSubTitle(s_forPdfTitle);
			reportAttributes.setReportName("Threshold");
			reportAttributes.setModule("ADMIN");
			reportAttributes.setPortrait(true);
			pdfData.setAttributes(reportAttributes);
			Iterator itr = tm_threshData.keySet().iterator();
			while(itr.hasNext())
			{
				String key = (String) itr.next();
				String HYPHEN = "";
				Vector v_title =(Vector) tm_threshData.get(key);
				//recent change
				if(v_title.size() == 2)
				{
					HYPHEN = " - ";
				}
%>
				<tr>
					<td colspan="6" nowrap>
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
								<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"> <b><egui:intnl test="<%=key%>" />
								</b> </td>
								<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td colspan="6" id="table_border" class="padding6 eg_morelight">
<%
				for (int x=0;x<v_title.size();x+=2)
				{
%>
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
<%
					String title = (String) v_title.get(x);
					if(title.equalsIgnoreCase("Default"))
						title = mappingInfo.getTestDescription(key);
					else if (title.equalsIgnoreCase("Fixed"))
						title = mappingInfo.getTestDescription(key)+" ["+_mapping.getTextDescription("admin.threshold.Fixed")+"]";
					else
						title = mappingInfo.getTestDescription(key) + ":" +title;
					//pdf work
					ArrayList aListData = new ArrayList();

					//recent change
					if(v_title.size() > 2)
					{
						if (x > 0)
						{
%>
							<tr><td>&nbsp;</td></tr>
<%
						}
%>
							<tr>
								<td colspan="6" width="98%" nowrap style="border-bottom-width:0px;border-left-width:1px" class="space3"><b><%=((String)v_title.get(x)).toUpperCase()%></b></td>
							</tr>
<%
					}

					String v_data1 = (String)v_title.get(x+1);
%>
				<tr>
					<td>
						<table align="center" width="95%" cellspacing="0" cellpadding="0" border="0"><col width="auto"><col width="65%"><col width="15%">
<%
		// CSV work starts
		ArrayList aListColumnNames = new ArrayList();
		for(int k=0; k<6; k++) aListColumnNames.add("C"+k);

		ArrayList userColumnNames = new ArrayList();
		userColumnNames.add(_mapping.getTextDescription("admin.threshold.Measurements"));
		userColumnNames.add(_mapping.getTextDescription("admin.threshold.Min/Max"));
		userColumnNames.add(_mapping.getTextDescription("admin.threshold.Critical"));
		userColumnNames.add(_mapping.getTextDescription("admin.threshold.Major"));
		userColumnNames.add(_mapping.getTextDescription("admin.threshold.Minor"));
		userColumnNames.add(_mapping.getTextDescription("admin.threshold.Alarm Policy"));

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		egTableAttributes.setTitle(title);
		egTableAttributes.setStartX(0);
		egTableAttributes.setColumnNames(userColumnNames);
		//CSV work ends

		boolean heading_flag = false;
		ArrayList aListTestWithNoThresholds = new ArrayList();
		boolean cellFlag = false;
		StringTokenizer st = new StringTokenizer(v_data1,",");
		while (st.hasMoreTokens())
		{
			String strTok = st.nextToken();
			StringTokenizer st1 = new StringTokenizer(strTok,":");
			while (st1.hasMoreTokens())
			{
				String measure = st1.nextToken();
				String policy = st1.nextToken();
				String min = st1.nextToken();
				String max = st1.nextToken();
				String alarmPolicy = st1.nextToken();
				String lastToken = st1.nextToken();

				String absMinCritical = "-";
				String relMinCritical = "-";

				String absMinMajor = "-";
				String relMinMajor = "-";

				String absMinMinor = "-";
				String relMinMinor = "-";

				String absMaxCritical = "-";
				String relMaxCritical = "-";

				String absMaxMajor = "-";
				String relMaxMajor = "-";

				String absMaxMinor = "-";
				String relMaxMinor = "-";

				if (policy.equalsIgnoreCase("none"))
				{
					policy = "mix";
				}
				else if (policy.equalsIgnoreCase("absolute"))
				{
					if (!min.equals("-1"))
					{
						StringTokenizer stAbsMin = new StringTokenizer(min,"/");
						absMinCritical = stAbsMin.nextToken();
						absMinMajor = stAbsMin.nextToken();
						absMinMinor = stAbsMin.nextToken();
					}

					if (!max.equals("-1"))
					{
						StringTokenizer stAbsMax = new StringTokenizer(max,"/");
						absMaxCritical = stAbsMax.nextToken();
						absMaxMajor = stAbsMax.nextToken();
						absMaxMinor = stAbsMax.nextToken();
					}
				}
				else if (policy.equalsIgnoreCase("relative"))
				{
					if (!min.equals("-1"))
					{
						StringTokenizer stRelMin = new StringTokenizer(min,"/");
						relMinCritical = stRelMin.nextToken();
						relMinMajor = stRelMin.nextToken();
						relMinMinor = stRelMin.nextToken();
					}

					if (!max.equals("-1"))
					{
						StringTokenizer stRelMax = new StringTokenizer(max,"/");
						relMaxCritical = stRelMax.nextToken();
						relMaxMajor = stRelMax.nextToken();
						relMaxMinor = stRelMax.nextToken();
					}
				}
				else if (policy.equalsIgnoreCase("mix"))
				{
					Vector vec = getAbsAndRel(min);
					String absA = (String) vec.get(0);
					String relA = (String) vec.get(1);
					Vector vec1 = getAbsAndRel(max);
					String absB = (String) vec1.get(0);
					String relB = (String) vec1.get(1);

					if (!absA.equals("none"))
					{
						StringTokenizer stmixMin = new StringTokenizer(absA,"/");
						absMinCritical = stmixMin.nextToken();
						absMinMajor = stmixMin.nextToken();
						absMinMinor = stmixMin.nextToken();
					}

					if (!absB.equals("none"))
					{
						StringTokenizer stmixMax = new StringTokenizer(absB,"/");
						absMaxCritical = stmixMax.nextToken();
						absMaxMajor = stmixMax.nextToken();
						absMaxMinor = stmixMax.nextToken();
					}

					if (!relA.equals("none"))
					{
						StringTokenizer stRelMin = new StringTokenizer(relA,"/");
						relMinCritical = stRelMin.nextToken();
						relMinMajor = stRelMin.nextToken();
						relMinMinor = stRelMin.nextToken();
					}

					if (!relB.equals("none"))
					{
						StringTokenizer stmixMax = new StringTokenizer(relB,"/");
						relMaxCritical = stmixMax.nextToken();
						relMaxMajor = stmixMax.nextToken();
						relMaxMinor = stmixMax.nextToken();
					}
				}

				String minCritical = getThresholdValue("min",absMinCritical,relMinCritical);
				String minMajor = getThresholdValue("min",absMinMajor,relMinMajor);
				String minMinor = getThresholdValue("min",absMinMinor,relMinMinor);

				String maxCritical = getThresholdValue("max",absMaxCritical,relMaxCritical);
				String maxMajor = getThresholdValue("max",absMaxMajor,relMaxMajor);
				String maxMinor = getThresholdValue("max",absMaxMinor,relMaxMinor);

				if (minCritical.equals("-")  && minMajor.equals("-") && minMinor.equals("-") && 
				maxCritical.equals("-") && maxMajor.equals("-") && maxMinor.equals("-"))
				{
					aListTestWithNoThresholds.add(measure);
					cellFlag = !cellFlag;
					continue;
				}

				if (!heading_flag)
				{
					heading_flag = true;
%>
				<!-- Heading -->
				<tr>
					<td align="center" class="lineright padding4 table_head">Measure</td>
					<td align="center" style="padding:0px">
						<table cellpadding="0" cellspacing="0" border="0" width="100%"><col width="19%"><col width="27%"><col width="27%"><col width="27%">
							<tr>
								<td align="center" class="lineright padding4 table_head">Min/Max</td>
								<td align="center" class="lineright padding4 table_head">Critical</td>
								<td align="center" class="lineright padding4 table_head">Major</td>
								<td align="center" class="lineright padding4 table_head">Minor</td>
							</tr>
						</table>
					</td>
					<td class="padding4 table_head" align="center">Alarm Policy</td>
				</tr>
<%
				}
				String unit = tables_info.getUnitForMeasure(key,measure);
%>
				<tr>
					<td align="left" valign="middle" id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="padding4" style="border-left-width:1px">
						<table cellpadding="0" cellspacing="0" border="0" width="100%">
							<tr>
								<td width="95%" valign="middle" nowrap><%=mappingInfo.getMeasureDescription(key,measure)%>
								</td>
								<td class="eg_7">&nbsp;<i>(<%=unit%>)</i>&nbsp;</td>
							</tr>
						</table>
					</td>
					<td align="left" valign="top" id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="padding4" >
						<table cellpadding="0" cellspacing="0" border="0" width="100%" class="tableborder_ad"><col width="19%"><col width="27%"><col width="27%"><col width="27%" >
<%
//				String measurePdf = mappingInfo.getMeasureDescription(key,measure);
				String measurePdf = mappingInfo.getMeasureDescription(key,measure) + " (" + tables_info.getUnitForMeasure(key,measure) + ")";
				aListData.add(measurePdf);
				boolean enterMinPart = false;
				boolean enterMaxPart = false;
				if(!minCritical.equals("-") || !minMajor.equals("-") || !minMinor.equals("-"))
				{
%>
							<tr class="linebottom">
								<td align="center" class="padding4 tdborder_ad"><b>Min</b></td>
								<td align="center" class="padding4 tdborder_ad"><%=minCritical%></td>
								<td align="center" class="padding4 tdborder_ad"><%=minMajor%></td>
								<td align="center" class="padding4 tdborder_ad"><%=minMinor%></td>
							</tr>
<%
						enterMinPart = true;
						//aListData.add("Min");
						//aListData.add(minCritical);
						//aListData.add(minMajor);
						//aListData.add(minMinor);
				}

				if(!maxCritical.equals("-") || !maxMajor.equals("-") || !maxMinor.equals("-"))
				{
					enterMaxPart = true;
%>
							<tr>
								<td align="center" class="padding4 tdborder_ad"><b>Max</b></td>
								<td align="center" class="padding4 tdborder_ad"><%=maxCritical%></td>
								<td align="center" class="padding4 tdborder_ad"><%=maxMajor%></td>
								<td align="center" class="padding4 tdborder_ad"><%=maxMinor%></td>
							</tr>
<%
//					if(enterMinPart)
//					{
//						enterMaxPart = true;
//						aListData.add("");
//						aListData.add("Max");
//						aListData.add(maxCritical);
//						aListData.add(maxMajor);
//						aListData.add(maxMinor);
//					}
//					else
//					{
//						aListData.add("Max");
//						aListData.add(maxCritical);
//						aListData.add(maxMajor);
//						aListData.add(maxMinor);
//
//					}
				}
%>

						</table>
					</td>
					<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="padding4" align="left" valign="middle" title="<%=alarmPolicy%>"><egui:display name="<%=alarmPolicy%>" length="<%=Integer.toString(alarmPolicyLength)%>"/></td>
				</tr>
<%
				//if(!enterMaxPart)
				//{
				if(enterMinPart && !enterMaxPart)
				{
					aListData.add("Min");
					aListData.add(minCritical);
					aListData.add(minMajor);
					aListData.add(minMinor);
					aListData.add(alarmPolicy);
				}
				else if(!enterMinPart && enterMaxPart)
				{
					aListData.add("Max");
					aListData.add(maxCritical);
					aListData.add(maxMajor);
					aListData.add(maxMinor);
					aListData.add(alarmPolicy);
				}
				else if(enterMinPart && enterMaxPart)
				{
					//min data
					aListData.add("Min");
					aListData.add(minCritical);
					aListData.add(minMajor);
					aListData.add(minMinor);
					aListData.add(alarmPolicy);

					//max data
					aListData.add("");
					aListData.add("Max");
					aListData.add(maxCritical);
					aListData.add(maxMajor);
					aListData.add(maxMinor);
					aListData.add("");

				}
				//}
			}
			cellFlag = !cellFlag;
		}
		
		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);
		tableList.add(egTable);

%>
						</table>
					</td>
				</tr>
<%
		if(isShowMeasWithoutThresholds)
		{
			if (aListTestWithNoThresholds != null && !aListTestWithNoThresholds.isEmpty())
			{
%>
				<tr>
					<td><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="5"></td>
				</tr>

				<tr>
					<td>
						<table align="center" width="95%" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td height="20" class="padding4 table_head">Measures without thresholds</td>
							</tr>
							<tr>
								<td width="100%">
									<table width="100%" cellspacing="0" cellpadding="0" border="0" class="tableborder_ad2" style="border-collapse: collapse;"><col width="33%"><col width="33%"><col width="34%">
<%
				for (int d=0; d<aListTestWithNoThresholds.size(); d=d+3)
				{
%>
										<tr>
<%
					int k=1;
					for (int e=d; e<d+3; e++)
					{
						if (e<aListTestWithNoThresholds.size())
						{
							String strMeasure = (String)aListTestWithNoThresholds.get(e);
							String tmpStyple="";
							if(k==1)
							{
							tmpStyple="border-left-width:1px";
							k++;
							}
%>
											<td class="tdborder_ad2 padding4" valign="top" align="left" >
												<table cellpadding="0" cellspacing="0" border="0" width="100%">
													<tr>
														<td width="5%" valign="center" valign="middle"></td>
														<td width="95%" valign="middle">
															<%=mappingInfo.getMeasureDescription(key,strMeasure)%>
														</td>
													</tr>
												</table>
											</td>
<%
						}
						else
						{
%>
											<td class="tdborder_ad2" >&nbsp;</td>
<%
						}
					}
%>
										</tr>
<%
				}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
			}
		}
%>
						</table>
<%
		}

%>

					</td>
				</tr>

				<tr>
					<td id="eg_blnkspace" height="10">&nbsp;</td>
				</tr>
<%
			}
			//pdf work
			pdfData.setData(tableList);
			session.setAttribute("pdfData",pdfData);
		}
		else
		{
%>
				<tr>
					<td colspan="7" align="center" valign="middle"  height="200" class="eg_subhead">
						<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br> &nbsp;&nbsp;&nbsp;<egui:intnl text="admin.threshold.No Data Available For The Combination Chosen"/>
					</td>
				</tr>
<%
		}
	}
%>
			</table>
		</td>
	</tr>
</table>
<%
		session.setAttribute("eg_compType",s_compType);
		session.setAttribute("eg_host",s_host);
		session.setAttribute("eg_test",req_test);
		session.setAttribute("eg_threshType",s_threshType);
		session.setAttribute("fromCT",fromCompType);
		session.setAttribute("fin",finn);
	}
%>

</form>
</body>
</html>
<%!
	// T.Thirumal Azhagan    Monday, March 27, 2006
//	public Vector getAbsAndRel(String format) // for mix format in threshold ,introduced by BOSS(MIX)
//	{
//		Vector vect = new Vector();	// [absolute,relative]
//		StringTokenizer stok1 = new StringTokenizer(format,"/");
//		if (!format.equals("-1") && stok1.countTokens() == 3)
//		{
//			String h;
//			String m;
//			String l;
//			String H = stok1.nextToken();
//			String M = stok1.nextToken();
//			String L = stok1.nextToken();
//			if (!(H.equals("-")))
//			{
//				if (H.indexOf("&") > -1)
//				{
//					StringTokenizer st = new StringTokenizer(H,"&");
//					H = st.nextToken();
//					h = st.nextToken();
//				}
//				else
//				{
//					if (H.indexOf("sqc") > -1)
//					{
//						h = H;
//						H = "-";
//					}
//					else
//						h = "-";
//				}
//			}
//			else
//			{
//				h = "-";
//			}
//			if (!(M.equals("-")))
//			{
//				if (M.indexOf("&") > -1)
//				{
//					StringTokenizer st = new StringTokenizer(M,"&");
//					M = st.nextToken();
//					m = st.nextToken();
//				}
//				else
//				{
//					if (M.indexOf("sqc") > -1)
//					{
//						m = M;
//						M = "-";
//					}
//					else
//						m = "-";
//				}
//			}
//			else
//			{
//				m = "-";
//			}
//			if (!(L.equals("-")))
//			{
//				if (L.indexOf("&") > -1)
//				{
//					StringTokenizer st = new StringTokenizer(L,"&");
//					L = st.nextToken();
//					l = st.nextToken();
//				}
//				else
//				{
//					if (L.indexOf("sqc") > -1)
//					{
//						l = L;
//						L = "-";
//					}
//					else
//						l = "-";
//				}
//			}
//			else
//			{
//				l = "-";
//			}
//			StringBuffer sb2 = new StringBuffer();
//			StringBuffer sb1 = new StringBuffer();
//			String s1 = null;
//			if (H.equals("-") && M.equals("-") && L.equals("-"))
//			{
//				s1 = "none";
//			}
//			else
//			{
//				sb1.append(H);
//				sb1.append("/");
//				sb1.append(M);
//				sb1.append("/");
//				sb1.append(L);
//				s1 = sb1.toString();
//			}
//			String s2 = null;
//			if (h.equals("-") && m.equals("-") && l.equals("-"))
//			{
//				vect.add(s1);
//				vect.add("none");
//			}
//			else
//			{
//				sb2.append(h);
//				sb2.append("/");
//				sb2.append(m);
//				sb2.append("/");
//				sb2.append(l);
//				s2 = sb2.toString();
//				vect.add(s1);
//				vect.add(s2);
//			}
//		}
//		else
//		{
//			vect.add("none");
//			vect.add("none");
//		}
//		return vect;
//	}

//	public String removeNull(String component)
//	{
//		return (component.endsWith(":NULL"))?component.substring(0,component.indexOf(":NULL")):component;
//	}

	public boolean isListContainsTest(ArrayList a1,ArrayList a2)
	{
		boolean b = false;
		for(int i=0;i<a2.size();i++)
		{
			String temp = (String)a2.get(i);
			if(a1.contains(temp))
			{
				b = true;
				break;
			}
		}
		return b;
	}
%>

<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgThreshDetailView.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgThreshDetailView.jsp");
	}
%>



<%!
	int alarmPolicyLength = 15;

	private String get1(String H)
	{
		String h;
		if (!(H.equals("-")))
		{
			if (H.indexOf("&") > -1)
			{
				StringTokenizer st = new StringTokenizer(H,"&");
				H = st.nextToken();
				h = st.nextToken();
			}
			else
			{
				if (H.indexOf("sqc") > -1)
				{
					h = H;
					H = "-";
				}
				else
				{
					h = "-";
				}
			}
		}
		else
		{
			h = "-";
		}
		return(H+"_"+h);
	}

	private Vector getAbsAndRel(String format)
	{
		Vector vect = new Vector();
		StringTokenizer stok1 = new StringTokenizer(format,"/");
		if (!format.equals("-1") && stok1.countTokens() == 3)
		{
			String H1 = stok1.nextToken();
			String h2=get1(H1);
			String M = stok1.nextToken();
			String m1=get1(M);
			String L = stok1.nextToken();
			String l1=get1(L);
			StringTokenizer h1 = new StringTokenizer(h2,"_");
			String High= h1.nextToken();
			String high = h1.nextToken();
			StringTokenizer m = new StringTokenizer(m1,"_");
			String Mid = m.nextToken();
			String mid = m.nextToken();
			StringTokenizer l = new StringTokenizer(l1,"_");
			String Low = l.nextToken();
			String low = l.nextToken();
			StringBuffer sb2 = new StringBuffer();
			StringBuffer sb1 = new StringBuffer();
			String s1 = null;
			if (High.equals("-") && Mid.equals("-") && Low.equals("-"))
			{
				s1 = "none";
			}
			else
			{
				sb1.append(High);
				sb1.append("/");
				sb1.append(Mid);
				sb1.append("/");
				sb1.append(Low);
				s1 = sb1.toString();
			}
			String s2 = null;
			if (high.equals("-") && mid.equals("-") && low.equals("-"))
			{
				vect.add(s1);
				vect.add("none");
			}
			else
			{
				sb2.append(high);
				sb2.append("/");
				sb2.append(mid);
				sb2.append("/");
				sb2.append(low);
				s2 = sb2.toString();
				vect.add(s1);
				vect.add(s2);
			}
		}
		else
		{
			vect.add("none");
			vect.add("none");
		}
		return vect;
	}

	private String getThresholdValue(String grpFunction, String absValue,String relValue)
	{
		String strValue = "-";

		if (absValue.equals("-") && relValue.equals("-"))
		{
			strValue = "-";
		}
		else if (!absValue.equals("-") && !relValue.equals("-"))
		{
			strValue = grpFunction+"("+absValue+", "+getRelativeThreshold(relValue)+")";
		}
		else if (!absValue.equals("-"))
		{
			strValue = absValue;
		}
		else if (!relValue.equals("-"))
		{
			strValue = getRelativeThreshold(relValue);
		}

		return strValue;
	}

	private String getRelativeThreshold(String relValue)
	{
		//relValue: 3*sqc
		String strValue = "";
		if (relValue.indexOf("*") != -1)
		{
			int idx = relValue.indexOf("*");
			String s1 = relValue.substring(0,idx);
			double d_value = Double.valueOf(s1.trim()).doubleValue();
			d_value = d_value * 100;
			int i_value = (new Double(d_value)).intValue();
			strValue = Integer.toString(i_value) + "% of auto";
		}
		else
		{
			strValue = "auto";
		}
		return strValue;
	}

	public String removeNull(String compName)
	{
		if (compName != null && compName.length()>0)
		{
			return (compName.endsWith(":NULL"))?compName.substring(0,compName.indexOf(":NULL")):compName;
		}
		else
		{
			return "";
		}
	}

	public boolean isSetThresholdValues(String str)
	{
		boolean isThreshVal = false;
		StringTokenizer st = new StringTokenizer(str,",");
		while(st.hasMoreElements())
		{
			String tmpVal = st.nextToken();
			StringTokenizer st1 = new StringTokenizer(tmpVal,":");
			String measName = st1.nextToken();
			String measType = st1.nextToken();
			String minVal = st1.nextToken();
			String maxVal = st1.nextToken();
			if(!minVal.equals("-1") || !maxVal.equals("-1"))
			{
				isThreshVal = true;
				break;
			}
		}
		return isThreshVal;
	}

%>
