<%
/*************************************************************************************************/
/*                 Name          : EgTopologyGroupPage.jsp                                       */
/*                 Purpose       : This page is used to list components under a group            */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
try
{
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<html>
<head>
<title>Group Details</title>
<egui:skin ui="admin"/>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script  src="/final/jquery/jquery.js"></script>
<script  src="/final/jquery/ui/jquery.ui.core.js"></script>
<script type="text/javascript">

function isIE() 
{
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}
var $j = jQuery.noConflict();

var autoTopologyPage = '<%=response.encodeURL("/final/admin/EgAutoTopologyGroup.jsp?")%>';
var topologyServlet = '<%=response.encodeURL("/final/servlet/com.eg.EgAutoTopologyServlet?")%>';
var topologyGroup = '<%=response.encodeURL("/final/admin/EgTopologyGroupPage.jsp?")%>';
var newServer = '<%=response.encodeURL("/final/admin/EgNewServer.jsp?")%>';
var autoManage = '<%=response.encodeURL("/final/admin/EgAutoManageComponents.jsp?")%>';
var autoMainpage = '<%=response.encodeURL("/final/admin/EgAutoMainPage.jsp?")%>';

$j(document).ready(function(){
	
	$j("#innerGroupDiv").height(310);
	$j("#groupDiv").height(353);
	centerBottom("#assignMore");
	$j(window).resize(function(){
		centerBottom("#assignMore");
	});

	var src = $j("#src").attr("value");
	if(src!=null && src.length > 0){
		selectFunction('newgroup','');
	}
});

var selectIn='';
function centerBottom(selector) {
	
	if(isIE() && selectIn=='select')
	{
		return;
	}
	else
	{
		var grpDivWidth = $j("#innerGroupDiv").width();
		var grpDivHeight = $j("#innerGroupDiv").height();
		var newLeft = parseInt(grpDivWidth) / 2 -  (parseInt($j(selector).width()) / 2) -  (parseInt( $j("#add").width()) / 2 ) - 25 ;
		var minusVal = 30;
		var newTop  = parseInt(grpDivHeight)  - minusVal;
		$j(selector).css({
			'position': 'absolute',
			'left': newLeft,
			'top': newTop
		});
		var newPos = $j(selector).position();

		// Position Finish Button
		var addLeft = newPos.left + parseInt($j(selector).width()) + 25;
		$j("#add").css({
			'position': 'absolute',
			'left': addLeft,
			'top': newTop
		});

		// Position #manageButton Button
		var manageLeft =  parseInt(grpDivWidth) / 2 -  (parseInt($j("#manageButton").width()) / 2) - 25;
		$j("#manageButton").css({
			'position': 'absolute',
			'left': manageLeft,
			'top': newTop
		});
	}
}

function zoneGroup(val)
{
	if(val=="0")
	{
		var option = $j("input[name='changeGroup']:checked").val();
		if(option=='oldgroup')
		{
			$j("#add").hide();
			$j(".rowClass").hide();
		}
		else
		{
			$j("#add").show();
			$j(".rowClass").show();
		}
	}
}

function showLoadingDiv()
{
	$j("#loading_image").css({"display":"block" , "position":"absolute" });
	var maxInd = maxIndex();
	$j("#loading_image").css({"z-index":maxInd+1});
	$j("#loading_image").show('slow');
	centerScreen("#loading_image");
}
function centerScreen(selector) 
{
	var newTop =   $j("#componentDispDiv").height() - $j(selector).height() / 2;
	var newLeft =  ($j("#componentDispDiv").width()  - $j(selector).width()) / 2;
	$j(selector).css({
		'position': 'absolute',
		'left': newLeft,
		'top': newTop / 2 
	});
}


function selectFunction(val,compValue){

	var segment = $j("#segment").attr("value");
	var zone = $j("#zone").attr("value");
	var src = $j("#src").attr("value");
	var thiscomp = $j("#thiscomp").attr("value");
	var compStatus = $j("#status").attr("value");
	var option="";
	var value="";

	if(val!="")
	{
		option = val;
		if(option=="newgroup")
		{
			$j("#groupNew").show();
			$j("#groupSelect").hide();
		}
		else if(option=="oldgroup")
		{
			$j("#groupNew").hide();
			$j("#groupSelect").show();
		}
	}
	else if(val=="")
	{
		option = $j("input[name='changeGroup']:checked").val();
	}
	if(compValue!="")
		value=compValue;
	if(value=="")
	{
		value = $j('#componentTypes :selected').val();
	}
	$j.ajax({
		type: "POST",
		url: autoTopologyPage,
		data: "option=" + option + "&segment="+ encodeURI(segment) +"&zone="+encodeURI(zone) + "&src="+encodeURI(src) + "&comp="+encodeURI(thiscomp)+ "&selectedComponent="+encodeURI(value)+"&compStatus="+encodeURI(compStatus), 
		success: function(msg) { 

			$j("#componentDispDiv").html("");
			$j("#componentDispDiv").html(msg);
			checkRows();
		},
		error: function(xhr, status, errorThrown){
			alert("Error:\n" + status);
		}
	});

	var allGroupNames = $j("#allGroupNames").attr("value");
	zoneGroup(allGroupNames);
	selectIn='select';
}

function valform(val,addOption)
{
	var option = $j("input[name='changeGroup']:checked").val();
	var isNewGroup='';
	if(option=='newgroup')
		isNewGroup="true";
	else
		isNewGroup="false";

	var action="";
	var selElement="";
	var thisForm = document.addgroup;
	var segment = $j("#segment").attr("value");
	var zone = $j("#zone").attr("value");
	var group = "";
	var src= $j("#src").attr("value");
	var comp= $j("#thiscomp").attr("value");
	var compStatus = $j("#status").attr("value");
	var sendToServlet="";
	var unchecked="";
	var zoomValue = $j("#zoom").attr("value");

	if(isNewGroup=="true")
	{
		action="add";
		group = $j("#groupNew").val();
		
		selElement = $j("input[name='chkbox']:checked")
					.map(function() { return $j(this).val() })
					.get()
					.join(",");
		
		unchecked= $j("input[name='chkbox']:not(:checked)")
					.map(function() { return $j(this).val() })
					.get()
					.join(",");
	}
	else
	{
		action="modify";
		
		selElement = $j("input[name='chkbox']:checked")
					.map(function() { return $j(this).val() })
					.get()
					.join(",");
		
		unchecked= $j("input[name='chkbox']:not(:checked)")
					.map(function() { return $j(this).val() })
					.get()
					.join(",");

		group = $j("#groupSelect").val();
	}

	if(selElement.length == 0 && $j.trim($j("#assocDiv").html())=='') 
	{
		alert('<egui:intnl text="admin.server.Please select a component"/>');
		return;
	}

	if(isNewGroup=="true")
	{
		var group_Name=true;
		if('<%=isDouble%>'=="false")
			group_Name = validateSingleByte(thisForm.groupNew.value);
		if(!checkblank(thisForm.groupNew))
		{
			alert("Field value cannot be blank");
			thisForm.groupNew.focus();
			if(val == "form")
			{
				return false;
			}
		}
		else if(!checkspace(thisForm.groupNew))
		{
			thisForm.groupNew.focus();
			if(val == "form")
			{
				return false;
			}
		}
		else if(!checkspecial(thisForm.groupNew,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
		{
			thisForm.groupNew.focus();
			if(val == "form")
			{
				return false;
			}
		}
		else if(!group_Name)
		{
			alert('<egui:intnl text="admin.compGroup.Group name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.groupNew.focus();
			return false;
		}
		else
		{
			sendToServlet="true";
		}
	}
	else
	{
		sendToServlet="true";
	}
	if(sendToServlet=="true")
	{
		var newCompValues = document.getElementById("newCompValues");
		var rowValues = document.getElementById("rowValues");
		if(rowValues!=null && newCompValues!=null)
		{
				$j("input[name='newchkbox']").attr("disabled",true);
				$j(".optiontd").show();
				$j(".porttd").hide();
		}
		if(isNewGroup=="true" && selElement.length!= 0)
		{
			$j("#groupNew").attr('readonly',true);
		}
		else if(isNewGroup!="true" && selElement.length != 0)
		{
			$j("#groupSelect").attr('disabled',true);
		}
		var disableOp=false;

		showLoadingDiv();
		var retVal='';
		$j.ajax({
			type: "POST",
			url: topologyServlet,
			data: "group="+encodeURI(group)+"&isNewGroup="+encodeURI(isNewGroup)+"&grpElement="+encodeURI(selElement)+"&segment="+encodeURI(segment)+"&zone="+encodeURI(zone)+"&action=addGroup"+"&finish="+encodeURI(addOption)+"&uncheckedVal="+encodeURI(unchecked)+"&continue=default" , 
			success: function(msg) { 
				$j("#loading_image").hide();
				if(msg!="")
				{
					if(msg.indexOf("is present in another group!")>-1)
					{
						$j("#alertResultDiv").html('<egui:intnl text=""/>'+msg);
						showAlertDiv();
						$j("#confirm").hide();
						$j("#okButtonRow").show();
						var newht = $j("#inneralertDiv").height();
						$j("#inneralertDiv").height(newht-10);
					}
					else if(msg.indexOf("is present in another group")>-1)
					{
						$j("#alertResultDiv").html('<egui:intnl text=""/>'+msg);
						$j("#alertResultDiv").append('<br><br>');
						$j("#alertResultDiv").append('<egui:intnl text="admin.common.Do you want to continue?"/>');
						getPositions();
						showAlertDiv();

						var newht = $j("#inneralertDiv").height();
						$j("#inneralertDiv").height(newht+10);
						$j("#confirm").show();
						$j("#okButtonRow").hide();
						
						$j("#okButton").click(function(){
							$j.ajax({
							type: "POST",
							url: topologyServlet,
							async: false,
							data: "group="+encodeURI(group)+"&isNewGroup="+encodeURI(isNewGroup)+"&grpElement="+encodeURI(selElement)+"&segment="+encodeURI(segment)+"&zone="+encodeURI(zone)+"&action=addGroup"+"&finish="+encodeURI(addOption)+"&uncheckedVal="+encodeURI(unchecked)+"&continue=yes" , 
							success: function(result){
									if(result!=""){
										$j("#inneralertDiv").height(newht);
										$j("#alertResultDiv").html('<egui:intnl text=""/>'+result);
										showAlertDiv();
										$j("#confirm").hide();
										$j("#okButtonRow").show();
									}
									if(result.indexOf("Your current changes")==-1)
										hideAlertDiv();
								}
							});
						});
						$j("#cancelButton").click(function(){
							$j("#inneralertDiv").height(newht);
							$j("#groupAlertDiv").hide();
							return false;
						});
					}
					else
					{
						$j("#groupNew").attr('readonly',false);
						$j("#groupSelect").attr('disabled',false);
						$j("#Modifygroup").attr('disabled',false);
						$j("#Addgroup").attr('disabled',false);
						disableOp = true;
						$j("#alertResultDiv").html('<egui:intnl text=""/>'+msg);
						showAlertDiv();
					}
				}
				if(addOption=='finish' && $j.trim($j("#alertResultDiv").html())=='')
				{
					var modify=$j("#modifySegment").attr("value");
					var myUrl = autoMainpage+"&segment="+encodeURI(segment)+"&zone="+encodeURI(zone)+'&zoom='+encodeURI(zoomValue)+"&modify="+encodeURI(modify);
					$j("#myFrame").attr('src',myUrl);
					$j("#groupDiv").hide('slow');
				}
				else if(addOption=='addMore')
				{
					//If Add More is clicked
					$j.ajax({
						type: "POST",
						url: topologyGroup,
						data: "&segment="+ encodeURI(segment) +"&zone="+encodeURI(zone) + "&thiscomp="+encodeURI(comp)+"&src="+encodeURI(src), 

						success: function(msg) { 
							 var selectContent = $j(msg).find('#groupSelect').html();
							 var contentHtml = $j(msg).find('.rowClass').html();
							 var assocHtml = $j(msg).find('#assocElement').html();
							 var assocDiv = $j(msg).find('#assocDiv').html();

							//$j(".rowClass").html(contentHtml);
							$j("#groupSelect").html(selectContent);
							$j("#assocElement").html(assocHtml);
							
							//To display associated elements div
							var x = $j("#assignMore").offset();
							var pos = $j("#assignMore").position();
							var outerheight = $j("#innerGroupDiv").outerHeight();
							
							if($j.trim($j("#assocDiv").html())!='')
							{
								$j("#groupDiv").animate({height:pos.top+155+"px"},500);
								$j("#innerGroupDiv").animate({height:pos.top+115+"px"},500);
								$j("#assocElement").show();
							}
							else
							{
								$j("#groupDiv").animate({height:"353px"},500);
								$j("#innerGroupDiv").animate({height:"310px"},500);
								$j("#assocElement").hide();
							}
							if(isNewGroup=="true")
							{
								$j("#groupSelect").hide();
								if(selElement.length!=0 && !disableOp){
									$j("#Modifygroup").attr('disabled',true);
								}
							}
							else
							{
								$j("#groupNew").hide();
								$j("#groupSelect").val(group);
								if(selElement.length!=0 && !disableOp){
									$j("#Addgroup").attr('disabled',true);
								}
							}
							if(rowValues!=null && newCompValues!=null)
							{
								$j("input[name='newchkbox']").attr("disabled",true);
								$j(".optiontd").show();
								$j(".porttd").hide();
							}
						}
					});
				}
			}
		});
	}
}
function OpenManageDivs(val)
{
	var manageFrame = document.getElementById("manageFrame");
	var thissegment = $j("#segment").attr("value");
	var thiszone = $j("#zone").attr("value");

	var urlToDisplay ='';
	if(val == 'single'){
		var comptitle = $j("#thiscomp").attr("value");
		var compsrc = $j("#src").attr("value");
		var compstatus = $j("#status").attr("value"); 
		var servertype=compsrc;
		/*if (compsrc.indexOf(".gif")>0)
			servertype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".gif"));
		else if (compsrc.indexOf(".png")>0)
			servertype = compsrc.substring(compsrc.lastIndexOf("/")+1,compsrc.indexOf(".png"));*/

		urlToDisplay = newServer+"&server=new&compstatus="+ encodeURI(compstatus)+"&serverType="+encodeURI(servertype)+"&allExternalTests=true&from=addnew&isAggregateLink=false&frmTopology=yes&comptitle="+encodeURI(comptitle)+"&topoSegName="+encodeURI(thissegment);
	}

	var maxInd = maxIndex();
	$j("#manageDiv").css({"display":"block" , "position":"absolute" });
	$j("#manageDiv").css({"z-index":maxInd+1});
	$j("#manageDiv").show('slow');
	manageFrame.src = urlToDisplay;
	$j("#groupDiv").hide("slow");
}

//EgAutotopologyGroup page scripts

function newCompSelect()
{
	var checked = false;
	var inputs = document.getElementsByTagName('input');

	for (var j = 0; j < inputs.length; j++) {
		if(inputs[j].type=='checkbox' && inputs[j].name=='newcheckbx')
		{
			checked = inputs[j].checked;
		}
		if (inputs[j].type == 'checkbox' && inputs[j].name=='newchkbox') 
		{
			inputs[j].checked = checked;
		}
	}
}
function selectAll()
{
	var checked = false;
	var inputs = document.getElementsByTagName('input');

	for (var i = 0; i < inputs.length; i++) {
		if(inputs[i].type=='checkbox' && inputs[i].name=='checkbx')
		{
			checked = inputs[i].checked;
		}
		if (inputs[i].type == 'checkbox' && inputs[i].name=='chkbox') 
		{
			inputs[i].checked = checked;
		}
	}
}
function checkRows()
{
	if($j('input:checkbox[name=chkbox]').length ==  $j("input[name='chkbox']:checked").length) 
	{
		var inputs = document.getElementsByTagName('input');
		for (var i = 0; i < inputs.length; i++) {
			if (inputs[i].type == 'checkbox' && inputs[i].name=='checkbx') {
				inputs[i].checked = true;
			}
		}
	}
	else
	{
		var inputs = document.getElementsByTagName('input');
		for (var i = 0; i < inputs.length; i++) {
			if (inputs[i].type == 'checkbox' && inputs[i].name=='checkbx') {
				inputs[i].checked = false;
			}
		}
	}
}
function checkRowsNew()
{
	if($j('input:checkbox[name=newchkbox]').length ==  $j("input[name='newchkbox']:checked").length) 
	{
		var inputs = document.getElementsByTagName('input');
		for (var j = 0; j < inputs.length; j++) {
			if (inputs[j].type == 'checkbox' && inputs[j].name=='newcheckbx') {
				inputs[j].checked = true;
			}
		}
	}
	else
	{
		var inputs = document.getElementsByTagName('input');
		for (var j = 0; j < inputs.length; j++) {
			if (inputs[j].type == 'checkbox' && inputs[j].name=='newcheckbx') {
				inputs[j].checked = false;
			}
		}
	}
}

</script>
<script type="text/javascript">
	function openManageComp(val)
	{
		var manageFrame = document.getElementById("manageFrame");
		var thissegment = $j("#segment").attr("value");
		var thiszone = $j("#zone").attr("value");

		var urlToDisplay ='';
		var compsrc = val.substring(0,val.indexOf(":"));
		var comptitle = val.substring(val.indexOf(":")+1);
		
		var compstatus = $j("#status").attr("value"); 
		var servertype=compsrc;
		
		urlToDisplay = newServer+"&server=new&compstatus="+ encodeURI(compstatus)+"&serverType="+encodeURI(servertype)+"&allExternalTests=true&from=addnew&isAggregateLink=false&frmTopology=yes&comptitle="+encodeURI(comptitle)+"&topoSegName="+encodeURI(thissegment);
		

		var maxInd = maxIndex();
		$j("#manageDiv").css({"display":"block" , "position":"absolute" });
		$j("#manageDiv").css({"z-index":maxInd+1});
		$j("#manageDiv").show('slow');
		manageFrame.src = urlToDisplay;
		$j("#groupDiv").hide("slow");
	}

	function manageComponents()
	{
		var segment = $j("#segment").attr("value");
		var urlToDisplay = autoManage+"&segment="+encodeURI(segment);
		
		var zoomValue = $j("#zoom").attr("value");
		var zone = $j("#zone").attr("value");
		var modify = $j("#modifySegment").attr("value");
		var myUrl = autoMainpage+"&segment="+encodeURI(segment)+"&zone="+encodeURI(zone)+'&zoom='+encodeURI(zoomValue)+"&modify="+encodeURI(modify);
		
		var test = $j("input[name='newchkbox']:checked")
					.map(function() { return $j(this).val() })
					.get()
					.join(",");

		if(test.length == 0) { 
			alert('<egui:intnl text="admin.server.Please select a component to manage"/>');
			return;
		}

		showLoadingDiv();
		$j('#manageButton').attr("disabled", true);
		$j.ajax({
			type: "POST",
			url: urlToDisplay,
			data: "test=" + test,
			success: function(msg) { 
				hideDivs('loading_image');
				//setTimeout(function(){ window.location.reload();}, 0);
				$j("#myFrame").attr('src',myUrl);
				$j("#groupDiv").hide('slow');
			}
		});
	}
	function centerScreen(selector) 
	{
		var newTop =   $j("#innerManageAllDiv").height() - $j(selector).height() / 2;
		var newLeft =  ($j("#innerManageAllDiv").width()  - $j(selector).width()) / 2;
		$j(selector).css({
			'position': 'absolute',
			'left': newLeft,
			'top': newTop / 2 
		});
	}

	function showLoadingDiv()
	{
		$j("#loading_image").css({"display":"block" , "position":"absolute" });
		var maxInd = maxIndex();
		$j("#loading_image").css({"z-index":maxInd+1});
		$j("#loading_image").show('slow');
		//centerScreen("#loading_image");
	}
	function showAlertDiv()
	{
		var maxInd = maxIndex();
		$j("#groupAlertDiv").css({"display":"block" , "position":"absolute" });
		$j("#groupAlertDiv").css({"z-index":maxInd+1});
		$j("#groupAlertDiv").show('slow');
		centerScreenAlert('#groupAlertDiv');
	}
	function hideAlertDiv()
	{
		var zoomValue = $j("#zoom").attr("value");
		var segment = $j("#segment").attr("value");
		var zone = $j("#zone").attr("value");
		var modify = $j("#modifySegment").attr("value");
		var myUrl = autoMainpage+"&segment="+encodeURI(segment)+"&zone="+encodeURI(zone)+'&zoom='+encodeURI(zoomValue)+"&modify="+encodeURI(modify);
		$j("#myFrame").attr('src',myUrl);
		$j("#groupAlertDiv").hide('slow');
		$j("#groupDiv").hide('slow');
	}

	function centerScreenAlert(selector) 
	{
		var topVar='';
		if($j.trim($j("#assocDiv").html())=='')
			topVar = 1.4;
		else
			topVar = 1.7;
		var newTop =   $j("#groupDiv").height() - $j(selector).height() / 2;
		var newLeft =  ($j("#groupDiv").width()  - $j(selector).width()) / 2;
		$j(selector).css({
			'position': 'absolute',
			'left': newLeft,
			'top': newTop / topVar 
		});
	}
	function getPositions()
	{
		var minusVal = 22;
			if(isIE()){
				minusVal = 25;
			}
		var alWidth = $j("#groupAlertDiv").width();
		var alHeight = $j("#groupAlertDiv").height();
		$j("#okButton").css({
			'position': 'absolute',
			'left': parseInt($j("#groupAlertDiv").width()) / 2 -  (parseInt($j("#okButton").width()) / 2) -  (parseInt( $j("#cancelButton").width()) / 2 ) - 53 ,
			'top': parseInt($j("#groupAlertDiv").height())  - minusVal
		});

		$j("#cancelButton").css({
			'position': 'absolute',
			'left': $j("#okButton").position().left + parseInt($j("#cancelButton").width()) + 140,
			'top': parseInt($j("#groupAlertDiv").height())  - minusVal
		});

	}
</script>
</head>
<%
	EgGroupInfo groupInfo = new EgGroupInfo();
	String groupName = request.getParameter("title");
	StringBuffer listBuffer = new StringBuffer();
	String conPath = request.getContextPath();
	String contextPath = request.getContextPath()+"/admin/eg_images/";
	String color = "A0A0A0";
	String dark = "150517";
	boolean isDiagram = false;
	Hashtable compTable = new Hashtable();
	String[] allGroupNames=null;
	ArrayList myList = new ArrayList();
	ArrayList tempList = new ArrayList();
	String status = request.getParameter("status");
	String fromPage = request.getParameter("fromPage");
	String modifySegment = request.getParameter("modify");
	if(modifySegment==null)
		modifySegment="";

	String compStatus="";
	if(status!=null && status.length()>0)
	{
		compStatus=status;
	}
	boolean newStatus=false;
	if(compStatus.equals("NEW") || compStatus.equals("UNMANAGE"))
	{
		newStatus=true;
	}

	boolean isGroup = false;
	if(groupName!=null && groupName.length() > 0)
	{
		ArrayList compList = groupInfo.getAllComponentsUnderGroup(groupName);
		int size = compList.size();
		if(isDiagram)
		{
			for(int k=0;k<size;k++)
			{
				String comp = (String) compList.get(k);
				listBuffer.append(comp);
				if(k!=size-1)
					listBuffer.append("#");
			}
		}
		else
		{
			for(int k=0;k<size;k++)
			{
				String comp = (String) compList.get(k);
				String compType = comp.substring(0,comp.indexOf(":"));
				String compName = comp.substring(comp.indexOf(":")+1);
				if(compTable.containsKey(compType))
				{
					ArrayList a = (ArrayList) compTable.get(compType);
					a.add(compName);
					compTable.put(compType,a);
				}
				else
				{
					ArrayList a = new ArrayList();
					a.add(compName);
					compTable.put(compType,a);
				}
			}
		}
	}
	else
	{
		isGroup = true;
	}
	
	Hashtable assocElementTable=null;
	if(fromPage!=null && fromPage.equals("automainPage"))
	{
		Hashtable grpElementTable = (Hashtable)session.getAttribute("autoTopoGroupTable");
		ArrayList grpElementList = (ArrayList)session.getAttribute("autoTopoGroupList");
		if(grpElementTable!=null && grpElementTable.size()>0)
			grpElementTable.clear();
		if(grpElementList!=null && grpElementList.size()>0)
			grpElementList.clear();

		synchronized( session ) {
			session.setAttribute("autoTopoGroupTable",(Hashtable)grpElementTable);
			session.setAttribute("autoTopoGroupList",(ArrayList)grpElementList);
			session.removeAttribute("autoTopoGroupTable") ;
			session.removeAttribute("autoTopoGroupList");
		}
	}
	else
	{
		assocElementTable = (Hashtable)session.getAttribute("autoTopoGroupTable");
	}

%>
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="white_bg">
<!-- Loading Div -->
<div id ="loading_image" style = "position:absolute;top:100px;left:150px;visibility:visible;display:none;border:0px solid #ff0000;"> 
	<table height="100%">
		<tr>
			<td height="100%" valign="middle"> 
				<img src='/final/admin/eg_images/indicator_medium.gif'>
			</td>
		</tr>
	</table>
</div>
<!-- Alert Div -->
<div id="groupAlertDiv" name="groupAlertDiv" style="display:none;left:50px;top:50px;width:300px;min-height:80px;border:0px solid #ff0000; position:absolute;height:auto;">
	<table  border="0" cellspacing="0" cellpadding="0" width="100%">
		<tr>
			<td class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_top_bg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_righttop_curve" ><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
		<tr>
			<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
			<td class="eg_whitebg" align="center">
				<div style="min-height:60px;border:1px solid black;height:auto;" id="inneralertDiv">
					<table border="0" cellspacing="0" cellpadding="4" align="center" width="100%">
						<tr align="center">
							<td>
								<div id="alertResultDiv" height="100%" width="100%"></div>
							</td>
						</tr>
						<tr align="center" id="okButtonRow">
							<td><input type="button" class="eg_lightbutton" name="ok" id="ok" value=" OK " onclick="javascript:hideAlertDiv();"style="padding-left:4px;padding-right:4px"></td>
						</tr>
						<tr align="center" id="confirm" style="display:none">
							<td><input type="button" class="eg_lightbutton" name="okButton" id="okButton" value=" OK " style="position:absolute;z-Index:100;" ></td>
							<td><input type="button" class="eg_lightbutton" name="cancelButton" id="cancelButton" value=" CANCEL " style="position:absolute;z-Index:100;" ></td>
						</tr>
					</table>
				</div>
			</td>
			<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
		</tr>
		<tr>
			<td class="pop2_leftbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_bottom_bg"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_rightbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
	</table>
</div>
<form name="addgroup" method="post" action="" onSubmit="return valform('form','');" style="margin:0px"> 
<table border="0" cellspacing="0" cellpadding="4" align="center" width="100%" height="100%">

<%
	if(isGroup)
	{
		String segment = request.getParameter("segment");
		String zone = request.getParameter("zone");
		String thiscomp = request.getParameter("thiscomp"); //componentName
		String src = request.getParameter("src");	//componentType
		String zoom = request.getParameter("zoom");
		boolean groupFound=false;

		boolean otherSegment=false;
		String otherSegName = "";
		IniFile egTopoIni =  new IniFile(EgInstallInfo.getInstallDir() + 
																"/manager/config/eg_topology.ini");
		String segmentNames[] = egTopoIni.getVariables("TOPOLOGY_SEGMENTS");
		for(int s=0;s<segmentNames.length;s++)
		{
			String allSegments = (String)segmentNames[s];
			if(!allSegments.equals(segment))
			{
				String[] aLines = egTopoIni.getLinesUnderSubject(allSegments);
				if(aLines!=null && aLines.length>0)
				{
					for(int a=0;a<aLines.length;a++)
					{
						String line = (String)aLines[a];
						String element= src+":"+thiscomp; 
						if(line.indexOf(element)>-1)
						{
							otherSegName = allSegments;
							otherSegment = true;
						}
					}
				}
			}
		}

		ArrayList managedCompList = new ArrayList();
		managedCompList = getManagedComponents(segment);
		
		ArrayList compTypeList=new ArrayList();
		ArrayList compNameList = new ArrayList();
		for(int k=0;k<managedCompList.size();k++)
		{
			String element = (String) managedCompList.get(k);
			StringTokenizer st = new StringTokenizer(element,":");
			int count = st.countTokens();
			String compType = "";
			String hostName = "";
			String portNo = "";
			String sid = "-";
			boolean isOraServer = false;
			if(count == 3)
			{
				compType = st.nextToken();
				hostName = st.nextToken();
				portNo = st.nextToken();
			}
			else if(count == 4)	// Only for Oracle_Database Component
			{
				compType = st.nextToken();
				hostName = st.nextToken();
				portNo = st.nextToken();
				sid = st.nextToken();
				isOraServer = true;
			}
			if(!compTypeList.contains(compType))
			{
				compTypeList.add(compType);
			}
		}

		if(zone!=null && !zone.equals("-1"))
		{
			TreeSet mySet =  groupInfo.getAllGroupsUnderZone(zone, true);
			if(mySet!=null && mySet.size() > 0)
			{
				myList.addAll(mySet);
				for(int m=0;m<myList.size();m++)
				{
					String fullName = (String)myList.get(m);
					fullName=fullName.substring(fullName.indexOf(":")+1,fullName.lastIndexOf(":"));
					tempList.add(fullName);
				}
				allGroupNames = new String[tempList.size()];
				for (int a = 0; a < tempList.size(); a++) 
				{
					allGroupNames[a] = tempList.get(a).toString();
				}
			}
		}
		else
		{
			allGroupNames = groupInfo.getGroupNames();
		}

%>
	<input type="hidden" id="zone" name="zone" value="<%=zone%>">
	<input type="hidden" id="segment" name="segment" value="<%=segment%>">
	<input type="hidden" id="src" name="src" value="<%=src%>">
	<input type="hidden" id="thiscomp" name="thiscomp" value="<%=thiscomp%>">
	<input type="hidden" id="status" name="status" value="<%=status%>">
	<input type="hidden" id="zoom" name="zoom" value="<%=zoom%>">
<%	
	
	if(allGroupNames==null || allGroupNames.length < 0)
	{
%>		<input type="hidden" id="allGroupNames" name="allGroupNames" value="0">
<%	}
%>

<%
		if(!otherSegment && !newStatus)
		{
%>
	<tr>
		<td height="53" align="left"  class="eg_cellbgmedium" style="border-bottom-width:1px" >
			<div id="thisIsMainDiv" style="width:100%;height:100%;border:0px solid #ff0000;"> 
				<table align="center" cellspacing="0" cellpadding="4" border="0" class="groupClass">
					<tr>
						<td id="eg_cellbgmedium" width="15"> <input type="radio" name="changeGroup" id="Addgroup" class="eg_input" value="newgroup" checked="checked" onclick="javascript:selectFunction(this.value,'');"></td>
						<td><egui:intnl text="admin.common.Create New Group"/></td>
						<td> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </td>
						<td id="eg_cellbgmedium" width="15"> <input type="radio" name="changeGroup" id="Modifygroup" class="eg_input" value="oldgroup" onclick="javascript:selectFunction(this.value,'');"></td>
						<td><egui:intnl text="admin.common.Existing Group"/></td>
					</tr>
				</table>

<%
	
%>
				<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" id="eg_subcontentbg" class="rowClass">
					<tr>
						<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					</tr>
					<tr id="grpOption">
						<td class="eg_subcontent" align="right" width="25%"><egui:intnl text="admin.compGroup.Group name"/>&nbsp;&nbsp;</td>
						<td width="5" class="eg_subcontent">:</td>
						<td  class="eg_subcontent"><input type="text" name="groupNew" id="groupNew" maxlength="32" ></td>
						<td class="eg_subcontent">
							<select name="groupSelect" id="groupSelect" width="100px">
<%
			if(allGroupNames!=null && allGroupNames.length > 0)
			{
				for(int k=0;k<allGroupNames.length;k++)
				{
					String thisGroupName = allGroupNames[k];
%>
					<option value="<%=thisGroupName%>"> <%=thisGroupName%></option>
<%
				}
			}
%>
							</select>
						</td>
						<td align="center" class="eg_subcontent">
							<select name="componentTypes" id="componentTypes" onchange="selectFunction('',this.value);" style="width:160px;">

<%							String selected="";
							String userLanguage = _user.getLanguage();
							IniUI iniUI = IniUI.getInstance();
							if (userLanguage == null)
								userLanguage = iniUI.getDefaultLanguage();
					
							MappingNameSorter sorter = new MappingNameSorter(userLanguage);
							compTypeList = sorter.getSortedCompTypeList(compTypeList);
							for(int j=0;j<compTypeList.size();j++)
							{
								EgName nameObj = (EgName)compTypeList.get(j);
								String actCompType = nameObj.getActualName();
								String mappingCompType = nameObj.getLocalName();
								if(actCompType.equals(src))
								{
%>									<option value="<%=actCompType%>"SELECTED> <%=mappingCompType%></option>
<%								}
								else
								{
%>									<option value="<%=actCompType%>"> <%=mappingCompType%></option>
<%								}
							}
%>
							</select>
						</td>
					</tr>
					<tr>
						<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
						<td id="eg_subcontentbg"  width="100%" colspan="4" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
						<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
					</tr>
				</table>
			</div>
		</td>
	</tr>
	
	<tr>
		<td width="100%" height="100%" align="center" valign="top">
			<div id="componentDispDiv" class="div_scroll" style="width:100%;height:200px;border:0px solid green;"> </div>
		</td>
	</tr>

	<tr>
		<td>
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" >
				<tr>
					<td align="center" class="eg_subcontent"><input type="button"  style="width:140px;height: 20px;z-Index:100;" name="updateImg" id="assignMore" class="eg_back" value='<egui:intnl text="admin.service.Assign and Add More"/>' onClick="javascript:valform('button','addMore');"></td> 
					<td align="center" class="eg_subcontent"><input type="button"  style="width:70px;height: 20px;z-Index:100;" name="updateImg" id="add" class="eg_back" value='<egui:intnl text="admin.service.Finish"/>' onClick="javascript:valform('button','finish');"></td>
					<td valign="top" align="center" ><input style="display:none" type="button" class="eg_back" name="manageButton" id="manageButton" value='<egui:intnl text="admin.servers.Add / Manage"/>' onClick="javascript:manageComponents();" style="width:110px;"></td>
				</tr>
			</table>
		</td>
	</tr>

	<tr id="assocElement" style="display:none;">
		<td>
			<table align="center" cellspacing="0" cellpadding="4" width="100%" height="100%" border="0">
				<tr>
					<th colspan= "2" id="eg_subheadbg" style="text-align:left" height="20">&nbsp;<egui:intnl text="admin.service.Associated Components"/>
					</th>
				</tr>
				<tr>
					<td align="left" class="linesquare">
						<div class="div_scroll" id="assocDiv" style="width:100%;height:55px;border:0px solid red">

<%				if(assocElementTable!=null && assocElementTable.size()>0)
				{
					ArrayList mappingList = new ArrayList();
					Enumeration keys = assocElementTable.keys();
					while(keys.hasMoreElements())
					{
						String key = (String)keys.nextElement();
						ArrayList arr = (ArrayList)assocElementTable.get(key);
						String finalElement="";
						if(arr!=null && arr.size()>0)
						{
							for(int a=0;a<arr.size();a++)
							{
								String element = (String)arr.get(a);
								String comptype = element.substring(0,element.indexOf(":"));
								String mappingCompType = _mapping.getComponentTypeDescription(comptype);
								String toMap = element.substring(element.indexOf(":")+1);
								String mappingElement = mappingCompType+":"+toMap;
								String portOnly = mappingElement.substring(mappingElement.lastIndexOf(":")+1);
								if(portOnly!=null && portOnly.equalsIgnoreCase("NULL"))
								{
									mappingElement = mappingElement.substring(0,mappingElement.lastIndexOf(":"));
								}
								finalElement = finalElement+", "+mappingElement;
							}
							finalElement = finalElement.trim();
							if(finalElement.startsWith(","))
								finalElement = finalElement.substring(finalElement.indexOf(",")+1);
%>							
							<%=finalElement%>
<%						}
					}
				}
%>						</div>
					</td>
				</tr>
			</table>
		</td>
	</tr>

<%			
		}
		else if(otherSegment)
		{
%>			<tr>
				<td width="100%" height="100%" >
					<table  cellspacing="0" cellpadding="0" width="100%" border="0" align="center">
						<tr>
							<td width="100%" height="100%" align="center" valign="middle"> <img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><egui:intnl text="admin.error.The selected component(s) is associated to the "/>
							<egui:intnl text="admin.common.Segment "/>&nbsp;<%=otherSegName%> 
							</td>
						</tr>
					</table>
				</td>
			</tr>
<%		}
		else if(newStatus)
		{
%>			<tr>
				<td width="100%" height="100%" >
					<table  cellspacing="0" cellpadding="0" width="100%" border="0" align="center">
						<tr>
							<td width="100%" height="100%" align="center" valign="middle"> <img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif">
							</td>
						</tr>
						<tr><td>&nbsp;</td></tr>
						<tr align="center">
							<td class="eg_subcontent" align="center">
								<a href="#" class="eg_monlink" onClick="javascript:OpenManageDivs('single');">
								<b>Click here</b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0">
								</a>
								to Add/Manage the component
							</td>
						</tr>
					</table>
				</td>
			</tr>
<%		}
	}
	else
	{
%>
	<tr>
		<td height="20" align="left"  class="" style="border-bottom-width:1px">  
			<table align="center" cellspacing="0" cellpadding="4" border="0" >
				<tr>
					<td height="24" nowrap align="right"><img src="/final/admin/eg_images/info2.gif"> </td>
					<td height="24" nowrap><egui:intnl text="admin.servers.Hosts associated with "/><b>&nbsp;<%=groupName%><b></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td width="100%" class="" align="center" valign="top">
			<div class="div_scroll" style="width:100%;height:100%;border:0px solid #ff0000;">
				<table align="center" width="95%" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td valign="top" width="100%" align="center" >&nbsp;</td>
					</tr>
					<tr>
						<td valign="top">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed;" >
								<col width="7"><col width="100%"><col width="90"><col width="150"><col width="7">
								<tr>
									<td id="subhead_left" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
									
									<td id="eg_subheadbg" height="22" align="center" style="border-left-width:0px"><strong><egui:intnl text="admin.servers.Host / Nick Name"/></strong></td>
									<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Port"/></strong></td>
									<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Component Type"/></strong></td>
									<td id="subhead_right" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								</tr>
<%
	Set keySet = compTable.keySet();
	Iterator itr = keySet.iterator();
	while(itr.hasNext())
	{
		String key = (String)itr.next();
		String mappingCompType = _mapping.getComponentTypeDescription(key);
		ArrayList nameList = (ArrayList)compTable.get(key);
		if(nameList==null || nameList.size() == 0)
		{
			continue;
		}
		else
		{
			for(int k=0;k<nameList.size();k++)
			{
				String element = (String) nameList.get(k);
				StringTokenizer st = new StringTokenizer(element,":");
				int count = st.countTokens();
				String hostName = "";
				String portNo = "";
				String sid = "-";
				boolean isOraServer = false;
				if(count == 2)
				{
					hostName = st.nextToken();
					portNo = st.nextToken();
				}
				else if(count == 3)	// Only for Oracle_Database Component
				{
					hostName = st.nextToken();
					portNo = st.nextToken();
					sid = st.nextToken();
					isOraServer = true;
				}
				if(portNo!=null && portNo.equalsIgnoreCase("NULL"))
					portNo = "-";
%>
							<tr>
								<td width="7" id="cell_border4"  style="border-left-width:1px;border-right-width:0px" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td id="cell_border4" align="left" class="left_space10" height="22" style="border-left-width:0px"><b><%=hostName%>&nbsp;<%=isOraServer?"("+sid+")":""%></b></td>
								<td id="cell_border3" align="left"class="left_space10" height="22"><%=portNo%></td>
								<td style="border-right-width:0px" id="cell_border4" align="left" class="left_space10" height="22"><egui:intnl type="<%=mappingCompType%>"/></td>
								<td width="7" id="cell_border4"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="22"></td>
							</tr>
<%
			}
		}
	}
%>
							</table>
						</td>
					</tr>
				</table>
			</div>
		</td>
	</tr>
<%
	}
%>
<input type="hidden" id="modifySegment" name="modifySegment" value="<%=modifySegment%>" >
</table>
</form>
</body>
</html>
<%
}
catch(Exception e)
{
	System.out.println("Exception Occured in EgTopologyGroupPage.jsp..");
	e.printStackTrace();
}
%>

<%!
	/*
		This method returns, list of managed components form the given segment name
	*/
	private ArrayList getManagedComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		ArrayList result = new ArrayList();
		Set thisSet = new TreeSet();
		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String checkValue = disIniFile.getValue(thisCompName,varName);
			//if(checkValue!=null && checkValue.length() > 0){
			if(!varName.startsWith("Group")){
				thisSet.add(varName);
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens()){
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String chkval = disIniFile.getValue(tmpcompname,tmpvar);
				//if(chkval!=null && chkval.length() > 0){
				if(!tmpvar.startsWith("Group")){
					thisSet.add(tmpvar);
				}
			}
		}
		if(thisSet!=null && thisSet.size() > 0){
			result = new ArrayList(thisSet);
		}
		return result;
	}
%>