<%
/**
 *	File name       :   Egnewremoteagentsp.jsp
 *  Purpose         :   Process page.
 *  Version         :   5.0
 *  Creation Date   :   18/10/2003
 *  Last Date       :
 *  Author          :	Babu S
 *	Modified		:	09/07/2004	Arun	Checks to see if the nickname 
 *						assigned to an agent
 *						performing client emulation or to another remote 						   agent.

 *  -1      :     Nickname already exists ;
 *  -2      :     Nickname exists with same ip but the given nick differ in case;
 *  -3      :     Nickname managed with some other ip;
 *  -4      :     Nickname used for client emulation;
 *   0      :     successfully updated.
 */

%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.RemoteAgent"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String r_option = request.getParameter("addAsRemote");
	String externalResultStr = request.getParameter("externalResultString");
	String url = "EgDispRemoteAgents.jsp";
	String toExtAgnt = request.getParameter("external");
	String s_mode = request.getParameter("mode");
	String s_hostip = request.getParameter("hostip");
	String s_hostname = request.getParameter("hostname");
	String old_ip = request.getParameter("old_ip");
	String s_eagent = request.getParameter("eagent");
	String vmware = request.getParameter("remote_vmware");
	s_mode = (s_mode == null? "" : s_mode);
	old_ip = (old_ip == null? "" : old_ip);
	s_hostip = (s_hostip == null? "" : s_hostip);
	s_hostname = (s_hostname == null? "" : s_hostname);
	toExtAgnt = (toExtAgnt == null? "" : toExtAgnt);
	r_option = (r_option == null? "" : r_option);
	externalResultStr = (externalResultStr == null? "" : externalResultStr);
				

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Remote Agents");
	/* code for auditlog ends */
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String[] extAgents = extInfo.getAllExternalAgents();
	List extList = Arrays.asList(extAgents);
	String s_eagentip = extInfo.getIpForRemoteAgent(s_eagent);
	s_eagentip = (s_eagentip == null? "" : s_eagentip);
	RemoteAgent remAgntObj = new RemoteAgent();
	if (s_mode.equalsIgnoreCase("add"))
	{
		String resultInStr = remAgntObj.add(s_hostip,s_hostname);
		resultInStr = resultInStr.substring(0,resultInStr.indexOf("#"));
		int updateResult = Integer.parseInt(resultInStr);
				
		if (updateResult == -2 || updateResult == -3)
		{
			String IP = remAgntObj.getManagedIPForNick();
			
			if (IP == null)
			{
				IP = s_hostip;
			}
			String originalName = remAgntObj.getOriginalHostName();
			Vector err_msg = new Vector();
			err_msg.add(_mapping.getTextDescription("admin.error.Agent Settings Page"));
			err_msg.add("EgDispRemoteAgents.jsp");
			err_msg.add(_mapping.getTextDescription("admin.error.Add new remote agent"));
			err_msg.add(_mapping.getTextDescription("admin.error.The host/nick name"));
			err_msg.add(" ("+"<b>"+s_hostname+"</b>"+") ");
			err_msg.add(_mapping.getTextDescription("admin.error.You are trying to add is already associated with the IP"));
			err_msg.add(" ("+"<b>"+IP+"</b>"+") ");
			err_msg.add(_mapping.getTextDescription("admin.error.in the following manner")+"."+"<br>"+"<br>");
			err_msg.add("<table border='0' cellspacing='0' cellpadding='3' width='50%'><tr><td width='50%' id='eg_subheadbg' style='text-align:left'><strong>"+_mapping.getTextDescription("admin.common.IP")+"</strong></td><td width='50%' id='eg_subheadbg' style='text-align:left'><strong>"+_mapping.getTextDescription("admin.common.Host/Nick name")+"</strong></td></tr><tr><td width='50%' id='cell_border1'>"+IP+"</td><td width='50%' id='cell_border1'>"+originalName+"</td></tr></table><br>");

			if (updateResult == -2)
			{
				err_msg.add(_mapping.getTextDescription("admin.error.As the host/nick name is case insensitive, please use the old host/nick name"));
				err_msg.add("(<b>" + originalName + "</b>)"+".");
			}
			else
			{
				err_msg.add(_mapping.getTextDescription("admin.error.Please use another host/nick name")+"."+"<br>");
			}
			session.setAttribute("vec_Errors",err_msg);
			
			auditLogThread.setValue("Activity","Add/Delete");
			auditLogThread.setCurrentValue("ColumnName","Agent Not Created");
			auditLogThread.setCurrentValue("Host/Nick name",s_hostname);
			auditLogThread.setValue("Description","Remote agent has not been created as this host/nick name is used by another remote agent");
			auditLogThread.sendItToDB();
			url = "EgErrors.jsp";
			
		}
		else if (updateResult == -4)
		{
			Vector err_msg = new Vector();
			err_msg.add(_mapping.getTextDescription("admin.error.Agent Settings Page"));
			err_msg.add("EgDispRemoteAgents.jsp");
			err_msg.add(_mapping.getTextDescription("admin.error.Add new remote agent"));
			err_msg.add(" "+_mapping.getTextDescription("admin.error.This host/nick name is used by another agent for client emulation")+"!");
			err_msg.add(" "+_mapping.getTextDescription("admin.error.Please use another host/nick name")+".");
			session.setAttribute("vec_Errors",err_msg);
			auditLogThread.setValue("Activity","Add/Delete");
			auditLogThread.setCurrentValue("Host/Nick name",s_hostname);
			auditLogThread.setValue("Description","Remote agent has not been created as this host/nick name is used by another agent for client emulation");
			auditLogThread.sendItToDB();
			url = "EgErrors.jsp";
			
		}
		else if (updateResult == -5)
		{
			Vector err_msg = new Vector();
			err_msg.addElement(_mapping.getTextDescription("admin.error.List of remote agents page"));
			err_msg.addElement("EgDispRemoteAgents.jsp");
			err_msg.addElement(_mapping.getTextDescription("admin.error.Add new remote agent"));
			if (remAgntObj.isVmwareAgent(vmware))
			{
				err_msg.addElement(_mapping.getTextDescription("admin.error.The Vmware host could not be monitored as a remote agent because you have exceeded the number of remote/premium agents allowed by your license")+"!");
			}
			else
			{
				err_msg.addElement(_mapping.getTextDescription("admin.error.You have exceeded the number of remote/premium agents allowed by your license")+"!");
			}
			err_msg.addElement(_mapping.getTextDescription("admin.error.To monitor additional remote agents")+", "+_mapping.getTextDescription("admin.error.admin.error.please contact <b>license@eginnovations*com</b>")+" .");
			session.setAttribute("vec_Errors",err_msg);
			
			auditLogThread.setValue("Activity","Add/Delete");
			auditLogThread.setCurrentValue("Agent Host/Nick Name",s_hostname);
			auditLogThread.setValue("Description","Remote agent has not been created as you have exceeded the number of remote/premium agents allowed by your license");
			auditLogThread.sendItToDB();
			
			url = "EgErrors.jsp?extRsltStr="+externalResultStr;
			
		}
		else if (updateResult == 0)
		{
			if(r_option.equals("true"))
			{
				if(externalResultStr.equals("eG_CLI_0010"))
				{
					Vector sess_vec = new Vector();
					sess_vec.add(_mapping.getTextDescription("admin.server.Configure external agents page"));
					sess_vec.add("EgDispExtAgents.jsp");
					sess_vec.add(_mapping.getTextDescription("admin.server.Configure external agents page"));
					sess_vec.add(_mapping.getTextDescription("admin.server.The following agent has been configured as an external agent with host IP")+" "+s_hostip+"<br><br>"+s_hostname);
					sess_vec.add(_mapping.getTextDescription("admin.server.The following agent has been configured as remote agent with host IP")+" "+s_hostip+"<br><br>"+s_hostname);
					session.setAttribute("vec_Results",sess_vec);
					url="EgResults.jsp";
				}
				else
				{
					Vector sess_vec = new Vector();
					sess_vec.add(_mapping.getTextDescription("admin.server.Configure remote agents page"));
					sess_vec.add("EgDispRemoteAgents.jsp");
					sess_vec.add(_mapping.getTextDescription("admin.server.Configure remote agents page"));
					sess_vec.add(_mapping.getTextDescription("admin.server.The following agent has been configured as remote agent with host IP")+" "+s_hostip+"<br><br>"+s_hostname);
					session.setAttribute("vec_Results",sess_vec);
					url="EgResults.jsp";
				}
			}
			else if(toExtAgnt.equals("true"))
			{
				if(extList.contains(s_hostname))
				{
					Vector sess_vec = new Vector();
					sess_vec.add(_mapping.getTextDescription("admin.server.Configure remote agents page"));
					sess_vec.add("EgDispRemoteAgents.jsp");
					sess_vec.add(_mapping.getTextDescription("admin.server.Configure remote agents page"));
					sess_vec.add(_mapping.getTextDescription("admin.server.The following agent has been configured as remote agent with host IP")+" "+s_hostip+"<br><br>"+s_hostname);
					sess_vec.add(_mapping.getTextDescription("admin.server.The external agent you are trying to add already exists"));
					session.setAttribute("vec_Results",sess_vec);
					url="EgResults.jsp?icon=exclamation";
				}
				else
				{
					url = "Egnewextagentsp.jsp?Btype=NewAgnt&remoteUpdateResult=0&addAsExternal=true&clientEmulation=false&hostip="+s_hostip+"&hostname="+s_hostname;
				}
			}
			else if(toExtAgnt.equals("false"))
			{
				Vector sess_vec = new Vector();
				sess_vec.add(_mapping.getTextDescription("admin.server.Configure remote agents page"));
				sess_vec.add("EgDispRemoteAgents.jsp");
				sess_vec.add(_mapping.getTextDescription("admin.server.Configure remote agents page"));
				sess_vec.add(_mapping.getTextDescription("admin.server.The following agent has been configured as remote agent with host IP")+" "+s_hostip+"<br><br>"+s_hostname);
				session.setAttribute("vec_Results",sess_vec);
				url="EgResults.jsp";

			}
			auditLogThread.setValue("Activity","Add/Delete");
			auditLogThread.setCurrentValue("ColumnName","Created Agent");
			auditLogThread.setCurrentValue("Agent IP Address",s_hostip);
			auditLogThread.setCurrentValue("Agent Host/Nick Name",s_hostname);
			auditLogThread.setValue("Description","Remote agent has been created");
			auditLogThread.sendItToDB();

		}
%>
	<jsp:forward page="<%=url%>"/>
<%
	}
	if (s_mode.equalsIgnoreCase("modifyip"))
	{	
		Vector sess_vec = new Vector();
		
		if (!old_ip.equals(s_hostip))
		{
			boolean ischangedIpUpdated = remAgntObj.modify(s_hostname,old_ip,s_hostip);
			if(ischangedIpUpdated)
			{
				String modifyComps = remAgntObj.getModifiedComponents();
				String modExtHosts = remAgntObj.getModifiedExternalHosts();

				List resultList = new ArrayList();
				if(modifyComps != null)
				{
					int idx = modifyComps.indexOf(":");
					if(idx != -1)
					{
						modifyComps = modifyComps.substring(idx+1);
						StringTokenizer stt = new StringTokenizer(modifyComps,":");
						while(stt.hasMoreTokens())
						{
							String tmpHost = stt.nextToken();
							if (tmpHost.indexOf("|") > 0)
							{
								resultList.add(tmpHost.substring(0,tmpHost.indexOf("|"))+" ("+_mapping.getComponentTypeDescription(tmpHost.substring(tmpHost.indexOf("|")+1))+")");
							}
						}
						Collections.sort(resultList);
					}
					else
						modifyComps = "";
				}
				String sessResult = resultList.toString();
				sessResult = sessResult.substring(1,sessResult.length() -1);
				sess_vec.add(_mapping.getTextDescription("admin.server.Configure remote agents page"));
				sess_vec.add("EgDispRemoteAgents.jsp");
				sess_vec.add(_mapping.getTextDescription("admin.server.Configure remote agents page"));
				sess_vec.add(_mapping.getTextDescription("admin.server.The following remote agent is/are updated with the new host IP")+" "+s_hostip+"<br><br>"+s_hostname);
				
				auditLogThread.setValue("Activity","Modify");
				auditLogThread.setValue("Description", "Host IP has been modified");
				auditLogThread.setCurrentValue("01~~Old host IP",old_ip);
				auditLogThread.setCurrentValue("02~~New host IP",s_hostip);
				auditLogThread.setCurrentValue("05~~Modified remote agent(s)",s_hostname);
				if (modifyComps!=null && modifyComps.length() > 0)
				{
					sess_vec.add(_mapping.getTextDescription("admin.server.The following component(s) is/are updated with the new host IP")+" "+s_hostip+"<br><br>"+sessResult);
					auditLogThread.setCurrentValue("03~~Modified host(s)", sessResult);
				}
				if (modExtHosts!=null && modExtHosts.length() > 0)
				{
					sess_vec.add(_mapping.getTextDescription("admin.server.The following external host(s) is/are updated with the new host IP")+" "+s_hostip+"<br><br>"+modExtHosts);
					auditLogThread.setCurrentValue("04~~Modified external agent(s)", modExtHosts);
				}
				session.setAttribute("vec_Results",sess_vec);
				auditLogThread.sendItToDB();
				url = "EgResults.jsp";
			}
			else
			{
				sess_vec.add(_mapping.getTextDescription("admin.server.Configure external agents page"));
				sess_vec.add("EgDispExtAgents.jsp");
				sess_vec.add(_mapping.getTextDescription("admin.server.Configure external agents page"));
				sess_vec.add(_mapping.getTextDescription("admin.server.Not properly updated with the new host IP")+", "+s_hostip);
				session.setAttribute("vec_Errors",sess_vec);
				if(toExtAgnt.equals("true"))
				{
					url = "EgErrors.jsp?targetjsp=Egnewextagentsp.jsp&hostip="+s_hostip+"&hostname="+s_hostname;
				}
				else
				{
					url = "EgErrors.jsp";
				}

			}
		}
		if(toExtAgnt.equals("true"))
		{
			url = "Egnewextagentsp.jsp?Btype=NewAgnt&addAsExternal=true&clientEmulation=false&hostip="+s_hostip+"&hostname="+s_hostname;
		}
%>
	<jsp:forward page="<%=url%>"/>
<%
	}
	if(s_mode.equalsIgnoreCase("del"))
	{
		Vector sess_vec = new Vector();
		String delResult =  remAgntObj.delete(s_eagent);
		if(delResult.indexOf("#") != -1)
		{
			delResult = delResult.substring(0,delResult.indexOf("#"));
		}
		boolean isAgentdeleted = delResult.equalsIgnoreCase("1")?true:false;
		if (isAgentdeleted)
		{
			sess_vec.add(_mapping.getTextDescription("admin.server.Configure remote agents page"));
			sess_vec.add("EgDispRemoteAgents.jsp");
			sess_vec.add(_mapping.getTextDescription("admin.server.Configure remote agents page"));
			sess_vec.add(_mapping.getTextDescription("admin.server.The following remote agent has been deleted successfully")+" "+s_eagentip+"<br><br>"+s_eagent);
			session.setAttribute("vec_Results",sess_vec);

			auditLogThread.setValue("Activity","Add/Delete");
			auditLogThread.setCurrentValue("ColumnName","Deleted Agent");
			auditLogThread.setCurrentValue("Agent Host/Nick Name",s_eagent);
			auditLogThread.setValue("Description","Remote agent has been deleted");
			auditLogThread.sendItToDB();
			url="EgResults.jsp?targetjsp=Egnewremoteagentsp.jsp&deleteAgent="+s_eagent; 
		}
		else if (delResult.equals("eG_CLI_Err_0038"))
		{
			//Vector sess_vec = new Vector();
			sess_vec.add(_mapping.getTextDescription("admin.error.List of remote agent"));
			sess_vec.add("EgDispRemoteAgents.jsp");
			sess_vec.add(_mapping.getTextDescription("admin.error.Delete remote agent"));
			sess_vec.add(_mapping.getTextDescription("admin.error.This remote agent has been used as an internal agent to one or more hosts")+".");
			sess_vec.add(_mapping.getTextDescription("admin.error.It needs to be disassociated as the internal agent from the host(s)")+".");
			sess_vec.add(_mapping.getTextDescription("admin.error.Go to the Components Add/Modify page to perform this action before deleting this agent")+".");
			session.setAttribute("vec_Errors",sess_vec);
			url = "EgErrors.jsp";
			/* auditlog - start */
			auditLogThread.setValue("Activity","Add/Delete");
			auditLogThread.setCurrentValue("ColumnName","Remote Agent Not Deleted");
			auditLogThread.setCurrentValue("Host/Nick name",s_eagent);
			auditLogThread.setValue("Description","Remote agent has not been deleted since it is assigned as an internal agent to one or more hosts");
			auditLogThread.sendItToDB();
			/* auditlog - end */
		}
		else
		{
			sess_vec.addElement(_mapping.getTextDescription("admin.error.List of remote agents page"));
			sess_vec.addElement("EgDispRemoteAgents.jsp");
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Delete remote agent"));
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Remote agent is been used by host(s)")+".");
			sess_vec.addElement(_mapping.getTextDescription("admin.error.This remote agent needs to be disassociated from the host(s) it is monitoring")+".");
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Go to the Assign Remote Agents Page to perform this action before deleting this agent")+".");
			session.setAttribute("vec_Errors",sess_vec);
			auditLogThread.setValue("Activity","Add/Delete");
			auditLogThread.setCurrentValue("Agent Host/Nick Name",s_eagent);
			auditLogThread.setValue("Description","Remote agent has not been deleted as it is being used by host(s)");
			auditLogThread.sendItToDB();
			url="EgErrors.jsp";
		}
%>
<jsp:forward page="<%=url%>"/>
<%
		
	}
%>



