<%
/*****************************************************************************
*	Name 		:	Egtestinfoviewp.jsp
*	Purpose		:	This collects the set of info enabled or 
				disabled for a particular test. If any info
				is disabled newly it goes on to delete data
				pertaining to this info from all the tables
				of the eGurkha database.
				It also updates the eg_testinfo.ini file 
				which the agent would download eventually to
				update its list of measures to be uploaded.
******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.UpdateAndTransmitTrendInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="com.egurkha.util.ListUtils" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgTestInfo" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	private static Hashtable recentEnableValues = new Hashtable();
%>

<%
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Test Descriptors");
	boolean isAuditLogDataUpdated = false;
	boolean isDisableAction = false;
	/* code for auditlog ends */

	UpdateAndTransmitTrendInfo updateHelper = new UpdateAndTransmitTrendInfo();
	String delInfo = "";
	EgTestInfo testInfo = new EgTestInfo(true);
	ArrayList al_enabled = new ArrayList();
	ArrayList al_disabled = new ArrayList();
	ArrayList iniList = new ArrayList();
	ArrayList newly_enabled = new ArrayList();
	ArrayList newly_disabled = new ArrayList();
	List tmpRecentDataList = new ArrayList();
	
	String from = request.getParameter("from");
	String serverType = request.getParameter("server");
	String compName = request.getParameter("comp");
	String testName = request.getParameter("testName");
	String selection = request.getParameter("duration");
	String enabledDesc = request.getParameter("enabledDescList");
	String disabledDesc = request.getParameter("disabledDescList");
	String isSearchBox = request.getParameter("isSearchBox");
	String disableAction = request.getParameter("disableaction");

	if(!StringUtils.isNull(disableAction) && disableAction.equals("true"))
	{
		isDisableAction = true;
	}
	int ind = compName.indexOf(":");
	String newComp = compName.substring(ind+1);

	String compA = compName.substring(compName.indexOf(":")+1);
	iniList = testInfo.getTestInfoFor(compA+":"+serverType,serverType);
	al_disabled = StringUtils.egTokenizer(disabledDesc,",");

	if(!StringUtils.isNull(from) && from.equals("delete"))
	{
		String removeStringFormIni = "";
		String deleteData = "";
		for(int k=0; k<iniList.size(); k++)
		{
			String str = (String) iniList.get(k);
			int in = str.indexOf("=");
			String test = str.substring(0, in);
			if(test.equals("WebLogicEjbTest"))
				continue;
			if(test.equals("WsEjbTest"))
				continue;
			String info = str.substring(in + 1);
			if(test.equals(testName))
			{
				ArrayList al_iniVal = StringUtils.egTokenizer(info,",");
				if(al_iniVal != null && al_iniVal.size() > 0)
				{
					for(int i=0;i<al_iniVal.size();i++)
					{
						String tmpIniData = (String) al_iniVal.get(i);
						if(al_disabled != null && !al_disabled.contains(tmpIniData))
						{
							removeStringFormIni += tmpIniData.trim()+",";
						}
						else
						{
							deleteData += tmpIniData.trim()+",";
						}
					}
				}
			}
		}
		auditLogThread.setValue("Activity","Deletion");
		if(deleteData.length() > 1)
		{
			deleteData = deleteData.substring(0,deleteData.length()-1);
			auditLogThread.setCurrentValue("Deleted Descriptor(s)", deleteData);
			isAuditLogDataUpdated = true;
		}

		testInfo.setTestInfo(compName, testName, removeStringFormIni); // for INI delete
	/*code for auditlog starts */
		String nullRemoved = newComp.endsWith(":NULL")?newComp.substring(0,newComp.lastIndexOf(":")):newComp;
		auditLogThread.setValue("Description","Descriptors have been deleted for the test " + _mapping.getTestDescription(testName) + " for component "+"$ctype$:"+(nullRemoved));
	/*code for auditlog ends */
	}
	else
	{
		al_enabled = (ArrayList) session.getAttribute("oldEnabledDescList");
		ArrayList tmpEnable = StringUtils.egTokenizer(enabledDesc,",");
		for(int k=0; k<iniList.size(); k++)
		{
			String str = (String) iniList.get(k);
			int in = str.indexOf("=");
			String test = str.substring(0, in);
			if(test.equals("WebLogicEjbTest"))
				continue;
			if(test.equals("WsEjbTest"))
				continue;
			String info = str.substring(in + 1);
			if(test.equals(testName))
			{
				ArrayList al_iniVal = StringUtils.egTokenizer(info,",");
				if(al_iniVal != null && al_iniVal.size() > 0)
				{
					for(int i=0;i<al_iniVal.size();i++)
					{
						String tmpDisableData = (String) al_iniVal.get(i);
						if(al_enabled != null && tmpEnable != null && !al_enabled.contains(tmpDisableData) && tmpEnable.contains(tmpDisableData))
						{
							if(!tmpRecentDataList.contains(tmpDisableData))
							{
								tmpRecentDataList.add(tmpDisableData.trim());
							}
						}
						else
						{
							delInfo += tmpDisableData.trim()+",";
						}
					}
				}
				if(al_disabled != null && al_disabled.size() > 0)
				{
					for(int j=0;j<al_disabled.size();j++)
					{
						String newDisableData = (String) al_disabled.get(j);
						if(al_iniVal == null || al_enabled == null || tmpEnable == null)
						{
							delInfo += newDisableData+",";
						}
						else if(!al_iniVal.contains(newDisableData) && al_enabled.contains(newDisableData) )
						{
							delInfo += newDisableData.trim()+",";
						}
					}
				}
				if(!StringUtils.isNull(isSearchBox) && isSearchBox.equals("true"))
				{
					if(tmpEnable != null && tmpEnable.size() > 0)
					{
						for(int e=0;e<tmpEnable.size();e++)
						{
							String newEnableData = (String) tmpEnable.get(e);
							if(al_iniVal.contains(newEnableData) && !al_disabled.contains(newEnableData))
							{
								if(!tmpRecentDataList.contains(newEnableData))
								{
									tmpRecentDataList.add(newEnableData.trim());
								}
							}
						}
					}
					if(al_disabled != null && al_disabled.size() > 0)
					{
						for(int j=0;j<al_disabled.size();j++)
						{
							String newDisableData = (String) al_disabled.get(j);
							if(al_iniVal == null || al_enabled == null)
							{
								delInfo += newDisableData.trim()+",";
							}
							else if(tmpEnable != null && al_iniVal != null && !al_iniVal.contains(newDisableData) && !tmpEnable.contains(newDisableData))
							{
								delInfo += newDisableData.trim()+",";
							}
						}
					}
				}
				if(tmpRecentDataList != null && tmpRecentDataList.size() > 0)
				{
					if(recentEnableValues.containsKey(test+":"+compName))
					{
						
						List tempInfo = (ArrayList) recentEnableValues.get(test+":"+compName);
						tempInfo.addAll(tmpRecentDataList);
						ListUtils.removeDuplicates(tempInfo);
						recentEnableValues.put(test+":"+compName, tempInfo);
						continue;
					}
					ListUtils.removeDuplicates(tmpRecentDataList);
					recentEnableValues.put(test+":"+compName,tmpRecentDataList);
				}
			}
		}
		if(al_disabled != null && al_disabled.size() > 0)
		{
			for(int j=0;j<al_disabled.size();j++)
			{
				String newDisableData = (String) al_disabled.get(j);
				if(al_enabled == null || tmpEnable == null)
				{
					delInfo += newDisableData+",";
				}
				else if(tmpEnable != null && !tmpEnable.contains(newDisableData))
				{
					delInfo += newDisableData+",";
				}
				else
				{
					if(!StringUtils.isNull(isSearchBox) && isSearchBox.equals("true") && al_enabled.contains(newDisableData) )
					{
						delInfo += newDisableData+",";
					}
				}
			}
		}

		if(delInfo.length() > 1)
		{
			delInfo = delInfo.substring(0,delInfo.length()-1);
		}
		updateHelper.updateDescriptors(newComp, testName, delInfo); //for DB delete
		testInfo.setTestInfo(compName, testName, delInfo); // for INI delete

	/*code for auditlog starts */
		auditLogThread.setValue("Activity","Enable/Disable");
		ArrayList previouslyEnabledDesc = (ArrayList) session.getAttribute("oldEnabledDescList");
		newly_enabled = StringUtils.egTokenizer(enabledDesc,",");
		newly_disabled = StringUtils.egTokenizer(disabledDesc,",");

		if(newly_enabled != null && newly_enabled.size() > 0)
		{
			String strNewEnabledDesc  = "";
			for(int en=0; en<iniList.size(); en++)
			{
				String str = (String) iniList.get(en);
				int in = str.indexOf("=");
				String test = str.substring(0, in);
				if(test.equals("WebLogicEjbTest"))
					continue;
				if(test.equals("WsEjbTest"))
					continue;
				String info = str.substring(in + 1);
				if(test.equals(testName))
				{
					ArrayList al_iniVal = StringUtils.egTokenizer(info,",");
					for(int i=0;i<newly_enabled.size();i++)
					{
						String tmpIniData = (String) newly_enabled.get(i);
						if(al_iniVal != null && al_iniVal.contains(tmpIniData))
						{
							strNewEnabledDesc += tmpIniData+",";
						}
					}
				}
			}

			if(strNewEnabledDesc.length() > 1)
			{
				if(strNewEnabledDesc.endsWith(","))
				{
					strNewEnabledDesc = strNewEnabledDesc.substring(0,strNewEnabledDesc.length()-1);
				}
				// remove duplictes
				ArrayList tempEnable = tokenizeInfo(strNewEnabledDesc);
				ListUtils.removeDuplicates(tempEnable);
				strNewEnabledDesc = StringUtils.getString(tempEnable);
				auditLogThread.setCurrentValue("Enabled Descriptor(s)", strNewEnabledDesc);
				isAuditLogDataUpdated = true;
			}
		}
		if(newly_disabled != null && newly_disabled.size() > 0)
		{
			String strNewDisabledDesc = "";
			for(int dis=0; dis<iniList.size(); dis++)
			{
				String str = (String) iniList.get(dis);
				int in = str.indexOf("=");
				String test = str.substring(0, in);
				if(test.equals("WebLogicEjbTest"))
					continue;
				if(test.equals("WsEjbTest"))
					continue;
				String info = str.substring(in + 1);
				if(test.equals(testName))
				{
					ArrayList al_iniVal = StringUtils.egTokenizer(info,",");
					for(int i=0;i<newly_disabled.size();i++)
					{
						String tmpIniData = (String) newly_disabled.get(i);
						if(al_iniVal != null && !al_iniVal.contains(tmpIniData))
						{
							strNewDisabledDesc += tmpIniData+",";
						}
					}
				}
			}
			if(strNewDisabledDesc.length() == 0 && isDisableAction)
			{
				strNewDisabledDesc = StringUtils.getString(newly_disabled);
			}

			if(strNewDisabledDesc.length() > 1)
			{
				if(strNewDisabledDesc.endsWith(","))
				{
					strNewDisabledDesc = 
						strNewDisabledDesc.substring(0,strNewDisabledDesc.length()-1);
				}
				// remove duplictes
				ArrayList tempDisable = tokenizeInfo(strNewDisabledDesc);
				List withoutDuplicates = removeDuplicates(tempDisable);
				strNewDisabledDesc = StringUtils.getString(withoutDuplicates);
				auditLogThread.setCurrentValue("Disabled Descriptor(s)", strNewDisabledDesc);
				isAuditLogDataUpdated = true;
			}
		}
		String nullRemoved = newComp.endsWith(":NULL")?newComp.substring(0,newComp.lastIndexOf(":")):newComp;
		auditLogThread.setValue("Description","Descriptors have been enabled/disabled to the " + _mapping.getTestDescription(testName) + " for component "+"$ctype$:"+(nullRemoved));	
	/*code for auditlog ends */
	}
	if(isAuditLogDataUpdated)
	{
		auditLogThread.sendItToDB();
	}
	String url = "EgTestInfoView.jsp?server=" + serverType + 
		"&comp=" + compName +"&testName="+ testName +"&duration=" + selection + "&newenabledesc="+enabledDesc+"&requestFrom=processUpdated";
	session.setAttribute("recentEnableValues",recentEnableValues);
%>
	<jsp:forward page="<%=url%>" />

<%!
	public ArrayList tokenizeInfo(String str)
	{
			ArrayList al = new ArrayList();
			StringTokenizer st = new StringTokenizer(str, ",");
			int count = st.countTokens();
			for(int i=0; i<count; i++)
			{
					al.add(st.nextToken());
			}
			return al;
	}

	public List removeDuplicates(List list)
	{
		if (list==null)
			return list;
		Set myset = new HashSet(list);
		List list1 = new LinkedList(myset);
		list = list1;
		return list1;
	}
%>





