<%
/**
 *	Process page for EgUserSiteServers.jsp
 *
 *	@author		KrishnaKumar.C
 *	@created	08/05/2001
 *	@version	3.0
 *
 *	@modified
 *		08/05/2001				THIS CODE HAS GENERIC QUERIES
 *		20/08/2001	Sandhya		Display messages appropriately
 *		05/01/2002	Sandhya		Associate a user with all servers of a specific servertype
 *								Made changes to userServerAddUpdate()
 *		18/01/2002	Sandhya		Change user_servertype to user_serv_type
 *		02/07/2002	Sandhya		Prevent the user to be associated to unconfigured Oracle_server.
 *		05/09/2003	Arun		Updates UserRegistry map for the user when configuration is changed
 *		30/12/2003	Arun		Removes :NULL from server names
 *		10/06/2004  Sri Devi G  Manager Clustering changes
 *		5/21/2005	 Pandian page modified according to new UI for version 4.0
		20/12/2011  Sri Devi G  User - VM Changes
 */
%>
<%@ include file = "EgTrackerA.jsp" %>
<%@ page errorPage = "EgProbs.jsp"%>
<%@ page import = "java.sql.ResultSet" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import ="egurkha.EgDbAdapterUI"%>
<%@ page import ="com.eg.EgDbAdapterTypeUI"%>
<%@ page import ="com.eg.DeleteMailFilterElements"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.ListUtils"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@page import="com.eg.EgURLEncoder"%>
<%@page import="com.eg.UpdateAndTransmitTopoInfo"%>
<jsp:useBean class="egurkha.UserInfoBean" id="userinfo" scope="page" />
<jsp:useBean class="com.egurkha.admin.UserDetailsBean" id="userDetails" scope="page" />
<%!
	UpdateAndTransmitTopoInfo updateAndTransmitTopoInfo=new UpdateAndTransmitTopoInfo();
	EgGroupInfo groupInfo = new EgGroupInfo();
	StringUtils util = new StringUtils();
	public String checkForNull(String param)
	{
		return ((param==null) || (param.equalsIgnoreCase(""))) ? "" : param;
	}

	public String removeEmptyString(String mystring)
	{
		String [] myary = util.getTokens(mystring, ",");
		String result = "";
		for (int i=0; i<myary.length; i++)
		{
			String thisEle = myary[i];
			if ((thisEle.equals("")) || (thisEle.equals(" ")))
				continue;
			result+=","+myary[i];
		}
		if (result.startsWith(","))
			result = result.substring(1);
		return result;
	}
	boolean setCurrentValue(String selected, String previousValues, String currentValues, String userName, AuditLogThread auditLogThread)
	{
		boolean isAssociated = false;
		boolean isDisassociated = false;

		Vector cvalues = new Vector();
		Vector pvalues = new Vector();
		
		selected = (selected.endsWith("s")?"Components":(selected +"s"));

		if(previousValues != null && !previousValues.equals("null") && previousValues.trim().length()>0)
		{
			StringTokenizer tokens = new StringTokenizer(previousValues.trim(),",");
			while(tokens.hasMoreTokens())
			{
				String zone = (String) tokens.nextToken();
				pvalues.add(zone);
			}			
		}
		if(currentValues != null && !currentValues.equals("null") && currentValues.trim().length()>0)
		{
			StringTokenizer tokens = new StringTokenizer(currentValues.trim(),",");
			while(tokens.hasMoreTokens())
			{
				String currentZone = (String) tokens.nextToken();
				cvalues.add(currentZone);
			}
		}

		Collections.sort(pvalues);
		Collections.sort(cvalues);
		if(pvalues.size()==cvalues.size() && pvalues.containsAll(cvalues))
			return false;

		auditLogThread.setCurrentValue("ColumnName",selected);

		if(pvalues.size()>0)
		{
			for(int i=0;i<pvalues.size();i++)
			{
				String pzonetemp = (String) pvalues.get(i);
				if(!cvalues.contains(pzonetemp))
				{
					if(pzonetemp != null && pzonetemp.endsWith(":NULL"))
						pzonetemp = pzonetemp.substring(0,pzonetemp.lastIndexOf(":NULL"));
					isDisassociated = true;
					if(selected.equals("Components"))
						auditLogThread.setCurrentValue("Disassociated "+selected,"$ctype$:"+pzonetemp);
					else
						auditLogThread.setCurrentValue("Disassociated "+selected,pzonetemp);
				}

				if(cvalues.contains(pzonetemp))
					cvalues.remove(pzonetemp);	
			}
			for(int i=0;i<cvalues.size();i++)
			{
				String strTmp = (String) cvalues.get(i);
				if(strTmp != null && strTmp.endsWith(":NULL"))
					strTmp = strTmp.substring(0,strTmp.lastIndexOf(":NULL"));
				isAssociated = true;
				if(selected.equals("Components"))
					auditLogThread.setCurrentValue("Associated "+selected, "$ctype$:"+strTmp);
				else
					auditLogThread.setCurrentValue("Associated "+selected, strTmp);
			}
		}
		else
		{
			for(int i=0;i<cvalues.size();i++)
			{
				String strTmp = (String) cvalues.get(i);
				if(strTmp != null && strTmp.endsWith(":NULL"))
					strTmp = strTmp.substring(0,strTmp.lastIndexOf(":NULL"));
				isAssociated = true;
				if(selected.equals("Components"))
					auditLogThread.setCurrentValue("Associated "+selected, "$ctype$:"+strTmp);
				else
					auditLogThread.setCurrentValue("Associated "+selected, strTmp);
			}
		}
		if(isAssociated && isDisassociated)
			auditLogThread.setValue("Description",selected + " have been associated and disassociated for the user " + userName);			
		else if(isAssociated)
			auditLogThread.setValue("Description",selected + " have been associated to the user " + userName);
		else
			auditLogThread.setValue("Description",selected + " have been disassociated from the user " + userName);	
		return true;
	}

	public boolean userServiceGroupAddOrUpdate(String s_user_id,String [] s_sergroup_list,String s_mode)
	{
		String s_qry = "";
		int j = 0;
		boolean flage=false;
		try
		{
			if(s_mode != null && s_mode.equals("update") || s_mode.equals("change"))
			{
				s_qry = "DELETE FROM user_servicegroup where user_id ='" + s_user_id + "'";
				flage=updateAndTransmitTopoInfo.deleteFromDb(s_qry);
			}

			if(s_sergroup_list != null)
			{
				for(int i=0;i < s_sergroup_list.length;i++)
				{
					s_qry = "INSERT INTO user_servicegroup values('" + s_user_id + "','" + s_sergroup_list[i] + "')";
					flage = updateAndTransmitTopoInfo.insertToDb(s_qry);
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("The Exception in userServiceGroupAddOrUpdate is " + e.toString());
			e.printStackTrace();
			return false;
		}
		return true;
	}
%>
<%
		String compType = checkForNull(request.getParameter("compType"));
		String username = checkForNull(request.getParameter("username"));
		if (username.indexOf("(Group)") != -1)
		{
			int idx = username.indexOf("/");
			int nextIdx = username.indexOf("(Group)");
			String strtempuname = username.substring(0,idx);
			strtempuname = strtempuname + "/Grp/";
			String strtempuname_A = username.substring(idx + 1 ,nextIdx);
			username = strtempuname + strtempuname_A;
			username = username.trim();
		}
		String chosenHosts = checkForNull(request.getParameter("chosenHosts"));
		String majorType = checkForNull(request.getParameter("majorType"));
		String compAssociation = checkForNull(request.getParameter("compAssociation"));
		String permanentAssociation = removeEmptyString(checkForNull(request.getParameter("permanentAssociation")));
		String operation = checkForNull(request.getParameter("operation"));
		String action = checkForNull(request.getParameter("action"));
		String mode = checkForNull(request.getParameter("mode"));
		String reqFrom = checkForNull(request.getParameter("reqfrom"));
		String vHosts = checkForNull(request.getParameter("vHost"));
		String vServer = checkForNull(request.getParameter("vServer"));
		String[] values = request.getParameterValues("virtualTypes");
		StringBuffer sb = new StringBuffer();
		if(permanentAssociation.equalsIgnoreCase("Virtual_Machine"))
		{
			if(values!=null)
			{
				for(int v=0; v < values.length;v++)
				{
					sb.append(values[v]);
					sb.append(",");

				}

				vServer = sb.toString();

				if(vServer.endsWith(","))
				{
					vServer = vServer.substring(0, vServer.lastIndexOf(","));
				}
			}

		}
		mode = (mode.equals(""))?"update":mode;
		reqFrom = (reqFrom.equals(""))?"modify":reqFrom;
		String disAssociatedElems = ""; // this string contains current disassociated elements.
		String previousSelectedValue = checkForNull(request.getParameter("previousSelectedValue"));
		if(!previousSelectedValue.equals(""))
		{
			previousSelectedValue = previousSelectedValue.substring(0,previousSelectedValue.length()-1);
			if(chosenHosts.equals(""))
			{
				disAssociatedElems = previousSelectedValue;
			}
			else if(!chosenHosts.equals(previousSelectedValue))
			{
				ArrayList t1  = StringUtils.myTokenizer(previousSelectedValue,",");
				ArrayList t2  = StringUtils.myTokenizer(chosenHosts,",");
				if(t1 != null && t2 != null)
				{
					t1.removeAll(t2);
					if(t1.size() == 0)
					{
						disAssociatedElems = "";
					}
					else
					{
						disAssociatedElems = t1.toString();
						disAssociatedElems = disAssociatedElems.substring(1,disAssociatedElems.length()-1);
						disAssociatedElems = StringUtils.replace(disAssociatedElems,", ",",");
					}
				}
			}
		}
		Hashtable initParams = new Hashtable();
		initParams.put("username",username);
		initParams.put("compAssociation",compAssociation);
		initParams.put("majorType",majorType);
		initParams.put("mode",mode);
		initParams.put("reqFrom",reqFrom);
		initParams.put("chosenHosts",chosenHosts);
		initParams.put("permanentAssociation",permanentAssociation );
		initParams.put("serverTypeDB",permanentAssociation);
		if(permanentAssociation.equalsIgnoreCase("Virtual_Machine"))
		{
			initParams.put("vServer",vServer);
			initParams.put("removeHosts",disAssociatedElems);
		}
		if(majorType!=null && majorType.trim().length()>0 && majorType.equalsIgnoreCase("ServiceGroup") && chosenHosts!=null)
		{
			String [] assArray = util.getTokens(chosenHosts, ",");
			boolean flage_for_update=userServiceGroupAddOrUpdate(username,assArray,mode);
		}
		else
		{
%>
		<jsp:setProperty name="userinfo" property="initParams" value="<%=initParams%>"/>
<%
				if(permanentAssociation.equalsIgnoreCase("Virtual_Machine"))
				{
%>
<%
					Hashtable newHash = (Hashtable)session.getAttribute("serverTypeVMs");
%>
					<jsp:setProperty name="userinfo" property="mserverTypeVMs" value="<%=newHash%>"/>
					<jsp:getProperty name="userinfo" property="vmUpdateStatus"/>
<%
				}
				else
				{

%>
					<jsp:getProperty name="userinfo" property="servUpdateStatus"/>
<%
				}
		}
		String previousZones = request.getParameter("previouszones");
		String previousServices = request.getParameter("previousservices");
		String previousServiceGroups = request.getParameter("previousservicegroup");

		String previousSegments = request.getParameter("previoussegments");
		String previousServers = request.getParameter("previouscomponents");
		String previousVMs = request.getParameter("previousVMs");
		previousZones = checkForNull(previousZones);
		previousServices = checkForNull(previousServices);
		previousServiceGroups = checkForNull(previousServiceGroups);
		previousSegments = checkForNull(previousSegments);
		previousServers = checkForNull(previousServers);
		previousVMs = checkForNull(previousVMs);
		/* code for auditlog starts */
		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","User Management");
		auditLogThread.setValue("Activity","Element Association");
		boolean canSend = false;

		String selected = request.getParameter("selected");		

		if(selected !=null && !selected.equals("-1"))
		{
			String now = "";
			if(selected.equals("Zone"))
			{
				now = "zones";
				String currentZones = userinfo.getUserZones(false);
				canSend = setCurrentValue(selected, previousZones, currentZones, request.getParameter("username"), auditLogThread);
			}
			else if(selected.equals("Service"))
			{
				now = "services";
				String currentServices = userinfo.getUserServices(false);
				canSend = setCurrentValue(selected, previousServices, currentServices, request.getParameter("username"), auditLogThread);
			}
			else if(selected.equals("ServiceGroup"))
			{
				now = "service groups";
				String currentServiceGroup = userinfo.getUserServiceGroups(false);
				canSend = setCurrentValue(selected, previousServiceGroups, currentServiceGroup, request.getParameter("username"), auditLogThread);
			}
			else if(selected.equals("Segment"))
			{
				now = "segments";
				String currentSegments = userinfo.getUserSegments(false);
				canSend = setCurrentValue(selected, previousSegments, currentSegments, request.getParameter("username"), auditLogThread);
			}
			else if(selected.equals("Independent servers"))
			{
				now = "components";
				String currentServers = userinfo.getUserComponents();	
				canSend = setCurrentValue(selected, previousServers, currentServers, request.getParameter("username"), auditLogThread);
				if(permanentAssociation.equalsIgnoreCase("Virtual_Machine"))
				{
					String currentVMs = userinfo.getUserVMs(vHosts);
					if(currentVMs!=null && currentVMs.length() > 0)
					{
						String[] currVMs = StringUtils.getTokens(currentVMs,",");
						StringBuffer sbuff = new StringBuffer();
						if(currVMs!=null && currVMs.length > 0)
						{
							for(int c=0; c<currVMs.length;c++)
							{
								String s_vm = _mapping.getComponentTypeDescription(_user.getVMType())+":"+currVMs[c];
								sbuff.append(s_vm);
								sbuff.append(",");
							}
						}
						currentVMs = sbuff.toString();
						currentVMs = currentVMs.substring(0,currentVMs.lastIndexOf(","));
					}
					canSend = setCurrentValue(selected, previousVMs, currentVMs, request.getParameter("username"), auditLogThread);
				}
			}
			if(!StringUtils.isNull(now) && !StringUtils.isNull(request.getParameter("assousers")))
			{
				auditLogThread.setCurrentValue("Auto-associate " + now + " to other users",request.getParameter("assousers"));
			}
		}
		if(canSend)
			auditLogThread.sendItToDB();
		/* code for auditlog ends */		

		ArrayList selectedUsers = new ArrayList();
		String finalResult = request.getParameter("finalOperation");
		String newusers=(String)request.getParameter("newusers");
		String assousers=(String)request.getParameter("assousers");

		if(newusers != null && !newusers.equals("null") && newusers.trim().length() != 0)
		{
			//StringTokenizer stt = new StringTokenizer(newusers,"~,~");
			ArrayList tempList = StringUtils.myTokenizer(newusers,"~,~");
			Iterator it = tempList.iterator();
			//while(stt.hasMoreTokens()) 
			//{
			//	String currentUser = stt.nextToken().toString().trim();
			//	if(currentUser.length()>0)
			//		selectedUsers.add(currentUser);
			//}
			while(it.hasNext()) 
			{
				String currentUser = it.next().toString().trim();
				if(currentUser.length()>0)
					selectedUsers.add(currentUser);
			}
		}
		else if(assousers != null && !assousers.equals("null") && assousers.trim().length() != 0)
		{
			//StringTokenizer sttasso = new StringTokenizer(assousers,",");
			ArrayList tempList = StringUtils.myTokenizer(assousers,"~,~");
			Iterator it = tempList.iterator();
			while(it.hasNext()) 
			{
				String currentUser = it.next().toString().trim();
				if(currentUser.length()>0)
					selectedUsers.add(currentUser);
			}
		}
		if(finalResult != null && finalResult.equalsIgnoreCase("added") && selectedUsers.size()>0)
		{
			Hashtable params = new Hashtable();
			for(int index=0;index<selectedUsers.size();index++)
			{
				String selectedUser = selectedUsers.get(index).toString();
				params.put("username",selectedUser);
				params.put("compAssociation",compAssociation);
				params.put("majorType",majorType);
				params.put("mode",mode);
				params.put("chosenHosts",chosenHosts);
				params.put("permanentAssociation",permanentAssociation );

				if(majorType!=null && majorType.trim().length()>0 && majorType.equalsIgnoreCase("ServiceGroup") && chosenHosts!=null)
				{
					String [] assArray = util.getTokens(chosenHosts, ",");
					boolean flage_for_update=userServiceGroupAddOrUpdate(selectedUser,assArray,mode);
				}
				else
				{
	%>
			<jsp:useBean class="egurkha.UserInfoBean" id="infos" scope="page" />
			<jsp:setProperty name="infos" property="initParams" value="<%=params%>"/>
			<jsp:getProperty name="infos" property="servUpdateStatus"/>
	<%
				}
				params.clear();
			}
		}

		//mail filter - start
		ArrayList tempList = StringUtils.myTokenizer(disAssociatedElems,",");
		if(tempList != null && tempList.size() > 0)
		{
			List userList = new ArrayList();
			userList.add(username);

			List removedServersFromUser = null;
			DeleteMailFilterElements delMailFilterElements = new DeleteMailFilterElements();
			if(majorType.equals("Zone"))
			{
				removedServersFromUser = delMailFilterElements.getServersForZones(tempList);
				delMailFilterElements.removeElementsFromMailFilter(userList,removedServersFromUser);
			}
			else if(majorType.equals("Segment"))
			{
				removedServersFromUser = delMailFilterElements.getServersForSegments(tempList);
				delMailFilterElements.removeElementsFromMailFilter(userList,removedServersFromUser);
			}
			else if(majorType.equals("Service"))
			{
				removedServersFromUser = delMailFilterElements.getServersForServices(tempList);
				delMailFilterElements.removeElementsFromMailFilter(userList,removedServersFromUser);
			}
			else if(majorType.equals("ServiceGroup"))
			{
				for(int j=0;j<tempList.size();j++)
				{
					String serviceGroupName=(String)tempList.get(j);
					ArrayList servicesList = groupInfo.getAllServicesFromServiceGroup(serviceGroupName.trim());		
					removedServersFromUser = delMailFilterElements.getServersForServices(servicesList);
					delMailFilterElements.removeElementsFromMailFilter(userList,removedServersFromUser);
				}
			}
			else
			{
				if(permanentAssociation!=null && !permanentAssociation.equalsIgnoreCase("Virtual_Machine"))
				{
					removedServersFromUser = tempList;
					delMailFilterElements.removeElementsFromMailFilter(userList,removedServersFromUser);
				}
			}
		}
		//end

		//String url = "EgUserSiteServers.jsp?qctr=1&associate="+majorType+"&username="+EgURLEncoder.encode(username,"UTF-8")+"&compType="+compAssociation+"&mode="+mode;
		String url = "EgUserSiteServers.jsp?qctr=1&associate="+majorType+"&username="+EgURLEncoder.encode(username,"UTF-8")+"&compType="+compType+"&mode="+mode;

		if(!StringUtils.isNull(assousers))
		{
			url = url +"&assousers="+assousers;
		}
		if(action != null && action.equalsIgnoreCase("confMailFtr"))
		{
			url = "EgMailAlertSuppress.jsp?userID="+EgURLEncoder.encode(username,"UTF-8")+"&reqfrom="+request.getParameter("reqfrom");
		}
		else if(action != null && action.equalsIgnoreCase("finish"))
		{
			Vector sessVec = new Vector();
			sessVec.add((mode.equalsIgnoreCase("change") && operation.equalsIgnoreCase("add"))?_mapping.getTextDescription("admin.service.Add users"):_mapping.getTextDescription("admin.service.Modify Users"));
			sessVec.add((mode.equalsIgnoreCase("change") && operation.equalsIgnoreCase("add"))?"EgAddUser.jsp?qctr=0":"EgChangeUserProfile.jsp?qctr=0");
			sessVec.add(_mapping.getTextDescription("admin.service.Element Association"));
			sessVec.add(_mapping.getTextDescription("admin.service.The elements have been associated/disassociated successfully")+".");
			session.putValue("vec_Results", sessVec);
			url = "EgResults.jsp";
		}
%>
<jsp:forward page="<%=url%>" />

