<%
/*
 *       Name            :      EgConfigUDConfigTest.jsp
 *       Purpose         :		IC - Component - Config Test (Configuration tests)
 *       CreationDate    :       01/10/2001
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "egurkha.*" %>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	JSONObject hiddens = new JSONObject();

	String server = request.getParameter("server");

	TestBean testBean = new TestBean(true);
	ArrayList tests=testBean.getTestsForServer(server);
	ArrayList configTests = testBean.getConfigTestsForServer(server);
	ArrayList allTests = testBean.getAllConfigTests();
	ArrayList desktopTest = testBean.getDeskTopAgentTests();
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	String[] compTypes = discInfo.getServerTypes();

	String testlist = "";

	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	for(int i=tests.size()-1; i>=0 ; i--)
	{
		testlist += tests.get(i) + ",";
	}
	if(testlist.length() > 0)
			testlist = testlist.substring(0,testlist.length()-1);
	hiddens.put("testlist",testlist);

	String configtestlist = "";
	JSONArray assoList = new JSONArray();
	JSONObject obj = new JSONObject();
	JSONArray cloneAssoTestsJSON = new JSONArray();
	if(configTests!=null)
	{
		ArrayList configTestsTmp = (ArrayList)configTests.clone();
		configTestsTmp = sorter.getSortedTestList(configTestsTmp);
		for(int j=0;j<configTests.size();j++)
		{
			EgName nameObj = (EgName)configTestsTmp.get(j);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();
			configtestlist += tmpVal + ",";
			obj = new JSONObject();
			obj.put("displayField",tmpDis);
			obj.put("valueField",tmpVal);
			assoList.add(obj);
			cloneAssoTestsJSON.add(obj);
		}
	}	
	for (int a=0; a<assoList.size(); a++)
	{
		JSONObject nameObj1 = (JSONObject)assoList.get(a);
		String tmpVal1 = (String)nameObj1.get("valueField");
		String tmpDis1 = (String)nameObj1.get("displayField");
		for (int b=0; b<cloneAssoTestsJSON.size(); b++)
		{
			JSONObject nameObj2 = (JSONObject)cloneAssoTestsJSON.get(b);
			String tmpVal2 = (String)nameObj2.get("valueField");
			String tmpDis2 = (String)nameObj2.get("displayField");
			if (tmpVal1.equalsIgnoreCase(tmpVal2))
			{
				continue;
			}
			if (tmpDis1.equalsIgnoreCase(tmpDis2))
			{
				String compTypeStr = "";
				ArrayList compTypeArr = new ArrayList();
				for(int k =0; k<compTypes.length; k++)
				{
					String compType = compTypes[k];
					boolean flag = specsInfo.isTestRelevantForServer(compType,tmpVal2,true);
					if(flag)
					{
						compTypeArr.add(_mapping.getComponentTypeDescription(compType));
					}
				}
				Collections.sort(compTypeArr,String.CASE_INSENSITIVE_ORDER);
				for(int v=0; v<compTypeArr.size(); v++)
				{
					String compTypeVal = (String)compTypeArr.get(v);
					compTypeStr += compTypeVal+", ";
				}
				if(compTypeStr.endsWith(", "))
				{
					compTypeStr = compTypeStr.substring(0,compTypeStr.length()-2);
				}
				if(compTypeStr!= "" && compTypeStr!=null)
					tmpDis2 = tmpDis2+" ("+compTypeStr+")";

				JSONObject nameObj3 = new JSONObject();
				nameObj3.put("valueField",tmpVal2);
				nameObj3.put("displayField",tmpDis2);
				cloneAssoTestsJSON.remove(b);
				cloneAssoTestsJSON.add(b,nameObj3);
			}
		}
	}	
	rootJSON.put("assoTests",cloneAssoTestsJSON);
	if(configtestlist.length() > 0)
		configtestlist = configtestlist.substring(0, configtestlist.length()-1);
	hiddens.put("configtestlist",configtestlist);

	JSONArray disoList = new JSONArray();
	ArrayList tmpDisoTests = new ArrayList();
	JSONArray cloneDisoTestsJSON = new JSONArray();
	for(int i=0; i<allTests.size(); i++)
	{
		String test = (String) allTests.get(i);
		if(configTests!=null && configTests.contains(test))
			continue;
		if(desktopTest!=null && desktopTest.contains(test))
			continue;
		tmpDisoTests.add(test);
	}
	tmpDisoTests = sorter.getSortedTestList(tmpDisoTests);
	for(int j=0;j<tmpDisoTests.size();j++)
	{
		EgName nameObj = (EgName)tmpDisoTests.get(j);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		obj = new JSONObject();
		obj.put("displayField",tmpDis);
		obj.put("valueField",tmpVal);
		disoList.add(obj);
		cloneDisoTestsJSON.add(obj);
	}	
	for (int a=0; a<disoList.size(); a++)
	{
		JSONObject nameObj1 = (JSONObject)disoList.get(a);
		String tmpVal1 = (String)nameObj1.get("valueField");
		String tmpDis1 = (String)nameObj1.get("displayField");
		for (int b=0; b<cloneDisoTestsJSON.size(); b++)
		{
			JSONObject nameObj2 = (JSONObject)cloneDisoTestsJSON.get(b);
			String tmpVal2 = (String)nameObj2.get("valueField");
			String tmpDis2 = (String)nameObj2.get("displayField");
			if (tmpVal1.equalsIgnoreCase(tmpVal2))
			{
				continue;
			}
			if (tmpDis1.equalsIgnoreCase(tmpDis2))
			{
				String compTypeStr = "";
				ArrayList compTypeArr = new ArrayList();
				for(int k =0; k<compTypes.length; k++)
				{
					String compType = compTypes[k];
					boolean flag = specsInfo.isTestRelevantForServer(compType,tmpVal2,true);
					if(flag)
					{
						compTypeArr.add(_mapping.getComponentTypeDescription(compType));
					}
				}
				Collections.sort(compTypeArr,String.CASE_INSENSITIVE_ORDER);
				for(int v=0; v<compTypeArr.size(); v++)
				{
					String compTypeVal = (String)compTypeArr.get(v);
					compTypeStr += compTypeVal+", ";
				}
				if(compTypeStr.endsWith(", "))
				{
					compTypeStr = compTypeStr.substring(0,compTypeStr.length()-2);
				}
				if(compTypeStr!= "" && compTypeStr!=null)
					tmpDis2 = tmpDis2+" ("+compTypeStr+")";
				JSONObject nameObj3 = new JSONObject();
				nameObj3.put("valueField",tmpVal2);
				nameObj3.put("displayField",tmpDis2);
				cloneDisoTestsJSON.remove(b);
				cloneDisoTestsJSON.add(b,nameObj3);
			}
		}
	}
	rootJSON.put("disoTests",cloneDisoTestsJSON);
	hiddens.put("server",server); // fassociate, fdissociate
	rootJSON.put("hiddens",hiddens);
	rootJSON.put("serverDispValue",_mapping.getComponentTypeDescription(server));
	out.println(rootJSON);
%>


