<%
/*
 *	Name		:	EgConfigTestParamJson.jsp
 *	Purpose		:	To modify IC test deails 
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import="egurkha.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@page import="com.egurkha.util.StringUtils"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%!
	private String [] testTypes = EgAggregateInfo.allowedTestTypes(); //skm
	
	private String [] dbTypes = {	"Oracle",
									"MsSql",
									"Sybase",
									"MySql",
									"PostGres",
									"DB2",
									"SAP HANA",
									"MariaDB"
								};
%>

<%
	//Check whether _cf test enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	JSONObject rootJSON = new JSONObject();
	JSONObject hiddens = new JSONObject();
	JSONObject obj = new JSONObject();
	rootJSON.put("success","true");
	rootJSON.put("isConfigSupported",isConfigSupported);

	boolean isDouble=EgDbInfo.doubleByteEnabled;
	String test = request.getParameter("test");
	String testType = request.getParameter("testtype");
	TestBean testBean = new TestBean(true);
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	
	ArrayList measures = testBean.getMeasuresForTest(test);
	if (measures != null && measures.size() > 0)
	{
		rootJSON.put("showGenerateTab",true);
	}
	else
	{
		rootJSON.put("showGenerateTab",false);
	}

	String os = testBean.getOs(test);
	String $_os = "";
	if(os.equalsIgnoreCase("Unix"))
		$_os = "Unix";

	if(os.equalsIgnoreCase("Windows"))
		$_os = "Windows";
	rootJSON.put("$os",$_os);

	String unix = "";
	String win = "";
	if(os.equalsIgnoreCase("Unix"))
		unix = "checked";
	else
		win = "checked";

	String portBased = "";
	String noPortBased = "";
	String external = "";
	String internal = "";

	if(testBean.isTestPortBased(test))
		portBased = "checked";
	else 
		noPortBased = "checked";
	
	if(specsInfo.isTestExternal(test))
		external = "checked";
	else
		internal = "checked";

	String paramList = "";
	
	String dbType = testBean.getDbType(test);
	
	String [] tmpTestTypes = new String[testTypes.length];
	for(int i=0; i<testTypes.length; i++)
	{
		if(testTypes[i].equals(testType))
		{
			tmpTestTypes[i] = "selected";
		}
		else
			tmpTestTypes[i] = "";
	}

	String [] tmpDbTypes = new String[dbTypes.length];
	for(int i=0; i<dbTypes.length; i++)
		if(dbTypes[i].equals(dbType))
			tmpDbTypes[i] = "selected";
		else
			tmpDbTypes[i] = "";

	session.setAttribute("egBackhref","/final/admin/EgUDTest.jsp");
	IniFile udTestsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");
	String typeValue = udTestsIni.getValue("TEST_TYPE",test);
	rootJSON.put("test",test);
	rootJSON.put("testType",testType);
	rootJSON.put("$dbType",dbType);
	rootJSON.put("typeValue",typeValue);

	if(testType != null && testType.equals("Script/Batch File")) 
	{
		rootJSON.put("osType",true);
		rootJSON.put("unixChecked",false);
		rootJSON.put("winChecked",false);
		if (unix.equals("checked"))
		{
			rootJSON.put("unixChecked",true);
		}
		else if (win.equals("checked"))
		{
			rootJSON.put("winChecked",true);
		}
	}
	if(testType != null && testType.equalsIgnoreCase("Sql Query")) 
	{
		rootJSON.put("dbType",true);
		
		JSONArray dbTypesArr = new JSONArray();
		rootJSON.put("dbTypeSelected",dbTypes[0]);
		for (int d=0; d<dbTypes.length; d++)
		{
			obj = new JSONObject();
			String tmp = "admin.ic."+dbTypes[d];
			obj.put("displayField",_mapping.getTextDescription(tmp));
			obj.put("valueField",dbTypes[d]);
			if (tmpDbTypes[d].equals("selected"))
			{
				rootJSON.put("dbTypeSelected",dbTypes[d]);
			}
			dbTypesArr.add(obj);
		}
		rootJSON.put("dbTypes",dbTypesArr);
	}
	if (testType != null && testType.equals("Custom"))
	{
		boolean ddEbld = testBean.isDdEnabled(test);
		rootJSON.put("ddEnabled",ddEbld);
	}
		
	rootJSON.put("execution",true);
	rootJSON.put("internalChecked",false);
	rootJSON.put("externalChecked",false);
	if (internal.equals("checked"))
	{
		rootJSON.put("internalChecked",true);
		rootJSON.put("$execution","Internal");
	}
	else if(external.equals("checked"))
	{
		rootJSON.put("externalChecked",true);
		rootJSON.put("$execution","External");
	}

	rootJSON.put("portBased",true);
	rootJSON.put("portBasedYes",false);
	rootJSON.put("portBasedNo",false);
	if (portBased.equals("checked"))
	{
		rootJSON.put("portBasedYes",true);
		rootJSON.put("$port","Yes");
	}
	else if(noPortBased.equals("checked"))
	{
		rootJSON.put("portBasedNo",true);
		rootJSON.put("$port","No");
	}
	hiddens.put("test",test);
	hiddens.put("testType",testType);

	if(test != null)
	{
		Hashtable ht = testBean.getTestParam(test);
		boolean isSnmp  = (testBean.getTestType(test)).equals("Snmp")?true:false;
		String value="";
		if(ht != null || ht.size() != 0)
		{
			Enumeration enum1 = ht.keys();
			Vector veckey = new Vector();
			Vector vecvalue = new Vector();;
			int count = 0;
			boolean pipeflag=false;
			while(enum1.hasMoreElements())
			{
				veckey = (Vector) enum1.nextElement();
				vecvalue = (Vector) ht.get(veckey);
			}
			JSONArray paramListArr = new JSONArray();
			for(int i=0;i<vecvalue.size();i++)
			{
				paramList += veckey.get(i) + ";";
				value=(String)vecvalue.get(i);
				if(value.indexOf("|")!=-1)// modified to read # as ,
				{ 
					value=StringUtils.replace(value, '|', ',');
					count++;
				}
				if (isSnmp && !(veckey.get(i).equals("snmpPort") || veckey.get(i).equals("snmpCommunity") || veckey.get(i).equals("snmpversion")))
				{
					continue;
				}
				obj = new JSONObject();
				obj.put("paramName",veckey.get(i).toString());
				obj.put("paramValue",value);
				String modifyURL = "EgModifyParamsJson.jsp?test="+test+"&testtype="+testType+"&param="+veckey.get(i).toString()+"&value="+value;
				obj.put("modifyURL",modifyURL);
				
				if(testType != null)
				{
					String tmpParam = (String)veckey.get(i);
					if(testType.equalsIgnoreCase("Snmp"))
					{
						obj.put("hideDelete",true);
					}
					else if(testType.equalsIgnoreCase("JMX") && (tmpParam.equals("Jmx_Remote_Port") || tmpParam.equals("Jndi_Name") || tmpParam.equals("user") || tmpParam.equals("password")))
					{
						obj.put("hideDelete",true);
					}
					else if(testType.equalsIgnoreCase("SQL Query") && (tmpParam.equals("user") || tmpParam.equals("password") || tmpParam.equals("dbhost") || tmpParam.equals("dbport")))
					{
						obj.put("hideDelete",true);
					}
					else
					{
						obj.put("hideDelete",false);
						String deleteURL = "EgconfigtestparampJson.jsp?mod=delParam&test="+test+"&param="+tmpParam+"&dbtype="+dbType +"&testtype="+testType;
						obj.put("deleteURL",deleteURL);
					}
				}
				
				/*if(testType != null && (!testType.equalsIgnoreCase("Snmp") && (!veckey.get(i).equals("Jmx_Remote_Port") && !veckey.get(i).equals("Jndi_Name") && !veckey.get(i).equals("user") && !veckey.get(i).equals("password") && !veckey.get(i).equals("dbhost") && !veckey.get(i).equals("dbport")&& !veckey.get(i).equals("Charset"))))
				{
					 obj.put("hideDelete",false);
					 String deleteURL = "EgconfigtestparampJson.jsp?mod=delParam&test="+test+"&param="+veckey.get(i).toString()+"&dbtype="+dbType +"&testtype="+testType;
					 obj.put("deleteURL",deleteURL);
				}
				else
				{
					 obj.put("hideDelete",true);
				}*/
				paramListArr.add(obj);
			 }// FOR LOOP
			rootJSON.put("paramList",paramListArr);
			if(paramList.length() > 1)
				paramList = paramList.substring(0,paramList.length()-1);
			hiddens.put("paramList",paramList);
		}
	}
			//skm
	if(testType != null && (testType.equalsIgnoreCase("Custom") || testType.equalsIgnoreCase("Script/Batch File") || testType.equalsIgnoreCase("Sql Query") || testType.equalsIgnoreCase("Perfmon") || testType.equalsIgnoreCase("jmx")))
	{
		rootJSON.put("showAddNewParam",true);
		rootJSON.put("showNewTetsParams",true);
	}
	else
	{
		rootJSON.put("showAddNewParam",false);
	}
	hiddens.put("mod","param");
	hiddens.put("test",test);
	hiddens.put("testType",testType);
	hiddens.put("os",os);
	hiddens.put("dbType",dbType);

	rootJSON.put("hiddens",hiddens);
	out.println(rootJSON);

%>



