<%
/*
 *	Name            :   UsedCountDetailsJson.jsp
 *	Purpose         :   To provide details about used counts. 
 */
%>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "java.sql.*"%>


<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%	
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	//For CSV
	List csvData = new ArrayList();
	csvData.add("Used count Report");
	csvData.add("");

	EgExternalInfo extInfo = new EgExternalInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgCertUsage certUsage = new EgCertUsage();
	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isIntAgentCheck = servicesInfo.isInternalAgentCertEnabled();
	EgGroupInfo grInf = new EgGroupInfo();
	egurkha.UserBean userBean = new egurkha.UserBean();
	IniFile topoIni = new IniFile(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egTopologyConfigFile);
	EgUsersInfo usersInfo = new EgUsersInfo();
	boolean isUserLiscense = usersInfo.isUserBasedLicense();
	ArrayList nameList = new ArrayList();
	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	String selAttribute = request.getParameter("attribute");
	String zoneAttr = request.getParameter("zoneAttr");
	boolean isZoneAttr = false;
	if (zoneAttr == null) zoneAttr = "";
	if (selAttribute == null) selAttribute = "";
	ArrayList details = new ArrayList();
	ArrayList compList =  new ArrayList();
	JSONArray jsonArr = new JSONArray();

	String[] zonesArr = grInf.getZoneNames();
	ArrayList eGZones = new ArrayList();
	if (zonesArr != null)
	{
		eGZones = new ArrayList(Arrays.asList(zonesArr));
		nameList.addAll(eGZones);
	}
	int nameListSize = nameList.size();
	JSONArray gridArr = new JSONArray();
	JSONObject jsonObj = new JSONObject();
	String tmpName = request.getParameter("zoneName");
	certUsage.setZoneName(tmpName);
	
	if(zoneAttr.equalsIgnoreCase("Total Monitors"))
	{
		ArrayList userlist = certUsage.getTotalMonitorsForZone();
		details.addAll(userlist);
		details = getTypesForNick(details,discInfo,extInfo,mappingInfo);
		isZoneAttr = true;
	}
	else if(zoneAttr.equalsIgnoreCase("Basic Monitors"))
	{
		ArrayList userlist = certUsage.getBasicMonitorsForZone();
		details.addAll(userlist);
		details = getTypesForNick(details,discInfo,extInfo,mappingInfo);
		isZoneAttr = true;
	}
	else if(zoneAttr.equalsIgnoreCase("Premium Monitors"))
	{
		ArrayList userlist = certUsage.getPremiumMonitorsForZone();
		details.addAll(userlist);
		details = getTypesForNick(details,discInfo,extInfo,mappingInfo);
		isZoneAttr = true;
	}
	else if(zoneAttr.equalsIgnoreCase("External Agents"))
	{
		ArrayList userlist = certUsage.getExternalAgentsForZone();
		details.addAll(userlist);
		details = getTypesForNick(details,discInfo,extInfo,mappingInfo);
		isZoneAttr = true;
	}
	else if(zoneAttr.equalsIgnoreCase("Monitored Targets"))
	{
		ArrayList userlist = certUsage.getMonitoredTargetsForZone();
		details.addAll(userlist);
		details = getTypesForNick(details,discInfo,extInfo,mappingInfo);
		isZoneAttr = true;
	}
	else if(zoneAttr.equalsIgnoreCase("Applications"))
	{
		ArrayList userlist = certUsage.getApplicationsForZone();
		isZoneAttr = true;
		String compName = "";
		int compNameSize = userlist.size();
		for(int l =0 ; l< compNameSize ; l++)
		{
			String app = (String)userlist.get(l);
			int idx = app.indexOf(":");
			String appType = app.substring(0,idx);
			appType = _mapping.getComponentTypeDescription(appType);
			app = app.substring(app.indexOf(":")+1);
			app = app.replace(":NULL","");
			compName += app+"("+appType+")";
			compName = compName + ",";
		}
		if(compName.endsWith(","))
		{
			compName = compName.substring(0,compName.length()-1);
		}
		if (details == null) details=new ArrayList();
		compList =  new ArrayList(Arrays.asList(compName.split(",")));
		details.addAll(compList);
	}
	else if(zoneAttr.equalsIgnoreCase("Network Devices"))
	{
		ArrayList userlist = certUsage.getNetworkDevicesForZone();
		isZoneAttr = true;
		String compName = "";
		int compNameSize = userlist.size();
		for(int l =0 ; l< compNameSize ; l++)
		{
			String app = (String)userlist.get(l);
			int idx = app.indexOf(":");
			String appType = app.substring(0,idx);
			appType = _mapping.getComponentTypeDescription(appType);
			app = app.substring(app.indexOf(":")+1);
			app = app.replace(":NULL","");
			compName += app+"("+appType+")";
			compName = compName + ",";
		}
		if(compName.endsWith(","))
		{
			compName = compName.substring(0,compName.length()-1);
		}
		if (details == null) details=new ArrayList();
		compList =  new ArrayList(Arrays.asList(compName.split(",")));
		details.addAll(compList);
	}
	else if(zoneAttr.equalsIgnoreCase("Services"))
	{
		ArrayList userlist = certUsage.getServicesForZone();
		details.addAll(userlist);
		isZoneAttr = true;
	}
	else if(zoneAttr.equalsIgnoreCase("Segments"))
	{
		ArrayList userlist = certUsage.getSegmentsForZone();
		details.addAll(userlist);
		isZoneAttr = true;
	}
	if(selAttribute.equals("External Agents"))
	{
		String[] extAgents = getAllExternalAgents(discInfo,extInfo,usersInfo);
		if (extAgents != null)
		{
			details = new ArrayList(Arrays.asList(extAgents));
		}
	}
	else if(selAttribute.equals("Basic Monitors"))
	{
		ArrayList basAgents = userBean.getCurrentBasicAgents();
		ArrayList alBasAgents = userBean.getAgentlessBasic();
		details.addAll(basAgents);
		details.addAll(alBasAgents);
		
		//If basic comps exceeds the allowed count then it will consume premium license if exist.
		int allowedBasic = EgMemInfo.basicAgents;
		if (allowedBasic > 0)
		{
			int usedBasic = details.size();
			if (usedBasic > allowedBasic)
			{
				Collections.sort(details);
				details = new ArrayList(details.subList(0,allowedBasic));
			}
		}
		// To show component type along with nick
		details = getTypesForNick(details,discInfo,extInfo,mappingInfo,"BasicMonitors");
	}
	else if(selAttribute.equals("Premium Monitors"))
	{
		ArrayList preAgents = userBean.getPremiumAgents();
		ArrayList alPreAgents = userBean.getAgentlessPremium();
		details.addAll(preAgents);
		details.addAll(alPreAgents);
		
		//If basic comps exceeds the allowed count then it will consume premium license if exist.
		int allowedBasic = EgMemInfo.basicAgents;
		if (allowedBasic > 0)
		{
			ArrayList tmpDetails = new ArrayList(userBean.getCurrentBasicAgents());
			tmpDetails.addAll(userBean.getAgentlessBasic());		
			int usedBasic = tmpDetails.size();
			if (usedBasic > allowedBasic)
			{
				Collections.sort(tmpDetails);
				List tmpPremuAgents = tmpDetails.subList(allowedBasic,tmpDetails.size());
				details.addAll(tmpPremuAgents);
			}
		}

		// To show component type along with nick
		details = getTypesForNick(details,discInfo,extInfo,mappingInfo,"PremiumMonitors");
	}
	else if(selAttribute.equals("Total Monitors"))
	{
		ArrayList basAgents = userBean.getCurrentBasicAgents();
		ArrayList alBasAgents = userBean.getAgentlessBasic();
		ArrayList preAgents = userBean.getPremiumAgents();
		ArrayList alPreAgents = userBean.getAgentlessPremium();
		details.addAll(basAgents);
		details.addAll(alBasAgents);
		details.addAll(preAgents);
		details.addAll(alPreAgents);

		// To show component type along with nick
		details = getTypesForNick(details,discInfo,extInfo,mappingInfo,"TotalMonitors");
	}
	else if(selAttribute.equals("Monitored Targets"))
	{
		//details = (isUserLiscense)?discInfo.getAllHostsFromRhs2():discInfo.getAllHostsFromRhs();
		details = discInfo.getAllHostsFromRhs2(isUserLiscense);
		if(isUserLiscense && isIntAgentCheck)
		{
			ArrayList userTypes = usersInfo.getAllUserBasedCompTypes();
			ArrayList allUserHosts = discInfo.getAllHostsOfTypes(userTypes);
			ArrayList intAgentComps = extInfo.getAllInternalAgentListForUserBasedNicks(allUserHosts);
			details.removeAll(intAgentComps);
			details.removeAll(allUserHosts);
		}
		if (details == null) details=new ArrayList();
	}
	else if(selAttribute.equals("Applications"))
	{
		//details = (isUserLiscense)?discInfo.getAllApps2():discInfo.getAllApps();
		details = discInfo.getAllApps2(isUserLiscense);
		if(isUserLiscense && isIntAgentCheck)
		{
			ArrayList userTypes = usersInfo.getAllUserBasedCompTypes();
			ArrayList allUserHosts = discInfo.getAllHostsOfTypes(userTypes);
			ArrayList intAgentComps = extInfo.getAllInternalAgentListForUserBasedNicks(allUserHosts);
			ArrayList tmpRemList = new ArrayList();
			int size = details.size();
			for (int d=0;d<size;d++)
			{
				String typeNickPort = (String)details.get(d);
				String tmpNick = typeNickPort.substring(typeNickPort.indexOf(":")+1);				
				tmpNick = tmpNick.substring(0,tmpNick.indexOf(":"));
				if (intAgentComps.contains(tmpNick) || allUserHosts.contains(tmpNick))
				{
					tmpRemList.add(typeNickPort);				
				}
			}
			details.removeAll(tmpRemList);	
		}
		if (details == null) details=new ArrayList();
		details = new ArrayList(details);
		details = getRefinedList(details,mappingInfo);
	}
	else if(selAttribute.equals("Network Devices"))
	{
		details = discInfo.getAllNetworkDevices();
		if (details == null) details=new ArrayList();
		details = new ArrayList(details);
		details = getRefinedList(details,mappingInfo);
	}
	else if(selAttribute.equals("Services"))
	{		
		String [] vars = topoIni.getVariables("WEB_SITE_MAPPING");
		if (vars != null)
		{
			details = new ArrayList(Arrays.asList(vars));
		}
	}
	else if(selAttribute.equals("Segments"))
	{
		String [] vars = topoIni.getVariables("TOPOLOGY_SEGMENTS");
		if (vars != null)
		{
			details = new ArrayList(Arrays.asList(vars));
		}
	}
	else if(selAttribute.equals("Monitor Users"))
	{
		EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
		String connStatus = egDb.setConnection();
		if (connStatus.equals("CONNECTED"))
		{
			try
			{
				ResultSet rs = egDb.SelectExec("SELECT user_id FROM user_info");
				while(rs.next())
				{
					String uname=rs.getString("user_id");
					boolean isDefUser = User.isDefaultUser(uname);
					if (!isDefUser)
					{
						details.add(uname);
					}
				}
				rs.close();
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
			finally
			{
				try
				{
					egDb.releaseConnection(false);
				}
				catch(Exception e)
				{
					egDb.releaseConnection(true);
				}
			}
		}
		EgDbAdapterTypeUI.releaseObject(egDb);
	}
	Collections.sort(details,String.CASE_INSENSITIVE_ORDER);
	int detailsCount = details.size();
	rootJSON.put("attribute",selAttribute);
	rootJSON.put("count",detailsCount);
	rootJSON.put("zoneName",tmpName);
	
	//CSV 
	if(isZoneAttr)
	{
		csvData.add("Zone :"+tmpName);
		csvData.add(zoneAttr+ " ("+detailsCount+")");
	}
	else
	{
		csvData.add(selAttribute+ " ("+detailsCount+")");
	}
	csvData.add("");
	for (int d=0; d<detailsCount; d++)
	{
		String types = details.get(d).toString();
		if (types.indexOf(",") != -1)
		{
			types = "\""+types+"\"";
		}
		csvData.add(types);	
	}
	session.setAttribute("list",csvData);
	session.setAttribute("isAuditlogCSV","true");

	
	if(detailsCount%3 == 1)
	{
		details.add("");
		details.add("");
	}
	else if (detailsCount%3 == 2)
	{
		details.add("");
	}
	for(int c=0; c<detailsCount; c+=3)
	{		
		JSONObject tmpObj = new JSONObject();
		tmpObj.put("col_1",details.get(c).toString());
		tmpObj.put("col_2",details.get(c+1).toString());
		tmpObj.put("col_3",details.get(c+2).toString());
		jsonArr.add(tmpObj);
	}
	rootJSON.put("details",jsonArr);
	out.println(rootJSON);
%>

<%!
	public ArrayList getRefinedList(ArrayList src,EgMappingInfo mappingInfo)
	{
		int srcCount = src.size();
		ArrayList result = new ArrayList();
		for (int i=0; i < srcCount; i++)
		{
			String comp = (String)src.get(i);
			if (comp.toLowerCase().endsWith(":null"))
				comp = comp.substring(0,comp.lastIndexOf(":"));
			int idx = comp.indexOf(":");
			if (idx > -1)
			{
				String type = comp.substring(0,idx);
				comp = comp.substring(idx+1) +" ("+mappingInfo.getComponentTypeDescription(type)+")";
			}

			result.add(comp);
		}
		return result;
	}

	public ArrayList getTypesForNick(ArrayList details, EgDiscInfo discInfo, EgExternalInfo extInfo, EgMappingInfo mappingInfo)
	{
		return getTypesForNick(details, discInfo, extInfo, mappingInfo,"");
	}

	public ArrayList getTypesForNick(ArrayList details, EgDiscInfo discInfo, EgExternalInfo extInfo, EgMappingInfo mappingInfo,String monitorType)
	{
		List tempDetails = new ArrayList();
		ArrayList basicTypes = EgInstallInfo.getBasicTypes();
		ArrayList excludeList = getCertCheckTypes();
		EgUsersInfo usersInfo = new EgUsersInfo();
		boolean userCert = usersInfo.isUserBasedLicense();
		ArrayList userTypes = usersInfo.getAllUserBasedCompTypes();
		ArrayList extAgents = new ArrayList();
		String[] exts = extInfo.getAllExternalAgents();
		if (exts != null)
		{
			extAgents = new ArrayList(Arrays.asList(exts));
		}
		for (int d=0; d<details.size(); d++)
		{
			String nick = (String)details.get(d);
			List compTypes = discInfo.getServerTypesForNick(nick);
			ArrayList tmpCompTypes = new ArrayList(compTypes);
			compTypes.removeAll(excludeList);
			if (monitorType.equals("BasicMonitors"))
			{
				compTypes.retainAll(basicTypes);
			}
			else if (userCert && (monitorType.equals("PremiumMonitors") || monitorType.equals("TotalMonitors")))
			{
				compTypes.removeAll(userTypes);
			}
			String type = "";
			if (compTypes != null && compTypes.size() > 0)
			{
				for (int c=0; c < compTypes.size(); c++)
				{
					type = compTypes.get(c).toString();
					if (!basicTypes.contains(type))
					{
						type = mappingInfo.getComponentTypeDescription(type);
						break;
					}
					type = "";
				}
				if (type.equals(""))// Basic agents or basic consumes premium license
				{
					type = compTypes.get(0).toString();
					type = mappingInfo.getComponentTypeDescription(type);
				}

				if (extAgents.contains(nick))
				{
					type = "External Agent, "+type;
				}
			}
			else
			{
				if (extAgents.contains(nick))
				{
					type = "External Agent";
				}else if(tmpCompTypes != null && tmpCompTypes.size() > 0)
				{
					type = (String)tmpCompTypes.get(0);
					type = mappingInfo.getComponentTypeDescription(type);
				}
			}

			tempDetails.add(nick+" ("+type+")");
		}
		if (tempDetails.size() > 0)
		{
			details = new ArrayList(tempDetails);
		}
		return details;
	}

	private String[] getAllExternalAgents(EgDiscInfo discInfo, EgExternalInfo extInfo,EgUsersInfo usersInfo)
	{
		String[] extIp = extInfo.getAllExternalAgents();
		if(extIp != null && extIp.length>0)
		{
			ArrayList tempExtAgents = new ArrayList();
			for(int r=0; r<extIp.length; r++)
			{
				if(!extIp[r].equalsIgnoreCase("none"))
				{
					tempExtAgents.add(extIp[r]);
				}
			}
			String[] tmpExtAgents = (String[])tempExtAgents.toArray(new String[0]);
			extIp = tmpExtAgents;
		}
		boolean userCert = usersInfo.isUserBasedLicense();
		if (!userCert) 
		{
			extIp = checkForFreeTypes(extIp);
			return extIp;
		}

		boolean isExt = usersInfo.isExtCheck();
		if (isExt)
		{
			ArrayList al = usersInfo.getAllUserBasedCompTypes();
			ArrayList hosts = discInfo.getAllHostsOfTypes(al);
			List tmpList = new ArrayList();
			for (int e=0;e<extIp.length; e++)
			{
				if (hosts.contains(extIp[e]))
				{
					continue;
				}
				tmpList.add(extIp[e]);
			}
			String [] extArr = (String[])tmpList.toArray(new String[0]);
			extArr = checkForFreeTypes(extArr);
			return extArr;
		}
		else
		{
			extIp = checkForFreeTypes(extIp);
			return extIp;
		}
	}

	private ArrayList getCertCheckTypes()
	{
		ArrayList tmpList = EgInstallInfo.getCertCheckList();
		ArrayList res = new ArrayList();
		if (tmpList != null)
		{
			int size = tmpList.size();
			for (int t=0; t<size; t++)
			{
				String compType = (String)tmpList.get(t);
				compType = EgCrypt.decrypt(compType);
				res.add(compType);
			}
		}
		return res;
	}

	private String[] checkForFreeTypes(String[] extAgents)
	{
		EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
		EgDiscInfo discInfo = new EgDiscInfo("manager");
		HashMap extAgentsMap = getExternalAgentMap();
		ArrayList finalResult = new ArrayList(Arrays.asList(extAgents));
		ArrayList freeCertTypes = getCertCheckTypes();
		if (freeCertTypes != null && freeCertTypes.size() > 0) // if no free license comps, dont do any work
		{
			finalResult = new ArrayList();
			String[] extSertvTypes = specsInfo.getAllExternalServerTypes();
			ArrayList extServList = new ArrayList();
			if (extSertvTypes != null)
			{
				extServList = new ArrayList(Arrays.asList(extSertvTypes));
			}		
			
			ArrayList freeExtCertTypes = (ArrayList)freeCertTypes.clone();
			freeExtCertTypes.retainAll(extServList);
			ArrayList allFreeExtCertHosts = discInfo.getAllHostsOfTypes(freeExtCertTypes);

			ArrayList allMgrExtHosts = discInfo.getAllExternalHosts();
			ArrayList allFreeHosts = discInfo.getAllHostsOfTypes(freeCertTypes);
			for (int r=0; r<extAgents.length;r++)
			{
				String extAgent = extAgents[r];
				ArrayList assignedHosts = (ArrayList)extAgentsMap.get(extAgent); // if external agent, get hosts it is monitoring
				if (assignedHosts == null || assignedHosts.size() == 0)
				{
					finalResult.add(extAgent);
					continue;
				}
				ArrayList assignedHostsClone =  (ArrayList)assignedHosts.clone();
				assignedHostsClone.removeAll(allFreeHosts);
				if (assignedHostsClone.containsAll(assignedHosts)) //if none of the host types is free license, no change
				{
					finalResult.add(extAgent);
					continue;
				}				
				boolean hasExternalFreeCertComp = isValidAgent(extAgent,assignedHosts,freeExtCertTypes,discInfo); //if the ext agent is monitoring any ext and free license comp then only do the rest
				if(!hasExternalFreeCertComp)
				{
					finalResult.add(extAgent);
					continue; 
				}
				allMgrExtHosts.add(extAgent);
				assignedHosts.removeAll(allFreeExtCertHosts); //from the monitored list, remove ext and free license comp
				assignedHosts.retainAll(allMgrExtHosts); //from the remaining list, remove all internal and remote comps  - except its own nick
				if(assignedHosts.size() > 0)
				{
					finalResult.add(extAgent); //if you are left with even one comp, then add license. 
				}
			}
		}
		// Malicis changes - ends
		String[] finalResultArr = (String[])finalResult.toArray(new String[0]);
		return finalResultArr;
	}

	private HashMap getExternalAgentMap()
	{
		IniFile extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
		String[] hosts = extIni.getVariables("Test_Mapping_Section");
		if (hosts == null)
			return (new HashMap());
		HashMap extAgentsMap = new HashMap();
		for (int v=0; v<hosts.length; v++)
		{
			String host = hosts[v];
			String agents = extIni.getValue("Test_Mapping_Section",host);
			StringTokenizer stt = new StringTokenizer(agents,",");
			ArrayList tmpList = new ArrayList();
			while (stt.hasMoreTokens())
			{
				String extAgent = stt.nextToken();
				if(extAgent.equalsIgnoreCase("none"))
				{
					continue;
				}
				tmpList = (ArrayList)extAgentsMap.get(extAgent);
				if (tmpList == null)
				{
					tmpList = new ArrayList();
				}
				tmpList.add(host);
				extAgentsMap.put(extAgent,tmpList);
			}
		}
		return extAgentsMap;
	}

	private boolean isValidAgent(String extAgent, ArrayList assignedHosts, ArrayList freeExtServTypes,EgDiscInfo discInfo)
	{
		for (int a=0; a<assignedHosts.size(); a++)
		{
			String host = (String)assignedHosts.get(a);
			List servTypes = discInfo.getServerTypesForNick(host);
			if (servTypes != null)
			{
				for (int s=0; s<servTypes.size(); s++)
				{
					String servType = (String) servTypes.get(s);
					if(freeExtServTypes.contains(servType)) 
					{
						return true;
					}
				}
			}
		}
		return false;
	}
%>