<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String isLocalManager = request.getParameter("isLocalManager");
	String logsDirectory = request.getParameter("logsDirectory");
	String mgrLogFile = request.getParameter("mgrLogFile");
	String managerID = request.getParameter("managerID");
	String filter = request.getParameter("filter");
	String sessionID = request.getParameter("sessionID");
	String lastModifiedTime = null;
	
	Hashtable contentMap = new Hashtable();
	if(sessionID == null)
	{
		sessionID = session.getId();
	}
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(sessionID);
	
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	String userLogo = "";
	if (user != null)
	{
		String trackerUserLang = user.getLanguage();
		if (trackerUserLang != null && !trackerUserLang.equalsIgnoreCase("NULL"))
		{
			userLanguage = trackerUserLang;
		}
		iniUI.set_userLogo(user.getUserLogo());
		userLogo = iniUI.getMonitorHomeLogo();
		if(iniUI.isHKTThemeEnabled())
		{
			userLogo = iniUI.getHKTReporterLogo();
		}
	}
	
	EgMappingInfo _mapping = new EgMappingInfo(userLanguage);
	
	String UI_FILTER_FORMAT = null;
	if(filter != null && filter.length() >0)
	{
		if(filter.equalsIgnoreCase("Not_Applicable") || filter.equalsIgnoreCase("No_Filter"))
		{
			UI_FILTER_FORMAT = filter.replace("_"," ");
			filter = null;
		}
		else
		{
			Date actualDate = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH).parse(filter);
			SimpleDateFormat sdf = new SimpleDateFormat(iniUI.getiniDataFormat());
			UI_FILTER_FORMAT = (String)sdf.format(actualDate);
		}
	}
	
	if(isLocalManager != null && isLocalManager.equalsIgnoreCase("true"))
	{
		if(EgInstallInfo.isClusterSupported)
		{
			managerID += " (Primary)";
		}
		String filepath = EgInstallInfo.getInstallDir()+"/manager";
		if(logsDirectory.equalsIgnoreCase("tomcat/logs"))
		{
			filepath += "/tomcat/logs/"+mgrLogFile;
		}
		else
		{
			filepath += "/logs/"+mgrLogFile;
		}
		boolean isLineSkip = false;
		File logFile = new File(filepath);

		SimpleDateFormat sdf = new SimpleDateFormat(iniUI.getiniDataFormat()+" "+"HH:mm:ss");
		lastModifiedTime = sdf.format(new Date(logFile.lastModified()));

		long skipBytes = 0;
		long fileSize = logFile.length();
		long limitLength = 5 * 1024 * 1024;
		BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(logFile),"UTF-8"));
		if(fileSize > limitLength)
		{
			skipBytes = fileSize-limitLength;
			br.skip(skipBytes);
			isLineSkip = true;
		}
		ArrayList data = new ArrayList();
		data.add(br);
		data.add(new Boolean(isLineSkip));
		contentMap.put("localhostContent",data);
	}
	else if(isLocalManager != null && isLocalManager.equalsIgnoreCase("false"))
	{
		ArrayList resultData = PMClusterHelper.getSecondaryManagerLogFiles(managerID ,mgrLogFile,"mail","false",logsDirectory);
		managerID += " (Secondary)";
		if(resultData != null && resultData.size() > 0)
		{
			String timeString = (String)resultData.get(0);
			resultData.remove(0);
			if(timeString != null && timeString.length() > 0)
			{
				long time = Long.parseLong(timeString.substring(timeString.indexOf("@#")+2));
				SimpleDateFormat sdf = new SimpleDateFormat(iniUI.getiniDataFormat()+" "+"HH:mm:ss");
				lastModifiedTime = sdf.format(new Date(time));
			}
			contentMap.put("otherhostContent",resultData);
		}
	}
	if(!contentMap.isEmpty())
	{
%>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="table-layout:fixed;margin-bottom:20px">
	<tr>
		<td width="100%" align="center" height="100%" valign="top">
			<table cellpadding="0" cellspacing="0" border="0" width="100%" align="center">
				<tr>
					<td style="padding:5px 10px 15px 10px"><img src='<%=userLogo%>' border="0" /></td>
				</tr>
			</table>
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
				<tr>
					<td style="padding:2px">
						<div style="float:left;font-weight:bold"><header><%=_mapping.getTextDescription("admin.title.MANAGER - LOGS")%></header></div>
					</td>
				</tr>
			</table>
			<table width="100%" border="0" cellspacing="2" cellpadding="2" align="left" style="border-bottom:1px solid #ccc;">
				<tr>
					<td style="padding:6px 0px 6px 0px">
						<span style="margin-right:15px"><b><%=_mapping.getTextDescription("admin.manager.Manager IP/Hostname")%></b> : <%=managerID == null ? "No IP/Hostname" : managerID%></span>
						<span style="margin-right:15px"><b><%=_mapping.getTextDescription("admin.manager.Log file directory")%></b> : <%=logsDirectory%></span>
						<span style="margin-right:15px"><b><%=_mapping.getTextDescription("admin.manager.Log file name")%></b> : <%=mgrLogFile%></span>
						<span style="margin-right:15px"><b><%=_mapping.getTextDescription("admin.manager.Filter by date")%></b> : <%=UI_FILTER_FORMAT == null ? "No Filter" : UI_FILTER_FORMAT%></span>
						<span style="margin-right:15px"><b><%=_mapping.getTextDescription("admin.manager.Last modified time")%></b> : <%=lastModifiedTime%></span>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<%
		if(contentMap.containsKey("localhostContent"))
		{
			ArrayList content = (ArrayList)contentMap.get("localhostContent");
			BufferedReader br = (BufferedReader)content.get(0);
			boolean isLineSkip = ((Boolean)content.get(1)).booleanValue();
			String line = "";
			while((line = br.readLine()) != null)
			{
				if(isLineSkip)
				{
					isLineSkip = false;
				}
				else
				{
					if(line == null || line.trim().length() == 0)
					{
						continue;
					}
					if(filter != null && !filter.equals("-1") && !line.startsWith(filter))
					{
						continue;
					}
					out.println(line+"<br>");
				}
			}
		}
		else  if(contentMap.containsKey("otherhostContent"))
		{
			ArrayList content = (ArrayList)contentMap.get("otherhostContent");
			for(int i = 0;i<content.size();i++)
			{
				String line = (String)content.get(i);
				if(line == null || (line = line.trim()).length() == 0)
				{
					continue;
				}
				if(filter != null && !filter.equals("-1") && !line.startsWith(filter))
				{
					continue;
				}
				out.println(line+"<br>");
			}
		}
	}
%>



