<%
/*******************************************************************************
 *      File name               :       EgDispRemoteAgentsJson.jsp
 *      Purpose                 :       To display the list of remote agents
                                        in the system.
 ******************************************************************************/
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.egurkha.IPComparator"%>
<%@ page import = "com.egurkha.admin.RemoteAgent"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%@ page import= "egurkha.EgUIUtils"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	if (egTitleSearchStr != null)
	{
		egTitleSearchStr = EgUIUtils.decodeSecurityChar(egTitleSearchStr);
	}
	boolean isSearchResult = (egTitleSearchStr!=null && egTitleSearchStr!="");
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
%>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	//Limited admin
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgUuidInfo uuidInfo = new EgUuidInfo();
	EgCertUsage egCertUsage = new EgCertUsage();
	ArrayList usersList = egCertUsage.getAllLimitedCompAccessUsers(true);
	boolean isLimitedAdmin = (usersList != null && usersList.contains(_user.getLoginID()));
	EgUserElementsInfo userElmentsObj = new EgUserElementsInfo();
	EgSpecsInfo specs = new EgSpecsInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	ArrayList allManagedCompNicks = discInfo.getAllManagedNames();
	trans.createFile("eg_external.ini");
	String[] s_eagents = trans.getVariables("Eg_Remote_Agents");
	String user_name = _user.getLoginID();
	String dependent_OU_name = uuidInfo.getDirectDependentOU(user_name);
	ArrayList agentsList = new ArrayList();
	boolean isMspModel = uuidInfo.isMspModel();
	
	if (!isLimitedAdmin)
	{
		agentsList = new ArrayList(Arrays.asList(s_eagents));
	}
	else
	{
		agentsList = userElmentsObj.getRemoteAgentsForUser(user_name);
	}
	s_eagents = (agentsList != null) ? (String[])agentsList.toArray(new String[0]) : new String[0];

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	RemoteAgent rmtObj = new RemoteAgent();

	Vector allInternalHosts = externalInfo.getAllAgents();
	boolean searchItemFound=false;
	ArrayList remAgents = new ArrayList();
	if (s_eagents!=null)
	{
		Arrays.sort(s_eagents,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i < s_eagents.length;i++)
		{
			String remAgentIP = externalInfo.getIpForRemoteAgent(s_eagents[i]);
			if (isSearchResult && !doesExist(searchList, s_eagents[i]+remAgentIP))
				continue;
			searchItemFound=true;
			remAgents.add(s_eagents[i]);
		}
	}
	List tmpList = new ArrayList();
	String defaultRemAgent = "";
	for (int j=0; j <remAgents.size();j++)
	{
		String tmpExtagent = (String)remAgents.get(j);
		if (specs.getEGServer().equals(tmpExtagent))
		{
			defaultRemAgent = tmpExtagent;
		}
		else
		{
			tmpList.add(tmpExtagent);
		}
	}
	if (!defaultRemAgent.equals(""))
	{
		tmpList.add(0,defaultRemAgent);
	}

	EgServicesInfo serviceInfo = new EgServicesInfo("manager");
	ArrayList ipList = new ArrayList();
	ArrayList aList = new ArrayList();
	for (int x=0; x<tmpList.size(); x++)
	{
		String agentStr = (String) tmpList.get(x);
		if (serviceInfo.isIP(agentStr))
		{
			ipList.add(agentStr);
		}
		else
		{
			aList.add(agentStr);
		}
	}
	Collections.sort(ipList,new IPComparator());
	Collections.sort(aList, String.CASE_INSENSITIVE_ORDER);
	tmpList = new ArrayList();
	tmpList.addAll(ipList);
	tmpList.addAll(aList);

	remAgents = new ArrayList(tmpList);

	JSONArray gridRmtAgents = new JSONArray();
	JSONObject gridObject = new JSONObject();
	boolean isDisabled = false;

	if(remAgents != null && remAgents.size() > 0 && searchItemFound)
	{
		ArrayList allCompNicks = new ArrayList();
		if (isLimitedAdmin)
		{
			allCompNicks = egRoleInfo.getAllServerNicks();			
		}


		for(int i=0;i < remAgents.size();i++)
		{
			String rmtAgent = (String)remAgents.get(i);
			gridObject.put("Hostname",rmtAgent);
			String remoteAgentIP = externalInfo.getIpForRemoteAgent(rmtAgent);
			boolean border=(i+1)< remAgents.size();
			gridObject.put("HostIP",remoteAgentIP);

			boolean isUsed = false;
			List agentWithCmp = rmtObj.getAgentsUsedWithComponent(rmtAgent);
			if (agentWithCmp.contains(rmtAgent))
			{
				isUsed = true;
			}
			gridObject.put("AssoDissRemAgnt",isUsed);

			boolean flagNotDel = false;
			if (allInternalHosts != null && allInternalHosts.contains(rmtAgent) && !allManagedCompNicks.contains(rmtAgent))
			{
				flagNotDel = true;
			}
			gridObject.put("internalRemAgent",flagNotDel);
			isDisabled = isUsed || flagNotDel;
			gridObject.put("isDisabled",isDisabled);	
			
			String hosts = "";
			if(isLimitedAdmin)
			{
				hosts = getAssignedHostsForRemoteAgent(rmtAgent,allCompNicks);
			}
			else
			{
				hosts = getAssignedHostsForRemoteAgent(rmtAgent);
			}
			if(hosts.trim().equals(""))
			{
				hosts = "- No assigned hosts found -";
			}
			gridObject.put("AssignedHosts",hosts);
			gridRmtAgents.add(gridObject);
		}
	}
	else
	{
		if (!isSearchResult && s_eagents == null || s_eagents.length == 0)
		{
			rootJson.put("NoRmtFound","true");
			screenLabels.put("admin.remote.No remote agents present in the system",_mapping.getTextDescription("admin.remote.No remote agents present in the system"));
		}
		else if (isSearchResult && remAgents.size() ==0)
		{
			screenLabels.put("admin.remote.No remote agent(s) found for your current search",_mapping.getTextDescription("admin.remote.No remote agent(s) found for your current search"));
		}
	}
%>

<%!
	private boolean doesExist(List searchList, String thisGroup)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (thisGroup.indexOf(nextStr)!=-1||(thisGroup.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
				return true;
		}
		return false;
	}
%>

<%
	//if(request.getQueryString()!=null)
	//session.setAttribute("adminLastAccessedURL","/final/admin/EgRemoteAgents.jsp?"+request.getQueryString());
	//else session.setAttribute("adminLastAccessedURL","/final/admin/EgRemoteAgents.jsp");

	rootJson.put("gridRmtAgents",gridRmtAgents);
	rootJson.put("screenLabels",screenLabels);

	String[] rmtAgents = null;
	if (isLimitedAdmin)
	{
		ArrayList agntsList = userElmentsObj.getRemoteAgentsForUser(_user.getLoginID());
		rmtAgents = (String[])agntsList.toArray(new String[0]);
	}
	else
	{
		rmtAgents = externalInfo.getAllRemoteAgents();
	}
	if (rmtAgents != null && rmtAgents.length > 0)
	{
		List rmtList = Arrays.asList(rmtAgents);
		String strrmtList = rmtList.toString();
		strrmtList = strrmtList.substring(1,strrmtList.length()-1);
		rootJson.put("strrmtList",strrmtList);
	}



	out.println(rootJson.toString());
%>
<%!

	public String getAssignedHostsForRemoteAgent(String agentName)
	{
		IniFile extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
		String[] vars = extIni.getVariables("Remote_Agent_Mapping_Section");
		Vector vals = extIni.getAllValues("Remote_Agent_Mapping_Section");
		String res="";
		StringTokenizer stt = null;
		List tmpList = new ArrayList();
		if (vals != null && vars != null)
		{
			int valsSize = vals.size();
			for (int v=0; v<valsSize; v++)
			{
				String agent = (String)vals.get(v);
				if (agent.equals(agentName))
				{
					tmpList.add(vars[v]);
				}
			}
		}
		Collections.sort(tmpList, String.CASE_INSENSITIVE_ORDER);
		for (int t=0; t < tmpList.size(); t++)
		{
			String tmp = tmpList.get(t).toString();
			res += tmp+",";
		}
		res = res.trim();
		if (res.endsWith(","))
			res = res.substring(0,res.length()-1);
		return res;
	}

	public String getAssignedHostsForRemoteAgent(String agentName,ArrayList allNicks)
	{
		IniFile extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
		String[] vars = extIni.getVariables("Remote_Agent_Mapping_Section");
		String res="";
		if (vars == null)
			return res;
		List tmpList = new ArrayList();
		for (int v=0; v<vars.length; v++)
		{
			String host = vars[v];
			if (allNicks != null && allNicks.contains(host))
			{
				String agent = extIni.getValue("Remote_Agent_Mapping_Section",host);
				if (agent.equals(agentName))
				{
					tmpList.add(host);
				}
			}
		}
		Collections.sort(tmpList, String.CASE_INSENSITIVE_ORDER);
		for (int t=0; t < tmpList.size(); t++)
		{
			String tmp = tmpList.get(t).toString();
			res += tmp+",";
		}
		res = res.trim();
		if (res.endsWith(","))
			res = res.substring(0,res.length()-1);
		return res;
	}
%>


