<%
/*******************************************************************************
 *      File name               :       EgNewRemoteAgentsJson.jsp
 *      Purpose                 :       To Add and Delete Remote Agents.
 ******************************************************************************/
%>
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String[] extAgents = extInfo.getAllExternalAgents();
	List extList = Arrays.asList(extAgents);

	JSONArray extAgentsArr = new JSONArray();
	for(int i = 0; i < extList.size(); i++)
	{
		String agent = (String) extList.get(i);
		extAgentsArr.add(agent);
	}

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	String rtype = request.getParameter("Rtype");
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	boolean enableNickNameEdit = false;
	boolean isMspModel = EgUuidInfo.isMspModel();

	screenLabels.put("admin.external.Hostname should not start or end with a",_mapping.getTextDescription("admin.external.Hostname should not start or end with a"));

	String AgentIp = null;
	String AgenthostNic = null;
	String rAgent = request.getParameter("ragent");
	String defaultAgent = specsInfo.getEGServer();
	String user_id = _user.getLoginID();
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),user_id);

	boolean isLimitedAdmin = !egRoleInfo.hasAllComponentAccess();
	
	EgUserRole role = EgUserRole.getRoleObject(_user.getLoginType());
	long adminPerm = role.getAdminPerm();

	long COMP_ADD_MODIFY = EgUserPermission.COMPONENT_MANAGEMENT;
	boolean CompMgmt = ((adminPerm & COMP_ADD_MODIFY) == COMP_ADD_MODIFY);

	long EXT_REM_CONFIG= EgUserPermission. EXTERNAL_REMOTE_AGENT_CONFIG;
	boolean AgentMgmt = ((adminPerm & EXT_REM_CONFIG) == EXT_REM_CONFIG);

	JSONObject hostValue = new JSONObject();
	String hnickname=request.getParameter("hostnickName");
	if(hnickname!=null && !isLimitedAdmin && (CompMgmt || AgentMgmt))   //only for admin with AllComponentAccess and Rmt/Ext-agent Managemtent permission
	{
		EgUuidInfo uuidinfo = new EgUuidInfo();
		ArrayList OrgWithGivenNick = new ArrayList();
		OrgWithGivenNick=uuidinfo.getSuperUsersOfGivenNick(hnickname);
		String OrgWithNickGiven="";
		Iterator it = OrgWithGivenNick.iterator();
		while(it.hasNext())
		{
			OrgWithNickGiven+=it.next()+",";
		}
		rootJson.put("OrgWithGivenNick",OrgWithNickGiven);
	}
	else
	{
		rootJson.put("OrgWithGivenNick","");
	}
	if (StringUtils.isNull(rAgent))
	{
		AgentIp = EgConstants.BLANK_STRING;
		AgenthostNic = EgConstants.BLANK_STRING;
		hostValue.put("AgentIp",AgentIp);
		hostValue.put("AgenthostNic",AgenthostNic);

	}
	else
	{
		AgenthostNic = rAgent;
		AgentIp = extInfo.getIpForRemoteAgent(rAgent);
		ArrayList allComponentNicks = discInfo.getAllComponentNicks();
		if(!allComponentNicks.contains(defaultAgent))
		{
			allComponentNicks.add(defaultAgent);
		}
		if(!allComponentNicks.contains(AgenthostNic.toLowerCase()))
		{
			enableNickNameEdit = true;
		}
		hostValue.put("AgentIp",AgentIp);
		hostValue.put("AgenthostNic",AgenthostNic);
	}
	rootJson.put("hostValue",hostValue);
	rootJson.put("enableNickNameEdit",enableNickNameEdit);

	screenLabels.put("admin.remote.NEW REMOTE AGENT DETAILS",_mapping.getTextDescription("admin.remote.NEW REMOTE AGENT DETAILS"));
	screenLabels.put("admin.remote.Agent IP Address",_mapping.getTextDescription("admin.server.Host IP/Name"));
	if (isMspModel)
	{
		screenLabels.put("admin.remote.Agent IP Address",_mapping.getTextDescription("admin.discovery.Host name"));
	}
	screenLabels.put("admin.remote.Agent Host/Nick Name",_mapping.getTextDescription("admin.server.Nick name"));

	if(!extList.contains(rAgent))
	{
		rootJson.put("extnothasragent","Yes");
		screenLabels.put("admin.remote.Add as External agent",_mapping.getTextDescription("admin.remote.Add as External agent"));
		screenLabels.put("admin.common.Yes",_mapping.getTextDescription("admin.common.Yes"));
		screenLabels.put("admin.common.No",_mapping.getTextDescription("admin.common.No"));
	}
	else
	{
		rootJson.put("extnothasragent","No");
	}

	if (rtype != null && rtype.equalsIgnoreCase("changeip"))
	{
		rootJson.put("mode","modifyip");
	}
	else
	{
		rootJson.put("mode","add");
	}
	screenLabels.put("admin.remote.Update",_mapping.getTextDescription("admin.remote.Update"));

	//session.setAttribute("adminLastAccessedURL","/final/admin/EgRemoteAgents.jsp?"+request.getQueryString());
	
	rootJson.put("extAgentsArr",extAgentsArr);
	rootJson.put("rtype",rtype);
	rootJson.put("screenLabels",screenLabels);
	rootJson.put("rAgent",rAgent);

	out.println(rootJson.toString());
%>



