<%

/****************************************************************************	
*	Name			:	EgAdminSegmentD3JS.jsp
*	Version			:	eG 6.1v
*	Purpose			:	To display the Segment topology by using D3JS
*	Creation Date	:	01-06-2015

*--*      Author                  :----Prantish A
*****************************************************************************/
%>
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ taglib prefix = "egui" uri = "../../../WEB-INF/eg-taglib.tld" %> 
<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8"  autoFlush = "true"%>
<%


	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	String csrfToken = request.getParameter("com.eg.CSRF_NONCE");
	
	String topologySkin = _user.getAdminSkin();
	String segmentName = request.getParameter("segment");
	String zoomLevel = request.getParameter("zoom");
	String view = request.getParameter("view");
	String defaultPos = request.getParameter("default");
	String site = request.getParameter("site");
	String phyTopology = request.getParameter("physical_topology");
	String autoPosition = request.getParameter("autoPosition");
	String fromAction = request.getParameter("fromAction");
	String checked = request.getParameter("checked");
	
	
	String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini";
	IniFile iniFile = new IniFile(iniFilePath);
	String topologyRenderingMode = iniFile.getValue("TOPOLOGY_OPTIONS", "TopologyRenderingMode");
	String topologyPosition = iniFile.getValue("TOPOLOGY_OPTIONS", "TopologyPosition");
	String link = "";
	boolean isFull = false;

	if(topologyRenderingMode == null){
		topologyRenderingMode = "manual";
	}
	if(topologyPosition == null){
		topologyPosition = "left";
	}
	if(site == null) {
		site = "egurkha.physical.topology";
	}
	
	if(view != null && view.equals("full")) {
		isFull = true;
	}

	StringBuffer topoUrl = new StringBuffer();
	topoUrl.append("/final/admin/Segments/data/EgTopologyJSON.jsp?segment=");
	topoUrl.append(EgURLEncoder.encode(segmentName, "UTF-8"));
	topoUrl.append("&zoom=");
	topoUrl.append(zoomLevel);
	topoUrl.append("&physical_topology=1&site=egurkha.physical.topology&fromPage=admin&default=");
	topoUrl.append(defaultPos);
	topoUrl.append("&topologyRenderingMode=");
	topoUrl.append(topologyRenderingMode);
	topoUrl.append("&autoPosition=");
	topoUrl.append(autoPosition);
	topoUrl.append("&fromAction=");
	topoUrl.append(fromAction);
	topoUrl.append("&checked=");
	topoUrl.append(checked);
	topoUrl.append("&com.eg.CSRF_NONCE="+csrfToken);
	link = topoUrl.toString(); 

	
%>

<!doctype html>

<!--Here css cls is added to html tag for popup window, when the theme is dark-->

<%
	if(topologySkin!=null && topologySkin.equalsIgnoreCase("Dark")) {
%>
	<html class = "content-frame">
<% 
	} else {
%>
	<html>
<% 
	} 
%>

<head>
<title><%=segmentName%></title>
<link rel="stylesheet" href="/final/styles/jquery-ui.min.css">
<egui:skin ui="admin"/>

<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script src="/final/scripts/d3.min.js" charset="utf-8"></script>
<script src="/final/scripts/map.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/jquery/jquery-ui.js"></script>
<script type="text/javascript" src="/final/extjs/ext-all.js"></script>
<script type="text/javascript" src="/final/scripts/admind3Topology.js"></script>
<meta charset="utf-8">

<script>
var nodesJson = null;
var compPosition = new Map;
var csrfToken = '<%=csrfToken%>';

function showExtMenu(d, x, y)
{
	document.getElementById('h_title').value = d.cName;
	document.getElementById('h_src').value = d.cImage_url;
	document.getElementById('h_status').value = d.status;
	var serverType = d.compID;
	var compNameVal= serverType.substring(serverType.indexOf(":")+1,serverType.length);
	document.getElementById('h_cmpName').value = compNameVal;
	serverType = serverType.substring(0,serverType.indexOf(":"));
	var compName = d.cName;
	compName = compName.replace(/\s/g, "");
	if((d.cImage_url).indexOf("group.svg")<= 0 && d.status == "NEW")
	{
		OpenManageSingleDiv(serverType,compName);
	}
	var menu = new Ext.create('Ext.menu.Menu',{
				margin: '0 0 0 0',
				floating: true,
				itemId:'ExtMenu',
	});
	switch(d.status)
	{
		case "NEW":
		if((d.cImage_url).indexOf("group.svg") > 0 && d.status == "NEW")
		{
			menu.add(
				{
					itemId:'managegroup',
					text: 'Manage',
					handler:manageGroupFunction
				},
				{
					itemId: 'groupdetail',
					text: 'Details',
					handler: ShowGroupDetails
				},
				{
					temId:'renamegrp',
					text:'Rename',
					handler:OpenRenameDiv
				}
			);
		}
		break;
		case "MANAGE":
		menu.add(
			{
				itemId:'assigntosegment',
				text: 'Assign',
				handler:function()
				{
					assignToSegment(serverType,compName);
				}
			}
		);
		break;
	}
	menu.showAt(x,y);
}
function OpenManageSingleDiv(serverType,compName)
{
	window.parent.OpenManageDiv(serverType,compName);
}
function manageGroupFunction()
{
	var thistitle = document.getElementById('h_title').value;
	var thissegment = $("#segment").attr("value");
	var comptype = "DGroup";
	var compstatus = $("#h_status").attr("value"); 
	var compname = $("#h_cmpName").attr("value");
	var zoomValue = $("#zoom").attr("value");
	var compsrc = $("#h_src").attr("value");
	var thiszone="-1";
	var manGrp = "manageGroup";
	var segmentname ='<%=segmentName%>';
	var href = 'thiscomp='+encodeURI(thistitle)+'&comptype='+encodeURI(comptype)+'&segment='+segmentname+'&zone='+encodeURI(zoomValue)+'&status='+encodeURI(compstatus)+'&fromPage=EgAdminSegment'+'&zoom='+encodeURI(zoomValue)+'&compname='+encodeURI(compname)+'&action='+manGrp;
	var myUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageJSON.jsp?"+href;
	window.parent.manageGrpFunction(myUrl);
}
function ShowGroupDetails()
{
	var thistitle = document.getElementById('h_title').value;
	window.parent.showGroupDetails(thistitle);
}
function OpenRenameDiv()
{
	window.parent.showRename();
}
function assignToSegment(serverType,compName)
{
	var segmentname ='<%=segmentName%>';
	var componentName = serverType+":"+compName;
	Ext.Msg.show({
		title : "Segment",
		msg : 'Do you want to assign the component '+componentName+' to this '+segmentname+' ?',
		buttons : Ext.Msg.YESNO,
		icon : 'iconInformation',
		fn : function(i)
		{
			if (i == "yes") {
				window.parent.openAssign(serverType,compName);
			}
		}
	});
}
function getXMLObject()  //XML OBJECT
{
	var xmlHttp = false;
	try 
	{
		xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
	}
	catch (e) 
	{
		try 
		{
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch (e2) 
		{
			xmlHttp = false;
		}
	}
	if (!xmlHttp && typeof XMLHttpRequest != 'undefined') 
	{
		xmlHttp = new XMLHttpRequest();
	}
	return xmlHttp;
}

function autoFit()
{
	$('#fit').trigger('click');
}
function deleteZoomPositionsforMonitor()
{
	var segmentname ='<%=segmentName%>';
	//if(segmentname == 'Independent_servers')
	{
		segmentname = segmentname+"~|#|~Segment~Monitor";
	}
	var url = "/final/servlet/com.eg.SegmentPositionServlet";
	//var zoomHidden = document.getElementById("zoom").value;
	//var zoomHidden = zoomVal;
	//var translateHidden = translateVal;
	var params;
	//if (str == 'zoom')
	{
		params = "action=zoom&segment="+segmentname+"&zoom=-1";
		params += "&translate=";
	}
	xmlhttp = new getXMLObject();
	if(xmlhttp)
	{
		xmlhttp.open("POST",url,true);
		xmlhttp.onreadystatechange  = function()
		{
			if (xmlhttp.readyState == 4) 
			{
				if(xmlhttp.status != 200) 
				{
					//alert("Error occured while saving. Please try again ...."+xmlhttp.status);
				}
				else
				{					
				}
			}
		}
		xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlhttp.send(params);
	}
}
function savePositions(str,check)
{
	var param;
	var url = '/final/servlet/com.eg.EgSegmentPositionServlet';
	var topologyRenderingMode = '<%=topologyRenderingMode%>';

	var	pan_X ;
	var	pan_Y ;
	var zoomVal = $('.slider').slider("option", "value");
	var discElementStatus = "";
	if(check == true)
	{
		discElementStatus = "enabled";
	}
	else
	{
		discElementStatus = "disabled";
	}

	try {
		pan_X = int_X;
		pan_Y = int_Y;
	} catch(e){
		pan_X = -8;// default pan X value is -8
		pan_Y = -8;// default pan Y value is -8

		//pan_X = $( window ).width()/2;// default pan X value is -8
		//pan_Y = $( window ).height()/2;// default pan Y value is -8
	}
	
	
	
	for(var i in nodesJson)
	{
		var key = nodesJson[i].compID;
		var val = nodesJson[i].x+'#'+nodesJson[i].y;
		compPosition.put(key, val);
		
	}

	var segmentname ='<%=segmentName%>';
	if(segmentname == 'Independent_servers')
	{
		var siteName = '<%=site%>';
		segmentname = siteName + ":" + segmentname;
	}	
	
	var zoomHidden = 100;
	
	if(str == 'save')
	{
		var keys = compPosition.listKeys();
		param ='action=' + str + '&segment=' + segmentname + '&total=' 
			+ keys.length + '&zoom=' + zoomVal + '&discElementStatus=' + discElementStatus + '&pan_X=' + pan_X + '&pan_Y=' + pan_Y + '&topologyRenderingMode=' + topologyRenderingMode; 
		
		//param ="action="+str+"&segment="+segmentname+"&total="+keys.length+"&zoom="+zoomHidden;//zoomVal+"&pan_X="+pan_X+"&pan_Y="+pan_Y; 
		for(var k = 0; k < keys.length; k++)
		{
			var key = keys[k];
			var val = compPosition.get(key);
			param += '&key'+k+'='+key+'&val'+k+'='+val;
		}
	}
	xmlhttp = new getXMLObject();
	if(xmlhttp)
	{
		xmlhttp.open("POST",url,true);
		xmlhttp.onreadystatechange  = function()
		{
			if (xmlhttp.readyState == 4) 
			{
				if(xmlhttp.status == 200) 
				{
					if(str == 'save')
					{
						Ext.Msg.show({
							title : 'SEGMENT',
							msg : 'Component positions have been saved successfully.',
							width : 400,
							icon : 'iconInformation',
							buttons : Ext.Msg.OK
						});
						deleteZoomPositionsforMonitor();
					}
				}
				else 
				{
					Ext.Msg.show({
						title : 'SEGMENT',
						msg : 'Error occured. Please try again ...',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK
					});
				}
			}
		}
		xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlhttp.send(param);
	}
}
function moveEnd(obj)
{
	var key = obj.compID;
	var val = obj.x +'#'+obj.y;

	compPosition.put(key, val);
}
function resetPositions(check)
{
	var fromAction = 'showDiscComp';
	var checked = check;
	var segmentname = '<%=segmentName%>';
	var site = '<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	//var zoom = document.getElementById('zoom').value;
	var zoom = 100; 
	var isfull = '<%=isFull%>';
	var myUrl = 'EgAdminSegmentD3JS.jsp?segment=' + encodeURIComponent(segmentname) + '&default=true&zoom=' + zoom + '&site=' + encodeURIComponent(site) + '&physical_topology=' + phyTopo+"&com.eg.CSRF_NONCE="+csrfToken+"&fromAction="+fromAction+"&checked="+checked;
	if(isfull == 'true')
		myUrl = myUrl + '&view=full';
	//window.location.href = myUrl;
	setTimeout(function(){
		window.location = myUrl;
	}, 0);
}

function defaultPosition()
{
	var segmentname = '<%=segmentName%>';
	var site = '<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	var zoom = 100; 
	var isfull = '<%=isFull%>';
	var myUrl = 'EgAdminSegmentD3JS.jsp?segment='+encodeURIComponent(segmentname)+'&default=false&zoom='+zoom+'&site='+encodeURIComponent(site)+'&physical_topology='+phyTopo+"&com.eg.CSRF_NONCE="+csrfToken;
	if(isfull == 'true')
		myUrl = myUrl + '&view=full';
	//window.location.href = myUrl;
	setTimeout(function(){
		window.location = myUrl;
	}, 0);
	
}
function autoPositions()
{
	var segmentname = '<%=segmentName%>';
	var site = '<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	var zoom = 100; 
	var isfull = '<%=isFull%>';
	var myUrl = 'EgAdminSegmentD3JS.jsp?segment='+encodeURIComponent(segmentname)+'&default=false&zoom='+zoom+'&site='+encodeURIComponent(site)+'&physical_topology='+phyTopo+"&autoPosition=true&com.eg.CSRF_NONCE="+csrfToken;

	if(isfull == 'true')
		myUrl = myUrl +'&view=full';
	//window.location.href = myUrl;
	setTimeout(function(){
		window.location = myUrl;
	}, 0);
	
}
function newDiscComp(check)
{
	var fromAction = 'showDiscComp';
	var checked = check;
	var segmentname = '<%=segmentName%>';
	var site = '<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	var myUrl = 'EgAdminSegmentD3JS.jsp?segment='+encodeURIComponent(segmentname)+'&default=false&site='+encodeURIComponent(site)+'&physical_topology='+phyTopo+"&autoPosition=false&fromAction="+fromAction+"&checked="+checked+"&com.eg.CSRF_NONCE="+csrfToken;
	setTimeout(function(){
		window.location = myUrl;
	}, 0);
}
function openBigDiv(check)
{
	var mySegment = '<%=segmentName%>';
	var site = '<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	var fromAction = 'showDiscComp';
	var checked = check;
	var screenWidth = screen.width;
	var screenheight = screen.height;
	
	var myUrl = 'Segments/data/EgAdminSegmentD3JS.jsp?segment=' + encodeURIComponent(mySegment) + '&view=full&site='+encodeURIComponent(site) + '&physical_topology=' + phyTopo+"&com.eg.CSRF_NONCE="+csrfToken+"&fromAction="+fromAction+"&checked="+checked;
	return myUrl;
}

</script>
</head>
<body>
<div id="diagram" ></div>
<div  class="div_scroll" style="width:50%;height:auto;border:0px solid black;" id="alarmsListDiv">
</div>
<div id="hiddenDiv">
<input type="hidden" id="h_title" name="h_title" value="">
<input type="hidden" id="h_src" name="h_src" value="">
<input type="hidden" id="h_status" name="h_status" value="">
<input type="hidden" id="h_cmptype" name="h_cmptype" value="">
<input type="hidden" id="h_cmpName" name="h_cmpName" value="">
<input type="hidden" id="lorn" name="lorn" value="">
<input type="hidden" id="link" name="link" value="<%=link%>">
<input type="hidden" id="site" name="site" value="<%=site%>">
<input type="hidden" id="segment" name="segment" value='<%=segmentName%>'>
<input type="hidden" name="zoom" id="zoom" value='<%=zoomLevel%>'>
</div>
<script>
function getPaperHeight(paperHeight)
{	
	var winHeight = $( window ).height();
	if(paperHeight < winHeight || isAutoFit === true){
		paperHeight = winHeight;
	}
	return paperHeight;
}
function getPaperWidth(paperWidth)
{	
	var winWidth = $( window ).width();
	if(paperWidth < winWidth || isAutoFit === true){
		paperWidth = winWidth;
	}
	return paperWidth;
}
$(window).ready(function(){
	var topologyPosition = '<%=topologyPosition%>';
	isAutoFit = ('<%=topologyRenderingMode%>' == 'auto')?true:false;
	var url = '<%=link%>';
	/**var url ='/final/monitor/EgSegmentTopologyJSON.jsp?segment=assads&physical_topology=1&fromHomepage=true&type=segment&zoom=100&isFromZone=null&iszoneName=&parentZone=null&segmentState=segment20New_INTERMEDIATE';
	**/

	Ext.Ajax.request({
			url:url,
			method: 'POST',
			success:function(respons)
			{
				if (respons.status == 200 && !Ext.isEmpty(respons.responseText))
				{
					var response = respons.responseText;
					
					var jsonData = Ext.decode(response);
					var rootJson = jsonData['rootJson'];
					
					var paperHeight = jsonData.rootJson.paper['height'];
					var paperWidth = jsonData.rootJson.paper['width'];
					var zoomLevel = jsonData.rootJson.paper['zoomLevel'];
					var pan_X = jsonData.rootJson.paper['pan_X'];
					var pan_Y = jsonData.rootJson.paper['pan_Y'];
					
					paperHeight = getPaperHeight(paperHeight);
					paperWidth = getPaperWidth(paperWidth);
					if(zoomLevel == null || zoomLevel.length == 0 || zoomLevel == 100){
						zoomLevel = 1;// default zoom value is 1
					}
					if( pan_X == null || pan_X.length == 0 ){
						pan_X = -8;// default pan X value is -8
					}
					if( pan_Y == null || pan_Y.length == 0 ){
						pan_Y = -8;// default pan Y value is -8
					}
					nodesJson = jsonData.rootJson.nodes; //nodesJson is used in savePositions() function
					$('#diagram').renderSvg({
						renderTo: '#diagram',
						zoom:true,
						draggable:true,
						collideLayout:isAutoFit,
						enableFitLayout: true,
						layoutAlign:'center',
						//layoutAlign:topologyPosition,
						width:paperWidth,
						height:paperHeight,
						initialX:pan_X,
						initialY:pan_Y,
						default_zoom:zoomLevel,
						segmentName: '<%=segmentName%>',
						//width:$( window ).height(),
						data:jsonData
					}); 
				}
			},
			failure: function(){
				Ext.Msg.show({
						title: 'Topology',
						msg: 'Request failed',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
			}
			}) ;
/**
//console.log('url--->' + url);

$('#diagram').renderSvg({
		renderTo: '#diagram',
		//height:1500,
		zoom:true,
		width:$('#diagram').width(),
		url:url
	});
	**/
 })
</script>

</body>
</html>


<% 
%>