<%
/*****************************************************************************************************
*	Name		:	EgTopologyJSON.jsp
*	Purpose		:	To get the admin segment topology JSON Object
*
*---                             ---Prantish A
******************************************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "egurkha.EgCrawlerAdmin" %>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ taglib prefix = "egui" uri="../../../WEB-INF/eg-taglib.tld" %> 
<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<%

try
{
	response.setHeader("Cache-Control", "no-store");
	response.setHeader("Pragma", "no-cache");
	response.setDateHeader ("Expires", -1);
	String ua = request.getHeader( "User-Agent" );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
	IniFile udTests = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_udtests.ini");
	String segmentName = request.getParameter("segment");
	String zoomLevel = request.getParameter("zoom");
	String view = request.getParameter("view");
	String defaultPos = request.getParameter("default");
	String fromAction = request.getParameter("fromAction");
	String checked = request.getParameter("checked");
	String topologyRenderingMode = request.getParameter("topologyRenderingMode");
	String finalJSON = "";
	String discElmtStatus = "disabled";
	String topologySkin = _user.getAdminSkin();
	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	
	if(zoomLevel == null)
	{
		zoomLevel = "100";
	}
	boolean isFull = false;
	if(view != null && view.equals("full"))
		isFull = true;
	HashMap compMap = new HashMap();
	String site = request.getParameter("site");
	String phyTopology = request.getParameter("physical_topology");
	if(site == null)
		site = "egurkha.physical.topology";
	String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
	IniFile topoiniFile = new IniFile(iniFilePath);
	ArrayList newlyManagedList = new ArrayList();
	ArrayList managedCompArrList = new ArrayList();
	if(fromAction != null && fromAction.equalsIgnoreCase("showDiscComp"))
	{
		String[] topoVar = topoiniFile.getVariables("Segments_Mapping");
		if(checked == "true" || checked.equals("true") )
		{
			discElmtStatus = "enabled";
			for(int v=0; v<topoVar.length; v++)
			{
				String discSeg = topoVar[v];
				String configSeg = topoiniFile.getValue("Segments_Mapping",discSeg);
				StringTokenizer strTok = new StringTokenizer(configSeg,"#");
				while(strTok.hasMoreTokens())
				{
					String configSegTok = strTok.nextToken();
					if(configSegTok.equalsIgnoreCase(segmentName))
					{
						managedCompArrList = getautoTopoSegmentNewManageComponentList(configSegTok,discSeg);
						compMap = getNewComponentMapping(configSegTok,discSeg);
						HashMap managedMap = (HashMap)compMap.get("MANAGE");
						Iterator itr = managedMap.keySet().iterator();
						while(itr.hasNext())
						{
							String var = (String)itr.next();
							ArrayList managedLIst = (ArrayList)managedMap.get(var);
							newlyManagedList.addAll(managedLIst);
						}
					}
				}
			}
		}
	}
	String manCompStr = "";
	if(managedCompArrList.size()>0)
	{
		for(int g=0; g<managedCompArrList.size(); g++)
		{
			String str = (String)managedCompArrList.get(g);
			manCompStr += str + ", ";
		}
	}
	String installDir = EgInstallInfo.getInstallDir();
	String iniFileName = installDir + "/manager/config/js_topology.ini";
	if(topologyRenderingMode != null && topologyRenderingMode.equals("auto")){
		iniFileName = installDir + "/manager/config/js_auto_topology.ini";
	}
	IniFile jsTopoIniObj  = EgConfigFilesSync.getInstance(iniFileName);
	String subjectName = segmentName;
	if(segmentName != null && segmentName.equals("Independent_servers"))
	{
		subjectName = site + ":" + segmentName;
	}
	String[] allLines = jsTopoIniObj.getLinesUnderSubject(subjectName);
	String iniZoom = jsTopoIniObj.getValue(subjectName, "zoom");
	if(iniZoom != null && iniZoom.length() > 0 )
	{
		zoomLevel = iniZoom;
	}
	EgConfigFilesSync.releaseInstance(jsTopoIniObj);
	//System.out.println("releaseInstance .egNewTopo..");
	boolean isPosition = false;
	StringBuffer positionBuffer = new StringBuffer();
	if(allLines != null)
	{
		List positionList = Arrays.asList(allLines);
		positionBuffer.append(positionList.toString().substring(1,positionList.toString().indexOf("]")));
		isPosition = true;
	}

	if(defaultPos != null && defaultPos.equals("true"))
		isPosition = false;
	String finalTopoStr = "";
	if(compMap.size() > 0)
	{
		finalTopoStr = getTopologyString(segmentName, site, phyTopology,compMap);
	}
	else
	{
		finalTopoStr = getTopologyString(segmentName, site, phyTopology);
	}
	
	//Get row & column spacing from eg_ui.ini .... (Begin)
	IniUI iniUI = IniUI.getInstance();
	String rs = iniUI.getValue("TOPOLOGY_OPTIONS", "Row_space");
	String cs = iniUI.getValue("TOPOLOGY_OPTIONS", "Column_space");
	iniUI =  null;
	JSONObject rootJson = new JSONObject();
	int rowspace = 50;
	int colspace = 50;
	try
	{
		if(rs!=null) rowspace = Integer.parseInt(rs);
	}
	catch(Exception e){
	}

	try
	{
		if(cs!=null) colspace = Integer.parseInt(cs);
	}
	catch(Exception e){
	}
	//Get row & column spacing from eg_ui.ini .... (End)
	if(manCompStr.endsWith(", "))
		manCompStr = manCompStr.substring(0,manCompStr.length()-2);
	EgNewTopology egNewTopo = new EgNewTopology(finalTopoStr, rowspace, colspace, topologySkin, request);

	if(topologyRenderingMode != null && topologyRenderingMode.equals("auto")) {
		rootJson.put("rootJson", egNewTopo.getAutoTopologyJson(manCompStr));
	} else {
		rootJson.put("rootJson", egNewTopo.getTopologyJson(manCompStr,discElmtStatus));
	}
	response.setContentType("application/json;charset=UTF-8");
	response.getWriter().write(rootJson.toString());
	}
	catch(Exception e)
	{
		System.out.println("Exception in admin/segments/data/EgTopologyJSON.jsp....");
		e.printStackTrace();
	}
	
%>

<%!
	private String getTopologyString(String segmentName, String site , String phyTopology)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		EgCrawlerAdmin strBean = new EgCrawlerAdmin(iniFile);

		String str = null;

		if (phyTopology.equals("1"))
			str = strBean.getPhysicalTopology(segmentName);
		else
		{
			if (segmentName.equals("Independent_servers"))
			{
				str = strBean.getSiteString(site, site + "_INDEPENDENT");
			}
			else
			{
				str = strBean.getSiteString(site, segmentName);
			}
		}

		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str)) {
			newString = EgConstants.BLANK_SPACE;
		}else{
			newString = ap.getTopologyPriority(str, site);
		}
		newString = sortTopoString(newString);

		return newString;
	}

	private String getTopologyString(String segmentName, String site , String phyTopology, HashMap compMap)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		EgCrawlerAdmin strBean = new EgCrawlerAdmin(iniFile);

		String str = null;

		if (phyTopology.equals("1"))
		{
			str = strBean.getPhysicalTopology(segmentName,compMap);
		}
		else
		{
			if (segmentName.equals("Independent_servers"))
			{
				str = strBean.getSiteString(site, site + "_INDEPENDENT");
			}
			else
			{
				str = strBean.getSiteString(site, segmentName);
			}
		}

		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str)) {
			newString = EgConstants.BLANK_SPACE;
		}else{
			newString = ap.getTopologyPriority(str, site);
		}
		newString = sortTopoString(newString);

		return newString;
	}

	/*
	To sort the topology string so that the new topology applet will understand
	*/
	public String sortTopoString(String topoStr) 
	{
		if(topoStr == null)
			return null;
		Hashtable h = new Hashtable();

		String [] topoToks = StringUtils.getTokens(topoStr, "|");

		ArrayList finalLhs = new ArrayList();
		ArrayList finalRhs = new ArrayList();
		ArrayList leftOver = new ArrayList();
		boolean changesOccured = false;
		while (!changesOccured)	 //loop until sorted properly changesOccured becomes true
		{
			changesOccured = true;	
			for (int i = 0; i < topoToks.length; i++ )
			{
				String [] relation = StringUtils.getTokens(topoToks[i], "=");
				String thisLhs = "";
				String thisRhs = "";
				if(relation != null && relation.length == 2)
				{
				 thisLhs = relation[0];
				 thisRhs = relation[1];	//Network_node:Core_Switch_1:NULL:N:GOOD,Network_node:Core_Switch_2:NULL:N:GOOD
				}
				else if(relation != null && relation.length == 1)
				{
					thisLhs = relation[0];
				}
				//System.out.println("! thisLhs:"+thisLhs);
				if (i == 0)
				{
					//add first component
					if (finalLhs.indexOf(thisLhs) == -1)	 //if lhs is already added, skip
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}
				}else
				{
					Object rhsObj = h.get(thisLhs);
					/*
						if rhsObj is null, it means that we get a wrong entry, i.e. the component comes in improper order. 
						a component which havnt come in rhs, has been given as lhs. so dont add it right now. wait until the 
						necessary rhs is getting added.
					*/
					if (rhsObj != null && finalLhs.indexOf(thisLhs) == -1)
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}else
					{
						if (rhsObj == null)				//if rhsObj is null, it means that some component is not yet added
							changesOccured = false;
					}
				}
			}
		}

		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < finalLhs.size(); i++ )
		{
			String thisStr = (String)finalLhs.get(i);
			ArrayList rhsList = (ArrayList) finalRhs.get(i);
			Iterator myIter = rhsList.iterator();
			StringBuffer sb2 = new StringBuffer();
			while (myIter.hasNext())
			{
				TopoRhsComp thisRhsComp = (TopoRhsComp) myIter.next();
				sb2.append(thisRhsComp.getComponent());
				if (myIter.hasNext())
					sb2.append(",");
			}
			sb.append(finalLhs.get(i));
			sb.append("=");
			sb.append(sb2.toString());
			sb.append("|");
		}
		String result = sb.toString();
		if (result.endsWith("|"))
		{
			result = result.substring(0, result.lastIndexOf("|"));
		}
		return result;
	}

	public ArrayList getRhsList(String thisRhs, String thisLhs, Hashtable h)
	{
		ArrayList result = new ArrayList();
		if(thisRhs != null && !thisRhs.equals(""))
		{
			String [] toks = StringUtils.getTokens(thisRhs, ",");
			for (int i=0; i < toks.length; i++ )
			{
				String thisStr = toks[i];
				TopoRhsComp rhsCmp = new TopoRhsComp(thisStr);
				result.add(rhsCmp);
				//System.out.println("$$$$$:"+rhsCmp.toString()+"\t"+thisLhs);
				if (!rhsCmp.toString().equals("null"))
				{
					h.put(rhsCmp.toString(), thisLhs);
				}
			}
		}
		return result;
	}
	
	public ArrayList getautoTopoSegmentNewDiscComponentList(String configSeg, String discSeg)
	{
		ArrayList newCompArrList = new ArrayList();
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile topoiniFile = new IniFile(iniFilePath);
		String[] varArray = topoiniFile.getVariables("Segments_Mapping");
		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			if(varName.equalsIgnoreCase(discSeg))
			{
				Hashtable newComptable = getUnmanageAndNewComponents(varName);
				TreeSet newCompSet = (TreeSet) newComptable.get("NEW");
				TreeSet unManageSet = (TreeSet) newComptable.get("UNMANAGE");
				ArrayList newGroup = getNewDiscGrp(discSeg);
				newCompArrList.addAll(newCompSet);
				newCompArrList.addAll(newGroup);
			}
		}
		return newCompArrList;
	}
	public ArrayList getautoTopoSegmentNewManageComponentList(String configSeg, String discSeg)
	{
		ArrayList manageCompArrList = new ArrayList();
		ArrayList configCompArrList = new ArrayList();
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile topoiniFile = new IniFile(iniFilePath);
		String[] varArray = topoiniFile.getVariables("Segments_Mapping");
		String[] topoArray = topoiniFile.getVariables(configSeg);
		for(int v=0; v<topoArray.length; v++)
		{
			String configStr = topoArray[v];
			String configValues = (String)topoiniFile.getValue(configSeg,configStr);
			StringTokenizer strTok = new StringTokenizer(configValues,",");
			while(strTok.hasMoreTokens())
			{
				String tok = strTok.nextToken();
				if(tok.endsWith(":L"))
				{
					tok = tok.replace(":L","");
				}
				if(tok!=null)
					configCompArrList.add(tok);
			}
			configCompArrList.add(configStr);
		}
		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			if(varName.equalsIgnoreCase(discSeg))
			{
				Hashtable newComptable = getUnmanageAndNewComponents(varName);
				TreeSet manageCompSet = (TreeSet) newComptable.get("MANAGE");
				manageCompArrList.addAll(manageCompSet);
			}
		}
		manageCompArrList.removeAll(configCompArrList);
		return manageCompArrList;
	}
	public HashMap getNewComponentMapping(String configSeg, String discSeg)
	{
		HashMap newCompVarMap = new HashMap();
		HashMap manageCompVarMap = new HashMap();
		HashMap compVarMap = new HashMap();
		EgAutoTopologyPreview egAutoTopo = new EgAutoTopologyPreview();
		egAutoTopo.autoTopology();
		String autoiniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile autotopoiniFile = new IniFile(autoiniFilePath);
		String topoiniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile topoiniFile = new IniFile(topoiniFilePath);
		String[] varArray = autotopoiniFile.getVariables(discSeg);
		String[] topoVarArray = topoiniFile.getVariables(configSeg);
		ArrayList topoVarList = new ArrayList();
		for(int m=0; m<topoVarArray.length; m++)
		{
			String varName = (String)topoVarArray[m];
			topoVarList.add(varName);
		}
		ArrayList newCompList = getautoTopoSegmentNewDiscComponentList(configSeg,discSeg);
		ArrayList manageCompList = getautoTopoSegmentNewManageComponentList(configSeg,discSeg);
		if(newCompList.size()>0)
		{
			for(int k=0;k<varArray.length;k++)
			{
				ArrayList sameKeyList = new ArrayList();
				String varName = varArray[k];
				String val = autotopoiniFile.getValue(discSeg, varName);
				String topoVal = autotopoiniFile.getValue(configSeg, varName);
				StringTokenizer strTok = new StringTokenizer(val,",");
				while(strTok.hasMoreTokens())
				{
					String tok = strTok.nextToken();
					if(tok.endsWith(":L") && !tok.startsWith("DGroup:"))
					{
						tok = tok.replace(":L","");
					}
					if(newCompList.contains(tok))
					{
						if(!sameKeyList.contains(tok))
						{
							if(tok.startsWith("DGroup:"))
							{
								tok = tok.replace(":L","");
							}
							sameKeyList.add(tok);
						}
						if(topoVarList.contains(varName))
							newCompVarMap.put(varName,sameKeyList);
					}
				}
			}
		}
		if(manageCompList.size()>0)
		{
			for(int l=0;l<varArray.length;l++)
			{
				ArrayList sameKeyList = new ArrayList();
				String varName = varArray[l];
				String val = autotopoiniFile.getValue(discSeg, varName);
				StringTokenizer strTok = new StringTokenizer(val,",");
				while(strTok.hasMoreTokens())
				{
					String tok = strTok.nextToken();
					if(tok.endsWith(":L") && !tok.startsWith("DGroup:"))
					{
						tok = tok.replace(":L","");
					}
					if(manageCompList.contains(tok))
					{
						if(!sameKeyList.contains(tok))
						{
							sameKeyList.add(tok);
						}
						if(topoVarList.contains(varName))
							manageCompVarMap.put(varName,sameKeyList);
					}
				}
			}
		}
		compVarMap.put("MANAGE",manageCompVarMap);
		compVarMap.put("NEW",newCompVarMap);
		return compVarMap;
	}
	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		Hashtable result = new Hashtable();
		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();
		Set manageSet = new TreeSet();
		String[] varArray = iniFile.getVariables(segmentName);
		for(int k = 0; k < varArray.length; k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0, varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName, newstr+varName);
			String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
			if(newValue != null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else if(unmanageValue != null && unmanageValue.length() > 0)
			{
				unmanageSet.add(varName);
			}
			else
			{
				manageSet.add(varName);
			}
			String valName = iniFile.getValue(segmentName, varName);
			if(valName != null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName, ",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0, tok.indexOf(":"));
				String tmpvar = tok.substring(0, tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname, newstr+tmpvar);
				String unmanageVal = disIniFile.getValue(tmpcompname, unmanagestr + tmpvar);
				if(newval != null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else if(unmanageVal != null && unmanageVal.length() > 0)
				{
					unmanageSet.add(tmpvar);
				}
				else
				{
					manageSet.add(tmpvar);
				}
			}
		}
		/*if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);*/
		result.put("NEW", newSet);
		result.put("UNMANAGE", unmanageSet);
		result.put("MANAGE", manageSet);
		return result;
	}
	private ArrayList getNewDiscGrp(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile autoTopoFile = new IniFile(iniFilePath);
		String[] segVar = autoTopoFile.getVariables(segmentName); 
		ArrayList newGrp = new ArrayList();
		//boolean isManGrp = false;
		for(int k=0; k<segVar.length; k++)
		{
			String var = segVar[k];
			String val = autoTopoFile.getValue(segmentName,var);
			StringTokenizer compTok = new StringTokenizer(val,",");
			while(compTok.hasMoreTokens())
			{
				String singleComp = compTok.nextToken();
				if(singleComp.startsWith("DGroup:"))
				{
					boolean isManGrp = isManagedGrp(singleComp);
					if(!isManGrp)
					{
						newGrp.add(singleComp);
					}
				}
			}
		}
		return newGrp;
	}
	public boolean isManagedGrp(String autoGrpName)
	{
		EgGroupInfo groupInfo = new EgGroupInfo();
		if(autoGrpName.startsWith("DGroup:"))
		{
			autoGrpName = autoGrpName.replace("DGroup:","");
			if(autoGrpName.endsWith(":L"))
			{
				autoGrpName = autoGrpName.replace(":L","");
			}

			if(autoGrpName.endsWith(":NULL"))
			{
				autoGrpName = autoGrpName.replace(":NULL","");
			}
			
		}
		boolean isManaged = false;
		String[] grpNames = groupInfo.getGroupNames();
		for(int k=0; k<grpNames.length; k++)
		{
			String grpName = grpNames[k];
			if(grpName.equalsIgnoreCase(autoGrpName))
			{
				isManaged = true;
			}
		}
		return isManaged;
	}
%>
