<%
/*******************************************************************************
*   Name                        :   getDataForMaintenanceAnalysis.jsp
*   Purpose                 :   To analyze maintenance periods
*   Version                     :   4.3
*   Created                 :   15.09.2008
*   Author                      :   Antony & Team
*   Design Changes  :   Jaiwin
*******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ page import = "com.egurkha.admin.*" %>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	String  param=request.getParameter("from");
	String  option=request.getParameter("option");
	if(session.getAttribute("paramForAnalysis")!=null)
	{
		session.removeAttribute("paramForAnalysis");
	}
	session.setAttribute("paramForAnalysis",request.getQueryString());
	session.setAttribute("paramforTab","Initial");
	String sessionIDStr = session.getId();
	String userID = (String)session.getAttribute("sess_userid");
	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionIDStr,userID);
	String  opt=request.getParameter("opt");
	String element=request.getParameter("element");
	String testElement=request.getParameter("testElement");
	String descElement=request.getParameter("descName");
	String day=request.getParameter("day");
	String startDate=request.getParameter("startDate");
	String endDate=request.getParameter("endDate");
	String  search=request.getParameter("searchStr");
	if(startDate==null || startDate.equals("null"))
		startDate="";
	if(endDate==null || endDate.equals("null"))
		endDate="";
	String startHr=request.getParameter("startHr");
	String endHr=request.getParameter("endHr");
	if(search==null || search.equals("null"))
		search="";
	ErUtils erutils=new ErUtils();
	EgMaintenanceUtility egM=new EgMaintenanceUtility();
	String[]  elements={"All","Host","Component","Test","Descriptor","Descriptor For Component","Test For Host","Test  For Component","Policy","Time Constraints"};
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	boolean isLimitedAdmin = false;// Limited admin
	if (!roleInfo.hasAllComponentAccess())
	{
		isLimitedAdmin = true;
	}
	
	if (isLimitedAdmin) 
	{
		elements = new String[]{"All","Component","Test  For Component","Descriptor For Component","Policy","Time Constraints"};
	}
	List al=Arrays.asList(elements);
	Vector  options=new Vector();
	options.addAll(al);
	Vector analysisOptions=null;
	Vector timeVal=null;
	String selectLabel="";
	Vector testElements=new Vector();
	Vector descElements=new Vector();
	Vector mappedDescElements=new Vector();
	Vector compNameForUI = new Vector();
	String[]  daysDisplay={"Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"};
	List all=Arrays.asList(daysDisplay);
	Vector  display=new Vector();
	display.addAll(all);
	String[]  daysValue={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
	List v_al=Arrays.asList(daysValue);
	Vector  values=new Vector();
	values.addAll(v_al);
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = ui.getDefaultLanguage();
	if (_user!=null) 
	{
		String userLang = _user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL")) 
		{
			thisLanguage = userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	egM.setLanguage(thisLanguage);
	MappingNameSorter sorter = new MappingNameSorter(thisLanguage);
	String [] hours = {"0","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23"};
	List hrs=Arrays.asList(hours);
	Vector  hoursPeriod=new Vector();
	hoursPeriod.addAll(hrs);
	String paramForTab="";
	if(option!=null && option.equals("Component"))
	{
		analysisOptions=new Vector();
//		analysisOptions.add("All Components");
		analysisOptions.addAll(egM.getAllAvailableComponents());
		if (isLimitedAdmin) // Limited admin
		{
			Vector userComps = roleInfo.getAllServersWithoutType();
			analysisOptions.retainAll(userComps);
		}
	}
	else if(option!=null && option.equals("Host")) 
	{
		analysisOptions=new Vector();
		analysisOptions.add(mappingInfo.getTextDescription("admin.mpolicy.All Hosts"));
		analysisOptions.addAll(egM.getAllAvailableHosts());
	}
	else if(option!=null && option.equals("Test")) 
	{
		analysisOptions=new Vector();
	//	analysisOptions.add(mappingInfo.getTextDescription("admin.mpolicy.All Tests"));
		analysisOptions.addAll(egM.getAllAvailableTests());
	}
	else if((option!=null && option.equals("Test  For Component")) || (option!=null && option.equals("Test For Host"))) 
	{
		analysisOptions=new Vector();
//		analysisOptions.add(mappingInfo.getTextDescription("admin.mpolicy.All Tests"));
		if (option.equals("Test  For Component"))
		{
			analysisOptions.addAll(egM.getAllAvailableComponentTests());
			selectLabel=mappingInfo.getTextDescription("admin.mpolicy.Components");
		}
		else if (option.equals("Test For Host"))
		{
			analysisOptions.addAll(egM.getAllAvailableHostTests());
			selectLabel=mappingInfo.getTextDescription("admin.mpolicy.Hosts");
		}
		testElements=egM.getAllAvailableComponentsForTest(element);
		if (isLimitedAdmin) // Limited admin
		{
			String[] usrServerTypes = roleInfo.getServerTypes();
			ArrayList userTests = new ArrayList();
			ArrayList userComps = new ArrayList();
			if (usrServerTypes != null)
			{			
				for (int s=0; s < usrServerTypes.length; s++)
				{
					String[] enabledTestsForServerType = specsInfo.getTestsForServer(usrServerTypes[s]);
					if (enabledTestsForServerType != null && enabledTestsForServerType.length > 0)
					{
						userTests.addAll(Arrays.asList(enabledTestsForServerType));
					}

					Vector tmpUserComps = roleInfo.getServersForTypeWithoutType(usrServerTypes[s]);
					if (tmpUserComps != null && tmpUserComps.size() > 0)
					{
						userComps.addAll(tmpUserComps);
					}				  
				}

			}
			analysisOptions.retainAll(userTests);
			testElements.retainAll(userComps);			
		}
		//Removal of NULL port from Comp display name
		if(testElements != null)
		{
			for(int u=0; u < testElements.size(); u++)
			{
				String tmpComp = (String)testElements.get(u);
				int  nullIndex = tmpComp.indexOf(":NULL");
				if (nullIndex > -1)
				{
					tmpComp = tmpComp.substring(0,nullIndex);
				}
				compNameForUI.add(tmpComp);
			}
		}
		
		
	}
	else if(option!=null && option.equals("Policy")) 
	{
		analysisOptions=new Vector();
		analysisOptions.add(mappingInfo.getTextDescription("admin.mpolicy.Please Choose a Policy"));
		Vector AllPolicies=new Vector();
		AllPolicies.addAll(egM.getAllPoliciesFromGroups());
		AllPolicies.addAll(egM.getAllAssociatedUnplannedPolicies());
		if (isLimitedAdmin) // Limited admin
		{
			Vector userPolicies = new Vector();
			for (int a=0; a < AllPolicies.size(); a++)
			{
				String policyNameTmp = (String)AllPolicies.get(a);
				int index = policyNameTmp.indexOf("|$|");
				if (index > -1)
				{
					String policyUser = policyNameTmp.substring(index+3).trim();
					if (policyUser.equals(userID))
					{
						userPolicies.add(policyNameTmp);
					}
				}
			}
			AllPolicies.retainAll(userPolicies);
		}
		Collections.sort(AllPolicies,String.CASE_INSENSITIVE_ORDER);
		analysisOptions.addAll(AllPolicies);
	}
	else    if(option!=null && option.equals("Time Constraints")) 
	{
		analysisOptions=new Vector();
		String[]  timeContraints={"First Day of Month","Last Day of Month","Daily","Day of Week","Date"};
		List aList=Arrays.asList(timeContraints);
		analysisOptions.addAll(aList);
		timeVal=new Vector();
		String[]  timeContraint={"FDM","LDM","*","Day of Week","Date"};
		List a_List=Arrays.asList(timeContraint);
		timeVal.addAll(a_List);
	}
	else if(option!=null && option.equals("Descriptor"))
	{
		analysisOptions=new Vector();
		String empty="";
		analysisOptions.addAll(egM.getInfosForAllComponents(empty));
	}
	else if(option!=null && option.equals("Descriptor For Component"))
	{
		analysisOptions=new Vector();
		analysisOptions.addAll(egM.getAllAvailableComponents());
		if(element!=null && !element.equals("All Descriptor Comp"))
		{
			descElements.addAll(egM.getInfosForAllComponents(element));
			for(int i=0;i<descElements.size();i++)
			{
				String testWithDesc=(String)descElements.get(i);
				String test=testWithDesc.substring(0,testWithDesc.indexOf(":"));
				String desc=testWithDesc.substring(testWithDesc.indexOf(":")+1);
				test=mappingInfo.getTestDescription(test);
				String addDesc=test+":"+desc;
				mappedDescElements.add(addDesc);
			}
		}
	}
	if(search!=null && !search.equals("")) 
	{
		Vector tmp=new Vector();
		analysisOptions.remove(0);

		if(option!=null && (option.equals("Test") || option.equals("Test For Host") || option.equals("Test  For Component")))
		{
			String testStr="";
			String str="";
			for(int s=0;s<analysisOptions.size();s++) 
			{
				testStr = (String)analysisOptions.get(s);
				str = mappingInfo.getTestDescription(testStr);

				if(search!=null && search.length()>0)
				{
					StringTokenizer searchTokenizer=new StringTokenizer(search," ");
					while(searchTokenizer.hasMoreTokens())
					{
						String searchToken=searchTokenizer.nextToken();
						int cond = str.toUpperCase().indexOf(searchToken.toUpperCase());
						if(str.toUpperCase().indexOf(searchToken.toUpperCase())!=-1) 
						{
							tmp.add(testStr);
						}
					}
				}
				else if(search!=null)
				{
					tmp.add(testStr);
				}
			}
		}
		else
		{
			for(int s=0;s<analysisOptions.size();s++) 
			{
				String str=(String)analysisOptions.get(s);
				if(search!=null && search.length()>0)
				{
					StringTokenizer searchTokenizer=new StringTokenizer(search," ");
					while(searchTokenizer.hasMoreTokens())
					{
						String searchToken=searchTokenizer.nextToken();
						if(str.toUpperCase().indexOf(searchToken.toUpperCase())!=-1) 
						{
							tmp.add(str);
						}
					}
				}
				else if(search!=null)
				{
					tmp.add(str);
				}
			}
		}
		analysisOptions.clear();
		analysisOptions.addAll(tmp);
	}
	if(param!=null && param.equals("select1")) 
	{
		out.println("<select id=\"AnalysisBy\" name=\"AnalysisBy\" style=\"width:160px\" onchange=\"select_1()\" >"+erutils.fillSelectBox1(options,"",option)+"</select>");
	}
	else    if(param!=null && param.equals("select2")) 
	{
		Vector map_analysisOptions = new Vector();
		Vector dispval=new Vector();
		Vector actualval=new Vector();
		if(option!=null && !option.equals("All") && !option.equals("Time Constraints")) 
		{
			egM.setUserLanguage(thisLanguage);
			if(option.equals("Test") || option.equals("Test For Host") || option.equals("Test  For Component"))
			{
				map_analysisOptions.addAll(sorter.getSortedTestList(analysisOptions));//egM.getMappedValue(option,analysisOptions);
				dispval.add(mappingInfo.getTextDescription("admin.mpolicy.All Tests"));
				actualval.add("All Tests");
			}
			else if(option.equals("Component"))
			{
				dispval.add(mappingInfo.getTextDescription("admin.mpolicy.All Components"));
				actualval.add("All Components");
				dispval.addAll(egM.getMappedValue(option,analysisOptions));
				Vector tempDis = new Vector(dispval);
				for (int i = 0;i < tempDis.size();i++)
				{
					String s_temp = (String) tempDis.get(i);
					if(s_temp.endsWith(":NULL"))
					{
						dispval.remove(s_temp);
						s_temp = s_temp.substring(0, s_temp.indexOf(":NULL"));
						dispval.add(i,s_temp);
					}
				}
				actualval.addAll(egM.getMappedValue(option,analysisOptions));
			}
			else if(option.equals("Host") || option.equals("Policy"))
			{
				dispval.addAll(analysisOptions);
				actualval.addAll(analysisOptions);
				if (option.equals("Policy")) // Limited admin
				{
					List tmpList = new ArrayList();
					for(int i=0;i<dispval.size();i++)
					{
						String displayValue = dispval.get(i).toString();
						int index = displayValue.indexOf("|$|");
						if (index > -1) // PolicyName|$|UserName
						{
							if (isLimitedAdmin)
							{
								displayValue = displayValue.substring(0,index);
							}
							else
							{
								displayValue = displayValue.substring(0,index) + " ("+displayValue.substring(index+3)+")";
							}
							dispval.remove(i);
							dispval.add(i,displayValue);
						}						
					}
				}
			}
			else if(option.equalsIgnoreCase("Descriptor"))
			{
				Vector tempValue=new Vector();
				if(analysisOptions!=null && analysisOptions.size()>0)
				{
					for(int i=0;i<analysisOptions.size();i++)
					{
						String testWithDesc=(String)analysisOptions.get(i);
						if(testWithDesc.indexOf(":")>-1)
						{
							String test=mappingInfo.getTestDescription(testWithDesc.substring(0,testWithDesc.indexOf(":")));
							String info=testWithDesc.substring(testWithDesc.indexOf(":")+1);
							String disp=test+"("+info+")";
							tempValue.add(disp);
						}
					}
				}
				dispval.add(mappingInfo.getTextDescription("admin.mpolicy.All Descriptors"));
				actualval.add("All Descriptors");
				dispval.addAll(egM.getMappedValue(option,tempValue));
				actualval.addAll(egM.getMappedValue(option,analysisOptions));
			}
			else if(option.equalsIgnoreCase("Descriptor For Component"))
			{
				dispval.add(mappingInfo.getTextDescription("admin.mpolicy.All Descriptor Comp"));
				actualval.add("All Descriptor Comp");
				dispval.addAll(egM.getMappedValue(option,analysisOptions));
				actualval.addAll(egM.getMappedValue(option,analysisOptions));
				Vector tempDFC = new Vector(dispval);
				for (int i = 0;i < tempDFC.size();i++)
				{
					String s_temp = (String) tempDFC.get(i);
					if(s_temp.endsWith(":NULL"))
					{
						dispval.remove(s_temp);
						s_temp = s_temp.substring(0, s_temp.indexOf(":NULL"));
						dispval.add(i,s_temp);
					}
				}
			}
			if(option.equals("Test") || option.equals("Test For Host") || option.equals("Test  For Component") || option.equals("Component") || option.equals("Descriptor") || option.equals("Descriptor For Component"))
			{
				for (int s=0;s<map_analysisOptions.size();s++)
				{
					EgName nameObj = (EgName)map_analysisOptions.get(s);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					dispval.add(tmpDis);
					actualval.add(tmpVal);
				}
			}
			out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td>Search&nbsp;</td><td><input type=\"text\" id=\"srch\" name=\"search\" size=\"18\" MaxLength=\"32\" value=\""+search+"\" style=\"height:18px;width:100px;\"></td><td style=\"width:20px\" align=\"center\"><img id='mouse' border=\"0\" onclick=\"javascript:egTitleSearch();\" title=\"GO\" src=\"/final/admin/eg_images/"+admin_Skin+"/arrow_1.gif\"/></td><td align=\"right\" style=\"width:130px\" nowrap>"+option+"&nbsp;&nbsp;</td><td><select name=\"AnalysisElement\" id=\"AnalysisElement\" style=\"width:200px\"  onchange=\"select_2()\"  onfocus=\"window.dropdown_menu_hack(this)\">"+erutils.fillSelectBox1(actualval,dispval,"",element)+"</select></td></tr></table>");
		}
		else if(option!=null && option.equals("Time Constraints")) 
		{
			out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td style=\"width:50px\">&nbsp;</td><td align=\"right\" style=\"width:150px\">"+option+"&nbsp;</td><td>&nbsp;<select name=\"AnalysisElement\" id=\"AnalysisElement\" style=\"width:200px\"  onchange=\"select_2()\">"+option+erutils.fillSelectBox1(timeVal,analysisOptions,"",element)+"</select></td></tr></table>");
		}
	}
	else    if(param!=null && param.equals("select3")) 
	{
		if(option!=null && (option.equals("Test For Host") || option.equals("Test  For Component"))) 
		{
			if(element!=null && !element.equals("All Tests")) 
			{
				out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td align=\"left\" style=\"width:80px\">"+selectLabel+"&nbsp;&nbsp;</td><td><select name=\"TestElement\" id=\"TestElement\" style=\"width:200px\" >"+option+erutils.fillSelectBox1(testElements,compNameForUI,"",testElement)+"</select></td><td width=\"56%\">&nbsp; </td></tr></table>");
			}
		}
		if(option!=null && option.equals("Time Constraints") && element!=null && element.equals("Day of Week") ) 
		{
			out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\" style=\"table-layout:auto\"><tr><td align=\"left\" style=\"width:80px\">Days</td><td><select id=\"days\" name=\"days\" style=\"width:160px\" >"+option+erutils.fillSelectBox1(values,display,"",day)+"</select></td><td width=\"56%\">&nbsp; </td></tr></table>");
		}
		if(option!=null && option.equals("Time Constraints") && element!=null && element.equals("Date") ) 
		{
			String s="<table width=\"75%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\" style=\"padding-top:6px\"><tr><td width=\"70\"><table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td align=\"right\" style=\"padding-right:4px\">From </td><td><a href='javascript:void(0);' onClick=\"checkwindow3(document.getElementById('startDate'),event,'EgMaintenanceAnalysis');\"><img src=\"/final/admin/eg_images/calendar.gif\" border=0></a></td></tr></table></td><td width=\"10\">:</td><td width=\"60\"> <input type=\"text\" id=\"startDate\" name=\"startDate\" size=\"10\"  style=\"width:100px;\" value='"+startDate+"' onfocus=\"this.blur()\"></td><td width=\"10\">&nbsp;</td><td width=\"10\">&nbsp;</td><td width=\"26\">Hrs</td><td width=\"42\"> <select id=\"startHr\" name=\"startHr\">"+ erutils.fillSelectBox1(hoursPeriod,"",startHr)+"</select></td><td width=\"75\">&nbsp;</td><td width=\"60\"><table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td align=\"right\" style=\"padding-right:4px\">To</td><td><a href='javascript:void(0);' onClick=\"checkwindow3(document.getElementById('endDate'),event,'EgMaintenanceAnalysis');\"><img src=\"/final/admin/eg_images/calendar.gif\" border=0></a></td></tr></table></td><td width=\"10\">:</td><td width=\"60\"><input type=\"text\" id=\"endDate\" name=\"endDate\" size=\"10\" readonly style=\"width:100px;\" value='"+endDate+"' onfocus=\"this.blur()\"> </td><td width=\"17\">&nbsp;</td><td width=\"36\">Hrs</td><td width=\"69\"><select name=\"endHr\" id=\"endHr\">"+erutils.fillSelectBox1(hoursPeriod,"",endHr)+"</select></td></tr></table>";
			out.println(s);
		}
		if(option!=null && option.equals("Descriptor For Component"))
		{
			if(element!=null && !element.equals("All Descriptor Comp"))
			{
				out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\" style=\"table-layout:auto\"><tr><td align=\"left\" style=\"width:80px\">Descriptor</td><td><select name=\"descElement\" id=\"descElement\" style=\"width:200px\"  onfocus=\"window.dropdown_menu_hack(this)\" >"+option+erutils.fillSelectBox1(descElements,mappedDescElements,"",descElement)+"</select></td><td width=\"56%\">&nbsp; </td></tr></table>");
			}
		}
	}
} 
catch(Throwable e) 
{
	e.printStackTrace();
}
%>