<%
/*
 *   File				:	EcSearchConfiguration.jsp
 *   Purpose			:	Search and display hotfix,filesystem,capacity,networkadapter,os,software
							and service in user-specific components
 *   Creation Date		:	11/09/2006
 *   Author				:	Krishnamurthi
 *   UI Design			:	Krishnamurthi
 *   UI Design Changes	:	Jaiwin
 */
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage = "EcProbs.jsp" %>
<%@ page import="com.eg.EgThresholdInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="egurkha.config.*" %>
<%@ page import="java.util.*" %>
<%@ page import="egurkha.*" %>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	public String decodeString(String s)
	{
		StringBuffer sb = new StringBuffer();
		int len = s.length();
		for(int i=0; i<len; i++)
		{
			char c = s.charAt(i);
			switch (c)
			{
				case '%':
					try
					{
						sb.append((char)Integer.parseInt(s.substring(i+1,i+3),16));
					}
					catch (NumberFormatException e) 
					{
						throw new IllegalArgumentException();
					}
					i += 2;
					break;
				default:
					sb.append(c);
					break;
			}
		}
		return sb.toString();
	}

	private String[] getValues(String str,String delimiter)
	{
		StringTokenizer strTokens = new StringTokenizer(str,delimiter);
		int i_count = strTokens.countTokens();
		String[] tempValues = new String[i_count];
		for (int i=0;i<tempValues.length;i++)
		{
			String s1 = strTokens.nextToken();
			tempValues[i] = s1;
		}
		return tempValues;
	}
%>

<%
	//for date
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	//end

	EcUtils ecUtils = new EcUtils();
	EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	//end user language

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter1 = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter1.getDateTime();
	/* Added by Prakash.K Ends */

	String configSkin = user.getConfigSkin();
	String[] searchFor = {"Hotfix","Harddisk","Network adapter","OS","Software"};
	String[] searchForValues = {"hf","hd","na","os","sw"};

	String s_info = request.getParameter("searchinfo");
	
	String requestFrom = (String)request.getParameter("request_from");
	if (requestFrom != null && requestFrom.equalsIgnoreCase("SystemPage"))
	{
		s_info = (String)request.getAttribute("searchinfo");
	}

	String[] tmpInfos = null;
	String[] testMeasuresNames = null;
	String[] testMeasuresValues = null;

	if (s_info != null && !s_info.equals("-1"))
	{
		tmpInfos = new String[searchForValues.length];
		for(int i=0;i<searchForValues.length;i++)
		{
			if (searchForValues[i].equalsIgnoreCase(s_info))
				tmpInfos[i] = "selected";
			else
				tmpInfos[i] = "";
		}

		if (s_info.equals("hf"))
		{
			testMeasuresValues = thresholdInfo.getMeasurementsForTest("HotFix_cf");
			if (testMeasuresValues != null && testMeasuresValues.length > 0)
			{
				testMeasuresNames = mappingInfo.getMeasureDescription("HotFix_cf",testMeasuresValues);
			}
		}
		else if (s_info.equals("sw"))
		{
			testMeasuresValues = thresholdInfo.getMeasurementsForTest("SoftwareList_cf");
			if (testMeasuresValues != null && testMeasuresValues.length > 0)
			{
				testMeasuresNames = mappingInfo.getMeasureDescription("SoftwareList_cf",testMeasuresValues);
			}
		}
		//else if (s_info.equals("sv"))
		//{
		//	testMeasuresValues = thresholdInfo.getMeasurementsForTest("ServicesInfo_cf");
		//	if (testMeasuresValues != null && testMeasuresValues.length > 0)
		//	{
		//		testMeasuresNames = mappingInfo.getMeasureDescription("ServicesInfo_cf",testMeasuresValues);
		//	}
		//}
		else if (s_info.equals("na"))
		{
			testMeasuresValues = thresholdInfo.getMeasurementsForTest("NwAdapterTest_cf");
			if (testMeasuresValues != null && testMeasuresValues.length > 0)
			{
				testMeasuresNames = mappingInfo.getMeasureDescription("NwAdapterTest_cf",testMeasuresValues);
			}
		}
	}

	String queryValues = request.getParameter("queryItems");
	String allOpts = request.getParameter("allOpts"); 
	String allOptSelection = request.getParameter("allOptSelection");
	if (allOptSelection == null || allOptSelection.equals(""))
		allOptSelection = "no";

	if (requestFrom != null && requestFrom.equalsIgnoreCase("SystemPage"))
	{
		queryValues = (String)request.getAttribute("queryItems");
		allOpts = (String)request.getAttribute("allOpts");
		allOptSelection = (String)request.getAttribute("allOptSelection");
	}

	ArrayList al_queryValues = null;
	ArrayList al_queryDisplayValues = null;
	ArrayList al_querySelectedDisplayValues = null;
	ArrayList al_selectedOptions = null;

	if (allOpts != null && !allOpts.equals("") && !allOpts.equals("-1"))
	{
		allOpts = StringUtils.replace(allOpts,"$$$","###");
		ArrayList strTokens = StringUtils.myTokenizer(allOpts,"###");
		al_queryValues = new ArrayList();
		for (int i=0;i<strTokens.size();i++)
		{
			String str_temp = decodeString((String)strTokens.get(i));
			str_temp = StringUtils.replace(str_temp,"$","#");
			al_queryValues.add(str_temp);
		}
		al_queryDisplayValues = getIntnlData(mappingInfo,al_queryValues,currentDateFormat,userDateFormat);
	}

	if (queryValues != null && !queryValues.equals("") && !queryValues.equals("-1"))
	{
		queryValues = StringUtils.replace(queryValues,"$$$","###");
		ArrayList strTokens = StringUtils.myTokenizer(queryValues,"###");
		al_selectedOptions = new ArrayList();
		for (int i=0;i<strTokens.size();i++)
		{
			String str_temp = decodeString((String)strTokens.get(i));
			str_temp = StringUtils.replace(str_temp,"$","#");
			al_selectedOptions.add(str_temp);
		}
		al_querySelectedDisplayValues = getIntnlData(mappingInfo,al_selectedOptions,currentDateFormat,userDateFormat);
	}

	ArrayList aListSearchDetails = (ArrayList)request.getAttribute("Search Configuration Details");
	Map mapUserRequestParameters = (Map)request.getAttribute("User Request Parameters");
	session.setAttribute("SEARCH_DATA",aListSearchDetails);
	session.setAttribute("INTNL_QUERIES",al_querySelectedDisplayValues);

	if (aListSearchDetails != null)
		session.setAttribute("mapUserRequestParametersFromSearch",mapUserRequestParameters);

	String userName = (String)session.getAttribute("sess_auserid");

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
%>

<html>
	<head>
		<meta name="Author" content="">
		<!-- <link rel="stylesheet" href="/final/config/styles/ec_style_green.css" /> -->
		<egui:skin ui="config"/>

		<script language="javascript" src="../config/scripts/jsrsClient.js"></script>
		<script language="javascript" src="../config/scripts/select.js"></script>
		<script language="javascript" src="../config/scripts/ec_validate.js"></script>
		<script language="JavaScript1.2" src="../config/scripts/ec_date.js"></script>
		<script language="JavaScript1.2">

		var screenname='';
		var ev='';
		var def='';
		var def_h='';
		var datefv='';
		function checkwindow1(datef,datef_h,event,sname,frmField)
		{
			event=event?event:window.event;
			document.forms[0].fromField.value = frmField;
			try
			{
				datefv = formatDate(new Date(getDateFromFormat(datef_h.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
			}
			catch(e)
			{
				datefv = formatDate(new Date(getDateFromFormat(datef_h.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
			}
			screenname=sname;
			ev=event;
			def=datef;
			def_h=datef_h;
			try
			{
				//callcalendar3(def,datefv,ev,screenname);
				setTimeout("callcalendar4(def,def_h,datefv,ev,screenname)",0);
			}
			catch(e)
			{
			}
		}

		function closeWin()
		{
			if(window.newwin !=null)
			{
				newwin.close();
			}
			if(window.datawin !=null)
			{
				datawin.close();
			}
			if(window.mailwin !=null)
			{
				mailwin.close();
			}
			if(window.statusWin!=null)
				statusWin.close();
		}

		function getInformation()
		{
			var thisForm = document.searchfrm;
			var old_sinfo = thisForm.old_s_info.value;
			var qflag = false;

			if (old_sinfo != "null")
				qflag = true;

			if (qflag)
			{
				if (thisForm.query.options[0].value != "-1")
				{
					var arr = new Array();
					var allOpts = new Array();
					var y=0;
					var selection = false;
					for(var x=0;x<thisForm.query.options.length;x++)
					{
						allOpts[x] = thisForm.query.options[x].value; 
						if(thisForm.query.options[x].selected)
						{
							arr[y++] = thisForm.query.options[x].value;
							selection = true;
						}
						if (!selection)
						{
							arr = allOpts;
							thisForm.allOptSelection.value="no";
						}
					}
					thisForm.queryItems.value = arr.join("###");
					thisForm.allOpts.value = allOpts.join("###");
				}
			}

			thisForm.action = "../config/EcSearchConfiguration.jsp";
			thisForm.submit();
		}

		function getData()
		{
			var thisForm = document.searchfrm;
			if (thisForm.searchinfo.value == "-1")
			{
				alert('<egui:intnl text="configmgmt.inventory.search.Please select an option" />');
				return;
			}

			if (thisForm.query.options[0].value == "-1")
			{
				alert('<egui:intnl text="configmgmt.inventory.search.Please furnish your selection criteria" />');
				return;
			}

			var old_sinfo = thisForm.old_s_info.value;
			var qflag = false;
			if (old_sinfo != "null")
				qflag = true;

			if (qflag)
			{
				if (thisForm.query.options[0].value != "-1")
				{
					var arr = new Array();
					var allOpts = new Array();
					var selection = false;
					var y=0;
					for(var x=0;x<thisForm.query.options.length;x++)
					{
						allOpts[x] = thisForm.query.options[x].value;
						if(thisForm.query.options[x].selected)
						{
							arr[y++] = thisForm.query.options[x].value;
							selection = true;
							thisForm.allOptSelection.value="yes";
						}
					}
					if (!selection)
					{
						arr = allOpts;
						thisForm.allOptSelection.value="no";
					}
					thisForm.queryItems.value = arr.join("###");
					thisForm.allOpts.value = allOpts.join("###");
				}
			}
			thisForm.action = "../servlet/com.eg.EcConfigurationServlet";
			thisForm.submit();
		}

		function display()
		{
			var thisForm = document.searchfrm;
			var search_info = thisForm.searchinfo.value;

			if (data_flag == "false")
				thisForm.instat.selectedIndex = 0;

			if (thisForm.elements[search_info+"opt"][0].checked)
			{
				thisForm.elements[search_info+"os"].selectedIndex = 0;
				if (data_flag == "false")
				{
					thisForm.elements[search_info+"name"].options.length = 1;
					thisForm.elements[search_info+"name"].options[0].text = '<egui:intnl text="configmgmt.inventory.search.Not Applicable" />';
					thisForm.elements[search_info+"name"].options[0].value = "-1";
				}

				if (isIE())
				{
					document.getElementById(search_info+"os").style.display = "block";
					document.getElementById(search_info+"nm").style.display = "block";
				}
				else if (isNetscape())
				{
					document.getElementById(search_info+"os").style.display = "table-row";
					document.getElementById(search_info+"nm").style.display = "table-row";
				}

				document.getElementById(search_info+"dt").style.display = "none";
				document.getElementById(search_info+"pat").style.display = "none";
			}

			if (thisForm.elements[search_info+"opt"][1].checked)
			{
				if (isIE())
				{
					document.getElementById(search_info+"dt").style.display = "block";
				}
				else if (isNetscape())
				{
					document.getElementById(search_info+"dt").style.display = "table-row";
				}
				if (data_flag == "false")
				{
					document.getElementById("FromDate").value = "";
					document.getElementById("ToDate").value = "";
				}
				document.getElementById(search_info+"os").style.display = "none";
				document.getElementById(search_info+"nm").style.display = "none";
				document.getElementById(search_info+"pat").style.display = "none";
			}

			if (thisForm.elements[search_info+"opt"][2].checked)
			{
				if (isIE())
				{
					document.getElementById(search_info+"pat").style.display = "block";
				}
				else if (isNetscape())
				{
					document.getElementById(search_info+"pat").style.display = "table-row";
				}
				if (data_flag == "false")
					thisForm.elements[search_info+"pattern"].value = "";
				document.getElementById(search_info+"dt").style.display = "none";
				document.getElementById(search_info+"os").style.display = "none";
				document.getElementById(search_info+"nm").style.display = "none";
			}

			if (data_flag == "false")
			{
				document.getElementById("dclbl").style.display = "none";
				document.getElementById("dcval").style.display = "none";
			}
		}

		function display1()
		{
			var thisForm = document.searchfrm;
			var search_info = thisForm.searchinfo.value;

			thisForm.elements[search_info+"os"].selectedIndex = 0;

			if (thisForm.elements[search_info+"opt"][1].checked)
			{
				if (data_flag == "false")
				{
					thisForm.elements[search_info+"cp"].selectedIndex = 0;
				}

				if (isIE())
				{
					document.getElementById(search_info+"cp").style.display = "block";
				}
				else if (isNetscape())
				{
					document.getElementById(search_info+"cp").style.display = "table-row";
				}

				document.getElementById(search_info+"fs").style.display = "none";
			}

			if (thisForm.elements[search_info+"opt"][0].checked)
			{
				if (data_flag == "false")
				{
					thisForm.elements[search_info+"fs"].selectedIndex = 0;
				}

				if (isIE())
				{
					document.getElementById(search_info+"fs").style.display = "block";
				}
				else if (isNetscape())
				{
					document.getElementById(search_info+"fs").style.display = "table-row";
				}

				document.getElementById(search_info+"cp").style.display = "none";
			}
		}

		function display2()
		{
			var thisForm = document.searchfrm;
			var search_info = thisForm.searchinfo.value;
			
			if (thisForm.elements[search_info+"opt"][0].checked)
			{
				if (data_flag == "false")
				{
					jsrsExecute(remoteURL,ecFillOS,"getOSNames",false);
					thisForm.elements[search_info+"ram"].options.length = 1;
					thisForm.elements[search_info+"ram"].options[0].text = '<egui:intnl text="configmgmt.inventory.search.Not Applicable" />';
					thisForm.elements[search_info+"ram"].options[0].value = "-1";
				}

				if (isIE())
				{
					document.getElementById(search_info).style.display = "block";
					document.getElementById(search_info+"ram").style.display = "block";
				}
				else if (isNetscape())
				{
					document.getElementById(search_info).style.display = "table-row";
					document.getElementById(search_info+"ram").style.display = "table-row";
				}

				document.getElementById(search_info+"nm").style.display = "none";
				document.getElementById(search_info+"dt").style.display = "none";
			}

			if (thisForm.elements[search_info+"opt"][1].checked)
			{
				if (data_flag == "false")
					thisForm.elements[search_info+"name"].selectedIndex = 0;

				jsrsExecute(remoteURL,ecFillOSName,"getOSNames",false);

				if (isIE())
				{
					document.getElementById(search_info+"nm").style.display = "block";
				}
				else if (isNetscape())
				{
					document.getElementById(search_info+"nm").style.display = "table-row";
				}

				document.getElementById(search_info+"dt").style.display = "none";
				document.getElementById(search_info).style.display = "none";
				document.getElementById(search_info+"ram").style.display = "none";
			}

			if (thisForm.elements[search_info+"opt"][2].checked)
			{
				if (isIE())
				{
					document.getElementById(search_info+"dt").style.display = "block";
				}
				else if (isNetscape())
				{
					document.getElementById(search_info+"dt").style.display = "table-row";
				}

				if (data_flag == "false")
				{
					document.getElementById("FromDate").value = "";
					document.getElementById("ToDate").value = "";
				}

				document.getElementById(search_info).style.display = "none";
				document.getElementById(search_info+"ram").style.display = "none";
				document.getElementById(search_info+"nm").style.display = "none";
			}
		}

		function display3()
		{
			var thisForm = document.searchfrm;
			var search_info = thisForm.searchinfo.value;

			if (data_flag == "false")
				thisForm.instat.selectedIndex = 0;

			if (thisForm.elements[search_info+"opt"][0].checked)
			{
				if (data_flag == "false")
				{
					thisForm.elements[search_info+"os"].selectedIndex = 0;

					if (search_info == "sv")
					{
						thisForm.elements[search_info+"name"].options.length = 1;
						thisForm.elements[search_info+"name"].options[0].text = '<egui:intnl text="configmgmt.inventory.search.Not Applicable" />';
						thisForm.elements[search_info+"name"].options[0].value = "-1";
					}
					else
					{
						thisForm.elements[search_info+"s"].options.length = 1;
						thisForm.elements[search_info+"s"].options[0].text = '<egui:intnl text="configmgmt.inventory.search.Not Applicable" />';
						thisForm.elements[search_info+"s"].options[0].value = "-1";
					}
				}

				if (isIE())
				{
					document.getElementById(search_info+"os").style.display = "block";
				}
				else if (isNetscape())
				{
					document.getElementById(search_info+"os").style.display = "table-row";
				}

				if (search_info == "sv")
				{
					if (isIE())
					{
						document.getElementById(search_info+"nm").style.display = "block";
					}
					else if (isNetscape())
					{
						document.getElementById(search_info+"nm").style.display = "table-row";
					}
				}
				else
				{
					if (isIE())
					{
						document.getElementById(search_info).style.display = "block";
					}
					else if (isNetscape())
					{
						document.getElementById(search_info).style.display = "table-row";
					}
				}

				document.getElementById(search_info+"pat").style.display = "none";
			}

			if (thisForm.elements[search_info+"opt"][1].checked)
			{
				if (isIE())
				{
					document.getElementById(search_info+"pat").style.display = "block";
				}
				else if (isNetscape())
				{
					document.getElementById(search_info+"pat").style.display = "table-row";
				}

				if (data_flag == "false")
				{
					if (search_info == "sv")
						thisForm.elements["svpattern"].value="";
					else
						thisForm.elements["napattern"].value="";
				}

				document.getElementById(search_info+"os").style.display = "none";

				if (search_info == "sv")
				{
					document.getElementById(search_info+"nm").style.display = "none";
				}
				else
				{
					document.getElementById(search_info).style.display = "none";
				}
			}

			if (data_flag == "false")
			{
				document.getElementById("dclbl").style.display = "none";
				document.getElementById("dcval").style.display = "none";
			}
		}

		function addQuery()
		{
			var thisForm = document.searchfrm;
			var count;
			var search_info = thisForm.searchinfo.value;
			var flag1 = false;
			var temp = "";
			var os = "";
			var temp1 = "";
			var temp2 = "";
			var heading = "";
			var nameHeading = "";

			var headingDisplay = "";
			var nameHeadingDisplay = "";
			var tempDisplay = "";

			if (thisForm.searchinfo.value == "-1")
			{
				alert('<egui:intnl text="configmgmt.inventory.search.Please select Search For" />');
				return;
			}

			if ((thisForm.query.options.length == "1") && (thisForm.query.options[0].value == "-1"))
				count = 0;
			else
				count = thisForm.query.options.length;

			if ((search_info == "hf") || (search_info == "sw"))
			{
				if (thisForm.elements[search_info+"opt"][1].checked)
				{
					var FromDateFlag = false;
					var ToDateFlag = false;

					var fdate = thisForm.ec_stdate.value;
					var tdate = thisForm.ec_enddate.value;
					var fdate_h = thisForm.ec_stdate_h.value;
					var tdate_h = thisForm.ec_enddate_h.value;

					if (fdate == "")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please choose From date" />');
						return false;
					}

					if (tdate == "")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please choose To date" />');
						return false;
					}

					var servertime = thisForm.currTime.value;
					var stHr="0";
					var endHr="0";
					if (fdate_h!="" && tdate_h!="")
					{
						var startDate = formatDate(new Date(getDateFromFormat(fdate_h,'<%=currentDateFormat%>')),"MM/dd/yyyy");
						var endDate = formatDate(new Date(getDateFromFormat(tdate_h,'<%=currentDateFormat%>')),"MM/dd/yyyy");

						if(!checktime(startDate,endDate,stHr,endHr))
						{
							alert('<egui:intnl text="configmgmt.inventory.search.Start date should be less than the End date" />');
							return false;
						}
					}

					var temp_instat = thisForm.instat.options[thisForm.instat.selectedIndex].value;

					if (search_info == "hf")
					{
						heading = "Hotfix:Date|";
						headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Hotfix" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Date" />' + '|';
					}
					
					if (search_info == "sw")
					{
						heading = "Software:Date|";
						headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Software" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Date" />' + '|';
					}

					temp = heading + "From=" + fdate_h + "#To=" + tdate_h + "#Installed=" + temp_instat;
					tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.common.From" />' + '=' + fdate + '#' + '<egui:intnl text="configmgmt.common.To" />' + '=' + tdate + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + temp_instat;
				}

				if (thisForm.elements[search_info+"opt"][0].checked)
				{
					os = thisForm.elements[search_info+"os"].value;
					if (os == "-1")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please select an OS" />');
						return;
					}

					temp1 = thisForm.elements[search_info+"name"].value;
					temp2 = thisForm.instat.value;

					if (temp1 == "-1")
					{
						if (search_info == "hf") 
							alert('<egui:intnl text="configmgmt.inventory.search.Please select a Hotfix name" />');
						if (search_info == "sw") 
							alert('<egui:intnl text="configmgmt.inventory.search.Please select a Software name" />');
						return;
					}

					if (search_info == "hf")
					{
						heading = "Hotfix:Name|";
						headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Hotfix" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Name" />' + '|';
						nameHeading = "Hotfix";
						nameHeadingDisplay = '<egui:intnl text="configmgmt.inventory.search.Hotfix" />';
					}
					if (search_info == "sw") 
					{
						heading = "Software:Name|";
						headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Software" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Name" />' + '|';
						nameHeading = "Software";
						nameHeadingDisplay = '<egui:intnl text="configmgmt.inventory.search.Software" />';
					}

					if (temp2 == "Yes")
					{
						var arr = new Array();
						var n = 0
						for(var x=0;x<thisForm.displaycolumns.options.length;x++)
						{
							if (thisForm.displaycolumns.options[x].selected)
							{
								arr[n] = thisForm.displaycolumns.options[x].value;
								n = n + 1;
							}
						}

						if (arr.length == 0)
						{
							alert('<egui:intnl text="configmgmt.inventory.search.Please select display columns" />');
							return;
						}

						temp = heading + "OS=" + os + "#" + nameHeading + "=" + temp1 + "#Installed=" + temp2 + "#Displaycolumns=" + arr;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.OS" />' + '=' + os + "#" + nameHeadingDisplay + "=" + temp1 + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + temp2 + '#' + '<egui:intnl text="configmgmt.inventory.search.Displaycolumns" />' + '=' + arr;
					}
					else
					{
						temp = heading + "OS=" + os + "#" + nameHeading + "=" + temp1 + "#Installed=" + temp2;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.OS" />' + '=' + os + "#" + nameHeadingDisplay + "=" + temp1 + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + temp2;
					}
				}

				if (thisForm.elements[search_info+"opt"][2].checked)
				{
					temp1 = thisForm.elements[search_info+"pattern"].value;
					temp2 = thisForm.instat.value;

					if (temp1 == "")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please provide a Pattern" />');
						thisForm.elements[search_info+"pattern"].focus();
						return;
					}
					if (!checkspecial(thisForm.elements[search_info+"pattern"],"#$%\\\"\'"))
					{
						thisForm.elements[search_info+"pattern"].focus();
						return;
					}

					if (search_info == "hf")
					{
						heading = "Hotfix:Pattern|";
						headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Hotfix" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Pattern" />' + '|';
					}
					if (search_info == "sw") 
					{
						heading = "Software:Pattern|";
						headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Software" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Pattern" />' + '|';
					}

					if (temp2 == "Yes")
					{
						var arr = new Array();
						var n = 0
						for(var x=0;x<thisForm.displaycolumns.options.length;x++)
						{
							if (thisForm.displaycolumns.options[x].selected)
							{
								arr[n] = thisForm.displaycolumns.options[x].value;
								n = n + 1;
							}
						}

						if (arr.length == 0)
						{
							alert('<egui:intnl text="configmgmt.inventory.search.Please select display columns" />');
							return;
						}

						temp = heading + "Pattern=" + temp1 + "#Installed=" + temp2 + "#Displaycolumns=" + arr;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.Pattern" />' + '=' + temp1 + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + temp2 + '#' + '<egui:intnl text="configmgmt.inventory.search.Displaycolumns" />' + '=' + arr;
					}
					else
					{
						temp = heading + "Pattern=" + temp1 + "#Installed=" + temp2;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.Pattern" />' + '=' + temp1 + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + temp2;
					}
				}
			}

			if (search_info == "hd")
			{
				os = thisForm.elements[search_info+"os"].value;
				if (os == "-1")
				{
					alert('<egui:intnl text="configmgmt.inventory.search.Please select an OS" />');
					return;
				}

				if (thisForm.elements[search_info+"opt"][0].checked)
				{
					heading = "Harddisk:FilesystemType|";
					headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Harddisk" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.FilesystemType" />' + '|';

					temp1 = thisForm.elements[search_info+"fs"].value;
					if (temp1 == "-1")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please select a filesystem type" />');
						return;
					}

					temp = heading + "OS=" + os + "#FilesystemType=" + temp1;
					tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.OS" />' + '=' + os + '#' + '<egui:intnl text="configmgmt.inventory.search.FilesystemType" />' + '=' + temp1;
				}

				if (thisForm.elements[search_info+"opt"][1].checked)
				{
					heading = "Harddisk:Capacity|";
					headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Harddisk" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Capacity" />' + '|';

					temp1 = thisForm.elements[search_info+"cp"].value;
					if (temp1 == "-1")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please select a capacity" />');
						return;
					}

					temp = heading + "OS=" + os + "#Capacity=" + temp1;
					tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.OS" />' + '=' + os + '#' + '<egui:intnl text="configmgmt.inventory.search.Capacity" />' + '=' + temp1;
				}
			}

			if (search_info == "na")
			{
				var inStatus = thisForm.instat.value;

				if (thisForm.elements[search_info+"opt"][0].checked)
				{
					os = thisForm.elements[search_info+"os"].value;
					if (os == "-1")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please select an OS" />');
						return;
					}

					if (thisForm.elements[search_info+"s"].value == "-1")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please select a network adapter" />');
						return;
					}

					temp1 = thisForm.elements[search_info+"s"].value;
					temp2 = inStatus;

					var tmpStr =  temp1;
					if (tmpStr.indexOf('@@@') > 0)
					{
						var tmpId = tmpStr.substring(tmpStr.indexOf('@@@')+3);
						if (tmpId != '-')
						{
							tmpStr = tmpStr.substring(0,tmpStr.indexOf('@@@')) + ' {'+tmpId+'}';
						}
						else
						{
							tmpStr = tmpStr.substring(0,tmpStr.indexOf('@@@'));
						}
					}
					heading = "Networkadapter:Name|";
					headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Networkadapter" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Name" />' + '|';

					if (temp2 == "Yes")
					{
						var arr = new Array();
						var n = 0
						for(var x=0;x<thisForm.displaycolumns.options.length;x++)
						{
							if (thisForm.displaycolumns.options[x].selected)
							{
								arr[n] = thisForm.displaycolumns.options[x].value;
								n = n + 1;
							}
						}
					
						if (arr.length == 0)
						{
							alert('<egui:intnl text="configmgmt.inventory.search.Please select display columns" />');
							return;
						}

						temp = heading + "OS=" + os + "#Networkadapter=" + temp1 + "#Installed=" + temp2 + "#Displaycolumns=" + arr;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.OS" />' + '=' + os + '#' + '<egui:intnl text="configmgmt.inventory.search.Networkadapter" />' + '=' + tmpStr + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + temp2 + '#' + '<egui:intnl text="configmgmt.inventory.search.Displaycolumns" />' + '=' + arr;
					}
					else
					{
						temp = heading + "OS=" + os + "#Networkadapter=" + temp1 + "#Installed=" + temp2;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.OS" />' + '=' + os + '#' + '<egui:intnl text="configmgmt.inventory.search.Networkadapter" />' + '=' + tmpStr + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />'+ '=' + temp2;
					}
				}

				if (thisForm.elements[search_info+"opt"][1].checked)
				{
					if (thisForm.elements[search_info+"pattern"].value == "")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please provide a Pattern" />');
						thisForm.napattern.focus();
						return;
					}
				
					temp1 = thisForm.elements[search_info+"pattern"].value;
					temp2 = inStatus;
					heading = "Networkadapter:Pattern|";
					headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Networkadapter" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Pattern" />' + '|';

					if (temp2 == "Yes")
					{
						var arr = new Array();
						var n = 0
						for(var x=0;x<thisForm.displaycolumns.options.length;x++)
						{
							if (thisForm.displaycolumns.options[x].selected)
							{
								arr[n] = thisForm.displaycolumns.options[x].value;
								n = n + 1;
							}
						}
					
						if (arr.length == 0)
						{
							alert('<egui:intnl text="configmgmt.inventory.search.Please select display columns" />');
							return;
						}

						temp = heading + "Pattern=" + temp1 + "#Installed=" + temp2 + "#Displaycolumns=" + arr;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.Pattern" />' + '=' + temp1 + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + temp2 + '#' + '<egui:intnl text="configmgmt.inventory.search.Displaycolumns" />' + '=' + arr;
					}
					else
					{
						temp = heading + "Pattern=" + temp1 + "#Installed=" + temp2;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.Pattern" />' + '=' + temp1 + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + temp2;
					}
				}
			}

			if (search_info == "os")
			{
				if (thisForm.elements[search_info+"opt"][2].checked)
				{
					var FromDateFlag = false;
					var ToDateFlag = false;

					var fdate = thisForm.ec_stdate.value;
					var tdate = thisForm.ec_enddate.value;
					var fdate_h = thisForm.ec_stdate_h.value;
					var tdate_h = thisForm.ec_enddate_h.value;

					if (fdate == "")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please choose From date" />');
						return false;
					}

					if (tdate == "")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please choose To date" />');
						return false;
					}

					var servertime = thisForm.currTime.value;

					if (fdate!="" && tdate!="" && fdate_h!="" && tdate_h!="" )
					{
						var startDate = formatDate(new Date(getDateFromFormat(fdate_h,'<%=currentDateFormat%>')),"MM/dd/yyyy");
						var endDate = formatDate(new Date(getDateFromFormat(tdate_h,'<%=currentDateFormat%>')),"MM/dd/yyyy");
						if(!checktime(startDate,endDate,"0","0"))
						{
							alert('<egui:intnl text="configmgmt.inventory.search.Start date should be less than the End date" />');
							return false;
						}
					}

					heading = "OS:Date|";
					headingDisplay = '<egui:intnl text="configmgmt.inventory.search.OS" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Date" />' + '|';

					temp = heading + "From=" + fdate_h + "#To=" + tdate_h;
					tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.common.From" />' + '=' + fdate + '#' + '<egui:intnl text="configmgmt.common.To" />' + '=' + tdate;
				}

				if (thisForm.elements[search_info+"opt"][1].checked)
				{
					temp1 = thisForm.elements[search_info+"name"].value;
					heading = "OS:OSname|";
					headingDisplay = '<egui:intnl text="configmgmt.inventory.search.OS" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.OSname" />' + '|';

					temp = heading + "OS=" + temp1;
					tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.OS" />' + '=' + temp1;

					if (thisForm.elements[search_info+"name"].value == "-1")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please select a os" />');
						return;
					}
				}

				if (thisForm.elements[search_info+"opt"][0].checked)
				{
					temp1 =  thisForm.elements[search_info+"ram"].value;
					os = thisForm.elements[search_info].value;
					temp2 = thisForm.elements[search_info+"operator"].value;

					heading = "OS:RAMsize|";
					headingDisplay = '<egui:intnl text="configmgmt.inventory.search.OS" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.RAMsize" />' + '|';

					temp = heading + "OS = " + os + "#RAMsize " + temp2 + " " + temp1; 
					tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.OS" />' + ' = ' + os + '#' + '<egui:intnl text="configmgmt.inventory.search.RAMsize" />' + ' ' + temp2 + ' ' + temp1; 

					if (thisForm.elements[search_info].value == "-1")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please select an OS" />');
						return;
					}

					if (thisForm.elements[search_info+"ram"].value == "-1")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please select a RAM size" />');
						return;
					}
				}
			}

			if (search_info == "sv")
			{
				var inStatus = thisForm.elements["instat"].value;

				if (thisForm.elements[search_info+"opt"][0].checked)
				{
					heading = "Service:Name|";
					headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Service" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Name" />' + '|';

					os = thisForm.elements[search_info+"os"].value;
					if ( os == "-1")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please select an OS" />');
						return;
					}

					temp1 =  thisForm.elements[search_info+"name"].value;
					if (temp1 == "-1")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please select a service name" />');
						return;
					}

					var v_temp1 = temp1;
					if (v_temp1.indexOf("#") != -1)
					{
						while (v_temp1.indexOf('#') != -1)
						{
							v_temp1 = v_temp1.replace('#','0eGHash1');
						}
					}

					if (inStatus == "Yes")
					{
						var arr = new Array();
						var n = 0
						for(var x=0;x<thisForm.displaycolumns.options.length;x++)
						{
							if (thisForm.displaycolumns.options[x].selected)
							{
								arr[n] = thisForm.displaycolumns.options[x].value;
								n = n + 1;
							}
						}

						if (arr.length == 0)
						{
							alert('<egui:intnl text="configmgmt.inventory.search.Please select display columns" />');
							return;
						}

						temp = heading + "OS=" + os + "#Service=" + v_temp1 + "#Installed=" + inStatus + "#Displaycolumns=" + arr;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.OS" />' + '=' + os + '#' + '<egui:intnl text="configmgmt.inventory.search.Service" />' + '=' + temp1 + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + inStatus + '#' + '<egui:intnl text="configmgmt.inventory.search.Displaycolumns" />' + '=' + arr;
					}
					else
					{
						temp = heading + "OS=" + os + "#Service=" + v_temp1 + "#Installed=" + inStatus;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.OS" />' + '=' + os + '#' + '<egui:intnl text="configmgmt.inventory.search.Service" />' + '=' + temp1 + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + inStatus;
					}
				}

				if (thisForm.elements[search_info+"opt"][1].checked)
				{
					if (thisForm.elements["svpattern"].value == "")
					{
						alert('<egui:intnl text="configmgmt.inventory.search.Please provide a Pattern" />');
						thisForm.svpattern.focus();
						return;
					}
				
					temp1 = thisForm.elements["svpattern"].value;
					heading = "Service:Pattern|";
					headingDisplay = '<egui:intnl text="configmgmt.inventory.search.Service" />' + ':' + '<egui:intnl text="configmgmt.inventory.search.Pattern" />' + '|';

					var v_temp1 = temp1;
					if (v_temp1.indexOf("#") != -1)
					{
						while (v_temp1.indexOf('#') != -1)
						{
							v_temp1 = v_temp1.replace('#','0eGHash1');
						}
					}

					if (inStatus == "Yes")
					{
						var arr = new Array();
						var n = 0
						for(var x=0;x<thisForm.displaycolumns.options.length;x++)
						{
							if (thisForm.displaycolumns.options[x].selected)
							{
								arr[n] = thisForm.displaycolumns.options[x].value;
								n = n + 1;
							}
						}

						if (arr.length == 0)
						{
							alert('<egui:intnl text="configmgmt.inventory.search.Please select display columns" />');
							return;
						}

						temp = heading + "Pattern=" + v_temp1 + "#Installed=" + inStatus + "#Displaycolumns=" + arr;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.Pattern" />' + '=' + temp1 + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + inStatus + '#' + '<egui:intnl text="configmgmt.inventory.search.Displaycolumns" />' + '=' + arr;
					}
					else
					{
						temp = heading + "Pattern=" + v_temp1 + "#Installed=" + inStatus;
						tempDisplay = headingDisplay + '<egui:intnl text="configmgmt.inventory.search.Pattern" />' + '=' + temp1 + '#' + '<egui:intnl text="configmgmt.inventory.search.Installed" />' + '=' + inStatus;
					}
				}
			}

			for (var y=0;y<thisForm.query.options.length;y++)
			{
				if (temp == thisForm.query.options[y].value)
				{	
					flag1 = true;
					alert('<egui:intnl text="configmgmt.inventory.search.Your current selection already exists"/>');
					break;
				}
			}

			if (!flag1)
				thisForm.query.options[count] = new Option(tempDisplay,temp);
		}

		function deleteQuery()
		{
			var thisForm = document.forms[0];
			var idx = thisForm.query.options.length;

			var n = 0;
			while (idx > 0)
			{
				if (thisForm.query.options[n].selected)
				{
					thisForm.query.remove(n);
					n = 0;
				}
				else
					n = n + 1;

				idx = thisForm.query.options.length;
				if (n == idx) break;
			}

			if (thisForm.query.options.length == "0")
			{
				var temp_name = '<egui:intnl text="configmgmt.inventory.search.Not Applicable" />';
				var temp_value = "-1";
				thisForm.query.options[0] = new Option(temp_name,temp_value);
			}

			var old_sinfo = thisForm.old_s_info.value;
			var qflag = false;
			if (old_sinfo != "null")
				qflag = true;

			if (qflag)
			{
				var arr = new Array();
				for(var x=0;x<thisForm.query.options.length;x++)
				{
					arr[x] = thisForm.query.options[x].value;
				}
				thisForm.queryItems.value = arr.join("###");
			}
		}

		function setInstallStatus()
		{
			var thisForm = document.forms[0];
			for (var x=0; x<thisForm.instat.length; x++)
			{
				var status = thisForm.instat.options[x].value;
				if (status == instat)
					thisForm.instat.options[x].selected = true;
			}
		}

		function setOSOperator()
		{
			var thisForm = document.forms[0];
			for (var x=0; x<thisForm.osoperator.length; x++)
			{
				var operator = thisForm.osoperator.options[x].value;
				if (operator == osoperator)
					thisForm.osoperator.options[x].selected = true;
			}
		}

		function populate()
		{
			var thisForm = document.forms[0];
			var searchinfo = thisForm.searchinfo.value;

<%
	if (mapUserRequestParameters != null)
	{
%>
			data_flag = "true";
<%
		String searchinfo[] = (String[])mapUserRequestParameters.get("searchinfo");
		
		if (searchForValues[0].equalsIgnoreCase(searchinfo[0])) //hf
		{
			String hfopt[] = (String[])mapUserRequestParameters.get("hfopt");
			String instat[] = (String[])mapUserRequestParameters.get("instat");
%>
			hfopt = "<%=hfopt[0]%>";
			instat = "<%=instat[0]%>";
<%
			if (hfopt[0].equalsIgnoreCase("byname"))
			{
				String hfos[] = (String[])mapUserRequestParameters.get("hfos");
				String hfname[] = (String[])mapUserRequestParameters.get("hfname");
%>
			hfos = "<%=hfos[0]%>";
			hfname = "<%=hfname[0]%>";
<%
			}

			if (hfopt[0].equalsIgnoreCase("bydate"))
			{
				String ec_stdate[] = (String[])mapUserRequestParameters.get("ec_stdate");
				String ec_enddate[] = (String[])mapUserRequestParameters.get("ec_enddate");
%>
			ec_stdate = "<%=ec_stdate[0]%>";
			ec_enddate = "<%=ec_enddate[0]%>";
<%
			}
			
			if (hfopt[0].equalsIgnoreCase("bypattern"))
			{
				String hfpattern[] = (String[])mapUserRequestParameters.get("hfpattern");
%>
			hfpattern = "<%=hfpattern[0]%>";
<%
			}

			if (instat[0].equalsIgnoreCase("Yes") && (hfopt[0].equalsIgnoreCase("byname") || hfopt[0].equalsIgnoreCase("bypattern")))
			{
				String displaycolumns[] = (String[])mapUserRequestParameters.get("displaycolumns");
				List list = Arrays.asList(displaycolumns);
				StringBuffer strBuffer = new StringBuffer();
				for (int i=0; i<list.size(); i++)
					strBuffer.append((String)list.get(i)+",");
				String dispcols = strBuffer.substring(0,strBuffer.length()-1);
%>
			displaycolumns = "<%=dispcols%>";
<%
			}
		}

		if (searchForValues[1].equalsIgnoreCase(searchinfo[0])) //hd
		{
			String hdopt[] = (String[])mapUserRequestParameters.get("hdopt");
			String hdos[] = (String[])mapUserRequestParameters.get("hdos");
%>
			hdopt = "<%=hdopt[0]%>";
			hdos = "<%=hdos[0]%>";
<%
			if (hdopt[0].equalsIgnoreCase("byfs"))
			{
				String hdfs[] = (String[])mapUserRequestParameters.get("hdfs");
%>
			hdfs = "<%=hdfs[0]%>";
<%
			}

			if (hdopt[0].equalsIgnoreCase("bycp"))
			{
				String hdcp[] = (String[])mapUserRequestParameters.get("hdcp");
%>
			hdcp = "<%=hdcp[0]%>";
<%
			}
		}

		if (searchForValues[2].equalsIgnoreCase(searchinfo[0])) //na
		{
			String naopt[] = (String[])mapUserRequestParameters.get("naopt");
			String instat[] = (String[])mapUserRequestParameters.get("instat");
%>
			naopt = "<%=naopt[0]%>";
			instat = "<%=instat[0]%>";
<%
			if (naopt[0].equalsIgnoreCase("byname"))
			{
				String naos[] = (String[])mapUserRequestParameters.get("naos");
				String nas[] = (String[])mapUserRequestParameters.get("nas");
%>
			naos = "<%=naos[0]%>";
			nas = "<%=nas[0]%>";
<%
			}

			if (naopt[0].equalsIgnoreCase("bypattern"))
			{
				String napattern[] = (String[])mapUserRequestParameters.get("napattern");
%>
			napattern = "<%=napattern[0]%>";
<%
			}

			if (instat[0].equalsIgnoreCase("Yes"))
			{
				String displaycolumns[] = (String[])mapUserRequestParameters.get("displaycolumns");
				List list = Arrays.asList(displaycolumns);
				StringBuffer strBuffer = new StringBuffer();
				for (int i=0; i<list.size(); i++)
					strBuffer.append((String)list.get(i)+",");
				String dispcols = strBuffer.substring(0,strBuffer.length()-1);
%>
			displaycolumns = "<%=dispcols%>";
<%
			}
		}

		if (searchForValues[3].equalsIgnoreCase(searchinfo[0])) //os
		{
			String osopt[] = (String[])mapUserRequestParameters.get("osopt");
%>
			osopt = "<%=osopt[0]%>";
<%
			if (osopt[0].equalsIgnoreCase("byram"))
			{
				String os[] = (String[])mapUserRequestParameters.get("os");
				String osram[] = (String[])mapUserRequestParameters.get("osram");
				String osoperator[] = (String[])mapUserRequestParameters.get("osoperator");

%>
			os = "<%=os[0]%>";
			osram = "<%=osram[0]%>";
			osoperator = "<%=osoperator[0]%>";
<%
			}

			if (osopt[0].equalsIgnoreCase("byname"))
			{
				String osname[] = (String[])mapUserRequestParameters.get("osname");
%>
			osname = "<%=osname[0]%>";
<%
			}

			if (osopt[0].equalsIgnoreCase("bydate"))
			{
				String ec_stdate[] = (String[])mapUserRequestParameters.get("ec_stdate");
				String ec_enddate[] = (String[])mapUserRequestParameters.get("ec_enddate");
%>
			ec_stdate = "<%=ec_stdate[0]%>";
			ec_enddate = "<%=ec_enddate[0]%>";
<%
			}
		}

		if (searchForValues[4].equalsIgnoreCase(searchinfo[0])) //sw
		{
			String swopt[] = (String[])mapUserRequestParameters.get("swopt");
			String instat[] = (String[])mapUserRequestParameters.get("instat");
%>
			swopt = "<%=swopt[0]%>";
			instat = "<%=instat[0]%>";
<%
			if (swopt[0].equalsIgnoreCase("byname"))
			{
				String swos[] = (String[])mapUserRequestParameters.get("swos");
				String swname[] = (String[])mapUserRequestParameters.get("swname");
%>
			swos = "<%=swos[0]%>";
			swname = "<%=swname[0]%>";
<%
			}

			if (swopt[0].equalsIgnoreCase("bydate"))
			{
				String ec_stdate[] = (String[])mapUserRequestParameters.get("ec_stdate");
				String ec_enddate[] = (String[])mapUserRequestParameters.get("ec_enddate");
%>
			ec_stdate = "<%=ec_stdate[0]%>";
			ec_enddate = "<%=ec_enddate[0]%>";
<%
			}
			
			if (swopt[0].equalsIgnoreCase("bypattern"))
			{
				String swpattern[] = (String[])mapUserRequestParameters.get("swpattern");
%>
			swpattern = "<%=swpattern[0]%>";
<%
			}

			if (instat[0].equalsIgnoreCase("Yes") && (swopt[0].equalsIgnoreCase("byname") || swopt[0].equalsIgnoreCase("bypattern")))
			{
				String displaycolumns[] = (String[])mapUserRequestParameters.get("displaycolumns");
				List list = Arrays.asList(displaycolumns);
				StringBuffer strBuffer = new StringBuffer();
				for (int i=0; i<list.size(); i++)
					strBuffer.append((String)list.get(i)+",");
				String dispcols = strBuffer.substring(0,strBuffer.length()-1);
%>
			displaycolumns = "<%=dispcols%>";
<%
			}
		}

		//if (searchForValues[5].equalsIgnoreCase(searchinfo[0])) //sv
		//{
		//	String svopt[] = (String[])mapUserRequestParameters.get("svopt");
		//	String instat[] = (String[])mapUserRequestParameters.get("instat");
%>
			//svopt = "<%//=svopt[0]%>";
			//instat = "<%//=instat[0]%>";
<%
		//	if (svopt[0].equalsIgnoreCase("byname"))
		//	{
		//		String svos[] = (String[])mapUserRequestParameters.get("svos");
		//		String svname[] = (String[])mapUserRequestParameters.get("svname");
%>
			//svos = "<%//=svos[0]%>";
			//svname = "<%//=svname[0]%>";
<%				
		//	}

		//	if (svopt[0].equalsIgnoreCase("bypattern"))
		//	{
		//		String svpattern[] = (String[])mapUserRequestParameters.get("svpattern");
%>
			//svpattern = "<%//=svpattern[0]%>";
<%
		//	}

		//	if (instat[0].equalsIgnoreCase("Yes"))
		//	{
		//		String displaycolumns[] = (String[])mapUserRequestParameters.get("displaycolumns");
		//		List list = Arrays.asList(displaycolumns);
		//		StringBuffer strBuffer = new StringBuffer();
		//		for (int i=0; i<list.size(); i++)
		//			strBuffer.append((String)list.get(i)+",");
		//		String dispcols = strBuffer.substring(0,strBuffer.length()-1);
%>
			//displaycolumns = "<%//=dispcols%>";
<%
		//	}
		//}
	}
%>

			if (searchinfo == "hf")
			{
				jsrsExecute(remoteURL,ecFillHFOS,"getOSNames",false);

				if (data_flag == "true")
				{
					if (hfopt == "byname")
					{
						thisForm.elements[searchinfo+"opt"][0].checked = true;
						setInstallStatus();
						if (instat == "Yes")
							showDisplayColumns();
					}

					if (hfopt == "bydate")
					{
						thisForm.elements[searchinfo+"opt"][1].checked = true;
						thisForm.ec_stdate.value = ec_stdate;
						thisForm.ec_enddate.value = ec_enddate;
						setInstallStatus();
					}

					if (hfopt == "bypattern")
					{
						thisForm.elements[searchinfo+"opt"][2].checked = true;
						thisForm.hfpattern.value = hfpattern;
						setInstallStatus();
						if (instat == "Yes")
							showDisplayColumns();
					}

					display();
				}
			}

			if (searchinfo == "hd")
			{
				jsrsExecute(remoteURL,ecFillHDOS,"getOSNames",false);

				if (data_flag == "true")
				{
					if (hdopt == "byfs")
						thisForm.elements[searchinfo+"opt"][0].checked = true;
					
					if (hdopt == "bycp")
						thisForm.elements[searchinfo+"opt"][1].checked = true;
				}

				display1();
			}

			if (searchinfo == "na")
			{
				jsrsExecute(remoteURL,ecFillNAOS,"getOSNames",false);

				if (data_flag == "true")
				{
					if (naopt == "byname")
						thisForm.elements[searchinfo+"opt"][0].checked = true;

					if (naopt == "bypattern")
					{
						thisForm.elements[searchinfo+"opt"][1].checked = true;
						thisForm.napattern.value = napattern;
					}

					setInstallStatus();
					if (instat == "Yes")
						showDisplayColumns();

					display3();
				}
			}

			if (searchinfo == "os")
			{
				jsrsExecute(remoteURL,ecFillOS,"getOSNames",false);

				if (data_flag == "true")
				{
					if (osopt == "byram")
					{
						thisForm.elements[searchinfo+"opt"][0].checked = true;
						setOSOperator();
					}

					if (osopt == "byname")
					{
						thisForm.elements[searchinfo+"opt"][1].checked = true;
					}

					if (osopt == "bydate")
					{
						thisForm.elements[searchinfo+"opt"][2].checked = true;
						thisForm.ec_stdate.value = ec_stdate;
						thisForm.ec_enddate.value = ec_enddate;
					}

					display2();
				}
			}

			if (searchinfo == "sw")
			{
				jsrsExecute(remoteURL,ecFillSWOS,"getOSNames",false);

				if (data_flag == "true")
				{
					if (swopt == "byname")
					{
						thisForm.elements[searchinfo+"opt"][0].checked = true;
						setInstallStatus();
						if (instat == "Yes")
							showDisplayColumns();
					}

					if (swopt == "bydate")
					{
						thisForm.elements[searchinfo+"opt"][1].checked = true;
						thisForm.ec_stdate.value = ec_stdate;
						thisForm.ec_enddate.value = ec_enddate;
						setInstallStatus();
					}

					if (swopt == "bypattern")
					{
						thisForm.elements[searchinfo+"opt"][2].checked = true;
						thisForm.swpattern.value = swpattern;
						setInstallStatus();
						if (instat == "Yes")
							showDisplayColumns();
					}

					display();
				}
			}

			if (searchinfo == "sv")
			{
				jsrsExecute(remoteURL,ecFillSVOS,"getOSNames",false);

				if (data_flag == "true")
				{
					if (svopt == "byname")
						thisForm.elements[searchinfo+"opt"][0].checked = true;

					if (svopt == "bypattern")
					{
						thisForm.elements[searchinfo+"opt"][1].checked = true;
						thisForm.svpattern.value = svpattern;
					}
					
					setInstallStatus();
					if (instat == "Yes")
						showDisplayColumns();
					
					display3();
				}
			}

			data_flag = "false";
		}

		function showDisplayColumns()
		{
			var thisForm = document.forms[0];

			var searchinfo = thisForm.searchinfo.value;
			var len = thisForm.elements[searchinfo+"opt"].length;
			var opt;
			for (var i=0; i<len; i++)
			{
				if (thisForm.elements[searchinfo+"opt"][i].checked)
					opt = thisForm.elements[searchinfo+"opt"][i].value;
			}

			var installed;
			if (data_flag == "false")
				installed = thisForm.instat.value;
			else
				installed = instat;

			if (installed == "Yes" && opt != "bydate")
			{
				document.getElementById("dclbl").style.display = "block";
				document.getElementById("dcval").style.display = "block";

				if (data_flag == "false")
				{
					var dispColLength = thisForm.displaycolumns.options.length;
					if (dispColLength == "0")
					{
						var notApp = '<egui:intnl text="configmgmt.inventory.search.Not Applicable"/>';
						thisForm.displaycolumns.options[0] = new Option(notApp,"-1")
					}
					else
					{
						for(var x=0;x<thisForm.displaycolumns.options.length;x++)
						{
							thisForm.displaycolumns.options[x].selected = true;
						}
					}
				}
				else
				{
					var dcols = displaycolumns.split(",");
					for (var x=0; x<dcols.length; x++)
					{
						for (var y=0; y<thisForm.displaycolumns.options.length; y++)
						{
							if (thisForm.displaycolumns.options[y].value == dcols[x])
								thisForm.displaycolumns.options[y].selected = true;
						}
					}
				}
			}
			else
			{
				document.getElementById("dclbl").style.display = "none";
				document.getElementById("dcval").style.display = "none";
			}
		}

		function printData()
		{
<%
			if (aListSearchDetails == null || aListSearchDetails.size()==0)
			{
%>
				alert('<egui:intnl text="configmgmt.common.No data available" />');
				return;
<%
			}

			StringBuffer printQS = new StringBuffer();
			printQS.append("ec_type=Search");
			printQS.append("&ec_trgttype=Configuration_Report");
			printQS.append("&printData=yes");
			printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
			printQS.append("&user_language="+userLanguage);
%>

			var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
			print(s_qryString);
		}

		function savePdf()
		{
<%
			if (aListSearchDetails == null || aListSearchDetails.size()==0)
			{
%>
				alert('<egui:intnl text="configmgmt.common.No data available" />');
				return;
<%
			}
			session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
			session.setAttribute("REPORT_NAME","InventorySearchReport");
			session.setAttribute("REPORT_LAYOUT","Portrait");
			session.setAttribute("PAGE_WIDTH_PDF","1100");
			session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
			session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
			getPdf('<%=configSkin%>');
		}

		function mail()
		{
<%
			if (aListSearchDetails == null || aListSearchDetails.size()==0)
			{
%>
				alert('<egui:intnl text="configmgmt.common.No data available" />');
				return;
<%
			}
%>
			sendMail();
		}

		function isNetscape()
		{
			// get browser info.
			appName= navigator.appName;
			appLongVer = navigator.appVersion;
			appVer = appLongVer.substring(0, 1);

			// check for Navigator ver 4+. 
			if ((appName == "Netscape") && (appVer >= 4)) return true;
			return false;
		}

		function isIE()
		{
			// get browser info.
			appName= navigator.appName;
			//alert(appName);
			appLongVer = navigator.appVersion;
			appVer = appLongVer.substring(0, 1);

			// check for IE ver 4+. 
			if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
			return false;
		}

		function csv()
		{
	<%
			if (aListSearchDetails == null || aListSearchDetails.size()==0)
			{
	%>
				alert('<egui:intnl text="configmgmt.common.No data available" />');
				return;
	<%
			}
	%>
			thisForm = document.forms[0];
			thisForm.action = "../servlet/com.eg.EcCSVController";
			thisForm.submit();
		}
		</script>
	</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" onUnLoad="closeWin()" onLoad="populate()" id="bgmedium">

	<form name="searchfrm" method="post" style="margin:0px">

		<input type="hidden" name="ec_rtype" value="Search">
		<input type="hidden" name="ec_trgttype" value="Configuration Report">
		<input type="hidden" name="old_s_info" value="<%=s_info%>">
		<input type="hidden" name="queryItems" value="<%=(queryValues==null)?"":decodeString(queryValues)%>">
		<input type="hidden" name="allOpts" value="<%=(allOpts == null)?"":decodeString(allOpts)%>">
		<input type="hidden" name="allOptSelection" value="<%=allOptSelection%>"> 
		<input type="hidden" name="fromField" id="fromField" value="from">

<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="99%">
	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="97%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.inventory.search.SEARCH INVENTORY"/></b>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<tr>
					<td id="padding6" >
						<table align="center" cellspacing="0" cellpadding="0" width="100%" style="height:200px" border="0" id="toptable">
							<tr>
								<td >
								<div name="div1" id="div_scroll" style="width:100%;height:200px;border:0px solid #CBD8CC;overflow: scroll; overflow: -moz-scrollbars-vertical; overflow-x: hidden;">
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" >
										<tr>
											<td align="center" colspan="4" width="100%" valign="top">
										</tr>
										<tr>
											<td width="15%" align="right" style="padding:2px"><b><egui:intnl text="configmgmt.inventory.search.Search for"/>&nbsp;:&nbsp;</b></td>
											<td width="15%" align="left" style="padding:2px">
											<select name="searchinfo" onChange="javasrcipt:getInformation();">
<%
	if (s_info!=null && !s_info.equals("-1"))
	{
		for (int i=0;i<searchFor.length;i++)
		{
%>
			<option value="<%=searchForValues[i]%>" <%=tmpInfos[i]%>>
				<egui:intnl text='<%="configmgmt.inventory.search."+searchFor[i]%>'/>
			</option>
<%
		}
	}
	else
	{
%>
			<option value="-1"><egui:intnl text="configmgmt.inventory.search.Please select"/></option>
<%
		for (int i=0;i<searchFor.length;i++)
		{
%>
			<option value="<%=searchForValues[i]%>">
				<egui:intnl text='<%="configmgmt.inventory.search."+searchFor[i]%>'/>
			</option>
<%
		}
	}
%>
											</select>
											</td>
<%
	if (s_info!=null)
	{
		if (s_info.equalsIgnoreCase(searchForValues[0])) //hf
		{
%>
											<td align="right" width="10%" style="padding:2px">
											<b><egui:intnl text="configmgmt.inventory.search.Search by"/>&nbsp;:&nbsp;</b>
											</td>
											<td style="padding:2px" width="60%">
												<table border="0" cellpadding="0" cellspacing="0"> 
													<tr>
														<td><input style="border:0px;background-color:transparent" type="radio" name="hfopt" value="byname" onClick="javascript:display();" checked></td>
														<td><egui:intnl text="configmgmt.inventory.search.Name"/></td>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="hfopt" value="bydate" onClick="javascript:display();"></td>
														<td><egui:intnl text="configmgmt.inventory.search.Date"/></td>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="hfopt" value="bypattern" onClick="javascript:display();"></td>
														<td><egui:intnl text="configmgmt.inventory.search.Pattern"/></td>
													</tr>
												</table>
											</td>
										</tr>

										<tr id="hfos">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.OS"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="hfos">
												<option value="-1"><egui:intnl text="configmgmt.inventory.search.Please select an OS"/></option>
												</select>
											</td>
										</tr>

										<tr id="hfnm">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text='<%="configmgmt.inventory.search."+searchFor[0]%>'/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="hfname">
													<option value="-1"><egui:intnl text="configmgmt.inventory.search.Not Applicable"/></option>
												</select>
											</td>
										</tr>

										<tr id="hfdt" style="display:none">
											<td width="15%" align="right"  style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Date"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<%@ include file="EcTimeLineLite.jsp"%>
											</td>
										</tr>

										<tr id="hfpat" style="display:none">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Pattern"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<input type="text" name="hfpattern" value="">
											</td>
										</tr>

										<tr>
											<td width="15%" align="right" valign="top" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Installed"/>&nbsp;:&nbsp;</b>
											</td>
											<td valign="top" width="15%" style="padding:2px">
												<select name="instat" onChange="javascript:showDisplayColumns()">
													<option value="All"><egui:intnl text="configmgmt.inventory.search.All"/></option>
													<option value="Yes"><egui:intnl text="configmgmt.inventory.search.Yes (Installed)"/></option>
													<option value="No"><egui:intnl text="configmgmt.inventory.search.No (Uninstalled)"/></option>
												</select>
											</td>
											<td width="15%" align="right" valign="top" style="padding:2px">
												<div id="dclbl" style="display:none">
													<b><egui:intnl text="configmgmt.inventory.search.Display columns"/>&nbsp;:&nbsp;</b>
												</div>
											</td>
											<td valign="top" style="padding:2px">
												<div id="dcval" style="display:none">
													<select name="displaycolumns" size="5" multiple style="width: 250px;">
<%
			if (testMeasuresValues != null && testMeasuresValues.length > 0)
			{
				for (int i=0;i<testMeasuresValues.length;i++)
				{
%>
					<option value="<%=testMeasuresValues[i]%>">
					<%=testMeasuresNames[i]%>
					</option>
<%
				}
			}
%>
													</select>
												</div>
											</td>
										</tr>
<%
		}

		if (s_info.equalsIgnoreCase(searchForValues[1])) //hd
		{
%>
											<td align="right" width="10%"  style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Search by"/>&nbsp;:&nbsp;</b>
											</td>
											<td  style="padding:2px">
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="hdopt" value="byfs" onClick="javascript:display1();" checked> </td> 
														<td> <egui:intnl text="configmgmt.inventory.search.Filesystem Type"/> </td>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="hdopt" value="bycp" onClick="javascript:display1();"> </td> 
														<td> <egui:intnl text="configmgmt.inventory.search.Capacity"/> </td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td width="15%" align="right" style="padding:2px">
											<b><egui:intnl text="configmgmt.inventory.search.OS"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="hdos">
													<option value="-1"><egui:intnl text="configmgmt.inventory.search.Please select an OS"/></option>
												</select>
											</td>
										</tr>

										<tr id="hdfs">
											<td width="15%" align="right" style="padding:2px">
											<b><egui:intnl text="configmgmt.inventory.search.Filesystem Type"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="hdfs">
													<option value="-1"><egui:intnl text="configmgmt.inventory.search.Not Applicable"/></option>
												</select>
											</td>
										</tr>

										<tr id="hdcp" style="display:none">
											<td width="15%" align="right" style="padding:2px">
											<b><egui:intnl text="configmgmt.inventory.search.Capacity"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="hdcp">
													<option value="-1"><egui:intnl text="configmgmt.inventory.search.Not Applicable"/></option>
												</select>
											</td>
										</tr>
<%
		}

		if (s_info.equalsIgnoreCase(searchForValues[2])) //na
		{
%>
											<td align="right" width="10%" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Search by"/>&nbsp;:&nbsp;</b>
											</td>
											<td style="padding:2px">
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="naopt" value="byname" onClick="javascript:display3();" checked></td>
														<td> <egui:intnl text="configmgmt.inventory.search.Name"/></td>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="naopt" value="bypattern" onClick="javascript:display3();"> </td>
														<td> <egui:intnl text="configmgmt.inventory.search.Pattern"/></td>
													</tr>
												</table>
											</td>
										</tr>

										<tr id="naos">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.OS"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="naos">
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.search.Please select an OS"/>
													</option>
												</select>
											</td>
										</tr>

										<tr id="na">
											<td width="15%" align="right" style="padding:2px">
											<b><egui:intnl text='<%="configmgmt.inventory.search."+searchFor[2]%>'/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="nas">
													<option value="-1"><egui:intnl text="configmgmt.inventory.search.Not Applicable"/></option>
												</select>
											</td>
										</tr>

										<tr id="napat" style="display:none">
											<td width="15%" align="right" style="padding:2px">
											<b><egui:intnl text="configmgmt.inventory.search.Pattern"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<input type="text" name="napattern" value="">
											</td>
										</tr>

										<tr>
											<td width="15%" align="right" valign="top" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Installed"/>&nbsp;:&nbsp;</b>
											</td>
											<td valign="top" width="15%" style="padding:2px">
												<select name="instat" onChange="javascript:showDisplayColumns();">
													<option value="All"><egui:intnl text="configmgmt.inventory.search.All"/></option>
													<option value="Yes"><egui:intnl text="configmgmt.inventory.search.Yes (Installed)"/></option>
													<option value="No"><egui:intnl text="configmgmt.inventory.search.No (Uninstalled)"/></option>
												</select>
											</td>
											<td width="15%" align="right" valign="top" style="padding:2px">
												<div id="dclbl" style="display:none">
													<b><egui:intnl text="configmgmt.inventory.search.Display columns"/>&nbsp;:&nbsp;</b>
												</div>
											</td>
											<td valign="top" style="padding:2px">
												<div id="dcval" style="display:none">
													<select name="displaycolumns" size="5" multiple style="width: 250px;">
<%
			if (testMeasuresValues != null && testMeasuresValues.length > 0)
			{
				for (int i=0;i<testMeasuresValues.length;i++)
				{
%>
					<option value="<%=testMeasuresValues[i]%>">
					<%=testMeasuresNames[i]%>
					</option>
<%
				}
			}
%>
													</select>
												</div>
											</td>
										</tr>

<%
		}

		if (s_info.equalsIgnoreCase(searchForValues[3])) //os
		{
%>
											<td align="right" width="10%"  style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Search by"/>&nbsp;:&nbsp;</b>
											</td>
											<td style="padding:2px">
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="osopt" value="byram" onClick="javascript:display2();" checked> </td>
														<td><egui:intnl text="configmgmt.inventory.search.RAM size"/></td>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="osopt" value="byname" onClick="javascript:display2();"> </td>
														<td><egui:intnl text="configmgmt.inventory.search.OS name"/></td>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="osopt" value="bydate" onClick="javascript:display2();"> </td>
														<td><egui:intnl text="configmgmt.inventory.search.Date"/></td>
													</tr>
												</table>
											</td>
										</tr>

										<tr id="os">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.OS"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="os">
													<option value="-1"><egui:intnl text="configmgmt.inventory.search.Please select an OS"/></option>
												</select>
											</td>
										</tr>

										<tr id="osram">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.RAM size"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="osoperator">
													<option value="=" selected><egui:intnl text="configmgmt.inventory.search.Equals"/></option>
													<option value="<"><egui:intnl text="configmgmt.inventory.search.Less Than"/></option>
													<option value="<="><egui:intnl text="configmgmt.inventory.search.Less Than or Equal To"/></option>
													<option value=">"><egui:intnl text="configmgmt.inventory.search.Greater Than"/></option>
													<option value=">="><egui:intnl text="configmgmt.inventory.search.Greater Than or Equal To"/></option>
												</select>
												<select name="osram">
													<option value="-1"><egui:intnl text="configmgmt.inventory.search.Not Applicable"/></option>
												</select>
											</td>
										</tr>

										<tr id="osnm" style="display:none">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.OS"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="osname">
												</select>
											</td>
										</tr>

										<tr id="osdt" style="display:none">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Date"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<%@ include file="EcTimeLineLite.jsp"%>
											</td>
										</tr>
<%
		}

		if (s_info.equalsIgnoreCase(searchForValues[4])) //sw
		{
%>
											<td align="right" width="10%"  style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Search by"/>&nbsp;:&nbsp;</b>
											</td>
											<td style="padding:2px">
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="swopt" value="byname" onClick="javascript:display();" checked> </td>
														<td><egui:intnl text="configmgmt.inventory.search.Name"/></td>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="swopt" value="bydate" onClick="javascript:display();"> </td>
														<td><egui:intnl text="configmgmt.inventory.search.Date"/></td>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="swopt" value="bypattern" onClick="javascript:display();"> </td>
														<td><egui:intnl text="configmgmt.inventory.search.Pattern"/></td>
													</tr>
												</table>
											</td>
										</tr>

										<tr id="swos">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.OS"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3"  style="padding:2px">
												<select name="swos">
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.search.Please select an OS"/>
													</option>
												</select>
											</td>
										</tr>

										<tr id="swnm">
											<td width="15%" align="right" style="padding:2px">
											<b><egui:intnl text='<%="configmgmt.inventory.search."+searchFor[4]%>'/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="swname">
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.search.Not Applicable"/>
													</option>
												</select>
											</td>
										</tr>

										<tr id="swdt" style="display:none">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Date"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<%@ include file="EcTimeLineLite.jsp"%>
											</td>
										</tr>

										<tr id="swpat" style="display:none">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Pattern"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<input type="text" name="swpattern" value="">
											</td>
										</tr>

										<tr>
											<td width="15%" align="right" valign="top" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Installed"/>&nbsp;:&nbsp;</b>
											</td>
											<td valign="top" width="15%"  style="padding:2px">
												<select name="instat" onChange="javascript:showDisplayColumns()">
													<option value="All"><egui:intnl text="configmgmt.inventory.search.All"/></option>
													<option value="Yes"><egui:intnl text="configmgmt.inventory.search.Yes (Installed)"/></option>
													<option value="No"><egui:intnl text="configmgmt.inventory.search.No (Uninstalled)"/></option>
												</select>
											</td>
											<td width="15%" align="right" valign="top" style="padding:2px">
												<div id="dclbl" style="display:none">
													<b><egui:intnl text="configmgmt.inventory.search.Display columns"/>&nbsp;:&nbsp;</b>
												</div>
											</td>
											<td valign="top" style="padding:2px">
												<div id="dcval" style="display:none">
													<select name="displaycolumns" size="5" multiple style="width: 250px;">
<%
			if (testMeasuresValues != null && testMeasuresValues.length > 0)
			{
				for (int i=0;i<testMeasuresValues.length;i++)
				{
%>
					<option value="<%=testMeasuresValues[i]%>">
					<%=testMeasuresNames[i]%>
					</option>
<%
				}
			}
%>
													</select>
												</div>
											</td>
										</tr>

<%
		}

		//if (s_info.equalsIgnoreCase(searchForValues[5])) //sv
		//{
%>
											<!-- <td align="right" width="10%"  style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Search by"/>&nbsp;:&nbsp;</b>
											</td>
											<td style="padding:2px">
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="svopt" value="byname" onClick="javascript:display3();" checked> </td>
														<td><egui:intnl text="configmgmt.inventory.search.Name"/></td>
														<td> <input style="border:0px;background-color:transparent" type="radio" name="svopt" value="bypattern" onClick="javascript:display3();"> </td>
														<td><egui:intnl text="configmgmt.inventory.search.Pattern"/></td>
													</tr>
												</table>
											</td>
										</tr>

										<tr id="svos">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.OS"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="svos">
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.search.Please select an OS"/>
													</option>
												</select>
											</td>
										</tr>

										<tr id="svnm">
											<td width="15%" align="right" style="padding:2px">
											<b><egui:intnl text='<%//="configmgmt.inventory.search."+searchFor[5]%>'/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<select name="svname">
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.search.Not Applicable"/>
													</option>
												</select>
											</td>
										</tr>

										<tr id="svpat" style="display:none">
											<td width="15%" align="right" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Pattern"/>&nbsp;:&nbsp;</b>
											</td>
											<td colspan="3" style="padding:2px">
												<input type="text" name="svpattern" value="">
											</td>
										</tr>

										<tr>
											<td width="15%" align="right" valign="top" style="padding:2px">
												<b><egui:intnl text="configmgmt.inventory.search.Installed"/>&nbsp;:&nbsp;</b>
											</td>
											<td valign="top" width="15%" style="padding:2px">
												<select name="instat" onChange="javascript:showDisplayColumns()">
													<option value="All"><egui:intnl text="configmgmt.inventory.search.All"/></option>
													<option value="Yes"><egui:intnl text="configmgmt.inventory.search.Yes (Installed)"/></option>
													<option value="No"><egui:intnl text="configmgmt.inventory.search.No (Uninstalled)"/></option>
												</select>
											</td>
											<td width="15%" align="right" valign="top" style="padding:2px">
												<div id="dclbl" style="display:none">
													<b><egui:intnl text="configmgmt.inventory.search.Display columns"/>&nbsp;:&nbsp;</b>
												</div>
											</td>
											<td valign="top"  style="padding:2px">
												<div id="dcval" style="display:none">
													<select name="displaycolumns" size="5" multiple style="width: 250px;"> -->
<%
			//if (testMeasuresValues != null && testMeasuresValues.length > 0)
			//{
			//	for (int i=0;i<testMeasuresValues.length;i++)
			//	{
%>
					<!-- <option value="<%//=testMeasuresValues[i]%>">
					<%//=testMeasuresNames[i]%>
					</option> -->
<%
			//	}
			//}
%>
													<!-- </select>
												</div>
											</td>
										</tr> -->
<%
		//}
	}
	else
	{
%>
											<td colspan="2">&nbsp;&nbsp;</td>
										</tr>
<%
	}
%>
										<tr>
											<td align="center" colspan="3" style="padding:2px" class="linebottom">
												<input type="button" value='<egui:intnl text="configmgmt.common.ADD"/>' id="darkbutton" style="width: 70px; height: 20px;" onClick="javascript:addQuery();">&nbsp;&nbsp;
												<input type="button" value='<egui:intnl text="configmgmt.common.DELETE"/>' id="darkbutton" style="width: 70px; height: 20px;" onClick="javascript:deleteQuery();">&nbsp;&nbsp;
												<input type="button" value='<egui:intnl text="configmgmt.common.SEARCH"/>' id="darkbutton" style="width: 70px; height: 20px;" onClick="javascript:getData();">
											</td>
											<td align="right" style="height:24" class="linebottom" valign="bottom" style="padding-bottom:0px">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve"><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" > </td>

														<td width="19" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13"> </td>

														<td width="19" align="center" id="leftcurvebg"><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13"> </td>

														<td width="19" align="center" id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13"> </td>

														<td width="19" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td colspan="4"  valign="top" style="padding:6px;" class="bgdarkmedium">
												<select name="query" style="width:100%;" size="11" multiple >
<%
	if(al_queryValues != null)
	{
		for(int i=0;i<al_queryValues.size();i++)
		{
			String displayValue = (String)al_queryDisplayValues.get(i);
			String selected = "";
			if (allOptSelection.equalsIgnoreCase("yes") && al_selectedOptions.contains((String)al_queryValues.get(i)))
				selected = "selected";
			int index = displayValue.indexOf("@@@");
			if (index > 0)
			{
				String tmpId = displayValue.substring(index+3);
				String tmpRest = tmpId.substring(tmpId.indexOf("#")); 
				displayValue = displayValue.substring(0,index);
				tmpId = tmpId.substring(0,tmpId.indexOf("#"));

				if (!tmpId.equals("-"))
				{
					displayValue += " {"+tmpId+"}"+ tmpRest;
				}
				else
				{
					displayValue += tmpRest;
				}
			}
%>
			<OPTION VALUE="<%=(String)al_queryValues.get(i)%>" style="border:0px" <%=selected%>>
			<%=displayValue%>
			</OPTION>
<%
		}
	}
	else
	{
%>
		<OPTION VALUE="-1"><egui:intnl text="configmgmt.inventory.search.Not Applicable"/></OPTION>
<%
	}
%>
												</select>
											</td>
										</tr>
									</table>
								</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" valign="top" style="padding-top:0px;padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
							<tr>
								<td valign="top">
								<!-- <div name="div2" id="div_scroll" style="width:100%;height:340px"> -->
<%
	if (aListSearchDetails != null)
	{
%>
									<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%"  class="body_text">
										<tr>
											<td align="center" id="whitefont" class="tdbackcolortop">
												<b><egui:intnl text="configmgmt.inventory.search.Search Results"/></b>
											</td>
										</tr>
									</table>

									<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" class="body_text">
										<tr>
											<td colspan="4" height="6"><img src="/final/config/images/spacer.gif" border="0" height="0"></td>
										</tr>
									</table>
<%
		//For New Pdf Framework - Krishnamurthi
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
	
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.SEARCH CONFIGURATION REPORT") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		reportAttributes.setMainTitle(pdfTitle);

		reportAttributes.setSubTitle(mappingInfo.getTextDescription("configmgmt.inventory.search.Search Results"));
		reportAttributes.setReportName("SearchConfiguration");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);
		pdfData.setAttributes(reportAttributes);

		for (int i=0; i<aListSearchDetails.size(); i++)
		{
			ArrayList aList = (ArrayList)aListSearchDetails.get(i);

			//String aListQuery = (String)aList.get(0);
			String aListQuery = (String)al_querySelectedDisplayValues.get(i);
			ArrayList aListColumnHeading = (ArrayList)aList.get(1);
			ArrayList aListData = (ArrayList)aList.get(2);

			int count = aListColumnHeading.size();

			String[] userOption = getValues(aListQuery,"|");
			String[] searchOption1 = getValues(userOption[0],":");

			ArrayList aListParameters = getParameters(userOption[1],"#");

			StringBuffer strBuffer = new StringBuffer();
			for (int y=0; y<aListParameters.size(); y++)
			{
				String tmpStr = (String)aListParameters.get(y);
				if (tmpStr.startsWith("Networkadapter=") && tmpStr.indexOf("@@@")  > 0)
				{
						String strId = tmpStr.substring(tmpStr.indexOf("@@@")+3);
						tmpStr = tmpStr.substring(0,tmpStr.indexOf("@@@"));
						if (!strId.equals("-"))
						{
							tmpStr += " {"+strId+"}";
						}
				}
				strBuffer.append(tmpStr+", ");
			}
			String searchCondition = strBuffer.substring(0,strBuffer.length()-2);

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.inventory.search.Search for")+"="+searchOption1[0]+", "+mappingInfo.getTextDescription("configmgmt.inventory.search.Search by")+"="+searchOption1[1]+", "+searchCondition);

			ArrayList aListColumnNames = new ArrayList();
			ArrayList aListData1 = new ArrayList();
			ArrayList userColumnNames = new ArrayList();
%>
									<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" id="bottomtable">
										<tr>
											<td align="left" class="table_header" id="white_content" height="20" colspan="<%=count%>">
											<egui:intnl text="configmgmt.inventory.search.Search for"/>=<%=searchOption1[0]%>, <egui:intnl text="configmgmt.inventory.search.Search by"/>=<%=searchOption1[1]%>, <%=searchCondition%>
											</td>
										</tr>
<%
			if (count == 0)
			{
				aListColumnNames.add("C0");
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.search.Search for")+"="+searchOption1[0]+", "+mappingInfo.getTextDescription("configmgmt.inventory.search.Search by")+"="+searchOption1[1]+", "+searchCondition);
				aListData1.add("                                             "+mappingInfo.getTextDescription("configmgmt.inventory.search.No result found for the current selection"));

				egTableAttributes.setTitle(" ");
%>
										<tr>
											<td align="center" id="cell_bg4">
												<b><egui:intnl text="configmgmt.inventory.search.No result found for the current selection"/></b>
											</td>
										</tr>
<%
			}
			else
			{
%>
										<tr>
<%
				for (int j=1; j<aListColumnHeading.size(); j++)
				{
					aListColumnNames.add("C"+j);
					userColumnNames.add((String)aListColumnHeading.get(j));
%>
											<td align="left" id="cell_bg4">
												<b><%=(String)aListColumnHeading.get(j)%></b>
											</td>
<%
				}
%>
										</tr>
<%
				boolean displayFlag = false;
				boolean columnFlag = false;
				String oldInfo = "";

				for (int x=0; x<aListData.size(); x++)
				{
					ArrayList aListTemp = (ArrayList)aListData.get(x);
	
					String info = (String)aListTemp.get(0);
					String system = (String)aListTemp.get(1);
					String ip = (String)aListTemp.get(2);

					ArrayList aListValues = (ArrayList)aListTemp.get(3);

					if (!info.equals("+"))
					{
						String strColHead = (String)aListColumnHeading.get(0);
						String strInfo = info;
						if (strColHead.equalsIgnoreCase("Network Adapter"))
						{
							if (strInfo.indexOf("@@@") > 0)
							{
								String tmpId = strInfo.substring(strInfo.indexOf("@@@")+3);
								strInfo = strInfo.substring(0,strInfo.indexOf("@@@"));
								
								if (!tmpId.equals("-"))
								{
									strInfo += " {"+tmpId+"}";
								}
							}
						}
						aListData1.add((String)aListColumnHeading.get(0)+": "+strInfo);

						if (!oldInfo.equalsIgnoreCase(info) && !oldInfo.equalsIgnoreCase(""))
							displayFlag = false;

						if (!displayFlag)
						{
							if (!columnFlag)
							{
								aListColumnNames.add(0,"C0");
								userColumnNames.add(0,mappingInfo.getTextDescription("configmgmt.inventory.search.Descriptor"));
								egTableAttributes.setDataGrouping(true);
								egTableAttributes.setDataGroupingField(0);
								columnFlag = true;
							}
							
%>
										<tr>
											<td align="left" id="cell_bg3" colspan="<%=count+1%>">
												<b><%=(String)aListColumnHeading.get(0)%></b>: <%=strInfo%>
											</td>
										</tr>
<%
							displayFlag = true;
						}

						oldInfo = info;
					}
%>
										<tr>
											<td align="left" id="cell_bg2" valign="top" wrap>
												<a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=BoxView&systemName=<%=EgURLEncoder.encode(system,"UTF-8")%>&request_from=SearchPage" target="_self" class="eg_monlink">
													<%=system%>
												</a>
											</td>

											<td align="left" id="cell_bg2" valign="top" wrap><%=ip%></td>
<%
					aListData1.add(system);
					aListData1.add(ip);

					for (int k=0; k<aListValues.size(); k++)
					{
						String value = (String)aListValues.get(k);

						int m = value.indexOf('=');
						if (m != -1)
						{
							value = value.substring(m+1,value.length());
						}

						value = decodeString(value);

						/* Added by Prakash.K for TimeZone - Starts*/
						boolean isDate = DateUtil.validDate(value,currentDateFormat);
						if (isDate)
						{
							int idx_colon = value.indexOf(':');
							if (idx_colon != -1)
							{
								if (value.indexOf("AM") != -1 || value.indexOf("PM") != -1)
								{
									boolean isPM = (value.substring(value.lastIndexOf(" ")+1)).equalsIgnoreCase("PM");

									value = value.substring(0,value.lastIndexOf(" "));
									String timeDate = value.substring(0,value.lastIndexOf(" "));
									String timeVal  = value.substring(value.lastIndexOf(" ")+1);

									String timeHour = null;
									String timeMin = null;
									String timeSec = null;

									ArrayList aListTokens = StringUtils.egTokenizer(timeVal,":");
									if (aListTokens != null)
									{
										timeHour = (String)aListTokens.get(0);
										timeMin = (String)aListTokens.get(1);
										timeSec = (String)aListTokens.get(2);
									}

									if (isPM)
									{
										int timeHourInt = Integer.parseInt(timeHour) + 12;
										timeHour = Integer.toString(timeHourInt);
									}

									timeVal = timeHour + ":" + timeMin + ":" + timeSec;
									value = timeDate + " " + timeVal;
								}

								EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(value,user);
								value = (String)timeZoneConverter.getDateTime();
							}
							else
							{
								value = DateUtil.changeDateFormat(value,currentDateFormat,userDateFormat);
							}
						}
						/* Added by Prakash.K for TimeZone - Ends*/
%>
											<td align="left" id="cell_bg2" valign="top" wrap>
<%
						if (value.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							out.println(mappingInfo.getTextDescription("configmgmt.common.Yes"));
							aListData1.add(mappingInfo.getTextDescription("configmgmt.common.Yes"));
						}
						else
						{
							out.println(value);
							aListData1.add(value);
						}
%>
											</td>
<%
					}
%>
										</tr>
<%
				}
			}
%>
									</table>

									<table>
										<tr>
											<td colspan="2" height="0"><img src="/final/config/images/spacer.gif" border="0" height="0"></td>
										</tr>
									</table>
<%
			//For new Pdf Framework
			EgTableModel egTableModel = new EgTableModel(aListData1,aListColumnNames);

			egTableAttributes.setColumnNames(userColumnNames);

			EgTable egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
		}

		//For new pdf framework
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
%>
								<!-- </div> -->
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>

</form>
</body>
</html>

<%!
	private ArrayList getIntnlData(EgMappingInfo mappingInfo,ArrayList aListQueryItems,String currentDateFormat,String userDtFormat)
	{
		ArrayList aListQueryItemsTemp = null;
		String headingDisplay = "";
		String nameHeadingDisplay = "";
		String tempDisplay = "";
		if (aListQueryItems != null)
		{
			aListQueryItemsTemp = new ArrayList();
			for (int i=0; i<aListQueryItems.size(); i++)
			{
				String temp_str = (String)aListQueryItems.get(i);
				String t1 = temp_str.substring(0,temp_str.indexOf("|"));
				String t2 = temp_str.substring(temp_str.indexOf("|")+1,temp_str.length());

				if (t1.equalsIgnoreCase("Hotfix:Date") || t1.equalsIgnoreCase("Software:Date"))
				{
					String[] params = getValues(t2);
					String fromDate = params[1];
					String toDate = params[3];
					String installed = params[5];

					fromDate = DateUtil.changeDateFormat(fromDate,currentDateFormat,userDtFormat);
					toDate = DateUtil.changeDateFormat(toDate,currentDateFormat,userDtFormat);

					if (t1.equalsIgnoreCase("Hotfix:Date"))
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Hotfix") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Date") + "|";
					}
					else
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Software") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Date") + "|";
					}

					tempDisplay = headingDisplay + mappingInfo.getTextDescription("configmgmt.common.From") + '=' + fromDate + '#' + mappingInfo.getTextDescription("configmgmt.common.To") + '=' + toDate + '#' + mappingInfo.getTextDescription("configmgmt.inventory.search.Installed") + '=' + installed;
				}
				else if (t1.equalsIgnoreCase("Hotfix:Name") || t1.equalsIgnoreCase("Software:Name") || t1.equalsIgnoreCase("Service:Name") || t1.equalsIgnoreCase("Networkadapter:Name"))
				{
					String[] params = getValues(t2);
					String strOS = params[1];
					String strSearchValue = params[3];
					String installed = params[5];

					strSearchValue = StringUtils.replace(strSearchValue,"0eGHash1","#");

					if (t1.equalsIgnoreCase("Hotfix:Name"))
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Hotfix") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Name") + "|";
						nameHeadingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Hotfix");
					}
					else if (t1.equalsIgnoreCase("Software:Name"))
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Software") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Name") + "|";
						nameHeadingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Software");
					}
					else if (t1.equalsIgnoreCase("Networkadapter:Name"))
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Networkadapter") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Name") + "|";
						nameHeadingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Networkadapter");
					}
					else if (t1.equalsIgnoreCase("Service:Name"))
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Service") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Name") + "|";
						nameHeadingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Service");
					}

					if (params.length == 6)
					{
						tempDisplay = headingDisplay + mappingInfo.getTextDescription("configmgmt.inventory.search.OS") + "=" + strOS + "#" + nameHeadingDisplay + "=" + strSearchValue + "#" + mappingInfo.getTextDescription("configmgmt.inventory.search.Installed") + "=" + installed;
					}
					else
					{
						String dispCols = params[7];
						tempDisplay = headingDisplay + mappingInfo.getTextDescription("configmgmt.inventory.search.OS") + "=" + strOS + "#" + nameHeadingDisplay + "=" + strSearchValue + "#" + mappingInfo.getTextDescription("configmgmt.inventory.search.Installed") + "=" + installed + '#' + mappingInfo.getTextDescription("configmgmt.inventory.search.Displaycolumns") + '=' + dispCols;
					}
				}
				else if (t1.equalsIgnoreCase("Hotfix:Pattern") || t1.equalsIgnoreCase("Software:Pattern") || t1.equalsIgnoreCase("Service:Pattern") || t1.equalsIgnoreCase("Networkadapter:Pattern"))
				{
					String[] params = getValues(t2);
					String strPattern = params[1];
					String installed = params[3];

					strPattern = StringUtils.replace(strPattern,"0eGHash1","#");

					if (t1.equalsIgnoreCase("Hotfix:Pattern"))
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Hotfix") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Pattern") + "|";
					}
					else if (t1.equalsIgnoreCase("Software:Pattern"))
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Software") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Pattern") + "|";
					}
					else if (t1.equalsIgnoreCase("Networkadapter:Pattern"))
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Networkadapter") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Pattern") + "|";
					}
					else if (t1.equalsIgnoreCase("Service:Pattern"))
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Service") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Pattern") + "|";
					}

					if (params.length == 4)
					{
						tempDisplay = headingDisplay + mappingInfo.getTextDescription("configmgmt.inventory.search.Pattern") + "=" + strPattern + "#" + mappingInfo.getTextDescription("configmgmt.inventory.search.Installed") + "=" + installed;
					}
					else
					{
						String dispCols = params[5];
						tempDisplay = headingDisplay + mappingInfo.getTextDescription("configmgmt.inventory.search.Pattern") + "=" + strPattern + "#" + mappingInfo.getTextDescription("configmgmt.inventory.search.Installed") + "=" + installed + '#' + mappingInfo.getTextDescription("configmgmt.inventory.search.Displaycolumns") + '=' + dispCols;
					}
				}
				else if (t1.equalsIgnoreCase("Harddisk:FilesystemType") || t1.equalsIgnoreCase("Harddisk:Capacity"))
				{
					String[] params = getValues(t2);
					String strOS = params[1];
					String strSearchValue = params[3];

					if (t1.equalsIgnoreCase("Harddisk:FilesystemType"))
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Harddisk") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.FilesystemType") + "|";
						nameHeadingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.FilesystemType");
					}
					else
					{
						headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Harddisk") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Capacity") + "|";
						nameHeadingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.Capacity");
					}

					tempDisplay = headingDisplay + mappingInfo.getTextDescription("configmgmt.inventory.search.OS") + "=" + strOS + "#" + nameHeadingDisplay + "=" + strSearchValue;
				}
				else if (t1.equalsIgnoreCase("OS:Date"))
				{
					String[] params = getValues(t2);
					String fromDate = params[1];
					String toDate = params[3];

					fromDate = DateUtil.changeDateFormat(fromDate,currentDateFormat,userDtFormat);
					toDate = DateUtil.changeDateFormat(toDate,currentDateFormat,userDtFormat);

					headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.OS") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.Date") + "|";

					tempDisplay = headingDisplay + mappingInfo.getTextDescription("configmgmt.common.From") + '=' + fromDate + '#' + mappingInfo.getTextDescription("configmgmt.common.To") + '=' + toDate;
				}
				else if (t1.equalsIgnoreCase("OS:OSname"))
				{
					String[] params = getValues(t2);
					String strOS = params[1];

					headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.OS") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.OSname") + "|";

					tempDisplay = headingDisplay + mappingInfo.getTextDescription("configmgmt.inventory.search.OS") + '=' + strOS;
				}
				else if (t1.equalsIgnoreCase("OS:RAMsize"))
				{
					StringTokenizer sTokens = new StringTokenizer(t2,"#");
					String os = sTokens.nextToken();
					String size = sTokens.nextToken();

					String s_os = os.substring(os.indexOf("=")+2);

					StringTokenizer sTokens_temp = new StringTokenizer(size," ");
					sTokens_temp.nextToken();
					String s_operator = sTokens_temp.nextToken();
					String s_size = sTokens_temp.nextToken();
					String s_unit = sTokens_temp.nextToken();

					headingDisplay = mappingInfo.getTextDescription("configmgmt.inventory.search.OS") + ":" + mappingInfo.getTextDescription("configmgmt.inventory.search.RAMsize") + "|";

					tempDisplay = headingDisplay + mappingInfo.getTextDescription("configmgmt.inventory.search.OS") + " = " + s_os + '#' + mappingInfo.getTextDescription("configmgmt.inventory.search.RAMsize") + ' ' + s_operator + ' ' + s_size + ' ' + s_unit; 
				}

				aListQueryItemsTemp.add(tempDisplay);
			}
		}
		return aListQueryItemsTemp;
	}

	private String[] getValues(String str)
	{
		StringTokenizer strTokens = new StringTokenizer(str,"#");
		int i_count = strTokens.countTokens();
		String[] tempValues = new String[i_count*2];
		int j = 0;
		for (int i=0;i<i_count;i++)
		{
			String s1 = strTokens.nextToken();
			tempValues[j] = s1.substring(0,s1.indexOf("="));
			tempValues[j+1] = s1.substring(s1.indexOf("=")+1);
			j = j+2;
		}
		return tempValues;
	}

	//For e.g., str can be OS=Microsoft Windows XP Professional#Service=eG##Mon#Installed=All##All
	//Note : delimiter should be a single character
	private ArrayList getParameters(String str,String delimiter)
	{
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		int delimiterIdx = str.indexOf(delimiter);
		while (delimiterIdx != -1)
		{
			String cutString = str.substring(0,delimiterIdx);

			if (cutString.length() == 0)
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + delimiter;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);

				str = str.substring(1);
			}
			else if (cutString.trim().indexOf("=") == -1)
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + delimiter + cutString;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);

				str = str.substring(cutString.length()+1);
			}
			else
			{
				String key = cutString.substring(0,cutString.indexOf("="));
				String value = cutString.substring(cutString.indexOf("=")+1);
				aListResultant.add(key.trim());
				aListResultant.add(value.trim());
				prevKey = key.trim();
				str = str.substring(delimiterIdx+1);
			}

			delimiterIdx = str.indexOf(delimiter);
		}

		if (str.length() > 0)
		{
			if (str.indexOf("=") != -1)
			{
				String lastKey = str.substring(0,str.indexOf("="));
				String lastValue = str.substring(str.indexOf("=")+1);
				aListResultant.add(lastKey.trim());
				aListResultant.add(lastValue.trim());
			}
			else
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + delimiter + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
		}

		ArrayList aListTemp = new ArrayList();
		for (int i=0;i<aListResultant.size();i=i+2)
		{
			aListTemp.add((String)aListResultant.get(i)+"="+(String)aListResultant.get(i+1));
		}

		return aListTemp;
	}
%>



