<%
/*
	File			:	ecChangeSummary.jsp
	Purpose			:	Display component type wise changes
	Creation Date	:	06-01-2009
	Author			:	Krishnamurthi
	UI Design		:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp"%>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "java.net.URLEncoder"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "egurkha.config.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	private TreeMap getTreeMap(ArrayList al_components)
	{
		TreeMap tmap = null;
		if (al_components != null && !al_components.isEmpty())
		{
			tmap = new TreeMap();
			for(int i=0;i<al_components.size();i++)
			{
				String s_component = (String)al_components.get(i);
				String component_type = s_component.substring(s_component.lastIndexOf(":")+1);
				String component_name;

				if (component_type.equals("Oracle_server"))
				{
					StringTokenizer strTokens = new StringTokenizer(s_component,":");
					component_name = strTokens.nextToken() + ":" + strTokens.nextToken();
					component_type = strTokens.nextToken() + ":" + strTokens.nextToken();
				}
				else
					component_name = s_component.substring(0,s_component.lastIndexOf(":"));

				if (tmap.containsKey(component_type))
				{
					ArrayList al_temp = (ArrayList)tmap.get(component_type);
					al_temp.add(component_name);
				}
				else
				{
					ArrayList al_temp = new ArrayList();
					al_temp.add(component_name);
					tmap.put(component_type,al_temp);
				}
			}
		}
		return tmap;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDateInfo egDateInfo = new EgDateInfo();
	EcProcessChangeData processChangeData = new EcProcessChangeData();
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}

	boolean hasAllComponentAccess = userRole.hasAllComponentAccess();

	String request_from = (String)request.getParameter("request_from");
	String request_start = (String)request.getParameter("request_start");

	String defaultHours = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ChangeSummary");
	String hourSelection = request.getParameter("NHour");
	StringTokenizer strTokens = new StringTokenizer(defaultHours,",");
	if (hourSelection == null)
	{
		Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);
		String hourSetting = (String)dashboardSetting.get(EgConfigConstants.TYPE_CHANGE_DURATION);
		if (hourSetting == null)
		{
			hourSelection = strTokens.nextToken();
		}
		else
		{
			hourSelection = hourSetting;
		}
	}

	Vector vecTimelineText = new Vector();
	Vector vecTimelineValue = new Vector(); //in hours
	strTokens = new StringTokenizer(defaultHours,",");
	while (strTokens.hasMoreTokens())
	{
		String hour = strTokens.nextToken().trim();
		int h = Integer.parseInt(hour);

		if (h == 1)
		{
			vecTimelineValue.add("1");
			vecTimelineText.add("1 hour");
		}
		else
		{
			vecTimelineValue.add(""+h);
			vecTimelineText.add(h+" hours");
		}
	}

	//UI Date Process - Start
	Date tempDate = new Date(egDateInfo.egetUTCDate());
	Calendar tempCalendar = new GregorianCalendar();
	tempCalendar.setTime(tempDate);
	Date tempDate2 = tempCalendar.getTime();
	long tempTime = tempDate2.getTime();

	String edate = egDateInfo.egetDate(tempTime);

	int start_time = Integer.parseInt(hourSelection);
	long msecsPerHour = (long) 1000 * 60 * 60;
	String sdate = egDateInfo.egetDate(tempTime - (long)(start_time * msecsPerHour));

	sdate = sdate.substring(0,sdate.lastIndexOf(":")+1) + "00";
	edate = edate.substring(0,edate.lastIndexOf(":")+1) + "00";

	String startDate = sdate.substring(0,sdate.indexOf(' '));
	String endDate = edate.substring(0,edate.indexOf(' '));
	startDate = startDate.substring(startDate.indexOf('/')+1,startDate.lastIndexOf('/'))+"/"+startDate.substring(0,startDate.indexOf('/'))+"/"+startDate.substring(startDate.lastIndexOf('/')+1);
	endDate = endDate.substring(endDate.indexOf('/')+1,endDate.lastIndexOf('/'))+"/"+endDate.substring(0,endDate.indexOf('/'))+"/"+endDate.substring(endDate.lastIndexOf('/')+1);

	String SHours = sdate.substring(sdate.indexOf(' ')+1);
	String EHours = edate.substring(edate.indexOf(' ')+1);
	StringTokenizer startTimeToken = new StringTokenizer(SHours,":");
	StringTokenizer endTimeToken = new StringTokenizer(EHours,":");

	String startHour = startTimeToken.nextToken();
	String startMinute = startTimeToken.nextToken();
	String endHour = endTimeToken.nextToken();
	String endMinute = endTimeToken.nextToken();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String tempStartDate = DateUtil.changeDateFormat(startDate,"MM/dd/yyyy",currentDateFormat);
	String tempEndDate = DateUtil.changeDateFormat(endDate,"MM/dd/yyyy",currentDateFormat);
	//UI Date Process - End

	//Parameters - Start
	String option1[] = new String[]{"All Components"};
	String timeline[] = new String[]{"Any"};
	String prevtimeline[] = new String[]{"Any"};

	String ec_stdate[] = new String[]{tempStartDate};
	String ec_sthr[] =  new String[]{startHour};
	String ec_startmin[] =  new String[]{startMinute};
	String ec_enddate[] =  new String[]{tempEndDate};
	String ec_endhr[] =  new String[]{endHour};
	String ec_endmin[] =  new String[]{endMinute};

	String strChangeType = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ShowChanges");
	if (strChangeType == null || strChangeType.length() == 0)
	{
		strChangeType = "All";
	}
	if (strChangeType.equalsIgnoreCase("Recent"))
	{
		strChangeType = "Latest";
	}
	else
	{
		strChangeType = "All";
	}

	String changeType[] = new String[]{strChangeType};

	String strViewChange = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ArrangeChanges");
	if (strViewChange == null || strViewChange.length() == 0)
	{
		strViewChange = "byInformation";
	}
	if (strViewChange.equalsIgnoreCase("Date"))
	{
		strViewChange = "byDate";
	}
	else
	{
		strViewChange = "byInformation";
	}

	String viewChange[] = new String[]{"byInformation"};

	Map params = new HashMap();
	params.put("ec_option1",option1);
	params.put("ec_timeline",timeline);
	params.put("ec_prevtimeline",prevtimeline);
	params.put("ec_stdate_h",ec_stdate);
	params.put("ec_sthr_h",ec_sthr);
	params.put("ec_startmin_h",ec_startmin);
	params.put("ec_enddate_h",ec_enddate);
	params.put("ec_endhr_h",ec_endhr);
	params.put("ec_endmin_h",ec_endmin);
	params.put("ec_changetype",changeType);
	params.put("ec_viewchange",viewChange);
	params.put("user_language",new String[]{userLanguage});
	//Parameters - End

	ArrayList al_components = new ArrayList();
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	for(int i=0;i<aListAssociatedComponents.size();i++)
	{
		String s_component = (String)aListAssociatedComponents.get(i);
		String component_type = s_component.substring(0,s_component.indexOf(":"));
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if(!isConfigTestEnabled)
			continue;
		String component_name = s_component.substring(s_component.indexOf(":")+1);
		al_components.add(component_name+":"+component_type);
	}
	TreeMap tmap_components = getTreeMap(al_components);

	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");

	EcChangeConfigurationBean ccbean = new EcChangeConfigurationBean(params,hasAllComponentAccess);
	ccbean.setTreeMap(tmap_components);
	ccbean.setHostAgentsMapping(hostAgentsMapping);
	TreeMap tmap_changeConfigDetails = ccbean.getChangeConfigurationData();

	String ec_criteria = request.getParameter("ec_criteria");
	String ec_userOption = request.getParameter("ec_userOption");
%>

<html>
<head>
<title></title>
<meta name="Author" content="Krishnamurthi">
<egui:skin ui="config"/>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:hidden" bgcolor="#FFFFFF">

<table width="100%" align="center" border="0" cellpadding="0" cellspacing="0" id="innertable" style="table-layout:fixed">

	<tr>
		<td height="20">
			<table cellspacing="0" cellpadding="0" border="0" width="100%">
				<tr>
					<td class="tdbackcolortop pLeft4" width="50%"><a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=ChangeSummary&NHour=<%=URLEncoder.encode(hourSelection)%>&request_from=Dashboard&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_headlink_white"><b><egui:intnl text="configmgmt.dashboard.Change Summary"/></b></a></td>
					<td align="right" width="50%" class="tdbackcolortop"><select name="NHour" onChange="javascript:goToChangeSummary()" style="width:85px">
<%
	for (int u=0;u<vecTimelineValue.size();u++)
	{
		String strTimelineText = (String)vecTimelineText.get(u);
		String strTimelineValue = (String)vecTimelineValue.get(u);

		String selected = "";
		if (strTimelineValue.equals(hourSelection))
			selected = "selected";

		String strValue = strTimelineText.substring(0,strTimelineText.indexOf(" "));
		String strText = strTimelineText.substring(strTimelineText.indexOf(" ")+1);
%>
						<option value="<%=strTimelineValue%>" <%=selected%>>
							<%=strValue%>&nbsp;<egui:intnl text='<%="configmgmt.common."+strText%>' />
						</option>
<%
	}
%>
						</select>
					</td>
				</tr>
			</table>
		</td>
	</tr>

<%
	if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
	{
%>
	<tr>
		<td align="center" height="150px" valign="middle">
			<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
				<tr>
					<td align="center" height="80" valign="bottom"><img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'></td>
				</tr>
				<tr>
					<td align="center" valign="top" height="60"><egui:intnl text="configmgmt.dashboard.No configuration changes found" /></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	else
	{
		TreeMap tmapAllComponentChanges = processChangeData.getAllComponentSummary(tmap_changeConfigDetails,null,null);
		Iterator changeCountKeys = tmapAllComponentChanges.keySet().iterator();
		int totalCount = 0;

		ArrayList aList = new ArrayList();
		while (changeCountKeys.hasNext())
		{
			Integer changeCount = (Integer)changeCountKeys.next();
			if (changeCount.intValue() == -1) continue;
			aList.add(changeCount);
		}
		Collections.reverse(aList);

		ArrayList aListChangedComponentTypes = new ArrayList();
		ArrayList aListChangeCount = new ArrayList();
		for (int a=0; a<aList.size(); a++)
		{
			Integer changeCount = (Integer)aList.get(a);
			int countValue = changeCount.intValue();

			ArrayList aListTemp = (ArrayList)tmapAllComponentChanges.get(changeCount);
			aListChangedComponentTypes.addAll(aListTemp);

			for (int i=0; i<aListTemp.size(); i++)
			{
				aListChangeCount.add(changeCount);
				totalCount = totalCount + countValue;
			}
		}
%>
	<tr>
		<td>
			<div id="div_scroll" style="width:100%;height:150px">
				<table width="100%" id="body_text" cellspacing="0" cellpadding="0" border="0" align="center" style="table-layout:fixed"><col width="80%"><col width="20%">
					<tr>
						<td align="center" width="100%" height="18" colspan="2" class="text_bold" id="tdbacklightcolor3"><egui:intnl text="configmgmt.dashboard.Total Changes" />&nbsp;:&nbsp;<%=totalCount%></td>
					</tr>
					<tr>
						<td align="center" width="80%" height="20" class="table_header_dash">&nbsp;<egui:intnl text="configmgmt.dashboard.Component Type" /></td>
						<td align="center" width="20%" height="20" class="table_header_dash" style="border-right-width:0px">&nbsp;<egui:intnl text="configmgmt.dashboard.Changes" /></td>
					</tr>
<%
		for (int g=0; g<aListChangedComponentTypes.size(); g++)
		{
			String componentType = (String)aListChangedComponentTypes.get(g);
			Integer changes = (Integer)aListChangeCount.get(g);
%>
					<tr>
						<td colspan="2" valign="top">
							<table cellspacing="0" cellpadding="2" align="center" border="0" width="100%" id="body_text" style="table-layout:fixed"><col width="80%"><col width="20%">
								<tr>
									<td nowrap width="80%" id="tdbacklightcolor2" class="cell_border">&nbsp;<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CSForDashboard&ec_rtype=Change&request_start=CSForDashboard&ec_option1=Component Type&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate_h=<%=URLEncoder.encode(tempEndDate)%>&ec_option2=<%=EgURLEncoder.encode(componentType,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=<%=strViewChange%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="" class="eg_monlink"><egui:intnl type="<%=componentType%>" /></a></td>
									<td width="20%" align="center" class="cell_border" style="border-right-width:0px"><a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CSForDashboard&ec_rtype=Change&request_start=CSForDashboard&ec_option1=Component Type&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate_h=<%=URLEncoder.encode(tempEndDate)%>&ec_option2=<%=EgURLEncoder.encode(componentType,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=<%=strViewChange%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="" class="eg_monlink"><%=changes%></a></td>
								</tr>
							</table>
						</td>
					</tr>
<%
		}
%>
				</table>
			</div>
		</td>
	</tr>
<%
	}
%>

</table>

</body>
</html>



