<%
/*****************************************************************************************************************
*	Name			:	addDefaultAggTestsp.jsp
*	Purpose			:	This process page for addDefaultAggTests.jsp
*	Version			:	5.7
*	Creation Date	:	28th March 2013
*	Author			:	James Thomas P
/*****************************************************************************************************************/
%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="java.util.*"%>
<%@ page import="java.io.*"%>
<%
	String operation = request.getParameter("operation");
	String s_component_type = request.getParameter("s_component_type");
	EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
	Hashtable testMeasureFunctionHt = new Hashtable();
	Hashtable testMeasuresInOrderHt = new Hashtable();
	if(operation.equals("addMeasures"))
	{
		Enumeration en = request.getParameterNames();
		while(en.hasMoreElements())
		{
			String param_name = (String)en.nextElement();
			if(param_name != null && (param_name=param_name.trim()).endsWith("$msr"))
			{
				String param_value = request.getParameter(param_name);
				if(param_name != null && (param_name=param_name.trim()).length()>0)
				{
					String function_param = param_name.substring(0,param_name.lastIndexOf("$"))+"$fun";
					String AGGREGATE_FUNCTION = request.getParameter(function_param);
					String array[] = StringUtils.getTokens(param_name,"$");
					String testname = array[0];
					String measure = array[1];
					if(testMeasureFunctionHt.containsKey(testname))
					{
						Hashtable measureFunctionHt = (Hashtable)testMeasureFunctionHt.get(testname);
						measureFunctionHt.put(measure,AGGREGATE_FUNCTION);
					}
					else
					{
						Hashtable measureFunctionHt = new Hashtable();
						measureFunctionHt.put(measure,AGGREGATE_FUNCTION);
						testMeasureFunctionHt.put(testname,measureFunctionHt);
					}
				}
			}
		}
	}
	else if(operation.equals("modifyMeasures"))
	{
		String testname = request.getParameter("test");
		String measures = request.getParameter("measureNames");
		String array[] = StringUtils.getTokens(measures,"$");
		for(int i=0;i<array.length;i++)
		{
			String MF = array[i];
			int index = MF.indexOf(":");
			if(index==-1)
			{
				testMeasureFunctionHt.clear();
				break;
			}
			String MEASURE_NAME = MF.substring(0,index);
			String AGGREGATE_FUNCTION = MF.substring(index+1);
			if(testMeasureFunctionHt.containsKey(testname))
			{
				Hashtable measureFunctionHt = (Hashtable)testMeasureFunctionHt.get(testname);
				measureFunctionHt.put(MEASURE_NAME,AGGREGATE_FUNCTION);
			}
			else
			{
				Hashtable measureFunctionHt = new Hashtable();
				measureFunctionHt.put(MEASURE_NAME,AGGREGATE_FUNCTION);
				testMeasureFunctionHt.put(testname,measureFunctionHt);
			}
		}
	}
	Iterator iterator = testMeasureFunctionHt.keySet().iterator();
	while(iterator.hasNext())
	{
		String testname = (String)iterator.next();
		Hashtable ht = (Hashtable)testMeasureFunctionHt.get(testname);
		int mCount = ht.size();
		String individualMeasures[] = thresholdInfo.getMeasurementsForTest(testname);
		String MEASURE_ARRAY[] = new String[mCount];
		String FUNCTION_ARRAY[] = new String[mCount];
		int c = 0;
		for(int i=0;i<individualMeasures.length;i++)
		{
			String individualMeasure = individualMeasures[i];
			if(ht.containsKey(individualMeasure))
			{
				String AGGREGATE_FUNCTION = (String)ht.get(individualMeasure);
				MEASURE_ARRAY[c] = individualMeasure;
				FUNCTION_ARRAY[c++] = AGGREGATE_FUNCTION;
			}
		}
		testMeasuresInOrderHt.put(testname,MEASURE_ARRAY);
		testMeasureFunctionHt.put(testname,FUNCTION_ARRAY);
	}
	if(operation.equals("modifyMeasures"))
	{
		String testname = request.getParameter("test");
		String aggTest = request.getParameter("aggTest");
		String aggTestExistingMeasures[] = thresholdInfo.getMeasurementsForTest(aggTest);
		String MEASURE_ARRAY[] = (String[])testMeasuresInOrderHt.get(testname);
		String FUNCTION_ARRAY[] = (String[])testMeasureFunctionHt.get(testname);
		ArrayList a1 = new ArrayList(Arrays.asList(MEASURE_ARRAY));
		ArrayList a2 = new ArrayList(Arrays.asList(FUNCTION_ARRAY));
		ArrayList a3 = new ArrayList();
		ArrayList a4 = new ArrayList();
		
		EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
		Vector templateVars = aggregateInfo.getVariables(testname+"_Template",true);
		Vector templateVals = aggregateInfo.getAllValues(testname+"_Template");
		Hashtable aimHt = new Hashtable();
		if(templateVars != null && !templateVars.isEmpty() && templateVals != null && !templateVals.isEmpty() && templateVars.size()==templateVals.size())
		{
			for(int i=0;i<templateVars.size();i++)
			{
				String measure = (String)templateVars.get(i);
				String aggmeasure = (String)templateVals.get(i);
				aimHt.put(aggmeasure.substring(aggmeasure.indexOf(":")+1),measure.substring(measure.indexOf(":")+1));
			}
		}

		for(int i=0;i<aggTestExistingMeasures.length;i++)
		{
			String m = aggTestExistingMeasures[i];//aggregate test measure
			String imeasure = (String)aimHt.get(m);//individual test measure
			String copy = null;
			if(!imeasure.equals(m))
			{
				copy = m;//copying existing aggregate measure name to variable namely copy
				m = imeasure;
			}
			int index = a1.indexOf(m);
			if(index>-1)
			{
				if(copy != null)
				{
					a3.add(copy);
				}
				else
				{
					a3.add(m);
				}
				a4.add(a2.get(index));

				a1.remove(index);
				a2.remove(index);
			}
		}
		if(!a1.isEmpty() && !a2.isEmpty())
		{
			a3.addAll(a1);
			a4.addAll(a2);
		}
		testMeasuresInOrderHt.put(testname,(String[])a3.toArray(new String[a3.size()]));
		testMeasureFunctionHt.put(testname,(String[])a4.toArray(new String[a3.size()]));
	}
	String testnames[] = (String[])testMeasureFunctionHt.keySet().toArray(new String[testMeasureFunctionHt.size()]);
%>
<html>
<head>
	<link rel="StyleSheet" href="/final/admin/eg_styles/adminstyle_blue.css"/>
	<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
</head>
<body style="overflow:auto" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
	<table align="center" cellspacing="0" cellpadding="0" width="75%" border="0">
		<tr>
			<td id="eg_blankspace" height="10">&nbsp;</td>
		</tr>
		<tr>
			<td align="center" id="eg_whitebg" align="center" height="600" valign="middle">
				<table align="center" cellspacing="0" cellpadding="0" width="75%" border="0" style="table-layout:auto">
					<tr>
						<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						<td height="6" id="eg_subcontentbg" width="100%" colspan="6"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
						<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					</tr>
<%
	if(testnames.length>0)
	{
		column_datatype.clear();
		Hashtable dbMsrColMap = new Hashtable();
		boolean error = false;
		String testname = null;
		for(int i=0;i<testnames.length;i++)
		{
			testname = testnames[i];
			String individualMeasures[] = thresholdInfo.getMeasurementsForTest(testname);
			Vector individualMeasurementDbMapping = getindividualMeasurementDbMapping(testname,individualMeasures,out);
			if(individualMeasurementDbMapping != null && !individualMeasurementDbMapping.isEmpty())
			{
				dbMsrColMap.put(testname,individualMeasurementDbMapping);
			}
			else
			{
				error = true;
				break;
			}
		}
		if(error)
		{
			String filename = null;
			if(EgDbInfo.isOraAdapter)
			{
				filename = EgInstallInfo.getInstallDir()+"/bin/database/total.sql";
			}
			else
			{
				filename = EgInstallInfo.getInstallDir()+"/bin/database/mssql/total.sql";
			}
%>
					<tr>
						<td colspan="8" class="eg_subcontentbg" id="form_spacing" align="center">
							<table border="0" cellspacing="0" cellpadding="4" width="95%">
								<tr>
									<td class="eg_subcontentbg" width="100%" align="center">Error while reading measure db column name mapping by parsing <b><i>create table <%=testname%> ...</i></b> query in <%=filename%></td>
								</tr>
								<tr>
									<td class="eg_subcontentbg" width="100%" align="center"><a class="eg_monlink" href='/final/misc/defaultAggTests.jsp?sessionInUse=true&s_component_type=<%=s_component_type%>'><b style="color:blue">Click here</b></a>&nbsp;to add new aggregate tests.</td>
								</tr>
							</table>
						</td>
					</tr>
<%
		}
		else
		{
			for(int a=0;a<testnames.length;a++)
			{
				testname = testnames[a];
				String thisAggTest = testname + "_ag";
				Vector individualMeasurementDbMapping = (Vector)dbMsrColMap.get(testname);
				String individualMeasures[] = thresholdInfo.getMeasurementsForTest(testname);
				boolean isNormalTestPortBased =new EgSpecsInfo("manager").isPortRelevantForTest(testname);
				String measures[] = (String[])testMeasuresInOrderHt.get(testname);
				String FUNCTION_ARRAY[] = (String[])testMeasureFunctionHt.get(testname);
				int measuresCount = measures.length;

				String siteOrientedStr = request.getParameter("siteOriented");
				boolean isTestSiteOriented = (siteOrientedStr != null && siteOrientedStr.equals("true"))?true:false;

				String aggregateDescriptor = null;
				if(operation.equals("addMeasures"))
				{
					aggregateDescriptor = request.getParameter(testname+"descriptorAggregation");
				}
				else
				{
					aggregateDescriptor = request.getParameter("descriptorAggregation");
				}
				aggregateDescriptor = (aggregateDescriptor != null && aggregateDescriptor.equals("true"))?"true":"false";

				String default_enabled_template = null;
				if(operation.equals("addMeasures"))
				{
					default_enabled_template = request.getParameter(testname+"default_enabled_template");
				}
				else
				{
					default_enabled_template = request.getParameter("default_enabled_template");
				}
				default_enabled_template = (default_enabled_template != null && default_enabled_template.equals("true"))?"true":"false";

				String dirPath =  EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/misc/aggsupport";
				File newDir = new File(dirPath);
				if(!newDir.isDirectory())
				{
					newDir.mkdir();
				}
				String fileName = EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/misc/aggsupport/"+thisAggTest+".ini";
				File file = new File(fileName);
				if(file.exists())
				{
					file.delete();
				}
				PrintWriter printWriter = new PrintWriter(new FileWriter(fileName));

				//Entries under eg_aggregate.ini file
				printWriter.println("Entries under eg_aggregate.ini file");
				printWriter.println("-------------------------------------");
				if(isTestSiteOriented)
				{
					printWriter.println("[SITE_AGGREGATE_TEST]");
					printWriter.println(thisAggTest+"=yes");
					printWriter.println();
				}

				printWriter.println("[AGGREGATE_TEST]");
				printWriter.println(thisAggTest+"="+testname);
				printWriter.println();

				printWriter.println("[PRE_DEFINED_AGGREGATE_TEST]");
				printWriter.println(thisAggTest+"="+testname);
				printWriter.println();

				ArrayList measuresList = new ArrayList();
				measuresList.addAll(Arrays.asList(individualMeasures));

				printWriter.println("[AGGREGATE_FUNCTION]");
				for(int i=0;i<measuresCount;i++)
				{
					String measure = measures[i];
					int index = measuresList.indexOf(measure);
					printWriter.println(thisAggTest+":"+measure.toUpperCase()+"="+(String)individualMeasurementDbMapping.get(index)+":"+FUNCTION_ARRAY[i]+":1#1");
				}
				printWriter.println();

				printWriter.println("[COLUMN_NAME_MAPPING]");
				for(int i=0;i<measuresCount;i++)
				{
					String measure = measures[i];
					printWriter.println(thisAggTest+":"+measure+"="+testname+":"+measure);
				}
				printWriter.println();

				printWriter.println("["+testname+"_Template]");
				for(int i=0;i<measuresCount;i++)
				{
					String measure = measures[i];
					printWriter.println(testname+":"+measure+"="+thisAggTest+":"+measure);
				}
				printWriter.println();

				printWriter.println("[DEFAULT_ENABLED_TEMPLATES]");
				printWriter.println(testname+"_Template="+default_enabled_template);
				printWriter.println();

				//Entries under eg_tables.ini file
				EgTablesInfo tablesInfo = new EgTablesInfo("manager");
				printWriter.println();
				printWriter.println("Entries under eg_tables.ini file");
				printWriter.println("----------------------------------");
				printWriter.println("[MEASUREMENT_LAYER_TABLE]");
				String layer = tablesInfo.getLayerForTest(testname);
				for(int i=0;i<measuresCount;i++)
				{
					printWriter.println(thisAggTest+":"+measures[i]+"="+layer.toUpperCase());
				}
				printWriter.println();
				printWriter.println("[MEASUREMENT_UNITS_TABLE]");
				for(int i=0;i<measuresCount;i++)
				{
					String measure = measures[i];
					printWriter.println(thisAggTest+":"+measure+"="+tablesInfo.getUnitForMeasure(testname,measure));
				}

				//Entries under eg_thresholds.ini file
				printWriter.println();
				printWriter.println("Entries under eg_thresholds.ini file");
				printWriter.println("----------------------------------");
				printWriter.println("[DEFAULT_THRESHOLDS]");
				Hashtable ht = new Hashtable();
				IniFile threasholds = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_thresholds.ini");
				StringTokenizer tokens = new StringTokenizer(threasholds.getValue("DEFAULT_THRESHOLDS",testname),",");
				threasholds = null;
				while(tokens.hasMoreTokens())
				{
					String t = tokens.nextToken();//Max_pool_size:mix:-1:-1:longterm:HML
					String m = t.substring(0,t.indexOf(":"));
					ht.put(m,m+":mix:-1:-1:immediate:HML");
				}
				String str="";
				for(int i=0;i<measuresCount;i++)
				{
					String s = (String)ht.get(measures[i]);
					str += "," + s;
				}
				ht.clear();
				if(str.length()>0)
				{
					str = str.substring(1);
				}
				printWriter.println(thisAggTest+"="+str);

				//Entries under eg_specs.ini file
				printWriter.println();
				printWriter.println("Entries under eg_specs.ini file");
				printWriter.println("----------------------------------");

				Hashtable testMappingHt = new Hashtable();
				IniFile specsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
				String host_layer_tests = specsIni.getValue("TEST_MAPPING","Host_system");

				String tempStr = ","+host_layer_tests+",";
				if(tempStr.indexOf(","+testname+",")>-1)
				{
					printWriter.println();
					printWriter.println("[TEST_MAPPING]");
					printWriter.println("Host_system=," + thisAggTest);
				}

				host_layer_tests = specsIni.getValue("DEFAULT_TEST_MAPPING","Host_system");
				tempStr = ","+host_layer_tests+",";
				if(tempStr.indexOf(","+testname+",")>-1)
				{
					printWriter.println();
					printWriter.println("[DEFAULT_TEST_MAPPING]");
					printWriter.println("Host_system=," + thisAggTest);
				}

				Iterator itr = testMappingHt.keySet().iterator();
				while(itr.hasNext())
				{
					String s = (String)itr.next();
					printWriter.println(s + "=" + testMappingHt.get(s).toString());
				}
				String var = "";
				String val = "";
				if(isNormalTestPortBased)
				{
					var += thisAggTest + "::$hostName:$portNo";
				}
				else
				{
					var += thisAggTest + "::$hostName";
				}
				if(new EgTesterInfo("manager").externalAgentRunsAllAggTests())
				{
					val += "$EG_SERVER, -auto, -host $hostIp -action_on_descriptors include -include_descriptors all";
				}
				else
				{
					val += "$hostName, -auto, -host $hostIp -action_on_descriptors include -include_descriptors all";
				}

				if(isNormalTestPortBased)
				{
					val += " -port $portNo";
				}

				Vector test_specification_var = (Vector)specsIni.getVariables("TEST_SPECIFICATION",true).clone();
				Vector test_specification_val = (Vector)specsIni.getAllValues("TEST_SPECIFICATION").clone();
				String defaultTestPeriod = "300";
				for(int i=0;i<test_specification_var.size();i++)
				{
					String key = (String)test_specification_var.get(i);
					if(key.startsWith(testname+":"))
					{
						defaultTestPeriod = (String)test_specification_val.get(i);
						defaultTestPeriod = defaultTestPeriod.substring(defaultTestPeriod.lastIndexOf(",")+1).trim();
						if(defaultTestPeriod.length()==0)
						{
							defaultTestPeriod = "300";//5 minutes
						}
					}
				}
				test_specification_var.clear();
				test_specification_val.clear();

				val += " -excludeDescriptor none -aggregateDescriptor "+aggregateDescriptor+" -agentless y -rptName $hostName -mCount " + measuresCount+", "+defaultTestPeriod;

				printWriter.println();
				printWriter.println("[TEST_SPECIFICATION]");
				printWriter.println(var + "=" + val);

				printWriter.println();
				printWriter.println("[AGGREGATE_TESTS]");
				printWriter.println(thisAggTest + "=yes");

				//Entries under eg_testparam.ini file
				printWriter.println();
				printWriter.println("Entries under eg_testparam.ini file");
				printWriter.println("----------------------------------");
				printWriter.println("[RADIO]");
				printWriter.println(thisAggTest + "=aggregateDescriptor");

				//Entries under eg_ui.ini file
				boolean header = true;
				for(int i=0;i<measuresCount;i++)
				{
					String measure = measures[i];
					String unit = tablesInfo.getUnitForMeasure(testname,measure);
					if(unit != null && unit.trim().equalsIgnoreCase("boolean"))
					{
						if(header)
						{
							header = false;
							printWriter.println();
							printWriter.println("Entries under eg_ui.ini file");
							printWriter.println("----------------------------------");
							printWriter.println("[Measure_value_display]");

						}
						printWriter.println(thisAggTest+":"+measure+":0=No");
						printWriter.println(thisAggTest+":"+measure+":1=Yes");
					}
				}
				if(!header)
				{
					printWriter.println();
				}
				printWriter.close();
			}
			createIniFiles();
%>
						<tr>
							<td colspan="8" class="eg_subcontentbg" id="form_spacing" align="center">
								<table border="0" cellspacing="0" cellpadding="4" width="110%">
									<tr>
										<td class="eg_subcontentbg" width="100%" align="center">Aggregate test entries are available in <b><%=com.eg.EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/misc/aggsupport"%></b>&nbsp;folder</td>
									</tr>
									<tr>
										<td class="eg_subcontentbg" width="100%" align="center"><a class="eg_monlink" href='../misc/defaultAggTests.jsp?sessionInUse=true&s_component_type=<%=s_component_type%>'><b style="color:blue">Click here</b></a>&nbsp;to add new aggregate test.</td>
									</tr>
								</table>
							</td>
						</tr>
<%
		}
	}
	else
	{
%>
						<tr>
							<td colspan="8" class="eg_subcontentbg" id="form_spacing" align="center">
								<table border="0" cellspacing="0" cellpadding="4" width="100%">
									<tr>
										<td class="eg_subcontentbg" width="100%" align="center">Tests have not been selected to aggregate.</td>
									</tr>
								</table>
							</td>
						</tr>
<%
	}
%>

						<tr>
							<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
							<td id="eg_subcontentbg" width="100%" colspan="6" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
							<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td id="eg_blankspace" height="10">&nbsp;</td>
			</tr>
		</table>
</body>
</html>
<%!
	ArrayList column_datatype = new ArrayList();
	EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
	Vector getindividualMeasurementDbMapping(String testname, String individualMeasures[], JspWriter out) throws IOException
	{
		Vector individualMeasurementDbMapping = null;
		Vector v = null;
		if(EgDbInfo.isOraAdapter)
		{
			v = getData(EgInstallInfo.getInstallDir()+"/bin/database/total.sql",testname);
		}
		else
		{
			v = getData(EgInstallInfo.getInstallDir()+"/bin/database/mssql/total.sql",testname);
		}
		if(v != null && v.size()>2)
		{
			individualMeasurementDbMapping = new Vector();
			String create_table_query = (String) v.get(1);//create table query
			v.clear();
			create_table_query = create_table_query.toLowerCase().substring(0,create_table_query.lastIndexOf(")"));
			if(EgDbInfo.isOraAdapter)
			{
				create_table_query = create_table_query.substring(create_table_query.indexOf("date"));
			}
			else
			{
				create_table_query = create_table_query.substring(create_table_query.indexOf("datetime"));
			}
			create_table_query = create_table_query.substring(create_table_query.indexOf(",")+1).trim();
			create_table_query = create_table_query.replaceAll("\\s+", " ");//change multiple white spaces into single
			String columns[] = StringUtils.getTokens(create_table_query,"not null,");
			for(int i=0;i<columns.length;i++)
			{
				if(i%2==0)
				{
					String column = columns[i].trim();
					column_datatype.add(column);
					String measure = column.substring(0,column.indexOf(" "));
					//System.out.println(column + " " + measure.toUpperCase());
					individualMeasurementDbMapping.add(measure.toUpperCase());
				}
			}
		}
		if(individualMeasures == null || individualMeasures.length == 0 || individualMeasurementDbMapping == null || individualMeasures.length != individualMeasurementDbMapping.size())
		{
			if(individualMeasures == null || individualMeasures.length==0)
			{
				out.println(testname + " measures are not found in eg_threshold.ini<br>");
				return null;
			}
			else if(individualMeasurementDbMapping == null || individualMeasurementDbMapping.isEmpty())
			{
				out.println(testname + " measurements db mapping are not found<br>");
				return null;
			}
			else if(individualMeasures.length != individualMeasurementDbMapping.size())
			{
				out.println(testname + " measures count and database column names count differs.<br>");
				individualMeasurementDbMapping.clear();
				return null;
			}
		}
		return individualMeasurementDbMapping;
	}

	/* this method is copied from EgDbInfo.java */
	Vector getData(String fileName, String tname)
	{
		BufferedReader in=null;
		FileReader file=null;
		boolean flag = true;
		String data=" Null";
		String addString="";
		int count=0;
		Vector vect = new Vector();
		boolean isTotal = false;
		String filterTables[] = null;

		String tname1 = tname.toLowerCase();
		if (fileName.endsWith("total.sql")) {
			isTotal = true;
			EgDbaseInfo e = new EgDbaseInfo("manager");
			filterTables = e.getDefaultTables();
			if (filterTables != null)
			{
				for (int m=0; m<filterTables.length; m++)
					if(filterTables[m].equalsIgnoreCase(tname1))
						return (vect); // no work!
			}
		}
		try{
			in = new BufferedReader( new FileReader(fileName));
		}catch(FileNotFoundException e){
			return null;
		}
		try {
			addString = "";
			String x1 = new String(" "+tname1+" ");
			String x2 = new String(" "+ tname1+"_");
			String x3 = new String(" " +tname1+"(");
			boolean processing = false;
			while ((data=in.readLine())!=null) {
				if (data.length() > 0) {
					if (!processing)
					{
						String str = data.toLowerCase();
						if (str.indexOf(tname1) < 0)
						{
							continue;
						}
					}
					processing = true;
					addString += " " + data;
					if (addString.indexOf(";") != -1) {
				     	String pure = addString.replace(';',' ');
						if (!isTotal)
				     			vect.addElement(pure);
						else
						{ // is total - lets filter
							String s = pure.toLowerCase();
							  int l = s.indexOf("table");
							  if (l >= 0)
							  {
								String s1 = s.substring(l+5);
								if (s1.indexOf(x1) >= 0 ||
									s1.indexOf(x2) >=0 ||
									s1.indexOf(x3)>=0)
				     				vect.addElement(pure);
							  } else
							  {
								if ((l=s.indexOf(" on ")) >= 0) {
								  String s1 = s.substring(l+3);
								 if (s1.indexOf(x2)>=0 || s1.indexOf(x1)>=0 || s1.indexOf(x3)>=0)
				     					vect.addElement(pure);
							  	}
								else {
								if ((l=s.indexOf(" into ")) >= 0) {
								 String s1=s.substring(l+5);
								 if (s1.indexOf(x1) >=0 ||
									 s1.indexOf(x3)>=0)
				     					vect.addElement(pure);
							     }
								}
							  }
						}
						processing = false;
						addString="";
					}
				}
			}
			in.close();
		}
		catch (Exception e) {}
		return vect;
	}
	void createIniFiles()
	{
		String miscDir = EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/misc/aggsupport";
		String filename = null;
		File dir = new File(miscDir);
		String allFiles[] = dir.list();
		ArrayList files = new ArrayList();
		for(int i=0;i<allFiles.length;i++)
		{
			filename = allFiles[i];
			if(filename.endsWith("_ag.ini"))
			{
				files.add(filename);
			}
		}
		int size = files.size();
		if(size>0)
		{
			String inifilenames[] = {"eg_aggregate.ini","eg_tables.ini","eg_thresholds.ini","eg_specs.ini","eg_testparam.ini","eg_ui.ini"};
			String newAggTests[] = (String[])files.toArray(new String[size]);

			String test_mapping = null;
			String default_test_mapping = null;

			for(int i=0;i<inifilenames.length;i++)
			{
				String inifilename = inifilenames[i];
				IniFile writeObject = new IniFile((miscDir + "/" + inifilename),true);

				String subjects[] = null;
				if(inifilename.equals("eg_specs.ini"))
				{
					subjects = new String[]{"TEST_MAPPING","TEST_SPECIFICATION","DEFAULT_TEST_MAPPING","AGGREGATE_TESTS"};
				}
				else if(inifilename.equals("eg_tables.ini"))
				{
					subjects = new String[]{"MEASUREMENT_LAYER_TABLE","MEASUREMENT_UNITS_TABLE"};
				}
				else if(inifilename.equals("eg_aggregate.ini"))
				{
					subjects = new String[]{"AGGREGATE_TEST","PRE_DEFINED_AGGREGATE_TEST","AGGREGATE_FUNCTION","COLUMN_NAME_MAPPING","XXX_Template","DEFAULT_ENABLED_TEMPLATES"};
				}
				else if(inifilename.equals("eg_thresholds.ini"))
				{
					subjects = new String[]{"DEFAULT_THRESHOLDS"};
				}
				else if(inifilename.equals("eg_testparam.ini"))
				{
					subjects = new String[]{"RADIO"};
				}
				else if(inifilename.equals("eg_ui.ini"))
				{
					subjects = new String[]{"Measure_value_display"};
				}
				for(int j=0;j<newAggTests.length;j++)
				{
					String newAggTest = newAggTests[j];
					IniFile readObject = new IniFile((miscDir + "/" + newAggTest));
					for(int k=0;k<subjects.length;k++)
					{
						String thisSubject = subjects[k];
						Vector vars = readObject.getVariables(thisSubject,true);
						Vector vals = readObject.getAllValues(thisSubject);
						if(vars != null && vals != null && vars.size()>0 && vars.size() == vals.size())
						{
							if(k==0 && inifilename.equals("eg_aggregate.ini"))
							{
								subjects[4] = (String)vals.get(0) + "_Template";
							}
							if(inifilename.equals("eg_specs.ini") && (thisSubject.equals("TEST_MAPPING") || thisSubject.equals("DEFAULT_TEST_MAPPING")))
							{
								if(thisSubject.equals("TEST_MAPPING"))
								{
									if(test_mapping == null)
									{
										test_mapping = (String)vals.get(0);
									}
									else
									{
										test_mapping += (String)vals.get(0);
									}
								}
								if(thisSubject.equals("DEFAULT_TEST_MAPPING"))
								{
									if(default_test_mapping == null)
									{
										default_test_mapping = (String)vals.get(0);
									}
									else
									{
										default_test_mapping += (String)vals.get(0);
									}
								}
							}
							else
							{
								for(int l=0;l<vals.size();l++)
								{
									writeObject.setValue(thisSubject,(String)vars.get(l),(String)vals.get(l));
								}
							}
						}
					}
				}
				if(inifilename.equals("eg_specs.ini"))
				{
					if(test_mapping != null)
					{
						writeObject.setValue("TEST_MAPPING","Host_system",test_mapping);
					}
					if(default_test_mapping != null)
					{
						writeObject.setValue("DEFAULT_TEST_MAPPING","Host_system",default_test_mapping);
					}
				}
				writeObject.saveFile();
			}
		}
	}
%>



