<%
/*****************************************************************************************************************
*	Name			:	defaultAggTests.jsp
*	Purpose			:	This page lists aggregate and non aggregated tests for component types
*	Version			:	5.7
*	Creation Date	:	28th March 2013
*	Author			:	James Thomas P
/*****************************************************************************************************************/
%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgConMonHelper"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%

	String tool = "aggsupport";
	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");
	String authenticated = (String)session.getAttribute("authenticated");

	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom="+tool+"&tools="+tool);
			}
			else
			{
%>
				<script>
					window.parent.location.href ="/final/toolkitlogin";
				</script>
<%
			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom="+tool+"&tools="+tool);
			}
			else
			{
				session.setAttribute("reqFromForTk","aggsupport");
				session.setAttribute("validate_tools","true");
				session.setAttribute("tools",tool);
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
			}
		}
	}
	else
	{ 
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			session.setAttribute("validate_tools","true");
			session.setAttribute("tools",tool);
			response.sendRedirect(request.getContextPath()+"/toolkit");
		}
	}
	session.setAttribute("reqFromForTk","aggsupport");

	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("Agg"))
	{
		session.setAttribute("treeViewSrc","aggsupport");
	}

	ArrayList componentTestList = null;
	ArrayList aggSupportedTestList = null;
	ArrayList componentTypes = new ArrayList(Arrays.asList(new com.eg.EgDiscInfo("manager").getComponentTypes()));
	MappingNameSorter sorter = new MappingNameSorter("en_US");
	
	String s_component_type = request.getParameter("s_component_type");
	if(StringUtils.isNull(s_component_type))
	{
		s_component_type="-1";
	}
	else
	{
		componentTestList = new ArrayList();
		aggSupportedTestList = new ArrayList();
		EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
		String tests[] = specsInfo.getDefaultTestsForServer(s_component_type);
		if(tests != null && tests.length>0)
		{
			componentTestList = new ArrayList(Arrays.asList(tests));
			aggSupportedTestList = new ArrayList(Arrays.asList(tests));
		}

		EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
		Vector aggregateTests = aggregateInfo.getVariables("PRE_DEFINED_AGGREGATE_TEST",true);
		Vector aggregatedIndividualTests = aggregateInfo.getAllValues("PRE_DEFINED_AGGREGATE_TEST");

		if(!aggSupportedTestList.isEmpty() && !aggregatedIndividualTests.isEmpty())
		{
			aggSupportedTestList.retainAll(aggregatedIndividualTests);
		}
		componentTestList.removeAll(aggSupportedTestList);
		componentTestList = sorter.getSortedTestList(componentTestList);
		aggSupportedTestList = sorter.getSortedTestList(aggSupportedTestList);
	}
	boolean allTestsAreAggregated = true;
%>
<html>
<head>
<title>Default Aggregate Tests</title>
<link REL = "StyleSheet" href = "/final/admin/eg_styles/adminstyle_blue.css"/>
<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
<script language="javascript1.2">
function changeComponentType(component_type)
{
	var thisForm = document.deleteuser;
	thisForm.s_component_type.value = component_type;
	thisForm.action = "defaultAggTests.jsp?sessionInUse=true";
	thisForm.submit();
}
function addDefaultAggTests()
{
	var val="";
	var thisForm = document.deleteuser;
	for(i=0;i<thisForm.notAddedTests.options.length;i++)
	{
		if(thisForm.notAddedTests.options[i].selected)
		{
			val += thisForm.notAddedTests.options[i].value+",";
		}
	}
	if(val.length==0)
	{
		alert("Please select a test to add.");
	}
	else
	{
		val = val.substring(0,val.lastIndexOf(","));
		thisForm.operation.value = "addMeasures";
		thisForm.s_tests.value = val;
		thisForm.s_component_type.value = thisForm.component_types.value;
		thisForm.action = "addDefaultAggTests.jsp?sessionInUse=true";
		thisForm.submit();
	}
}
function modifyDefaultAggTest(test)
{
	var notSent = "true";
	var thisForm = document.deleteuser;
	for(i=0;i<thisForm.addedTests.options.length;i++)
	{
		if(thisForm.addedTests.options[i].selected)
		{
			notSent = "false";
			thisForm.operation.value = "modifyMeasures";
			thisForm.s_tests.value = thisForm.addedTests.options[i].value;
			thisForm.s_component_type.value = thisForm.component_types.value;
			thisForm.action = "modifyDefaultAggTest.jsp?sessionInUse=true";
			thisForm.submit();
		}
	}
	if(notSent=="true")
	{
		alert("Please select a test to modify.");
	}
}
</script>
</head>
<body style="overflow:auto" scrolling="yes" id="space6" >
<form name="deleteuser" method="POST" style="margin:0px">
<input type="hidden" name="operation" value="">
<input type="hidden" name="s_component_type" value="<%=s_component_type%>">
<input type="hidden" name="s_tests" value="">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="70%" border="0">
			<col width="50%"><col width="50%">
				<tr>
					<td id="eg_blankspace" height="15" nowrap colspan="2">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="2" width="100%" id="eg_whitebg" align="center" height="100%" valign="middle">
						<table align="center" cellspacing="0" cellpadding="0" width="55%" border="0" style="table-layout:auto">
							<tr>
								<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="6"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr>
								<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
								<td align="right" width="142" class="eg_subcontentbg" nowrap height="20" id="form_spacing"><strong>Component type</strong></td>
								<td width="5" class="eg_subcontentbg" id="form_spacing">&nbsp;:&nbsp;</td>
								<td class="eg_subcontentbg" id="form_spacing" style="padding-left:10px;">
									<select name="component_types" style='width:285px' onchange="javascript:changeComponentType(this.value);">
										<option value="-1" selected="true">Select a component type</option>

	<%
									EgName nameObj = null;
									ArrayList serverList = sorter.getSortedCompTypeList(componentTypes);
									for(int i=0;i<componentTypes.size();i++)
									{
										nameObj = (EgName)serverList.get(i);
										String componentType = nameObj.getActualName();
										String displayname = nameObj.getLocalName();
										if(componentType.startsWith("Agg_"))
											continue;
	%>
										<option value='<%=componentType%>' <%=(componentType.equalsIgnoreCase(s_component_type))?"selected":""%>>
											<%=displayname%>
											</option>
	<%
									}
	%>
									</select>
								</td>
								<td colspan="4" class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
							</tr>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg" width="100%" colspan="6" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
<%
if(!s_component_type.equals("-1"))
{
%>
				<tr>
					<td id="eg_blankspace" height="15" nowrap colspan="2">&nbsp;</td>
				</tr>
				<tr>
					<td>
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td colspan="3" width="100%" height="22">
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" id="eg_subcontentbg" height="22">
										<tr>
											<td id="subhead_left" width="7">
											<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
											<strong>
												Tests With Default Aggregate Support
											</strong>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td id="eg_subcontentbg"  width="100%" align="center" valign="top" colspan="3" class="form_spacing">
								<select name="addedTests" size="25" style="width:350px">
<%
								for(int i=0;i<aggSupportedTestList.size();i++)
								{
									EgName egName=(EgName)aggSupportedTestList.get(i);
									String actualName=egName.getActualName();
									String displayName=egName.getLocalName();
%>
									<option value='<%=actualName%>'><%=displayName%></option>
<%
								}
%>
								</select>
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" height="10" nowrap colspan="3" class="eg_subcontentbg">&nbsp;</td>
							</tr>
							<tr>
								<td height="6" class="inner_bott_left" width="7" > <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="1000px" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="eg_subcontentbg"  width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
					<td>
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td colspan="3" width="100%" height="22">
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" id="eg_subcontentbg" height="22">
										<tr>
											<td width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
											<strong>
												Tests Without Default Aggregate Support
											</strong>
											</td>
											<td id="subhead_right" width="7">
											<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td id="eg_subcontentbg"  width="1000px" align="center" valign="top" colspan="3" class="form_spacing">
								<select name="notAddedTests" size="25" style="width:350px">
<%
								for(int i=0;i<componentTestList.size();i++)
								{
									EgName egName=(EgName)componentTestList.get(i);
									String actualName=egName.getActualName();
									String displayName=egName.getLocalName();
									if(actualName.endsWith("_cf") || actualName.endsWith("_ex"))
									{
										continue;
									}
									allTestsAreAggregated = false;
%>
									<option value='<%=actualName%>'><%=displayName%></option>
<%
								}
%>
								</select>
								</td>
							</tr>
							<tr>
								<td id="eg_blankspace" height="10" nowrap colspan="3" class="eg_subcontentbg">&nbsp;</td>
							</tr>
							<tr>
								<td height="6"  width="7" id="eg_subcontentbg" > <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg" width="1000px" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" height="8" nowrap colspan="2"></td>
				</tr>
				<tr>
					<td align="center">
					<input type="button" value='MODIFY' style="width:120px;" class="eg_darkbutton" onClick="javascript:modifyDefaultAggTest()" <%=aggSupportedTestList.isEmpty()?"disabled":""%>>
					</td>
					<td align="center">
					<input type="button" name="deleteuser" value='ADD' style="width:120px;" class="eg_darkbutton" onClick="javascript:addDefaultAggTests()" <%=allTestsAreAggregated?"disabled":""%>>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" height="8" nowrap colspan="2">&nbsp;</td>
				</tr>
<%
}
%>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>



