<%@ page contentType="text/html;charset-UTF8" language="java" pageEncoding="UTF-8" %>
<%@ page errorPage="EgProbsM.jsp" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ taglib uri="../WEB-INF/eg-taglib.tld" prefix="egui" %>

<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import="com.egurkha.monitor.MonitorDAOFactory" %>
<%@ page import="com.egurkha.monitor.EgServerDashBoardDAO" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="com.egurkha.monitor.EgFusionChartUtil" %>

<%
	response.setHeader("Cache-Control","no-Store");
	response.setHeader("Pragma","no-Cache");
	response.setDateHeader("Expires",-1);
%>

<%
try
{
	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String tab=request.getParameter("tab");
	String blockType=request.getParameter("blockType");
	String test=request.getParameter("testName");
	String measure=request.getParameter("measureName");
	String defaultInfo=request.getParameter("defaultInfo");
	String selectedDate=request.getParameter("selectedDate");
	String selectedInterface=request.getParameter("selectedInterface");
	EgDbInfo dbinfo=new EgDbInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgDateInfo edi = new EgDateInfo();
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniobj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	MonitorDAOFactory factory=MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=factory.getServerDashBoardDAO();
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);

	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}


	String defaultMGraphDuration=iniobj.getValue("Default_MeasureGraph_Duration","duration");
	String FullViewPriority="TOP+-+10";
	String hostName="";
	String portNo="";
	String sid="";
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);

	if(blockType!=null && blockType.equals("areaChart"))
	{
		SimpleDateFormat sdf=new SimpleDateFormat("MM/dd/yyyy HH:mm");
		int[] timeFormat={1000*60*60,1000*60*60*24*7,1000*60*60*24*30};
		int passValue=1000*60*60;
		String title="";
		String startDateTime="";
		String endDateTime="";
		String s_en_time="";
		String s_st_time="";
		String s_st_hr = "";
		String s_en_hr="";
		String timeSelect="";
		if(selectedDate!=null && !selectedDate.equals(""))
		{
			selectedDate=selectedDate.toLowerCase();
			timeSelect=selectedDate.toLowerCase();
			int blankSpaceIndex = selectedDate.indexOf(DateTimeTokenizer.BLANK_SPACE);
			if (blankSpaceIndex > 0)
			{
				String titletmp=selectedDate;
				java.util.Date today = edi.egetRealDate();
				endDateTime=sdf.format(today);
				int value = Integer.parseInt(selectedDate.substring(0, blankSpaceIndex));
				String timelineUnit = selectedDate.substring(blankSpaceIndex+1).toLowerCase();
				if (timelineUnit.startsWith("h"))
				{//hours
					value *= 3600;
					title=titletmp;
				}
				else if (timelineUnit.startsWith("d"))
				{//days
					value *= (24 * 3600);
					title=titletmp;
				}
				else if (timelineUnit.startsWith("w"))
				{//weeks
					value *= (7 * 24 * 3600);
					title=titletmp;
				}
				else if (timelineUnit.startsWith("mo"))
				{//months
					//value *= (30 * 24 * 3600);
					value *=(24*(ErUtils.getMaxDaysInMonth()) * 3600);
					title=titletmp;
				}
				long longValue=value;
				java.util.Date start = edi.egetRealDate();
				start.setTime(today.getTime() - (longValue * 1000));
				startDateTime = sdf.format(start);
				if ((startDateTime != null) && (endDateTime != null))
				{
					int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
					int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
					s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
					s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
					s_st_hr = String.valueOf(shr);
					s_en_hr = String.valueOf(en_hr);
				}
			}
		}
		else
		{
			timeSelect="1 hour";
			java.util.Date endDate=edi.egetRealDate();
			endDateTime=sdf.format(endDate);
			java.util.Date startDate=edi.egetRealDate();
			startDate.setTime(endDate.getTime() - (3600 * 1000));
			startDateTime=sdf.format(startDate);
			if ((startDateTime != null) && (endDateTime != null))
			{
				int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
				int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
				s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_hr = String.valueOf(shr);
				s_en_hr = String.valueOf(en_hr);
			}
			title="1 hour";
		}
%>

<%
		String interfaceEntries = iniobj.getValue(compType,"Network_NetworkInterfaces_AreaCharts");
		if(interfaceEntries!=null && interfaceEntries.length() > 0)
		{
				String infosToArea=request.getParameter("infosToArea");
				StringBuffer tmpBuffer=new StringBuffer();
				if(infosToArea!=null && !infosToArea.equals(""))
				{
					StringTokenizer stt=new StringTokenizer(infosToArea,",");
					
					while(stt.hasMoreTokens())
					{
						String tok=stt.nextToken();
						tok=tok.trim();
						tok="+"+tok;
						tmpBuffer.append("'");
						tmpBuffer.append(tok);
						tmpBuffer.append("'");
						if(stt.hasMoreTokens())
							tmpBuffer.append(",");

					}
				}
				infosToArea=tmpBuffer.toString();
			StringTokenizer stoken=new StringTokenizer(interfaceEntries,",");


		double defaultTableWidth=950;
		double tableWidth=920;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);

			int count=0;
			boolean isFullView=false;
			ArrayList pieChartNAList = new ArrayList();
			while(stoken.hasMoreTokens())
			{
				String testMeasure=stoken.nextToken();
				String interface_test=testMeasure.substring(0,testMeasure.indexOf(":"));
				String interface_measure=testMeasure.substring(testMeasure.indexOf(":")+1);

				if(interface_measure.equals("Availability"))
					continue;

				String measureForDB=dbinfo.getColumnForMeasure(interface_test,interface_measure);
				String msmthost=(String)allMsmtHosts.get(interface_test);
				Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,interface_test,measureForDB,msmthost,dbinfo.getColumnForMeasure(interface_test,"Pct_bandwidth_used"),true,"");
				String info="";
				if(currentValues!=null && currentValues.size() >0)
				{
					for(int i=0;i<currentValues.size();i=i+2)
					{
						String currentInfo=(String)currentValues.get(i);
						currentInfo=com.egurkha.util.StringUtils.replace(currentInfo, "+", "*");
						if(currentValues.size()>1)
							info+=currentInfo+",";

						String value=(String)currentValues.get(0);
					}
				}
				String tableName = iniobj.getValue("Dashboard_GraphTitle_Mapping",testMeasure);
				String unit=tablesInfo.getUnitForMeasure(interface_test,interface_measure);
				String mappingName = iniobj.getValue("Dashboard_TableColumn_mapping",testMeasure);

				if(mappingName!=null && mappingName.equals(""))
				{
					mappingName="Band Width";
				}
				String s_layer=dashboardDAO.getLayerForTest(compType,interface_test,interface_measure);
//------------------newly added--------------------------------------//
				if(unit.equals("%"))
					unit="percent";

				Vector Infos=(Vector)allTestInfos.get(interface_test);
				String ddinfo="";
				if(Infos!=null && Infos.size()>0)
				{
					if(interface_test.equals("SystemTest") && Infos.contains("+Summary"))
					{
						ddinfo="+Summary";
					}
					else
					{
						ddinfo=(String)Infos.get(0);
					}
				}
				String areaGraphUrlLarge="";

				Vector chartAttributes=new Vector();
//				chartAttributes.add("caption='"+mappingName+" ("+unit+")'");
	//			chartAttributes.add("xAxisName='Time in  HH : mm'");
				chartAttributes.add("showValues='0'");
				chartAttributes.add("palette='0'");
				chartAttributes.add("bgColor='#FFFFFF'");
				chartAttributes.add("showBorder='0'");
				chartAttributes.add("staggerLines='3'");
				chartAttributes.add("numVDivLines='10'");
				chartAttributes.add("plotGradientColor=''");
				chartAttributes.add("numDivLines='10'");
				chartAttributes.add("adjustDiv='1'");
				chartAttributes.add("vDivLineIsDashed='1'");
				chartAttributes.add("legendShadow='1'");
				chartAttributes.add("legendPosition='RIGHT'");
				chartAttributes.add("vDivLineDashGap='10px'");
				chartAttributes.add("dashed='1'");
				chartAttributes.add("divLineIsDashed='1'");
				//chartAttributes.add("clickURL='javascript:areaChartOnClick(&apos;fusion"+count+"&apos;);'");

				String xml=fusionChart.getXMLDataForAreaChart(timeSelect,interface_test,interface_measure,mappingName,hostName,msmthost,chartAttributes,"",infosToArea,isFullView);
				int legendInfo_count=fusionChart.getInfoCountForLegend();
				if(infosToArea!=null && infosToArea.length()>0 && infosToArea.contains("+"))
				{
					String infosToChart= infosToArea.replace("+","plus ");
					areaGraphUrlLarge=response.encodeURL("/final/monitor/egDashBoardDDData.jsp?")+"host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+interface_test+"&measure="+interface_measure+"&module="+tab+"&width=880&height=320&from=fullview&timeSelect="+timeSelect+"&mode=3D&monitorSkin="+monitor_Skin+"&blockType="+blockType+"&mappingName="+mappingName+"&unit="+unit+"&msmt_host="+msmthost+"&fullview=true&priority="+FullViewPriority+"&infosToArea="+infosToChart+"&legendInfoCount="+legendInfo_count+"&display=false&fromInterface=true";
				}
				else
				{
					areaGraphUrlLarge=response.encodeURL("/final/monitor/egDashBoardDDData.jsp?")+"host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+interface_test+"&measure="+interface_measure+"&module="+tab+"&width=880&height=220&from=fullview&timeSelect="+timeSelect+"&mode=3D&monitorSkin="+monitor_Skin+"&blockType="+blockType+"&mappingName="+mappingName+"&msmt_host="+msmthost+"&fullview=true&priority="+FullViewPriority+"&infosToArea="+infosToArea+"&legendInfoCount="+legendInfo_count+"&display=false&fromInterface=true";
				}
				if(xml!=null && !xml.equals(""))
				{

%>
				<div class="eg_cell  bglight" style="display:block;visibility:visible;width:100%;height:20px">
					<p  style="text-align:center;padding:4px 4px 0px 4px;margin:0px" class="eg_75bold"><egui:intnl text="<%=mappingName%>"/>(<egui:intnl text="<%=unit%>"/>)</p>
				</div>
				<div class="eg_8bold eg_whitebg" align="center" style="display:inline-block;padding:0px 4px 4px 4px ;">
					<div style="float:left;">

					<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=tableWidth%>" height="245" id="StackedColumn3D" >
					<param name="movie" value="/final/FusionCharts/swf/MSArea.swf" />
					<param name="FlashVars" value="&dataXML=<%=xml%>&chartWidth=<%=tableWidth%>&chartHeight=225">
					<param name="quality" value="high" />
					<param name="WMode" value="Transparent">
					<embed wmode="transparent" src="/final/FusionCharts/swf/MSArea.swf" flashVars="&dataXML=<%=xml%>" quality="high" width="<%=tableWidth%>" height="225" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
					</object> -->

					<div id="chartMSAreaContainer<%=count%>"  style="height:100%;"></div>
					<script type="text/javascript">
						if  ( FusionCharts( "myMSAreaChartId<%=count%>" ) )
								FusionCharts( "myMSAreaChartId<%=count%>" ).dispose();
						var myChart = new FusionCharts( "/final/FusionCharts/swf/MSArea.swf","myMSAreaChartId<%=count%>", "<%=tableWidth%>", "225","0","1");
						myChart.setXMLData("<%=xml%>");
						myChart.setTransparent(true);
						myChart.render("chartMSAreaContainer<%=count%>");
					</script>

					</div>
					<div style="float:right;" valign="top">
						<a  onclick="javascript:areaChartOnClick('fusion<%=count%>');" href="javascript:void(0);"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png" border="0" /></a>
					</div>
				</div>
				<br/><br/>
<%
				}
				else
				{
					pieChartNAList.add(mappingName+" ("+unit+")");
				}
%>
				<input type="Hidden" id="fusion<%=count%>" value="<%=areaGraphUrlLarge%>"/>
<%
			count++;
			}
			if(pieChartNAList.size() > 0)
			{
				if(pieChartNAList.size()==count)
				{
%>
					<table width="100%" height="100%" border="0"  cellspacing="0px">
						<tr>
							<td align="center" valign="middle" class="eg_whitebg">
								<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.No Measures Available" />
							</td>
						</tr>
					</table>
<%
				}
			}
		}
%>

<%
	}
}
catch(Exception e)
{
	e.printStackTrace();
}
%>

