<%
/*******************************1/21/20116/3/2010*************************************************
FileName	:egDesignDashboard.jsp
Purpose		:User can design the dashboard using the tools. Some codes are duplicated in jsp and in javascript for the fast development of Dashboard.
Created by	:Simeon.D
Created on	:22/11/2009
GUI Changed by	:Vijay\Jaiwin
**********************************************************************************/
%>
<%@ include file="EgLoginTracker.jsp"%>
<%@ page errorPage="EgProbsM.jsp"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
try
{
//	System.out.println("Custom Design Page Starts");
	ErUtils erutils=new  ErUtils();
	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	EgServerDashboardModel egDashboard=new EgServerDashboardModel();
	EgCustomDashboardModel egCustomDashboard=new EgCustomDashboardModel();
	egDashboard.setUser(u_ser);	
	String profileName=request.getParameter("profileName");
	String queryString=request.getQueryString();
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniObj = new IniFile(s_iniFile_dir+"eg_customdashboard.ini");
	IniFile mappingIni = new IniFile(s_iniFile_dir+"eg_customdashboardTitleMapping.ini");
	String subject=u_ser.getLoginID()+"_multi_"+profileName;

	String uiFile = "eg_ui.ini";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isFirefox2 = ( ua != null && ua.indexOf( "Firefox2/" ) != -1 );
	boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );
	boolean isFirefox3 = ( ua != null && ua.indexOf( "Firefox3/" ) != -1 );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
	boolean isIE6=( ua != null && ua.indexOf("MSIE 6.0") != -1 );
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	ArrayList configureComparisonTables=new ArrayList();
	int maxDivID=0;
	Vector compTables=iniObj.getVariables(subject,true);
	if(compTables!=null && !compTables.isEmpty())
	{
		Iterator itrCompTables=compTables.iterator();
		while(itrCompTables.hasNext())
		{
			String varName=(String)itrCompTables.next();
			if(varName!=null && (!varName.startsWith("table_") || !varName.endsWith("_metrics")))
				continue;
			configureComparisonTables.add(varName);
			if(varName!=null && varName.indexOf("_")!=-1)
			{
				int divID=Integer.parseInt(varName.substring(varName.indexOf("_")+1,varName.lastIndexOf("_")));
				if(divID>maxDivID)
					maxDivID=divID;
			}
		}
	}
	ArrayList configurationBarChartTables=new ArrayList();
	int maxBarChartDivID=0;
	if(compTables!=null && !compTables.isEmpty())
	{
		Iterator itrCompTables=compTables.iterator();
		while(itrCompTables.hasNext())
		{
			String varName=(String)itrCompTables.next();
			if(varName!=null && (!varName.startsWith("BarChart_") || !varName.endsWith("_metrics")))
				continue;
			configurationBarChartTables.add(varName);
			if(varName!=null && varName.indexOf("_")!=-1)
			{
				int divID=Integer.parseInt(varName.substring(varName.indexOf("_")+1,varName.lastIndexOf("_")));
				if(divID>maxBarChartDivID)
					maxBarChartDivID=divID;
			}
		}
	}
	ArrayList configuredTimelineCharts=new ArrayList();
	int maxTimelineChartDivID=0;
	if(compTables!=null && !compTables.isEmpty())
	{
		Iterator itrCompTables=compTables.iterator();
		while(itrCompTables.hasNext())
		{
			String varName=(String)itrCompTables.next();
			if(varName!=null && (!varName.startsWith("TimelineChart_") || !varName.endsWith("_metrics")))
				continue;
			configuredTimelineCharts.add(varName);
			if(varName!=null && varName.indexOf("_")!=-1)
			{
				int divID=Integer.parseInt(varName.substring(varName.indexOf("_")+1,varName.lastIndexOf("_")));
				if(divID>maxTimelineChartDivID)
					maxTimelineChartDivID=divID;
			}
		}
	}
	ArrayList configuredCombinedTimelineCharts=new ArrayList();
	int maxCombinedTimelineChartDivID=0;
	if(compTables!=null && !compTables.isEmpty())
	{
		Iterator itrCompTables=compTables.iterator();
		while(itrCompTables.hasNext())
		{
			String varName=(String)itrCompTables.next();
			if(varName!=null && (!varName.startsWith("CombinedTimelineChart_") || !varName.endsWith("_metrics")))
				continue;
			configuredCombinedTimelineCharts.add(varName);
			if(varName!=null && varName.indexOf("_")!=-1)
			{
				int divID=Integer.parseInt(varName.substring(varName.indexOf("_")+1,varName.lastIndexOf("_")));
				if(divID>maxCombinedTimelineChartDivID)
					maxCombinedTimelineChartDivID=divID;
			}
		}
	}
	int divCount=0;
	double screenWidthDouble=1024.0;
	if(screenWidth!=null && !screenWidth.equals(""))
		screenWidthDouble=Double.parseDouble(screenWidth);

	double screenHeightDouble=768.0;
	if(screenHeight!=null && !screenHeight.equals(""))
		screenHeightDouble=Double.parseDouble(screenHeight);
	String settingSub="template_column";
	String rowSettings=iniObj.getValue(settingSub,"rows");
	String columnSettings=iniObj.getValue(settingSub,profileName+":"+u_ser.getLoginID());
	String blockWidth="50%";
	String barWidth="100%";
	String timelineWidth="600";
	int tableTitlelength=12;
	double currentColumns=2;
	if(columnSettings!=null && !columnSettings.equals(""))
	{
		currentColumns=Double.parseDouble(columnSettings);
		double blockWidthDouble=100/currentColumns;
		if (isMSIE)
		{ 
		blockWidth=erutils.round(blockWidthDouble-0.1,2)+"%";
		}
		else if(isChrome)
		{
			blockWidth=erutils.round(blockWidthDouble-0.6,2)+"%";
		}
		else
		{
			blockWidth=erutils.round(blockWidthDouble-0.5,2)+"%";
		}
		if(blockWidthDouble<=100)
		{
			tableTitlelength=(int)((48*blockWidthDouble)/100);
		}
		double barWidthDouble=(screenWidthDouble*blockWidthDouble)/100;
		barWidth="100%";
		timelineWidth=erutils.round((barWidthDouble-55),0);
	}
	String divPadding="";
	String divWidth="";
	if(isMSIE)
	{
		divWidth="100%";
		divPadding="6px";
	}
	else if(isChrome)
	{
		if(currentColumns==3)
		{
			divWidth="97.9%";
		}
		if(currentColumns==2)
		{
			divWidth="98.6%";
		}
		divPadding="6px";
	}
	else if(isFirefox)
	{
		if(currentColumns==3)
		{
			divWidth="97.8%";
		}
		if(currentColumns==2)
		{
			divWidth="98.5%";
		}
		divPadding="6px";
	}
	else 
	{
		if(currentColumns==3)
		{
			divWidth="97.8%";
		}
		if(currentColumns==2)
		{
			divWidth="98.6%";
		}
		divPadding="6px";
	}
%>
<html>
<head>
<egui:skin ui="monitor"/>
<script language="javascript" src="/final/monitor/eg_scripts/eg_validate.js"></script>
<script src="/final/monitor/eg_scripts/eg_date.js"></script>
<script src="/final/monitor/eg_scripts/prototype-1.6.0.3.js" type="text/javascript"></script>
<script src="/final/monitor/eg_scripts/scriptaculous.js" type="text/javascript"></script>
<script language="javascript">
	/*---------------------------- Browser Height and Width(IE, Mozilla, Chrome) START----------------------*/
documentView ={
			getObject: function()
			{
				if(typeof( window.innerWidth) == 'number')
				{//Firefox
					this.height = window.innerHeight;
					this.width = window.innerWidth-10;
					this.fireFox = true;
				}
				else if( document.documentElement && ( document.documentElement.clientWidth
					|| document.documentElement.clientHeight ))
				{//IE 6 + in 'standards compliant mode'
					this.height = document.documentElement.clientHeight;
					this.width = document.documentElement.clientWidth;
					this.ie = true;
				}
				else if(document.body && document.body.clientHeight)
				{ //IE 4 compatible
					this.height = document.body.clientHeight;
					this.width = document.body.clientWidth;
					this.ie = true;
				}
				this.screenHeight=window.screen.availHeight;
				this.screenWidth=window.screen.availWidth;
				return this;
			},
			getScreenHeight: function()
			{
				return this.getObject().screenHeight;
			},
			getScreenWidth: function()
			{
				return this.getObject().screenWidth;
			},
			getHeight: function()
			{
				return this.getObject().height;
			},
			getWidth: function()
			{
				return this.getObject().width;
			},
			isIE: function()
			{
					return this.getObject().ie;
			},
			isFireFox: function()
			{
					return this.getObject().fireFox;
			}
	};
/*---------------------------- Browser Height and Width(IE, Mozilla, Chrome) END----------------------*/
	var fromCustomModify=false;
	var fromCustomBarChartModify=false;
	var fromCustomTimelineChartModify=false;
	var fromCustomCombinedTimelineChartModify=false;
	var addedMetricCount=0;
	var addedBarChartMetricCount=0;
	var addedTimelineChartMetricCount=0;
	var ComparisonTableStr="ComparisonTable";
	var BarChartStr="BarChart";
	var TimelineChartStr="TimelineChart";
	var CombinedTimelineChartStr="CombinedTimelineChart";
	var thresholdFlag="";
	var divCount=0;
	var upDateingDivId=0;
	var upDateingBarChartDivId=0;
	var upDateingTimelineChartDivId=0;
	var upDateingCombinedTimelineChartDivId=0;
	var titleLength='<%=tableTitlelength%>';
	var existingSelectBoxTestsForPopup=new Array();
	var existingSelectBoxMeasuresForPopup=new Array();
	var existingMetricDisplayNamesForPopup=new Array();
	var existingAddMeasures="";
	var isRemoveDivMethd = true;
	var ans = true;
	var divIdForUpDate = '';
	function hideElement(elmentId)
	{
		cleanUpScriptVariables();
		var element=document.getElementById(elmentId);
		if(element!=null)
			element.style.display="none";
	}
	function cleanUpScriptVariables()
	{
		thresholdFlag=""
		addedMetricCount=0;
		addedBarChartMetricCount=0;
		addedTimelineChartMetricCount=0;
		existingSelectBoxTestsForPopup=new Array();
		existingSelectBoxMeasuresForPopup=new Array();
		existingMetricDisplayNamesForPopup=new Array();
		existingAddMeasures="";
	}
	function BacktoList()
	{
		var iniUrl='<%=response.encodeURL("/final/monitor/egCustomHome.jsp?")%>';
		window.location.href=iniUrl;
	}
	function showElement(elmentId)
	{
		var element=document.getElementById(elmentId);
		if(element!=null)
			element.style.display="block";
	}
	function showToolBox()
	{
		var toolsImg=document.getElementById("toolsImg");
		var toolsDiv=document.getElementById("toolsDiv");
		var iconbg=document.getElementById("iconBg");
		if(toolsImg!=null && toolsDiv!=null && iconbg!=null)
		{
			toolsDiv.style.display="block";
			toolsImg.src="/final/monitor/eg_images/spacer.gif";
			iconbg.style.display="none";
		}
	}
	function hideToolBox()
	{
		var toolsImg=document.getElementById("toolsImg");
		var toolsDiv=document.getElementById("toolsDiv");
		var iconbg=document.getElementById("iconBg");
		if(toolsImg!=null && toolsDiv!=null && iconbg!=null)
		{
			toolsDiv.style.display="none";
			toolsImg.src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_custom_toolbox.png";
			iconbg.style.display="block";
		}
	}
	function GetXmlHttpObject()
	{
		var xmlHttp=null;
		try
		{
			// Firefox, Opera 8.0+, Safari
			xmlHttp=new XMLHttpRequest();
		}
		catch (e)
		{
			// Internet Explorer
			try
			{
				xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");
			}
			catch (e)
			{
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");
			}
		}
		return xmlHttp;
	}
	var propertyLeft=50;
	var propertyTop=100;
	function loadPropertyPage(url,divId,event,from)
	{
		url=url+"&cache="+(new Date()).getTime();
		var propertyDiv=document.getElementById("propertyDiv");
		var showInMousePosition=false;
		var idObj =document.getElementById(divId);
		event=(isIE())?window.event:event;
		if(propertyDiv!=null)
		{
			propertyDiv.style.display="block";
			propertyDiv.style.left=propertyLeft;
			propertyDiv.style.top=propertyTop;
		}
		var xmlHttp=GetXmlHttpObject();
		if (xmlHttp==null)
			return;
		xmlHttp.onreadystatechange = function ()
		{
			if(divId!=null && divId!="addedMetricsDiv")
			{
				if(idObj!=null && idObj!="undefined")
				{
				idObj.innerHTML = '<table height="500px" width="100%"><tr><td height="500px" align=center valign="middle"><img src="/final/monitor/eg_images/indicator_medium.gif"></td></tr></table>';
				}
			}
			if (xmlHttp.readyState==4)
			{
				if (xmlHttp.status == 200)
				{
					var response=xmlHttp.responseText;
					try
					{
						if(divId!=null && divId=="addedMetricsDiv")
						{
							if(idObj!=null && idObj!="undefined")
							{
							idObj.innerHTML+=response;
							}
							if(isFireFox())
							{
							loadExistingMetricPopupSelectBoxValues();
							}
						}
						else
						{
							if(idObj!=null && idObj!="undefined")
							{
							idObj.innerHTML=response;
							}
						}
					}
					catch(e)
					{
						alert("e--->"+e.description);
					}
				}
			}
		}
		xmlHttp.open("POST",url,true);
		xmlHttp.send(null);
	}
	function loadExistingMetricPopupSelectBoxValues()
	{
		if(existingSelectBoxTestsForPopup!=null && existingSelectBoxTestsForPopup.length>0)
		{
			for(var s=0;s<existingSelectBoxTestsForPopup.length;s++)
			{
				var selectedTest=existingSelectBoxTestsForPopup[s];
				var selectedMeasure=existingSelectBoxMeasuresForPopup[s];
				var metricDisplayName=existingMetricDisplayNamesForPopup[s];
				var test=document.getElementById("testList"+s);
				var measure=document.getElementById("measureList"+s);
				var metricIDName=document.getElementById("metricIDName"+s);
				if(test!=null && test!="undefined")
				{
					test.options[selectedTest].selected=true;
				}
				if(measure!=null && measure!="undefined")
				{
					measure.options[selectedMeasure].selected=true;
				}
				if(metricIDName!=null && metricIDName!="undefined")
				{
					metricIDName.value=metricDisplayName;
				}
			}
		}
	}
	function isIE()
	{
		var ver = navigator.appVersion;
		ver = ver.toLowerCase();
		if (ver.indexOf("msie ") > 0 || document.all)
			return true;
		else
			return false;
	}
	function isFireFox()
	{
		if (isIE())
			return false;
		else
			return true;
	}
	var startX=0;
	var startY=0;
	var dragStarted=false;
	var dragDiv;

	function startDrag(divId,event)
	{
		dragDiv=document.getElementById(divId);

		document.body.style.cursor="move";
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event=window.event;
		}
		if(dragDiv!=null)
		{
			startX=event.clientX-parseInt(dragDiv.style.left);
			startY=event.clientY-parseInt(dragDiv.style.top);
		}
		dragStarted=true;
	}

	function drag(event)
	{
		var iframe1=document.getElementById("iframe1");
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event=window.event;
		}
		if(dragStarted)
		{
			if(dragDiv!=null)
			{
				dragDiv.style.left=event.clientX-startX;
				dragDiv.style.top=event.clientY-startY;
				iframe1.style.left=event.clientX-startX;
				iframe1.style.top=event.clientY-startY;
			}
		}
	}

	function endDrag(event)
	{
		document.body.style.cursor="default";
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event=window.event;
		}
		startX=0;
		startY=0;
		dragStarted=false;
	}
	function updateIniFile(url)
	{
		return updateIniFile(url,"");
	}
	function updateIniFile(url,from)
	{
		url=url+"&cache="+(new Date()).getTime();
		var xmlHTTP=GetXmlHttpObject();
		if(xmlHTTP!=null)
		{
			xmlHTTP.onreadystatechange = function ()
			{
				if(xmlHTTP.readyState==4)
				{
					if(xmlHTTP.status == 200)
					{
						if(from!=null && (from=="compTable" || from=="reloadAssociatedComponents"))
						{
							var designURL='<%=response.encodeURL("/final/monitor/egCustomComparisonTableDesign.jsp?")%>'+"profileName=<%=profileName%>&savedTable="+fromCustomModify+"&tableID=table_"+upDateingDivId;
							loadComparisonTableDesign(designURL,'contentDiv'+upDateingDivId,'event',from);
							
							if(from!=null && from=="reloadAssociatedComponents")
							{
								loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?from=ComparisonTable&action=reloadAssociatedComponents&profileName="+profileName)%>&tableID=table_'+upDateingDivId+'&savedTable='+fromCustomModify,"reloadAssociatedComponents",'event',"compTable");
							}
							fromCustomModify=false;
						}
						else if(from!=null && (from=="BarChart" || from=="reloadBarAssociatedComponents"))
						{
							var designURL='<%=response.encodeURL("/final/monitor/egCustomBarChartTableDesign.jsp?")%>'+"profileName=<%=profileName%>&savedBarChart="+fromCustomBarChartModify+"&barChartID=BarChart_"+upDateingBarChartDivId;
							loadComparisonTableDesign(designURL,'contentBarChartDiv'+upDateingBarChartDivId,'event',from);
							if(from!=null && from=="reloadBarAssociatedComponents")
							{
								loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?from=BarChart&action=reloadBarAssociatedComponents&profileName="+profileName)%>&barChartID=BarChart_'+upDateingBarChartDivId+'&savedBarChart='+fromCustomBarChartModify,"reloadBarAssociatedComponents",'event',"BarChart");
							}
							fromCustomBarChartModify=false;
						}
						else if(from!=null && (from=="TimelineChart" || from=="CombinedTimelineChart") ||  (from=="reloadTimelineAssociatedComponents" || from=="reloadCombinedTimelineAssociatedComponents"))
						{
							if(from=="CombinedTimelineChart" || from=="reloadCombinedTimelineAssociatedComponents")
							{
								var designURL='<%=response.encodeURL("/final/monitor/egCustomTimelineChartTableDesign.jsp?")%>'+"&from=CombinedTimelineChart&profileName=<%=profileName%>&savedTimelineChart="+fromCustomCombinedTimelineChartModify+"&combinedTimelineChartID=CombinedTimelineChart_"+upDateingCombinedTimelineChartDivId;
								loadComparisonTableDesign(designURL,'contentCombinedTimelineChartDiv'+upDateingCombinedTimelineChartDivId,'event',from);
								if(from!=null && from=="reloadCombinedTimelineAssociatedComponents")
								{
									loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?from=CombinedTimelineChart&action=reloadTimelineAssociatedComponents&profileName="+profileName)%>&combinedTimelineChartID=CombinedTimelineChart_'+upDateingCombinedTimelineChartDivId+'&savedTimelineChart='+fromCustomCombinedTimelineChartModify,"reloadTimelineAssociatedComponents",'event',"TimelineChart");
								}
								fromCustomCombinedTimelineChartModify=false;
							}
							else
							{
								var designURL='<%=response.encodeURL("/final/monitor/egCustomTimelineChartTableDesign.jsp?")%>'+"profileName=<%=profileName%>&savedTimelineChart="+fromCustomTimelineChartModify+"&timelineChartID=TimelineChart_"+upDateingTimelineChartDivId;
								loadComparisonTableDesign(designURL,'contentTimelineChartDiv'+upDateingTimelineChartDivId,'event',from);
								if(from!=null && from=="reloadTimelineAssociatedComponents")
								{
									loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?from=TimelineChart&action=reloadTimelineAssociatedComponents&profileName="+profileName)%>&timelineChartID=TimelineChart_'+upDateingTimelineChartDivId+'&savedTimelineChart='+fromCustomTimelineChartModify,"reloadTimelineAssociatedComponents",'event',"TimelineChart");
								}
								fromCustomTimelineChartModify=false;
							}
							
						}
						else if(from!=null && (from=="emptyComparisonTableConfig" || from=="emptyBarChartConfig" || from=="emptyTimelineChartConfig" || from=="emptyCombinedTimelineChartConfig"))
						{
							if(from=="emptyComparisonTableConfig")
							{
								isRemoveDivMethd = false;
								removeTable(upDateingDivId);
							}
							else if(from=="emptyBarChartConfig")
							{
								isRemoveDivMethd = false;
								removeBarChart(upDateingBarChartDivId);
							}
							else if(from=="emptyTimelineChartConfig")
							{
								isRemoveDivMethd = false;
								removeTimelineChart(upDateingTimelineChartDivId,"TimelineChart");
							}
							else if(from=="emptyCombinedTimelineChartConfig")
							{
								isRemoveDivMethd = false;
								removeTimelineChart(upDateingCombinedTimelineChartDivId,"CombinedTimelineChart");
							}
						}
						xmlHTTP=null;
					}
				}
			}
			xmlHTTP.open("POST",url,true);
			xmlHTTP.send(null);
		}
	}
	function init()
	{
		myResize();
	}
	function myResize()
	{
		var contentDiv=document.getElementById("contentDiv");
		if(contentDiv!=null)
		{
			contentDiv.style.height=document.body.clientHeight-30;
		}
	}
	window.onresize = myResize;	
	function timeSelect(savedTable,blockType)
	{
		var time_lineObj=document.getElementById("time_line");
		var start_time=document.getElementById("starttime").value;
		var end_time=document.getElementById("endtime").value;
		var start_hrObj=document.getElementById("starthr");
		var end_hrObj=document.getElementById("endhr");
		var start_hr=start_hrObj.options[start_hrObj.selectedIndex].value;
		var end_hr=end_hrObj.options[end_hrObj.selectedIndex].value;
		var ssdate = formatDate(new Date(getDateFromFormat(start_time,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		var eedate = formatDate(new Date(getDateFromFormat(end_time,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		var timeline="";
		if(time_lineObj!=null && time_lineObj!="undefined")
			timeline=time_lineObj.value;
		if (!checktime(ssdate,eedate,start_hrObj,end_hrObj) && time_line=='Any')
		{
			document.getElementById("starttime").value=endtime;
			alert('<egui:intnl text="monitor.common.Start date should be lesser than end date"/>');
			return;
		}
		var selectedCompType=document.getElementById("compTypeList");
		var selectedType="";
		if(selectedCompType!=null)
		selectedType=selectedCompType.value;
		
		var url1='<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?profileName="+profileName)%>&action=addRows&selectedComponentType='+encodeURIComponent(selectedType);
		if(blockType!=null && blockType==CombinedTimelineChartStr)
		{
			url1=url1+'&from=CombinedTimelineChart&combinedTimelineChartID=CombinedTimelineChart_'+upDateingCombinedTimelineChartDivId;
		}
		else
		{
			url1=url1+'&from=TimelineChart&timelineChartID=TimelineChart_'+upDateingTimelineChartDivId;
		}
		var paramValue="&time_line="+timeline+"&start_time="+start_time+"&end_time="+end_time+"&start_hr="+start_hr+"&end_hr="+end_hr;
		url1=url1+paramValue;
		if(savedTable!=null && savedTable!="")
			url1=url1+"&savedTimelineChart="+savedTable;
		loadPropertyPage(url1,'propertyContentDiv');
	}
	function checkwindow2(datef,event)
	{
		var datefv1=document.getElementById(datef);
		var dateVal="";
		if(datefv!=null && datefv!="undefined")
			dateVal=datefv1.value;
		event=event?event:window.event;
		var datefv = formatDate(new Date(getDateFromFormat(dateVal,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		var screenname="MultiCustomDashboard";
		callcalendar3(datefv1,datefv,event,screenname);
	}
	function loadMeasuresForSelectedTableTest(testslectBoxID,measureSelectBoxID,blockType)
	{
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			var selectedTest = document.getElementById(testslectBoxID).value;
			var url1='<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?from=ComparisonTable")%>'+"&action=loadMeasuresForTest&selectedTest="+selectedTest+"&measureSelectBoxID="+measureSelectBoxID;
			loadPropertyPage(url1,"measureDiv"+measureSelectBoxID,'event',"compTable");
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			var selectedTest = document.getElementById(testslectBoxID).value;
			var url1='<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?from=BarChart")%>'+"&action=loadMeasuresForTest&selectedTest="+selectedTest+"&measureSelectBoxID="+measureSelectBoxID;
			loadPropertyPage(url1,"measureDiv"+measureSelectBoxID,'event',"BarChart");
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var selectedTest = document.getElementById(testslectBoxID).value;
			var url1='<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?")%>'+"&action=loadMeasuresForTest&selectedTest="+selectedTest+"&measureSelectBoxID="+measureSelectBoxID;
			if(blockType==CombinedTimelineChartStr)
			{
				url1=url1+"&from=CombinedTimelineChart";
			}
			else
			{
				url1=url1+"&from=TimelineChart";
			}
			loadPropertyPage(url1,"measureDiv"+measureSelectBoxID,'event',"TimelineChart");
		}
	}
	function measureOnChangeinTable(measureSelectBoxID)
	{
		var metricIDNameTextObj=document.getElementById("metricIDName"+measureSelectBoxID);
		var measureSelect=document.getElementById("measureList"+measureSelectBoxID);
		var testList=document.getElementById("testList"+measureSelectBoxID);
		if(measureSelect.value!="")
		{
			var existingTableMeasures="";
			var configuredTestMeasures=document.getElementById("existingTableMeasures");
			if(configuredTestMeasures!=null && configuredTestMeasures!="")
				existingTableMeasures=configuredTestMeasures.value;
			var mEntry=testList.value+":"+measureSelect.value;
			if(metricIDNameTextObj!=null && metricIDNameTextObj!="undefined")
			{
				metricIDNameTextObj.value=measureSelect.options[measureSelect.options.selectedIndex].text;
			}
			existingAddMeasures=existingAddMeasures+","+mEntry;
		}
		
	}
	function removeValues(imgID)
	{
		var metricTRRow=document.getElementById(("metricTR"+imgID));
		if(metricTRRow!=null && metricTRRow!="undefined")
		{
			metricTRRow.cells[0].innerHTML="";
			metricTRRow.cells[1].innerHTML="";
			metricTRRow.cells[2].innerHTML="";
			metricTRRow.style.display="none";
		}
	}
	function setThreshold(flag)
	{
		thresholdFlag=flag;
	}
	function selectCompsForType(savedTable,param,blockType)
	{
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			var selectedCompType=document.getElementById("compTypeList");
			var selectedType="";
			if(selectedCompType!=null)
				selectedType=selectedCompType.value;
			if(selectedType=="null" || selectedType=="")
			{
				alert('<egui:intnl text="admin.test.Please select a component type"/>');
				return;
			}
			if(param!=null && param=="addRows")
			{
				var url1='<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?profileName="+profileName)%>&from=ComparisonTable&action=addRows&selectedComponentType='+encodeURIComponent(selectedType)+'&tableID=table_'+upDateingDivId;
			}
			else if(param!=null && param=="modify")
			{
				var url1='<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?profileName="+profileName)%>&from=ComparisonTable&action=modify&selectedComponentType='+encodeURIComponent(selectedType)+'&tableID=table_'+upDateingDivId;
			}
			if(savedTable!=null && savedTable!="")
				url1=url1+"&savedTable="+savedTable;
			loadPropertyPage(url1,'propertyContentDiv');
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			var selectedCompType=document.getElementById("compTypeList");
			var selectedType="";
			if(selectedCompType!=null)
				selectedType=selectedCompType.value;
			if(selectedType=="null" || selectedType=="")
			{
				alert('<egui:intnl text="admin.test.Please select a component type"/>');
				return;
			}
			if(param!=null && param=="addRows")
			{
				var url1='<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?profileName="+profileName)%>&from=BarChart&action=addRows&selectedComponentType='+encodeURIComponent(selectedType)+'&barChartID=BarChart_'+upDateingBarChartDivId;
			
			}
			else if(param!=null && param=="modify")
			{
				var url1='<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?profileName="+profileName)%>&from=BarChart&action=modify&selectedComponentType='+encodeURIComponent(selectedType)+'&barChartID=BarChart_'+upDateingBarChartDivId;
			}
			if(savedTable!=null && savedTable!="")
				url1=url1+"&savedBarChart="+savedTable;
			loadPropertyPage(url1,'propertyContentDiv');
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var selectedCompType=document.getElementById("compTypeList");
			var selectedType="";
			if(selectedCompType!=null)
				selectedType=selectedCompType.value;
			var url="";
			if(selectedType=="null" || selectedType=="")
			{
				alert('<egui:intnl text="admin.test.Please select a component type"/>');
				return;
			}
			if(param!=null && param=="addRows")
			{
				url='<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?profileName="+profileName)%>&action=addRows&selectedComponentType='+encodeURIComponent(selectedType);
				if(blockType==CombinedTimelineChartStr)
				{
					var time_lineObj=document.getElementById("time_line");
					var start_time=document.getElementById("starttime").value;
					var end_time=document.getElementById("endtime").value;
					var start_hrObj=document.getElementById("starthr");
					var end_hrObj=document.getElementById("endhr");
					var start_hr=start_hrObj.options[start_hrObj.selectedIndex].value;
					var end_hr=end_hrObj.options[end_hrObj.selectedIndex].value;
					var timeline="";
					if(time_lineObj!=null && time_lineObj!="undefined")
						timeline=time_lineObj.value;

					url=url+'&from=CombinedTimelineChart&combinedTimelineChartID=CombinedTimelineChart_'+upDateingCombinedTimelineChartDivId+"&time_line="+timeline+"&start_time="+start_time+"&end_time="+end_time+"&start_hr="+start_hr+"&end_hr="+end_hr;
				}
				else
				{
					var time_lineObj=document.getElementById("time_line");
					var start_time=document.getElementById("starttime").value;
					var end_time=document.getElementById("endtime").value;
					var start_hrObj=document.getElementById("starthr");
					var end_hrObj=document.getElementById("endhr");
					var start_hr=start_hrObj.options[start_hrObj.selectedIndex].value;
					var end_hr=end_hrObj.options[end_hrObj.selectedIndex].value;
					var timeline="";
					if(time_lineObj!=null && time_lineObj!="undefined")
						timeline=time_lineObj.value;

					url=url+'&from=TimelineChart&timelineChartID=TimelineChart_'+upDateingTimelineChartDivId+"&time_line="+timeline+"&start_time="+start_time+"&end_time="+end_time+"&start_hr="+start_hr+"&end_hr="+end_hr;
				}
			}
			else if(param!=null && param=="modify")
			{
				url='<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?profileName="+profileName)%>&action=modify&selectedComponentType='+encodeURIComponent(selectedType);
				if(blockType==CombinedTimelineChartStr)
				{
					url=url+'&from=CombinedTimelineChart&combinedTimelineChartID=CombinedTimelineChart_'+upDateingCombinedTimelineChartDivId;
				}
				else
				{
					url=url+'&from=TimelineChart&timelineChartID=TimelineChart_'+upDateingTimelineChartDivId;
				}
			}
			if(savedTable!=null && savedTable!="")
				url=url+"&savedTimelineChart="+savedTable;
			loadPropertyPage(url,'propertyContentDiv');
		}
	}
	function loadColumnPopup(divId,event,from,blockType)
	{
		cleanUpScriptVariables();
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			fromCustomModify=from;
			upDateingDivId=divId;
			var savedConfig="false";
			if(from!=null && from==true)
			{
				savedConfig="true";
			}	loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?from=ComparisonTable&action=loadMetricsPopup&profileName="+profileName)%>&savedTable='+savedConfig+'&tableID=table_'+divId,"propertyContentDiv",'event','compTable');
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			fromCustomBarChartModify=from;
			upDateingBarChartDivId=divId;
			var savedConfig="false";
			if(from!=null && from==true)
			{
				savedConfig="true";
			}	loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?from=BarChart&action=loadMetricsPopup&profileName="+profileName)%>&savedBarChart='+savedConfig+'&barChartID=BarChart_'+divId,"propertyContentDiv",'event','BarChart');
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var savedConfig="false";
			if(from!=null && from==true)
			{
				savedConfig="true";
			}
			if(blockType==CombinedTimelineChartStr)
			{
				fromCustomCombinedTimelineChartModify=from;
				upDateingCombinedTimelineChartDivId=divId;
				loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?from=CombinedTimelineChart&action=loadMetricsPopup&profileName="+profileName)%>&savedTimelineChart='+savedConfig+'&combinedTimelineChartID=CombinedTimelineChart_'+divId,"propertyContentDiv",'event','TimelineChart');
			}
			else
			{
				fromCustomTimelineChartModify=from;
				upDateingTimelineChartDivId=divId;
				loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?from=TimelineChart&action=loadMetricsPopup&profileName="+profileName)%>&savedTimelineChart='+savedConfig+'&timelineChartID=TimelineChart_'+divId,"propertyContentDiv",'event','TimelineChart');
			}
			
		}
	}
	function showModify(savedConfiguration,blockType)
	{
		var savedConfig="false";
		if(savedConfiguration!=null && savedConfiguration=="true")
		{
			savedConfig="true";
		}
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			if(savedConfig!=null && savedConfig=="true")
				fromCustomModify=true;
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?from=ComparisonTable&action=modify&profileName="+profileName)%>&tableID=table_'+upDateingDivId+"&savedTable="+savedConfig,"propertyContentDiv",'event','compTable');
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			if(savedConfig!=null && savedConfig=="true")
					fromCustomBarChartModify=true;
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?from=BarChart&action=modify&profileName="+profileName)%>&barChartID=BarChart_'+upDateingBarChartDivId+"&savedBarChart="+savedConfig,"propertyContentDiv",'event','BarChart');
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			if(blockType==CombinedTimelineChartStr)
			{
				if(savedConfig!=null && savedConfig=="true")
					fromCustomCombinedTimelineChartModify=true;
				loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?from=CombinedTimelineChart&action=modify&profileName="+profileName)%>&combinedTimelineChartID=CombinedTimelineChart_'+upDateingCombinedTimelineChartDivId+"&savedTimelineChart="+savedConfig,"propertyContentDiv",'event','TimelineChart');
			}
			else
			{
				if(savedConfig!=null && savedConfig=="true")
					fromCustomTimelineChartModify=true;
				loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?from=TimelineChart&action=modify&profileName="+profileName)%>&timelineChartID=TimelineChart_'+upDateingTimelineChartDivId+"&savedTimelineChart="+savedConfig,"propertyContentDiv",'event','TimelineChart');
			}
		}
	}
	function getDisplayName(savedTable,blockType)
	{
		var savedConfig="false";
		if(savedTable!=null && savedTable!="")
			savedConfig=savedTable;
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			var cmpNameListObj=document.getElementById("compName");
			var selectedCompType=document.getElementById("compTypeList").value;
			var cmpName="";
			if(cmpNameListObj!=null && cmpNameListObj!="undefined")
			{
				cmpName=cmpNameListObj.value;
			}	loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?from=ComparisonTable&action=modify&profileName="+profileName)%>&selectedComponentType='+encodeURIComponent(selectedCompType)+'&compName='+encodeURIComponent(cmpName)+'&selectedComponents='+encodeURIComponent(cmpName)+'&cmp_dispName='+encodeURIComponent(cmpName)+'&tableID=table_'+upDateingDivId+"&savedTable="+savedConfig,"propertyContentDiv",'event','compTable');
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			var cmpNameListObj=document.getElementById("compName");
			var selectedCompType=document.getElementById("compTypeList").value;
			var cmpName="";
			if(cmpNameListObj!=null && cmpNameListObj!="undefined")
			{
				cmpName=cmpNameListObj.value;
			}	loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?from=BarChart&action=modify&profileName="+profileName)%>&selectedComponentType='+encodeURIComponent(selectedCompType)+'&compName='+encodeURIComponent(cmpName)+'&selectedComponents='+encodeURIComponent(cmpName)+'&cmp_dispName='+encodeURIComponent(cmpName)+'&barChartID=BarChart_'+upDateingBarChartDivId+"&savedBarChart="+savedConfig,"propertyContentDiv",'event','BarChart');
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var cmpNameListObj=document.getElementById("compName");
			var selectedCompType=document.getElementById("compTypeList").value;
			var cmpName="";
			if(cmpNameListObj!=null && cmpNameListObj!="undefined")
			{
				cmpName=cmpNameListObj.value;
			}
			if(blockType==CombinedTimelineChartStr)
			{
				loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?from=CombinedTimelineChart&action=modify&profileName="+profileName)%>&selectedComponentType='+encodeURIComponent(selectedCompType)+'&compName='+encodeURIComponent(cmpName)+'&selectedComponents='+encodeURIComponent(cmpName)+'&cmp_dispName='+encodeURIComponent(cmpName)+'&combinedTimelineChartID=CombinedTimelineChart_'+upDateingCombinedTimelineChartDivId+"&savedTimelineChart="+savedConfig,"propertyContentDiv",'event','TimelineChart');
			}
			else
			{
				loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?from=TimelineChart&action=modify&profileName="+profileName)%>&selectedComponentType='+encodeURIComponent(selectedCompType)+'&compName='+encodeURIComponent(cmpName)+'&selectedComponents='+encodeURIComponent(cmpName)+'&cmp_dispName='+encodeURIComponent(cmpName)+'&timelineChartID=TimelineChart_'+upDateingTimelineChartDivId+"&savedTimelineChart="+savedConfig,"propertyContentDiv",'event','TimelineChart');
			}
		}
	}
	function getCompoenetToModify(tableID,url,blockType,savedTable)
	{
		cleanUpScriptVariables();
		var savedConfig="false";
		if(savedTable!=null && savedTable!="")
			savedConfig=savedTable;
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			if(tableID!=null && tableID.indexOf("_")>0)
				upDateingDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));				loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?from=ComparisonTable&action=modify&profileName="+profileName)%>&savedTable='+savedConfig+'&'+url,"propertyContentDiv",'event','compTable');
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			if(tableID!=null && tableID.indexOf("_")>0)
				upDateingBarChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));	
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?from=BarChart&action=modify&profileName="+profileName)%>&savedBarChart='+savedConfig+'&'+url,"propertyContentDiv",'event','BarChart');
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var urlParam="&from=TimelineChart";
			if(blockType==CombinedTimelineChartStr)
			{
				urlParam="&from=CombinedTimelineChart";
				if(tableID!=null && tableID.indexOf("_")>0)
					upDateingCombinedTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));	
			}
			else
			{
				if(tableID!=null && tableID.indexOf("_")>0)
					upDateingTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));	
				urlParam="&from=TimelineChart";
			}
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?action=modify&profileName="+profileName)%>&savedTimelineChart='+savedConfig+'&'+(url+urlParam),"propertyContentDiv",'event','TimelineChart');
		}
	}
	function changeDescriptorsForComp(tableID,url,blockType,savedTable)
	{
		cleanUpScriptVariables();
		var savedConfig="false";
		if(savedTable!=null && savedTable!="")
			savedConfig=savedTable;
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			if(tableID!=null && tableID.indexOf("_")>0)
				upDateingDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));				loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?from=ComparisonTable&action=modify&profileName="+profileName)%>&savedTable='+savedConfig+'&'+url,"propertyContentDiv",'event','compTable');
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			if(tableID!=null && tableID.indexOf("_")>0)
				upDateingBarChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));	
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?from=BarChart&action=modify&profileName="+profileName)%>&savedBarChart='+savedConfig+'&'+url,"propertyContentDiv",'event','BarChart');
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var urlParam="&from=TimelineChart";
			if(blockType==CombinedTimelineChartStr)
			{
				if(tableID!=null && tableID.indexOf("_")>0)
					upDateingCombinedTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));	
				urlParam="&from=CombinedTimelineChart";
			}
			else
			{
				if(tableID!=null && tableID.indexOf("_")>0)
					upDateingTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));	
				urlParam="&from=TimelineChart";
			}
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?&action=modify&profileName="+profileName)%>&savedTimelineChart='+savedConfig+'&'+(url+urlParam),"propertyContentDiv",'event','TimelineChart');
		}
	}
	function modifyMetricsInPopup(savedTable,from,tableID,blockType)
	{
		cleanUpScriptVariables();
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			if(tableID!=null && tableID.indexOf("_")>0)
				upDateingDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));	
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?from=ComparisonTable&action=modifyColumns&profileName="+profileName)%>&tableID='+tableID+'&modifyMeasures='+from+'&savedTable='+savedTable,"propertyContentDiv",'event','compTable');
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			if(tableID!=null && tableID.indexOf("_")>0)
				upDateingBarChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));	
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?from=BarChart&action=modifyColumns&profileName="+profileName)%>&barChartID='+tableID+'&modifyMeasures='+from+'&savedBarChart='+savedTable,"propertyContentDiv",'event','BarChart');
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var urlParam="&from=TimelineChart&timelineChartID="+tableID;
			if(blockType==CombinedTimelineChartStr)
			{
				if(tableID!=null && tableID.indexOf("_")>0)
					upDateingCombinedTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));	
				urlParam="&from=CombinedTimelineChart&combinedTimelineChartID="+tableID;
			}
			else
			{
				if(tableID!=null && tableID.indexOf("_")>0)
					upDateingTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));	
				urlParam="&from=TimelineChart&timelineChartID="+tableID;
			}
			
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?action=modifyColumns&profileName="+profileName)%>'+urlParam+'&modifyMeasures='+from+'&savedTimelineChart='+savedTable,"propertyContentDiv",'event','TimelineChart');
		}
	}
	function addMetricInPopup(blockType)
	{
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			var updateTR=document.getElementById("updateTR");
			var addedMetricsDiv=document.getElementById("addedMetricsDiv");
			if(addedMetricsDiv!=null && addedMetricsDiv!="undefined")
			{
				if(addedMetricsDiv.style.display=="none")
				{
					addedMetricsDiv.style.display="block";
					var existingMeasureCount=document.getElementById("existingMeasureCount");
					if(existingMeasureCount!=null && existingMeasureCount!="undefined")
					{
						if(existingMeasureCount.value!="")
							addedMetricCount=existingMeasureCount.value;
					}
				}
			}
			if(addedMetricCount!=null && addedMetricCount>0)
			{
				var existingConfMeasureDisplayNames="";
				for(var c=0;c<addedMetricCount;c++)
				{
					var test=document.getElementById("testList"+c);
					var measure=document.getElementById("measureList"+c);
					var metricNameID=document.getElementById("metricIDName"+c);
					if(metricNameID!=null && metricNameID!="undefined")
					{
						existingMetricDisplayNamesForPopup[c]=metricNameID.value;
					}
					else
					{
						existingMetricDisplayNamesForPopup[c]="";
					}
					if(test!=null && test!="undefined")
					{
						existingSelectBoxTestsForPopup[c]=test.options.selectedIndex;
					}
					else
					{
						existingSelectBoxTestsForPopup[c]=0;
					}
					if(measure!=null && measure!="undefined")
					{
						existingSelectBoxMeasuresForPopup[c]=measure.options.selectedIndex;
					}
					else
					{
						existingSelectBoxMeasuresForPopup[c]=0;
					}
				}
			}	loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?from=ComparisonTable&action=addColumns&profileName="+profileName)%>&metricSNO='+addedMetricCount,"addedMetricsDiv",'event','compTable');
			addedMetricCount++;
			if(updateTR!=null && updateTR!="undefined")
			{
				if(isFireFox())
					updateTR.style.display="table-row";
				else
					updateTR.style.display="block";
			}
			
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			var updateTR=document.getElementById("updateTR");
			var addedMetricsDiv=document.getElementById("addedMetricsDiv");
			if(addedMetricsDiv!=null && addedMetricsDiv!="undefined")
			{
				if(addedMetricsDiv.style.display=="none")
				{
					addedMetricsDiv.style.display="block";
					var existingMeasureCount=document.getElementById("existingBarChartMeasureCount");
					if(existingMeasureCount!=null && existingMeasureCount!="undefined")
					{
						if(existingMeasureCount.value!="")
							addedBarChartMetricCount=existingMeasureCount.value;
					}
				}
			}
			if(addedBarChartMetricCount!=null && addedBarChartMetricCount>0)
			{
				var existingConfMeasureDisplayNames="";
				for(var c=0;c<addedBarChartMetricCount;c++)
				{
					var test=document.getElementById("testList"+c);
					var measure=document.getElementById("measureList"+c);
					var metricNameID=document.getElementById("metricIDName"+c);
					if(metricNameID!=null && metricNameID!="undefined")
					{
						existingMetricDisplayNamesForPopup[c]=metricNameID.value;
					}
					else
					{
						existingMetricDisplayNamesForPopup[c]="";
					}
					if(test!=null && test!="undefined")
					{
						existingSelectBoxTestsForPopup[c]=test.options.selectedIndex;
					}
					else
					{
						existingSelectBoxTestsForPopup[c]=0;
					}
					if(measure!=null && measure!="undefined")
					{
						existingSelectBoxMeasuresForPopup[c]=measure.options.selectedIndex;
					}
					else
					{
						existingSelectBoxMeasuresForPopup[c]=0;
					}
				}
			}
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?from=BarChart&action=addColumns&profileName="+profileName)%>&metricSNO='+addedBarChartMetricCount,"addedMetricsDiv",'event','BarChart');
			addedBarChartMetricCount++;
			if(updateTR!=null && updateTR!="undefined")
			{
				if(isFireFox())
					updateTR.style.display="table-row";
				else
					updateTR.style.display="block";
			}
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var updateTR=document.getElementById("updateTR");
			var addedMetricsDiv=document.getElementById("addedMetricsDiv");
			if(addedMetricsDiv!=null && addedMetricsDiv!="undefined")
			{
				if(addedMetricsDiv.style.display=="none")
				{
					addedMetricsDiv.style.display="block";
					if(blockType==TimelineChartStr)
					{
						var existingMeasureCount=document.getElementById("existingTimelineChartMeasureCount");
						if(existingMeasureCount!=null && existingMeasureCount!="undefined")
						{
							if(existingMeasureCount.value!="")
								addedTimelineChartMetricCount=existingMeasureCount.value;
						}
					}
					else if(blockType==CombinedTimelineChartStr)
					{
						var existingMeasureCount=document.getElementById("existingCombinedTimelineChartMeasureCount");
						if(existingMeasureCount!=null && existingMeasureCount!="undefined")
						{
							if(existingMeasureCount.value!="")
								addedTimelineChartMetricCount=existingMeasureCount.value;
						}
					}
				}
			}
			if(addedTimelineChartMetricCount!=null && addedTimelineChartMetricCount>0)
			{
				var existingConfMeasureDisplayNames="";
				for(var c=0;c<addedTimelineChartMetricCount;c++)
				{
					var test=document.getElementById("testList"+c);
					var measure=document.getElementById("measureList"+c);
					var metricNameID=document.getElementById("metricIDName"+c);
					if(metricNameID!=null && metricNameID!="undefined")
					{
						existingMetricDisplayNamesForPopup[c]=metricNameID.value;
					}
					else
					{
						existingMetricDisplayNamesForPopup[c]="";
					}
					if(test!=null && test!="undefined")
					{
						existingSelectBoxTestsForPopup[c]=test.options.selectedIndex;
					}
					else
					{
						existingSelectBoxTestsForPopup[c]=0;
					}
					if(measure!=null && measure!="undefined")
					{
						existingSelectBoxMeasuresForPopup[c]=measure.options.selectedIndex;
					}
					else
					{
						existingSelectBoxMeasuresForPopup[c]=0;
					}
				}
			}	loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?action=addColumns&profileName="+profileName)%>&from='+blockType+'&metricSNO='+addedTimelineChartMetricCount,"addedMetricsDiv",'event','TimelineChart');
			addedTimelineChartMetricCount++;
			if(updateTR!=null && updateTR!="undefined")
			{
				if(isFireFox())
					updateTR.style.display="table-row";
				else
					updateTR.style.display="block";
			}
		}
	}
	function loadRowPopup(divId,event,from,blockType)
	{
		cleanUpScriptVariables();
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			thresholdFlag="";
			fromCustomModify=from;
			upDateingDivId=divId;
			var savedConfig="false";
			if(from!=null && (from=="true" || from==true))
			{
				savedConfig="true";
			}
		loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomDesignProperties.jsp?from=ComparisonTable&action=addRows&profileName="+profileName)%>&tableID=table_'+divId+'&savedTable='+savedConfig,"propertyContentDiv",'event',"compTable");
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			fromCustomBarChartModify=from;
			upDateingBarChartDivId=divId;
			var savedConfig="false";
			
			if(from!=null && (from=="true" || from==true))
			{
				savedConfig="true";
			}	loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomBarChartProperties.jsp?from=BarChart&action=addRows&profileName="+profileName)%>&barChartID=BarChart_'+divId+'&savedBarChart='+savedConfig,"propertyContentDiv",'event',"BarChart");
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var urlParam="&from=TimelineChart&timelineChartID=TimelineChart_"+divId;
			if(blockType==CombinedTimelineChartStr)
			{
				fromCustomCombinedTimelineChartModify=from;
				upDateingCombinedTimelineChartDivId=divId;
				urlParam="&from=CombinedTimelineChart&combinedTimelineChartID=CombinedTimelineChart_"+divId;
			}
			else
			{
				fromCustomTimelineChartModify=from;
				upDateingTimelineChartDivId=divId;
				urlParam="&from=TimelineChart&timelineChartID=TimelineChart_"+divId;
			}
			var savedConfig="false";
			
			if(from!=null && (from=="true" || from==true))
			{
				savedConfig="true";
			}
			loadPropertyPage('<%=response.encodeURL("/final/monitor/egCustomTimelineChartProperties.jsp?action=addRows&profileName="+profileName)%>&savedTimelineChart='+(savedConfig+urlParam),"propertyContentDiv",'event',"TimelineChart");
		}
	}
	function addColumnsForTable(savedConfig,flag,blockType)
	{
		saveColumnData(savedConfig,flag,blockType);
	}
	function loadComparisonTableDesign(url,divId,event,from)
	{
		url=url+"&screenWidth="+screen.width+"&screenHeight="+screen.height+"&tableTitlelength=<%=tableTitlelength%>&cache="+(new Date()).getTime();
		var tableDiv=document.getElementById(divId);
		event=(isIE())?window.event:event;
		if(tableDiv!=null)
		{
			tableDiv.style.display="block";
			var xmlHttpT=GetXmlHttpObject();
			if (xmlHttpT==null)
				return;
			xmlHttpT.onreadystatechange = function ()
			{
				tableDiv.innerHTML = '<table height="500px" width="100%"><tr><td height="500px" align=center valign="middle"><img src="/final/monitor/eg_images/indicator_medium.gif"></td></tr></table>';
				if (xmlHttpT.readyState==4)
				{
					if (xmlHttpT.status == 200)
					{
						var response=xmlHttpT.responseText;
						try
						{
							tableDiv.innerHTML=response;
						}
						catch(e)
						{
							alert("e--->"+e.description);
						}
					}
				}
			}
		}
		xmlHttpT.open("POST",url,true);
		xmlHttpT.send(null);
	}
	function saveColumnData(savedConfig,flag,blockType)
	{
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			var header=document.getElementById('header'+upDateingDivId);
			var contentDiv=document.getElementById('contentDiv'+upDateingDivId);
			var isModify=(flag!=null && flag=="true");
			if(isModify)
			{
				if(savedConfig!=null && savedConfig=="true")
					fromCustomModify=true;
				var existingMeasureCount=document.getElementById("existingMeasureCount");
				if(existingMeasureCount!=null && existingMeasureCount!="undefined")
				{
					var exMCount=existingMeasureCount.value;
					if(exMCount!=null && (exMCount!="" && exMCount>addedMetricCount))
						addedMetricCount=existingMeasureCount.value;
				}
			}
			var VValues="";
			var existingConfMeasures="";
			var existingConfMeasureDisplayNames="";
			for(var c=0;c<addedMetricCount;c++)
			{
				var metricTR=document.getElementById("metricTR"+c);
				if(metricTR!=null && metricTR!="undefined")
				{
					if(metricTR.style.display=="none")
						continue;
				}
				var metricNameID=document.getElementById("metricIDName"+c);
				if(metricNameID!=null && metricNameID.value=="")
				{
					alert('<egui:intnl text="monitor.dashboard.Please enter metric name"/>');
					return;
				}
				var test=document.getElementById("testList"+c);
				var measure=document.getElementById("measureList"+c);
				if(measure!=null && measure.value=="")
				{
					alert('<egui:intnl text="monitor.dashboard.Please select measures"/>');
					return;
				}
				var metricName=metricNameID.value;
				var testName=test.value;
				var measureName=measure.value;
				if(checkspecialCharacterForMetric(metricName))
				{
					alert('<egui:intnl text="monitor.dashboard.Metric Displayname cannot have special characters"/>');
					return;
				}
				if(existingConfMeasureDisplayNames!=null && existingConfMeasureDisplayNames!="")
				{
					if(existingConfMeasureDisplayNames.indexOf(",")!=-1)
					{
						var isMetricFound=false;
						var exMetricsArr=existingConfMeasureDisplayNames.split(",");
						if(exMetricsArr!=null && exMetricsArr.length>0)
						{
							for(var m=0;m<exMetricsArr.length;m++)
							{
								var exMetric=exMetricsArr[m];
								if(exMetric!=null && exMetric.toLowerCase()==metricName.toLowerCase())
								{
									isMetricFound=true;
								}
							}
						}
						if(isMetricFound)
						{
					alert('<egui:intnl text="monitor.dashboard.Metric Name already exists"/>!');
					return;
						}
					}
				}
				existingConfMeasures=existingConfMeasures+","+testName+":"+measureName;	existingConfMeasureDisplayNames=existingConfMeasureDisplayNames+","+metricName.toLowerCase();
				var mValue=metricName+"$"+testName+":"+measureName;
				VValues= VValues+","+mValue;
			}
			if(VValues!=null && VValues.indexOf(",")==0)
				VValues=VValues.substr(1, VValues.length);
			if(VValues!=null && VValues.lastIndexOf(",")==VValues.length)
				VValues=VValues.substr(0,VValues.length-1);
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=addTableMeasure&DBtype=multiple&configureMetrics=true&operation=add&profileName=<%=profileName%>&key=table_"+upDateingDivId+"_metrics&value="+encodeURIComponent(VValues);
			if(isModify)
				url+="&replaceValue=true";
			var thresholdChkBox=document.getElementById("thresholdChkBox");
			if(thresholdChkBox!=null && thresholdChkBox!="undefined")
			{
				url=url+"&thresholdKey=table_"+upDateingDivId+"_ThresholdNeeded&thresholdValue="+thresholdFlag;
			}
			thresholdFlag="";
			var paramForUpdate="compTable";
			if(VValues!=null && VValues=="")
				paramForUpdate="emptyComparisonTableConfig";
			divIdForUpDate += "table_"+upDateingDivId+",";
			updateIniFile(url,paramForUpdate);
			hideElement('propertyDiv');
			addedMetricCount=0;
		}
		else if(blockType!=null && blockType=="BarChart")
		{
			var header=document.getElementById('headerBarChart'+upDateingBarChartDivId);
			var contentDiv=document.getElementById('contentBarChartDiv'+upDateingBarChartDivId);
			var isModify=(flag!=null && flag=="true");
			if(isModify)
			{
				if(savedConfig!=null && savedConfig=="true")
					fromCustomBarChartModify=true;
				var existingMeasureCount=document.getElementById("existingBarChartMeasureCount");
				if(existingMeasureCount!=null && existingMeasureCount!="undefined")
				{
					var exMCount=existingMeasureCount.value;
					if(exMCount!=null && (exMCount!="" && exMCount>addedBarChartMetricCount))
						addedBarChartMetricCount=existingMeasureCount.value;
				}
			}
			var VValues="";
			var existingConfMeasures="";
			var existingConfMeasureDisplayNames="";
			for(var c=0;c<addedBarChartMetricCount;c++)
			{
				var metricTR=document.getElementById("metricTR"+c);
				if(metricTR!=null && metricTR!="undefined")
				{
					if(metricTR.style.display=="none")
						continue;
				}
				var metricNameID=document.getElementById("metricIDName"+c);
				if(metricNameID!=null && metricNameID.value=="")
				{
					alert('<egui:intnl text="monitor.common.Please enter metric name"/>');
					return;
				}
				var test=document.getElementById("testList"+c);
				var measure=document.getElementById("measureList"+c);
				if(measure!=null && measure.value=="")
				{
					alert('<egui:intnl text="monitor.common.Please select measures"/>');
					return;
				}
				var metricName=metricNameID.value;
				var testName=test.value;
				var measureName=measure.value;
				if(checkspecialCharacterForMetric(metricName))
				{
					alert('<egui:intnl text="monitor.common.Metric Displayname cannot have special characters"/>');
					return;
				}
				if(existingConfMeasureDisplayNames!=null && existingConfMeasureDisplayNames!="")
				{
					if(existingConfMeasureDisplayNames.indexOf(",")!=-1)
					{
						var isMetricFound=false;
						var exMetricsArr=existingConfMeasureDisplayNames.split(",");
						if(exMetricsArr!=null && exMetricsArr.length>0)
						{
							for(var m=0;m<exMetricsArr.length;m++)
							{
								var exMetric=exMetricsArr[m];
								if(exMetric!=null && exMetric.toLowerCase()==metricName.toLowerCase())
								{
									isMetricFound=true;
								}
							}
						}
						if(isMetricFound)
						{
					alert('<egui:intnl text="monitor.common.Metric Name already exists"/>!');
					return;
						}
					}
				}
				existingConfMeasures=existingConfMeasures+","+testName+":"+measureName;
				existingConfMeasureDisplayNames=existingConfMeasureDisplayNames+","+metricName.toLowerCase();
				var mValue=metricName+"$"+testName+":"+measureName;
				VValues= VValues+","+mValue;
			}
			if(VValues!=null && VValues.indexOf(",")==0)
				VValues=VValues.substr(1, VValues.length);
			if(VValues!=null && VValues.lastIndexOf(",")==VValues.length)
				VValues=VValues.substr(0,VValues.length-1);
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=addTableMeasure&DBtype=multiple&operation=add&configureMetrics=true&profileName=<%=profileName%>&key=BarChart_"+upDateingBarChartDivId+"_metrics&value="+encodeURIComponent(VValues);
			if(isModify)
				url+="&replaceValue=true";
			var paramForUpdate="BarChart";
			if(VValues!=null && VValues=="")
				paramForUpdate="emptyBarChartConfig";
			divIdForUpDate += "barChart_"+upDateingBarChartDivId+",";
			updateIniFile(url,paramForUpdate);
			hideElement('propertyDiv');
			addedBarChartMetricCount=0;
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var header=document.getElementById('headerTimelineChart'+upDateingTimelineChartDivId);
			var contentDiv=document.getElementById('contentTimelineChartDiv'+upDateingTimelineChartDivId);
			if(blockType==CombinedTimelineChartStr)
			{
				header=document.getElementById('headerCombinedTimelineChart'+upDateingTimelineChartDivId);
				contentDiv=document.getElementById('contentCombinedTimelineChartDiv'+upDateingTimelineChartDivId);
			}
			var isModify=(flag!=null && flag=="true");
			if(isModify)
			{
				if(blockType==CombinedTimelineChartStr)
				{
					if(savedConfig!=null && savedConfig=="true")
						fromCustomCombinedTimelineChartModify=true;
				}
				else
				{
					if(savedConfig!=null && savedConfig=="true")
						fromCustomTimelineChartModify=true;
				}
				var existingMeasureCount=document.getElementById("existingTimelineChartMeasureCount");
				if(blockType==CombinedTimelineChartStr)
				{
					existingMeasureCount=document.getElementById("existingCombinedTimelineChartMeasureCount");
				}
				if(existingMeasureCount!=null && existingMeasureCount!="undefined")
				{
					var exMCount=existingMeasureCount.value;
					if(exMCount!=null && (exMCount!="" && exMCount>addedTimelineChartMetricCount))
						addedTimelineChartMetricCount=existingMeasureCount.value;
				}
			}
			var VValues="";
			var existingConfMeasures="";
			var existingConfMeasureDisplayNames="";
			for(var c=0;c<addedTimelineChartMetricCount;c++)
			{
				var metricTR=document.getElementById("metricTR"+c);
				if(metricTR!=null && metricTR!="undefined")
				{
					if(metricTR.style.display=="none")
						continue;
				}
				var metricNameID=document.getElementById("metricIDName"+c);
				if(metricNameID!=null && metricNameID.value=="")
				{
					alert('<egui:intnl text="monitor.common.Please enter metric name"/>');
					return;
				}
				var test=document.getElementById("testList"+c);
				var measure=document.getElementById("measureList"+c);
				if(measure!=null && measure.value=="")
				{
					alert('<egui:intnl text="monitor.common.Please select measures"/>');
					return;
				}
				var metricName=metricNameID.value;
				var testName=test.value;
				var measureName=measure.value;
				if(checkspecialCharacterForMetric(metricName))
				{
					alert('<egui:intnl text="monitor.common.Metric Displayname cannot have special characters"/>');
					return;
				}
				if(existingConfMeasureDisplayNames!=null && existingConfMeasureDisplayNames!="")
				{
					if(existingConfMeasureDisplayNames.indexOf(",")!=-1)
					{
						var isMetricFound=false;
						var exMetricsArr=existingConfMeasureDisplayNames.split(",");
						if(exMetricsArr!=null && exMetricsArr.length>0)
						{
							for(var m=0;m<exMetricsArr.length;m++)
							{
								var exMetric=exMetricsArr[m];
								if(exMetric!=null && exMetric.toLowerCase()==metricName.toLowerCase())
								{
									isMetricFound=true;
								}
							}
						}
						if(isMetricFound)
						{
					alert('<egui:intnl text="monitor.common.Metric Name already exists"/>!');
					return;
						}
					}
				}
				existingConfMeasures=existingConfMeasures+","+testName+":"+measureName;	existingConfMeasureDisplayNames=existingConfMeasureDisplayNames+","+metricName.toLowerCase();
				var mValue=metricName+"$"+testName+":"+measureName;
				VValues= VValues+","+mValue;
			}
			if(VValues!=null && VValues.indexOf(",")==0)
				VValues=VValues.substr(1, VValues.length);
			if(VValues!=null && VValues.lastIndexOf(",")==VValues.length)
				VValues=VValues.substr(0,VValues.length-1);
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=addTableMeasure&configureMetrics=true&DBtype=multiple&operation=add&profileName=<%=profileName%>";
			if(blockType==CombinedTimelineChartStr)
			{
				url=url+"&key=CombinedTimelineChart_"+upDateingCombinedTimelineChartDivId+"_metrics&value="+encodeURIComponent(VValues);
				divIdForUpDate += "CombinedTimelineChart_"+upDateingCombinedTimelineChartDivId+",";
			}
			else
			{
				url=url+"&key=TimelineChart_"+upDateingTimelineChartDivId+"_metrics&value="+encodeURIComponent(VValues);
				divIdForUpDate += "TimelineChart_"+upDateingTimelineChartDivId+",";
			}
			if(isModify)
				url+="&replaceValue=true";
			var paramForUpdate=blockType;
			if(VValues!=null && VValues=="")
			{
				paramForUpdate="emptyTimelineChartConfig";
				if(blockType==CombinedTimelineChartStr)
					paramForUpdate="emptyCombinedTimelineChartConfig";
			}
			updateIniFile(url,paramForUpdate);
			hideElement('propertyDiv');
			addedTimelineChartMetricCount=0;
		}
	}
	function addRowsForTable(flag,tableID,blockType)
	{
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			if(tableID!=null && tableID.indexOf("_")>0)
			{
				upDateingDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
			}
			var componentList=document.getElementById("componentList");
			var compList=document.getElementById("AssociateCompList");
			var values="";
			if(compList!=null && compList.options.length==0)
			{
				var ans =confirm("<egui:intnl text='monitor.dashboard.No components associated for this type!\r\n\r\nDo you want to continue'/>?","Ok" , "Cancel");
				if(ans==false)
				{
					return;
				}
			}
			var isModify=(flag!=null && flag=="true");
			if(isModify)
			{
				fromCustomModify=true;
			}
			for(var i=0;i<compList.options.length;i++)
			{
				values=values+","+compList.options[i].value;
			}
			var removedValues="";
			for(var r=0;r<componentList.options.length;r++)
			{
				removedValues=removedValues+","+componentList.options[r].value;
			}
			if(values!=null && values.indexOf(",")==0)
				values=values.substr(1,values.length);
			if(removedValues!=null && removedValues.indexOf(",")==0)
				removedValues=removedValues.substr(1,removedValues.length);
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=addTableMeasure&DBtype=multiple&operation=add&profileName=<%=profileName%>&key=table_"+upDateingDivId+"_components&value="+encodeURIComponent(values);
			url=url+"&isModifyIniValues=true&removedValues="+encodeURIComponent(removedValues);		
			updateIniFile(url,"reloadAssociatedComponents");
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			if(tableID!=null && tableID.indexOf("_")>0)
			{
				upDateingBarChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
			}
			var componentList=document.getElementById("componentList");
			var compList=document.getElementById("AssociateCompList");
			var values="";
			if(compList!=null && compList.options.length==0)
			{
				var ans =confirm("<egui:intnl text='monitor.dashboard.No components associated for this type!\r\n\r\nDo you want to continue'/>?","Ok" , "Cancel");
				if(ans==false)
				{
					return;
				}
			}
			var isModify=(flag!=null && flag=="true");
			if(isModify)
			{
				fromCustomBarChartModify=true;
			}
			for(var i=0;i<compList.options.length;i++)
			{
				values=values+","+compList.options[i].value;
			}
			var removedValues="";
			for(var r=0;r<componentList.options.length;r++)
			{
				removedValues=removedValues+","+componentList.options[r].value;
			}
			if(values!=null && values.indexOf(",")==0)
				values=values.substr(1,values.length);
			if(removedValues!=null && removedValues.indexOf(",")==0)
				removedValues=removedValues.substr(1,removedValues.length);
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=addTableMeasure&DBtype=multiple&operation=add&profileName=<%=profileName%>&key=BarChart_"+upDateingBarChartDivId+"_components&value="+encodeURIComponent(values);
			url=url+"&isModifyIniValues=true&removedValues="+encodeURIComponent(removedValues);
			updateIniFile(url,"reloadBarAssociatedComponents");
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			if(blockType==CombinedTimelineChartStr)
			{
				if(tableID!=null && tableID.indexOf("_")>0)
				{
					upDateingCombinedTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
				}
			}
			else
			{
				if(tableID!=null && tableID.indexOf("_")>0)
				{
					upDateingTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
				}
			}
			var componentList=document.getElementById("componentList");
			var compList=document.getElementById("AssociateCompList");
			var values="";
			if(compList!=null && compList.options.length==0)
			{
				var ans =confirm("<egui:intnl text='monitor.dashboard.No components associated for this type!\r\n\r\nDo you want to continue'/>?","Ok" , "Cancel");
				if(ans==false)
				{
					return;
				}
			}
			var isModify=(flag!=null && flag=="true");
			if(isModify)
			{
				if(blockType==CombinedTimelineChartStr)
					fromCustomCombinedTimelineChartModify=true;
				else
					fromCustomTimelineChartModify=true;
			}
			for(var i=0;i<compList.options.length;i++)
			{
				values=values+","+compList.options[i].value;
			}
			var time_lineObj=document.getElementById("time_line");
			var time_line =time_lineObj.options[time_lineObj.selectedIndex].value;
			var start_time=document.getElementById("starttime").value;
			var end_time=document.getElementById("endtime").value;
			var start_hrObj=document.getElementById("starthr");
			var end_hrObj=document.getElementById("endhr");
			var start_hr=start_hrObj.options[start_hrObj.selectedIndex].value;
			var end_hr=end_hrObj.options[end_hrObj.selectedIndex].value;
			var removedValues="";
			var start_time1=formatDate(new Date(getDateFromFormat(start_time,"<%=currentDateFormat%>")),"MM/dd/yyyy");
			var end_time1=formatDate(new Date(getDateFromFormat(end_time,"<%=currentDateFormat%>")),"MM/dd/yyyy");
			for(var r=0;r<componentList.options.length;r++)
			{
				removedValues=removedValues+","+componentList.options[r].value;
			}
			if(values!=null && values.indexOf(",")==0)
				values=values.substr(1,values.length);
			if(removedValues!=null && removedValues.indexOf(",")==0)
				removedValues=removedValues.substr(1,removedValues.length);
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=addTableMeasure&DBtype=multiple&operation=add&profileName=<%=profileName%>";
			if(blockType==CombinedTimelineChartStr)
			{
				url=url+"&key=CombinedTimelineChart_"+upDateingCombinedTimelineChartDivId+"_components&value="+encodeURIComponent(values);
				url=url+"&isModifyIniValues=true&removedValues="+encodeURIComponent(removedValues);
			}
			else
			{
			
				url=url+"&key=TimelineChart_"+upDateingTimelineChartDivId+"_components&value="+encodeURIComponent(values);
				url=url+"&isModifyIniValues=true&removedValues="+encodeURIComponent(removedValues);
			}
			if((start_time1!=null && (start_time1!="" && start_time1!="undefined")) && (end_time1!=null && (end_time1!="" && end_time1!="undefined")))
			{
				if(start_hr!=null && start_hr!="")
				{
					var shr=parseInt(start_hr);
					if(shr<10)
						start_hr="0"+start_hr;
				}
				if(end_hr!=null && end_hr!="")
				{
					var ehr=parseInt(end_hr);
					if(ehr<10)
						end_hr="0"+end_hr;
				}
				if(blockType==CombinedTimelineChartStr)
				{
					url=url+"&saveTimeline=true&time_line="+time_line+"&timelineKey=CombinedTimelineChart_"+upDateingCombinedTimelineChartDivId+"&starttime="+encodeURI(start_time1)+"&endtime="+encodeURI(end_time1)+"&starthr="+start_hr+"&endhr="+end_hr;
				}
				else
				{
					url=url+"&saveTimeline=true&time_line="+time_line+"&timelineKey=TimelineChart_"+upDateingTimelineChartDivId+"&starttime="+encodeURI(start_time1)+"&endtime="+encodeURI(end_time1)+"&starthr="+start_hr+"&endhr="+end_hr;
				}
			}
			var reloadParam="reloadTimelineAssociatedComponents";
			if(blockType==CombinedTimelineChartStr)
				reloadParam="reloadCombinedTimelineAssociatedComponents";

			updateIniFile(url,reloadParam);
		}
	}
	function checkComponentDisplayName(cDispNameEntry,tableID,blockType)
	{
		
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			var existingComponentDisplayNamesForTable=document.getElementById("existingComponentsForTable_"+tableID);
	
			if(existingComponentDisplayNamesForTable!=null && existingComponentDisplayNamesForTable!="undefined")
			{
				var existingComps=existingComponentDisplayNamesForTable.value;
				if(existingComps!=null && existingComps!="")
				{
					if(existingComps!=null && existingComps.indexOf(",")!=-1)
					{
						var exCompsArr=existingComps.split(",");
						if(exCompsArr!=null && exCompsArr.length>0)
						{
							for(var c=0;c<exCompsArr.length;c++)
							{
								var cDisplayNameWithType=exCompsArr[c];
								if((cDispNameEntry!=null && cDisplayNameWithType!=null) && cDispNameEntry!=cDisplayNameWithType)
								{
									var currentCompIDX=cDispNameEntry.indexOf("$");
									var existCompIDX=cDisplayNameWithType.indexOf("$");
									if(currentCompIDX>0 && existCompIDX>0)
									{
										var cName=cDispNameEntry.substr(currentCompIDX+1,cDispNameEntry.length);
										var cExistDispName=cDisplayNameWithType.substr(existCompIDX+1,cDisplayNameWithType.length);
										if(cName.toLowerCase()==cExistDispName.toLowerCase())
										{
											return true;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			var existingComponentDisplayNamesForBarChart=document.getElementById("existingBarChartComponentsForTable_"+tableID);
			if(existingComponentDisplayNamesForBarChart!=null && existingComponentDisplayNamesForBarChart!="undefined")
			{
				var existingComps=existingComponentDisplayNamesForBarChart.value;
				if(existingComps!=null && existingComps!="")
				{
					if(existingComps!=null && existingComps.indexOf(",")!=-1)
					{
						var exCompsArr=existingComps.split(",");
						if(exCompsArr!=null && exCompsArr.length>0)
						{
							for(var c=0;c<exCompsArr.length;c++)
							{
								var cDisplayNameWithType=exCompsArr[c];
								if((cDispNameEntry!=null && cDisplayNameWithType!=null) && cDispNameEntry!=cDisplayNameWithType)
								{
									var currentCompIDX=cDispNameEntry.indexOf("$");
									var existCompIDX=cDisplayNameWithType.indexOf("$");
									if(currentCompIDX>0 && existCompIDX>0)
									{
										var cName=cDispNameEntry.substr(currentCompIDX+1,cDispNameEntry.length);
										var cExistDispName=cDisplayNameWithType.substr(existCompIDX+1,cDisplayNameWithType.length);
										if(cName.toLowerCase()==cExistDispName.toLowerCase())
										{
											return true;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		else if(blockType==TimelineChartStr || blockType==CombinedTimelineChartStr)
		{
			var existingComponentDisplayNames=document.getElementById("existingTimelineChartComponentsForTable_"+tableID);
			if(blockType==CombinedTimelineChartStr)
			{
				existingComponentDisplayNames=document.getElementById("existingCombinedTimelineChartComponentsForTable_"+tableID);
			}
			if(existingComponentDisplayNames!=null && existingComponentDisplayNames!="undefined")
			{
				var existingComps=existingComponentDisplayNames.value;
				if(existingComps!=null && existingComps!="")
				{
					if(existingComps!=null && existingComps.indexOf(",")!=-1)
					{
						var exCompsArr=existingComps.split(",");
						if(exCompsArr!=null && exCompsArr.length>0)
						{
							for(var c=0;c<exCompsArr.length;c++)
							{
								var cDisplayNameWithType=exCompsArr[c];
								if((cDispNameEntry!=null && cDisplayNameWithType!=null) && cDispNameEntry!=cDisplayNameWithType)
								{
									var currentCompIDX=cDispNameEntry.indexOf("$");
									var existCompIDX=cDisplayNameWithType.indexOf("$");
									if(currentCompIDX>0 && existCompIDX>0)
									{
										var cName=cDispNameEntry.substr(currentCompIDX+1,cDispNameEntry.length);
										var cExistDispName=cDisplayNameWithType.substr(existCompIDX+1,cDisplayNameWithType.length);
										if(cName.toLowerCase()==cExistDispName.toLowerCase())
										{
											return true;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	function RemoveThisComponent(flag,tableID,blockType)
	{
		var compTypeList=document.getElementById("compTypeList");
		var compNameList=document.getElementById("compName");
		var compDispName=document.getElementById("nicName");
		var isModify=(flag!=null && flag=="true");
		var compType=compTypeList.value
		var compName=compNameList.value;
		var cDispName=compDispName.value;
		if(compType!=null && compType=="")
		{
			alert('<egui:intnl text="monitor.common.Please select component"/>!');
			return;
		}
		if(cDispName!=null && cDispName=="")
		{
			alert('<egui:intnl text="monitor.common.Please enter component display name"/>!');
			return;
		}
		if(checkspecialCharacter(cDispName))
		{
			alert('<egui:intnl text="monitor.common.Components Displayname cannot have special characters"/>');
			return;
		}
		var cDispEntry=compType+":"+compName+"$"+cDispName;
		if(checkComponentDisplayName(cDispEntry,tableID,blockType))
		{
			alert('<egui:intnl text="monitor.common.Component Display name already exists for some other component"/>!');
			return;
		}
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			if(isModify)
			{
				if(tableID!=null && tableID.indexOf("_")>0)
				{
					upDateingDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
				}
				fromCustomModify=true;
			}
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=deleteDuplicateComponents&profileName=<%=profileName%>&key=table_"+upDateingDivId+"_descriptors&value="+encodeURIComponent(cDispEntry);
			updateIniFile(url,"compTable");
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			if(isModify)
			{
				if(tableID!=null && tableID.indexOf("_")>0)
				{
					upDateingBarChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
				}
				fromCustomBarChartModify=true;
			}
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=deleteDuplicateComponents&profileName=<%=profileName%>&key=BarChart_"+upDateingBarChartDivId+"_descriptors&value="+encodeURIComponent(cDispEntry);
			updateIniFile(url,"BarChart");
		}
		else if(blockType!=null && (blockType==CombinedTimelineChartStr || blockType==TimelineChartStr))
		{
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>&action=deleteDuplicateComponents&profileName=<%=profileName%>';
			if(isModify)
			{
				if(blockType==CombinedTimelineChartStr)
				{
					if(tableID!=null && tableID.indexOf("_")>0)
					{
						upDateingCombinedTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
					}
					fromCustomCombinedTimelineChartModify=true;
					url=url+"&key="+blockType+"_"+upDateingCombinedTimelineChartDivId+"_descriptors&value="+encodeURIComponent(cDispEntry);
				}
				else
				{
					if(tableID!=null && tableID.indexOf("_")>0)
					{
						upDateingTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
					}
					fromCustomTimelineChartModify=true;
					url=url+"&key="+blockType+"_"+upDateingTimelineChartDivId+"_descriptors&value="+encodeURIComponent(cDispEntry);
				}
			}
			updateIniFile(url,blockType);
		}
		hideElement('propertyDiv');
	}
	function saveDescriptors(flag,tableID,blockType)
	{
		if(blockType!=null && blockType==ComparisonTableStr)
		{
			var compTypeList=document.getElementById("compTypeList");
			var compNameList=document.getElementById("compName");
			var compDispName=document.getElementById("nicName");
			var existingCompNicName=document.getElementById("existingCompNicName");
			var descBasedTestCount=document.getElementById("descBasedTestCount");
			if(compTypeList!=null && compTypeList.value=="")
			{
				alert('<egui:intnl text="monitor.quickinsight.Please select a component"/>!');
				return;
			}
			if(compDispName!=null && compDispName.value=="")
			{
				alert('<egui:intnl text="monitor.dashboard.Please enter component display name"/>!');
				return;
			}
			var dCount=0;
			if(descBasedTestCount!=null && descBasedTestCount!="undefined")
			{
				dCount=descBasedTestCount.value;
			}
			var isModify=(flag!=null && flag=="true");
			if(isModify)
			{
				if(tableID!=null && tableID.indexOf("_")>0)
				{
					upDateingDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
				}
				fromCustomModify=true;
			}
			var compType=compTypeList.value
			var compName=compNameList.value;
			var cDispName=compDispName.value;
			var existingCompNicNameVal=existingCompNicName.value;
			if(checkspecialCharacter(cDispName))
			{
				alert('<egui:intnl text="monitor.common.Components Displayname cannot have special characters"/>');
				return;
			}
			var cDispEntry=compType+":"+compName+"$"+cDispName;
			if(checkComponentDisplayName(cDispEntry,tableID,blockType))
			{
				alert('<egui:intnl text="monitor.common.Component Display name already exists for some other component"/>!');
				return;
			}
			var values="";
			for(var d=1;d<=dCount;d++)
			{
				var testMeasureObj=document.getElementById(("testMeasureDesc_"+d));
				var infoSelectObj=document.getElementById("infoSelectConf_"+d);
				var dispMeasureObj=document.getElementById("dispMeasure_"+d);
				var dispMeasureName="";
				if(dispMeasureObj!=null && dispMeasureObj!="undefined")
					dispMeasureName=dispMeasureObj.value;
				var measureName="";
				if(testMeasureObj!=null && testMeasureObj!="undefined")
					measureName=testMeasureObj.value;
				var info="";
				if(infoSelectObj!=null && infoSelectObj!="undefined")
					info=infoSelectObj.value;
				if(info!=null && info=="All")
				{
					var dispMeasureAllInfosObj=document.getElementById("dispMeasure_AllInfos_"+d);
					if(dispMeasureAllInfosObj!=null && dispMeasureAllInfosObj!="undefined")
					{
						var currentVal=dispMeasureAllInfosObj.value;
						values=values+","+currentVal;
					}
				}
				else
				{
					var currentVal=cDispEntry+"|"+dispMeasureName+"$"+measureName+"$"+info;
				values=values+","+currentVal;
				}
			}
			if(values!=null && values.indexOf(",")==0)
				values=values.substr(1,values.length);
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=addTableMeasure&DBtype=multiple&operation=add&profileName=<%=profileName%>&saveDescs=true&compDispKey=table_"+upDateingDivId+"_ComponentDisplayNames&compDispName="+(compType+":"+compName+"$"+cDispName);
			if(existingCompNicNameVal!=null && existingCompNicNameVal!="" && existingCompNicNameVal!=cDispName)
			{
				url=url+"&ComparisonTableCompNickRename=true&existingCompNicNameVal="+encodeURIComponent(compType+":"+compName+"$"+existingCompNicNameVal);
			}
			if(values!=null && values!="")
			{
				url=url+"&key=table_"+upDateingDivId+"_descriptors&value="+encodeURIComponent(values);	
			}
			else
			{
				url=url+"&key=";
			}
			updateIniFile(url,"compTable");
			hideElement('propertyDiv');
		}
		else if(blockType!=null && blockType==BarChartStr)
		{
			var compTypeList=document.getElementById("compTypeList");
			var compNameList=document.getElementById("compName");
			var compDispName=document.getElementById("nicName");
			var descBasedTestCount=document.getElementById("descBasedTestCount");
			var existingCompNicName=document.getElementById("existingCompNicName");
			if(compTypeList!=null && compTypeList.value=="")
			{
				alert('<egui:intnl text="monitor.common.Please select component"/>!');
				return;
			}
			if(compDispName!=null && compDispName.value=="")
			{
				alert('<egui:intnl text="monitor.common.Please enter component display name"/>!');
				return;
			}
			var dCount=0;
			if(descBasedTestCount!=null && descBasedTestCount!="undefined")
			{
				dCount=descBasedTestCount.value;
			}
			var isModify=(flag!=null && flag=="true");
			if(isModify)
			{
				if(tableID!=null && tableID.indexOf("_")>0)
				{
					upDateingBarChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
				}
				fromCustomBarChartModify=true;
			}
			var compType=compTypeList.value
			var compName=compNameList.value;
			var cDispName=compDispName.value;
			var existingCompNicNameVal=existingCompNicName.value;
			if(checkspecialCharacter(cDispName))
			{
				alert('<egui:intnl text="monitor.common.Components Displayname cannot have special characters"/>');
				return;
			}
			var cDispEntry=compType+":"+compName+"$"+cDispName;
			if(checkComponentDisplayName(cDispEntry,tableID,blockType))
			{
				alert('<egui:intnl text="monitor.common.Component Display name already exists for some other component"/>!');
				return;
			}
			var values="";
			for(var d=1;d<=dCount;d++)
			{
				var testMeasureObj=document.getElementById(("testMeasureDesc_"+d));
				var infoSelectObj=document.getElementById("infoSelectConf_"+d);
				var dispMeasureObj=document.getElementById("dispMeasure_"+d);
				var dispMeasureName="";
				if(dispMeasureObj!=null && dispMeasureObj!="undefined")
					dispMeasureName=dispMeasureObj.value;
				var measureName="";
				if(testMeasureObj!=null && testMeasureObj!="undefined")
					measureName=testMeasureObj.value;
				var info="";
				if(infoSelectObj!=null && infoSelectObj!="undefined")
					info=infoSelectObj.value;
				if(info!=null && info=="All")
				{
					var dispMeasureAllInfosObj=document.getElementById("dispMeasure_AllInfos_"+d);
					if(dispMeasureAllInfosObj!=null && dispMeasureAllInfosObj!="undefined")
					{
						var currentVal=dispMeasureAllInfosObj.value;
						values=values+","+currentVal;
					}
				}
				else
				{
					var currentVal=cDispEntry+"|"+dispMeasureName+"$"+measureName+"$"+info;
					values=values+","+currentVal;
				}
			}
			if(values!=null && values.indexOf(",")==0)
				values=values.substr(1,values.length);
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=addTableMeasure&DBtype=multiple&operation=add&profileName=<%=profileName%>&saveDescs=true&compDispKey=BarChart_"+upDateingBarChartDivId+"_ComponentDisplayNames&compDispName="+(compType+":"+compName+"$"+cDispName);
			if(existingCompNicName!=null && existingCompNicName!="" && existingCompNicName!=cDispName)
			{
				url=url+"&ComparisonTableCompNickRename=true&existingCompNicNameVal="+encodeURIComponent(compType+":"+compName+"$"+existingCompNicNameVal);
			}
			if(values!=null && values!="")
			{
				url=url+"&key=BarChart_"+upDateingBarChartDivId+"_descriptors&value="+encodeURIComponent(values);	
			}
			else
			{
				url=url+"&key=";
			}
			updateIniFile(url,"BarChart");
			hideElement('propertyDiv');
		}
		else if(blockType!=null && (blockType==TimelineChartStr || blockType==CombinedTimelineChartStr))
		{
			var compTypeList=document.getElementById("compTypeList");
			var compNameList=document.getElementById("compName");
			var compDispName=document.getElementById("nicName");
			var descBasedTestCount=document.getElementById("descBasedTestCount");
			var existingCompNicName=document.getElementById("existingCompNicName");
			if(compTypeList!=null && compTypeList.value=="")
			{
				alert('<egui:intnl text="monitor.common.Please select component"/>!');
				return;
			}
			if(compDispName!=null && compDispName.value=="")
			{
				alert('<egui:intnl text="monitor.common.Please enter component display name"/>!');
				return;
			}
			var dCount=0;
			if(descBasedTestCount!=null && descBasedTestCount!="undefined")
			{
				dCount=descBasedTestCount.value;
			}
			var isModify=(flag!=null && flag=="true");
			if(isModify)
			{
				if(blockType==CombinedTimelineChartStr)
				{
					if(tableID!=null && tableID.indexOf("_")>0)
					{
						upDateingCombinedTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
					}
					fromCustomCombinedTimelineChartModify=true;
				}
				else
				{
					if(tableID!=null && tableID.indexOf("_")>0)
					{
						upDateingTimelineChartDivId=tableID.substr(tableID.indexOf("_")+1,tableID.lastIndexOf("_"));
					}
					fromCustomTimelineChartModify=true;
				}
			}
			var compType=compTypeList.value
			var compName=compNameList.value;
			var cDispName=compDispName.value;
			var existingCompNicNameVal=existingCompNicName.value;
			if(checkspecialCharacter(cDispName))
			{
				alert('<egui:intnl text="monitor.common.Components Displayname cannot have special characters"/>');
				return;
			}
			var cDispEntry=compType+":"+compName+"$"+cDispName;
			if(checkComponentDisplayName(cDispEntry,tableID,blockType))
			{
				alert('<egui:intnl text="monitor.common.Component Display name already exists for some other component"/>!');
				return;
			}
			var values="";
			for(var d=1;d<=dCount;d++)
			{
				var testMeasureObj=document.getElementById(("testMeasureDesc_"+d));
				var infoSelectObj=document.getElementById("infoSelectConf_"+d);
				var dispMeasureObj=document.getElementById("dispMeasure_"+d);
				var dispMeasureName="";
				if(dispMeasureObj!=null && dispMeasureObj!="undefined")
					dispMeasureName=dispMeasureObj.value;
				var measureName="";
				if(testMeasureObj!=null && testMeasureObj!="undefined")
					measureName=testMeasureObj.value;
				var info="";
				if(infoSelectObj!=null && infoSelectObj!="undefined")
					info=infoSelectObj.value;
				if(info!=null && info=="All")
				{
					var dispMeasureAllInfosObj=document.getElementById("dispMeasure_AllInfos_"+d);
					if(dispMeasureAllInfosObj!=null && dispMeasureAllInfosObj!="undefined")
					{
						var currentVal=dispMeasureAllInfosObj.value;
						values=values+","+currentVal;
					}
				}
				else
				{
					var currentVal=cDispEntry+"|"+dispMeasureName+"$"+measureName+"$"+info;
				values=values+","+currentVal;
				}
			}
			if(values!=null && values.indexOf(",")==0)
				values=values.substr(1,values.length);
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=addTableMeasure&DBtype=multiple&operation=add&profileName=<%=profileName%>&saveDescs=true";
			if(existingCompNicName!=null && existingCompNicName!="" && existingCompNicName!=cDispName)
			{
				url=url+"&ComparisonTableCompNickRename=true&existingCompNicNameVal="+encodeURIComponent(compType+":"+compName+"$"+existingCompNicNameVal);
			}
			if(blockType==CombinedTimelineChartStr)
			{
				url=url+"&compDispKey=CombinedTimelineChart_"+upDateingCombinedTimelineChartDivId+"_ComponentDisplayNames&compDispName="+(compType+":"+compName+"$"+cDispName);
				if(values!=null && values!="")
				{
					url=url+"&key=CombinedTimelineChart_"+upDateingCombinedTimelineChartDivId+"_descriptors&value="+encodeURIComponent(values);	
				}
				else
				{
					url=url+"&key=";
				}
			}
			else
			{
				url=url+"&compDispKey=TimelineChart_"+upDateingTimelineChartDivId+"_ComponentDisplayNames&compDispName="+(compType+":"+compName+"$"+cDispName);
				if(values!=null && values!="")
				{
					url=url+"&key=TimelineChart_"+upDateingTimelineChartDivId+"_descriptors&value="+encodeURIComponent(values);	
				}
				else
				{
					url=url+"&key=";
				}
			}
			updateIniFile(url,blockType);
			hideElement('propertyDiv');
		}
	}
	function checkspecialCharacterForMetric(obj_val)
	{
		var splChar =":~!@#$%^&*+={}[]|\\;\"\<>,";
		for(var i=0; i<obj_val.length; i++)
		{
			var check_char = splChar.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				return true;
			}
		}
	}
	function checkspecialCharacter(obj_val)
	{
		//obj_val = field.value;
		var splChar ="`~!@#$%^&*+={}[]|\\;\"\'<>,/";
		for(var i=0; i<obj_val.length; i++)
		{
			var check_char = splChar.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				return true;
			}
		}
		return false;
	}
	function addtounmanage()
	{
		var serverselected = "false";
		manunmanage = true;
		var count=0;
		var AssociatedSLA=document.getElementById("AssociateCompList");
		var DisAssociatedSLA=document.getElementById("componentList");
		//getting list size
		var j = DisAssociatedSLA.options.length;
		//gettin list vars
		var list =AssociatedSLA;
		var mlist = DisAssociatedSLA;
		if(list.options.length==0)
		{
			alert("<egui:intnl text='admin.mpolicy.Please choose an element'/>");
			return;
		}
		for(kk=0;kk<list.options.length;kk++)
		{
			if(list.options[kk].selected==true)
			{
				count++;
			}
		}
		if(count==0)
		{
			alert("<egui:intnl text='admin.mpolicy.Please choose an element'/>");
			return;
		}
		for(var i = 0 ; i < list.options.length ; i++)
		{
			//browsing through to find selected items
			if(list.options[i].selected == true)
			{
				serverselected = "true";
				var txt=list.options[i].text;
				var val=list.options[i].value;
				mlist.options[j++] = new Option (txt,val) ;
			}
		}
		for(var i = AssociatedSLA.options.length; i > 0 ; i--)
		{
			if(AssociatedSLA.options[i-1].selected == true )
			AssociatedSLA.options[i-1] = null;
		}
		sortAllElement("componentList");
	}
	function addtomanage()
	{
		var thisForm = document.configSLA;
		var serverselected = "false";
		manunmanage = true;
		var AssociatedSLA=document.getElementById("AssociateCompList");
		var DisAssociatedSLA=document.getElementById("componentList");
		//getting list size
		var j = AssociatedSLA.options.length;
		//gettin list vars
		var list = DisAssociatedSLA;
		var mlist = AssociatedSLA;
		var count=0;
		if(list.options.length==0)
		{
			alert("<egui:intnl text='admin.mpolicy.Please choose an element'/>");
			return;
		}
		for(kk=0;kk<list.options.length;kk++)
		{
			if(list.options[kk].selected==true)
			{
				count++;
			}
		}
		if(count==0)
		{
			alert("<egui:intnl text='admin.mpolicy.Please choose an element'/>");
			return;
		}
		for(var i = 0 ; i < list.options.length ; i++)
		{
			//browsing through to find selected items
			if(list.options[i].selected == true)
			{
				serverselected = "true";
				var txt = list.options[i].text;
				var val = list.options[i].value;
				mlist.options[j++] = new Option (txt,val) ;
			}
		}
		for(var i = DisAssociatedSLA.options.length; i > 0 ; i--)
		{
			if(DisAssociatedSLA.options[i-1].selected == true )
				DisAssociatedSLA.options[i-1] = null;
		}
		sortAllElement("AssociateCompList");
	}
	function sortAllElement(boxRefName)
	{
		var boxRef=document.getElementById(boxRefName);
		var tmpTextArray2 = new Array();
		for(var no=0;no<boxRef.options.length;no++)
		{
			tmpTextArray2.push(boxRef.options[no].text + '___' + boxRef.options[no].value);
		}       
		tmpTextArray2.sort();
		sortArray(tmpTextArray2);
		for(var no=0;no<tmpTextArray2.length;no++)
		{
			var items = tmpTextArray2[no].split('___');
			boxRef.options[no] = new Option(items[0],items[1]);
		}
	}
	function sortArray(values)
	{
		var tempArr=new Array();
		for(var i=0;i<values.length;i++)
		{
		tempArr[i]=values[i].toLowerCase();
		}

		for(var i=0;i<tempArr.length-1;i++)
		{
			for(var j=i+1;j<tempArr.length;j++)
			{
				if(tempArr[i]>tempArr[j])
				{
				var temp=tempArr[i];
				tempArr[i]=tempArr[j];
				tempArr[j]=temp;

				var tempValue=values[i];
				values[i]=values[j];
				values[j]=tempValue;
				}
			}
		}
		return values;
	}
	function moveAllTemplates(FromBox,ToBox)
	{
		var thisForm = document.configSLA;
		var templatesselected = "false";
		var count=0;
		var FBox=document.getElementById(FromBox);
		var TBox=document.getElementById(ToBox);
		//getting list size
		var j = TBox.options.length;
		//gettin list vars
		var list = FBox;
		var mlist = TBox;
		if(list.options.length==0 && FromBox=="componentList")
		{
			alert('<egui:intnl text="admin.mpolicy.No components available"/>');
			return;
		}   
		else if(list.options.length==0 && FromBox=="AssociateCompList")
		{
			alert('<egui:intnl text="admin.mpolicy.No components available"/>');
			return;     
		}
		if(list.options.length>0 && FromBox=="AssociateCompList")
		{
			if(list.options[0].value=="-1" && list.options.length==1)
			{
				
				alert('<egui:intnl text="admin.mpolicy.No Infra Elements available to remove from SLA"/>');
				return;
			}
			disflag=true;
		}
		if(list.options.length>0 && FromBox=="componentList")
		{
			if(list.options[0].value=="-1" && list.options.length==1)
			{
				alert('<egui:intnl text="admin.mpolicy.No Infra Elements available to add for SLA"/>');
				return;
			}
			assflag=true;
		}
		for(var i = 0 ; i < list.options.length ; i++)
		{
			//browsing through to find selected items
				templatesselected = "true";
				var txt=list.options[i].text;
				var val=list.options[i].value;
				if((txt!="" && val!="") &&  (txt!=null && val!=null) && (txt!="null" && val!="null") && (txt!=" " && val!=" ") && (txt!="none" && val!="none") && (txt!="Not Applicable!" && val!="-1"))
				{
					mlist.options[j++] = new Option (txt,val) ;
				}
		}
		for(var i=FBox.options.length; i > 0 ; i--)
		{
			if(FBox.options[i-1].text!="Not Applicable!" && FBox.options[i-1].value!="-1")
			{
				FBox.options[i-1] = null;
			}
		}
		sortAllElement(ToBox);
	}
	var barChartDivCount=0;
	function drawBarGraph()
	{
		var contentDiv=document.getElementById("contentDiv");
		var latestDivCount="<%=maxBarChartDivID%>";
		if(latestDivCount && latestDivCount>barChartDivCount)
		{
			barChartDivCount=latestDivCount;
		}
		var str='<div id="divB'+(++barChartDivCount)+'" style="padding-right:5px;margin-bottom:<%=divPadding%>;overflow:hidden;float:left;width:<%=blockWidth%>;height:237px;border:0px solid red;display:block">';
		str+='<table width="100%"  border="0" class="widgetHeader" bordercolor="red" cellspacing="0" cellpadding="0"><tr>';
		str+='<td width="8" height="18" class="customTopLeft eg_whitebg"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>';
		str+='<td class="eg_75bold eg_whitebg" height="18" style="border-right-width:0px" width="30%"><div id="headerBarChartBarChart_'+barChartDivCount+'" ondblclick="javascript:editBarChartHeader(\'BarChart_'+barChartDivCount+'\',\'BarChart\');">BarChartHeader</div></td>';
		str+='<td align="right" style="background-repeat:repeat-x" bgcolor="#FFFFFF" wrap><span><img  src="/final/monitor/eg_images/arrow_forward_black.gif" border="0" id="mouse"><a href="javascript:void(0);" onclick="javascript:loadColumnPopup('+barChartDivCount+',event,false,\'BarChart\');" title="Add Metrics" class="eg_monlink"><egui:intnl text="monitor.dashboard.Add Metrics"/></a></span><span><img  src="/final/monitor/eg_images/arrow_forward_black.gif" border="0" id="mouse"><a href="javascript:void(0);" onclick="javascript:loadRowPopup('+barChartDivCount+',event,false,\'BarChart\');" title="Add Servers" class="eg_monlink"><egui:intnl text="monitor.dashboard.Add Servers"/></a></span></td>';
		str+='<td width="8" align="left" valign="top" class="customTopRight1" bgcolor="#FFFFFF">';
		str+='<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>';
		str+='<td class="customTopRightBg eg_whitebg" align="right" valign="top" style="padding-top:3px;width:20px;border-right-width:0px"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeDiv('+barChartDivCount+',\'barChart\');"/></td>';
		str+='<td width="8" valign="top" class="customTopRight eg_whitebg"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>';
		str+='</tr></table>';
		str+='<div id="contentBarChartDiv'+barChartDivCount+'" style="padding-left:5px;padding-right:5px;padding-top:6px;background-color:#ffffff;overflow:auto;width:<%=divWidth%>;height:205px"/>';
		str+='<table height="100%" border="0" bordercolor="blue" cellpadding="2" cellspacing="0" width="100%">';
		str+='</table>';
		str+='</div>';
		str+='<table width="100%" border="0" cellspacing="0" cellpadding="0"><tr>';
		str+='<td width="8" class="whiteBottLeft"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="8"></td>';
		str+='<td width="100%" bgcolor="#FFFFFF"><img src="/final/monitor/eg_images/spacer.gif" width="1" height="8"></td>';
		str+='<td width="8" class="whiteBottRight"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="8"></td>';
		str+='</tr></table>';
		str+='</div>';
		if(contentDiv!=null)
			contentDiv.innerHTML=contentDiv.innerHTML+str;
	}


	var timelineChartDivCount=0;
	var combinedTimelineChartDivCount=0;
	function drawTimelineGraph(chartType)
	{
		var timelineConfDivCount=0;
		var outerDIVID="divTL";
		var contentTimelineDivID="contentTimelineChartDiv"
		var contentDiv=document.getElementById("contentDiv");
		if(chartType!=null && chartType=="TimelineChart")
		{
			var latestTimelineChartDivCount="<%=maxTimelineChartDivID%>";
			if(latestTimelineChartDivCount && latestTimelineChartDivCount>timelineChartDivCount)
			{
				timelineChartDivCount=latestTimelineChartDivCount;
			}
			timelineConfDivCount=timelineChartDivCount;
		}
		else if(chartType!=null && chartType=="CombinedTimelineChart")
		{
			var latestCombinedTimelineChartDivCount="<%=maxCombinedTimelineChartDivID%>";
			if(latestCombinedTimelineChartDivCount && latestCombinedTimelineChartDivCount>combinedTimelineChartDivCount)
			{
				combinedTimelineChartDivCount=latestCombinedTimelineChartDivCount;
			}
			timelineConfDivCount=combinedTimelineChartDivCount;
			outerDIVID="divCTL";
			contentTimelineDivID="contentCombinedTimelineChartDiv";
			var combinedTimelineChartTitle="CombinedTimelineHeader";
			if(combinedTimelineChartTitle.length>titleLength)
			{
				combinedTimelineChartTitle=combinedTimelineChartTitle.substr(0,(titleLength-4))+"...";
			}
		}
		var str='<div id="'+outerDIVID+(++timelineConfDivCount)+'" style="padding-right:5px;margin-bottom:<%=divPadding%>;overflow:hidden;float:left;width:<%=blockWidth%>;height:237px;border:0px solid green;display:block">';
		str+='<table width="100%"  class="widgetHeader" border="0" bordercolor="red" cellspacing="0" cellpadding="0"><tr>';
		str+='<td width="8" height="18" class="customTopLeft eg_whitebg"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>';
		if(chartType!=null && chartType=="CombinedTimelineChart")
		{
			str+='<td class="eg_75bold eg_whitebg" height="18" style="border-right-width:0px" width="30%"><div id="headerCombinedTimelineChart_'+timelineConfDivCount+'" ondblclick="javascript:editTimelineChartHeader(\'CombinedTimelineChart_'+timelineConfDivCount+'\',\'CombinedTimelineChart\'  );">'+combinedTimelineChartTitle+'</div></td>';
		}
		else
		{
			str+='<td class="eg_75bold eg_whitebg" height="18" style="border-right-width:0px" width="30%"><div id="headerTimelineChartTimelineChart_'+timelineConfDivCount+'" ondblclick="javascript:editTimelineChartHeader(\'TimelineChart_'+timelineConfDivCount+'\',\'TimelineChart\');">TimelineHeader</div></td>';
		}
		str+='<td align="center" style="background-repeat:repeat-x" bgcolor="#FFFFFF" wrap ><span><img  src="/final/monitor/eg_images/arrow_forward_black.gif" border="0" id="mouse"><a href="javascript:void(0);" onclick="javascript:loadColumnPopup('+timelineConfDivCount+',event,false,\''+chartType+'\');" title="Add Metrics" class="eg_monlink"><egui:intnl text="monitor.dashboard.Add Metrics"/></a></span><span><img  src="/final/monitor/eg_images/arrow_forward_black.gif" border="0" id="mouse"><a href="javascript:void(0);" onclick="javascript:loadRowPopup('+timelineConfDivCount+',event,false,\''+chartType+'\');" title="Add Servers" class="eg_monlink"><egui:intnl text="monitor.dashboard.Add Servers"/></a></span></td>';
		str+='<td width="8" align="left" valign="top" class="customTopRight1 " bgcolor="#FFFFFF">';
		str+='<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>';
		if(chartType!=null && chartType=="CombinedTimelineChart")
		{
			str+='<td class="customTopRightBg eg_whitebg" align="right" valign="top" style="padding-top:3px;width:20px;border-right-width:0px"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeDiv('+timelineConfDivCount+',\'CombinedTimelineChart\');"/></td>';
		}
		else
		{
			str+='<td class="customTopRightBg eg_whitebg" align="right" valign="top" style="padding-top:3px;width:20px;border-right-width:0px"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeDiv('+timelineConfDivCount+',\'TimelineChart\');"/></td>';
		}
		str+='<td width="8" valign="top" class="customTopRight eg_whitebg"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>';		
		str+='</tr></table>';
		str+='<div id="'+contentTimelineDivID+timelineConfDivCount+'" style="padding-left:5px;padding-right:5px;padding-top:6px;background-color:#ffffff;overflow:auto;width:<%=divWidth%>;height:205px"/>';
		str+='<table height="100%" border="0" bordercolor="blue" cellpadding="2" cellspacing="0" width="100%">';
		str+='</table>';
		str+='</div>';
		str+='<table width="100%" border="0" cellspacing="0" cellpadding="0"><tr>';
		str+='<td width="8" class="whiteBottLeft"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="8"></td>';
		str+='<td width="100%" bgcolor="#FFFFFF"><img src="/final/monitor/eg_images/spacer.gif" width="1" height="8"></td>';
		str+='<td width="8" class="whiteBottRight"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="8"></td>';
		str+='</tr></table>';
		str+='</div>';
		if(chartType!=null && chartType=="TimelineChart")
		{
			timelineChartDivCount=timelineConfDivCount;
		}
		else if(chartType!=null && chartType=="CombinedTimelineChart")
		{
			combinedTimelineChartDivCount=timelineConfDivCount;
		}
		if(contentDiv!=null)
			contentDiv.innerHTML=contentDiv.innerHTML+str;
	}
	function drawTable()
	{
		var contentDiv=document.getElementById("contentDiv");
		var latestDivCount="<%=maxDivID%>";
		if(latestDivCount && latestDivCount>divCount)
		{
			divCount=latestDivCount;
		}
		var str='<div id="divT'+(++divCount)+'" style="padding-right:5px;margin-bottom:<%=divPadding%>;overflow:hidden;float:left;width:<%=blockWidth%>;height:237px;border:0px solid blue;display:block;position:relative">';
		str+='<table width="100%" class="widgetHeader" border="0" bordercolor="red" cellspacing="0" cellpadding="0"><tr>';
		str+='<td width="8" height="18" class="customTopLeft eg_whitebg"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>';
		str+='<td class="eg_75bold eg_whitebg" height="18" style="border-right-width:0px" width="30%"><div id="headertable_'+divCount+'" ondblclick="javascript:editTableHeader(\'table_'+divCount+'\',\'tables\');">Table Header</div></td>';
		str+='<td align="center" style="background-repeat:repeat-x" bgcolor="#FFFFFF" wrap ><span><img  src="/final/monitor/eg_images/arrow_forward_black.gif" border="0" id="mouse"><a href="javascript:void(0);" onclick="javascript:loadColumnPopup('+divCount+',event,false,\'ComparisonTable\');" title="Add Metrics" class="eg_monlink"><egui:intnl text="monitor.dashboard.Add Metrics"/></a></span><span><img  src="/final/monitor/eg_images/arrow_forward_black.gif" border="0" id="mouse"><a href="javascript:void(0);" onclick="javascript:loadRowPopup('+divCount+',event,false,\'ComparisonTable\');" title="Add Servers" class="eg_monlink"><egui:intnl text="monitor.dashboard.Add Servers"/></a></span></td>';
		str+='<td width="8" align="left" valign="top" class="customTopRight1" bgcolor="#FFFFFF">';
		str+='<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>';
		str+='<td class="customTopRightBg eg_whitebg" align="right" valign="top" style="padding-top:3px;width:20px;border-right-width:0px"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeDiv('+divCount+',\'table\');"/></td>';
		str+='<td width="8" valign="top" class="customTopRight eg_whitebg"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>';
		str+='</tr></table>';
		str+='<div id="contentDiv'+divCount+'" style="position:relative;padding-left:5px;padding-right:5px;padding-top:6px;background-color:#ffffff;overflow:auto;width:<%=divWidth%>;height:205px;border:0px solid black"/>';
		str+='<table height="100%" border="0" bordercolor="blue" cellpadding="2" cellspacing="0" width="100%">';
		str+='</table>';
		str+='</div>';
		str+='<table width="100%" border="0" cellspacing="0" cellpadding="0"><tr>';
		str+='<td width="8" class="whiteBottLeft"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="8"></td>';
		str+='<td width="100%" bgcolor="#FFFFFF"><img src="/final/monitor/eg_images/spacer.gif" width="1" height="8"></td>';
		str+='<td width="8" class="whiteBottRight"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="8"></td>';
		str+='</tr></table>';
		str+='<input type="hidden" id="hidTest'+divCount+'"/>';
		str+='<input type="hidden" id="DivNewValue'+divCount+'"/>';
		str+='<input type="hidden" id="DivAllValue'+divCount+'"/>';
		str+='<input type="hidden" id="hidTestMapping'+divCount+'"/>';
		str+='</div>';
		if(contentDiv!=null)
			contentDiv.innerHTML=contentDiv.innerHTML+str;
	}
	var vKey2Rename = "";
	var graphName;
	function editTableHeader(divId,func)
	{
		vKey2Rename = func;
		findDivId = divId;
		findFunc = func;
		graphName = "Table";
		var header=document.getElementById('header'+divId);
		if(header!=null && header.getElementsByTagName("input").length==0)
		{
			var tempStr=header.innerHTML;
			header.innerHTML='<input type="text" id="txtMapping'+divId+'" value="'+tempStr+'" onblur=updateTableTitle("'+divId+'"); maxlength='+titleLength+' onKeyDown=onEnterPressing(event)>';
			var txtMapping=document.getElementById('txtMapping'+divId);
			if(txtMapping!=null)
				txtMapping.focus();
		}
	}
	var vKey2Rename = "";
	function editBarChartHeader(divId,func)
	{
		vKey2Rename = func;
		findDivId = divId;
		findFunc = func;
		graphName = "BarChart";
		var header=document.getElementById('headerBarChart'+divId);
		if(header!=null && header.getElementsByTagName("input").length==0)
		{
			var tempStr=header.innerHTML;
			header.innerHTML='<input type="text" id="txtMapping'+divId+'" value="'+tempStr+'" onblur=updateBarChartTitle("'+divId+'"); maxlength='+titleLength+' onKeyDown=onEnterPressing(event)>';
			var txtMapping=document.getElementById('txtMapping'+divId);
			if(txtMapping!=null)
				txtMapping.focus();
		}
	}
	function updateBarChartTitle(divId)	
	{
		var header=document.getElementById('headerBarChart'+divId);
		var txtMapping=document.getElementById('txtMapping'+divId);
		var vTitle="";
		if(txtMapping!=null && header!=null)
		{
			vTitle=txtMapping.value;
			var renameTextValue=txtMapping.value;
			if(renameTextValue!=null && renameTextValue=="")
			{
				header.innerHTML='<egui:intnl text="monitor.dashboard.BarChartHeader"/>';
				return;
			}
			else
			{
				header.innerHTML=renameTextValue;
			}
		}
		vKey2Rename=divId+"_Title";
		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=rename&&profileName=<%=profileName%>&key="+vKey2Rename+"&value="+vTitle+"&&replaceValue=true";
		updateIniFile(url);
	}
	function updateTableTitle(divId)
	{
		var header=document.getElementById('header'+divId);
		var txtMapping=document.getElementById('txtMapping'+divId);
		var vTitle="";
		if(txtMapping!=null && header!=null)
		{
			vTitle=txtMapping.value;
			var renameTextValue=txtMapping.value;
			if(renameTextValue!=null && renameTextValue=="")
			{
				header.innerHTML='<egui:intnl text="monitor.dashboard.TableHeader"/>';
				return;
			}
			else
			{
				header.innerHTML=renameTextValue;
			}
		}
		if(vKey2Rename!=null && vKey2Rename=="tables")
			vKey2Rename=divId+"_Title";
		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=rename&&profileName=<%=profileName%>&key="+vKey2Rename+"&value="+vTitle+"&replaceValue=true";
		updateIniFile(url);
	}

	var vKey2Rename = "";
	var findDivId,findFunc;
	function editTimelineChartHeader(divId,func)
	{
		vKey2Rename = func;
		findDivId = divId;
		findFunc = func;
		graphName = "TimelineChart";
		var header=document.getElementById('headerTimelineChart'+divId);
		if(func!=null && func=="CombinedTimelineChart")
			header=document.getElementById('header'+divId);
		if(header!=null && header.getElementsByTagName("input").length==0)
		{
			var tempStr=header.innerHTML;
			header.innerHTML='<input type="text" id="txtMapping'+divId+'" value="'+tempStr+'" onblur=updateTimelineChartTitle("'+divId+'","'+func+'"); maxlength='+titleLength+' onKeyDown=onEnterPressing(event)>';
			var txtMapping=document.getElementById('txtMapping'+divId);
			if(txtMapping!=null)
				txtMapping.focus();
		}
	}
	function onEnterPressing(event)
	{
		if ( event == null )
			event=(isIE())?window.event:event;
		if( event.keyCode == 13 && findFunc != null && findDivId != null)
		{
			if ( graphName =="TimelineChart")
				updateTimelineChartTitle(findDivId,findFunc);
			else if ( graphName =="BarChart")
				updateBarChartTitle(findDivId);
			else if ( graphName =="Table")
				updateTableTitle(findDivId,findFunc);
		}
		else
			return;
	}
	function updateTimelineChartTitle(divId,func)	
	{
		var header=document.getElementById('headerTimelineChart'+divId);
		if(func!=null && func=="CombinedTimelineChart")
		{
			header=document.getElementById('header'+divId);
		}
		var txtMapping=document.getElementById('txtMapping'+divId);
		var vTitle="";
		if(txtMapping!=null && header!=null)
		{
			vTitle=txtMapping.value;
			var renameTextValue=txtMapping.value;
			if(renameTextValue!=null && renameTextValue=="")
			{
				if(func!=null && func=="CombinedTimelineChart")
				{
					var combinedTimelineChartTitle="CombinedTimelineHeader";
					if(combinedTimelineChartTitle.length>titleLength)
					{
						combinedTimelineChartTitle=combinedTimelineChartTitle.substr(0,(titleLength-4))+"...";
					}
					header.innerHTML=combinedTimelineChartTitle;
				}
				else
				{
					header.innerHTML='<egui:intnl text="monitor.dashboard.TimelineHeader"/>';
				}
				return;
			}
			else
			{
				header.innerHTML=renameTextValue;
			}
		}
		vKey2Rename=divId+"_Title";
		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+"&action=rename&&profileName=<%=profileName%>&key="+vKey2Rename+"&value="+vTitle+"&replaceValue=true";
		updateIniFile(url);
	}
	function removeDiv(divCount,chartType)
	{
		var chartType_Divcount = chartType+"_"+divCount;
		if (divIdForUpDate != null && divIdForUpDate.indexOf(chartType_Divcount) != -1)
			isRemoveDivMethd = true;
		else
			isRemoveDivMethd = false;
		if(chartType != null && chartType == "table")
		removeTable(divCount);
		if(chartType != null && chartType == "barChart")
			removeBarChart(divCount);
		if(chartType != null && chartType == "TimelineChart" || chartType == "CombinedTimelineChart")
			removeTimelineChart(divCount,chartType);
	}
	function removeTable(divCount)
	{
		var ans = true;
		if ( isRemoveDivMethd )
			ans = confirm("Configurations will be lost, Do you want to proceed","ok","cancel");
		if ( ans )
		{
			var div=document.getElementById("contentDiv"+divCount);
			if(div!=null)
			{
				div.style.display="none";
				var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+'&action=deleteTable&profileName=<%=profileName%>&key=table_'+divCount;
				updateIniFile(url);
				hideElement(div);
				hideElement("divT"+divCount);
			}
		}
		isRemoveDivMethd = true;
	}
	function removeBarChart(bdivCount)
	{
		var ans = true;
		if ( isRemoveDivMethd )
			ans = confirm("Configurations will be lost, Do you want to proceed","ok","cancel");
		if ( ans )
		{
			var div=document.getElementById("contentBarChartDiv"+bdivCount);
			if(div!=null)
			{
				div.style.display="none";
				var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+'&action=deleteTable&profileName=<%=profileName%>&key=BarChart_'+bdivCount;
				updateIniFile(url);
				hideElement(div);
				hideElement("divB"+bdivCount);
			}
		}
		isRemoveDivMethd = true;
	}
	function removeTimelineChart(tdivCount,chartType)
	{
		var ans = true;
		if ( isRemoveDivMethd )
			ans = confirm("Configurations will be lost, Do you want to proceed","ok","cancel");
		if ( ans )
		{
			var div=document.getElementById("contentTimelineChartDiv"+tdivCount);
			if(chartType!=null && chartType=="CombinedTimelineChart")
			{
				div=document.getElementById("contentCombinedTimelineChartDiv"+tdivCount);
			}
			if(div!=null)
			{
				div.style.display="none";
				var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomController?")%>'+'&action=deleteTable&from=TimelineChart&profileName=<%=profileName%>&key='+chartType+'_'+tdivCount;
				updateIniFile(url);
				hideElement(div);
				if(chartType!=null && chartType=="CombinedTimelineChart")
				{
					hideElement("divCTL"+tdivCount);
				}
				else
				{
					hideElement("divTL"+tdivCount);
				}
			}
		}
		isRemoveDivMethd = true;
	}
	function gotoDesignView(url)
	{
		window.location.href=url+"&screenWidth="+documentView.getWidth()+"&screenHeight="+documentView.getHeight();
	}
</script>
</head>
<body topmargin="0" leftmargin="0" class="eg_medium" onload="javascript:myResize();" onmousemove="javascript:drag(event);" onmouseup="javascript:endDrag(event);" style="overflow:hidden">
<div id="dummyDiv" style="display:none;width:200px;height:200px;position:absolute;">Dummy Div</div>
<iframe id="iframe1" name="iframe1" frameborder="1" width="0" height="0" style="display:none;position:absolute;z-index:10"></iframe>
<div id="propertyDiv" style="display:none;left:500px;top:100px;width:600px;height:400px;position:absolute;border:0px solid #ff0000;z-index:550;" onmousemove="javascript:drag(event);" onmouseup="javascript:endDrag(event);">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0" width="700">
	<tr>
		<td colspan="3"  height="20px" onmousedown="javascript:startDrag('propertyDiv',event);">
			<table border="0"  cellpadding="0" cellspacing="0" width="100%">
				<tr>
					<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
					<td id="GraphTitle" class="popup_topbg eg_75bold whitefont"  height="27px"><egui:intnl text="monitor.dashboard.Add/Modify"/></td>
					<td align="right" class="popup_topbg"><img id="closeImg" src="/final/monitor/eg_images/<%=monitor_Skin%>/popup_close.png" border="0" class="mouse" title="close" vspace="2" onclick="hideElement('propertyDiv');"> </td>
					<td width="17" height="27" class="popup_topright"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
		<!-- <td align="center" valign="top" class="white_bg" style="width:300px"> -->
		<td align="center" valign="top" class="white_bg" style="width:100%">
			<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="500" class="white_bg">
				<tr>
					<!-- <td align="center" style="width:300px"> -->
					<td align="center" style="width:100%" valign="top">
						<div id="propertyContentDiv"></div>
					</td>
				</tr>
			</table>
		</td>
		<td class="popup_rightbg" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
	</tr>
	<tr>
		<td class="popup_bottomleft"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
		<td  class="popup_bottombg" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
		<td class="popup_bottomright"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
	</tr>
</table>
</div>
<div id="toolsDiv" style="display:block;left:50px;top:30px;position:absolute;border:0px solid #ff0000;z-index:500;">
	<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
		<tr>
			<td colspan="3" width="100%" height="21px" onmousedown="javascript:startDrag('toolsDiv',event);">
				<table border="0"  cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td width="5" height="22" class="tool_top_left"><img src="/final/monitor/eg_images/spacer.gif" width="5" height="22" border="0"></td>
						<td id="GraphTitle" class="tool_top_bg eg_75bold whitefont"  height="22px" >Tools &nbsp;</td>
						<td align="right" class="tool_top_bg" style="padding-top:2px"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/popup_close.png" border="0" class="mouse" title="close" onclick="javascript:hideToolBox('toolsDiv');"> </td>
						<td width="9" height="22" class="tool_top_right"><img src="/final/monitor/eg_images/spacer.gif" width="9" height="22" border="0"></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td class="tool_left_bg toolbg" width="4"><img src="/final/monitor/eg_images/spacer.gif" width="5"></td>
			<td align="center" valign="top" class="toolbg" width="60">
				<table  border="0"bordercolor="red" cellpadding="1" cellspacing="0" align="center">
					<tr>
						<td align="center"><img src="/final/monitor/eg_images/icon_custom_timeline_mmm.png" title="Combined Timeline Chart"  onmouseover="this.src='/final/monitor/eg_images/icon_custom_timeline_mmm_ov.png'" onmouseout="this.src='/final/monitor/eg_images/icon_custom_timeline_mmm.png'" onclick="javascript:drawTimelineGraph('CombinedTimelineChart');"/></td>
					</tr>
					<tr>
					
						<td align="center"><img src="/final/monitor/eg_images/icon_comparision.png" title="Bar Chart" onmouseover="this.src='/final/monitor/eg_images/icon_comparision_over.png'" onmouseout="this.src='/final/monitor/eg_images/icon_comparision.png'" onclick="javscript:drawBarGraph();"/></td>
					</tr>
					<tr>
						<td align="center" ><img src="/final/monitor/eg_images/icon_table.png" title="Comparison Table" onmouseover="this.src='/final/monitor/eg_images/icon_table_over.png'" onmouseout="this.src='/final/monitor/eg_images/icon_table.png'" onclick="javascript:drawTable();"/></td>
					</tr>
					<tr>
						<td align="center"><img src="/final/monitor/eg_images/icon_custom_timeline.png" title="Timeline Chart"  onmouseover="this.src='/final/monitor/eg_images/icon_custom_timeline_over.png'" onmouseout="this.src='/final/monitor/eg_images/icon_custom_timeline.png'" onclick="javascript:drawTimelineGraph('TimelineChart');"/></td>
					</tr>
				</table>
			</td>
			<td class="tool_right_bg" width="4"><img src="/final/monitor/eg_images/spacer.gif" width="9"></td>
		</tr>
		<tr>
			<td class="tool_bottom_left"><img src="/final/monitor/eg_images/spacer.gif" width="5" height="10"></td>
			<td  class="tool_bottom_bg" height="10" width="50"><img src="/final/monitor/eg_images/spacer.gif"></td>
			<td class="tool_bottom_right"><img src="/final/monitor/eg_images/spacer.gif" width="9" height="10"></td>
		</tr>
	</table>
</div>
<%
if (isChrome)
{
%>
<!-- <div style="width:99.9%;border:0px solid #ff8888;" class="layer_headbg"> -->
<div style="width:99.9%;border:0px solid #ff8888;margin:0px;padding:0px" class="layer_headbg">
<%
}
else if (isFirefox)
{
%>
<!-- <div style="width:100%;border:2px solid #ff8888;" class="layer_headbg"> -->
<div style="width:100.5%;border:0px solid #ff8888;margin:0px;padding:0px" class="layer_headbg">
<%
}
else
{
%>
<!-- <div style="width:100%;border:2px solid #ff8888;" class="layer_headbg"> -->
<div style="width:100%;border:0px solid #ff8888;margin:0px;padding:0px" class="layer_headbg">
<%
}
%>
	<table  border="0" width="100%" class="padding2" cellspacing="0" cellpadding="0" height="25">
	<col width="50%"><col width="50%">
		<tr>
			<td  align="right" nowrap>
				<table  border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td  id="main_head"> <egui:intnl text="monitor.dashboard.Template"/>&nbsp;:&nbsp;</td>
			<td id="main_head" align="left" style="font-weight:normal" nowrap><%=profileName%></td>
					</tr>
				</table>
			</td>
			<td align="right" style="padding:0px">
				<table  border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td align="center" style="width:50px">
							<div id="iconBg" style="display:none;margin:0px;padding:0px"> <img id="toolsImg" src="/final/monitor/eg_images/spacer.gif" onclick="javascript:showToolBox();" title="Toolbox" border="0"/> </div>
			</td>
						<td >
<%
	String urlForView=response.encodeURL("/final/monitor/egCustomView.jsp?")+"profileName="+profileName;
%>
				<table cellspacing="0" cellpadding="0" border="0">
					<tr>
									<td>&nbsp;</td>
									<td> <img src="/final/monitor/eg_images/<%=monitor_Skin%>/custom_view.png" border="0" onclick="javascript:showElement('toolsDiv');" title="Preview"/> </td>
									<td>&nbsp;</td>
									<td><a class="qin_link" href="javascript:void(0);" onclick="javscript:gotoDesignView('<%=urlForView%>');"><egui:intnl text="admin.auditlog.View"/></a>
						</td>
					</tr>
				</table>
			</td>
						<td>&nbsp;</td>
			<td style="padding-right:4px" align="right" width="100">
							<a class="home_subhead" href="javascript:BacktoList();"> <img src='/final/admin/eg_images/back-arrow.gif' border='0'>&nbsp;<egui:intnl text="monitor.common.Back to list"/>&nbsp;&nbsp;</a>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</div>
<%
if (isMSIE)
{
%>
<div id="contentDiv" class="div_scroll" style="display:table;overflow-x:hidden;padding:5px 0px 5px 5px;width:100%;height:96%;border:0px solid violet;">
<%
}
else if(isChrome)
{
%>
<div id="contentDiv" class="div_scroll" style="display:block;overflow-x:hidden;padding:5px 0px 5px 5px;width:98.9%;height:85%;border:0px solid violet;">
<%
}
else if(isFirefox)
{
%>
<div id="contentDiv" class="div_scroll" style="display:block;overflow-x:hidden;padding:5px 0px 5px 5px;width:100%;height:80%;border:0px solid violet;">
<%
}	
%>
<%
	if(configuredCombinedTimelineCharts!=null && !configuredCombinedTimelineCharts.isEmpty())
	{
		Iterator itrCompTables=configuredCombinedTimelineCharts.iterator();
		while(itrCompTables.hasNext())
		{
			String varName=(String)itrCompTables.next();
			String designURL="/final/monitor/egCustomTimelineChartTableDesign.jsp?from=CombinedTimelineChart&profileName="+profileName+"&combinedTimelineChartID="+varName.substring(0,varName.lastIndexOf("_"))+"&savedTimelineChart=true";
			int tID=Integer.parseInt(varName.substring(varName.indexOf("_")+1,varName.lastIndexOf("_")));
%>
<!--------------------------------- Timeline Chart------------------------------------------------------------------->
	<div id="<%="contentCombinedTimelineChartDiv"+tID%>" style="padding-right:5px;margin-bottom:<%=divPadding%>;overflow:hidden;float:left;width:<%=blockWidth%>;height:237px;border:0px solid red;display:block">
		<table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td width="8" height="18" class="customTopLeft">
					<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18">
				</td>
				<td class="eg_75bold eg_whitebg" height="18" style="border-right-width:0px">
					<div id="<%="headerCombinedTimelineChart"+tID%>" ondblclick="javascript:editTimelineChartHeader('<%=tID%>','CombinedTimelineChart');">
					</div>
				</td>
				<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF">
					<table border="0" cellspacing="0" cellpadding="0" width="100%">
						<tr>
							<td>
								<table border="0" cellspacing="0" cellpadding="0" width="100%">
									<tbody id="<%=varName%>">
									</tbody>
								</table>
							</td>
						</tr>
					</table>
				</td>
				<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF">
					<img src="/final/monitor/eg_images/spacer.gif" onload="javascript:loadComparisonTableDesign('<%=designURL%>','<%="contentCombinedTimelineChartDiv"+(tID)%>',event,'TimelineChart');"/>
				</td>
				<td width="8" valign="top" class="customTopRight">
					<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18">
				</td>
			</tr>
		</table>
	</div>
<%
		}
	}
	if(configurationBarChartTables!=null && !configurationBarChartTables.isEmpty())
	{
		Iterator itrCompTables=configurationBarChartTables.iterator();
		while(itrCompTables.hasNext())
		{
			String varName=(String)itrCompTables.next();
			String designURL="/final/monitor/egCustomBarChartTableDesign.jsp?profileName="+profileName+"&barChartID="+varName.substring(0,varName.lastIndexOf("_"))+"&savedBarChart=true";
			int tID=Integer.parseInt(varName.substring(varName.indexOf("_")+1,varName.lastIndexOf("_")));
%>
	<div id="<%="contentBarChartDiv"+tID%>" style="margin-bottom:<%=divPadding%>;overflow:hidden;padding-right:6px;float:left;width:<%=blockWidth%>;height:237px;border:0px solid yellow" >
		<table width="100%" border="0" cellspacing="0" cellpadding="0" height="100%">
			<tr>
				<td width="8" height="18" class="customTopLeft">
					<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18">
				</td>
				<td class="eg_75bold eg_whitebg" height="18" style="border-right-width:0px">
					<div id="<%="headerBarChart"+tID%>" ondblclick="javascript:editBarChartHeader('<%=tID%>','BarChart');">
					</div>
				</td>
				<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF">
					<table border="0" cellspacing="0" cellpadding="0" width="100%">
						<tr>
							<td>
								<table border="0" cellspacing="0" cellpadding="0" width="100%">
									<tbody id="<%=varName%>">
									</tbody>
								</table>
							</td>
						</tr>
					</table>
				</td>
				<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF">
					<img src="/final/monitor/eg_images/spacer.gif" onload="javascript:loadComparisonTableDesign('<%=designURL%>','<%="contentBarChartDiv"+(tID)%>',event,'BarChart');"/>
				</td>
				<td width="8" valign="top" class="customTopRight">
					<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18">
				</td>
			</tr>
		</table>
	</div>
<%
		}
	}
	if(configureComparisonTables!=null && !configureComparisonTables.isEmpty())
	{
		Iterator itrCompTables=configureComparisonTables.iterator();
		while(itrCompTables.hasNext())
		{
			String varName=(String)itrCompTables.next();
			String designURL="/final/monitor/egCustomComparisonTableDesign.jsp?profileName="+profileName+"&tableID="+varName.substring(0,varName.lastIndexOf("_"))+"&savedTable=true";
			int tID=Integer.parseInt(varName.substring(varName.indexOf("_")+1,varName.lastIndexOf("_")));
%>
	<div id="<%="contentDiv"+tID%>" style="background-color:transparent;margin-bottom:<%=divPadding%>;width:<%=blockWidth%>;overflow:hidden;padding-right:5px;float:left;height:237px;border:0px solid red" >
		<table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td width="8" height="18" class="customTopLeft">
					<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18">
				</td>
				<td class="eg_75bold eg_whitebg" height="18" style="border-right-width:0px">
					<div id="<%="header"+tID%>" ondblclick="javascript:editTableHeader('<%=tID%>','tables');">
					</div>
				</td>
				<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF">
					<table border="0" cellspacing="0" cellpadding="0" width="100%">
						<tr>
							<td>
								<table border="0" cellspacing="0" cellpadding="0" width="100%">
									<tbody id="<%=varName%>">
									</tbody>
								</table>
							</td>
						</tr>
					</table>
				</td>
				<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF">
					<img src="/final/monitor/eg_images/spacer.gif" onload="javascript:loadComparisonTableDesign('<%=designURL%>','<%="contentDiv"+(tID)%>',event,'compTable');"/>
				</td>
				<td width="8" valign="top" class="customTopRight">
					<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18">
				</td>
			</tr>
		</table>
	</div>
<%
		}
	}	
	if(configuredTimelineCharts!=null && !configuredTimelineCharts.isEmpty())
	{
		Iterator itrCompTables=configuredTimelineCharts.iterator();
		while(itrCompTables.hasNext())
		{
			String varName=(String)itrCompTables.next();
			String designURL="/final/monitor/egCustomTimelineChartTableDesign.jsp?profileName="+profileName+"&timelineChartID="+varName.substring(0,varName.lastIndexOf("_"))+"&savedTimelineChart=true";
			int tID=Integer.parseInt(varName.substring(varName.indexOf("_")+1,varName.lastIndexOf("_")));
%>
<!--------------------------------- Timeline Chart------------------------------------------------------------------->
	<div id="<%="contentTimelineChartDiv"+tID%>" style="background-color:transparent;margin-bottom:<%=divPadding%>;width:<%=blockWidth%>;overflow:hidden;padding-right:5px;float:left;height:237px;border:0px solid yellow" >
	
		<table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td width="8" height="18" class="customTopLeft">
					<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18">
				</td>
				<td class="eg_75bold eg_whitebg" height="18" style="border-right-width:0px">
					<div id="<%="headerTimelineChart"+tID%>" ondblclick="javascript:editTimelineChartHeader('<%=tID%>','TimelineChart');">
					</div>
				</td>
				<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF">
					<table border="0" cellspacing="0" cellpadding="0" width="100%">
						<tr>
							<td>
								<table border="0" cellspacing="0" cellpadding="0" width="100%">
									<tbody id="<%=varName%>">
									</tbody>
								</table>
							</td>
						</tr>
					</table>
				</td>
				<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF">
					<img src="/final/monitor/eg_images/spacer.gif" onload="javascript:loadComparisonTableDesign('<%=designURL%>','<%="contentTimelineChartDiv"+(tID)%>',event,'TimelineChart');"/>
				</td>
				<td width="8" valign="top" class="customTopRight eg_whitebg">
					<img src="/final/monitor/eg_images/spacer.gif" width="8" height="18">
				</td>
			</tr>
		</table>
	</div>
<%
		}
	}
%>
</div>
</body>
</html>
<%
}
catch(Exception ex)
{
	ex.printStackTrace();
}
//System.out.println("Custom Design Page loaded");
%>

