<%@ taglib prefix = "egui" uri = "../../../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "net.sf.json.JSONArray"%>
<%@ page import="com.eg.EgManagersIniForManager"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ include file="../../../admin/EgAdminTracker.jsp" %>
<%
	try
	{
		User user = registry.getUser(session.getId());
		com.egurkha.ini.IniUI uiObj = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
		String thisLanguage = uiObj.getDefaultLanguage();
		if (user!=null)
		{
			String userLang = user.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage=userLang;
			}
		}

		String entry = null;
		String newWindow = request.getParameter("newwindow");

		if (StringUtils.isNull(newWindow))
		{
			entry = (String) session.getAttribute("egEntryMain");
		}
		else
		{
			entry = (String) session.getAttribute("egEntryChild");
		}

		if (entry == null || entry.equalsIgnoreCase("null"))
		{
			entry = "admin";
		}
		
		String fromSm = request.getParameter("fromsuper");
		if(fromSm == null)
			fromSm = (String) session.getAttribute("fromSm");

		EgUserRole userRole = user.getUserRole();
		boolean hasAdminTab = userRole.hasAnyAdminRole(EgUserPermission.ADMIN);
		boolean hasReporterTab = userRole.hasAnyReporterRole(EgUserPermission.REPORTER);
		boolean hasConfigTab = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
		boolean hasMonitorTab = userRole.hasAnyMonitorRole(EgUserPermission.MONITOR);
		
		
		boolean isAdmin   = entry.equalsIgnoreCase("admin");
		boolean isMonitor = entry.equalsIgnoreCase("monitor");
		boolean isReport  = entry.equalsIgnoreCase("reporter");
		boolean isConfig  = entry.equalsIgnoreCase("config");
		
		boolean isSecondaryManager = false;
		EgManagersIniForManager mi = null;
		if(EgInstallInfo.isClusterSupported)
		{
			mi = EgManagersIniForManager.getInstance();
			if(!mi.isPrimaryManager())
			{
				isSecondaryManager = true;
				if(isAdmin && hasAdminTab && hasMonitorTab)
				{
					isAdmin=false;
					isMonitor=true;
					entry="monitor";
				}
				if(isAdmin && hasAdminTab && hasConfigTab)
				{
					isAdmin=false;
					isConfig=true;
					entry="config";
				}
				if(isAdmin && hasAdminTab && hasReporterTab)
				{
					isAdmin=false;
					isReport=true;
					entry="reporter";
				}
			}
		}
		
		EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
		JSONObject rootJson = new JSONObject();
		JSONArray mList = new JSONArray();
		
		String QLinkHeader ="";
		QLinkHeader= "<div style='float:left;margin:0px 4px 0px 2px;'>"+mappingInfo.getTextDescription("admin.profile.Quick Links")+"</div><div style='float:right;cursor:pointer;cursor:hand' title='close' id='closeQuickmenuLink'></div><div style='float:right;cursor:pointer;cursor:hand;margin:4px 20px 0px 2px;' class='iconConfigUser' title='configure' id='configureQuickmenuLink' onclick='javascript:configureQuickLinks();'></div>";
		
		String strRequestFrom = request.getParameter("comeFrom");
		String strModuleName = request.getParameter("moduleName");

		if (strRequestFrom != null && strRequestFrom.equalsIgnoreCase("profile"))
		{
			strModuleName = null;
		}

		if (strModuleName == null)
		{
			if (entry.equalsIgnoreCase("admin"))
			{
				strModuleName = "Admin";
			}
			else if (entry.equalsIgnoreCase("monitor"))
			{
				strModuleName = "Monitor";
			}
			else if (entry.equalsIgnoreCase("reporter"))
			{
				strModuleName = "Reporter";
			}
			else if (entry.equalsIgnoreCase("config"))
			{
				strModuleName = "Configuration";
			}
		}
	else
	{
	}
		IniFile QMIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_quickmenu.ini");
		String[] arrModules = QMIni.getVariables(user.getLoginID());
		ArrayList aListModules = new ArrayList();
		if (arrModules != null && arrModules.length > 0)
		{
			if (newWindow != null && newWindow.trim().length() > 0 && newWindow.equals("yes"))
			{
				if(fromSm == null)
					fromSm = (String) session.getAttribute("fromSm");
				if(fromSm != null && (fromSm.equals("yes") || fromSm.equals("home")))
				{
					// Coming from super manager so all tabs are necessary, dont limit any tab.
				}
				else
				{
					if (entry.equalsIgnoreCase("admin"))
					{
						arrModules = new String[]{"Admin"};
					}
					else if (entry.equalsIgnoreCase("monitor"))
					{
						arrModules = new String[]{"Monitor"};
					}
					else if (entry.equalsIgnoreCase("reporter"))
					{
						arrModules = new String[]{"Reporter"};
					}
					else if (entry.equalsIgnoreCase("config"))
					{
						arrModules = new String[]{"Configuration"};
					}
				}
			}

			for (int z=0;z<arrModules.length;z++)
			{
				String strModule = arrModules[z];

				if (strModule.equalsIgnoreCase("Admin") && (!hasAdminTab || isSecondaryManager))
				{
					continue;
				}
				else if (strModule.equalsIgnoreCase("Monitor") && !hasMonitorTab)
				{
					continue;
				}
				else if (strModule.equalsIgnoreCase("Reporter") && 
						(!EgInstallInfo.isReporterSupported || !hasReporterTab))
				{
					continue;
				}
				else if (strModule.equalsIgnoreCase("Configuration") && 
						(!EgInstallInfo.isConfigSupported || !hasConfigTab))
				{
					continue;
				}

				aListModules.add(strModule);
			}
			rootJson.put("comboFlag","true");
		}
		else
		{
			//code
			QLinkHeader= "<div style='float:left;margin:0px 4px 0px 2px;' >"+mappingInfo.getTextDescription("admin.profile.Quick Links")+"</div><div style='float:right;cursor:pointer;cursor:hand' class='iconQuickLinksClose' title='close' id='closeQuickmenuLink'></div>";
			String configureLink="<table width='100%' height='333px' ><tr><td align='center' valign='middle'><div class='iconInformation'></div><span class='sublinks'>Please&nbsp;<span style='text-decoration: underline;' ><a href='/final/admin/egQuickMenu.jsp' target='main' class='linkColor'>configure</a></span>&nbsp;<span>quick links</span></span></td></tr></table>";
			rootJson.put("comboFlag","false");
			rootJson.put("configureLink",configureLink);
		
		}
		rootJson.put("QLinkHeader",QLinkHeader);
		
		String strModule="";
		if (aListModules != null && !aListModules.isEmpty())
		{
			String selectedModule = "";
			for (int z=0;z<aListModules.size();z++)
			{
				strModule = (String)aListModules.get(z);
				String selected = "";
				if (strModuleName != null && strModuleName.equalsIgnoreCase(strModule))
				{
					selected = "selected";
					selectedModule = strModuleName;				
				}
		
				JSONObject jobj = new JSONObject();
				jobj.put("displayField",strModule);
				jobj.put("valueField",strModule);
				mList.add(jobj);
			}
			if(!selectedModule.equals(""))
			{				
				rootJson.put("entrySet",selectedModule);					
			}
			else
			{
				String defaultModule = (String) aListModules.get(0);
				rootJson.put("entrySet",defaultModule);	
			}
		}
		rootJson.put("modulesList",mList.toString());
		//System.out.println("rootJson---->"+rootJson);
		response.getWriter().write(rootJson.toString());
		
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
%>




