
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>

<%
	try
	{
		response.setContentType("application/json");
		response.setHeader("X-Robots-Tag", "noindex, nofollow");
		JSONObject json = new JSONObject();
		JSONObject screenlabels = new JSONObject();
		EgMappingInfo mapping = new EgMappingInfo("manager");

		screenlabels.put("username", mapping.getTextDescription("admin.login.Username"));
		screenlabels.put("password", mapping.getTextDescription("admin.login.Password"));
		screenlabels.put("logon", mapping.getTextDescription("admin.login.Domain"));
		screenlabels.put("logon_idp", "Identity Provider");
		screenlabels.put("siginin", mapping.getTextDescription("admin.login.Sign In"));
		screenlabels.put("ForgotPassword", mapping.getTextDescription("admin.login.Forgot Password"));
		screenlabels.put("Help",mapping.getTextDescription("admin.login.Help"));
		
		screenlabels.put("identity", mapping.getTextDescription("admin.login.Please confirm your identity"));
		screenlabels.put("Get Password", mapping.getTextDescription("admin.login.Get Password"));
		screenlabels.put("Login Page", mapping.getTextDescription("admin.login.Login Page"));
		screenlabels.put("admin.login.Copyright", mapping.getTextDescription("admin.login.Copyright"));
		screenlabels.put("copyright",mapping.getTextDescription("admin.login.eG Innovations, Inc&#46 All Rights Reserved"));
		screenlabels.put("admin.login.Powered by eG Enterprise",mapping.getTextDescription("admin.login.Powered by eG Enterprise"));

		com.eg.EgManagersInfo mgrInfo=null;
		java.util.Hashtable ht=null;
		boolean isDomainConfigured = false;
		ArrayList egLoggingSystem = new ArrayList();
		if(EgInstallInfo.isSuperManager)
		{
			mgrInfo= com.eg.EgManagersInfo.getInstance();
			ht = mgrInfo.getReportingManagers();
			if(ht != null && !ht.isEmpty())
			{
				java.util.Iterator itr = ht.keySet().iterator();
				while(itr.hasNext())
				{
					String mgrId = (String)itr.next();
					IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/"+mgrId+"-eg_authenticate.ini",false,"yes");
					String[] domains = iniFile.getSubjects();
					if(domains != null && domains.length > 0)
					{
						isDomainConfigured=true;
						for (int i=0;i<domains.length;i++)
						{
							if(!egLoggingSystem.contains(domains[i]))
							{
								egLoggingSystem.add(domains[i]);
							}
						}
					}
				}
			}
			if(!egLoggingSystem.isEmpty())
			{
				java.util.Collections.sort(egLoggingSystem,String.CASE_INSENSITIVE_ORDER);
			}
		}
		else
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_authenticate.ini");
			String[] domains = iniFile.getSubjects();
			if (domains != null && domains.length > 0)
			{
				for (int i = 0; i < domains.length; i++)
				{
					if (!egLoggingSystem.contains(domains[i]))
					{
						egLoggingSystem.add(domains[i]);
					}
				}
			}
			isDomainConfigured = (domains != null && domains.length > 0);
		}
		IniFile ssoIniObj = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_samlsso.ini");
		boolean hasSsoLoginEnabled = false;
		String enableSSOLogin = ssoIniObj.getValue("SAML_SSO","SSO_ENABLED");
		
		ArrayList egLoggingIdp = new ArrayList();
		String[] idpList = ssoIniObj.getSubjects();
		if (idpList != null && idpList.length > 0) 
		{
			for (int i = 0; i < idpList.length; i++) 
			{
				if (!com.egurkha.util.StringUtils.isNull(idpList[i]) && (idpList[i].equals("SAML_SSO") || idpList[i].startsWith("SECONDARY_")))
				{
					continue;
				}
				if (!egLoggingIdp.contains(idpList[i])) 
				{
					egLoggingIdp.add(idpList[i]);
				}
			}
		}
		
		String isLoggingFrom = request.getParameter("isLoggingFrom");
		isLoggingFrom = com.egurkha.util.StringUtils.decodeSecurityChar(isLoggingFrom);
		String idpResponse = request.getParameter("idpResponse");
		idpResponse = com.egurkha.util.StringUtils.decodeSecurityChar(idpResponse);
		String loggedInDomain = request.getParameter("loggedInDomain");
		loggedInDomain = com.egurkha.util.StringUtils.decodeSecurityChar(loggedInDomain);
		String loggedInIdp = loggedInIdp = request.getParameter("loggedInIdp");
		loggedInIdp = com.egurkha.util.StringUtils.decodeSecurityChar(loggedInIdp);
		
		if (com.egurkha.util.StringUtils.isNull(idpResponse))
		{
			idpResponse = "";
		}

		IniFile serviceObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
		String strDefaultAuthType = serviceObj.getValue("MISC_ARGS","AuthenticationModeForLogin");
		if (com.egurkha.util.StringUtils.isNull(strDefaultAuthType))
		{
			strDefaultAuthType = "eG Enterprise";
		}
		if (strDefaultAuthType.equalsIgnoreCase("SAML"))
		{
			boolean isSSOEnabledAndConfigured = (!com.egurkha.util.StringUtils.isNull(enableSSOLogin) && 
			(enableSSOLogin.equalsIgnoreCase("yes") || enableSSOLogin.equalsIgnoreCase("true")) && (egLoggingIdp != null && egLoggingIdp.size() > 0)) ? true : false;
			
			if (!isSSOEnabledAndConfigured)
			{
				strDefaultAuthType = "eG Enterprise";
			}
			else
			{
				if (com.egurkha.util.StringUtils.isNull(isLoggingFrom) || isLoggingFrom.equals(strDefaultAuthType))
				{
					isLoggingFrom = strDefaultAuthType;
				}
				//strDefaultAuthType = "SAML Identity Provider";
			}
		}
		else if (strDefaultAuthType.equalsIgnoreCase("Domain"))
		{
			if (!isDomainConfigured)
			{
				strDefaultAuthType = "eG Enterprise";
			}
			else
			{
				if (com.egurkha.util.StringUtils.isNull(isLoggingFrom) || isLoggingFrom.equals(strDefaultAuthType))
				{
					isLoggingFrom = strDefaultAuthType;
				}
				//strDefaultAuthType = "Active Directory";
			}
		}

		if (com.egurkha.util.StringUtils.isNull(isLoggingFrom))
		{
			isLoggingFrom = "eG Enterprise";
		}
		
		String disableAuthTypes = serviceObj.getValue("MISC_ARGS","DisabledAuthentication");
		ArrayList disableAuthList = new ArrayList();
		ArrayList disableAuthTypeArr = new ArrayList();
		if (!com.egurkha.util.StringUtils.isNull(disableAuthTypes))
		{
			disableAuthTypeArr = com.egurkha.util.StringUtils.egTokenizer(disableAuthTypes, ",");
			for (int a = 0; a < disableAuthTypeArr.size();a++)
			{
				String strAuthMode = (String) disableAuthTypeArr.get(a);
				if (strAuthMode.equalsIgnoreCase("eG Enterprise") ||
				strAuthMode.equalsIgnoreCase("Domain") || 
				strAuthMode.equalsIgnoreCase("SAML"))
				{
					disableAuthList.add(strAuthMode);
				}
			}
			
			if (disableAuthList != null ) 
			{
				disableAuthList.remove(strDefaultAuthType);
				if (disableAuthList.contains(isLoggingFrom))
				{
					isLoggingFrom = "";
				}
			}
		}
		
		if (!com.egurkha.util.StringUtils.isNull(strDefaultAuthType) && com.egurkha.util.StringUtils.isNull(isLoggingFrom))
		{
			isLoggingFrom = strDefaultAuthType;
			loggedInDomain = "";
		}

		JSONArray domainArray = new JSONArray();
		JSONArray idpArray = new JSONArray();
		JSONObject obj;
		
		JSONArray domainArray_mobile = new JSONArray();
		JSONArray idpArray_mobile = new JSONArray();
		JSONObject obj_mobile;

		String domainCombobox_value = "";
		String idpCombobox_value = "";
		for (int k = 0;k<egLoggingSystem.size();k++)
		{
			String logging = (String)egLoggingSystem.get(k);
			obj = new JSONObject();
			obj_mobile=new JSONObject();
			String dispLoggingDomain=logging;
			String valforDomain=logging;

			if (loggedInDomain != null && logging.equalsIgnoreCase(loggedInDomain))
			{
				obj.put("displayField",dispLoggingDomain);
				obj.put("valueField",logging);
				obj_mobile.put("displayField",dispLoggingDomain);
				obj_mobile.put("valueField",logging); 
				domainCombobox_value = logging;
			}
			else
			{
				obj.put("displayField",dispLoggingDomain);
				obj.put("valueField",logging);
				obj_mobile.put("displayField",dispLoggingDomain);
				obj_mobile.put("valueField",logging);
			}
			domainArray.add(obj);
			domainArray_mobile.add(obj_mobile);
		}
		obj_mobile= new JSONObject();
		obj_mobile.put("displayField","Local");
		obj_mobile.put("valueField","Local"); 
		domainArray_mobile.add(obj_mobile);

		if (egLoggingIdp != null && egLoggingIdp.size() > 0)
		{
			for (int k = 0;k<egLoggingIdp.size();k++)
			{
				String idpName = (String)egLoggingIdp.get(k);
				JSONObject obj_idp = new JSONObject();
				JSONObject obj_mobile_idp=new JSONObject();

				obj_idp.put("displayField",idpName);
				obj_idp.put("valueField",idpName);

				obj_mobile_idp.put("displayField",idpName);
				obj_mobile_idp.put("valueField",idpName); 

				idpArray.add(obj_idp);
				idpArray_mobile.add(obj_mobile_idp);

				if (loggedInIdp!=null&&loggedInIdp.length()>0 && idpName.equalsIgnoreCase(loggedInIdp))
				{
					idpCombobox_value = idpName;
				}
			}
		}

		json.put("idpCombobox_value",idpCombobox_value); 
		json.put("configuredDomains", domainArray);
		json.put("configuredIdp", idpArray);
		json.put("loggedInDomain", domainCombobox_value);

		boolean hasMultiLoginTypes = false;
		if (enableSSOLogin != null && 
			(enableSSOLogin.equalsIgnoreCase("yes") || enableSSOLogin.equalsIgnoreCase("true")))
		{
			if (disableAuthList != null && !disableAuthList.contains("SAML"))
			{
				hasSsoLoginEnabled = true;
			}
		}

		hasMultiLoginTypes = (isDomainConfigured || (hasSsoLoginEnabled && (egLoggingIdp != null && egLoggingIdp.size() > 0)))? true : false;
		
		json.put("hasMultiLoginTypes",hasMultiLoginTypes);
		if (hasMultiLoginTypes)
		{
			json.put("hasLocalAuthentication",false);
			JSONArray loginTypesArr = new JSONArray();
			JSONObject tmpJsonObj = new JSONObject();
			if (disableAuthList != null && !disableAuthList.contains("eG Enterprise"))
			{
				json.put("hasLocalAuthentication",true);
				tmpJsonObj.put("displayField","eG Enterprise");
				tmpJsonObj.put("valueField","eG Enterprise");
				loginTypesArr.add(tmpJsonObj);
			}

			if (isDomainConfigured && (disableAuthList != null && !disableAuthList.contains("Domain")))
			{
				tmpJsonObj = new JSONObject();
				tmpJsonObj.put("displayField","Active Directory");
				tmpJsonObj.put("valueField","Domain");
				loginTypesArr.add(tmpJsonObj);
			}

			if (hasSsoLoginEnabled && (egLoggingIdp != null && egLoggingIdp.size() > 0))
			{
				tmpJsonObj = new JSONObject();
				tmpJsonObj.put("displayField","SAML Identity Provider");
				tmpJsonObj.put("valueField","SAML");
				loginTypesArr.add(tmpJsonObj);
			}
			json.put("loginTypesArr",loginTypesArr);
			screenlabels.put("loginTypeLbl", mapping.getTextDescription("admin.login.Authentication"));
			json.put("isLoggingFrom", isLoggingFrom);
			json.put("idpResponse", idpResponse);
		}
		json.put("screenlabels", screenlabels);

		response.getWriter().write(json.toString());
	}
	catch (Exception e) 
	{
		e.printStackTrace();
	}
%>



