import validate from "./validate";
import logger from "./plugins/logger";
import image from "./plugins/image";
import benchmark from "./plugins/benchmark";
import stateResponses from "./plugins/state-responses";
import apiResponse from "./plugins/api-response";
import clear from "./plugins/clear";
import repl from "./plugins/repl";
import serialize from "./serialize";
import { start } from "./stopwatch";
import { NativeModules } from 'react-native';
import DeviceInfo from './eg-react-device-info';
export var corePlugins = [
    image(),
    logger(),
    benchmark(),
    stateResponses(),
    apiResponse(),
    clear(),
    repl(),
];
var DEFAULT_OPTIONS = {
    appToken: "",
    createSocket: null,
    host: "1.1.1.1",
    port: 0,
    loggingEnabled: true,
    logLevel: 1,
    name: "@eginnovations/react-native-eg-agent",
    secure: false,
    plugins: corePlugins,
    safeRecursion: true,
    onCommand: function () { return null; },
    onConnect: function () { return null; },
    onDisconnect: function () { return null; },
};
// these are not for you.
var reservedFeatures = [
    "options",
    "connected",
    "socket",
    "plugins",
    "configure",
    "connect",
    "send",
    "use",
    "startTimer",
    "setUserName",
    "setAttribute"
];
var isReservedFeature = function (value) { return reservedFeatures.some(function (res) { return res === value; }); };
export var ArgType;
(function (ArgType) {
    ArgType["String"] = "string";
})(ArgType || (ArgType = {}));
var eGImpl = /** @class */ (function () {
    function eGImpl() {
        var _this = this;
        // the configuration options
        this.options = Object.assign({}, DEFAULT_OPTIONS);
        /**
         * Are we connected to a server?
         */
        this.connected = false;
        /**
         * The socket we're using.
         */
        this.socket = null;
        /**
         * Available plugins.
         */
        this.plugins = [];
        /**
         * Messages that need to be sent.
         */
        this.sendQueue = [];
        /**
         * Are we ready to start communicating?
         */
        this.isReady = false;
        /**
         * The last time we sent a message.
         */
        this.lastMessageDate = new Date();
        /**
         * The registered custom commands
         */
        this.customCommands = [];
        /**
         * The current ID for custom commands
         */
        this.customCommandLatestId = 1;
        /**
         * Starts a timer and returns a function you can call to stop it and return the elapsed time.
         */
        this.startTimer = function () { return start(); };
        /**
         * Sends a command to the server
         */
        this.send = function (type, data, important) {
            if (important === void 0) { important = false; }
            // set the timing info
            console.log("send called to agent url..." + _this.host);
            var date = new Date();
            var deltaTime = date.getTime() - _this.lastMessageDate.getTime();
            // glitches in the matrix
            if (deltaTime < 0) {
                deltaTime = 0;
            }
            _this.lastMessageDate = date;
            var appToken = _this.options.appToken;
            var instrumentationType = type;
            var appName = DeviceInfo.getApplicationName();
            var activityName = DeviceInfo.getCurrentActivityNameSync();
            var osName = DeviceInfo.getBaseOsSync();
            var osVersion = DeviceInfo.getSystemVersion();
            var deviceName = DeviceInfo.getDeviceNameSync();
            // this.deviceInfo = NativeModules.eGAgent.getDevInfo();
            // this.appData =NativeModules.eGAgent.getAppinfo();
            // this.resourceData = NativeModules.eGAgent.getResInfo();
            var deviceInformation = JSON.parse(_this.deviceInfo);
            var applicationInformation = JSON.parse(_this.appData);
            var resourceInformation = JSON.parse(_this.resourceData);
            var userInformation = JSON.parse(_this.userData);
            var executionTime = deltaTime;
            var country = DeviceInfo.getUserCountrySync();
            var fullMessage = {};
            console.log("send called type..." + type);
            if (type == 'HTTP') {
                var httpInformation = data;
                fullMessage = {
                    appName: appName,
                    instrumentationType: instrumentationType,
                    appToken: appToken,
                    activityName: activityName,
                    osName: osName,
                    osVersion: osVersion,
                    deviceName: deviceName,
                    deviceInformation: deviceInformation,
                    applicationInformation: applicationInformation,
                    resourceInformation: resourceInformation,
                    httpInformation: httpInformation,
                    userInformation: userInformation,
                    executionTime: executionTime,
                    country: country
                };
            }
            else if (type == 'Page') {
                var pageInformation = data;
                fullMessage = {
                    appName: appName,
                    instrumentationType: instrumentationType,
                    appToken: appToken,
                    activityName: activityName,
                    osName: osName,
                    osVersion: osVersion,
                    deviceName: deviceName,
                    deviceInformation: deviceInformation,
                    applicationInformation: applicationInformation,
                    resourceInformation: resourceInformation,
                    pageInformation: pageInformation,
                    userInformation: userInformation,
                    executionTime: executionTime,
                    country: country
                };
            }
            else if (type == 'JSError') {
                var message = data;
                console.log("sending serialized message .." + message);
                fullMessage = {
                    appName: appName,
                    instrumentationType: instrumentationType,
                    activityName: activityName,
                    deviceName: deviceName,
                    osName: osName,
                    osVersion: osVersion,
                    appToken: appToken,
                    deviceInformation: deviceInformation,
                    applicationInformation: applicationInformation,
                    resourceInformation: resourceInformation,
                    userInformation: userInformation,
                    errordetails: message,
                    executionTime: executionTime,
                    country: country
                };
            }
            console.log("sending serialized data .." + serialize(data, _this.options.proxyHack));
            console.log('url in send is.... ' + _this.host);
            var serializedMessage = serialize(fullMessage, _this.options.proxyHack);
            console.log("sending serializedMessage.." + serializedMessage);
            console.log("this.isready .. " + _this.isReady);
            if (_this.isReady) {
                // send this command
                try {
                    send(serializedMessage, _this.host);
                    while (_this.sendQueue.length > 0) {
                        var h = _this.sendQueue[0];
                        _this.sendQueue = _this.sendQueue.slice(1);
                        send(h, _this.host);
                    }
                }
                catch (e) {
                    _this.isReady = false;
                    console.log("An error occured communicating with eG. Please reload your app", e);
                }
            }
            else {
                // queue it up until we can connect
                _this.sendQueue.push(serializedMessage);
            }
        };
    }
    /**
     * Set the user name.
     */
    eGImpl.prototype.setUserName = function (name) {
        NativeModules.eGAgent.setUserName(name);
    };
    eGImpl.prototype.setAttribute = function (name, value) {
        NativeModules.eGAgent.setUserAttribute(name, value);
    };
    /**
     * Set the configuration options.
     */
    eGImpl.prototype.configure = function (options) {
        var _this = this;
        if (options === void 0) { options = {}; }
        // options get merged & validated before getting set
        var newOptions = Object.assign({}, this.options, options);
        validate(newOptions);
        this.options = newOptions;
        var _a = this.options, appToken = _a.appToken, secure = _a.secure, host = _a.host, loggingEnabled = _a.loggingEnabled, logLevel = _a.logLevel, port = _a.port;
        //  console.log("appToken::"+appToken);
        //  console.log("configure::$host::${host}"+host)
        var protocol = secure ? "https" : "http";
        // this.host = `${protocol}://${host}:${port}/` 
        if (host.startsWith("http")) {
            this.host = host + "/rumcollector/servlet/eGMobileRumCollector";
        }
        else {
            this.host = protocol + "://" + host + ":" + port + "/rumcollector/servlet/eGMobileRumCollector";
        }
        console.log("configure:host.toString(): " + host.toString());
        // console.log("configure:host.toString().indexOf('1.1.1.1'): "+host.toString().indexOf('1.1.1.1'))
        try {
            if (host.toString().indexOf('1.1.1.1') == -1) {
                // console.log("host URL ..."+this.host)
                if (host.startsWith("http")) {
                    NativeModules.eGAgent.start({ appToken: appToken, hostUrl: host, loggingEnabled: loggingEnabled, useSsl: secure, logLevel: logLevel }, function () { return console.log('EG Agent  Initialized'); });
                }
                else {
                    NativeModules.eGAgent.start({ appToken: appToken, hostUrl: protocol + "://" + host + ":" + port + "/", loggingEnabled: loggingEnabled, useSsl: secure, logLevel: logLevel }, function () { return console.log('EG Agent  Initialized'); });
                }
                this.isReady = true;
            }
        }
        catch (e) {
            console.log("eg agent start::::" + e);
            console.error("Error:" + e);
        }
        // if we have plugins, let's add them here
        if (Array.isArray(this.options.plugins)) {
            this.options.plugins.forEach(function (p) { return _this.use(p); });
        }
        return this; // cast needed to allow patching by other implementations like eG-react-native
    };
    eGImpl.prototype.close = function () {
        this.connected = false;
        // this.socket && this.socket.close && this.socket.close()
    };
    /**
     * Connect to the eg-manager server.
     */
    eGImpl.prototype.connect = function () {
        this.connected = true;
        this.isReady = true;
        this.deviceInfo = NativeModules.eGAgent.getDevInfo();
        this.appData = NativeModules.eGAgent.getAppinfo();
        this.resourceData = NativeModules.eGAgent.getResInfo();
        this.userData = NativeModules.eGAgent.getUserInfo();
        console.log('connected...');
        return this; // cast needed to allow patching by other implementations like eg-react-native
    };
    /**
     * Sends a custom command to the server to displays nicely.
     */
    eGImpl.prototype.display = function (config) {
        if (config === void 0) { config = {}; }
        var name = config.name, value = config.value, preview = config.preview, img = config.image, _a = config.important, important = _a === void 0 ? false : _a;
        var payload = {
            name: name,
            value: value || null,
            preview: preview || null,
            image: img || null,
        };
        this.send("display", payload, important);
    };
    /**
     * Client libraries can hijack this to report errors.
     */
    eGImpl.prototype.reportError = function (error) {
        this.error(error);
    };
    /**
     * Adds a plugin to the system
     */
    eGImpl.prototype.use = function (pluginCreator) {
        var _this = this;
        // we're supposed to be given a function
        if (typeof pluginCreator !== "function") {
            throw new Error("plugins must be a function");
        }
        // execute it immediately passing the send function
        var plugin = pluginCreator.bind(this)(this);
        // ensure we get an Object-like creature back
        if (typeof plugin !== "object") {
            throw new Error("plugins must return an object");
        }
        // do we have features to mixin?
        if (plugin.features) {
            // validate
            if (typeof plugin.features !== "object") {
                throw new Error("features must be an object");
            }
            // here's how we're going to inject these in
            var inject_1 = function (key) {
                // grab the function
                var featureFunction = plugin.features[key];
                // only functions may pass
                if (typeof featureFunction !== "function") {
                    throw new Error("feature " + key + " is not a function");
                }
                // ditch reserved names
                if (isReservedFeature(key)) {
                    throw new Error("feature " + key + " is a reserved name");
                }
                // ok, let's glue it up... and lose all respect from elite JS champions.
                _this[key] = featureFunction;
            };
            // let's inject
            Object.keys(plugin.features).forEach(function (key) { return inject_1(key); });
        }
        // add it to the list
        this.plugins.push(plugin);
        // call the plugins onPlugin
        plugin.onPlugin && typeof plugin.onPlugin === "function" && plugin.onPlugin.bind(this)(this);
        // chain-friendly
        return this; // cast needed to allow patching by other implementations like eG-react-native
    };
    eGImpl.prototype.onCustomCommand = function (config, optHandler) {
        var _this = this;
        var command;
        var handler;
        var title;
        var description;
        var args;
        if (typeof config === "string") {
            command = config;
            handler = optHandler;
        }
        else {
            command = config.command;
            handler = config.handler;
            title = config.title;
            description = config.description;
            args = config.args;
        }
        // Validations
        // Make sure there is a command
        if (!command) {
            throw new Error("A command is required");
        }
        // Make sure there is a handler
        if (!handler) {
            throw new Error("A handler is required for command \"" + command + "\"");
        }
        // Make sure the command doesn't already exist
        var existingCommands = this.customCommands.filter(function (cc) { return cc.command === command; });
        if (existingCommands.length > 0) {
            existingCommands.forEach(function (command) {
                console.log(command);
                _this.customCommands = _this.customCommands.filter(function (cc) { return cc.id !== command.id; });
                _this.send("customCommand.unregister", {
                    id: command.id,
                    command: command.command,
                });
            });
        }
        if (args) {
            var argNames_1 = [];
            args.forEach(function (arg) {
                if (!arg.name) {
                    throw new Error("A arg on the command \"" + command + "\" is missing a name");
                }
                if (argNames_1.indexOf(arg.name) > -1) {
                    throw new Error("A arg with the name \"" + arg.name + "\" already exists in the command \"" + command + "\"");
                }
                argNames_1.push(arg.name);
            });
        }
        // Create this command handlers object
        var customHandler = {
            id: this.customCommandLatestId,
            command: command,
            handler: handler,
            title: title,
            description: description,
            args: args,
        };
        // Increment our id counter
        this.customCommandLatestId += 1;
        // Add it to our array
        this.customCommands.push(customHandler);
        this.send("customCommand.register", {
            id: customHandler.id,
            command: customHandler.command,
            title: customHandler.title,
            description: customHandler.description,
            args: customHandler.args,
        });
        return function () {
            _this.customCommands = _this.customCommands.filter(function (cc) { return cc.id !== customHandler.id; });
            _this.send("customCommand.unregister", {
                id: customHandler.id,
                command: customHandler.command,
            });
        };
    };
    return eGImpl;
}());
export { eGImpl };
// convenience factory function
export function createClient(options) {
    var client = new eGImpl();
    client.configure(options);
    return client; // cast needed to allow patching by other implementations like eg-react-native
}
function send(serializedMessage, host) {
    var myHeaders = new Headers();
    myHeaders.append("Content-Type", "application/json");
    var requestOptions = {
        method: 'POST',
        headers: myHeaders,
        body: serializedMessage,
    };
    console.log("JSON::" + serializedMessage);
    fetch(host, requestOptions)
        .then(function (response) { var text = response.text(); console.log("text::" + text); return text; })
        .then(function (result) { console.log("result::" + result); return result; })
        .catch(function (error) { console.log('error', error); return error; });
}
