/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.Legend;
import com.objectplanet.chart.LegendRenderer;
import com.objectplanet.chart.LineChartRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class LineChart
extends Chart {
    public static final int SAMPLE_HIGHLIGHT_CIRCLE = 0;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_OPAQUE = 1;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_FILLED = 2;
    public static final int SAMPLE_HIGHLIGHT_SQUARE = 3;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_OPAQUE = 4;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_FILLED = 5;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND = 6;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_OPAQUE = 7;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_FILLED = 8;
    public static final int BEHIND_LINE_LAYOUT = 0;
    public static final int SAME_LEVEL_LINE_LAYOUT = 1;
    public static final int LINE_STYLE_LINE = 0;
    public static final int LINE_STYLE_TUBE = 1;
    private boolean autoLabelSpacingOn;
    private int[] lineWidth;
    private double[] line3dDepth;
    private boolean[] outlineOn;
    private float[][] lineStroke;
    private int[] lineStyle;
    private boolean stackedOn;
    private int line3DLayout;
    private boolean[][] sampleHighlightOn;
    private boolean[] sampleHighlightOn_all;
    private int[] sampleHighlightStyle;
    private int[] sampleHighlightSize;
    private boolean[] seriesLinesOn;
    private boolean[] connectedLinesOn;
    private String highlightImage;
    private String[] highlightImages_all;
    private String[][] highlightImages;
    private boolean missingValuesInterpolated;
    int[][] areaSeries;
    Color[] areaColors;
    Color[] areaColors2;

    public LineChart() {
        this(1, 5, 100.0);
    }

    public LineChart(int seriesCount, int sampleCount, double range) {
        this(seriesCount, sampleCount, range, 0.0);
    }

    public LineChart(int seriesCount, int sampleCount, double range, double lowerRange) {
        super(sampleCount);
        this.grid = new Grid(this);
        this.legend = new Legend();
        this.legendRenderer = new LegendRenderer(this);
        this.renderer = new LineChartRenderer(this);
        this.chartType = "line";
        this.setAutomaticRepaintOn(false);
        this.sampleHighlightOn = new boolean[seriesCount][sampleCount];
        this.sampleHighlightOn_all = new boolean[seriesCount];
        this.sampleHighlightStyle = new int[seriesCount];
        this.sampleHighlightSize = new int[seriesCount];
        this.sampleHighlightSize = new int[seriesCount];
        this.seriesLinesOn = new boolean[seriesCount];
        this.outlineOn = new boolean[seriesCount];
        this.lineWidth = new int[seriesCount];
        this.lineStyle = new int[seriesCount];
        this.line3dDepth = new double[seriesCount];
        this.lineStroke = new float[seriesCount][];
        for (int i = 0; i < this.sampleHighlightSize.length; ++i) {
            this.sampleHighlightSize[i] = 6;
            this.seriesLinesOn[i] = true;
            this.outlineOn[i] = true;
            this.lineWidth[i] = 2;
            this.line3dDepth[i] = 1.0;
        }
        this.highlightImages = new String[seriesCount][sampleCount];
        this.highlightImages_all = new String[seriesCount];
        this.connectedLinesOn = new boolean[seriesCount];
        this.areaSeries = null;
        this.areaColors = null;
        this.setSeriesCount(seriesCount);
        this.setRange(0, range);
        this.setLowerRange(0, lowerRange);
        this.setSampleColors(null);
        this.valueLabelStyle = 1;
        this.sampleLabelStyle = 2;
        this.seriesLabelStyle = 3;
        this.autoLabelSpacingOn = false;
        this.multiSeriesOn = true;
        this.missingValuesInterpolated = true;
        this.setAutomaticRepaintOn(true);
    }

    public void reset() {
        super.reset();
        this.valueLabelStyle = 1;
        this.sampleLabelStyle = 2;
        this.seriesLabelStyle = 3;
        this.autoLabelSpacingOn = false;
        this.multiSeriesOn = true;
        this.areaSeries = null;
        this.areaColors = null;
        this.areaColors2 = null;
    }

    public String[] getLegendLabels() {
        String[] legendLabels = this.legend.getLegendLabels();
        if (legendLabels != null) {
            return legendLabels;
        }
        return this.getSeriesLabels();
    }

    protected double getHighestValue(int range) {
        if (this.stackedOn) {
            return Math.max(super.getHighestValue(range), this.getMaxValue(-2));
        }
        return super.getHighestValue(range);
    }

    public double getMaxValue(int serie) {
        if (serie >= -1 || !this.stackedOn) {
            return super.getMaxValue(serie);
        }
        double max = 0.0;
        int sampleCount = this.getSampleCount();
        int seriesCount = this.getSeriesCount();
        for (int sample = 0; sample < sampleCount; ++sample) {
            double sum = 0.0;
            for (int i = 0; i < seriesCount; ++i) {
                ChartSample s = this.getSample(i, sample);
                if (s == null || s.value == null || s.value.isNaN() || !(s.value > 0.0)) continue;
                sum += s.value.doubleValue();
            }
            max = Math.max(max, sum);
        }
        return max;
    }

    public void setSampleColors(Color[] colors) {
        super.setSampleColors(colors);
        if (colors == null) {
            this.setSampleColor(2, new Color(132, 255, 198));
        }
        this.autoRepaint();
    }

    public int getValuePosition(double value) {
        return this.grid.getValuePosition(0, value, this.getGraphBounds());
    }

    public Point getSamplePoint(int serie, int sample) {
        try {
            int x = ((LineChartRenderer)this.renderer).samplePoints[serie][sample][0];
            int y = ((LineChartRenderer)this.renderer).samplePoints[serie][sample][1];
            return new Point(x - (this.display3dOn ? this.renderer.depth3dPoint.x : 0), y);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setAutoLabelSpacingOn(boolean on) {
        if (this.autoLabelSpacingOn != on) {
            this.autoLabelSpacingOn = on;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isAutoLabelSpacingOn() {
        return this.autoLabelSpacingOn;
    }

    public void setStackedOn(boolean on) {
        if (this.stackedOn != on) {
            this.stackedOn = on;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isStackedOn() {
        return this.stackedOn;
    }

    public void setLineWidth(int width) {
        this.setLineWidth(-1, width);
    }

    public void setLineWidth(int series, int width) {
        if (series >= 0 && series < this.lineWidth.length) {
            this.lineWidth[series] = width;
        } else if (series < 0) {
            for (int i = 0; i < this.lineWidth.length; ++i) {
                this.lineWidth[i] = width;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public int getLineWidth() {
        return this.getLineWidth(0);
    }

    public int getLineWidth(int series) {
        if (series >= 0 && series < this.lineWidth.length) {
            return this.lineWidth[series];
        }
        return this.lineWidth[0];
    }

    public void setLineStyle(int series, int style) {
        if (series >= 0 && series < this.lineStyle.length) {
            this.lineStyle[series] = style;
        } else if (series < 0) {
            for (int i = 0; i < this.lineStyle.length; ++i) {
                this.lineStyle[i] = style;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public int getLineStyle(int series) {
        if (series >= 0 && series < this.lineStyle.length) {
            return this.lineStyle[series];
        }
        return this.lineStyle[0];
    }

    public void setLine3DDepth(int series, double depth) {
        if (series >= 0 && series < this.line3dDepth.length) {
            this.line3dDepth[series] = depth;
        } else if (series < 0) {
            for (int i = 0; i < this.line3dDepth.length; ++i) {
                this.line3dDepth[i] = depth;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public double getLine3DDepth(int series) {
        if (series >= 0 && series < this.lineWidth.length) {
            return this.line3dDepth[series];
        }
        return this.line3dDepth[0];
    }

    public void setOutlineOn(int serie, boolean on) {
        if (serie >= 0) {
            if (this.outlineOn[serie] != on) {
                this.outlineOn[serie] = on;
                this.needRender = true;
                this.autoRepaint();
            }
        } else if (serie < 0) {
            for (int i = 0; i < this.outlineOn.length; ++i) {
                this.outlineOn[i] = on;
            }
        }
    }

    public boolean isOutlineOn(int serie) {
        return this.outlineOn[serie];
    }

    public void setLineStroke(int series, float[] dash) {
        int count = dash.length % 2 == 0 ? dash.length : dash.length + 1;
        this.lineStroke[series] = new float[count];
        if (series >= 0 && series < this.lineStroke.length) {
            for (int i = 0; i < dash.length; ++i) {
                this.lineStroke[series][i] = Math.abs(dash[i]);
            }
            if (this.lineStroke[series][count - 1] == 0.0f) {
                this.lineStroke[series][count - 1] = this.lineStroke[series][count - 2];
            }
        } else if (series < 0) {
            for (int j = 0; j < this.lineStroke.length; ++j) {
                for (int i = 0; i < dash.length; ++i) {
                    this.lineStroke[j][i] = Math.abs(dash[i]);
                }
                if (this.lineStroke[j][count - 1] != 0.0f) continue;
                this.lineStroke[j][count - 1] = this.lineStroke[j][count - 2];
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public float[] getLineStroke(int series) {
        if (this.lineStroke == null || this.lineStroke.length == 0) {
            return new float[]{0.0f};
        }
        if (series >= 0 && series < this.lineStroke.length) {
            return this.lineStroke[series];
        }
        return this.lineStroke[0];
    }

    public void setLine3DLayout(int layout) {
        this.line3DLayout = layout;
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getLine3DLayout() {
        return this.line3DLayout;
    }

    public void setSampleHighlightOn(boolean on) {
        for (int series = 0; series < this.sampleHighlightOn.length; ++series) {
            this.sampleHighlightOn_all[series] = on;
            for (int sample = 0; sample < this.sampleHighlightOn[series].length; ++sample) {
                this.sampleHighlightOn[series][sample] = on;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int series, boolean on) {
        try {
            this.sampleHighlightOn_all[series] = on;
            for (int sample = 0; sample < this.sampleHighlightOn[series].length; ++sample) {
                this.sampleHighlightOn[series][sample] = on;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int series, int sample, boolean on) {
        try {
            this.sampleHighlightOn[series][sample] = on;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series or index: " + series + ", " + sample);
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isSampleHighlightOn(int series) {
        try {
            return this.sampleHighlightOn_all[series];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid serie: , " + series);
        }
    }

    public boolean isSampleHighlightOn(int series, int sample) {
        if (this.sampleHighlightOn != null && series < this.sampleHighlightOn.length && sample < this.sampleHighlightOn[series].length) {
            return this.sampleHighlightOn[series][sample];
        }
        return false;
    }

    public void setSampleHighlightStyle(int style, int size) {
        for (int i = 0; i < this.sampleHighlightStyle.length; ++i) {
            this.setSampleHighlightStyle(i, style, size);
        }
    }

    public void setSampleHighlightStyle(int serie, int style, int size) {
        this.sampleHighlightSize[serie] = Math.max(0, size);
        this.sampleHighlightStyle[serie] = style;
        this.needRender = true;
        this.autoRepaint();
    }

    public int getSampleHighlightStyle(int series) {
        try {
            return this.sampleHighlightStyle[series];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
    }

    public int getSampleHighlightSize(int series) {
        try {
            return this.sampleHighlightSize[series];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
    }

    public void setSampleHighlightImage(int series, int sample, String name) {
        if (series >= -1 && series < 1000 && sample >= -1 && series <= 1000) {
            if (series == -1 && sample == -1) {
                this.highlightImage = name;
            } else if (sample == -1) {
                int series_count = Math.max(this.highlightImages.length, series + 1);
                if (series >= this.highlightImages_all.length) {
                    String[] newHighlightImages_all = new String[series_count];
                    for (int i = 0; i < this.highlightImages_all.length; ++i) {
                        newHighlightImages_all[i] = this.highlightImages_all[i];
                    }
                    this.highlightImages_all = newHighlightImages_all;
                }
                this.highlightImages_all[series] = name;
            } else {
                int series_count = Math.max(this.highlightImages.length, series + 1);
                int sample_count = Math.max(this.highlightImages[0].length, sample + 1);
                if (series >= this.highlightImages.length || sample >= this.highlightImages[0].length) {
                    String[][] newHighlightImages = new String[series_count][sample_count];
                    for (int i = 0; i < this.highlightImages.length; ++i) {
                        for (int j = 0; j < this.highlightImages[0].length; ++j) {
                            newHighlightImages[i][j] = this.highlightImages[i][j];
                        }
                    }
                    this.highlightImages = newHighlightImages;
                }
                this.highlightImages[series][sample] = name;
            }
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public String getSampleHighlightImage(int series, int sample) {
        if (series == -1 && sample == -1) {
            return this.highlightImage;
        }
        if (series >= 0 && series < this.highlightImages_all.length && sample == -1) {
            return this.highlightImages_all[series];
        }
        if (series >= 0 && series < this.highlightImages.length && sample >= 0 && sample < this.highlightImages[0].length) {
            return this.highlightImages[series][sample];
        }
        return null;
    }

    public String getLegendImage(int index) {
        String image_name = super.getLegendImage(index);
        if (image_name == null) {
            image_name = this.getSampleHighlightImage(index, -1);
        }
        return image_name;
    }

    public void setSeriesLineOn(boolean state) {
        for (int i = 0; i < this.seriesLinesOn.length; ++i) {
            this.seriesLinesOn[i] = state;
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSeriesLineOn(int serie, boolean state) {
        if (this.seriesLinesOn[serie] != state) {
            this.seriesLinesOn[serie] = state;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isSeriesLineOn(int serie) {
        if (this.seriesLinesOn != null && serie < this.seriesLinesOn.length) {
            return this.seriesLinesOn[serie];
        }
        return true;
    }

    public void setConnectedLinesOn(int serie, boolean on) {
        if (serie >= 0 && serie < this.connectedLinesOn.length) {
            this.connectedLinesOn[serie] = on;
        } else if (serie == -1) {
            for (int i = 0; i < this.connectedLinesOn.length; ++i) {
                this.connectedLinesOn[i] = on;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isConnectedLinesOn(int serie) {
        if (serie >= 0 && serie < this.connectedLinesOn.length) {
            return this.connectedLinesOn[serie];
        }
        if (serie == -1) {
            boolean on = false;
            for (int i = 0; i < this.connectedLinesOn.length; ++i) {
                if (!this.connectedLinesOn[i]) continue;
                on = true;
            }
            return on;
        }
        return false;
    }

    public void setArea(int index, int line1, int line2) {
        if (line1 < 0 || line2 < 0 || line1 >= this.getSeriesCount() || line2 >= this.getSeriesCount() || line1 == line2) {
            return;
        }
        if (this.areaSeries == null) {
            this.areaSeries = new int[index + 1][2];
            for (int i = 0; i < this.areaSeries.length; ++i) {
                this.areaSeries[i][0] = -1;
                this.areaSeries[i][1] = -1;
            }
        }
        if (index >= this.areaSeries.length) {
            int[][] new_areaSeries = new int[index + 1][2];
            System.arraycopy(this.areaSeries, 0, new_areaSeries, 0, this.areaSeries.length);
            for (int i = this.areaSeries.length; i < new_areaSeries.length - 1; ++i) {
                new_areaSeries[i][0] = -1;
                new_areaSeries[i][1] = -1;
            }
            this.areaSeries = new_areaSeries;
        }
        this.areaSeries[index][0] = line1;
        this.areaSeries[index][1] = line2;
        this.needRender = true;
        this.autoRepaint();
    }

    public int[] getArea(int index) {
        if (this.areaSeries == null || index >= this.areaSeries.length) {
            return new int[]{-1, -1};
        }
        return this.areaSeries[index];
    }

    public void setAreaColor(int index, Color color) {
        if (this.areaColors == null) {
            this.areaColors = new Color[index + 1];
        }
        if (index >= this.areaColors.length) {
            Color[] new_areaColors = new Color[index + 1];
            System.arraycopy(this.areaColors, 0, new_areaColors, 0, this.areaColors.length);
            this.areaColors = new_areaColors;
        }
        this.areaColors[index] = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getAreaColor(int index) {
        if (this.areaColors == null || index >= this.areaColors.length) {
            return null;
        }
        return this.areaColors[index];
    }

    public void setAreaColor2(int index, Color color) {
        if (this.areaColors2 == null) {
            this.areaColors2 = new Color[index + 1];
        }
        if (index >= this.areaColors2.length) {
            Color[] new_areaColors2 = new Color[index + 1];
            System.arraycopy(this.areaColors2, 0, new_areaColors2, 0, this.areaColors2.length);
            this.areaColors2 = new_areaColors2;
        }
        this.areaColors2[index] = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getAreaColor2(int index) {
        if (this.areaColors2 == null || index >= this.areaColors2.length) {
            return null;
        }
        return this.areaColors2[index];
    }

    public void setRightToLeftScrollingOn(boolean state) {
        this.grid.setRightToLeftScrollingOn(state);
        this.setVisibleSamples(this.visibleSamples[0], this.visibleSamples[1]);
        this.needChartCalculation = true;
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isRightToLeftScrollingOn() {
        return this.grid.isRightToLeftScrollingOn();
    }

    public boolean isMissingValuesInterpolated() {
        return this.missingValuesInterpolated;
    }

    public void setMissingValuesInterpolated(boolean on) {
        this.missingValuesInterpolated = on;
    }

    protected void checkDataIntegrity() {
        int oldSampleCount;
        super.checkDataIntegrity();
        this.renderer.checkDataIntegrity();
        int seriesCount = this.getSeriesCount();
        int sampleCount = this.getSampleCount();
        int oldSeriesCount = this.sampleHighlightOn != null ? this.sampleHighlightOn.length : 1;
        int n = oldSampleCount = oldSeriesCount > 0 && this.sampleHighlightOn != null ? this.sampleHighlightOn[0].length : 0;
        if (seriesCount != oldSeriesCount || sampleCount != oldSampleCount) {
            boolean[][] newSampleHighlightOn = new boolean[seriesCount][sampleCount];
            boolean[] newSampleHighlightOn_all = new boolean[seriesCount];
            for (int serie = 0; serie < seriesCount; ++serie) {
                if (serie >= oldSeriesCount || this.sampleHighlightOn_all == null) continue;
                try {
                    newSampleHighlightOn_all[serie] = this.sampleHighlightOn_all[serie];
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (int sample = 0; sample < sampleCount; ++sample) {
                    try {
                        if (sample < oldSampleCount) {
                            newSampleHighlightOn[serie][sample] = this.sampleHighlightOn[serie][sample];
                            continue;
                        }
                        newSampleHighlightOn[serie][sample] = this.sampleHighlightOn_all[serie];
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this.sampleHighlightOn = newSampleHighlightOn;
            this.sampleHighlightOn_all = newSampleHighlightOn_all;
            int[] newSampleHighlightStyle = new int[seriesCount];
            int[] newSampleHighlightSize = new int[seriesCount];
            boolean[] newSeriesLinesOn = new boolean[seriesCount];
            boolean[] newConnectedLinesOn = new boolean[seriesCount];
            int[] newLineWidth = new int[seriesCount];
            int[] newLineStyle = new int[seriesCount];
            double[] newLine3dDepth = new double[seriesCount];
            float[][] newLineStroke = new float[seriesCount][];
            boolean[] newOutlineOn = new boolean[seriesCount];
            for (int serie = 0; serie < seriesCount; ++serie) {
                if (serie < oldSeriesCount && this.sampleHighlightStyle != null && this.sampleHighlightSize != null && this.seriesLinesOn != null && this.connectedLinesOn != null && this.lineWidth != null && this.lineStroke != null && this.outlineOn != null && this.line3dDepth != null && this.lineStyle != null) {
                    newSampleHighlightStyle[serie] = this.sampleHighlightStyle[serie];
                    newSampleHighlightSize[serie] = this.sampleHighlightSize[serie];
                    newSeriesLinesOn[serie] = this.seriesLinesOn[serie];
                    newConnectedLinesOn[serie] = this.connectedLinesOn[serie];
                    newLineWidth[serie] = this.lineWidth[serie];
                    newLineStyle[serie] = this.lineStyle[serie];
                    newLine3dDepth[serie] = this.line3dDepth[serie];
                    newLineStroke[serie] = this.lineStroke[serie];
                    newOutlineOn[serie] = this.outlineOn[serie];
                    continue;
                }
                newSampleHighlightSize[serie] = 6;
                newLineWidth[serie] = 2;
                newLine3dDepth[serie] = 1.0;
                newSeriesLinesOn[serie] = true;
                newOutlineOn[serie] = true;
            }
            this.sampleHighlightStyle = newSampleHighlightStyle;
            this.sampleHighlightSize = newSampleHighlightSize;
            this.seriesLinesOn = newSeriesLinesOn;
            this.connectedLinesOn = newConnectedLinesOn;
            this.lineWidth = newLineWidth;
            this.lineStyle = newLineStyle;
            this.line3dDepth = newLine3dDepth;
            this.lineStroke = newLineStroke;
            this.outlineOn = newOutlineOn;
            this.needChartCalculation = true;
        }
    }

    public ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }

    protected void paintLine(Graphics g, int serie, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected) {
        ((LineChartRenderer)this.renderer).paintLine(g, serie, gridBounds, dataBounds, color, selected);
    }

    protected void paint3DLine(Graphics g, int x1, int y1, int x2, int y2, int y3, Color color, boolean top, boolean right, boolean outlined) {
        ((LineChartRenderer)this.renderer).paint3DLine(g, x1, y1, x2, y2, y3, color, top, right, outlined);
    }

    protected void paintSampleHighlight(Graphics g, int serie, int sample, int x, int y, Color color) {
        ((LineChartRenderer)this.renderer).paintSampleHighlight(g, serie, sample, x, y, color);
    }
}

