/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3;

import com.eg.org.apache.commons.lang3.CharRange;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CharSet
implements Serializable {
    private static final long serialVersionUID = 5947847346149275958L;
    public static final CharSet EMPTY = new CharSet(new String[]{null});
    public static final CharSet ASCII_ALPHA;
    public static final CharSet ASCII_ALPHA_LOWER;
    public static final CharSet ASCII_ALPHA_UPPER;
    public static final CharSet ASCII_NUMERIC;
    protected static final Map<String, CharSet> COMMON;
    private final Set<CharRange> set = Collections.synchronizedSet(new HashSet());

    public static CharSet getInstance(String ... stringArray) {
        CharSet charSet;
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 1 && (charSet = COMMON.get(stringArray[0])) != null) {
            return charSet;
        }
        return new CharSet(stringArray);
    }

    protected CharSet(String ... stringArray) {
        for (String string : stringArray) {
            this.add(string);
        }
    }

    protected void add(String string) {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n2 - n3;
            if (n4 >= 4 && string.charAt(n3) == '^' && string.charAt(n3 + 2) == '-') {
                this.set.add(CharRange.isNotIn(string.charAt(n3 + 1), string.charAt(n3 + 3)));
                n3 += 4;
                continue;
            }
            if (n4 >= 3 && string.charAt(n3 + 1) == '-') {
                this.set.add(CharRange.isIn(string.charAt(n3), string.charAt(n3 + 2)));
                n3 += 3;
                continue;
            }
            if (n4 >= 2 && string.charAt(n3) == '^') {
                this.set.add(CharRange.isNot(string.charAt(n3 + 1)));
                n3 += 2;
                continue;
            }
            this.set.add(CharRange.is(string.charAt(n3)));
            ++n3;
        }
    }

    CharRange[] getCharRanges() {
        return this.set.toArray(new CharRange[this.set.size()]);
    }

    public boolean contains(char c10) {
        for (CharRange charRange : this.set) {
            if (!charRange.contains(c10)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CharSet)) {
            return false;
        }
        CharSet charSet = (CharSet)object;
        return this.set.equals(charSet.set);
    }

    public int hashCode() {
        return 89 + this.set.hashCode();
    }

    public String toString() {
        return this.set.toString();
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = "a-zA-Z";
        ASCII_ALPHA = new CharSet(stringArray);
        String[] stringArray2 = new String[1];
        stringArray2[0] = "a-z";
        ASCII_ALPHA_LOWER = new CharSet(stringArray2);
        String[] stringArray3 = new String[1];
        stringArray3[0] = "A-Z";
        ASCII_ALPHA_UPPER = new CharSet(stringArray3);
        String[] stringArray4 = new String[1];
        stringArray4[0] = "0-9";
        ASCII_NUMERIC = new CharSet(stringArray4);
        COMMON = Collections.synchronizedMap(new HashMap());
        COMMON.put(null, EMPTY);
        COMMON.put("", EMPTY);
        COMMON.put("a-zA-Z", ASCII_ALPHA);
        COMMON.put("A-Za-z", ASCII_ALPHA);
        COMMON.put("a-z", ASCII_ALPHA_LOWER);
        COMMON.put("A-Z", ASCII_ALPHA_UPPER);
        COMMON.put("0-9", ASCII_NUMERIC);
    }
}

