/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.Legend;
import com.objectplanet.chart.LegendRenderer;
import com.objectplanet.chart.LineChartRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class LineChart
extends Chart {
    public static final int SAMPLE_HIGHLIGHT_CIRCLE = 0;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_OPAQUE = 1;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_FILLED = 2;
    public static final int SAMPLE_HIGHLIGHT_SQUARE = 3;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_OPAQUE = 4;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_FILLED = 5;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND = 6;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_OPAQUE = 7;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_FILLED = 8;
    public static final int BEHIND_LINE_LAYOUT = 0;
    public static final int SAME_LEVEL_LINE_LAYOUT = 1;
    public static final int LINE_STYLE_LINE = 0;
    public static final int LINE_STYLE_TUBE = 1;
    private boolean cz;
    private int[] cp;
    private double[] cD;
    private boolean[] cC;
    private float[][] cF;
    private int[] cu;
    private boolean co;
    private int cB;
    private boolean[][] cy;
    private boolean[] ct;
    private int[] cE;
    private int[] cH;
    private boolean[] cA;
    private boolean[] cv;
    private String cr;
    private String[] cw;
    private String[][] cG;
    private boolean cn;
    int[][] cs;
    Color[] cq;
    Color[] cx;

    public LineChart() {
        this(1, 5, 100.0);
    }

    public LineChart(int n, int n2, double d) {
        this(n, n2, d, 0.0);
    }

    public LineChart(int n, int n2, double d, double d2) {
        super(n2);
        this.grid = new Grid(this);
        this.legend = new Legend();
        this.legendRenderer = new LegendRenderer(this);
        this.renderer = new LineChartRenderer(this);
        this.chartType = "line";
        this.setAutomaticRepaintOn(false);
        this.cy = new boolean[n][n2];
        this.ct = new boolean[n];
        this.cE = new int[n];
        this.cH = new int[n];
        this.cH = new int[n];
        this.cA = new boolean[n];
        this.cC = new boolean[n];
        this.cp = new int[n];
        this.cu = new int[n];
        this.cD = new double[n];
        this.cF = new float[n][];
        for (int i = 0; i < this.cH.length; ++i) {
            this.cH[i] = 6;
            this.cA[i] = true;
            this.cC[i] = true;
            this.cp[i] = 2;
            this.cD[i] = 1.0;
        }
        this.cG = new String[n][n2];
        this.cw = new String[n];
        this.cv = new boolean[n];
        this.cs = null;
        this.cq = null;
        this.setSeriesCount(n);
        this.setRange(0, d);
        this.setLowerRange(0, d2);
        this.setSampleColors(null);
        this.bz = 1;
        this.bG = 2;
        this.by = 3;
        this.cz = false;
        this.u = true;
        this.cn = true;
        this.setAutomaticRepaintOn(true);
    }

    public void reset() {
        super.reset();
        this.bz = 1;
        this.bG = 2;
        this.by = 3;
        this.cz = false;
        this.u = true;
        this.cs = null;
        this.cq = null;
        this.cx = null;
    }

    public String[] getLegendLabels() {
        String[] stringArray = this.legend.getLegendLabels();
        if (stringArray != null) {
            return stringArray;
        }
        return this.getSeriesLabels();
    }

    protected double getHighestValue(int n) {
        if (this.co) {
            return Math.max(super.getHighestValue(n), this.getMaxValue(-2));
        }
        return super.getHighestValue(n);
    }

    public double getMaxValue(int n) {
        if (n >= -1 || !this.co) {
            return super.getMaxValue(n);
        }
        double d = 0.0;
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        for (int i = 0; i < n2; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n3; ++j) {
                ChartSample chartSample = this.getSample(j, i);
                if (chartSample == null || chartSample.value == null || chartSample.value.isNaN() || !(chartSample.value > 0.0)) continue;
                d2 += chartSample.value.doubleValue();
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public void setSampleColors(Color[] colorArray) {
        super.setSampleColors(colorArray);
        if (colorArray == null) {
            this.setSampleColor(2, new Color(132, 255, 198));
        }
        this.autoRepaint();
    }

    public int getValuePosition(double d) {
        return this.grid.a(0, d, this.getGraphBounds());
    }

    public Point getSamplePoint(int n, int n2) {
        try {
            int n3 = ((LineChartRenderer)this.renderer).samplePoints[n][n2][0];
            int n4 = ((LineChartRenderer)this.renderer).samplePoints[n][n2][1];
            return new Point(n3 - (this.display3dOn ? this.renderer.depth3dPoint.x : 0), n4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setAutoLabelSpacingOn(boolean bl) {
        if (this.cz != bl) {
            this.cz = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isAutoLabelSpacingOn() {
        return this.cz;
    }

    public void setStackedOn(boolean bl) {
        if (this.co != bl) {
            this.co = bl;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isStackedOn() {
        return this.co;
    }

    public void setLineWidth(int n) {
        this.setLineWidth(-1, n);
    }

    public void setLineWidth(int n, int n2) {
        if (n >= 0 && n < this.cp.length) {
            this.cp[n] = n2;
        } else if (n < 0) {
            for (int i = 0; i < this.cp.length; ++i) {
                this.cp[i] = n2;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public int getLineWidth() {
        return this.getLineWidth(0);
    }

    public int getLineWidth(int n) {
        if (n >= 0 && n < this.cp.length) {
            return this.cp[n];
        }
        return this.cp[0];
    }

    public void setLineStyle(int n, int n2) {
        if (n >= 0 && n < this.cu.length) {
            this.cu[n] = n2;
        } else if (n < 0) {
            for (int i = 0; i < this.cu.length; ++i) {
                this.cu[i] = n2;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public int getLineStyle(int n) {
        if (n >= 0 && n < this.cu.length) {
            return this.cu[n];
        }
        return this.cu[0];
    }

    public void setLine3DDepth(int n, double d) {
        if (n >= 0 && n < this.cD.length) {
            this.cD[n] = d;
        } else if (n < 0) {
            for (int i = 0; i < this.cD.length; ++i) {
                this.cD[i] = d;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public double getLine3DDepth(int n) {
        if (n >= 0 && n < this.cp.length) {
            return this.cD[n];
        }
        return this.cD[0];
    }

    public void setOutlineOn(int n, boolean bl) {
        if (n >= 0) {
            if (this.cC[n] != bl) {
                this.cC[n] = bl;
                this.needRender = true;
                this.autoRepaint();
            }
        } else if (n < 0) {
            for (int i = 0; i < this.cC.length; ++i) {
                this.cC[i] = bl;
            }
        }
    }

    public boolean isOutlineOn(int n) {
        return this.cC[n];
    }

    public void setLineStroke(int n, float[] fArray) {
        int n2 = fArray.length % 2 == 0 ? fArray.length : fArray.length + 1;
        this.cF[n] = new float[n2];
        if (n >= 0 && n < this.cF.length) {
            for (int i = 0; i < fArray.length; ++i) {
                this.cF[n][i] = Math.abs(fArray[i]);
            }
            if (this.cF[n][n2 - 1] == 0.0f) {
                this.cF[n][n2 - 1] = this.cF[n][n2 - 2];
            }
        } else if (n < 0) {
            for (int i = 0; i < this.cF.length; ++i) {
                for (int j = 0; j < fArray.length; ++j) {
                    this.cF[i][j] = Math.abs(fArray[j]);
                }
                if (this.cF[i][n2 - 1] != 0.0f) continue;
                this.cF[i][n2 - 1] = this.cF[i][n2 - 2];
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public float[] getLineStroke(int n) {
        if (this.cF == null || this.cF.length == 0) {
            return new float[]{0.0f};
        }
        if (n >= 0 && n < this.cF.length) {
            return this.cF[n];
        }
        return this.cF[0];
    }

    public void setLine3DLayout(int n) {
        this.cB = n;
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getLine3DLayout() {
        return this.cB;
    }

    public void setSampleHighlightOn(boolean bl) {
        for (int i = 0; i < this.cy.length; ++i) {
            this.ct[i] = bl;
            for (int j = 0; j < this.cy[i].length; ++j) {
                this.cy[i][j] = bl;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, boolean bl) {
        try {
            this.ct[n] = bl;
            for (int i = 0; i < this.cy[n].length; ++i) {
                this.cy[n][i] = bl;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, int n2, boolean bl) {
        try {
            this.cy[n][n2] = bl;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series or index: " + n + ", " + n2);
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isSampleHighlightOn(int n) {
        try {
            return this.ct[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid serie: , " + n);
        }
    }

    public boolean isSampleHighlightOn(int n, int n2) {
        if (this.cy != null && n < this.cy.length && n2 < this.cy[n].length) {
            return this.cy[n][n2];
        }
        return false;
    }

    public void setSampleHighlightStyle(int n, int n2) {
        for (int i = 0; i < this.cE.length; ++i) {
            this.setSampleHighlightStyle(i, n, n2);
        }
    }

    public void setSampleHighlightStyle(int n, int n2, int n3) {
        this.cH[n] = Math.max(0, n3);
        this.cE[n] = n2;
        this.needRender = true;
        this.autoRepaint();
    }

    public int getSampleHighlightStyle(int n) {
        try {
            return this.cE[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public int getSampleHighlightSize(int n) {
        try {
            return this.cH[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public void setSampleHighlightImage(int n, int n2, String string) {
        if (n >= -1 && n < 1000 && n2 >= -1 && n <= 1000) {
            if (n == -1 && n2 == -1) {
                this.cr = string;
            } else if (n2 == -1) {
                int n3 = Math.max(this.cG.length, n + 1);
                if (n >= this.cw.length) {
                    String[] stringArray = new String[n3];
                    for (int i = 0; i < this.cw.length; ++i) {
                        stringArray[i] = this.cw[i];
                    }
                    this.cw = stringArray;
                }
                this.cw[n] = string;
            } else {
                int n4 = Math.max(this.cG.length, n + 1);
                int n5 = Math.max(this.cG[0].length, n2 + 1);
                if (n >= this.cG.length || n2 >= this.cG[0].length) {
                    String[][] stringArray = new String[n4][n5];
                    for (int i = 0; i < this.cG.length; ++i) {
                        for (int j = 0; j < this.cG[0].length; ++j) {
                            stringArray[i][j] = this.cG[i][j];
                        }
                    }
                    this.cG = stringArray;
                }
                this.cG[n][n2] = string;
            }
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public String getSampleHighlightImage(int n, int n2) {
        if (n == -1 && n2 == -1) {
            return this.cr;
        }
        if (n >= 0 && n < this.cw.length && n2 == -1) {
            return this.cw[n];
        }
        if (n >= 0 && n < this.cG.length && n2 >= 0 && n2 < this.cG[0].length) {
            return this.cG[n][n2];
        }
        return null;
    }

    public String getLegendImage(int n) {
        String string = super.getLegendImage(n);
        if (string == null) {
            string = this.getSampleHighlightImage(n, -1);
        }
        return string;
    }

    public void setSeriesLineOn(boolean bl) {
        for (int i = 0; i < this.cA.length; ++i) {
            this.cA[i] = bl;
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSeriesLineOn(int n, boolean bl) {
        if (this.cA[n] != bl) {
            this.cA[n] = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isSeriesLineOn(int n) {
        if (this.cA != null && n < this.cA.length) {
            return this.cA[n];
        }
        return true;
    }

    public void setConnectedLinesOn(int n, boolean bl) {
        if (n >= 0 && n < this.cv.length) {
            this.cv[n] = bl;
        } else if (n == -1) {
            for (int i = 0; i < this.cv.length; ++i) {
                this.cv[i] = bl;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isConnectedLinesOn(int n) {
        if (n >= 0 && n < this.cv.length) {
            return this.cv[n];
        }
        if (n == -1) {
            boolean bl = false;
            for (int i = 0; i < this.cv.length; ++i) {
                if (!this.cv[i]) continue;
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void setArea(int n, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n2 >= this.getSeriesCount() || n3 >= this.getSeriesCount() || n2 == n3) {
            return;
        }
        if (this.cs == null) {
            this.cs = new int[n + 1][2];
            for (int i = 0; i < this.cs.length; ++i) {
                this.cs[i][0] = -1;
                this.cs[i][1] = -1;
            }
        }
        if (n >= this.cs.length) {
            int[][] nArray = new int[n + 1][2];
            System.arraycopy(this.cs, 0, nArray, 0, this.cs.length);
            for (int i = this.cs.length; i < nArray.length - 1; ++i) {
                nArray[i][0] = -1;
                nArray[i][1] = -1;
            }
            this.cs = nArray;
        }
        this.cs[n][0] = n2;
        this.cs[n][1] = n3;
        this.needRender = true;
        this.autoRepaint();
    }

    public int[] getArea(int n) {
        if (this.cs == null || n >= this.cs.length) {
            return new int[]{-1, -1};
        }
        return this.cs[n];
    }

    public void setAreaColor(int n, Color color) {
        if (this.cq == null) {
            this.cq = new Color[n + 1];
        }
        if (n >= this.cq.length) {
            Color[] colorArray = new Color[n + 1];
            System.arraycopy(this.cq, 0, colorArray, 0, this.cq.length);
            this.cq = colorArray;
        }
        this.cq[n] = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getAreaColor(int n) {
        if (this.cq == null || n >= this.cq.length) {
            return null;
        }
        return this.cq[n];
    }

    public void setAreaColor2(int n, Color color) {
        if (this.cx == null) {
            this.cx = new Color[n + 1];
        }
        if (n >= this.cx.length) {
            Color[] colorArray = new Color[n + 1];
            System.arraycopy(this.cx, 0, colorArray, 0, this.cx.length);
            this.cx = colorArray;
        }
        this.cx[n] = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getAreaColor2(int n) {
        if (this.cx == null || n >= this.cx.length) {
            return null;
        }
        return this.cx[n];
    }

    public void setRightToLeftScrollingOn(boolean bl) {
        this.grid.setRightToLeftScrollingOn(bl);
        this.setVisibleSamples(this.visibleSamples[0], this.visibleSamples[1]);
        this.needChartCalculation = true;
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isRightToLeftScrollingOn() {
        return this.grid.isRightToLeftScrollingOn();
    }

    public boolean isMissingValuesInterpolated() {
        return this.cn;
    }

    public void setMissingValuesInterpolated(boolean bl) {
        this.cn = bl;
    }

    protected void checkDataIntegrity() {
        int n;
        super.checkDataIntegrity();
        this.renderer.checkDataIntegrity();
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        int n4 = this.cy != null ? this.cy.length : 1;
        int n5 = n = n4 > 0 && this.cy != null ? this.cy[0].length : 0;
        if (n2 != n4 || n3 != n) {
            boolean[][] blArray = new boolean[n2][n3];
            boolean[] blArray2 = new boolean[n2];
            for (int i = 0; i < n2; ++i) {
                if (i >= n4 || this.ct == null) continue;
                try {
                    blArray2[i] = this.ct[i];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int j = 0; j < n3; ++j) {
                    try {
                        if (j < n) {
                            blArray[i][j] = this.cy[i][j];
                            continue;
                        }
                        blArray[i][j] = this.ct[i];
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.cy = blArray;
            this.ct = blArray2;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            boolean[] blArray3 = new boolean[n2];
            boolean[] blArray4 = new boolean[n2];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            double[] dArray = new double[n2];
            float[][] fArrayArray = new float[n2][];
            boolean[] blArray5 = new boolean[n2];
            for (int i = 0; i < n2; ++i) {
                if (i < n4 && this.cE != null && this.cH != null && this.cA != null && this.cv != null && this.cp != null && this.cF != null && this.cC != null && this.cD != null && this.cu != null) {
                    nArray[i] = this.cE[i];
                    nArray2[i] = this.cH[i];
                    blArray3[i] = this.cA[i];
                    blArray4[i] = this.cv[i];
                    nArray3[i] = this.cp[i];
                    nArray4[i] = this.cu[i];
                    dArray[i] = this.cD[i];
                    fArrayArray[i] = this.cF[i];
                    blArray5[i] = this.cC[i];
                    continue;
                }
                nArray2[i] = 6;
                nArray3[i] = 2;
                dArray[i] = 1.0;
                blArray3[i] = true;
                blArray5[i] = true;
            }
            this.cE = nArray;
            this.cH = nArray2;
            this.cA = blArray3;
            this.cv = blArray4;
            this.cp = nArray3;
            this.cu = nArray4;
            this.cD = dArray;
            this.cF = fArrayArray;
            this.cC = blArray5;
            this.needChartCalculation = true;
        }
    }

    public ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }

    protected void paintLine(Graphics graphics, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        ((LineChartRenderer)this.renderer).paintLine(graphics, n, rectangle, rectangle2, color, bl);
    }

    protected void paint3DLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl, boolean bl2, boolean bl3) {
        ((LineChartRenderer)this.renderer).paint3DLine(graphics, n, n2, n3, n4, n5, color, bl, bl2, bl3);
    }

    protected void paintSampleHighlight(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        ((LineChartRenderer)this.renderer).paintSampleHighlight(graphics, n, n2, n3, n4, color);
    }
}

