/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.LineChartRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;

public class BarChartRenderer
extends ChartRenderer {
    private static final int SIDE_BY_SIDE_BARS = 0;
    private static final int STACKED_BARS = 1;
    private static final int BEHIND_BARS = 2;
    private int barType;
    private double barWidthFraction;
    private Rectangle[][] barBounds;
    private int gridAlignment;
    BarChart chart;

    public BarChartRenderer(BarChart chart) {
        super(chart);
        this.chart = chart;
        this.legend = chart.legend;
        this.gridRenderer = chart.gridRenderer;
        this.legendRenderer = chart.legendRenderer;
    }

    public ChartSample checkSelection(Point point) {
        int selected;
        if (point == null) {
            return null;
        }
        ChartSample foundSample = super.checkSelection(point);
        int seriesCount = this.getSeriesCount();
        int sampleCount = this.getSampleCount();
        boolean from_legend = false;
        if (foundSample == null && (selected = this.legendRenderer.getSelectedElement(point, this.legend)) > -1) {
            if (seriesCount > 1 || this.chart.chartType.equals("line") || this.chart.multiSeriesOn) {
                foundSample = new ChartSample(-1);
                foundSample.setSeries(selected);
            } else if (selected < sampleCount) {
                foundSample = this.chart.getSample(0, selected);
                if (foundSample != null) {
                    foundSample.setSeries(-1);
                }
            } else {
                if (selected >= sampleCount) {
                    selected = -1;
                }
                foundSample = this.chart.getSample(0, selected);
            }
            from_legend = true;
            if (foundSample != null && this.overlayRenderers != null) {
                int overlay_count = this.overlayRenderers.size();
                for (int i = overlay_count - 1; i >= 0; --i) {
                    ChartRenderer overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
                    if (overlay == null) continue;
                    overlay.mouseOverSampleIndex = foundSample.getIndex();
                    overlay.mouseOverSeriesIndex = foundSample.getSeries();
                    if (this.gridAlignment == 1) {
                        overlay.mousePosition.x = this.mousePosition.x;
                        overlay.mousePosition.y = -1;
                        continue;
                    }
                    overlay.mousePosition.x = -1;
                    overlay.mousePosition.y = this.mousePosition.y;
                }
            }
        }
        if (foundSample == null && this.barBounds != null) {
            int samplesToCheck = Math.min(sampleCount, this.chart.visibleSamples[1]);
            int first = this.chart.visibleSamples[0];
            int last = first + samplesToCheck;
            while (foundSample == null && samplesToCheck != 0) {
                int sample = this.gridAlignment == 0 ? last - samplesToCheck : first + samplesToCheck - 1;
                --samplesToCheck;
                int seriesToCheck = seriesCount;
                while (foundSample == null && seriesToCheck != 0) {
                    Polygon right;
                    boolean check_right;
                    Polygon top;
                    int serie = this.barType == 1 ? seriesToCheck - 1 : (this.barType == 2 ? seriesCount - seriesToCheck : (this.gridAlignment == 0 ? seriesCount - seriesToCheck : seriesToCheck - 1));
                    --seriesToCheck;
                    ChartSample currentSample = this.chart.getSample(serie, sample);
                    Rectangle bar = null;
                    try {
                        bar = new Rectangle(this.barBounds[serie][sample]);
                    }
                    catch (NullPointerException e) {
                    }
                    catch (IndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    if (bar == null) continue;
                    Rectangle tip_area = new Rectangle(bar);
                    if (this.barType != 1 || seriesCount <= 1) {
                        if (this.gridAlignment == 1 && tip_area.height < 3) {
                            tip_area.y -= 3 - tip_area.height;
                            tip_area.height = 6;
                        } else if (this.gridAlignment == 0 && tip_area.width < 3) {
                            tip_area.x -= 3 - tip_area.width;
                            tip_area.width = 6;
                        }
                    }
                    if (tip_area.contains(point)) {
                        foundSample = this.chart.getSample(serie, sample);
                    }
                    if (foundSample != null || !this.display3dOn) continue;
                    double upperRange = this.chart.getRange(0);
                    double lowerRange = this.chart.getLowerRange(0);
                    boolean check_top = this.gridAlignment != 1 || this.barType != 1 || serie == 0;
                    check_top |= upperRange > lowerRange && this.chart.getSampleValue(serie, sample) > 0.0;
                    if ((check_top |= upperRange < lowerRange && this.chart.getSampleValue(serie, sample) < 0.0) && (top = this.get3dBarTop(bar, serie)).contains(point)) {
                        foundSample = currentSample;
                    }
                    if (!(check_right = this.gridAlignment != 0 || this.barType != 1 || serie == 0) || !(right = this.get3dBarRight(bar, serie)).contains(point)) continue;
                    foundSample = currentSample;
                }
            }
        }
        if (foundSample != null) {
            this.mouseOverSampleIndex = foundSample.getIndex();
            this.mouseOverSeriesIndex = foundSample.getSeries();
            this.mousePosition = point;
            if (from_legend) {
                if (this.gridAlignment == 1) {
                    this.mousePosition.y = -1;
                } else {
                    this.mousePosition.x = -1;
                }
            }
        } else {
            this.mouseOverSampleIndex = -1;
            this.mouseOverSeriesIndex = -1;
        }
        return foundSample;
    }

    protected void render(Graphics g) {
        this.render(g, !this.chart.isServletModeOn());
    }

    protected void paintGrid(Graphics g, Grid grid, Rectangle gridBounds) {
        this.gridRenderer.paintGrid(g, grid, gridBounds);
        if (this.isAnyBelowLabelsOn()) {
            this.paintBelowSampleLabels(g, gridBounds);
        } else {
            for (int i = 0; i < this.overlayRenderers.size(); ++i) {
                ChartRenderer overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (overlay == null || !(overlay.chart instanceof Chart) || !overlay.isAnyBelowLabelsOn()) continue;
                overlay.paintBelowSampleLabels(g, gridBounds);
                break;
            }
        }
    }

    protected void renderData(Graphics g, Rectangle gridBounds, Rectangle dataBounds) {
        this.paintBars(g, gridBounds);
        if (this.display3dOn && this.parentRenderer == null) {
            for (int i = this.chart.getRangeCount() - 1; i >= 0; --i) {
                this.paint3DZeroDivider(g, gridBounds, i);
            }
        }
        this.paintStaticLabels(g, gridBounds);
    }

    protected void checkDataIntegrity() {
        int serie;
        int sampleCount = this.chart.getSampleCount();
        int seriesCount = this.chart.getSeriesCount();
        if (sampleCount == 0 || seriesCount == 0) {
            return;
        }
        if (this.barBounds == null || this.barBounds.length != seriesCount || this.barBounds[0].length != sampleCount) {
            Rectangle[][] newBarBounds = new Rectangle[seriesCount][sampleCount];
            for (serie = 0; serie < seriesCount; ++serie) {
                for (int sample = 0; sample < sampleCount; ++sample) {
                    if (this.barBounds == null || serie >= this.barBounds.length || sample >= this.barBounds[0].length || this.barBounds[serie][sample] == null) continue;
                    newBarBounds[serie][sample] = this.barBounds[serie][sample];
                }
            }
            this.barBounds = newBarBounds;
        }
        for (int sample = 0; sample < sampleCount; ++sample) {
            for (serie = 0; serie < seriesCount; ++serie) {
                if (this.barBounds[serie][sample] != null) continue;
                this.barBounds[serie][sample] = new Rectangle();
            }
        }
    }

    protected void calculateChartData(Rectangle gridBounds, Rectangle dataBounds) {
        double pos;
        if (!this.chart.needChartCalculation && !this.chart.isServletModeOn()) {
            return;
        }
        this.gridAlignment = this.chart.getGridAlignment();
        this.barType = this.chart.getBarType();
        this.display3dOn = this.chart.is3DModeOn();
        this.gridRenderer.calculateZeroLines(this.chart.getGrid(), gridBounds);
        int sampleCount = this.getSampleCount();
        int seriesCount = this.getSeriesCount();
        this.barWidthFraction = this.chart.getBarWidth();
        double sampleWidth = 0.0;
        double barWidth = dataBounds.width;
        if (sampleCount > 0 && seriesCount > 0) {
            sampleWidth = this.gridAlignment == 1 ? (double)dataBounds.width / (double)sampleCount : (double)dataBounds.height / (double)sampleCount;
            barWidth = sampleWidth * this.barWidthFraction;
            if (this.barType == 0) {
                barWidth /= (double)seriesCount;
            }
        }
        double barSpace = sampleWidth * (1.0 - this.barWidthFraction);
        if (this.gridAlignment == 1) {
            pos = (double)dataBounds.x + barSpace / 2.0;
            if (this.display3dOn) {
                pos -= (double)this.depth3dPoint.x;
            }
        } else {
            pos = (double)dataBounds.y + barSpace / 2.0;
            if (this.display3dOn) {
                pos -= (double)this.depth3dPoint.y;
            }
        }
        if (this.gridAlignment == 1) {
            for (int sample = 0; sample < sampleCount; ++sample) {
                for (int serie = 0; serie < seriesCount; ++serie) {
                    double bar_height;
                    double ypos;
                    double total_height;
                    double height;
                    Rectangle bar = new Rectangle();
                    if (pos >= 0.0) {
                        bar.x = (int)(pos + 0.5);
                        bar.width = (int)(barWidth + 0.5);
                    } else {
                        bar.x = (int)(pos - 0.5);
                        bar.width = (int)(barWidth - 0.5);
                    }
                    if (sampleWidth < 1.3) {
                        bar.width = pos >= 0.0 ? (int)(pos + sampleWidth + 0.5) - bar.x : (int)(pos + sampleWidth - 0.5) - bar.x;
                    }
                    bar.width = Math.max(1, bar.width);
                    boolean stacked = this.barType == 1;
                    int rangeIndex = this.chart.getSeriesRange(serie);
                    double upperRange = this.chart.getRange(rangeIndex);
                    double lowerRange = this.chart.getLowerRange(rangeIndex);
                    double currentUpperRange = this.chart.getCurrentRange(rangeIndex);
                    double currentLowerRange = this.chart.getCurrentLowerRange(rangeIndex);
                    int zeroLine = this.gridRenderer.zeroLine[rangeIndex];
                    double value = this.chart.getSampleValue(serie, sample);
                    if (value >= 0.0) {
                        int chart_bottom;
                        int bar_bottom;
                        height = upperRange > lowerRange ? value / currentUpperRange * (double)(zeroLine - dataBounds.y) : value / currentLowerRange * (double)(dataBounds.y + dataBounds.height - zeroLine);
                        bar.height = (int)(height + 0.5);
                        bar.y = zeroLine;
                        if (upperRange > lowerRange) {
                            bar.y -= bar.height;
                        }
                        if (stacked && serie > 0) {
                            double sum = 0.0;
                            for (int i = 0; i < serie; ++i) {
                                double sample_value = this.chart.getSampleValue(i, sample);
                                if (!(sample_value >= 0.0)) continue;
                                sum += sample_value;
                            }
                            total_height = upperRange > lowerRange ? sum / currentUpperRange * (double)(zeroLine - dataBounds.y) : -(sum / currentLowerRange) * (double)(dataBounds.y + dataBounds.height - zeroLine);
                            ypos = (double)zeroLine - total_height;
                            if (upperRange > lowerRange) {
                                ypos -= height;
                            }
                            bar.y = ypos >= 0.0 ? (int)(ypos + 0.5) : (int)(ypos - 0.5);
                            bar_height = height + ypos - (double)bar.y;
                            bar.height = bar_height >= 0.0 ? (int)(bar_height + 0.5) : (int)(bar_height - 0.5);
                        }
                        if ((bar_bottom = bar.y + bar.height) > (chart_bottom = dataBounds.y + dataBounds.height)) {
                            bar.height -= bar_bottom - chart_bottom;
                        }
                    } else {
                        height = upperRange > lowerRange ? value / currentLowerRange * (double)(dataBounds.y + dataBounds.height - zeroLine) : value / currentUpperRange * (double)(zeroLine - dataBounds.y);
                        bar.height = (int)(height + 0.5);
                        bar.y = zeroLine;
                        if (upperRange < lowerRange) {
                            bar.y -= bar.height;
                        }
                        if (stacked && serie > 0) {
                            double sum = 0.0;
                            for (int i = 0; i < serie; ++i) {
                                if (!(this.chart.getSampleValue(i, sample) < 0.0)) continue;
                                sum += this.chart.getSampleValue(i, sample);
                            }
                            total_height = upperRange > lowerRange ? sum / currentLowerRange * (double)(dataBounds.y + dataBounds.height - zeroLine) : -(sum / currentUpperRange) * (double)(zeroLine - dataBounds.y);
                            ypos = (double)zeroLine + total_height;
                            if (upperRange < lowerRange) {
                                ypos -= height;
                            }
                            bar.y = ypos >= 0.0 ? (int)(ypos + 0.5) : (int)(ypos - 0.5);
                            bar_height = height + ypos - (double)bar.y;
                            bar.height = bar_height >= 0.0 ? (int)(bar_height + 0.5) : (int)(bar_height - 0.5);
                        }
                        if (bar.y < dataBounds.y) {
                            bar.height -= dataBounds.y - bar.y;
                            bar.y = dataBounds.y;
                        }
                    }
                    if (this.display3dOn) {
                        bar.y -= this.depth3dPoint.y;
                    }
                    if (this.barType == 2 && this.display3dOn) {
                        bar.x = (int)((long)bar.x + ((long)serie * Math.round((double)this.depth3dPoint.x / (double)seriesCount) + Math.round((double)this.depth3dPoint.x / (double)seriesCount * (1.0 - this.barWidthFraction) * 0.5)));
                        bar.y = (int)((long)bar.y + ((long)serie * Math.round((double)this.depth3dPoint.y / (double)seriesCount) + Math.round((double)this.depth3dPoint.y / (double)seriesCount * (1.0 - this.barWidthFraction) * 0.5)));
                    }
                    if (this.display3dOn && this.parentRenderer != null && this.parentRenderer instanceof BarChartRenderer && this.parentRenderer.display3dOn) {
                        BarChartRenderer parent = (BarChartRenderer)this.parentRenderer;
                        bar.x = (int)((long)bar.x + Math.round((double)parent.depth3dPoint.x / (double)parent.getSeriesCount() * ((1.0 - parent.chart.getBarWidth()) * 0.5)));
                        bar.y = (int)((long)bar.y + Math.round((double)parent.depth3dPoint.y / (double)parent.getSeriesCount() * ((1.0 - parent.chart.getBarWidth()) * 0.5)));
                    }
                    if (this.barType == 0 || serie == seriesCount - 1) {
                        pos += barWidth;
                    }
                    try {
                        this.barBounds[serie][sample].x = bar.x;
                        this.barBounds[serie][sample].y = bar.y;
                        this.barBounds[serie][sample].width = bar.width;
                        this.barBounds[serie][sample].height = bar.height;
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                pos += barSpace;
            }
        } else {
            for (int sample = 0; sample < sampleCount; ++sample) {
                for (int serie = 0; serie < seriesCount; ++serie) {
                    double bar_width;
                    double xpos;
                    double total_height;
                    double sum;
                    double height;
                    Rectangle bar = new Rectangle();
                    if (pos >= 0.0) {
                        bar.y = (int)(pos + 0.5);
                        bar.height = (int)(barWidth + 0.5);
                    } else {
                        bar.y = (int)(pos - 0.5);
                        bar.height = (int)(barWidth - 0.5);
                    }
                    bar.height = Math.max(1, bar.height);
                    int rangeIndex = this.chart.getSeriesRange(serie);
                    double upperRange = this.chart.getRange(rangeIndex);
                    double lowerRange = this.chart.getLowerRange(rangeIndex);
                    double currentUpperRange = this.chart.getCurrentRange(rangeIndex);
                    double currentLowerRange = this.chart.getCurrentLowerRange(rangeIndex);
                    int zeroLine = this.gridRenderer.zeroLine[rangeIndex];
                    double value = this.chart.getSampleValue(serie, sample);
                    if (value >= 0.0) {
                        height = upperRange > lowerRange ? value / currentUpperRange * (double)(dataBounds.x + dataBounds.width - zeroLine) : value / currentLowerRange * (double)(zeroLine - dataBounds.x);
                        bar.width = (int)(height + 0.5);
                        bar.x = zeroLine;
                        if (upperRange < lowerRange) {
                            bar.x -= bar.width;
                        }
                        if (this.barType == 1 && serie > 0) {
                            sum = 0.0;
                            for (int i = 0; i < serie; ++i) {
                                double sample_value = this.chart.getSampleValue(i, sample);
                                if (!(sample_value >= 0.0)) continue;
                                sum += sample_value;
                            }
                            total_height = this.chart.getRange(0) > this.chart.getLowerRange(0) ? sum / this.chart.getCurrentRange(0) * (double)(dataBounds.x + dataBounds.width - this.gridRenderer.zeroLine[0]) : -(sum / this.chart.getCurrentLowerRange(0)) * (double)(this.gridRenderer.zeroLine[0] - dataBounds.x);
                            xpos = (double)this.gridRenderer.zeroLine[0] + total_height;
                            if (this.chart.getRange(0) < this.chart.getLowerRange(0)) {
                                xpos -= height;
                            }
                            bar.x = xpos >= 0.0 ? (int)(xpos + 0.5) : (int)(xpos - 0.5);
                            bar_width = height + xpos - (double)bar.x;
                            bar.width = bar_width >= 0.0 ? (int)(bar_width + 0.5) : (int)(bar_width - 0.5);
                        }
                        if (bar.x < dataBounds.x) {
                            bar.width -= dataBounds.x - bar.x;
                            bar.x = dataBounds.x;
                        }
                    } else {
                        int chart_edge;
                        int bar_bottom;
                        height = upperRange > lowerRange ? value / currentLowerRange * (double)(zeroLine - dataBounds.x) : value / currentUpperRange * (double)(dataBounds.x + dataBounds.width - zeroLine);
                        bar.width = (int)(height + 0.5);
                        bar.x = zeroLine;
                        if (upperRange > lowerRange) {
                            bar.x -= bar.width;
                        }
                        if (this.barType == 1 && serie > 0) {
                            sum = 0.0;
                            for (int i = 0; i < serie; ++i) {
                                if (!(this.chart.getSampleValue(i, sample) < 0.0)) continue;
                                sum += this.chart.getSampleValue(i, sample);
                            }
                            total_height = this.chart.getRange(0) > this.chart.getLowerRange(0) ? sum / this.chart.getCurrentLowerRange(0) * (double)(this.gridRenderer.zeroLine[0] - dataBounds.x) : -(sum / this.chart.getCurrentRange(0)) * (double)(dataBounds.x + dataBounds.width - this.gridRenderer.zeroLine[0]);
                            xpos = (double)this.gridRenderer.zeroLine[0] - total_height;
                            if (this.chart.getRange(0) > this.chart.getLowerRange(0)) {
                                xpos -= height;
                            }
                            bar.x = xpos >= 0.0 ? (int)(xpos + 0.5) : (int)(xpos - 0.5);
                            bar_width = height + xpos - (double)bar.x;
                            bar.width = bar_width >= 0.0 ? (int)(bar_width + 0.5) : (int)(bar_width - 0.5);
                        }
                        if ((bar_bottom = bar.x + bar.width) > (chart_edge = dataBounds.x + dataBounds.width)) {
                            bar.width -= bar_bottom - chart_edge;
                        }
                    }
                    if (this.display3dOn) {
                        bar.x -= this.depth3dPoint.x;
                    }
                    if (this.barType == 2 && this.display3dOn) {
                        bar.x = (int)((long)bar.x + ((long)serie * Math.round((double)this.depth3dPoint.x / (double)seriesCount) + Math.round((double)this.depth3dPoint.x / (double)seriesCount * (1.0 - this.barWidthFraction) * 0.5)));
                        bar.y = (int)((long)bar.y + ((long)serie * Math.round((double)this.depth3dPoint.y / (double)seriesCount) + Math.round((double)this.depth3dPoint.y / (double)seriesCount * (1.0 - this.barWidthFraction) * 0.5)));
                    }
                    try {
                        this.barBounds[serie][sample].x = bar.x;
                        this.barBounds[serie][sample].y = bar.y;
                        this.barBounds[serie][sample].width = bar.width;
                        this.barBounds[serie][sample].height = bar.height;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (this.barType != 0 && serie != seriesCount - 1) continue;
                    pos += barWidth;
                }
                pos += barSpace;
            }
        }
        this.chart.needChartCalculation = false;
    }

    private void paintBars(Graphics g, Rectangle gridBounds) {
        int sample;
        int seriesCount = this.getSeriesCount();
        int sampleCount = this.getSampleCount();
        if (gridBounds.width < 0 || gridBounds.height < 0) {
            return;
        }
        if (this.display3dOn) {
            g.setClip(gridBounds.x - this.depth3dPoint.x + 1, gridBounds.y + 1, gridBounds.width + this.depth3dPoint.x - 1, gridBounds.height - this.depth3dPoint.y - 1);
        } else if (this.parentRenderer != null && this.parentRenderer.chart != null && this.parentRenderer.display3dOn) {
            g.setClip(gridBounds.x + 1, gridBounds.y, gridBounds.width - 1, gridBounds.height + 1);
        } else {
            g.setClip(gridBounds.x + 1, gridBounds.y + 1, gridBounds.width - 1, gridBounds.height - 1);
        }
        double[][] sampleValues = new double[seriesCount][];
        for (int serie = 0; serie < seriesCount; ++serie) {
            sampleValues[serie] = this.chart.getSampleValues(serie);
        }
        int startIndex = Math.max(this.chart.visibleSamples[0] - 1, 0);
        int stopIndex = Math.min(startIndex + this.chart.visibleSamples[1] + 1, sampleCount);
        if (this.gridAlignment == 1) {
            if (this.barType == 0) {
                for (sample = startIndex; sample < stopIndex; ++sample) {
                    for (int serie = 0; serie < seriesCount; ++serie) {
                        this.paintBar(g, gridBounds, serie, sample);
                    }
                }
            } else if (this.barType == 2) {
                for (sample = startIndex; sample < stopIndex; ++sample) {
                    for (int serie = seriesCount - 1; serie >= 0; --serie) {
                        this.paintBar(g, gridBounds, serie, sample);
                    }
                }
            } else if (this.chart.getRange(0) > this.chart.getLowerRange(0)) {
                int serie;
                for (sample = startIndex; sample < stopIndex; ++sample) {
                    for (serie = seriesCount - 1; serie >= 0; --serie) {
                        try {
                            if (!(sampleValues[serie][sample] < 0.0)) continue;
                            this.paintBar(g, gridBounds, serie, sample);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                    }
                }
                for (sample = startIndex; sample < stopIndex; ++sample) {
                    for (serie = 0; serie < seriesCount; ++serie) {
                        try {
                            if (!(sampleValues[serie][sample] >= 0.0)) continue;
                            this.paintBar(g, gridBounds, serie, sample);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                    }
                }
            } else {
                int serie;
                for (sample = startIndex; sample < stopIndex; ++sample) {
                    for (serie = seriesCount - 1; serie >= 0; --serie) {
                        try {
                            if (!(sampleValues[serie][sample] >= 0.0)) continue;
                            this.paintBar(g, gridBounds, serie, sample);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                    }
                }
                for (sample = startIndex; sample < stopIndex; ++sample) {
                    for (serie = 0; serie < seriesCount; ++serie) {
                        try {
                            if (!(sampleValues[serie][sample] < 0.0)) continue;
                            this.paintBar(g, gridBounds, serie, sample);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                    }
                }
            }
        } else if (this.barType == 0 || this.barType == 2) {
            for (sample = stopIndex - 1; sample >= startIndex; --sample) {
                for (int serie = seriesCount - 1; serie >= 0; --serie) {
                    this.paintBar(g, gridBounds, serie, sample);
                }
            }
        } else if (this.chart.getRange(0) > this.chart.getLowerRange(0)) {
            int serie;
            for (sample = stopIndex - 1; sample >= startIndex; --sample) {
                for (serie = seriesCount - 1; serie >= 0; --serie) {
                    if (!(sampleValues[serie][sample] < 0.0)) continue;
                    this.paintBar(g, gridBounds, serie, sample);
                }
            }
            for (sample = stopIndex - 1; sample >= startIndex; --sample) {
                for (serie = 0; serie < seriesCount; ++serie) {
                    if (!(sampleValues[serie][sample] >= 0.0)) continue;
                    this.paintBar(g, gridBounds, serie, sample);
                }
            }
        } else {
            int serie;
            for (sample = stopIndex - 1; sample >= startIndex; --sample) {
                for (serie = seriesCount - 1; serie >= 0; --serie) {
                    if (!(sampleValues[serie][sample] >= 0.0)) continue;
                    this.paintBar(g, gridBounds, serie, sample);
                }
            }
            for (sample = stopIndex - 1; sample >= startIndex; --sample) {
                for (serie = 0; serie < seriesCount; ++serie) {
                    if (!(sampleValues[serie][sample] < 0.0)) continue;
                    this.paintBar(g, gridBounds, serie, sample);
                }
            }
        }
        if (this.display3dOn) {
            g.setColor(this.chart.getBackground());
            Polygon edge = new Polygon();
            edge.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + gridBounds.height);
            edge.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + gridBounds.height - this.depth3dPoint.y + 1);
            edge.addPoint(gridBounds.x + gridBounds.width - this.depth3dPoint.x - 1, gridBounds.y + gridBounds.height - this.depth3dPoint.y + 1);
            edge.xpoints[0] = gridBounds.x;
            edge.ypoints[0] = gridBounds.y;
            edge.xpoints[1] = gridBounds.x - this.depth3dPoint.x;
            edge.ypoints[1] = gridBounds.y;
            edge.xpoints[2] = gridBounds.x - this.depth3dPoint.x;
            edge.ypoints[2] = gridBounds.y - this.depth3dPoint.y;
            g.setColor(this.chart.getBackground());
            if (this.parentRenderer == null) {
                g.setColor(this.chart.getChartForeground());
            }
        }
    }

    private void paintBar(Graphics g, Rectangle gridBounds, int serie, int sample) {
        double lower;
        ChartSample s = this.chart.getSample(serie, sample);
        int seriesCount = this.getSeriesCount();
        if (s == null || s.value == null || s.value.isNaN() || s.getFloatValue() == 0.0 && this.barType == 1 && seriesCount > 1) {
            return;
        }
        int rangeIndex = this.chart.getSeriesRange(serie);
        double value = s.getFloatValue();
        double upper = this.chart.getCurrentRange(rangeIndex);
        boolean outside_grid = upper > (lower = this.chart.getCurrentLowerRange(rangeIndex)) && (value < lower && lower > 0.0 || value > upper && upper < 0.0);
        if (this.barType != 1 && (outside_grid &= upper < lower && (value < lower && lower < 0.0 || value > upper && upper > 0.0))) {
            return;
        }
        double offset_3d_x = this.depth3dPoint.x;
        double offset_3d_y = this.depth3dPoint.y;
        if (this.barType == 2 && this.display3dOn) {
            offset_3d_x = (long)this.depth3dPoint.x - (long)serie * Math.round((double)this.depth3dPoint.x / (double)seriesCount);
            offset_3d_y = (long)this.depth3dPoint.y - (long)serie * Math.round((double)this.depth3dPoint.y / (double)seriesCount);
            offset_3d_y -= (double)Math.round((double)this.depth3dPoint.y / (double)seriesCount * (1.0 - this.barWidthFraction) * 0.5);
            offset_3d_x -= (double)Math.round((double)this.depth3dPoint.x / (double)seriesCount * (1.0 - this.barWidthFraction) * 0.5);
        }
        Rectangle bar = null;
        if (this.barBounds != null && serie < this.barBounds.length && this.barBounds[serie] != null && sample < this.barBounds[serie].length) {
            bar = new Rectangle(this.barBounds[serie][sample]);
            if (this.display3dOn) {
                double left_cut_off;
                double right_cut_off;
                double bottom_cut_off;
                double top_cut_off = (double)(gridBounds.y - bar.y) - offset_3d_y;
                if (top_cut_off > 0.0) {
                    bar.y = (int)((long)bar.y + Math.round(top_cut_off));
                    bar.height = (int)((long)bar.height - Math.round(top_cut_off));
                }
                if ((bottom_cut_off = (double)(bar.y + bar.height) - ((double)(gridBounds.y + gridBounds.height) - offset_3d_y)) > 0.0) {
                    bar.height = (int)((long)bar.height - Math.round(bottom_cut_off));
                }
                if ((right_cut_off = (double)(bar.x + bar.width) - ((double)(gridBounds.x + gridBounds.width) - offset_3d_x)) > 0.0) {
                    bar.width = (int)((long)bar.width - Math.round(right_cut_off));
                }
                if ((left_cut_off = (double)gridBounds.x - offset_3d_x - (double)bar.x) > 0.0) {
                    bar.x = (int)((long)bar.x + Math.round(left_cut_off));
                    bar.width = (int)((long)bar.width - Math.round(left_cut_off));
                }
            }
        }
        boolean inside = false;
        if (bar != null) {
            inside = (long)bar.x <= (long)(gridBounds.x + gridBounds.width) - (this.display3dOn ? Math.round(offset_3d_x) : 0L);
            inside &= (long)(bar.x + bar.width) >= (long)gridBounds.x - (this.display3dOn ? Math.round(offset_3d_x) : 0L);
            inside &= (long)(bar.y + bar.height) >= (long)gridBounds.y - (this.display3dOn ? Math.round(offset_3d_y) : 0L);
            inside &= (long)bar.y <= (long)(gridBounds.y + gridBounds.height) - (this.display3dOn ? Math.round(offset_3d_y) : 0L);
        }
        if (inside) {
            boolean selected;
            boolean bl = selected = s != null && s.isSelected();
            if (this.chart.getBarShape() == 1) {
                this.paintCylinderBar((Graphics2D)g, bar, serie, sample, selected);
            } else {
                this.paintBlockBar((Graphics2D)g, gridBounds, bar, serie, sample, selected);
            }
        }
    }

    public void paintBlockBar(Graphics2D g, Rectangle gridBounds, Rectangle bar, int serie, int sample, boolean selected) {
        Color chartForeground = this.chart.getChartForeground();
        Color barOutlineColor = this.chart.getBarOutlineColor();
        Color color = this.chart.getSampleColor(0);
        Color color2 = this.chart.getSampleColor2(0);
        if (this.getSeriesCount() > 1 || this.barType == 1 && this.getSeriesCount() > 1 || this.chart.multiSeriesOn) {
            color = this.chart.getSampleColor(serie);
            color2 = this.chart.getSampleColor2(serie);
        } else if (this.chart.isMultiColorOn()) {
            color = this.chart.getSampleColor(sample);
            color2 = this.chart.getSampleColor2(sample);
        }
        if (color2 == null) {
            color2 = color;
        }
        GradientPaint paint = this.gridAlignment == 1 ? new GradientPaint(0.0f, bar.y + bar.height, color, 0.0f, bar.y, color2) : new GradientPaint(bar.x, 0.0f, color, bar.x + bar.width, 0.0f, color2);
        g.setPaint(paint);
        g.fillRect(bar.x, bar.y, bar.width, bar.height);
        if (this.chart.isBarOutlineOn()) {
            Color c = g.getColor();
            if (barOutlineColor != null) {
                g.setColor(barOutlineColor);
            } else {
                g.setColor(chartForeground);
            }
            if (this.barWidthFraction == 1.0) {
                g.drawRect(bar.x, bar.y, bar.width, bar.height);
                if (selected) {
                    g.drawRect(bar.x + 1, bar.y + 1, Math.max(bar.width - 2, 1), bar.height == 2 ? 1 : bar.height - 2);
                }
            } else if (this.display3dOn) {
                g.drawRect(bar.x, bar.y, bar.width - 1, bar.height);
                if (selected) {
                    g.drawRect(bar.x + 1, bar.y + 1, Math.max(bar.width - 3, 1), bar.height == 2 ? 1 : bar.height - 2);
                }
            } else {
                g.drawRect(bar.x, bar.y, bar.width, bar.height);
                if (selected) {
                    g.drawRect(bar.x + 1, bar.y + 1, Math.max(bar.width - 2, 1), bar.height == 2 ? 1 : bar.height - 2);
                }
            }
            g.setColor(c);
        } else if (selected) {
            if (barOutlineColor != null) {
                g.setColor(barOutlineColor);
            } else {
                g.setColor(chartForeground);
            }
            if (this.gridAlignment == 1) {
                g.drawRect(bar.x, bar.y, bar.width - 1, bar.height);
            } else {
                g.drawRect(bar.x, bar.y, bar.width - 1, bar.height - 1);
            }
        }
        if (this.display3dOn) {
            this.paint3DBar(g, bar, selected, serie, sample);
        }
    }

    private void paintCylinderBar(Graphics2D g, Rectangle bar, int serie, int sample, boolean selected) {
        Color color = this.chart.getSampleColor(0);
        Color color2 = this.chart.getSampleColor2(0);
        if (this.getSeriesCount() > 1 || this.barType == 1 && this.getSeriesCount() > 1 || this.chart.multiSeriesOn) {
            color = this.chart.getSampleColor(serie);
            color2 = this.chart.getSampleColor2(serie);
        } else if (this.chart.isMultiColorOn()) {
            color = this.chart.getSampleColor(sample);
            color2 = this.chart.getSampleColor2(sample);
        }
        if (color2 == null) {
            color2 = color;
        }
        if (selected) {
            color = BarChartRenderer.getDarker(BarChartRenderer.getDarker(color));
            color2 = BarChartRenderer.getDarker(BarChartRenderer.getDarker(color2));
        }
        if (color.equals(color2)) {
            color2 = BarChartRenderer.getDarker(BarChartRenderer.getDarker(color));
            color = BarChartRenderer.getBrighter(color);
        }
        int bar_depth_x = this.depth3dPoint.x;
        int bar_depth_y = this.depth3dPoint.y;
        if (this.parentRenderer != null) {
            bar_depth_x = (int)((double)this.depth3dPoint.x * this.barWidthFraction);
            bar_depth_y = (int)((double)this.depth3dPoint.y * this.barWidthFraction);
        }
        if (this.chart.getBarType() == 2) {
            bar_depth_x = this.depth3dPoint.x / this.chart.getSeriesCount();
            bar_depth_y = this.depth3dPoint.y / this.chart.getSeriesCount();
        }
        if (this.display3dOn) {
            bar.x += bar_depth_x / 2;
            bar.y += bar_depth_y / 2;
        }
        if (this.chart.getGridAlignment() == 1) {
            GradientPaint paint = new GradientPaint(bar.x + bar.width / 3, 0.0f, color, bar.x + bar.width, 0.0f, color2, true);
            GradientPaint paint_back = new GradientPaint(bar.x, 0.0f, color, bar.x + bar.width, 0.0f, color2);
            if (this.display3dOn) {
                int lid_height = Math.min((int)((double)(bar.width - 4) / 2.5), -bar_depth_y - 2);
                lid_height = Math.max(1, lid_height);
                if (this.chart.getSampleValue(serie, sample) > 0.0) {
                    g.setPaint(new GradientPaint(bar.x + bar.width / 3, 0.0f, BarChartRenderer.getBrighter(BarChartRenderer.getBrighter(color)), bar.x + bar.width, 0.0f, BarChartRenderer.getBrighter(BarChartRenderer.getBrighter(color2)), true));
                    g.fillArc(bar.x, bar.y + bar.height - lid_height / 2, bar.width, lid_height, 0, 360);
                    g.setPaint(paint);
                    g.fillArc(bar.x, bar.y + bar.height - lid_height / 2, bar.width, lid_height, 0, -180);
                    g.setPaint(paint);
                    Shape clip = g.getClip();
                    g.setClip(bar.x, bar.y, bar.width, bar.height + 1);
                    g.fillRoundRect(bar.x, bar.y, bar.width, bar.height + 15, 5, 15);
                    g.setClip(clip);
                    g.fillArc(bar.x + 2, bar.y - lid_height / 2, bar.width - 4, lid_height, 0, 180);
                    g.setColor(color);
                    g.fillArc(bar.x + 2, bar.y - lid_height / 2, bar.width - 4, lid_height, 0, 360);
                } else {
                    g.setPaint(new GradientPaint(bar.x + bar.width / 3, 0.0f, BarChartRenderer.getBrighter(BarChartRenderer.getBrighter(color)), bar.x + bar.width, 0.0f, BarChartRenderer.getBrighter(BarChartRenderer.getBrighter(color2)), true));
                    g.fillArc(bar.x + 2, bar.y + bar.height - lid_height / 2, bar.width - 4, lid_height, 0, 360);
                    g.setPaint(paint);
                    g.fillArc(bar.x + 2, bar.y + bar.height - lid_height / 2, bar.width - 4, lid_height, 0, -180);
                    g.setPaint(paint);
                    Shape clip = g.getClip();
                    g.setClip(bar.x, bar.y, bar.width, bar.height + 1);
                    g.fillRoundRect(bar.x, bar.y - 13, bar.width, bar.height + 15, 5, 15);
                    g.setClip(clip);
                    g.fillArc(bar.x, bar.y - lid_height / 2, bar.width, lid_height, 0, 180);
                    g.setColor(color);
                    g.fillArc(bar.x, bar.y - lid_height / 2, bar.width, lid_height, 0, 360);
                }
            } else {
                g.setPaint(paint);
                g.fillRect(bar.x, bar.y, bar.width, bar.height);
                g.setPaint(paint_back);
                g.drawLine(bar.x, bar.y, bar.x + bar.width - 1, bar.y);
                g.drawLine(bar.x, bar.y + bar.height, bar.x + bar.width - 1, bar.y + bar.height);
            }
        } else {
            GradientPaint paint = new GradientPaint(0.0f, bar.y + bar.height / 3, color, 0.0f, bar.y + bar.height, color2, true);
            GradientPaint paint_back = new GradientPaint(0.0f, bar.y, color, 0.0f, bar.y + bar.height, color2);
            if (this.display3dOn) {
                int lid_width = Math.min((int)((double)(bar.height - 4) / 1.8), bar_depth_x - 2);
                lid_width = Math.max(1, lid_width);
                if (this.chart.getSampleValue(serie, sample) > 0.0) {
                    g.setPaint(paint);
                    g.fillArc(bar.x - lid_width / 2, bar.y, lid_width, bar.height, 0, 360);
                    g.fillArc(bar.x - lid_width / 2, bar.y, lid_width, bar.height, -90, -180);
                    g.setPaint(paint);
                    Shape clip = g.getClip();
                    g.setClip(bar.x, bar.y, bar.width + 1, bar.height);
                    g.fillRoundRect(bar.x - 14, bar.y, bar.width + 15, bar.height, 15, 5);
                    g.setClip(clip);
                    g.fillArc(bar.x + bar.width - lid_width / 2, bar.y + 2, lid_width, bar.height - 4, -90, 180);
                    g.setColor(color);
                    g.fillArc(bar.x + bar.width - lid_width / 2, bar.y + 2, lid_width, bar.height - 4, 0, 360);
                } else {
                    g.setPaint(paint);
                    g.fillArc(bar.x - lid_width / 2, bar.y + 2, lid_width, bar.height - 4, -90, -180);
                    g.fillArc(bar.x - lid_width / 2, bar.y + 2, lid_width, bar.height - 4, 0, 360);
                    g.setPaint(paint);
                    Shape clip = g.getClip();
                    g.setClip(bar.x - 2, bar.y, bar.width + 2, bar.height);
                    g.fillRoundRect(bar.x - 2, bar.y, bar.width + 15, bar.height, 15, 5);
                    g.setClip(clip);
                    g.setColor(color);
                    g.fillArc(bar.x + bar.width - lid_width / 2, bar.y, lid_width, bar.height, 0, 360);
                    g.fillArc(bar.x + bar.width - lid_width / 2, bar.y, lid_width, bar.height, -90, 180);
                }
            } else {
                g.setPaint(paint);
                g.fillRect(bar.x, bar.y, bar.width, bar.height);
                g.setPaint(paint_back);
                g.drawLine(bar.x, bar.y, bar.x, bar.y + bar.height - 1);
                g.drawLine(bar.x + bar.width, bar.y, bar.x + bar.width, bar.y + bar.height - 1);
            }
        }
    }

    private void paint3DBar(Graphics g, Rectangle bar, boolean selected, int serie, int sample) {
        GradientPaint paint;
        Graphics2D g2D = (Graphics2D)g;
        Polygon top = this.get3dBarTop(bar, serie);
        Polygon right = this.get3dBarRight(bar, serie);
        Color color = BarChartRenderer.getDarker(this.chart.getSampleColor(0));
        Color color2 = BarChartRenderer.getDarker(this.chart.getSampleColor2(0));
        if (this.getSeriesCount() > 1 || this.barType == 1 && this.getSeriesCount() > 1 || this.chart.multiSeriesOn) {
            color = BarChartRenderer.getDarker(this.chart.getSampleColor(serie));
            color2 = BarChartRenderer.getDarker(this.chart.getSampleColor2(serie));
        } else if (this.chart.isMultiColorOn()) {
            color = BarChartRenderer.getDarker(this.chart.getSampleColor(sample));
            color2 = BarChartRenderer.getDarker(this.chart.getSampleColor2(sample));
        }
        if (color2 == null) {
            color2 = color;
        }
        g2D.setColor(color2);
        if (this.gridAlignment == 1) {
            g2D.fillPolygon(top);
            paint = new GradientPaint(0.0f, bar.y + bar.height, color, 0.0f, bar.y, color2, true);
            g2D.setPaint(paint);
            g2D.fillPolygon(right);
        } else {
            g2D.fillPolygon(right);
            paint = new GradientPaint(bar.x, 0.0f, color, bar.x + bar.width, 0.0f, color2, true);
            g2D.setPaint(paint);
            g2D.fillPolygon(top);
        }
        Color barOutlineColor = this.chart.getBarOutlineColor();
        if (this.chart.isBarOutlineOn()) {
            if (barOutlineColor != null) {
                g.setColor(barOutlineColor);
            } else {
                g.setColor(this.chart.getChartForeground());
            }
            g.drawLine(top.xpoints[0], top.ypoints[0], top.xpoints[1], top.ypoints[1]);
            g.drawLine(top.xpoints[1], top.ypoints[1], top.xpoints[2], top.ypoints[2]);
            g.drawLine(top.xpoints[2] - 1, top.ypoints[2], top.xpoints[3] - 1, top.ypoints[3]);
            g.drawLine(right.xpoints[1], right.ypoints[1], right.xpoints[2], right.ypoints[2] - 1);
            if (this.gridAlignment == 1) {
                g.drawLine(right.xpoints[2] - 1, right.ypoints[2], right.xpoints[3] - 1, right.ypoints[3]);
            } else {
                g.drawLine(right.xpoints[2], right.ypoints[2] - 1, right.xpoints[3], right.ypoints[3] - 1);
            }
            if (selected) {
                g.drawLine(top.xpoints[0] + 1, top.ypoints[0], top.xpoints[1] + 1, top.ypoints[1]);
                g.drawLine(top.xpoints[1], top.ypoints[1] + 1, top.xpoints[2], top.ypoints[2] + 1);
                g.drawLine(right.xpoints[0], right.ypoints[0], right.xpoints[1], right.ypoints[1]);
                g.drawLine(right.xpoints[1] - 1, right.ypoints[1], right.xpoints[2] - 1, right.ypoints[2]);
                if (this.gridAlignment == 1) {
                    g.drawLine(right.xpoints[2] - 1, right.ypoints[2] - 1, right.xpoints[3] - 1, right.ypoints[3] - 1);
                } else {
                    g.drawLine(right.xpoints[2], right.ypoints[2], right.xpoints[3], right.ypoints[3]);
                }
            }
        } else if (selected) {
            if (barOutlineColor != null) {
                g.setColor(barOutlineColor);
            } else {
                g.setColor(this.chart.getChartForeground());
            }
            g.drawLine(top.xpoints[0], top.ypoints[0], top.xpoints[1], top.ypoints[1]);
            g.drawLine(top.xpoints[1], top.ypoints[1], top.xpoints[2], top.ypoints[2]);
            g.drawLine(top.xpoints[2] - 1, top.ypoints[2], top.xpoints[3] - 1, top.ypoints[3]);
            g.drawLine(right.xpoints[1], right.ypoints[1], right.xpoints[2], right.ypoints[2] - 1);
            if (this.gridAlignment == 1) {
                g.drawLine(right.xpoints[2] - 1, right.ypoints[2], right.xpoints[3] - 1, right.ypoints[3]);
            } else {
                g.drawLine(right.xpoints[2], right.ypoints[2] - 1, right.xpoints[3], right.ypoints[3] - 1);
            }
        }
    }

    private Polygon get3dBarTop(Rectangle bar, int serie) {
        int seriesCount = this.getSeriesCount();
        int bar_depth_x = this.depth3dPoint.x;
        int bar_depth_y = this.depth3dPoint.y;
        if (this.barType == 2) {
            bar_depth_x = (int)Math.round((double)this.depth3dPoint.x / (double)seriesCount * this.barWidthFraction);
            bar_depth_y = (int)Math.round((double)this.depth3dPoint.y / (double)seriesCount * this.barWidthFraction);
            if (this.barWidthFraction == 1.0 && serie == seriesCount - 1) {
                bar_depth_x = this.depth3dPoint.x - bar_depth_x * (seriesCount - 1);
                bar_depth_y = this.depth3dPoint.y - bar_depth_y * (seriesCount - 1);
            }
        }
        if (this.display3dOn && this.parentRenderer != null && this.parentRenderer instanceof BarChartRenderer && this.parentRenderer.display3dOn) {
            BarChartRenderer parent = (BarChartRenderer)this.parentRenderer;
            bar_depth_x = (int)Math.round((double)parent.depth3dPoint.x / (double)parent.getSeriesCount() * parent.chart.getBarWidth());
            bar_depth_y = (int)Math.round((double)parent.depth3dPoint.y / (double)parent.getSeriesCount() * parent.chart.getBarWidth());
        }
        Polygon top = new Polygon();
        top.addPoint(bar.x, bar.y);
        top.addPoint(top.xpoints[0] + bar_depth_x, top.ypoints[0] + bar_depth_y);
        top.addPoint(top.xpoints[1] + bar.width, top.ypoints[1]);
        top.addPoint(bar.x + bar.width, bar.y);
        return top;
    }

    private Polygon get3dBarRight(Rectangle bar, int serie) {
        int seriesCount = this.getSeriesCount();
        int bar_depth_x = this.depth3dPoint.x;
        int bar_depth_y = this.depth3dPoint.y;
        if (this.barType == 2) {
            bar_depth_x = (int)Math.round((double)this.depth3dPoint.x / (double)seriesCount * this.barWidthFraction);
            bar_depth_y = (int)Math.round((double)this.depth3dPoint.y / (double)seriesCount * this.barWidthFraction);
            if (this.barWidthFraction == 1.0 && serie == seriesCount - 1) {
                bar_depth_x = this.depth3dPoint.x - bar_depth_x * (seriesCount - 1);
                bar_depth_y = this.depth3dPoint.y - bar_depth_y * (seriesCount - 1);
            }
        }
        if (this.display3dOn && this.parentRenderer != null && this.parentRenderer instanceof BarChartRenderer && this.parentRenderer.display3dOn) {
            BarChartRenderer parent = (BarChartRenderer)this.parentRenderer;
            bar_depth_x = (int)Math.round((double)parent.depth3dPoint.x / (double)parent.getSeriesCount() * parent.chart.getBarWidth());
            bar_depth_y = (int)Math.round((double)parent.depth3dPoint.y / (double)parent.getSeriesCount() * parent.chart.getBarWidth());
        }
        Polygon right = new Polygon();
        right.addPoint(bar.x + bar.width, bar.y);
        right.addPoint(bar.x + bar_depth_x + bar.width, bar.y + bar_depth_y);
        right.addPoint(bar.x + bar_depth_x + bar.width, bar.y + bar_depth_y + bar.height);
        right.addPoint(bar.x + bar.width, bar.y + bar.height);
        return right;
    }

    private void paint3DZeroDivider(Graphics g, Rectangle gridBounds, int index) {
        index = Math.min(this.chart.getRangeCount() - 1, Math.max(0, index));
        if (!this.chart.isRangeOn(index) || index >= this.gridRenderer.zeroLine.length) {
            return;
        }
        Color c = index == 0 ? this.chart.getChartForeground() : this.chart.getRangeColor(index);
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 64));
        int zeroLine = this.gridRenderer.zeroLine[index];
        if (this.gridAlignment == 1) {
            int zero_line = Math.max(zeroLine, gridBounds.y);
            zero_line = Math.min(zero_line, gridBounds.y + gridBounds.height);
            int x = gridBounds.x - this.depth3dPoint.x;
            int y = zero_line - this.depth3dPoint.y;
            g.setColor(c);
            g.drawLine(x, y, x + gridBounds.width, y);
            g.drawLine(x + gridBounds.width, y, gridBounds.x + gridBounds.width, zero_line);
        } else {
            int zero_line = Math.max(zeroLine, gridBounds.x);
            zero_line = Math.min(zero_line, gridBounds.x + gridBounds.width);
            int y = gridBounds.y - this.depth3dPoint.y;
            int x = zero_line - this.depth3dPoint.x;
            g.drawLine(x, y, x, y + gridBounds.height);
            g.drawLine(x, y, zero_line, gridBounds.y);
        }
    }

    private void paintStaticLabels(Graphics g, Rectangle gridBounds) {
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        int sampleCount = this.getSampleCount();
        int seriesCount = this.getSeriesCount();
        if (sampleCount == 0 || seriesCount == 0) {
            return;
        }
        int grid_top = gridBounds.y;
        int grid_bottom = grid_top + gridBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0);
        int grid_left = gridBounds.x - (this.display3dOn ? this.depth3dPoint.x : 0);
        int grid_right = gridBounds.x + gridBounds.width;
        Font valueLabelFont = this.getFont("valueLabelFont");
        FontMetrics fm = this.getFontMetrics(valueLabelFont);
        int valueLabelAngle = this.getLabelAngle("valueLabelAngle");
        int valueAscent = fm.getAscent();
        int valueLabelStyle = this.chart.getValueLabelStyle();
        Font sampleLabelFont = this.getFont("sampleLabelFont");
        int sampleAngle = this.getLabelAngle("sampleLabelAngle");
        boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
        int sampleLabelStyle = this.chart.getSampleLabelStyle();
        Font seriesLabelFont = this.getFont("seriesLabelFont");
        boolean seriesLabelsOn = this.chart.isSeriesLabelsOn();
        int seriesLabelStyle = this.chart.getSeriesLabelStyle();
        boolean outside = this.chart.isValueLabelsOn() && valueLabelStyle == 1;
        outside |= sampleLabelsOn && sampleLabelStyle == 1;
        boolean stacked_and_outside = (outside |= seriesLabelsOn && seriesLabelStyle == 1) && this.barType == 1 && seriesCount > 1;
        int start = Math.max(this.chart.visibleSamples[0] - 1, 0);
        int stop = Math.min(start + this.chart.visibleSamples[1] + 1, sampleCount);
        for (int sample = start; sample < stop; ++sample) {
            boolean paint_label = true;
            Rectangle bar = null;
            Rectangle negative_bar = null;
            for (int series = 0; series < seriesCount; ++series) {
                int label_y;
                int label_x;
                Font font;
                int angle;
                String postfix;
                if (!this.chart.isValueLabelsOn(series) && !sampleLabelsOn && !seriesLabelsOn) continue;
                String prefix = this.getLabel("valueLabelPrefix_" + series);
                if (prefix == null || stacked_and_outside) {
                    prefix = this.getLabel("valueLabelPrefix");
                }
                if ((postfix = this.getLabel("valueLabelPostfix_" + series)) == null || stacked_and_outside) {
                    postfix = this.getLabel("valueLabelPostfix");
                }
                double value = 0.0;
                double negative_value = 0.0;
                if (this.barBounds != null) {
                    if (series < this.barBounds.length && this.barBounds[series] != null && sample < this.barBounds[series].length) {
                        bar = this.barBounds[series][sample].y > (this.display3dOn ? -this.depth3dPoint.y : 0) || this.barBounds[series][sample].height != (this.display3dOn ? -this.depth3dPoint.y : 0) ? this.barBounds[series][sample] : null;
                    }
                    if (this.barBounds.length > 0 && series < this.barBounds.length && this.barBounds[0] != null && sample < this.barBounds[0].length && (this.barBounds[series][sample].x > 0 || this.barBounds[series][sample].width != 0)) {
                        negative_bar = this.barBounds[series][sample];
                    }
                }
                if (bar == null) continue;
                if (stacked_and_outside && bar != null && negative_bar != null) {
                    boolean validValue = false;
                    for (int i = 0; i < seriesCount; ++i) {
                        ChartSample s = this.chart.getSample(i, sample);
                        if (s == null || s.value == null || s.value.isNaN()) continue;
                        validValue = true;
                        double val = s.getFloatValue();
                        if (val >= 0.0) {
                            value += val;
                            continue;
                        }
                        negative_value += val;
                    }
                    if (!validValue) {
                        continue;
                    }
                } else {
                    ChartSample s = this.chart.getSample(series, sample);
                    if (s == null || s.value == null || s.value.isNaN()) continue;
                    value = s.getFloatValue();
                }
                if (bar != null && (seriesLabelsOn && seriesLabelStyle == 0 || sampleLabelsOn && sampleLabelStyle == 0 || this.chart.isValueLabelsOn(-1) && valueLabelStyle == 0)) {
                    angle = 0;
                    Color fontColor = null;
                    font = seriesLabelFont;
                    if (valueLabelStyle == 0 && this.chart.isValueLabelsOn(series)) {
                        angle = valueLabelAngle;
                        fontColor = this.chart.getValueLabelColor(series);
                        font = valueLabelFont;
                    }
                    if (sampleLabelStyle == 0 && sampleLabelsOn) {
                        angle = sampleAngle;
                        if (this.chart.getSampleLabelColor(sample) != null) {
                            fontColor = this.chart.getSampleLabelColor(sample);
                        }
                        font = sampleLabelFont;
                    }
                    if (seriesLabelStyle == 0 && seriesLabelsOn && fontColor == null) {
                        fontColor = this.chart.getSeriesLabelColor(series);
                    }
                    fm = this.getFontMetrics(font);
                    g.setFont(font);
                    if (fontColor == null) {
                        Color c = this.chart.getSampleColor(0);
                        if (this.chart.isMultiColorOn()) {
                            c = seriesCount > 1 || this.barType == 1 || this.chart.isMultiSeriesOn() ? this.chart.getSampleColor(series) : this.chart.getSampleColor(sample);
                        }
                        if ((c.getRed() + c.getGreen() + c.getBlue()) / 3 > 110) {
                            g.setColor(Color.black);
                        } else {
                            g.setColor(Color.white);
                        }
                    }
                    String label = this.chart.constructLabel(series, sample, 0, seriesLabelsOn, null);
                    Dimension labelSize = this.getLabelSize(label, fm);
                    Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                    if (this.gridAlignment == 1) {
                        label_x = bar.x + bar.width / 2 - angledSize.width / 2 + 1;
                        if (this.chart.getBarShape() == 1) {
                            int bar_depth_x = this.depth3dPoint.x;
                            if (this.chart.getBarType() == 2) {
                                bar_depth_x = this.depth3dPoint.x / this.chart.getSeriesCount();
                            }
                            label_x += bar_depth_x / 2;
                        }
                        if (value >= 0.0 && this.chart.getRange(0) >= 0.0 || value < 0.0 && this.chart.getLowerRange(0) >= 0.0) {
                            if (angle % 180 == 0) {
                                label_y = bar.y + fm.getAscent();
                                label_y = Math.max(label_y, gridBounds.y + fm.getAscent() - (this.display3dOn ? this.depth3dPoint.y : 0));
                                label_y = Math.min(label_y, gridBounds.y + gridBounds.height - 2 - (this.display3dOn ? this.depth3dPoint.y : 0));
                            } else {
                                label_y = bar.y + 3;
                                if (this.barType != 2) {
                                    label_y = Math.min(label_y, gridBounds.y + gridBounds.height - angledSize.height - 2 - (this.display3dOn ? this.depth3dPoint.y : 0));
                                    label_y = Math.max(label_y, gridBounds.y + 3 - (this.display3dOn ? this.depth3dPoint.y : 0));
                                }
                            }
                        } else if (angle % 180 == 0) {
                            label_y = bar.y + bar.height - 2;
                            label_y = Math.min(label_y, gridBounds.y + gridBounds.height - 2 - (this.display3dOn ? this.depth3dPoint.y : 0));
                            label_y = Math.max(label_y, gridBounds.y + angledSize.height - 1 - (this.display3dOn ? this.depth3dPoint.y : 0));
                        } else {
                            label_y = bar.y + bar.height - angledSize.height - 2;
                            label_y = Math.min(label_y, gridBounds.y + gridBounds.height - angledSize.height - 2 - (this.display3dOn ? this.depth3dPoint.y : 0));
                            label_y = Math.max(label_y, gridBounds.y + 3 - (this.display3dOn ? this.depth3dPoint.y : 0));
                        }
                        if (this.barType == 1 && seriesCount > 1) {
                            if (angle % 180 == 0) {
                                paint_label = label_y < bar.y + bar.height;
                                paint_label &= label_y - fm.getAscent() >= bar.y;
                            } else {
                                paint_label = label_y + angledSize.height < bar.y + bar.height;
                                paint_label &= label_y >= bar.y;
                            }
                        }
                    } else {
                        label_y = angle % 180 == 0 ? bar.y + bar.height / 2 + angledSize.height / 2 - 1 : bar.y + bar.height / 2 - angledSize.height / 2 + 1;
                        if (value >= 0.0 && this.chart.getRange(0) >= 0.0 || value < 0.0 && this.chart.getLowerRange(0) >= 0.0) {
                            label_x = bar.x + bar.width - angledSize.width - 1;
                            label_x = Math.max(label_x, gridBounds.x + 2 - (this.display3dOn ? this.depth3dPoint.x : 0));
                            label_x = Math.min(label_x, gridBounds.x + gridBounds.width - angledSize.width - 1 - (this.display3dOn ? this.depth3dPoint.x : 0));
                        } else {
                            label_x = bar.x + 2;
                            label_x = Math.max(label_x, gridBounds.x + 2 - (this.display3dOn ? this.depth3dPoint.x : 0));
                            label_x = Math.min(label_x, gridBounds.x + gridBounds.width - angledSize.width - 1 - (this.display3dOn ? this.depth3dPoint.x : 0));
                        }
                        if (this.barType == 1 && seriesCount > 1) {
                            paint_label = label_x > bar.x;
                            paint_label &= label_x + angledSize.width <= bar.x + bar.width;
                        }
                    }
                    if (this.gridAlignment == 1) {
                        if (label_x + angledSize.width / 2 < grid_left - 3 || label_x + angledSize.width / 2 > grid_right + 3 - (this.display3dOn ? this.depth3dPoint.x : 0)) {
                            paint_label = false;
                        }
                    } else if (angle % 180 == 0) {
                        if (label_y - fm.getHeight() / 2 > grid_bottom || label_y - fm.getHeight() / 2 < grid_top - 3 - (this.display3dOn ? this.depth3dPoint.y : 0)) {
                            paint_label = false;
                        }
                    } else if (label_y + angledSize.height / 2 > grid_bottom || label_y + angledSize.height / 2 < grid_top - 3 - (this.display3dOn ? this.depth3dPoint.y : 0)) {
                        paint_label = false;
                    }
                    if (paint_label) {
                        g.setColor(fontColor);
                        this.paintLabel(g, label, label_x, label_y, labelSize, this.chart.getMultilineLabelAlignment(), angle, false);
                    }
                }
                if (bar == null || !(seriesLabelsOn && seriesLabelStyle == 1 || sampleLabelsOn && sampleLabelStyle == 1) && (!this.chart.isValueLabelsOn(-1) || valueLabelStyle != 1) || stacked_and_outside && series < seriesCount - 1) continue;
                if (stacked_and_outside) {
                    for (int i = 0; i < this.barBounds.length; ++i) {
                        Rectangle b = this.barBounds[i][sample];
                        if (b == null) continue;
                        if (this.gridAlignment == 1) {
                            if (b.y + b.height > negative_bar.y + negative_bar.height) {
                                negative_bar = b;
                            }
                            if (b.y >= bar.y && bar.y + bar.height + (this.display3dOn ? this.depth3dPoint.y : 0) != 0 || b.height <= 0 && b.y == grid_top - (this.display3dOn ? this.depth3dPoint.y : 0)) continue;
                            bar = b;
                            continue;
                        }
                        if (b.x < negative_bar.x && b.x >= grid_left) {
                            negative_bar = b;
                        }
                        if (b.x + b.width <= bar.x + bar.width) continue;
                        bar = b;
                    }
                }
                angle = 0;
                Color fontColor = null;
                font = null;
                if (valueLabelStyle == 1 && this.chart.isValueLabelsOn(series)) {
                    angle = valueLabelAngle;
                    fontColor = this.chart.getValueLabelColor(series);
                    font = valueLabelFont;
                }
                if (sampleLabelStyle == 1 && sampleLabelsOn) {
                    angle = sampleAngle;
                    if (this.chart.getSampleLabelColor(sample) != null) {
                        fontColor = this.chart.getSampleLabelColor(sample);
                    }
                    font = sampleLabelFont;
                }
                if (seriesLabelStyle == 1 && seriesLabelsOn) {
                    if (font == null) {
                        font = seriesLabelFont;
                    }
                    if (fontColor == null) {
                        fontColor = this.chart.getSeriesLabelColor(series);
                    }
                }
                if (fontColor == null) {
                    fontColor = this.chart.getChartForeground();
                }
                if (font == null) {
                    font = new Font("Arial", 0, 11);
                }
                fm = this.getFontMetrics(font);
                g.setFont(font);
                String label = this.chart.constructLabel(series, sample, 1, seriesLabelsOn, null);
                String negative_label = "";
                Dimension negativeLabelSize = null;
                Dimension negativeLabelAngledSize = null;
                if (stacked_and_outside) {
                    angle = valueLabelAngle;
                    g.setFont(valueLabelFont);
                    String valueLabel = this.chart.formatSeriesNumber(series, value);
                    valueLabel = prefix != null ? prefix + valueLabel : valueLabel;
                    valueLabel = postfix != null ? valueLabel + postfix : valueLabel;
                    String sampleLabel = "";
                    if (sampleLabelsOn && sampleLabelStyle == 1 && (sampleLabel = this.chart.getSampleLabel(sample)) != null && !sampleLabel.endsWith("\n") && valueLabel != null && this.chart.isValueLabelsOn() && valueLabelStyle == 1) {
                        sampleLabel = sampleLabel + " : ";
                    }
                    label = sampleLabel;
                    if (this.chart.isValueLabelsOn() && valueLabelStyle == 1) {
                        label = label == null ? valueLabel : label + valueLabel;
                    }
                    if (negative_value < 0.0) {
                        if (this.chart.isValueLabelsOn() && valueLabelStyle == 1) {
                            negative_label = this.chart.formatSeriesNumber(series, negative_value);
                            negative_label = prefix != null ? prefix + negative_label : negative_label;
                            String string = negative_label = postfix != null ? negative_label + postfix : negative_label;
                        }
                        if (sampleLabel != null) {
                            negative_label = sampleLabel + negative_label;
                        }
                        negativeLabelSize = this.getLabelSize(negative_label, this.getFontMetrics(valueLabelFont));
                        negativeLabelAngledSize = this.getAngledLabelSize(negativeLabelSize, angle);
                    }
                }
                Dimension labelSize = this.getLabelSize(label, fm);
                Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                if (value >= 0.0 && this.chart.getRange(0) >= 0.0 || value < 0.0 && this.chart.getLowerRange(0) >= 0.0) {
                    if (this.gridAlignment == 1) {
                        label_x = bar.x + bar.width / 2 - angledSize.width / 2;
                        if (angle % 180 == 0) {
                            label_y = bar.y - 2 - angledSize.height + fm.getHeight() - fm.getDescent();
                            label_y = Math.max(grid_top - 2 - angledSize.height + fm.getHeight() - fm.getDescent(), label_y);
                            label_y = Math.min(grid_bottom - 2 - angledSize.height + fm.getHeight() - fm.getDescent(), label_y);
                        } else {
                            label_y = bar.y - 2 - angledSize.height;
                            label_y = Math.max(label_y, grid_top - angledSize.height - 2);
                            label_y = Math.min(label_y, grid_bottom - angledSize.height - 2);
                        }
                        if (angle % 180 > 0 && angle % 180 < 90) {
                            label_x = bar.x + bar.width - angledSize.width + 1;
                        } else if (angle % 180 > 90) {
                            label_x = bar.x - 1;
                        }
                        if (this.display3dOn && (seriesCount == 1 || stacked_and_outside)) {
                            label_y += this.depth3dPoint.y;
                            label_x += this.depth3dPoint.x;
                            label_y = angle % 180 == 0 ? Math.max(grid_top - 2, label_y) : Math.max(grid_top - angledSize.height - 2, label_y);
                        }
                        if (label_x + angledSize.width / 2 < grid_left - 3 || label_x + angledSize.width / 2 > grid_right + 3) {
                            paint_label = false;
                        }
                    } else {
                        label_y = angle % 180 == 0 ? bar.y + bar.height / 2 + angledSize.height / 2 - 1 : bar.y + bar.height / 2 - angledSize.height / 2 + 1;
                        label_x = bar.x + bar.width + 3;
                        label_x = Math.min(gridBounds.x + gridBounds.width + 3, label_x);
                        label_x = Math.max(grid_left + 3, label_x);
                        if (this.display3dOn && (seriesCount == 1 || stacked_and_outside)) {
                            label_y += this.depth3dPoint.y;
                            label_x += this.depth3dPoint.x;
                            label_x = Math.min(gridBounds.x + gridBounds.width + 3, label_x);
                        }
                        if (angle % 180 == 0) {
                            if (label_y - fm.getHeight() / 2 < grid_top - 3 || label_y - fm.getHeight() / 2 > grid_bottom) {
                                paint_label = false;
                            }
                        } else if (label_y + angledSize.height / 2 < grid_top - 3 || label_y + angledSize.height / 2 > grid_bottom) {
                            paint_label = false;
                        }
                    }
                    if (paint_label && (value != 0.0 || !(negative_value < 0.0))) {
                        g.setColor(fontColor);
                        this.paintLabel(g, label, label_x, label_y, labelSize, this.chart.getMultilineLabelAlignment(), angle, false);
                    }
                }
                if (stacked_and_outside && negative_value < 0.0) {
                    value = negative_value;
                    label = negative_label;
                    labelSize = negativeLabelSize;
                    angledSize = negativeLabelAngledSize;
                }
                if (!(value < 0.0 && this.chart.getLowerRange(0) < 0.0) && (!(value >= 0.0) || !(this.chart.getRange(0) < 0.0))) continue;
                if (this.gridAlignment == 1) {
                    label_x = negative_bar.x + negative_bar.width / 2 - angledSize.width / 2;
                    if (angle % 180 == 0) {
                        label_y = negative_bar.y + negative_bar.height + valueAscent;
                        label_y = Math.min(grid_bottom + valueAscent, label_y);
                        label_y = Math.max(label_y, this.display3dOn ? grid_top - this.depth3dPoint.y + valueAscent : grid_top + valueAscent);
                    } else {
                        label_y = negative_bar.y + negative_bar.height + 3;
                        label_y = Math.min(grid_bottom + 3, label_y);
                        label_y = Math.max(label_y, this.display3dOn ? grid_top - this.depth3dPoint.y + 2 : grid_top + 2);
                    }
                    if (angle % 180 > 0 && angle % 180 < 90) {
                        label_x = bar.x + bar.width - angledSize.width + 1;
                    } else if (angle % 180 > 90) {
                        label_x = bar.x - 1;
                    }
                    if (label_x + angledSize.width / 2 < grid_left - 3 || label_x + angledSize.width / 2 > grid_right + 3) {
                        paint_label = false;
                    }
                } else {
                    label_y = angle % 180 == 0 ? negative_bar.y + bar.height / 2 + angledSize.height / 2 - 1 : negative_bar.y + bar.height / 2 - angledSize.height / 2 + 1;
                    label_x = negative_bar.x - angledSize.width - 3;
                    label_x = Math.max(grid_left - labelSize.width - 3, label_x);
                    label_x = Math.min(grid_left + gridBounds.width - labelSize.width - 3, label_x);
                    if (angle % 180 == 0) {
                        if (label_y - fm.getHeight() / 2 < grid_top - 3 || label_y - fm.getHeight() / 2 > grid_bottom) {
                            paint_label = false;
                        }
                    } else if (label_y + angledSize.height / 2 < grid_top - 3 || label_y + angledSize.height / 2 > grid_bottom) {
                        paint_label = false;
                    }
                }
                if (!paint_label) continue;
                g.setColor(fontColor);
                this.paintLabel(g, label, label_x, label_y, labelSize, this.chart.getMultilineLabelAlignment(), angle, false);
            }
        }
    }

    void paintBelowSampleLabels(Graphics g, Rectangle gridBounds) {
        boolean paint = this.chart.sampleLabelsOn && this.chart.sampleLabelStyle == 2;
        paint |= this.chart.sampleLabelsOn && this.chart.sampleLabelStyle == 4;
        if (!(paint |= this.chart.barLabelsOn)) {
            return;
        }
        String[] labels = this.chart.getSampleLabels();
        if (this.chart.barLabelsOn) {
            labels = this.chart.getBarLabels();
        }
        if (labels == null) {
            return;
        }
        Font barLabelFont = this.getFont("sampleLabelFont");
        int angle = this.getLabelAngle("sampleLabelAngle");
        if (this.chart.barLabelsOn) {
            barLabelFont = this.getFont("barLabelFont");
            angle = this.getLabelAngle("barLabelAngle");
        }
        FontMetrics fm = this.getFontMetrics(barLabelFont);
        g.setFont(barLabelFont);
        int barType = this.chart.getBarType();
        if (this.gridAlignment == 1) {
            int last_label_x = 0;
            int start = Math.max(this.chart.visibleSamples[0] - 1, 0);
            int stop = Math.min(start + this.chart.visibleSamples[1] + 1, labels.length);
            for (int index = start; index < stop; ++index) {
                if (labels[index] == null) continue;
                boolean selected = false;
                int series_count = this.getSeriesCount();
                if (index < this.getSampleCount()) {
                    for (int i = 0; i < series_count; ++i) {
                        if (!this.chart.isSelected(i, index)) continue;
                        selected = true;
                        break;
                    }
                }
                Color fontColor = null;
                if (this.chart.isBarLabelsOn()) {
                    fontColor = this.chart.getBarLabelColor(index);
                }
                if (fontColor == null) {
                    fontColor = this.chart.getSampleLabelColor(index);
                }
                if (fontColor == null) {
                    fontColor = this.chart.getForeground();
                }
                if (selected && this.chart.getSampleLabelSelectionColor() != null) {
                    g.setColor(this.chart.getSampleLabelSelectionColor());
                } else if (fontColor != null) {
                    g.setColor(fontColor);
                }
                Dimension labelSize = this.getLabelSize(labels[index], fm);
                Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                int label_x = Integer.MIN_VALUE;
                int w = 0;
                if (this.barBounds != null && this.barBounds.length > 0 && index < this.barBounds[0].length) {
                    label_x = this.barBounds[0][index].x;
                    w = this.barBounds[this.barBounds.length - 1][index].x + this.barBounds[this.barBounds.length - 1][index].width - label_x;
                    if (barType == 2) {
                        w = this.barBounds[0][index].x + this.barBounds[0][index].width - label_x;
                    }
                }
                int center = label_x + w / 2;
                label_x = angle % 90 == 0 ? center - angledSize.width / 2 : (angle % 180 > 90 ? center + w / 2 - angledSize.width : center - w / 2);
                int left = gridBounds.x - 2 - (this.display3dOn ? this.depth3dPoint.x : 0);
                if (center < left || center > gridBounds.x + gridBounds.width + 2) continue;
                int label_y = gridBounds.y + gridBounds.height + 6;
                if (angle % 180 == 0) {
                    label_y += fm.getMaxAscent() - 4;
                }
                if (this.display3dOn) {
                    label_y -= this.depth3dPoint.y;
                }
                if (this.chart.isSampleScrollerOn()) {
                    label_y += 10;
                }
                if (this.chart.isValueLabelsOn() && this.chart.valueLabelStyle == 1 && this.chart.getLowerRange(0) < 0.0) {
                    int bottom = gridBounds.y;
                    int zero = this.gridRenderer.zeroLine[0] - (this.display3dOn ? this.depth3dPoint.y : 0);
                    for (int serie = 0; serie < this.barBounds.length; ++serie) {
                        int y = this.barBounds[serie][index].y + this.barBounds[serie][index].height;
                        if (y <= bottom || y <= zero) continue;
                        bottom = y;
                    }
                    label_y = Math.max(label_y, bottom + fm.getMaxAscent() + 10);
                    bottom = gridBounds.y + gridBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0);
                    label_y = Math.min(label_y, bottom + fm.getMaxAscent() + 10);
                }
                if (this.chart.isAutoLabelSpacingOn()) {
                    if (labels[index] == null || labels[index].trim().length() <= 0 || label_x <= last_label_x && index != 0) continue;
                    this.paintLabel(g, labels[index], label_x, label_y, labelSize, 0, angle, false);
                    last_label_x = label_x + angledSize.width;
                    continue;
                }
                this.paintLabel(g, labels[index], label_x, label_y, labelSize, 0, angle, false);
            }
        } else {
            int last_label_y = 0;
            int count = Math.min(labels.length, this.getSampleCount());
            int start = Math.max(this.chart.visibleSamples[0] - 1, 0);
            int stop = Math.min(start + this.chart.visibleSamples[1] + 1, count);
            for (int index = start; index < stop; ++index) {
                if (labels[index] == null) continue;
                boolean selected = false;
                int series_count = this.getSeriesCount();
                for (int i = 0; i < series_count; ++i) {
                    if (!this.chart.isSelected(i, index)) continue;
                    selected = true;
                    break;
                }
                Color fontColor = null;
                if (this.chart.isBarLabelsOn()) {
                    fontColor = this.chart.getBarLabelColor(index);
                }
                if (fontColor == null) {
                    fontColor = this.chart.getSampleLabelColor(index);
                }
                if (fontColor == null) {
                    fontColor = this.chart.getForeground();
                }
                if (selected && this.chart.getSampleLabelSelectionColor() != null) {
                    g.setColor(this.chart.getSampleLabelSelectionColor());
                } else if (fontColor != null) {
                    g.setColor(fontColor);
                }
                Dimension labelSize = this.getLabelSize(labels[index], fm);
                Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                int height = angledSize.height;
                if (this.barBounds != null && this.barBounds.length > 0 && index < this.barBounds[this.barBounds.length - 1].length && index < this.barBounds[0].length) {
                    height = this.barBounds[this.barBounds.length - 1][index].y + this.barBounds[this.barBounds.length - 1][index].height - this.barBounds[0][index].y;
                    if (barType == 2) {
                        height = this.barBounds[0][index].y + this.barBounds[0][index].height - this.barBounds[0][index].y;
                    }
                }
                int center = 0;
                if (this.barBounds != null && this.barBounds.length > 0 && index < this.barBounds[0].length) {
                    center = this.barBounds[0][index].y + height / 2;
                }
                int label_y = center - angledSize.height / 2;
                if (angle % 180 == 0) {
                    label_y += fm.getAscent() - 1;
                } else if (angle % 180 > 90) {
                    label_y = center - height / 2;
                } else if (angle % 180 != 90) {
                    label_y = center + height / 2 - angledSize.height;
                }
                if (center < gridBounds.y || center > gridBounds.y + gridBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0)) continue;
                int label_x = gridBounds.x - angledSize.width - 3;
                if (this.display3dOn) {
                    label_x -= this.depth3dPoint.x;
                }
                if (this.chart.isSampleScrollerOn()) {
                    label_x -= 10;
                }
                if (this.chart.isValueLabelsOn() && this.chart.valueLabelStyle == 1 && this.chart.getLowerRange(0) < 0.0) {
                    int left = gridBounds.x + gridBounds.width;
                    int value_label_width = 0;
                    double value = 0.0;
                    for (int serie = 0; serie < this.barBounds.length; ++serie) {
                        if (this.chart.getSampleValue(serie, index) >= 0.0) continue;
                        value = barType == 1 ? (value += this.chart.getSampleValue(serie, index)) : this.chart.getSampleValue(serie, index);
                        if (this.barBounds[serie][index].x >= left) continue;
                        String prefix = this.getLabel("valueLabelPrefix");
                        String postfix = this.getLabel("valueLabelPostfix");
                        left = this.barBounds[serie][index].x;
                        String label = this.chart.formatSeriesNumber(serie, value);
                        label = prefix != null ? prefix + label : label;
                        label = postfix != null ? label + postfix : label;
                        value_label_width = fm.stringWidth(label);
                    }
                    label_x = Math.min(label_x, left - value_label_width - angledSize.width - 3);
                    left = gridBounds.x - (this.display3dOn ? this.depth3dPoint.x : 0);
                    label_x = Math.max(label_x, left - value_label_width - angledSize.width - 3);
                    label_x = Math.min(label_x, (left -= this.chart.isSampleScrollerOn() ? 10 : 0) - angledSize.width - 3);
                }
                if (this.chart.isAutoLabelSpacingOn()) {
                    if (labels[index] == null || labels[index].trim().length() <= 0 || label_y <= last_label_y && index != 0) continue;
                    this.paintLabel(g, labels[index], label_x, label_y, labelSize, 1, angle, false);
                    last_label_y = label_y + angledSize.height;
                    continue;
                }
                this.paintLabel(g, labels[index], label_x, label_y, labelSize, 1, angle, false);
            }
        }
    }

    protected Rectangle getLineChartBounds(Rectangle dataBounds) {
        Rectangle lineBounds = dataBounds;
        int seriesCount = 1;
        if (this.barType == 0) {
            seriesCount = this.getSeriesCount();
        }
        if (this.getSampleCount() > 1 && this.barBounds != null && this.barBounds.length > 0 && this.barBounds[0] != null && this.barBounds[0].length > 0) {
            int change = this.barBounds[0][0].x + this.barBounds[0][0].width * seriesCount / 2 - dataBounds.x;
            lineBounds.x += change;
            lineBounds.width -= change * 2;
            if (this.barType == 2) {
                int in_depth_offset = (int)Math.round((double)this.depth3dPoint.x / (double)this.getSeriesCount() * (1.0 - this.barWidthFraction) * 0.5);
                lineBounds.x -= in_depth_offset;
                lineBounds.width += in_depth_offset * 2;
            }
        }
        return lineBounds;
    }

    protected Point getSampleCenter(int sample, int serie) {
        Rectangle b;
        Rectangle bounds = new Rectangle(this.chart.getGraphBounds());
        if (this.display3dOn) {
            bounds.x -= this.depth3dPoint.x;
            bounds.y -= this.depth3dPoint.y;
        }
        if ((b = this.getBarBounds(serie, sample)) != null) {
            Point centerPoint;
            if (b.y < bounds.y) {
                b.height -= bounds.y - b.y + 1;
                b.y = bounds.y;
            }
            if (b.y + b.height > bounds.y + bounds.height) {
                b.height -= b.y + b.height - (bounds.y + bounds.height);
            }
            if (b.x + b.width > bounds.x + bounds.width) {
                b.width = bounds.x + bounds.width - b.x;
            }
            if (b.x < bounds.x) {
                b.width -= bounds.x - b.x + 2;
                b.x = bounds.x;
            }
            if (bounds.contains(centerPoint = new Point(b.x + b.width / 2, b.y + b.height / 2))) {
                return centerPoint;
            }
        }
        return null;
    }

    Rectangle getBarBounds(int serie, int sample) {
        if (this.barBounds != null && serie >= 0 && sample >= 0 && serie < this.barBounds.length && sample < this.barBounds[serie].length) {
            return this.barBounds[serie][sample];
        }
        return null;
    }

    private Rectangle adjustGridForLabels(Rectangle gridBounds) {
        boolean valueLabelsOn = this.chart.isValueLabelsOn(0);
        boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
        boolean seriesLabelsOn = this.chart.isSeriesLabelsOn();
        int valueLabelStyle = this.chart.getValueLabelStyle();
        int sampleLabelStyle = this.chart.getSampleLabelStyle();
        int seriesLabelStyle = this.chart.getSeriesLabelStyle();
        boolean adjust = valueLabelsOn && valueLabelStyle == 1;
        adjust |= sampleLabelsOn && sampleLabelStyle == 1;
        if (!(adjust |= seriesLabelsOn && seriesLabelStyle == 1)) {
            return gridBounds;
        }
        Rectangle newGrid = new Rectangle(gridBounds);
        int angle = 0;
        Font font = this.getFont("seriesLabelFont");
        if (valueLabelStyle == 1 && valueLabelsOn) {
            angle = this.getLabelAngle("valueLabelAngle");
            font = this.getFont("valueLabelFont");
        }
        if (sampleLabelStyle == 1 && sampleLabelsOn) {
            angle = this.getLabelAngle("sampleLabelAngle");
            font = this.getFont("sampleLabelFont");
        }
        FontMetrics fm = this.getFontMetrics(font);
        int seriesCount = this.getSeriesCount();
        int sampleCount = this.getSampleCount();
        int topAdjust = 0;
        int bottomAdjust = 0;
        double highest = 0.0;
        double lowest = 0.0;
        for (int series = 0; series < seriesCount; ++series) {
            for (int sample = 0; sample < sampleCount; ++sample) {
                String label = this.chart.constructLabel(series, sample, 1, seriesLabelsOn, null);
                if (this.barType == 1) {
                    double value = this.chart.getSampleValue(series, sample);
                    String valueLabel = this.chart.formatSeriesNumber(0, value);
                    String prefix = this.getLabel("valueLabelPrefix");
                    String postfix = this.getLabel("valueLabelPostfix");
                    valueLabel = prefix != null ? prefix + valueLabel : valueLabel;
                    valueLabel = postfix != null ? valueLabel + postfix : valueLabel;
                    String sampleLabel = "";
                    if (sampleLabelsOn && sampleLabelStyle == 1 && (sampleLabel = this.chart.getSampleLabel(sample)) != null && !sampleLabel.endsWith("\n") && valueLabel != null && valueLabelStyle == 1) {
                        sampleLabel = sampleLabel + " : ";
                    }
                    label = valueLabelStyle == 1 ? sampleLabel + valueLabel : sampleLabel;
                }
                Dimension labelSize = this.getLabelSize(label, fm);
                Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                double next = this.chart.getSampleValue(series, sample);
                if (next == highest) {
                    topAdjust = this.gridAlignment == 1 ? Math.max(topAdjust, angledSize.height) : Math.max(topAdjust, fm.stringWidth(label));
                }
                double upperRange = this.chart.getRange(0);
                double lowerRange = this.chart.getLowerRange(0);
                if (next > highest && upperRange > lowerRange || next < highest && upperRange < lowerRange) {
                    highest = next;
                    topAdjust = this.gridAlignment == 1 ? angledSize.height : fm.stringWidth(label);
                }
                if (!(next < lowest && upperRange > lowerRange) && (!(next > lowest) || !(upperRange < lowerRange))) continue;
                lowest = next;
                bottomAdjust = this.gridAlignment == 1 ? angledSize.height : fm.stringWidth(label);
            }
        }
        if (angle % 180 == 0 && this.gridAlignment == 1 && bottomAdjust > 0) {
            bottomAdjust -= fm.getDescent();
        }
        if (this.gridAlignment == 1) {
            newGrid.y += topAdjust;
            newGrid.height -= topAdjust + bottomAdjust;
        } else {
            newGrid.x += bottomAdjust;
            newGrid.width -= topAdjust + bottomAdjust;
        }
        return newGrid;
    }

    protected void calculateGraphBounds(Rectangle gridBounds) {
        int angle;
        Font font;
        String[] labels;
        int bottom;
        int top;
        int right;
        int left;
        Dimension size;
        block20: {
            block19: {
                this.legendRenderer.calculateGraphBounds(this.legend, gridBounds);
                this.gridAlignment = this.chart.getGridAlignment();
                this.barType = this.chart.getBarType();
                this.display3dOn = this.chart.is3DModeOn();
                this.barWidthFraction = this.chart.getBarWidth();
                size = this.chart.getSize();
                left = gridBounds.x;
                right = size.width - gridBounds.width - gridBounds.x;
                top = gridBounds.y;
                bottom = size.height - gridBounds.height - gridBounds.y;
                labels = null;
                font = this.getFont("sampleLabelFont");
                angle = this.getLabelAngle("sampleLabelAngle");
                if (!this.isAnyBelowLabelsOn()) break block19;
                labels = this.chart.getSampleLabels();
                if (!this.chart.isBarLabelsOn()) break block20;
                font = this.getFont("barLabelFont");
                angle = this.getLabelAngle("barLabelAngle");
                labels = this.chart.getBarLabels();
                break block20;
            }
            for (int i = 0; i < this.overlayRenderers.size(); ++i) {
                ChartRenderer overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (overlay == null || !(overlay.chart instanceof Chart) || !overlay.isAnyBelowLabelsOn()) continue;
                font = overlay.getFont("sampleLabelFont");
                angle = overlay.getLabelAngle("sampleLabelAngle");
                labels = ((Chart)overlay.chart).getSampleLabels();
                if (!(overlay instanceof BarChartRenderer) || !((BarChart)overlay.chart).isBarLabelsOn()) break;
                font = overlay.getFont("barLabelFont");
                angle = overlay.getLabelAngle("barLabelAngle");
                labels = ((BarChart)overlay.chart).getBarLabels();
                break;
            }
        }
        if (labels != null) {
            Dimension angledSize;
            Dimension labelSize;
            int i;
            FontMetrics fm = this.getFontMetrics(font);
            if (this.gridAlignment == 1) {
                int height = 0;
                for (i = 0; i < labels.length; ++i) {
                    labelSize = this.getLabelSize(labels[i], fm);
                    angledSize = this.getAngledLabelSize(labelSize, angle);
                    height = Math.max(angledSize.height, height);
                }
                int bottom_offset = height;
                if (angle % 180 == 0) {
                    bottom_offset -= fm.getMaxDescent();
                }
                bottom += bottom_offset;
            } else {
                int widest = 0;
                for (i = 0; i < labels.length; ++i) {
                    labelSize = this.getLabelSize(labels[i], fm);
                    angledSize = this.getAngledLabelSize(labelSize, angle);
                    widest = Math.max(widest, angledSize.width);
                }
                left += widest;
            }
        }
        Rectangle newGrid = new Rectangle(left, top, size.width - left - right, size.height - top - bottom);
        newGrid = this.adjustGridForLabels(newGrid);
        left = newGrid.x;
        right = size.width - newGrid.width - newGrid.x;
        top = newGrid.y;
        bottom = size.height - newGrid.height - newGrid.y;
        int sampleCount = this.chart.getSampleCount();
        int seriesCount = this.chart.getSeriesCount();
        if (this.display3dOn && sampleCount > 0 && seriesCount > 0) {
            double barWidth;
            if (this.chart.depth3d >= 0) {
                this.depth3dPoint.x = Math.round((float)this.chart.depth3d * 1.25f);
                this.depth3dPoint.y = Math.round((float)(-this.chart.depth3d) / 1.25f);
            } else if (this.parentRenderer != null) {
                if (this.parentRenderer instanceof BarChartRenderer || this.parentRenderer instanceof LineChartRenderer) {
                    this.depth3dPoint.x = this.parentRenderer.depth3dPoint.x / this.parentRenderer.getSeriesCount();
                    this.depth3dPoint.y = this.parentRenderer.depth3dPoint.y / this.parentRenderer.getSeriesCount();
                }
            } else if (this.gridAlignment == 1) {
                double sampleWidth = (double)gridBounds.width / (double)sampleCount;
                barWidth = sampleWidth * this.barWidthFraction;
                if (this.barType == 0) {
                    barWidth /= (double)seriesCount;
                }
                this.depth3dPoint.x = (int)Math.round(barWidth * 1.25);
                this.depth3dPoint.y = (int)Math.round(-barWidth / 1.25);
            } else {
                double sampleWidth = (double)gridBounds.height / (double)sampleCount;
                barWidth = sampleWidth * this.barWidthFraction;
                if (this.barType == 0) {
                    barWidth /= (double)seriesCount;
                }
                this.depth3dPoint.x = (int)Math.round(barWidth * 1.25 * 0.75);
                this.depth3dPoint.y = (int)Math.round(-(barWidth / 1.25 * 0.75));
            }
            left += this.depth3dPoint.x;
            bottom -= this.depth3dPoint.y;
        }
        for (int i = 0; i < this.overlayRenderers.size(); ++i) {
            ChartRenderer overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
            if (overlay == null || !(overlay.chart instanceof Chart)) continue;
            if (this.barType == 2) {
                overlay.depth3dPoint.x = this.depth3dPoint.x / seriesCount;
                overlay.depth3dPoint.y = this.depth3dPoint.y / seriesCount;
                continue;
            }
            overlay.depth3dPoint.x = this.depth3dPoint.x;
            overlay.depth3dPoint.y = this.depth3dPoint.y;
        }
        gridBounds.x = left;
        gridBounds.width = size.width - left - right;
        gridBounds.y = top;
        gridBounds.height = size.height - top - bottom;
        this.gridRenderer.calculateGraphBounds(this.chart.getGrid(), gridBounds);
    }

    protected void paintFloatingLabel(Graphics g, String label, Rectangle gridBounds, int sample, int series, Font font, FontMetrics fm) {
        if (label == null || series < 0 || series >= this.getSeriesCount() || sample < 0 || sample >= this.getSampleCount() || fm == null) {
            return;
        }
        Rectangle bar = this.barBounds[series][sample];
        if (bar == null) {
            return;
        }
        if (this.gridAlignment == 1) {
            if (bar.x + bar.width < gridBounds.x - (this.display3dOn ? this.depth3dPoint.x : 0) || bar.x > gridBounds.x + gridBounds.width) {
                return;
            }
            if (bar.y + bar.height < gridBounds.y || bar.y > gridBounds.y + gridBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0)) {
                return;
            }
        } else {
            if (bar.y + bar.height < gridBounds.y || bar.y > gridBounds.y + gridBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0)) {
                return;
            }
            if (bar.x + bar.width < gridBounds.x - (this.display3dOn ? this.depth3dPoint.x : 0) || bar.x > gridBounds.x + gridBounds.width) {
                return;
            }
        }
        Dimension labelSize = this.getLabelSize(label, this.getFontMetrics(font));
        int label_x = this.gridAlignment == 1 ? bar.x + bar.width / 2 - labelSize.width / 2 + 1 : (this.mousePosition.x < 0 ? bar.x + bar.width / 2 - labelSize.width / 2 : this.mousePosition.x - labelSize.width / 2);
        int label_y = this.mousePosition.y - labelSize.height + fm.getAscent();
        if (this.gridAlignment == 0 || this.mousePosition.y < 0) {
            label_y = bar.y + bar.height / 2 - labelSize.height / 2 + fm.getAscent();
        }
        if (this.barType == 1 && label_y - labelSize.height / 2 < bar.y) {
            label_y = bar.y + labelSize.height / 2 + 1;
        } else if (this.display3dOn && this.depth3dPoint.y != 0 && this.gridAlignment == 1 && this.mousePosition.y < bar.y && this.mousePosition.y >= 0) {
            label_x += -this.depth3dPoint.x * (bar.y - this.mousePosition.y) / this.depth3dPoint.y;
            Rectangle nextBarBounds = null;
            if (series < this.getSeriesCount() - 1) {
                nextBarBounds = this.barBounds[series + 1][sample];
            } else if (sample < this.getSampleCount() - 1) {
                nextBarBounds = this.barBounds[0][sample + 1];
            }
            if (nextBarBounds != null) {
                int offset = (int)((double)(-this.depth3dPoint.x) * (double)(nextBarBounds.y - this.mousePosition.y) / (double)this.depth3dPoint.y);
                if (label_y >= nextBarBounds.y && label_x > nextBarBounds.x - 10) {
                    label_x = nextBarBounds.x - 10;
                } else if (label_y < nextBarBounds.y && label_x > nextBarBounds.x + offset - 10) {
                    label_x = nextBarBounds.x + offset - 10;
                }
            }
        }
        Color frameColor = this.chart.getChartForeground();
        if (this.getSeriesCount() == 1 && this.chart.isMultiColorOn()) {
            frameColor = BarChartRenderer.getDarker(this.chart.getSampleColor(sample));
        } else if (this.chart.isMultiColorOn()) {
            frameColor = BarChartRenderer.getDarker(this.chart.getSampleColor(series));
        }
        this.paintFloatingLabel(g, label, label_x, label_y, labelSize, frameColor, fm);
    }

    protected boolean isAnyFloatingLabelsOn(int serie) {
        int valueLabelStyle = this.chart.getValueLabelStyle();
        int sampleLabelStyle = this.chart.getSampleLabelStyle();
        int seriesLabelStyle = this.chart.getSeriesLabelStyle();
        boolean valueLabelsOn = this.chart.isValueLabelsOn(serie);
        boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
        boolean seriesLabelsOn = this.chart.isSeriesLabelsOn();
        boolean labels_on = valueLabelsOn && valueLabelStyle == 3;
        labels_on |= sampleLabelsOn && (sampleLabelStyle == 3 || sampleLabelStyle == 4);
        return labels_on |= seriesLabelsOn && seriesLabelStyle == 3;
    }

    protected boolean isAnyBelowLabelsOn() {
        int sampleLabelStyle = this.chart.getSampleLabelStyle();
        boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
        boolean labels_on = sampleLabelsOn && (sampleLabelStyle == 2 || sampleLabelStyle == 4);
        return labels_on |= this.chart.isBarLabelsOn();
    }
}

