/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import com.objectplanet.image.GrayScaleEncoder;
import java.awt.image.ColorModel;
import java.io.IOException;

public class GrayScaleAlphaEncoder
extends GrayScaleEncoder {
    GrayScaleAlphaEncoder(int compression) {
        super(compression);
        this.colorType = 4;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == null || pixels == null) {
            return;
        }
        if (this.pngPixels == null || this.pngPixels.length < scansize * 2 + 1) {
            this.pngPixels = new byte[scansize * 4 + 1];
        }
        int rows = pixels.length / scansize;
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            this.pngPixels[0] = 0;
            int p = 1;
            for (int i = 0; i < scansize; ++i) {
                int alpha = pixels[index] >> 24 & 0xFF;
                int red = pixels[index] >> 16 & 0xFF;
                int green = pixels[index] >> 8 & 0xFF;
                int blue = pixels[index] & 0xFF;
                if (red != green || red != blue) {
                    int gray = (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
                    this.pngPixels[p] = (byte)gray;
                } else {
                    this.pngPixels[p] = (byte)red;
                }
                this.pngPixels[p + 2] = (byte)(alpha % 256);
                this.pngPixels[p + 3] = (byte)(alpha / 256);
                p += 4;
                ++index;
            }
            try {
                this.deflaterOut.write(this.pngPixels, 0, scansize * 4 + 1);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

