/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class MockClob
implements Clob,
Cloneable {
    private StringBuffer clobData;
    private boolean wasFreeCalled;

    public MockClob(String string) {
        this.clobData = new StringBuffer(string);
        this.wasFreeCalled = false;
    }

    public long length() throws SQLException {
        return this.clobData.length();
    }

    public void truncate(long l) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        this.clobData.setLength((int)l);
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        try {
            return new ByteArrayInputStream(this.clobData.toString().getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NestedApplicationException(unsupportedEncodingException);
        }
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return new ClobOutputStream((int)(l - 1L));
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return new StringReader(this.clobData.toString());
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        l2 = this.verifyAndFixLength(l, (int)l2);
        return new StringReader(this.getSubString(l, (int)l2));
    }

    public Writer setCharacterStream(long l) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return new ClobWriter((int)(l - 1L));
    }

    public String getSubString(long l, int n) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        n = this.verifyAndFixLength(l, n);
        return this.clobData.substring((int)(l - 1L), (int)(l - 1L) + n);
    }

    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        string = string.substring(n, n + n2);
        this.clobData.replace((int)(l - 1L), (int)(l - 1L) + string.length(), string);
        return n2;
    }

    public long position(String string, long l) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        int n = this.clobData.toString().indexOf(string, (int)(l - 1L));
        if (-1 != n) {
            ++n;
        }
        return n;
    }

    public long position(Clob clob, long l) throws SQLException {
        return this.position(clob.getSubString(1L, (int)clob.length()), l);
    }

    public void free() throws SQLException {
        this.wasFreeCalled = true;
    }

    public boolean wasFreeCalled() {
        return this.wasFreeCalled;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        MockClob mockClob = (MockClob)object;
        if (this.wasFreeCalled != mockClob.wasFreeCalled()) {
            return false;
        }
        return this.clobData.toString().equals(mockClob.clobData.toString());
    }

    public int hashCode() {
        int n = this.clobData.toString().hashCode();
        n = 31 * n + (this.wasFreeCalled ? 31 : 62);
        return n;
    }

    public String toString() {
        return "Clob data: " + this.clobData.toString();
    }

    public Object clone() {
        try {
            MockClob mockClob = (MockClob)super.clone();
            mockClob.clobData = new StringBuffer(this.clobData.toString());
            return mockClob;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NestedApplicationException(cloneNotSupportedException);
        }
    }

    private int verifyAndFixLength(long l, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length must be greater or equals 0");
        }
        if ((long)n + (l - 1L) > (long)this.clobData.length()) {
            return this.clobData.length() - (int)(l - 1L);
        }
        return n;
    }

    private class ClobOutputStream
    extends OutputStream {
        private int index;

        public ClobOutputStream(int n) {
            this.index = n;
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            try {
                MockClob.this.setString(this.index + 1, new String(byArray));
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            ++this.index;
        }
    }

    private class ClobWriter
    extends Writer {
        private int index;

        public ClobWriter(int n) {
            this.index = n;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            try {
                MockClob.this.setString(this.index + 1, new String(cArray, n, n2));
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            ++this.index;
        }
    }
}

