/*
 * Decompiled with CFR 0.152.
 */
package eGTTIntegration;

import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.EgSSL;
import com.eg.EgTablesInfo;
import com.eg.IniFile;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import com.egurkha.ini.IniUI;
import com.egurkha.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eGTTIntegration.TTIntegrationWrapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class TOPdeskIntegrator
extends TTIntegrationWrapper {
    private String TitleFormat = "";
    private String DescriptionFormat = "";
    private String url = "";
    private String username = "";
    private String applicationPassword = "";
    private String criticalPriorityId = "";
    private String majorPriorityId = "";
    private String minorPriorityId = "";
    private String normalPriorityId = "";
    private String resolvedTicketStatusId = "";
    private String openTicketStatusId = "";
    private String callerId = "";
    private String operatorId = "";
    private String categoryId = "";
    private String subCategoryId = "";
    private String callTypeId = "";
    private String entryTypeId = "";
    private String operatorGroup = "";
    private boolean enableDetailedLog = false;
    private boolean enableResponseJsonLog = false;
    private EgTablesInfo tablesInfo = new EgTablesInfo("manager");
    private Gson gson = null;
    private EgMappingInfo mappingInfo = null;
    private String thisLanguage = "";
    private IniFile servicesIni = null;
    public String fileSeparator = System.getProperty("file.separator");
    private String servicesFile = "";
    private String DefaultDescFormat = "Priority :$prior<br>Component Type : $ctype<br>Component Name : $cname<br>Layer : $layer<br>Problem description : $pdesc<br>Problem Start Time : $starttime<br>Service : $service";
    private String DefaultTitleFormat = "$prior - $ctype / $cname - $pdesc";
    private int MAX_TITLE_SIZE = 80;
    private int CONNECTION_TIMEOUT_MS = 30000;
    private int MAX_DESC_SIZE = 1024;
    private String subject = "TT_COMMON_SETTINGS";
    private String summaryMaxCharLength = "summaryMaxCharLength";
    private String problemDescriptionMaxCharLength = "problemDescriptionMaxCharLength";
    private Hashtable callBranchIdMap = new Hashtable();
    private String fieldsRequiredForTopdesk = "";
    private ArrayList topDeskFieldsList = null;
    private String impactValueForCritical = "";
    private String impactValueForMajor = "";
    private String impactValueForMinor = "";
    private String urgencyValueForCritical = "";
    private String urgencyValueForMajor = "";
    private String urgencyValueForMinor = "";
    private boolean isCallerBranchRequired = false;
    private String ticketStatus = "";
    private Hashtable impactTypeList = null;
    private Hashtable urgencyList = null;
    boolean isImpactRequired = false;
    boolean isUrgencyRequired = false;

    public TOPdeskIntegrator(Hashtable hashtable) {
        try {
            this.TitleFormat = "";
            this.DescriptionFormat = "";
            this.url = "";
            this.username = "";
            this.applicationPassword = "";
            this.criticalPriorityId = "";
            this.majorPriorityId = "";
            this.minorPriorityId = "";
            this.normalPriorityId = "";
            this.resolvedTicketStatusId = "";
            this.openTicketStatusId = "";
            this.callerId = "";
            this.operatorId = "";
            this.categoryId = "";
            this.subCategoryId = "";
            this.callTypeId = "";
            this.entryTypeId = "";
            this.ticketStatus = "";
            this.enableDetailedLog = false;
            this.enableResponseJsonLog = false;
            IniUI iniUI = IniUI.getInstance();
            this.thisLanguage = iniUI.getDefaultLanguage();
            this.mappingInfo = new EgMappingInfo(this.thisLanguage);
            this.servicesFile = EgInstallInfo.getInstallDir() + this.fileSeparator + "manager" + this.fileSeparator + "config" + this.fileSeparator + "eg_services.ini";
            this.servicesIni = new IniFile(this.servicesFile);
            this.gson = new GsonBuilder().setPrettyPrinting().create();
            this.updateInitParams(hashtable);
        }
        catch (Throwable throwable) {
            System.out.println("Error: Exception in updateInitParams() method -TOPdeskIntegrator.java|Details::" + throwable);
            throwable.printStackTrace();
        }
    }

    public void updateInitParams(Hashtable hashtable) {
        if (hashtable != null) {
            String string;
            String string2;
            if (hashtable.get("enableDetailedLog") != null) {
                string2 = (String)hashtable.get("enableDetailedLog");
                this.enableDetailedLog = string2.equalsIgnoreCase("true");
            }
            if (hashtable.get("enableResponseJsonLog") != null) {
                string2 = (String)hashtable.get("enableResponseJsonLog");
                this.enableResponseJsonLog = string2.equalsIgnoreCase("true");
            }
            if (this.timeoutVal != null && !this.timeoutVal.equals("")) {
                try {
                    int n = Integer.parseInt(this.timeoutVal);
                    this.CONNECTION_TIMEOUT_MS = n * 1000;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            String string3 = this.servicesIni.getValue(this.subject, this.summaryMaxCharLength);
            String string4 = this.servicesIni.getValue(this.subject, this.problemDescriptionMaxCharLength);
            if (string3 == null || string3.length() == 0) {
                string3 = "80";
            }
            if (string4 == null || string4.length() == 0) {
                string4 = "1024";
            }
            try {
                this.MAX_TITLE_SIZE = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.MAX_TITLE_SIZE = 80;
            }
            try {
                this.MAX_DESC_SIZE = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                this.MAX_DESC_SIZE = 1024;
            }
            if (hashtable.get("fieldsRequiredForTopdesk") != null) {
                this.fieldsRequiredForTopdesk = (String)hashtable.get("fieldsRequiredForTopdesk");
            }
            this.topDeskFieldsList = new ArrayList();
            if (StringUtils.isNull((String)this.fieldsRequiredForTopdesk)) {
                this.fieldsRequiredForTopdesk = "personSurname,operatorSurname,priority,status,category,subcategory,call_type,entry_type,callerBranch";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.fieldsRequiredForTopdesk, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                this.topDeskFieldsList.add(string);
            }
            if (hashtable.get("url") != null) {
                this.url = (String)hashtable.get("url");
            }
            if (hashtable.get("user") != null) {
                this.username = (String)hashtable.get("user");
            }
            if (hashtable.get("password") != null) {
                this.applicationPassword = (String)hashtable.get("password");
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("personSurname") && hashtable.get("personSurname") != null) {
                string = (String)hashtable.get("personSurname");
                this.callerId = this.getUserId(string, "person");
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("operatorSurname") && hashtable.get("operatorSurname") != null) {
                string = (String)hashtable.get("operatorSurname");
                this.operatorId = this.getUserId(string, "operator");
            }
            if (hashtable.get("TitleFormat") != null) {
                this.TitleFormat = (String)hashtable.get("TitleFormat");
            }
            if (hashtable.get("DescriptionFormat") != null) {
                this.DescriptionFormat = (String)hashtable.get("DescriptionFormat");
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("priority") && hashtable.get("priority") != null) {
                string = (String)hashtable.get("priority");
                this.extractPriority(string);
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("status") && hashtable.get("status") != null) {
                string = (String)hashtable.get("status");
                this.extractStatus(string);
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("category") && hashtable.get("category") != null) {
                string = (String)hashtable.get("category");
                this.extractCategory(string);
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("subCategory") && hashtable.get("subCategory") != null) {
                string = (String)hashtable.get("subCategory");
                this.extractSubCategory(string);
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("call_type") && hashtable.get("call_type") != null) {
                string = (String)hashtable.get("call_type");
                this.extractCallType(string);
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("entry_type") && hashtable.get("entry_type") != null) {
                string = (String)hashtable.get("entry_type");
                this.extractEntryType(string);
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("callerBranch")) {
                this.isCallerBranchRequired = true;
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("impact")) {
                this.isImpactRequired = true;
                this.getIdForAllImpacts();
                if (hashtable != null) {
                    this.impactValueForCritical = (String)hashtable.get("impactValueForCritical");
                    this.impactValueForMajor = (String)hashtable.get("impactValueForMajor");
                    this.impactValueForMinor = (String)hashtable.get("impactValueForMinor");
                }
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("urgency")) {
                this.isUrgencyRequired = true;
                this.getIdForAllUrgency();
                if (hashtable != null) {
                    this.urgencyValueForCritical = (String)hashtable.get("urgencyValueForCritical");
                    this.urgencyValueForMajor = (String)hashtable.get("urgencyValueForMajor");
                    this.urgencyValueForMinor = (String)hashtable.get("urgencyValueForMinor");
                }
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("operatorGroup")) {
                string = (String)hashtable.get("operatorGroup");
                this.operatorGroup = this.getUserId(string, "operatorgroups");
            }
            if (this.topDeskFieldsList != null && this.topDeskFieldsList.contains("ticketStatus")) {
                this.ticketStatus = (String)hashtable.get("ticketStatus");
            }
        }
    }

    public void extractCategory(String string) {
        if (!StringUtils.isNull((String)string)) {
            Hashtable hashtable = this.getList("category");
            string = string.toLowerCase();
            if (hashtable != null && hashtable.get(string) != null) {
                this.categoryId = hashtable.get(string).toString();
                if (this.enableDetailedLog) {
                    System.out.println("INFO: categoryId :: " + this.categoryId);
                }
            }
        }
    }

    public void extractSubCategory(String string) {
        if (!StringUtils.isNull((String)string)) {
            Hashtable hashtable = this.getList("subCategory");
            string = string.toLowerCase();
            if (hashtable != null && hashtable.get(string) != null) {
                this.subCategoryId = hashtable.get(string).toString();
                if (this.enableDetailedLog) {
                    System.out.println("INFO: subCategoryId :: " + this.subCategoryId);
                }
            }
        }
    }

    public void extractCallType(String string) {
        if (!StringUtils.isNull((String)string)) {
            Hashtable hashtable = this.getList("call_types");
            string = string.toLowerCase();
            if (hashtable != null && hashtable.get(string) != null) {
                this.callTypeId = hashtable.get(string).toString();
                if (this.enableDetailedLog) {
                    System.out.println("INFO: callTypeId :: " + this.callTypeId);
                }
            }
        }
    }

    public void extractEntryType(String string) {
        if (!StringUtils.isNull((String)string)) {
            Hashtable hashtable = this.getList("entry_types");
            string = string.toLowerCase();
            if (hashtable != null && hashtable.get(string) != null) {
                this.entryTypeId = hashtable.get(string).toString();
                if (this.enableDetailedLog) {
                    System.out.println("INFO: entryTypeId :: " + this.entryTypeId);
                }
            }
        }
    }

    public void getIdForAllImpacts() {
        this.impactTypeList = this.getList("impact");
        if (this.enableDetailedLog) {
            System.out.println("INFO: impactTypeList :: " + this.impactTypeList);
        }
    }

    public void getIdForAllUrgency() {
        this.urgencyList = this.getList("urgency");
        if (this.enableDetailedLog) {
            System.out.println("INFO: urgencyList :: " + this.urgencyList);
        }
    }

    public void extractOperatorGroup(String string) {
        if (!StringUtils.isNull((String)string)) {
            Hashtable hashtable = this.getList("operatorGroup");
            string = string.toLowerCase();
            if (hashtable != null && hashtable.get(string) != null) {
                this.operatorGroup = hashtable.get(string).toString();
                if (this.enableDetailedLog) {
                    System.out.println("INFO: operatorGroup :: " + string);
                }
            }
        }
    }

    public void getCallerBranchIdMap() {
        try {
            int n;
            String[] stringArray = this.servicesIni.getVariables("TOPDESK_ZONE_MAPPING");
            if (stringArray != null && (n = stringArray.length) > 0) {
                Hashtable hashtable = new Hashtable();
                hashtable = this.getList("callerBranch");
                System.out.println("callBranchMap---->" + hashtable);
                for (int i = 0; i < n; ++i) {
                    String string;
                    String string2 = stringArray[i];
                    String string3 = this.servicesIni.getValue("TOPDESK_ZONE_MAPPING", string2);
                    if (StringUtils.isNull((String)string3) || StringUtils.isNull((String)(string = (String)hashtable.get(string3.toLowerCase())))) continue;
                    this.callBranchIdMap.put(string2, string);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void extractPriority(String string) {
        if (!StringUtils.isNull((String)string)) {
            Hashtable hashtable = this.getList("priority");
            if (string.indexOf("#") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
                ArrayList<String> arrayList = null;
                String string2 = "";
                StringTokenizer stringTokenizer2 = null;
                String string3 = "";
                String string4 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (!StringUtils.isNull((String)string2) && string2.indexOf(":") > 0) {
                        stringTokenizer2 = new StringTokenizer(string2, ":");
                        arrayList = new ArrayList<String>();
                        while (stringTokenizer2.hasMoreTokens()) {
                            arrayList.add(stringTokenizer2.nextToken());
                        }
                        if (arrayList.isEmpty() || arrayList.size() != 2) continue;
                        string3 = arrayList.get(1).toString();
                        string4 = arrayList.get(0).toString().toLowerCase();
                        if (string3.equalsIgnoreCase("critical")) {
                            if (hashtable == null || hashtable.get(string4) == null) continue;
                            this.criticalPriorityId = hashtable.get(string4).toString();
                            if (!this.enableDetailedLog) continue;
                            System.out.println("INFO: criticalPriorityId :: " + this.criticalPriorityId);
                            continue;
                        }
                        if (string3.equalsIgnoreCase("major")) {
                            if (hashtable == null || hashtable.get(string4) == null) continue;
                            this.majorPriorityId = hashtable.get(string4).toString();
                            if (!this.enableDetailedLog) continue;
                            System.out.println("INFO: majorPriorityId :: " + this.majorPriorityId);
                            continue;
                        }
                        if (string3.equalsIgnoreCase("minor")) {
                            if (hashtable == null || hashtable.get(string4) == null) continue;
                            this.minorPriorityId = hashtable.get(string4).toString();
                            if (!this.enableDetailedLog) continue;
                            System.out.println("INFO: minorPriorityId :: " + this.minorPriorityId);
                            continue;
                        }
                        if (!string3.equalsIgnoreCase("normal") || hashtable == null || hashtable.get(string4) == null) continue;
                        this.normalPriorityId = hashtable.get(string4).toString();
                        if (!this.enableDetailedLog) continue;
                        System.out.println("INFO: normalPriorityId :: " + this.normalPriorityId);
                        continue;
                    }
                    System.out.println("Warning: Ticket Priority Configuration is invalid. It must be in this format(priority=$Name:Critical#$Name:Major#$Name:Minor#$Name:Normal)");
                }
            } else {
                System.out.println("Warning: Ticket Priority Configuration is invalid. It must be in this format(priority=$Name:Critical#$Name:Major#$Name:Minor#$Name:Normal)");
            }
        } else {
            System.out.println("Warning: Ticket Priority Configuration is empty");
        }
    }

    public Hashtable getList(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Object[] objectArray = new Object[5];
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        String string2 = "";
        string2 = this.url;
        if (!StringUtils.isNull((String)string) && string.equalsIgnoreCase("priority")) {
            string2 = string2 + "/tas/api/incidents/priorities";
        } else if (!StringUtils.isNull((String)string) && string.equalsIgnoreCase("status")) {
            string2 = string2 + "/tas/api/incidents/statuses";
        } else if (!StringUtils.isNull((String)string) && string.equalsIgnoreCase("category")) {
            string2 = string2 + "/tas/api/incidents/categories";
        } else if (!StringUtils.isNull((String)string) && string.equalsIgnoreCase("subCategory")) {
            string2 = string2 + "/tas/api/incidents/subcategories";
        } else if (!StringUtils.isNull((String)string) && string.equalsIgnoreCase("call_types")) {
            string2 = string2 + "/tas/api/incidents/call_types";
        } else if (!StringUtils.isNull((String)string) && string.equalsIgnoreCase("entry_types")) {
            string2 = string2 + "/tas/api/incidents/entry_types";
        } else if (!StringUtils.isNull((String)string) && string.equalsIgnoreCase("callerBranch")) {
            string2 = string2 + "/tas/api/branches";
        } else if (!StringUtils.isNull((String)string) && string.equalsIgnoreCase("impact")) {
            string2 = string2 + "/tas/api/incidents/impacts";
        } else if (!StringUtils.isNull((String)string) && string.equalsIgnoreCase("urgency")) {
            string2 = string2 + "/tas/api/incidents/urgencies";
        }
        if (this.enableDetailedLog) {
            System.out.println("Request Url for retriving " + string + " available in TOPdesk : " + string2);
        }
        Hashtable hashtable2 = this.connect(string2, "get", objectArray);
        int n = 0;
        try {
            if (hashtable2 != null && hashtable2.get("statusCode") != null) {
                n = Integer.parseInt(hashtable2.get("statusCode").toString());
            }
        }
        catch (Exception exception) {
            System.out.println("Status code is empty |Exception: " + exception);
        }
        String string3 = "";
        if (hashtable2 != null && hashtable2.get("resData") != null) {
            string3 = hashtable2.get("resData").toString();
        }
        if (this.enableDetailedLog) {
            System.out.println("Status Code of the response:" + n);
            if (!StringUtils.isNull((String)string3) && string3.startsWith("[") && this.enableResponseJsonLog) {
                System.out.println("Response JSON Data Received for retriving " + string + " available in TOPdesk :\n" + this.gson.toJson((Object)JSONArray.fromObject((Object)string3)));
            }
        }
        if (!(n != 201 && n != 200 || StringUtils.isNull((String)string3))) {
            if (string3.startsWith("[")) {
                jSONArray = JSONArray.fromObject((Object)string3);
            }
            if (jSONArray != null) {
                int n2 = jSONArray.size();
                String string4 = "";
                String string5 = "";
                try {
                    for (int i = 0; i < n2; ++i) {
                        jSONObject = jSONArray.getJSONObject(i);
                        String string6 = (String)jSONObject.get("name");
                        string4 = new String(string6.getBytes("UTF-8"), StandardCharsets.UTF_8);
                        if (string4 != null) {
                            string4 = string4.trim();
                            hashtable.put(string4, string5);
                            string4 = string4.toLowerCase();
                        }
                        string5 = jSONObject.get("id").toString();
                        hashtable.put(string4, string5);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (this.enableDetailedLog) {
                    System.out.println("INFO: " + string + " available in TOPdesk is successfully retrieved...");
                }
            } else if (this.enableDetailedLog) {
                System.out.println("Error: Failed to retrieve " + string + " available in TOPdesk| URL: " + string2);
            }
        }
        return hashtable;
    }

    public void extractStatus(String string) {
        Hashtable hashtable = this.getList("status");
        if (!StringUtils.isNull((String)string)) {
            if (string.indexOf("#") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
                StringTokenizer stringTokenizer2 = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                String string2 = "";
                String string3 = "";
                String string4 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (!StringUtils.isNull((String)string2) && string2.indexOf(":") > 0) {
                        stringTokenizer2 = new StringTokenizer(string2, ":");
                        arrayList = new ArrayList();
                        while (stringTokenizer2.hasMoreTokens()) {
                            arrayList.add(stringTokenizer2.nextToken());
                        }
                        if (arrayList.isEmpty() || arrayList.size() != 2) continue;
                        string3 = arrayList.get(1).toString();
                        string4 = arrayList.get(0).toString().toLowerCase();
                        if (string3.equalsIgnoreCase("OpenTicket")) {
                            if (hashtable == null || hashtable.get(string4) == null) continue;
                            this.openTicketStatusId = hashtable.get(string4).toString();
                            if (!this.enableDetailedLog) continue;
                            System.out.println("INFO: openTicketStatusId :: " + this.openTicketStatusId);
                            continue;
                        }
                        if (!string3.equalsIgnoreCase("ResolvedTicket") || hashtable == null || hashtable.get(string4) == null) continue;
                        this.resolvedTicketStatusId = hashtable.get(string4).toString();
                        if (!this.enableDetailedLog) continue;
                        System.out.println("INFO: resolvedTicketStatusId :: " + this.resolvedTicketStatusId);
                        continue;
                    }
                    System.out.println("Warning: Ticket Status Configuration is invalid. It must be in this format(status=$Name:NewTicket#$Name:ResolvedTicket)");
                }
            } else {
                System.out.println("Warning: Ticket Status Configuration is invalid. It must be in this format(status=$Name:NewTicket#$Name:ResolvedTicket)");
            }
        } else {
            System.out.println("Error: Ticket Status Configuration is empty");
        }
    }

    public String getUserId(String string, String string2) {
        String string3 = "";
        String string4 = "";
        Object[] objectArray = new Object[5];
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        string4 = this.url;
        if (!StringUtils.isNull((String)string2) && string2.equalsIgnoreCase("person")) {
            string4 = string4 + "/tas/api/persons/lookup?name=" + string;
        } else if (!StringUtils.isNull((String)string2) && string2.equalsIgnoreCase("operator")) {
            string4 = string4 + "/tas/api/operators/lookup?name=" + string;
        } else if (!StringUtils.isNull((String)string2) && string2.equalsIgnoreCase("operatorgroups")) {
            string4 = string4 + "/tas/api/operatorgroups/lookup?name=" + string;
        }
        if (this.enableDetailedLog) {
            System.out.println("Request Url to get ID  of " + string2 + ": " + string4);
        }
        Hashtable hashtable = this.connect(string4, "get", objectArray);
        int n = 0;
        try {
            if (hashtable != null && hashtable.get("statusCode") != null) {
                n = Integer.parseInt(hashtable.get("statusCode").toString());
            }
        }
        catch (Exception exception) {
            System.out.println("Status code is empty |Exception: " + exception);
        }
        String string5 = "";
        if (hashtable != null && hashtable.get("resData") != null) {
            string5 = hashtable.get("resData").toString();
        }
        if (this.enableDetailedLog) {
            System.out.println("Status Code of the response:" + n);
            if (!StringUtils.isNull((String)string5) && string5.startsWith("{") && this.enableResponseJsonLog) {
                System.out.println("Response JSON Data Received for retriving id of " + string2 + ":\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)string5)));
            }
        }
        if (!(n != 201 && n != 200 || StringUtils.isNull((String)string5))) {
            if (string5.startsWith("{")) {
                jSONObject = JSONObject.fromObject((Object)string5);
            }
            if (jSONObject != null && jSONObject.get("results") != null) {
                jSONArray = (JSONArray)jSONObject.get("results");
                if (jSONArray != null && jSONArray.get(0) != null) {
                    jSONObject2 = (JSONObject)jSONArray.get(0);
                    string3 = jSONObject2.get("id").toString();
                    if (this.enableDetailedLog) {
                        System.out.println("INFO: ID of " + string2 + " is successfully retrieved...Details-> ID: " + string3);
                    }
                }
            } else if (this.enableDetailedLog) {
                System.out.println("Error: Failed to retrieve ID of " + string2 + "...| Details-> Surname of " + string2 + ": " + string + "| URL: " + string4);
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable connect(String string, String string2, Object[] objectArray) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        HttpResponse httpResponse = null;
        int n = string.indexOf(":");
        String string3 = "https";
        if (string != null && n > 0 && string.length() > n + 3) {
            string3 = string.substring(0, n);
        }
        if (string3 != null && string3.equalsIgnoreCase("https")) {
            this.doTheSSL();
        }
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        try {
            if (!StringUtils.isNull((String)this.username) && !StringUtils.isNull((String)this.applicationPassword)) {
                String string4;
                Object object;
                String string5 = this.username + ":" + this.applicationPassword;
                byte[] byArray = Base64.encodeBase64((byte[])string5.getBytes(Charset.forName("US-ASCII")));
                String string6 = "Basic " + new String(byArray);
                RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.CONNECTION_TIMEOUT_MS).setConnectTimeout(this.CONNECTION_TIMEOUT_MS).setSocketTimeout(this.CONNECTION_TIMEOUT_MS).build();
                HttpPost httpPost = null;
                HttpGet httpGet = null;
                HttpPut httpPut = null;
                if (!StringUtils.isNull((String)string2) && string2.equalsIgnoreCase("get")) {
                    object = "";
                    string4 = "";
                    if (!StringUtils.isNull((String)string) && string.indexOf("?") != -1) {
                        int n2 = string.indexOf("?");
                        int n3 = string.indexOf("=");
                        String string7 = string;
                        string = string.substring(0, n2);
                        object = string7.substring(n2 + 1, n3);
                        string4 = string7.substring(n3 + 1);
                    }
                    URIBuilder uRIBuilder = new URIBuilder(string);
                    if (!StringUtils.isNull((String)object) && !StringUtils.isNull((String)string4)) {
                        uRIBuilder.setParameter((String)object, string4);
                    }
                    httpGet = new HttpGet(uRIBuilder.build());
                    httpGet.setHeader("Authorization", string6);
                    httpGet.setConfig(requestConfig);
                    httpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
                } else if (!StringUtils.isNull((String)string2) && string2.equalsIgnoreCase("post")) {
                    httpPost = new HttpPost(string);
                    httpPost.setHeader("Authorization", string6);
                    httpPost.setConfig(requestConfig);
                    if (this.logEnabled && this.enableDetailedLog) {
                        this.sop("JSON Data Sent for create ticket:\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)this.getTicketData(objectArray, false))));
                    }
                    object = new StringEntity(this.getTicketData(objectArray, false));
                    object.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)object);
                    httpPost.setConfig(requestConfig);
                    httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
                } else if (!StringUtils.isNull((String)string2) && string2.equalsIgnoreCase("put")) {
                    string = this.replace(string, " ", "%20");
                    object = new URI(string);
                    string4 = new URIBuilder((URI)object);
                    httpPut = new HttpPut(string4.build());
                    httpPut.setHeader("Authorization", string6);
                    httpPut.setConfig(requestConfig);
                    StringEntity stringEntity = null;
                    if (this.logEnabled && this.enableDetailedLog) {
                        this.sop("JSON Data Sent for update ticket:\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)this.getTicketData(objectArray, true))));
                    }
                    stringEntity = new StringEntity(this.getTicketData(objectArray, true));
                    stringEntity.setContentType("application/json");
                    httpPut.setEntity((HttpEntity)stringEntity);
                    httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPut);
                }
                int n4 = httpResponse.getStatusLine().getStatusCode();
                string4 = this.getResponseData(httpResponse);
                hashtable.put("statusCode", n4);
                hashtable.put("resData", string4);
            }
            System.out.println("Error ->  Username/application password is not provided");
        }
        catch (Exception exception) {
            System.out.println("Error ->  Failed to send :" + string + " Reason :" + exception.toString());
        }
        finally {
            closeableHttpClient.getConnectionManager().shutdown();
            return hashtable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createTicket(Object[] objectArray) throws Exception {
        String string = "";
        String string2 = "";
        JSONObject jSONObject = new JSONObject();
        try {
            try {
                String string3 = (String)objectArray[1];
                if (StringUtils.isNull((String)string3)) {
                    string3 = "-";
                }
                if (!StringUtils.isNull((String)this.callerId)) {
                    String string4 = (String)objectArray[0];
                    String string5 = (String)objectArray[3];
                    String string6 = (String)objectArray[4];
                    String string7 = (String)objectArray[5];
                    Hashtable hashtable = this.getFormattedData(objectArray);
                    String string8 = "";
                    String string9 = "";
                    if (hashtable != null && hashtable.get("summary") != null) {
                        string8 = hashtable.get("summary").toString();
                    }
                    if (hashtable != null && hashtable.get("description") != null) {
                        string9 = hashtable.get("description").toString();
                        string9 = string9.replace("<br>", " ");
                    }
                    string2 = this.url;
                    string2 = string2 + "/tas/api/incidents";
                    try {
                        Hashtable hashtable2 = this.connect(string2, "post", objectArray);
                        int n = 0;
                        try {
                            if (hashtable2 != null && hashtable2.get("statusCode") != null) {
                                n = Integer.parseInt(hashtable2.get("statusCode").toString());
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("Status code is empty |Exception: " + exception);
                        }
                        String string10 = "";
                        if (hashtable2 != null && hashtable2.get("resData") != null) {
                            string10 = hashtable2.get("resData").toString();
                        }
                        if (this.logEnabled && this.enableDetailedLog) {
                            this.sop("Status Code of the response:" + n);
                            if (!StringUtils.isNull((String)string10) && string10.startsWith("{") && this.enableResponseJsonLog) {
                                this.sop("Response JSON Data Received for create Ticket request:\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)string10)));
                            }
                        }
                        if (n != 201 && n != 200) {
                            if (!this.logEnabled) return string;
                            this.sop("Error: Failed to create Ticket...|API URL: " + string2 + " Details-> Priority: " + string4 + " Component Type: " + string5 + " Component Name: " + string6 + " Layer: " + string7 + " Zone name :" + string3 + " Summary: " + string8 + " Description: " + string9);
                            if (StringUtils.isNull((String)string10)) return string;
                            if (!string10.startsWith("{")) return string;
                            this.sop("Response JSON Data Received for update Ticket request:\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)string10)));
                            return string;
                        }
                        if (!StringUtils.isNull((String)string10) && string10.startsWith("{")) {
                            jSONObject = JSONObject.fromObject((Object)string10);
                        }
                        if (jSONObject != null && jSONObject.get("number") != null) {
                            string = jSONObject.get("number").toString();
                            if (!this.logEnabled) return string;
                            this.sop("INFO: Ticket has been created successfully...Details-> Ticket Number: " + string + " Priority: " + string4 + " Component Type: " + string5 + " Component Name: " + string6 + " Layer: " + string7 + " Zone name :" + string3 + " Summary: " + string8 + " Description: " + string9);
                            return string;
                        }
                        if (!this.logEnabled) return string;
                        this.sop("Error: Failed to create Ticket...|API URL: " + string2 + " Details-> Priority: " + string4 + " Component Type: " + string5 + " Component Name: " + string6 + " Layer: " + string7 + " Zone name :" + string3 + " Summary: " + string8 + " Description: " + string9);
                        if (StringUtils.isNull((String)string10)) return string;
                        if (!string10.startsWith("{")) return string;
                        this.sop("Response JSON Data Received for create Ticket request:\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)string10)));
                        return string;
                    }
                    catch (Exception exception) {
                        if (!this.logEnabled) return string;
                        this.sop("Error ->  Failed to send :" + string2 + " Reason :" + exception.toString());
                        return string;
                    }
                }
                if (!this.logEnabled) return string;
                this.sop("Error: Failed to create Ticket...| Reason: Surname of the Person provided is invalid");
                return string;
            }
            catch (Throwable throwable) {
                if (this.logEnabled) {
                    this.sop("ERROR:  Exception in createTicket()  method -TOPdeskIntegrator ");
                }
                throwable.printStackTrace();
            }
        }
        finally {
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateTicket(String string, Object[] objectArray) throws Exception {
        String string2 = "";
        boolean bl = false;
        String string3 = "";
        JSONObject jSONObject = new JSONObject();
        try {
            try {
                String string4 = (String)objectArray[1];
                if (StringUtils.isNull((String)string4)) {
                    string4 = "-";
                }
                if (!StringUtils.isNull((String)this.callerId)) {
                    String string5 = (String)objectArray[0];
                    String string6 = (String)objectArray[3];
                    String string7 = (String)objectArray[4];
                    String string8 = (String)objectArray[5];
                    Hashtable hashtable = this.getFormattedData(objectArray);
                    String string9 = "";
                    String string10 = "";
                    if (hashtable != null && hashtable.get("summary") != null) {
                        string9 = hashtable.get("summary").toString();
                    }
                    if (hashtable != null && hashtable.get("description") != null) {
                        string10 = hashtable.get("description").toString();
                        string10 = string10.replace("<br>", " ");
                    }
                    string3 = this.url;
                    string3 = string3 + "/tas/api/incidents/number/" + string;
                    try {
                        Hashtable hashtable2 = this.connect(string3, "put", objectArray);
                        int n = 0;
                        try {
                            if (hashtable2 != null && hashtable2.get("statusCode") != null) {
                                n = Integer.parseInt(hashtable2.get("statusCode").toString());
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("Status code is empty |Exception: " + exception);
                        }
                        String string11 = "";
                        if (hashtable2 != null && hashtable2.get("resData") != null) {
                            string11 = hashtable2.get("resData").toString();
                        }
                        if (this.logEnabled && this.enableDetailedLog) {
                            this.sop("Status Code of the response:" + n);
                            if (!StringUtils.isNull((String)string11) && string11.startsWith("{") && this.enableResponseJsonLog) {
                                this.sop("Response JSON Data Received for update Ticket request:\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)string11)));
                            }
                        }
                        if (n != 201 && n != 200) {
                            if (!this.logEnabled) return bl;
                            this.sop("Error: Failed to update Ticket...|API URL: " + string3 + " Details-> Priority: " + string5 + " Component Type: " + string6 + " Component Name: " + string7 + " Layer: " + string8 + " Zone name :" + string4 + " Summary: " + string9 + " Description: " + string10);
                            if (StringUtils.isNull((String)string11)) return bl;
                            if (!string11.startsWith("{")) return bl;
                            this.sop("Response JSON Data Received for update Ticket request:\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)string11)));
                            return bl;
                        }
                        if (!StringUtils.isNull((String)string11) && string11.startsWith("{")) {
                            jSONObject = JSONObject.fromObject((Object)string11);
                        }
                        if (jSONObject.get("number") != null) {
                            bl = true;
                            string2 = jSONObject.get("number").toString();
                            if (!this.logEnabled) return bl;
                            this.sop("INFO: Ticket has been updated successfully...Details-> Ticket Number: " + string2 + " Priority: " + string5 + " Component Type: " + string6 + " Component Name: " + string7 + " Layer: " + string8 + " Zone name :" + string4 + " Summary: " + string9 + " Description: " + string10);
                            return bl;
                        }
                        if (!this.logEnabled) return bl;
                        this.sop("Error: Failed to update Ticket...|API URL: " + string3 + " Details-> Priority: " + string5 + " Component Type: " + string6 + " Component Name: " + string7 + " Layer: " + string8 + " Zone name :" + string4 + " Summary: " + string9 + " Description: " + string10);
                        if (StringUtils.isNull((String)string11)) return bl;
                        if (!string11.startsWith("{")) return bl;
                        this.sop("Response JSON Data Received for update Ticket request:\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)string11)));
                        return bl;
                    }
                    catch (Exception exception) {
                        if (!this.logEnabled) return bl;
                        this.sop("Error ->  Failed to send :" + string3 + " Reason :" + exception.toString());
                        return bl;
                    }
                }
                if (!this.logEnabled) return bl;
                this.sop("Error: Failed to update Ticket...| Reason: Surname of the Person provided is invalid");
                return bl;
            }
            catch (Throwable throwable) {
                if (this.logEnabled) {
                    this.sop("ERROR: Exception in UpdateTicket()  method -TOPdeskIntegrator.java ");
                }
                throwable.printStackTrace();
            }
        }
        finally {
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getFormattedData(Object[] objectArray) {
        Object object;
        Object object2;
        Object object3;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = (String)objectArray[0];
        String string6 = (String)objectArray[2];
        String string7 = (String)objectArray[3];
        String string8 = (String)objectArray[4];
        String string9 = (String)objectArray[5];
        String string10 = "";
        String string11 = "";
        int n = 1;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        String string12 = (String)objectArray[7];
        String string13 = (String)objectArray[8];
        String string14 = (String)objectArray[11];
        if (!StringUtils.isNull((String)string14)) {
            object3 = new StringTokenizer(string14, ",");
            object2 = null;
            object = null;
            String string15 = "";
            String string16 = "";
            String string17 = "";
            String string18 = "";
            String string19 = "";
            String string20 = "";
            String string21 = "";
            int n2 = 1;
            while (((StringTokenizer)object3).hasMoreTokens()) {
                string15 = ((StringTokenizer)object3).nextToken();
                if (StringUtils.isNull((String)string15) || ((StringTokenizer)(object2 = new StringTokenizer(string15, "|"))).countTokens() < 5) continue;
                string4 = ((StringTokenizer)object2).nextToken();
                string3 = ((StringTokenizer)object2).nextToken();
                if (!StringUtils.isNull((String)string3) && string3.length() > 1) {
                    string3 = string3.substring(1).trim();
                }
                string16 = string2 = ((StringTokenizer)object2).nextToken();
                string2 = this.mappingInfo.getTestDescription(string16);
                string17 = ((StringTokenizer)object2).nextToken();
                string18 = string8.substring(string8.indexOf(":") + 1);
                hashtable2.put("$componentType", this.mappingInfo.getComponentTypeDescription(string7));
                hashtable2.put("$componentName", string8);
                hashtable2.put("$info", string3);
                hashtable2.put("$port", string18);
                hashtable2.put("appendTag", new Boolean(false));
                string19 = this.tablesInfo.getMeasureAlert(string16 + ":" + string17, this.thisLanguage, hashtable2);
                string20 = ((StringTokenizer)object2).nextToken();
                if (!StringUtils.isNull((String)string3)) {
                    string11 = string11 + "<br>* " + string19 + " / " + string2;
                    if (string3.equalsIgnoreCase("+")) continue;
                    string11 = string11 + " <br>Descriptor :";
                    n2 = 1;
                    object = new StringTokenizer(string3, ";");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string21 = ((StringTokenizer)object).nextToken().toString();
                        string11 = string11 + "<br>" + n2 + ". " + string21;
                        ++n2;
                    }
                } else {
                    string11 = string11 + "<br>" + n + ". " + string19 + " / " + string2;
                }
                ++n;
            }
        }
        string10 = string11;
        try {
            block29: {
                hashtable = new Hashtable();
                if (!StringUtils.isNull((String)this.DescriptionFormat)) {
                    hashtable.put("description", this.DescriptionFormat);
                } else {
                    hashtable.put("description", this.DefaultDescFormat);
                }
                if (!StringUtils.isNull((String)this.TitleFormat)) {
                    hashtable.put("summary", this.TitleFormat);
                } else {
                    hashtable.put("summary", this.DefaultTitleFormat);
                }
                if (hashtable == null) break block29;
                if (hashtable.isEmpty()) break;
                object3 = hashtable.keySet();
                object2 = object3.iterator();
                object = "";
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    string = (String)hashtable.get(object);
                    if (StringUtils.isNull((String)object) || StringUtils.isNull((String)string)) continue;
                    if (string.indexOf("$cname") > -1) {
                        string = !StringUtils.isNull((String)string8) ? this.replace(string, "$cname", string8 + "<br>") : this.replace(string, "$cname", "-<br>");
                    }
                    if (string.indexOf("$ctype") > -1) {
                        string = !StringUtils.isNull((String)string7) ? this.replace(string, "$ctype", string7 + "<br>") : this.replace(string, "$ctype", "-<br>");
                    }
                    if (string.indexOf("$prior") > -1) {
                        string = !StringUtils.isNull((String)string5) ? this.replace(string, "$prior", string5 + "<br>") : this.replace(string, "$prior", "-<br>");
                    }
                    if (string.indexOf("$pdesc") > -1) {
                        string = !StringUtils.isNull((String)string10) ? this.replace(string, "$pdesc", string10 + "<br>") : this.replace(string, "$pdesc", "-<br>");
                    }
                    if (string.indexOf("$layer") > -1) {
                        string = !StringUtils.isNull((String)string9) ? this.replace(string, "$layer", string9 + "<br>") : this.replace(string, "$layer", "-<br>");
                    }
                    if (string.indexOf("$starttime") > -1) {
                        string = !StringUtils.isNull((String)string12) ? this.replace(string, "$starttime", string12 + "<br>") : this.replace(string, "$starttime", "-<br>");
                    }
                    if (string.indexOf("$service") > -1) {
                        string = !StringUtils.isNull((String)string6) ? this.replace(string, "$service", string6 + "<br>") : this.replace(string, "$service", "-<br>");
                    }
                    if (string.indexOf("$user") > -1) {
                        string = !StringUtils.isNull((String)string13) ? this.replace(string, "$user", string13 + "<br>") : this.replace(string, "$user", "-<br>");
                    }
                    if (string.indexOf("$test") > -1) {
                        string = !StringUtils.isNull((String)string2) ? this.replace(string, "$test", string2 + "<br>") : this.replace(string, "$test", "-<br>");
                    }
                    if (string.indexOf("$info") > -1) {
                        string = !StringUtils.isNull((String)string3) ? this.replace(string, "$info", string3 + "<br>") : this.replace(string, "$info", "-<br>");
                    }
                    string = this.replace(string, "~!~false", "");
                    string = this.replace(string, "~!~true", "");
                    if (((String)object).equalsIgnoreCase("summary") && (string = this.replace(string, "<br>", "")).length() > this.MAX_TITLE_SIZE) {
                        string = string.substring(0, this.MAX_TITLE_SIZE - 4);
                        string = string + "...";
                    }
                    if (((String)object).equalsIgnoreCase("description") && string.length() > this.MAX_DESC_SIZE) {
                        string = string.substring(0, this.MAX_DESC_SIZE - 4);
                        string = string + "...";
                    }
                    hashtable.put((String)object, string);
                }
                break;
            }
        }
        catch (Exception exception) {
            if (this.logEnabled) {
                this.sop("ERROR: Exception in getFormattedData method -TOPdeskIntegrator.java-->" + exception);
            }
            exception.printStackTrace();
        }
        finally {
            return hashtable;
        }
    }

    private String getResponseData(HttpResponse httpResponse) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("ERROR: Exception in getResponseData()  method -TOPdeskIntegrator.java-->" + exception);
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public void doTheSSL() {
        try {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
        }
        catch (Exception exception) {
            if (this.logEnabled) {
                this.sop("ERROR: Exception in doTheSSL method -TopdeskIntegrator.java-->" + exception);
            }
            exception.printStackTrace();
        }
    }

    private String getTicketData(Object[] objectArray, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        String string = (String)objectArray[0];
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Hashtable hashtable = this.getFormattedData(objectArray);
        String string5 = "";
        String string6 = "";
        if (hashtable != null && hashtable.get("summary") != null) {
            string5 = hashtable.get("summary").toString();
        }
        if (hashtable != null && hashtable.get("description") != null) {
            string6 = hashtable.get("description").toString();
        }
        if (!StringUtils.isNull((String)string)) {
            if (string.equalsIgnoreCase("Critical")) {
                string3 = this.criticalPriorityId;
                string4 = this.openTicketStatusId;
            } else if (string.equalsIgnoreCase("Major")) {
                string3 = this.majorPriorityId;
                string4 = this.openTicketStatusId;
            } else if (string.equalsIgnoreCase("Minor")) {
                string3 = this.minorPriorityId;
                string4 = this.openTicketStatusId;
            } else if (string.equalsIgnoreCase("Normal")) {
                string3 = this.normalPriorityId;
                string4 = this.resolvedTicketStatusId;
            }
        }
        JSONObject jSONObject = new JSONObject();
        if (!StringUtils.isNull((String)string6)) {
            jSONObject.put((Object)"request", (Object)string6);
        }
        if (!StringUtils.isNull((String)string5)) {
            jSONObject.put((Object)"briefDescription", (Object)string5);
        }
        if (!StringUtils.isNull((String)string3)) {
            object3 = new JSONObject();
            object3.put((Object)"id", (Object)string3);
            jSONObject.put((Object)"priority", object3);
        }
        if (!StringUtils.isNull((String)this.ticketStatus)) {
            jSONObject.put((Object)"status", (Object)this.ticketStatus);
        }
        if (!StringUtils.isNull((String)string4)) {
            object3 = new JSONObject();
            object3.put((Object)"id", (Object)string4);
            jSONObject.put((Object)"processingStatus", object3);
        }
        if (!StringUtils.isNull((String)this.callerId)) {
            object3 = new JSONObject();
            object3.put((Object)"id", (Object)this.callerId);
            jSONObject.put((Object)"caller", object3);
        }
        object3 = "";
        String string7 = "";
        if (this.isImpactRequired || this.isUrgencyRequired) {
            if (string != null && string.equalsIgnoreCase("Critical")) {
                object3 = this.urgencyValueForCritical;
                string7 = this.impactValueForCritical;
            } else if (string != null && string.equalsIgnoreCase("Major")) {
                object3 = this.urgencyValueForMajor;
                string7 = this.impactValueForMajor;
            } else if (string != null && string.equalsIgnoreCase("Minor")) {
                object3 = this.urgencyValueForMinor;
                string7 = this.impactValueForMinor;
            }
            if (this.isImpactRequired && !StringUtils.isNull((String)string7)) {
                object2 = string7;
                string7 = string7.toLowerCase();
                if (StringUtils.isNull((String)(string7 = (String)this.impactTypeList.get(string7)))) {
                    string7 = (String)this.impactTypeList.get(object2);
                }
                object = new JSONObject();
                object.put((Object)"id", (Object)string7);
                jSONObject.put((Object)"impact", object);
            }
            if (this.isUrgencyRequired && !StringUtils.isNull((String)object3)) {
                object2 = string7;
                object3 = ((String)object3).toLowerCase();
                if (StringUtils.isNull((String)(object3 = (String)this.urgencyList.get(object3)))) {
                    object3 = (String)this.impactTypeList.get(object2);
                }
                object = new JSONObject();
                object.put((Object)"id", object3);
                jSONObject.put((Object)"urgency", object);
            }
        }
        if (!bl) {
            if (!StringUtils.isNull((String)this.operatorId)) {
                object2 = new JSONObject();
                object2.put((Object)"id", (Object)this.operatorId);
                jSONObject.put((Object)"operator", object2);
            }
            if (!StringUtils.isNull((String)this.operatorGroup)) {
                object2 = new JSONObject();
                object2.put((Object)"id", (Object)this.operatorGroup);
                jSONObject.put((Object)"operatorGroup", object2);
            }
            if (!StringUtils.isNull((String)this.categoryId)) {
                object2 = new JSONObject();
                object2.put((Object)"id", (Object)this.categoryId);
                jSONObject.put((Object)"category", object2);
            }
            if (!StringUtils.isNull((String)this.subCategoryId)) {
                object2 = new JSONObject();
                object2.put((Object)"id", (Object)this.subCategoryId);
                jSONObject.put((Object)"subcategory", object2);
            }
            if (!StringUtils.isNull((String)this.callTypeId)) {
                object2 = new JSONObject();
                object2.put((Object)"id", (Object)this.callTypeId);
                jSONObject.put((Object)"callType", object2);
            }
            if (!StringUtils.isNull((String)this.entryTypeId)) {
                object2 = new JSONObject();
                object2.put((Object)"id", (Object)this.entryTypeId);
                jSONObject.put((Object)"entryType", object2);
            }
            if (this.isCallerBranchRequired) {
                object2 = (String)objectArray[1];
                if (!StringUtils.isNull((String)object2)) {
                    object = (String)this.callBranchIdMap.get(object2);
                    if (!StringUtils.isNull((String)object)) {
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put((Object)"id", object);
                        jSONObject.put((Object)"callerBranch", (Object)jSONObject2);
                    } else {
                        this.sop("Error: Failed to create Ticket...|Caller branch is not configured for the Zone : " + (String)object2);
                    }
                } else {
                    this.sop("Error: Failed to create Ticket...|component belongs to the alert is not associated with any zone and Caller branch is not configured for the Zone ");
                }
            }
        }
        string2 = jSONObject.toString();
        return string2;
    }
}

