/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.output;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.output.Outputter;

public class DelimitedTextOutputter
implements Outputter {
    private String delimiter = ",";
    private boolean outputHeaderRow = false;
    private String dependentVariableName = "dependent value";
    private BufferedWriter out;

    public DelimitedTextOutputter(String filename) throws IOException {
        this(new FileWriter(filename));
    }

    public DelimitedTextOutputter(String filename, boolean append) throws IOException {
        this(new FileWriter(filename, append));
    }

    public DelimitedTextOutputter(File file) throws IOException {
        this(new FileWriter(file));
    }

    public DelimitedTextOutputter(File file, boolean append) throws IOException {
        this(new FileWriter(file.getPath(), append));
    }

    public DelimitedTextOutputter(Writer writer) {
        this.out = new BufferedWriter(writer);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void output(DataSet dataSet) throws IOException {
        if (this.outputHeaderRow) {
            this.writeHeader(dataSet.getIndependentVariables());
        }
        Iterator it = dataSet.iterator();
        while (it.hasNext()) {
            DataPoint dataPoint = (DataPoint)it.next();
            this.output(dataPoint);
        }
        this.out.flush();
    }

    private void writeHeader(String[] varNames) throws IOException {
        int var = 0;
        while (var < varNames.length) {
            if (varNames[var].indexOf(this.delimiter) >= 0) {
                this.out.write(34);
                this.out.write(varNames[var]);
                this.out.write(34);
            } else {
                this.out.write(varNames[var]);
            }
            this.out.write(this.delimiter);
            ++var;
        }
        this.out.write(this.dependentVariableName);
        this.out.newLine();
    }

    public void output(DataPoint dataPoint) throws IOException {
        String[] varNames = dataPoint.getIndependentVariableNames();
        int var = 0;
        while (var < varNames.length) {
            this.out.write("" + dataPoint.getIndependentValue(varNames[var]) + this.delimiter);
            ++var;
        }
        this.out.write("" + dataPoint.getDependentValue());
        this.out.newLine();
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
    }

    public String getDependentVariableName() {
        return this.dependentVariableName;
    }

    public void setDependentVariableName(String name) {
        this.dependentVariableName = name;
    }

    public void setOutputHeaderRow(boolean outputHeaderRow) {
        this.outputHeaderRow = outputHeaderRow;
    }
}

