/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.tds.SybTimestamp;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class DateObject {
    private static final String ZEROS = "0000000000";
    private int _nanos = 0;
    private Calendar _calendar = null;

    public DateObject() throws SQLException {
        this.init(null, null);
    }

    public DateObject(Object o) throws SQLException {
        this.init(o, null);
    }

    public DateObject(Object o, Calendar cal) throws SQLException {
        this.init(o, cal);
    }

    public DateObject(Calendar cal) throws SQLException {
        this.init(null, cal);
    }

    public String format(boolean includeNanos) {
        int dateVal = 0;
        String formattedDate = String.valueOf(this._calendar.get(1)) + "-";
        dateVal = this._calendar.get(2) + 1;
        formattedDate = String.valueOf(formattedDate) + (dateVal < 10 ? "0" : "") + dateVal + "-";
        dateVal = this._calendar.get(5);
        formattedDate = String.valueOf(formattedDate) + (dateVal < 10 ? "0" : "") + dateVal + " ";
        dateVal = this._calendar.get(11);
        formattedDate = String.valueOf(formattedDate) + (dateVal < 10 ? "0" : "") + dateVal + ":";
        dateVal = this._calendar.get(12);
        formattedDate = String.valueOf(formattedDate) + (dateVal < 10 ? "0" : "") + dateVal + ":";
        dateVal = this._calendar.get(13);
        formattedDate = String.valueOf(formattedDate) + (dateVal < 10 ? "0" : "") + dateVal;
        if (includeNanos) {
            String nanosString = null;
            if (this._nanos == 0) {
                nanosString = "0";
            } else {
                nanosString = Integer.toString(this._nanos);
                if (nanosString.length() < 9) {
                    nanosString = String.valueOf(ZEROS.substring(0, 9 - nanosString.length())) + nanosString;
                }
                char[] nanosChar = new char[nanosString.length()];
                nanosString.getChars(0, nanosString.length(), nanosChar, 0);
                int truncIndex = 8;
                while (nanosChar[truncIndex] == '0') {
                    --truncIndex;
                }
                nanosString = new String(nanosChar, 0, truncIndex + 1);
            }
            formattedDate = String.valueOf(formattedDate) + "." + nanosString;
        }
        return formattedDate;
    }

    public Calendar getCalendar() {
        return this._calendar;
    }

    public int getNanos() {
        return this._nanos;
    }

    private void init(Object o, Calendar cal) throws SQLException {
        Calendar userCal = null;
        userCal = cal != null ? (Calendar)cal.clone() : Calendar.getInstance();
        if (o != null) {
            this._calendar = Convert.objectToCalendar(o, userCal);
            if (o instanceof Timestamp) {
                this._nanos = ((Timestamp)o).getNanos();
            }
        } else {
            this._calendar = userCal;
            this._calendar.clear();
        }
    }

    public void setNanos(int nanos) {
        this._nanos = nanos;
    }

    public String toString() {
        String value = this.format(true);
        int decimalPoint = value.lastIndexOf(46);
        if (decimalPoint >= 0) {
            int end = decimalPoint + 4;
            if (end > value.length()) {
                end = value.length();
            }
            value = value.substring(0, end);
        }
        return value;
    }

    public SybTimestamp toSybTimestamp() {
        return new SybTimestamp(this._calendar.get(1) - 1900, this._calendar.get(2), this._calendar.get(5), this._calendar.get(11), this._calendar.get(12), this._calendar.get(13), this._nanos);
    }
}

