/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.TdsDataInputStream;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.CacheStream;
import com.sybase.jdbc2.utils.Debug;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RawInputStream
extends FilterInputStream {
    private static final int HIBIT = Integer.MIN_VALUE;
    private static final int LOBITS = Integer.MAX_VALUE;
    private static final int NOLIMIT = -1;
    private int _visibleLength;
    private boolean _noLimit;
    private int _actualLength;
    private int _resetVisibleLength;
    private int _resetActualLength;
    private boolean _resetLastChunk;
    private int _bytesRead;
    private int _jmark;
    private boolean _markSupported;
    CacheManager _cm;
    TdsDataInputStream _tdis;
    private boolean _dead = false;
    protected boolean _isCached = false;
    private boolean _needReset = false;
    private boolean _lastChunk = true;

    public RawInputStream(InputStream stream, int length, int lengthLimit, CacheManager cm) throws IOException {
        super(stream);
        Debug.println(this, "RawInputStream(length = " + length + ", lengthLimit = " + lengthLimit);
        this._resetVisibleLength = lengthLimit;
        this._visibleLength = lengthLimit;
        this._noLimit = lengthLimit == -1;
        this._resetActualLength = length;
        this._actualLength = length;
        this._bytesRead = 0;
        this._jmark = -1;
        this._markSupported = false;
        this._cm = cm;
        this._tdis = stream instanceof TdsDataInputStream ? (TdsDataInputStream)stream : null;
        if (length < 0) {
            this._lastChunk = false;
        }
    }

    public int available() throws IOException {
        this.checkMe();
        Debug.println(this, "available()");
        if (this.in == null) {
            Debug.println(this, "InputStream is NULL!");
            return 0;
        }
        int avail = 0;
        if (this._actualLength > 0) {
            avail = this.in.available();
        }
        if (avail < this._actualLength && avail < this._visibleLength && !this._noLimit) {
            return avail;
        }
        return this._noLimit ? this._actualLength : this._visibleLength;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cache(CacheStream is) throws IOException {
        if (this._jmark != -1) {
            Debug.assert(this, this._isCached);
            return true;
        }
        this._jmark = this._bytesRead;
        this._needReset = true;
        this._resetActualLength = this._actualLength;
        this._resetVisibleLength = this._visibleLength;
        this._resetLastChunk = this._lastChunk;
        if (this._actualLength == 0 && this._lastChunk || this._dead) {
            this._isCached = true;
            return true;
        }
        if (this._isCached) {
            return true;
        }
        this.in = is;
        try {
            Debug.println(this, "caching at " + this._bytesRead + " with a current buffer of " + this._actualLength + " bytes. " + (this._lastChunk ^ true) + " and visible length " + this._visibleLength);
            byte[] tmpbuf = new byte[512];
            block2: while (true) {
                if (this._actualLength <= 0 && this._lastChunk) {
                    this._isCached = true;
                    this.doneReading();
                    return this._isCached;
                }
                while (true) {
                    if (this._actualLength <= 0) {
                        this.nextChunk();
                        continue block2;
                    }
                    int len = this._actualLength < 512 ? this._actualLength : 512;
                    len = this.in.read(tmpbuf, 0, len);
                    Debug.println(this, "read " + len + " bytes");
                    if (len > 0) {
                        this._actualLength -= len;
                        this._bytesRead += len;
                        continue;
                    }
                    ErrorMessage.raiseIOException("JZ0EM");
                }
                break;
            }
        }
        catch (IOException ioe) {
            void tmpbuf;
            this._dead = true;
            throw tmpbuf;
        }
    }

    private void checkDone() throws IOException {
        if (this.in != null && (this._visibleLength == 0 || this._noLimit && this._actualLength == 0 && this._lastChunk)) {
            Debug.println(this, "just read the last byte.");
            this.doneReading();
            this._isCached = true;
        }
    }

    private void checkMe() throws IOException {
        if (this._dead) {
            ErrorMessage.raiseIOException("JZ0I9");
        }
        if (this._needReset && this._tdis != null) {
            Debug.println(this, "resetting to " + this._jmark + " with a current buffer of " + this._resetActualLength + " bytes. " + (this._resetLastChunk ^ true) + " and visible length " + this._resetVisibleLength);
            this._tdis.reset();
            this._needReset = false;
            this.in.reset();
            this._visibleLength = this._resetVisibleLength;
            this._actualLength = this._resetActualLength;
            this._lastChunk = this._resetLastChunk;
            this._bytesRead = 0;
            this.in.skip(this._jmark);
            this._bytesRead = this._jmark;
            this._jmark = -1;
        }
        if (this._actualLength <= 0 && !this._lastChunk) {
            this.nextChunk();
        }
    }

    public void close() throws IOException {
        if (this._dead) {
            return;
        }
        Debug.println(this, "close()");
        if (this._dead) {
            return;
        }
        this._needReset = false;
        this.checkMe();
        try {
            if (!this._isCached) {
                if (this._noLimit) {
                    while (this._actualLength > 0 || !this._lastChunk) {
                        this.skip(this._actualLength);
                    }
                } else {
                    this._visibleLength = this._actualLength;
                    this.skip(this._visibleLength);
                }
            }
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.checkDone();
            this._dead = true;
            this.in = null;
            throw throwable;
        }
        this.checkDone();
        this._dead = true;
        this.in = null;
    }

    private void doneReading() throws IOException {
        if (!this._isCached) {
            Debug.println(this, "doneReading(), slurping/skipping " + this._actualLength + " bytes.");
            if (!this._noLimit) {
                if (this._resetActualLength > this._resetVisibleLength) {
                    Debug.println(this, "it's a slurp.");
                    this.in.read(new byte[this._actualLength]);
                } else {
                    Debug.println(this, "it's a skip.");
                    this.in.skip(this._actualLength);
                }
            } else {
                Debug.assert(this, this._visibleLength == -1);
                while (!(this.in == null || this._actualLength <= 0 && this._lastChunk)) {
                    this.skip(this._actualLength);
                }
            }
        }
        if (this._cm != null) {
            this._cm.doneReading();
            this._cm = null;
        }
    }

    public boolean markSupported() {
        return this._markSupported;
    }

    private void nextChunk() throws IOException {
        if (this._lastChunk) {
            return;
        }
        Debug.assert(this, this._actualLength <= 0 && this._tdis != null);
        int chunkSize = this._tdis.readInt(this.in);
        this._bytesRead += 4;
        Debug.println(this, "nextChunk() " + (chunkSize & Integer.MAX_VALUE) + ((chunkSize & Integer.MIN_VALUE) == 0 ? " LAST" : " MORE"));
        if ((chunkSize & Integer.MIN_VALUE) == 0) {
            this._lastChunk = true;
        }
        this._actualLength = chunkSize & Integer.MAX_VALUE;
    }

    public int read() throws IOException {
        this.checkMe();
        if (this._visibleLength == 0) {
            return -1;
        }
        if (!this._noLimit) {
            --this._visibleLength;
        }
        int b = 0;
        if (this._actualLength > 0) {
            --this._actualLength;
            ++this._bytesRead;
            b = this.in.read();
        }
        this.checkDone();
        return b;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        this.checkMe();
        if (length == 0) {
            return 0;
        }
        int numToReturn = length;
        if (!this._noLimit && this._visibleLength < length) {
            numToReturn = this._visibleLength;
        }
        if (numToReturn == 0) {
            Debug.println(this, "past end of visible data");
            return -1;
        }
        length = numToReturn;
        while (!(length <= 0 || this._actualLength <= 0 && this._lastChunk)) {
            int numToRead;
            int n = numToRead = length < this._actualLength ? length : this._actualLength;
            if (numToRead > 0) {
                Debug.println(this, "reading " + numToRead + " of a requested " + length + " bytes into a buffer of " + buf.length + " bytes at offset " + offset);
                int nread = this.in.read(buf, offset, numToRead);
                Debug.assert(this, nread == numToRead);
                offset += nread;
                length -= nread;
                if (this._actualLength > 0) {
                    this._actualLength -= nread;
                }
                this._bytesRead += nread;
            }
            if (this._actualLength != 0) continue;
            this.nextChunk();
        }
        if (this._noLimit) {
            if (length == numToReturn) {
                return -1;
            }
            if (length > 0) {
                numToReturn -= length;
            }
        } else {
            this._visibleLength -= numToReturn;
            Debug.println(this, "padding " + length + " null bytes");
            if (length > 0) {
                int i = 0;
                while (i < length) {
                    buf[offset + i] = 0;
                    ++i;
                }
            }
        }
        this.checkDone();
        return numToReturn;
    }

    public void setCached(boolean cached) {
        this._isCached = cached;
    }

    public long skip(long n) throws IOException {
        this.checkMe();
        if (this._visibleLength == 0) {
            return 0L;
        }
        long numToSkip = n;
        if (!this._noLimit) {
            if ((long)this._visibleLength < n) {
                numToSkip = this._visibleLength;
            }
            this._visibleLength = (int)((long)this._visibleLength - numToSkip);
        }
        long numSkipped = 0L;
        while (!(numToSkip <= 0L || this._actualLength <= 0 && this._lastChunk)) {
            long actualNumToSkip = numToSkip < (long)this._actualLength ? numToSkip : (long)this._actualLength;
            Debug.println(this, "skipping " + numToSkip + " bytes. (Actually skipping " + actualNumToSkip + ")");
            if (actualNumToSkip > 0L) {
                this.in.skip(actualNumToSkip);
                this._actualLength = (int)((long)this._actualLength - actualNumToSkip);
                this._bytesRead = (int)((long)this._bytesRead + actualNumToSkip);
                numToSkip -= actualNumToSkip;
                numSkipped += actualNumToSkip;
            }
            if (numToSkip <= 0L) continue;
            this.nextChunk();
        }
        this.checkDone();
        return numSkipped;
    }
}

