/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybPooledConnection;
import com.sybase.jdbc2.jdbc.SybXAConnection;
import com.sybase.jdbc2.jdbc.SybXAResource;
import com.sybase.jdbc2.jdbc.SybXAResource11;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbcx.Capture;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybEventHandler;
import com.sybase.jdbcx.SybMessageHandler;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.XAConnection;

public class SybConnectionProxy
implements SybConnection {
    protected final SybPooledConnection _realConn;
    private final boolean _realConnIsXA;
    private WeakHashMap _openStatements = new WeakHashMap();
    private boolean _wasClosed = false;

    public SybConnectionProxy(SybPooledConnection conn) {
        this._realConn = conn;
        this._realConnIsXA = this._realConn instanceof XAConnection;
        Debug.println(this, "SybConnectionProxy constructed for type " + (this._realConnIsXA ? "XA" : "Pooled") + "Connection");
    }

    public void cancel() throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.cancel();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    private void checkIfClosed() throws SQLException {
        if (this._wasClosed) {
            ErrorMessage.raiseError("JZ0C0");
        }
    }

    private void checkLocalTransaction(String txtype) throws SQLException {
        SybXAResource sxar = (SybXAResource)((SybXAConnection)this._realConn).getXAResource();
        if (!sxar.isLocalTransactionOK()) {
            ErrorMessage.raiseError(sxar instanceof SybXAResource11 ? "JZ0S6" : "JZ0S5", txtype);
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.clearWarnings();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public void close() throws SQLException {
        Debug.println(this, "close()");
        this.checkIfClosed();
        this._wasClosed = true;
        this.closeRememberedStatements();
        this._realConn.notifyListeners(null);
    }

    protected void closeRememberedStatements() {
        Debug.println(this, "closeRememberedStatements()");
        Iterator iter = ((AbstractMap)this._openStatements).keySet().iterator();
        while (iter.hasNext()) {
            Statement stmt = (Statement)iter.next();
            try {
                stmt.close();
            }
            catch (SQLException sqe) {
                if (sqe.getSQLState().equals("JZ0S2") || sqe.getSQLState().equals("JZ0C0")) continue;
                Debug.println(this, "problem closing statement: " + sqe);
            }
        }
        this._openStatements.clear();
    }

    public void commit() throws SQLException {
        Debug.println(this, "commit()");
        this.checkIfClosed();
        if (this._realConnIsXA) {
            this.checkLocalTransaction("commit()");
        }
        try {
            this._realConn.commit();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public Capture createCapture() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.createCapture();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public Statement createStatement() throws SQLException {
        this.checkIfClosed();
        Statement stmt = null;
        Debug.println(this, "createStatement()");
        try {
            stmt = this._realConn.createStatement();
            this.rememberStatement(stmt);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
        return stmt;
    }

    public Statement createStatement(int type, int concur) throws SQLException {
        this.checkIfClosed();
        Statement stmt = null;
        try {
            stmt = this._realConn.createStatement(type, concur);
            this.rememberStatement(stmt);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
        return stmt;
    }

    public boolean getAutoCommit() throws SQLException {
        Debug.println(this, "getAutoCommit()");
        this.checkIfClosed();
        try {
            return this._realConn.getAutoCommit();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public String getCatalog() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getCatalog();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getMetaData();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public String getSessionID() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getSessionID();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._realConn.getSybMessageHandler();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getTransactionIsolation();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getTypeMap();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getWarnings();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public boolean isClosed() throws SQLException {
        if (this._wasClosed) {
            return true;
        }
        try {
            return this._realConn.isClosed();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.isReadOnly();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.nativeSQL(sql);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkIfClosed();
        CallableStatement stmt = null;
        try {
            stmt = this._realConn.prepareCall(sql);
            this.rememberStatement(stmt);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int type, int concur) throws SQLException {
        this.checkIfClosed();
        CallableStatement stmt = null;
        try {
            stmt = this._realConn.prepareCall(sql, type, concur);
            this.rememberStatement(stmt);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        Debug.println(this, "prepareStatement(" + sql + ")");
        this.checkIfClosed();
        PreparedStatement stmt = null;
        try {
            stmt = this._realConn.prepareStatement(sql);
            this.rememberStatement(stmt);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int type, int concur) throws SQLException {
        this.checkIfClosed();
        PreparedStatement stmt = null;
        try {
            stmt = this._realConn.prepareStatement(sql, type, concur);
            this.rememberStatement(stmt);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, boolean dynamic) throws SQLException {
        PreparedStatement stmt;
        this.checkIfClosed();
        try {
            stmt = this._realConn.prepareStatement(sql, dynamic);
            this.rememberStatement(stmt);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
        return stmt;
    }

    public void regNoWatch(String eventName) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.regNoWatch(eventName);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public void regWatch(String eventName, SybEventHandler eventHdlr, int option) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.regWatch(eventName, eventHdlr, option);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    protected void rememberStatement(Statement stmt) {
        Debug.println(this, "rememberStatement(" + stmt + ")");
        this._openStatements.put(stmt, null);
    }

    public void rollback() throws SQLException {
        Debug.println(this, "rollback()");
        this.checkIfClosed();
        if (this._realConnIsXA) {
            this.checkLocalTransaction("rollback()");
        }
        try {
            this._realConn.rollback();
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        Debug.println(this, "setAutoCommit(" + autoCommit + ")");
        this.checkIfClosed();
        if (this._realConnIsXA && autoCommit && this._realConnIsXA) {
            this.checkLocalTransaction("setAutoCommit()");
        }
        try {
            this._realConn.setAutoCommit(autoCommit);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setCatalog(catalog);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setReadOnly(readOnly);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public void setSybMessageHandler(SybMessageHandler msgHandler) {
        this._realConn.setSybMessageHandler(msgHandler);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setTransactionIsolation(level);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setTypeMap(map);
        }
        catch (SQLException sqe) {
            this.testConnection(sqe);
            throw sqe;
        }
    }

    private void testConnection(SQLException sqle) {
        Debug.println(this, "testConnection(" + sqle + ")");
        boolean fatalError = true;
        try {
            fatalError = this._realConn.isClosed();
        }
        catch (SQLException sqe) {
            Debug.println(this, "Failed isClosed() test with exception\n" + sqe);
        }
        Debug.println(this, "the error was " + (fatalError ? "" : "NOT ") + "fatal");
        if (fatalError) {
            this._realConn.notifyListeners(sqle);
        }
    }

    protected boolean wasClosed() {
        return this._wasClosed;
    }
}

