/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybUrlManager;
import com.sybase.jdbc2.jdbc.SybUrlProviderImplBase;
import com.sybase.jdbc2.utils.Debug;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class SybJndiProvider
extends SybUrlProviderImplBase {
    private static final String[] SERVER_ATTRIBUTES = new String[]{"1.3.6.1.4.1.897.4.2.5", "1.3.6.1.4.1.897.4.2.15", "1.3.6.1.4.1.897.4.2.9", "1.3.6.1.4.1.897.4.2.10", "1.3.6.1.4.1.897.4.2.11", "1.3.6.1.4.1.897.4.2.16", "1.3.6.1.4.1.897.4.2.17", "1.3.6.1.4.1.897.4.2.18", "sybaseAddress", "sybaseHAservername", "sybaseJconnectProtocol", "sybaseJconnectProperty", "sybaseDatabaseName", "sybaseResourceManagerName", "sybaseResourceManagerType", "sybaseJdbcDataSourceInterface"};
    private static final int ADDRESS = 0;
    private static final int HASERVER = 1;
    private static final int PROTOCOL = 2;
    private static final int PROPERTY = 3;
    private static final int DBNAME = 4;
    private static final int RMNAME = 5;
    private static final int RMTYPE = 6;
    private static final int DATASOURCE = 7;
    private static final String[][] ATTRIBUTE_TABLE = new String[][]{{"1.3.6.1.4.1.897.4.2.5", "sybaseAddress"}, {"1.3.6.1.4.1.897.4.2.15", "sybaseHAservername"}, {"1.3.6.1.4.1.897.4.2.9", "sybaseJconnectProtocol"}, {"1.3.6.1.4.1.897.4.2.10", "sybaseJconnectProperty"}, {"1.3.6.1.4.1.897.4.2.11", "sybaseDatabaseName"}, {"1.3.6.1.4.1.897.4.2.16", "sybaseResourceManagerName"}, {"1.3.6.1.4.1.897.4.2.17", "sybaseResourceManagerType"}, {"1.3.6.1.4.1.897.4.2.18", "sybaseJdbcDataSourceInterface"}};
    private static final String SYBASE_ADDRESS_PREFIX = "TCP#1#";
    private static final char SYBASE_ADDRESS_DELIMITER = ' ';
    private static final String PLACEHOLDER = "placeholder";
    private static final char HOSTPORT_DELIMITER = ':';

    public SybJndiProvider() {
        this._hostportList = new Vector();
        this._secondaryHostportList = new Vector();
    }

    public SybJndiProvider(DirContext ctx, Name name, SybProperty sybProps) throws SQLException, NamingException {
        this();
        this._sybProps = sybProps;
        this.processAttrs(ctx.getNameInNamespace(), ctx.getAttributes(name, SERVER_ATTRIBUTES), ctx);
    }

    public void init(String protocol, String url, Properties userProps, SybProperty sybProps) throws SQLException {
        Debug.println(this, "SybJndiProvider.init()");
        Debug.println(this, "protocol: <" + protocol + ">, url: <" + url + ">");
        this._sybProps = sybProps;
        try {
            InitialDirContext ctx = new InitialDirContext(userProps);
            this.processAttrs(url, ctx.getAttributes(url, SERVER_ATTRIBUTES), ctx);
        }
        catch (NamingException ne) {
            Debug.printStackTrace(this, ne);
            ErrorMessage.raiseError("JZ013", url, ne.toString());
        }
    }

    private int mapAttribute(String name) {
        int i = 0;
        while (i < ATTRIBUTE_TABLE.length) {
            if (name.equals(ATTRIBUTE_TABLE[i][0]) || name.equalsIgnoreCase(ATTRIBUTE_TABLE[i][1])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void populateAddressList(Vector list, Attribute attr) throws NamingException {
        NamingEnumeration<?> e = attr.getAll();
        while (e.hasMoreElements()) {
            String dsValue = e.nextElement().toString();
            if (!dsValue.startsWith(SYBASE_ADDRESS_PREFIX) || dsValue.indexOf(32) == -1) {
                Debug.println(this, "skipping address entry: <" + dsValue + ">");
                continue;
            }
            Debug.println(this, "adding address entry: <" + dsValue + ">");
            list.addElement(dsValue.substring(SYBASE_ADDRESS_PREFIX.length()).replace(' ', ':'));
        }
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processAttrs(String url, Attributes attrs, DirContext ctx) throws SQLException {
        protocolName = null;
        lookupName = url;
        try {
            ae = attrs.getAll();
            block20: while (ae != null && ae.hasMoreElements()) {
                attr = ae.next();
                e = attr.getAll();
                dsAttribute = attr.getID();
                Debug.println(this, "Attribute name: " + dsAttribute);
                cfr_temp_0 = -2147483648;
                block21: do {
                    switch (cfr_temp_0 == -2147483648 ? this.mapAttribute(dsAttribute) : cfr_temp_0) {
                        case 0: {
                            Debug.println(this, "adding to primary list");
                            this.populateAddressList(this._hostportList, attr);
                            break;
                        }
                        case 2: {
                            protocolName = e.nextElement().toString();
                            Debug.println(this, "protocol: <" + protocolName + ">");
                            break;
                        }
                        case 4: {
                            this._dbName = e.nextElement().toString();
                            Debug.println(this, "database name: <" + this._dbName + ">");
                            break;
                        }
                        case 5: {
                            this._rmName = e.nextElement().toString();
                            Debug.println(this, "resource manager name: <" + this._rmName + ">");
                            break;
                        }
                        case 6: {
                            this._rmType = Integer.parseInt(e.nextElement().toString());
                            Debug.println(this, "resource manager type: <" + this._rmType + ">");
                            break;
                        }
                        case 7: {
                            this._dataSourceInterface = e.nextElement().toString();
                            Debug.println(this, "datasource interface: <" + this._dataSourceInterface + ">");
                            break;
                        }
                        default: {
                            break;
                        }
                        while (true) {
                            secondaryURL = e.nextElement().toString();
                            haAttribs = null;
                            Debug.println(this, "look up ADDRESS_HA_OID: " + secondaryURL);
                            try {
                                lookupName = secondaryURL;
                                haAttribs = ctx.getAttributes(secondaryURL, SybJndiProvider.SERVER_ATTRIBUTES);
                            }
                            catch (NamingException v0) {
                                np = null;
                                try {
                                    Debug.println(this, "DN from RDN?");
                                    np = ctx.getNameParser(url);
                                    n1 = np.parse(url);
                                    n1.remove(n1.size() - 1);
                                    n2 = np.parse(secondaryURL);
                                    this.removeDups(n2, n1);
                                    n1.addAll(n2);
                                    try {
                                        lookupName = n1.toString();
                                        Debug.println(this, "trying " + lookupName);
                                        haAttribs = ctx.getAttributes(n1, SybJndiProvider.SERVER_ATTRIBUTES);
                                    }
                                    catch (NamingException v1) {
                                        Debug.println(this, "couldn't parse name?");
                                        haAttribs = ctx.getAttributes(n1.toString(), SybJndiProvider.SERVER_ATTRIBUTES);
                                    }
                                }
                                catch (Exception e2) {
                                    Debug.printStackTrace(this, e2);
                                    Debug.println(this, "full DN?");
                                    searchBase = ctx.getNameInNamespace();
                                    base = np.parse(searchBase);
                                    n2 = np.parse(secondaryURL);
                                    this.removeDups(n2, base);
                                    try {
                                        lookupName = n2.toString();
                                        Debug.println(this, "trying " + lookupName);
                                        haAttribs = ctx.getAttributes(n2, SybJndiProvider.SERVER_ATTRIBUTES);
                                    }
                                    catch (NamingException v2) {
                                        Debug.println(this, "couldn't parse name?");
                                        haAttribs = ctx.getAttributes(n2.toString(), SybJndiProvider.SERVER_ATTRIBUTES);
                                    }
                                }
                            }
                            cfr_temp_0 = 1;
                            if (haAttribs == null) continue block21;
                            Debug.println(this, "adding to 2ndary list");
                            if (haAttribs.get("1.3.6.1.4.1.897.4.2.5") != null) {
                                Debug.println(this, "LDAP gave us an ADDRESS_OID for the secondary server");
                                this.populateAddressList(this._secondaryHostportList, haAttribs.get("1.3.6.1.4.1.897.4.2.5"));
                                cfr_temp_0 = 1;
                                continue block21;
                            }
                            Debug.println(this, "LDAP gave us an ADDRESS_ALIAS for the secondary server");
                            cfr_temp_0 = 1;
                            this.populateAddressList(this._secondaryHostportList, haAttribs.get("sybaseAddress"));
                            break;
                        }
                        case 1: {
                            if (e.hasMoreElements()) ** continue;
                            break;
                        }
                        while (true) {
                            propValue = e.nextElement().toString();
                            this._sybProps.parsePropertyString(propValue);
                            cfr_temp_0 = 3;
                            Debug.println(this, "added property: <" + propValue + ">");
                            break;
                        }
                        case 3: {
                            if (e.hasMoreElements()) ** continue;
                            break;
                        }
                    }
                    continue block20;
                } while (true);
            }
        }
        catch (NamingException ne) {
            ErrorMessage.raiseError("JZ013", ne.toString());
            Debug.printStackTrace(this, ne);
            ErrorMessage.raiseError("JZ013", lookupName, ne.toString());
        }
        if (protocolName == null) {
            protocolName = "Tds";
            Debug.println(this, "using default protocol: <" + protocolName + ">");
        }
        Debug.println(this, "loading protocol: <" + protocolName + ">");
        this._protocol = SybUrlManager.loadProtocol(protocolName);
    }

    private void removeDups(Name n1, Name n2) throws InvalidNameException {
        int i = n1.size() - 1;
        while (i >= 0) {
            String v1 = n1.get(i);
            int j = 0;
            while (j < n2.size()) {
                if (v1.equals(n2.get(j))) {
                    Debug.println(this, "ignoring duplicate DN part: " + v1);
                    n1.remove(i);
                    break;
                }
                ++j;
            }
            --i;
        }
    }
}

