/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybResultSet;
import com.sybase.jdbc2.tds.RowFormatToken;
import com.sybase.jdbc2.utils.Debug;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.StringTokenizer;

public class SybLiteral
extends SybResultSet
implements PreparedStatement {
    private static final String LIST_DELIMITER = ",";
    private int _queryType = 0;
    private String _query = null;
    private boolean _atFirstRow = false;
    private String[] _columnList = null;
    RowFormatToken _rowFmt = null;

    public SybLiteral(String sql, int queryType) throws SQLException {
        super(null, null);
        Debug.println(this, "Constructor()");
        this._query = sql;
        this._queryType = queryType;
        Debug.println(this, "query: " + this._query);
        Debug.println(this, "queryType: " + this._queryType);
    }

    public void addBatch() throws SQLException {
        Debug.assert(this, false);
    }

    public void addBatch(String sql) throws SQLException {
        Debug.assert(this, false);
    }

    public void cancel() throws SQLException {
        Debug.println(this, "cancel()");
    }

    public void clearBatch() throws SQLException {
        Debug.assert(this, false);
    }

    public void clearParameters() throws SQLException {
        Debug.assert(this, false);
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        Debug.println(this, "close()");
        this._atFirstRow = false;
        this._columnList = null;
        this._rowFmt = null;
        this._query = null;
    }

    public boolean execute() throws SQLException {
        Debug.assert(this, false);
        return false;
    }

    public boolean execute(String query) throws SQLException {
        Debug.assert(this, false);
        return false;
    }

    public int[] executeBatch() throws SQLException {
        Debug.assert(this, false);
        return null;
    }

    public ResultSet executeQuery() throws SQLException {
        Debug.println(this, "executeQuery " + this._query);
        return this;
    }

    public ResultSet executeQuery(String query) throws SQLException {
        Debug.assert(this, false);
        return null;
    }

    public int executeUpdate() throws SQLException {
        Debug.assert(this, false);
        return 0;
    }

    public int executeUpdate(String query) throws SQLException {
        Debug.assert(this, false);
        return 0;
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Debug.assert(this, this._queryType == 4);
        return this.getColumnValue(columnIndex).trim().equals("1");
    }

    private String getColumnValue(int columnIndex) throws SQLException {
        if (!this._atFirstRow) {
            ErrorMessage.raiseError("JZ0R1");
        }
        if (this._columnList == null || columnIndex < 0 || this._columnList != null && columnIndex > this._columnList.length) {
            ErrorMessage.raiseError("JZ008", String.valueOf(columnIndex));
        }
        return this._columnList[columnIndex - 1];
    }

    public Connection getConnection() throws SQLException {
        Debug.assert(this, false);
        return null;
    }

    public int getInt(int columnIndex) throws SQLException {
        Debug.assert(this, this._queryType == 5);
        return new Integer(this.getColumnValue(columnIndex).trim());
    }

    public int getMaxFieldSize() throws SQLException {
        Debug.assert(this, false);
        return 0;
    }

    public int getMaxRows() throws SQLException {
        Debug.assert(this, false);
        return 0;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._rowFmt;
    }

    public boolean getMoreResults() throws SQLException {
        Debug.assert(this, false);
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        Debug.assert(this, false);
        return 0;
    }

    public ResultSet getResultSet() throws SQLException {
        Debug.assert(this, false);
        return null;
    }

    public int getResultSetConcurrency() throws SQLException {
        Debug.assert(this, false);
        return 0;
    }

    public int getResultSetType() throws SQLException {
        Debug.assert(this, false);
        return 0;
    }

    public String getString(int columnIndex) throws SQLException {
        Debug.assert(this, this._queryType == 6 || this._queryType == 7);
        if (this._queryType == 7) {
            return this._query;
        }
        return this.getColumnValue(columnIndex);
    }

    public int getUpdateCount() throws SQLException {
        Debug.assert(this, false);
        return 0;
    }

    public boolean next() throws SQLException {
        Debug.println(this, "next, _atFirstRow = " + this._atFirstRow);
        if (!this._atFirstRow) {
            this._atFirstRow = true;
            if (this._queryType != 7) {
                this._columnList = SybLiteral.tokenizeList(this._query);
            }
            if (this._columnList != null && this._columnList.length > 0) {
                this._rowFmt = new RowFormatToken(this._columnList.length);
                return true;
            }
        }
        return false;
    }

    public void setArray(int i, Array x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Debug.assert(this, false);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Debug.assert(this, false);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        Debug.assert(this, false);
    }

    public void setClob(int i, Clob x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setCursorName(String name) throws SQLException {
        Debug.assert(this, false);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Debug.assert(this, false);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        Debug.assert(this, false);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        Debug.assert(this, false);
    }

    public void setMaxRows(int max) throws SQLException {
        Debug.assert(this, false);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        Debug.assert(this, false);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Debug.assert(this, false);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        Debug.assert(this, false);
    }

    public void setObject(int parameterIndex, Object obj, int targetSqlType, int scale) throws SQLException {
        Debug.assert(this, false);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        Debug.println(this, "setQueryTimeout()");
    }

    public void setRef(int i, Ref x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Debug.assert(this, false);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        Debug.assert(this, false);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Debug.assert(this, false);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Debug.assert(this, false);
    }

    private static String[] tokenizeList(String list) {
        StringTokenizer tokens = new StringTokenizer(list, LIST_DELIMITER, false);
        if (tokens != null) {
            int count = tokens.countTokens();
            String[] tokenString = new String[count];
            int i = 0;
            while (i < count) {
                tokenString[i] = tokens.nextToken();
                ++i;
            }
            return tokenString;
        }
        return null;
    }
}

