/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsCursor;
import com.sybase.jdbc2.tds.TdsDataInputStream;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.SQLException;

public class CurInfoToken
extends Token {
    private TdsCursor _cursor;
    private int _status;
    private int _command;

    protected CurInfoToken() {
    }

    public CurInfoToken(TdsCursor cursor) throws SQLException {
        this._cursor = cursor;
    }

    public CurInfoToken(TdsProtocolContext tpc) throws IOException {
        int length;
        int curId;
        block15: {
            TdsDataInputStream in = tpc._in;
            this._cursor = tpc._cursor;
            int rows = -1;
            String name = null;
            curId = 0;
            length = 0;
            try {
                length = in.readShort();
                curId = in.readInt();
                if (tpc._cursor._id == 0) {
                    tpc._cursor._id = curId;
                }
                length -= 4;
                if (curId == 0) {
                    int nameLen = in.readUnsignedByte();
                    if (nameLen > 0) {
                        name = in.readString(nameLen);
                        Debug.assert(this, name.equalsIgnoreCase(this._cursor._name));
                    }
                    length -= 1 + nameLen;
                }
                if (length > 0) {
                    this._command = in.readUnsignedByte();
                    --length;
                }
                if (length > 0) {
                    this._status = in.readShort();
                    length -= 2;
                }
                if (length > 0) {
                    rows = in.readInt();
                    length -= 4;
                }
                if (this._command != 3) break block15;
                if ((this._status & 2) != 0) {
                    this._cursor._state = 1;
                }
                if ((this._status & 4) != 0) {
                    this._cursor._state = 2;
                }
                if ((this._status & 0x40) != 0) {
                    this._cursor._state = 3;
                }
                try {
                    if ((this._status & 8) != 0) {
                        this._cursor.setType(1);
                    }
                    if ((this._status & 0x10) != 0) {
                        this._cursor.setType(2);
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (IOException ioe) {
                Token.readSQE(ioe);
            }
        }
        Debug.println(this, "Received " + this.toString());
        Debug.assert(this, curId == 0 || curId == tpc._cursor._id);
        Debug.assert(this, length == 0);
    }

    public boolean isOpen() {
        return (this._status & 2) != 0;
    }

    protected void send(TdsDataOutputStream out, int command, int size) throws IOException {
        this._command = command;
        int length = 7;
        if (command == 1) {
            this._status = 32;
            length = 11;
        } else {
            this._status = 0;
        }
        Debug.println(this, "Send " + this.toString() + (command == 1 ? ", RowSize= " + size : ""));
        byte[] cvtName = null;
        int nameLen = 0;
        if (this._cursor._id == 0) {
            cvtName = out.stringToByte(this._cursor.getName());
            nameLen = cvtName.length;
            length += 1 + nameLen;
        }
        try {
            out.writeByte(131);
            out.writeShort(length);
            out.writeInt(this._cursor._id);
            if (this._cursor._id == 0) {
                out.writeByte(nameLen);
                out.write(cvtName);
            }
            out.writeByte(this._command);
            out.writeShort(this._status);
            if (command == 1) {
                out.writeInt(size);
            }
        }
        catch (IOException ioe) {
            Token.writeSQE(ioe);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("CurInfoToken: ");
        s.append(this._cursor._id == 0 ? "curId= " + this._cursor._id : "name= " + this._cursor.getName());
        s.append(", command= " + this._command);
        s.append(", status= " + this._status);
        return s.toString();
    }
}

