/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.SQLException;

public class DynamicToken
extends Token {
    public static final int PREPARE = 1;
    public static final int EXEC = 2;
    public static final int DEALLOC = 4;
    public static final int EXEC_IMMED = 8;
    public static final int PROCNAME = 16;
    public static final int ACK = 32;
    public static final int DESCIN = 64;
    public static final int DESCOUT = 128;
    private static final int UNUSED = 0;
    private static final int HASARGS = 1;
    public static final int MAX_DYNAMIC_LENGTH = Short.MAX_VALUE;
    protected long _totalLen;
    protected long _totalOutLen;
    protected int _type;
    protected int _status;
    protected String _name;
    protected int _nameLen;
    protected String _body;
    protected long _bodyLen;

    protected DynamicToken() {
    }

    public DynamicToken(int type, String name, String body, boolean hasParams) throws SQLException {
        switch (type) {
            case 1: {
                Debug.assert(this, body != null);
            }
            case 2: 
            case 4: {
                Debug.assert(this, name != null && name.length() <= 10);
                break;
            }
            default: {
                Debug.assert(this, false);
            }
        }
        this._type = type;
        this._name = name;
        this._body = body;
        this._status = hasParams ? 1 : 0;
    }

    public DynamicToken(TdsInputStream in) throws IOException {
        try {
            this._totalLen = this.readLength(in);
            this._type = in.readUnsignedByte();
            this._status = in.readUnsignedByte();
            this._nameLen = in.readUnsignedByte();
            this._name = in.readString(this._nameLen);
            long checkLen = this._totalLen - (long)(3 + this._nameLen);
            if (checkLen < 2L) {
                Debug.assert(this, checkLen == 0L);
                this._body = null;
                this._bodyLen = 0L;
            } else {
                this.readBodyLength(in);
            }
            Debug.println(this, this.toString());
        }
        catch (IOException ioe) {
            Token.readSQE(ioe);
        }
    }

    protected int getStatementLengthFieldSize() {
        return 2;
    }

    protected void readBodyLength(TdsInputStream in) throws IOException {
        this._bodyLen = in.readShort();
        this._body = in.readString((int)this._bodyLen);
        Debug.assert(this, this._totalLen == (long)this._nameLen + this._bodyLen + 5L);
    }

    protected long readLength(TdsInputStream in) throws IOException {
        long len = in.readShort();
        return len;
    }

    public void send(TdsDataOutputStream out) throws IOException {
        try {
            Tds tds = out._tds;
            this.sendTokenName(out);
            byte[] nameString = out.stringToByte(this._name);
            byte[] bodyString = out.stringToByte(this._body);
            this._totalOutLen = 3 + nameString.length;
            if (this._type != 32) {
                this._totalOutLen += (long)this.getStatementLengthFieldSize();
                if (bodyString != null) {
                    this._totalOutLen += (long)bodyString.length;
                }
            }
            this.sendTotalLength(out);
            out.writeByte(this._type);
            out.writeByte(this._status);
            out.writeByte(nameString.length);
            out.write(nameString);
            if (this._type != 32) {
                if (bodyString == null) {
                    this.sendBodyLength(0L, out);
                } else {
                    this.sendBodyLength(bodyString.length, out);
                    out.write(bodyString);
                }
            }
        }
        catch (IOException ioe) {
            Token.writeSQE(ioe);
        }
    }

    protected void sendBodyLength(long len, TdsOutputStream out) throws IOException {
        out.writeShort((int)len);
    }

    protected void sendTokenName(TdsOutputStream out) throws IOException {
        out.writeByte(231);
    }

    protected void sendTotalLength(TdsOutputStream out) throws IOException {
        out.writeShort((int)this._totalOutLen);
    }

    public String toString() {
        String type;
        switch (this._type) {
            case 1: {
                type = "PREPARE";
                break;
            }
            case 2: {
                type = "EXEC";
                break;
            }
            case 4: {
                type = "DEALLOC";
                break;
            }
            case 32: {
                type = "ACK";
                break;
            }
            default: {
                type = "Unknown!";
            }
        }
        return "DYNAMIC: type(" + this._type + ")=" + type + " name: >" + this._name + "< body: >" + this._body + ((this._status & 1) != 0 ? "< (Params)" : "< (No params)");
    }
}

