/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;

public class RowDataFormat2
extends DataFormat {
    protected String _labelName;
    protected int _labelLen;
    protected String _catalogName;
    protected int _catalogLen;
    protected String _schemaName;
    protected int _schemaLen;
    protected int _tableLen;

    protected RowDataFormat2() {
    }

    public RowDataFormat2(TdsInputStream in) throws IOException {
        super(in, true);
    }

    public RowDataFormat2(TdsInputStream in, boolean locale) throws IOException {
        super(in, locale);
    }

    public int length() {
        int sum = super.length();
        return sum += 7 + (this._labelName == "" ? 0 : this._labelName.length()) + (this._catalogName == null ? 0 : this._catalogName.length()) + (this._schemaName == null ? 0 : this._schemaName.length()) + (this._tableName == null ? 0 : this._tableName.length());
    }

    protected void readMetaInfo(TdsInputStream in) throws IOException {
        try {
            this._labelLen = in.readUnsignedByte();
            if (this._labelLen > 0) {
                Debug.println(this, "reading a labelName of length " + this._labelLen);
                this._labelName = in.readString(this._labelLen);
                Debug.println(this, "The labelName is " + this._labelName);
            } else {
                Debug.println(this, "LabelName was empty. Will reset it to the value that we get for ColumnName");
                this._labelName = "";
            }
            this._catalogLen = in.readUnsignedByte();
            if (this._catalogLen > 0) {
                Debug.println(this, "reading a catalogName of length " + this._catalogLen);
                this._catalogName = in.readString(this._catalogLen);
                Debug.println(this, "The catalogName is " + this._catalogName);
            } else {
                Debug.println(this, "Setting catalogName to \"\"");
                this._catalogName = "";
            }
            this._schemaLen = in.readUnsignedByte();
            if (this._schemaLen > 0) {
                Debug.println(this, "reading a schemaName of length " + this._schemaLen);
                this._schemaName = in.readString(this._schemaLen);
                Debug.println(this, "The schemaName is " + this._schemaName);
            } else {
                Debug.println(this, "Setting schemaName to \"\"");
                this._schemaName = "";
            }
            this._tableLen = in.readUnsignedByte();
            if (this._tableLen > 0) {
                Debug.println(this, "reading a tableName of length " + this._tableLen);
                this._tableName = in.readString(this._tableLen);
                Debug.println(this, "The tableName is " + this._tableName);
            } else {
                Debug.println(this, "Setting tableName to \"\"");
                this._tableName = "";
            }
            this._nameLen = in.readUnsignedByte();
            if (this._nameLen > 0) {
                Debug.println(this, "reading a column name of length " + this._nameLen);
                this._name = in.readString(this._nameLen);
                Debug.println(this, "The columnName is " + this._name);
                if (this._labelName == "") {
                    this._labelName = this._name;
                    this._labelLen = this._nameLen;
                    Debug.println("Since label name was empty, we are setting it to the columnName value of " + this._name);
                }
            } else {
                Debug.println(this, "Setting columnName to \"\"");
                this._name = "";
            }
        }
        catch (IOException ioe) {
            Token.readSQE(ioe);
        }
    }

    protected void readStatus(TdsInputStream in) throws IOException {
        this._status = in.readInt();
    }

    protected void sendMetaInfo(TdsOutputStream out) throws IOException {
        byte[] cvtString;
        if (this._labelName == "") {
            out.writeByte(0);
        } else {
            cvtString = out.stringToByte(this._labelName);
            out.writeByte(cvtString.length);
            out.write(cvtString);
        }
        if (this._catalogName == "") {
            out.writeByte(0);
        } else {
            cvtString = out.stringToByte(this._catalogName);
            out.writeByte(cvtString.length);
            out.write(cvtString);
        }
        if (this._schemaName == "") {
            out.writeByte(0);
        } else {
            cvtString = out.stringToByte(this._schemaName);
            out.writeByte(cvtString.length);
            out.write(cvtString);
        }
        if (this._tableName == "") {
            out.writeByte(0);
        } else {
            cvtString = out.stringToByte(this._tableName);
            out.writeByte(cvtString.length);
            out.write(cvtString);
        }
        if (this._name == "") {
            out.writeByte(0);
        } else {
            cvtString = out.stringToByte(this._name);
            out.writeByte(cvtString.length);
            out.write(cvtString);
        }
    }

    protected void sendStatus(TdsOutputStream out) throws IOException {
        out.writeInt(this._status);
    }
}

