/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.SybCallableStatement;
import com.sybase.jdbc2.tds.EventThread;
import com.sybase.jdbc2.tds.EventToken;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.timedio.OutStreamMgr;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbcx.SybEventHandler;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Hashtable;

public class TdsEventContext
extends TdsProtocolContext {
    private Thread _runner = null;
    private EventThread _evtThrd = null;
    private Hashtable _events;

    public TdsEventContext(Protocol p, InStreamMgr inMgr, OutStreamMgr outMgr) throws SQLException {
        super(p, inMgr, outMgr);
        inMgr.setEventContext(this);
    }

    protected void addHandler(String name, SybEventHandler hdlr, int option) throws SQLException {
        this.checkEventTable();
        this._events.put(name, hdlr);
        SybCallableStatement cs = (SybCallableStatement)this._conn.prepareCall("{call sp_regwatch(?, ?)}");
        cs.setString(1, name);
        short opt = (short)(option | 0x40);
        cs.setShort(2, opt);
        Debug.println(this, "call sp_regwatch(" + name + ", " + opt + ")");
        cs.executeUpdate();
        cs.close();
    }

    public void beginRequest() {
        Debug.println(this, "beginRequest(), _state = " + this._state);
        this.close(false);
        this.setState(2);
    }

    protected boolean checkBufStat(int status) {
        if ((status & 8) == 0) {
            this._pduState = 4;
            return true;
        }
        return false;
    }

    private synchronized void checkEventTable() throws SQLException {
        if (this._events == null) {
            this._evtThrd = new EventThread(this);
            this._runner = new Thread(this._evtThrd);
            try {
                this._runner.start();
            }
            catch (IllegalThreadStateException itse) {
                ErrorMessage.raiseError("JZ0H0", itse.toString());
            }
            this._events = new Hashtable();
        }
    }

    public void drop() {
        if (this._runner != null) {
            this._runner.stop();
            try {
                this._runner.join(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        super.drop();
    }

    protected void dropHandler(String name) throws SQLException {
        this.checkEventTable();
        CallableStatement cs = this._conn.prepareCall("{call sp_regnowatch(?)}");
        cs.setString(1, name);
        cs.executeUpdate();
        this._events.remove(name);
    }

    protected SybEventHandler getHandler(String procName) throws SQLException {
        Debug.println(this, "getHandler()");
        this.checkEventTable();
        SybEventHandler hdlr = (SybEventHandler)this._events.get(procName);
        if (hdlr == null) {
            this.close(false);
            ErrorMessage.raiseError("JZ0H1", procName);
        }
        Debug.println(this, String.valueOf(procName) + " has event");
        return hdlr;
    }

    protected String getProcName() throws SQLException {
        Debug.println(this, "getProcName()");
        String procName = null;
        int nextRes = this._protocol.nextResult(this);
        Debug.assert(this, nextRes == 3);
        if (this._lastTds == 162) {
            try {
                Debug.println(this, "See event");
                EventToken et = new EventToken(this._in);
                procName = et._name;
                this._lastResult = -1;
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.toString());
            }
        } else {
            this._protocol.ungetResult(this, this._lastTds);
            ErrorMessage.raiseError("JZ0P4");
        }
        return procName;
    }

    public int responseState() {
        if (this._pduState == 0) {
            if (this._evtThrd != null) {
                EventThread eventThread = this._evtThrd;
                synchronized (eventThread) {
                    ++this._evtThrd._eventCount;
                    if (this._evtThrd._threadState) {
                        this._evtThrd.notify();
                    }
                }
            }
            this._pduState = 6;
        }
        return this._pduState;
    }
}

