/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.SybBigDecimal;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class TdsNumeric {
    private static final int[] NUME_PREC_TO_LEN = new int[]{-1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12, 12, 13, 13, 14, 14, 14, 15, 15, 16, 16, 16, 17, 17, 18, 18, 19, 19, 19, 20, 20, 21, 21, 21, 22, 22, 23, 23, 24, 24, 24, 25, 25, 26, 26, 26, 27, 27, 28, 28, 28, 29, 29, 30, 30, 31, 31, 31, 32, 32, 33, 33, 33};
    private static final int NUME_MAXPREC = NUME_PREC_TO_LEN.length - 1;
    private static final int NUME_BASEBITS = 8;
    protected static final int NUME_USERPREC = 38;
    private static final int NUME_MAXLEN = 33;
    private static final int NUME_NULLSCALE = 19;
    private static final BigDecimal D_ZERO = BigDecimal.valueOf(0L, 0);
    private static final BigDecimal NEGATIVE_ONE = BigDecimal.valueOf(-1L, 0);
    private static final BigDecimal MAX_NUMERIC = new BigDecimal("99999999999999999999999999999999999999");
    private static final BigDecimal MIN_NUMERIC = new BigDecimal("-99999999999999999999999999999999999999");

    private TdsNumeric() {
    }

    public static void checkRange(BigDecimal n) throws SQLException {
        BigDecimal unScaled = n.movePointRight(n.scale());
        if (MAX_NUMERIC.compareTo(unScaled) < 0 || MIN_NUMERIC.compareTo(unScaled) > 0) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    protected static BigDecimal numericValue(byte[] numeval, int precision, int scale) throws IOException {
        if (numeval == null) {
            return null;
        }
        int length = numeval.length;
        Debug.assert(null, precision > 0 && precision <= NUME_MAXPREC);
        Debug.assert(null, scale >= 0 && scale <= precision);
        int minLength = NUME_PREC_TO_LEN[precision];
        Debug.assert(null, length >= minLength, "length too small for given precision " + length + ", " + precision);
        int sign = numeval[0] == 0 ? 1 : -1;
        numeval[0] = 0;
        byte[] numCopy = numeval;
        if (length > minLength) {
            if (minLength > (length + 1) / 2) {
                Debug.assert(null, false);
                ErrorMessage.raiseIOException("JZ00B");
            }
            boolean shiftLeft = true;
            int i = length - 1;
            while (i >= minLength) {
                if (numeval[i] != 0) {
                    shiftLeft = false;
                    break;
                }
                --i;
            }
            if (shiftLeft) {
                numCopy = new byte[minLength];
                System.arraycopy(numeval, 0, numCopy, 0, minLength);
            }
        }
        Debug.println(null, "to BigDecimal length = " + length + " minLength = " + minLength + " precision = " + precision + " scale = " + scale + " sign = " + sign);
        BigDecimal bd = new BigDecimal(new BigInteger(sign, numCopy), scale);
        numeval[0] = (byte)(sign != 1 ? 1 : 0);
        return bd;
    }

    protected static byte[] tdsNumeric(BigDecimal bd, int[] dataInfo) throws IOException {
        int scale;
        if (bd == null) {
            dataInfo[1] = 33;
            dataInfo[2] = 38;
            dataInfo[3] = 19;
            return null;
        }
        if (MAX_NUMERIC.compareTo(bd) < 0 || MIN_NUMERIC.compareTo(bd) > 0) {
            ErrorMessage.raiseIOException("JZ00B");
        }
        boolean sign = false;
        if (bd.compareTo(D_ZERO) < 0) {
            sign = true;
        }
        int precision = -1;
        if (bd instanceof SybBigDecimal) {
            scale = ((SybBigDecimal)bd)._scale;
            precision = ((SybBigDecimal)bd)._precision;
            Debug.println(null, "User specified prec/scale " + precision + " / " + scale);
        } else {
            scale = bd.scale();
        }
        dataInfo[3] = scale;
        BigInteger bi = TdsNumeric.unscale(bd, scale);
        byte[] value = bi.toByteArray();
        int valuePrec = bi.toString().length();
        int length = 0;
        if (precision >= valuePrec) {
            length = NUME_PREC_TO_LEN[precision];
        } else {
            Debug.assert(null, precision == -1);
            precision = valuePrec;
            if (precision < scale) {
                precision = scale;
            }
            length = NUME_PREC_TO_LEN[precision];
        }
        if (length <= 2) {
            ++length;
        }
        byte[] tdsnum = new byte[length];
        System.arraycopy(value, 0, tdsnum, length - value.length, value.length);
        tdsnum[0] = (byte)(sign ? 1 : 0);
        dataInfo[2] = precision;
        dataInfo[1] = tdsnum.length;
        Debug.assert(null, precision >= scale);
        Debug.println(null, "NUMERIC( " + precision + ", " + scale + ") with data length of " + length + " created.");
        return tdsnum;
    }

    protected static BigInteger unscale(BigDecimal n, int scale) {
        if (n.compareTo(D_ZERO) < 0) {
            n = n.multiply(NEGATIVE_ONE);
        }
        return n.movePointRight(scale).toBigInteger();
    }
}

