/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.tds.CapabilitySet;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsParam
extends Param {
    private static final String NULL = "null";
    private static final String ZERO = "0";
    private static final String QUOTE = "'";
    private static final String HEX_START = "0x";
    private static final String ASCII_ENCODING = "ISO8859_1";
    protected DataFormat _inDataFmt;
    byte[] _cvtString = null;
    protected String _parameterAsAString = null;
    protected boolean _parameterHoldsUnicharData = false;
    protected TdsDataOutputStream _tdos = null;

    protected TdsParam() {
    }

    public TdsParam(TdsDataOutputStream tdos) {
        this._tdos = tdos;
    }

    protected void clear(boolean all) throws IOException {
        this._sendAsLiteral = false;
        this._cvtString = null;
        this._parameterAsAString = null;
        if (all) {
            this._sqlType = -999;
            this._regType = -999;
            this._inValue = null;
            this._scale = -999;
        }
        if (this._outValue != null) {
            ((TdsJdbcInputStream)this._outValue).clear();
            this._outValue = null;
        }
    }

    protected int getCharCount() throws IOException {
        Debug.assert(this, this._inValue instanceof InputStream);
        InputStream is = (InputStream)this._inValue;
        int length = this._scale;
        if (this._scale == -1) {
            length = is.available();
            length /= 2;
        }
        return length;
    }

    protected int getLength() {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            return this._inDataFmt.length();
        }
        return 0;
    }

    protected String getStringFromStream(int maxFieldSize) throws IOException {
        InputStream is = (InputStream)this._inValue;
        StringBuffer text = new StringBuffer();
        Debug.assert(this, this._scale == -1 || this._scale % 2 == 0);
        int length = this._scale;
        if (length != -1 && length % 2 != 0) {
            --length;
        }
        while (length != 0) {
            int b2;
            int b1 = is.read();
            if (b1 == -1 || (b2 = is.read()) == -1) break;
            char c = (char)(b1 << 8 | b2);
            text.append(c);
            length -= 2;
        }
        return text.toString();
    }

    public String literalValue(Protocol p, int id, int maxFieldSize) throws IOException {
        Tds tds = (Tds)p;
        switch (this._sqlType) {
            case -7: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return (Boolean)this._inValue != false ? "1" : ZERO;
            }
            case -6: 
            case 4: 
            case 5: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Integer)this._inValue).toString();
            }
            case -5: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Long)this._inValue).toString();
            }
            case 2: 
            case 3: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((BigDecimal)this._inValue).toString();
            }
            case 7: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Float)this._inValue).toString();
            }
            case 6: 
            case 8: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                StringBuffer text = new StringBuffer("convert(float(32), ");
                text.append(((Double)this._inValue).toString());
                text.append(")");
                return text.toString();
            }
            case 91: 
            case 92: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return QUOTE + ((DateObject)this._inValue).format(false) + QUOTE;
            }
            case 93: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return QUOTE + ((DateObject)this._inValue).format(true) + QUOTE;
            }
            case -1: 
            case 1: 
            case 12: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                StringBuffer text = null;
                if (this._inValue instanceof String) {
                    Debug.println(this, "expanding an String to a literal");
                    int length = ((String)this._inValue).length();
                    text = new StringBuffer(length + 2);
                    text.append(QUOTE);
                    text.append(((String)this._inValue).substring(0, length));
                } else if (this._inValue instanceof InputStream) {
                    int length = this.getCharCount();
                    Debug.println(this, "expanding an InputStream to String");
                    text = new StringBuffer(length + 2);
                    text.append(QUOTE);
                    text.append(this.getStringFromStream(maxFieldSize));
                } else if (this._inValue instanceof Reader) {
                    int[] dataInfo = new int[4];
                    this._tdos.convertString(this, dataInfo);
                    text = new StringBuffer(dataInfo[1] + 2);
                    text.append(QUOTE);
                    text.append(this._parameterAsAString);
                } else {
                    Debug.assert(this, false);
                }
                int nextQuote = 1;
                int length = text.length();
                while ((nextQuote = text.toString().indexOf(39, nextQuote)) != -1) {
                    text.insert(nextQuote, '\'');
                    if ((nextQuote += 2) <= ++length) continue;
                }
                text.append(QUOTE);
                return text.toString();
            }
            case -4: 
            case -3: 
            case -2: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                if (this._inValue instanceof byte[]) {
                    Debug.println(this, "expanding a byte[] to hexLiteral");
                    return HEX_START + HexConverts.hexConvert((byte[])this._inValue);
                }
                Debug.assert(this, this._inValue instanceof InputStream);
                Debug.println(this, "expanding an InputStream to hexLiteral");
                InputStream is = (InputStream)this._inValue;
                int length = this._scale;
                if (this._scale == -1) {
                    length = is.available();
                }
                byte[] toSend = new byte[length];
                int i = 0;
                while (i < length) {
                    int bytesRead = is.read(toSend, i, length - i);
                    if (bytesRead == -1) break;
                    i += bytesRead;
                }
                return HEX_START + HexConverts.hexConvert(toSend);
            }
            case 2000: {
                if (!this._sendAsLiteral) break;
                ErrorMessage.raiseIOException("JZ0ST");
                break;
            }
        }
        return "@p" + id;
    }

    protected boolean makeFormat(Protocol p) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            this._inDataFmt = new DataFormat(this, ((Tds)p)._out);
            return true;
        }
        return false;
    }

    protected void prepareForSend(Protocol protocol, int i, boolean isRPC) throws SQLException {
        Tds tds = (Tds)protocol;
        CapabilitySet reqCaps = tds._capT._reqCaps;
        Debug.println(this, "prepareForSend " + i + " _sqlType " + this._sqlType + " _regType " + this._regType + " _inValue " + this._inValue + " isRPC " + isRPC);
        if (this._sqlType == -999) {
            this._inValue = null;
            this._sqlType = this._regType;
        }
        if (this._sqlType == -999) {
            ErrorMessage.raiseError("JZ0SA", String.valueOf(i));
        }
        switch (this._regType) {
            case -4: {
                if (tds._sendLongAnyway) {
                    this._sendAsLiteral = false;
                }
            }
            case -1: {
                this._sqlType = this._regType;
                break;
            }
        }
        if (!isRPC && tds._sendLiterals) {
            this._sendAsLiteral = true;
            return;
        }
        switch (this._sqlType) {
            case -5: {
                if (reqCaps.get(51)) break;
                if (this._inValue != null) {
                    Debug.println(this, "no 8-byte int support, converting...");
                    long value = (Long)this._inValue;
                    if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                        Debug.println(this, "value = " + value + " to NUMERIC");
                        this._inValue = new BigDecimal(String.valueOf(value));
                        this._sqlType = 2;
                        if (reqCaps.get(24)) break;
                        this._sendAsLiteral = true;
                        break;
                    }
                    Debug.println(this, "value = " + value + " to INTEGER");
                    this._inValue = new Integer((int)value);
                }
                this._sqlType = 4;
            }
            case 4: {
                if (reqCaps.get(12)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -7: {
                if (reqCaps.get(13)) break;
                if (this._inValue != null) {
                    this._inValue = new Integer((Boolean)this._inValue != false ? 1 : 0);
                }
                this._sqlType = -6;
            }
            case -6: {
                if (this._inValue != null && (Integer)this._inValue >= 0 && reqCaps.get(10)) break;
                this._sqlType = 5;
            }
            case 5: {
                if (reqCaps.get(11)) break;
                this._sqlType = 4;
                if (reqCaps.get(12)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (this._sqlType == 1 || this._sqlType == 12 || this._inValue == null) {
                    int[] dataInfo = new int[4];
                    try {
                        this._tdos.convertString(this, dataInfo);
                        if (this._parameterHoldsUnicharData) {
                            break;
                        }
                    }
                    catch (IOException ioe) {
                        ErrorMessage.raiseError("JZ006", ioe.toString());
                    }
                    if (dataInfo[1] <= 255) {
                        if (this._sqlType == 1 && reqCaps.get(14)) break;
                        if (reqCaps.get(15)) {
                            this._sqlType = 12;
                            break;
                        }
                    }
                }
                Debug.println(this, "Either the server has no char or varchar support, or the converted string is too long to send as a VARCHAR. Trying LONGVARCHAR.");
                if (this._tdos._tds.isUnicharEnabled() && (!(this._inValue instanceof Reader) || this._inValue instanceof InputStreamReader && !((InputStreamReader)this._inValue).getEncoding().equals(ASCII_ENCODING))) break;
                if ((this._inValue instanceof InputStream || this._inValue instanceof Reader) && reqCaps.get(55)) {
                    if (this._scale != -1 && this._scale <= 255 && reqCaps.get(15)) {
                        this._sqlType = 12;
                        break;
                    }
                    this._sqlType = 9219;
                    break;
                }
                if (reqCaps.get(28) && this.sendingLongcharIsOK(protocol)) {
                    Debug.println(this, "Server supports LONGCHAR, so we're sending the string as a LONGCHAR.");
                    this._sqlType = -1;
                    break;
                }
                if (reqCaps.get(55)) {
                    Debug.println(this, "Server supports BLOBs of sub-type STREAMCHAR, so we're sending this string inside a BLOB.");
                    ByteArrayInputStream bi = null;
                    try {
                        byte[] tempArray = this._parameterAsAString.getBytes("Unicode");
                        byte[] correctedArray = new byte[tempArray.length - 2];
                        System.arraycopy(tempArray, 2, correctedArray, 0, tempArray.length - 2);
                        bi = new ByteArrayInputStream(correctedArray);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Debug.assert(this, false);
                    }
                    this._sqlType = 9219;
                    this._inValue = bi;
                    this._scale = this._parameterAsAString.length();
                    break;
                }
                Debug.println(this, "Server capabilities left us no choice but to send as a literal.");
                this._sendAsLiteral = true;
                break;
            }
            case -4: {
                Debug.println(this, "LONGBINARY Param, reqCaps = " + reqCaps.get(57));
                if (this._inValue instanceof InputStream && reqCaps.get(57)) {
                    this._sqlType = 9220;
                    break;
                }
                if (reqCaps.get(29) && this.sendingLongbinIsOK(protocol) || tds._sendLongAnyway) break;
                this._sendAsLiteral = true;
                break;
            }
            case -2: {
                if (reqCaps.get(16)) break;
                this._sqlType = -3;
            }
            case -3: {
                if (reqCaps.get(17)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 3: {
                if (reqCaps.get(27)) break;
                this._sqlType = 2;
            }
            case 2: {
                if (reqCaps.get(24)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 7: {
                if (reqCaps.get(22)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 6: 
            case 8: {
                if (reqCaps.get(23)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (reqCaps.get(20)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 2000: {
                if (reqCaps.get(54) && !this._sendAsLiteral) break;
                ErrorMessage.raiseError("JZ0ST");
                break;
            }
        }
        Debug.println(this, "Parameter " + i + " has input set to type " + this._sqlType + ", output registered for type " + this._regType);
        if (isRPC && this._sendAsLiteral) {
            ErrorMessage.raiseError("JZ0SM");
        }
    }

    protected void send(OutputStream out, int maxFieldSize) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            ((TdsDataOutputStream)out).writeParam(this, maxFieldSize);
        }
    }

    protected void sendFormat(DataOutput out) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            this._inDataFmt.send((TdsOutputStream)out);
        }
    }

    private boolean sendingLongbinIsOK(Protocol p) throws SQLException {
        int maxLongVarbinaryLength;
        boolean returnVal = true;
        boolean specialCase = false;
        int numBytesToSend = 0;
        if (this._inValue != null) {
            if (this._inValue instanceof byte[]) {
                numBytesToSend = ((byte[])this._inValue).length;
            } else if (this._inValue instanceof InputStream) {
                if (this._scale == -1) {
                    specialCase = true;
                } else {
                    numBytesToSend = this._scale;
                }
            } else {
                Debug.assert(null, false);
            }
        }
        if (numBytesToSend > (maxLongVarbinaryLength = ((Tds)p).getMaxLongvarbinaryLength()) || specialCase && maxLongVarbinaryLength != Integer.MAX_VALUE) {
            returnVal = false;
        }
        return returnVal;
    }

    private boolean sendingLongcharIsOK(Protocol p) throws SQLException {
        boolean returnVal = true;
        int[] dataInfo = new int[4];
        try {
            this._tdos.convertString(this, dataInfo);
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.toString());
        }
        int maxLongvarcharLength = ((Tds)p).getMaxLongvarcharLength();
        if (dataInfo[1] > maxLongvarcharLength) {
            returnVal = false;
        }
        return returnVal;
    }

    protected byte[] stringToUnicodeBytes(String s) {
        byte[] correctedArray = null;
        try {
            byte[] tempArray = this._parameterAsAString.getBytes("Unicode");
            correctedArray = new byte[tempArray.length - 2];
            System.arraycopy(tempArray, 2, correctedArray, 0, tempArray.length - 2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.assert(this, false);
        }
        return correctedArray;
    }
}

