/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.RowFormatToken;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsInt;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.tds.TdsReal;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class TdsResultSet
implements ProtocolResultSet {
    protected TdsProtocolContext _tpc = null;
    protected int _rowCount = 0;
    protected boolean _needNext = true;
    protected SQLWarning _warning;
    protected TdsDataObject[] _columns;
    private RowFormatToken _rowfmt;
    private int _totalColumns = -1;
    private Vector _cachedRows = null;
    private int _rowIndex = 0;
    private boolean _dead = false;
    private int _type = 1003;
    private boolean _scrolling = false;
    private TdsDataObject[] _savedCols = null;

    protected TdsResultSet(TdsProtocolContext tpc) throws SQLException {
        this._tpc = tpc;
        Debug.assert(this, tpc._paramFmts != null);
        this._rowfmt = tpc._paramFmts;
        this._rowfmt.setPc(tpc);
        this._totalColumns = this._rowfmt._numColumns;
        this._columns = new TdsDataObject[this._totalColumns];
        TdsDataObject prev = null;
        Debug.println(this, "creating " + this._totalColumns + " TdsDataObjects for new result set");
        try {
            int i = 0;
            while (i < this._totalColumns) {
                DataFormat df = this._rowfmt.getDataFormat(i);
                switch (df._datatype) {
                    case 38: 
                    case 48: 
                    case 52: 
                    case 56: {
                        this._columns[i] = new TdsInt(tpc);
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        this._columns[i] = new TdsReal(tpc);
                        break;
                    }
                    default: {
                        this._columns[i] = new TdsJdbcInputStream(tpc, (Tds)tpc._protocol);
                    }
                }
                this._columns[i]._dataFmt = df;
                this._columns[i].setPrevious(prev);
                if (prev != null) {
                    prev.setNext(this._columns[i]);
                }
                prev = this._columns[i];
                ++i;
            }
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
    }

    public void absolute(int row) {
        Debug.println(this, "absolute(" + row + ")");
        Debug.assert(this, this._scrolling, "absolute can only be used with scrollable result sets.");
        Debug.assert(this, row >= 0, "negative row numbers are not valid for absolute()");
        Debug.println(this, "Index = " + this._rowIndex);
        Debug.assert(this, row <= this._cachedRows.size(), "tried to retrieve a row before it was cached.");
        if (this._rowIndex != row && row != 0) {
            this._rowIndex = row;
            this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
        }
    }

    private void cacheCurrentRow() throws SQLException {
        TdsDataObject[] cachedCols = new TdsDataObject[this._totalColumns];
        try {
            int i = 0;
            while (i < this._totalColumns) {
                cachedCols[i] = this._columns[i].createCachedCopy();
                ++i;
            }
            Debug.println(this, "adding row " + this._rowIndex + " to the cache at the end of next().");
            this._cachedRows.insertElementAt(cachedCols, this._rowIndex - 1);
            this._savedCols = this._columns;
            this._columns = cachedCols;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
    }

    public void clearWarnings() throws SQLException {
        Debug.println(this, "clearing warnings");
        this._warning = null;
    }

    public void close(boolean cancelling) throws SQLException {
        Debug.println(this, "close(" + cancelling + ")");
        if (this._dead) {
            return;
        }
        if (this._scrolling) {
            this._scrolling = false;
            this._columns = this._savedCols;
        }
        if (!cancelling) {
            while (this.next()) {
            }
        }
        this.markDead();
    }

    protected void dump() {
    }

    public int findColumn(String columnName) throws SQLException {
        int userIndex = 0;
        int i = 0;
        while (i < this._rowfmt._numColumns) {
            if ((this._rowfmt.getStatus(i) & 1) == 0) {
                ++userIndex;
                Debug.println(this, "comparing to " + this._rowfmt.getName(i));
                if (this._rowfmt.getName(i).equalsIgnoreCase(columnName)) {
                    return userIndex;
                }
            }
            ++i;
        }
        ErrorMessage.raiseError("S0022", columnName);
        return -1;
    }

    public int findColumnByLabel(String columnName) throws SQLException {
        int userIndex = 0;
        int i = 0;
        while (i < this._rowfmt._numColumns) {
            if ((this._rowfmt.getStatus(i) & 1) == 0) {
                ++userIndex;
                Debug.println(this, "comparing to " + this._rowfmt.getLabel(i));
                if (this._rowfmt.getLabel(i).equalsIgnoreCase(columnName)) {
                    return userIndex;
                }
            }
            ++i;
        }
        ErrorMessage.raiseError("S0022", columnName);
        return -1;
    }

    public JdbcDataObject getColumn(int columnIndex) throws SQLException {
        Debug.println(this, "getColumn " + columnIndex);
        if (this._needNext && !this._scrolling) {
            ErrorMessage.raiseError("JZ0R1");
        }
        int column = this._rowfmt.mapColumn(columnIndex);
        return this._columns[column];
    }

    public int getCount() throws SQLException {
        return this._rowCount;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._rowfmt;
    }

    public int getNumRowsCached() {
        return this._scrolling ? this._cachedRows.size() : 0;
    }

    public int getType() {
        return this._type;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._warning;
    }

    protected void handleSQLE(SQLException sqe) throws SQLException {
        boolean foundAnException = SybConnection.thisChainHasAnException(sqe);
        SQLWarning w = null;
        w = !foundAnException ? (SQLWarning)sqe : SybConnection.getAllTheWarnings(sqe);
        if (w != null) {
            if (this._warning == null) {
                this._warning = w;
            } else {
                this._warning.setNextWarning(w);
            }
        }
        if (foundAnException) {
            throw sqe;
        }
        Debug.println(this, ">>> Only Warnings");
    }

    protected synchronized void markDead() {
        this._dead = true;
    }

    public boolean next() throws SQLException {
        Debug.println(this, "next()");
        if (this._scrolling) {
            Debug.println(this, "Index = " + this._rowIndex);
            Debug.println(this, "Count = " + this._cachedRows.size());
            if (this._rowIndex < this._cachedRows.size()) {
                ++this._rowIndex;
                Debug.println(this, "CACHE READ. assigning columns from row cache.");
                this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
                return true;
            }
            if (this._dead) {
                Debug.println(this, "called next() on dead.");
                ++this._rowIndex;
                return false;
            }
        }
        if (!this._needNext) {
            this._tpc._lastResult = -1;
            try {
                if (this._scrolling) {
                    this._columns = this._savedCols;
                }
                int i = 0;
                while (i < this._totalColumns) {
                    this._columns[i].clear();
                    ++i;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
        }
        int result = this.nextResult();
        Debug.println(this, "get nextResult = " + result);
        switch (result) {
            case 209: {
                Debug.println(this, "Got a Row");
                ++this._rowIndex;
                ++this._rowCount;
                if (this._scrolling) {
                    this.cacheCurrentRow();
                }
                this._needNext = false;
                return true;
            }
            case 5: {
                this._rowCount = this._tpc._protocol.count(this._tpc);
                ++this._rowIndex;
                this.markDead();
                return false;
            }
        }
        this._tpc._protocol.ungetResult(this._tpc, result);
        this.markDead();
        return false;
    }

    protected int nextResult() throws SQLException {
        int result;
        while (true) {
            try {
                result = this._tpc._protocol.nextResult(this._tpc);
            }
            catch (SQLException sqe) {
                this.handleSQLE(sqe);
                continue;
            }
            break;
        }
        return result;
    }

    protected void prepareForNextFetch() {
        Debug.println(this, "prepareForNextFetch()");
        this._needNext = true;
        if (this._scrolling) {
            if (this._rowIndex != 0) {
                --this._rowIndex;
            }
            this._dead = false;
        }
    }

    public void previous() {
        Debug.println(this, "previous()");
        Debug.assert(this, this._scrolling, "previous can only be used with scrollable result sets.");
        Debug.println(this, "Index = " + this._rowIndex);
        Debug.assert(this, this._rowIndex > 0, "tried to call previous() when current row <= 0");
        --this._rowIndex;
        if (this._rowIndex != 0) {
            this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
        }
    }

    public void setType(int rsType) {
        this._type = rsType;
        if (this._type == 1004) {
            this._cachedRows = new Vector();
            this._scrolling = true;
        }
    }
}

