/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.timedio;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.timedio.StreamContext;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.Queue;
import com.sybase.jdbc2.utils.SyncObj;
import com.sybase.jdbc2.utils.SyncQueue;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;

public class OutStreamMgr {
    private Queue _requestList = new Queue(6, 6);
    private SyncQueue _waitList = new SyncQueue(6, 6);
    private InStreamMgr _inMgr;
    private StreamContext _cancelCtx;
    private StreamContext _cancelledCtx;
    private boolean _serialize = false;
    public Tds _tds;
    public boolean _tracing = false;

    public OutStreamMgr(InStreamMgr inMgr) {
        this._inMgr = inMgr;
        this._inMgr.setOutStreamMgr(this);
        this._cancelCtx = null;
        this._cancelledCtx = null;
    }

    public void abortRequest(StreamContext pc) {
        pc._request.giveToNext();
        Debug.println(this, "Send Ownership RELEASED. " + pc._request.whoAmI() + ", context= " + pc);
        Debug.println(this, "Send aborted, context = " + pc);
        this._requestList.removeElement(pc);
    }

    public void beginRequest(StreamContext context) throws SQLException {
        Debug.println(this, "beginRequest, context = " + context);
        context._request.validate();
        if (this._serialize) {
            try {
                this._inMgr.cacheResponses(context);
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.toString());
            }
        }
        Debug.println(this, "Send begin, context = " + context);
        context.beginRequest();
        this.queueRequest(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean cancelBySpec(StreamContext ctx, StreamContext cancelCtx) throws SQLException {
        Queue queue = this._requestList;
        synchronized (queue) {
            int count = 0;
            int waitForCtx = -1;
            this._requestList.reset();
            try {
                while (true) {
                    StreamContext pc;
                    if ((pc = (StreamContext)this._requestList.next()) == cancelCtx) {
                        continue;
                    }
                    if (waitForCtx >= 0) {
                        this._requestList.removeElement(cancelCtx);
                        Debug.println(this, "CANCELSLURP a BUSY context " + ctx);
                        ctx.setState(6);
                        return false;
                    }
                    if (pc == ctx) {
                        waitForCtx = count;
                        ctx.cancelled();
                        this._cancelledCtx = ctx;
                    }
                    ++count;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                Debug.println(this, "waitForCtx = " + waitForCtx);
                if (waitForCtx == 0) {
                    this._cancelCtx = cancelCtx;
                    return true;
                }
                if (waitForCtx < 0) {
                    if (this._inMgr.currentContext() == ctx && count == 0) {
                        this._cancelCtx = cancelCtx;
                        ctx.cancelled();
                        this._cancelledCtx = null;
                        return true;
                    }
                    this._requestList.removeElement(cancelCtx);
                    Debug.println(this, "_cancelledCtx not found");
                    this._cancelledCtx = null;
                    return false;
                }
            }
        }
        this._cancelCtx = cancelCtx;
        this._cancelledCtx = ctx;
        OutStreamMgr outStreamMgr = this;
        synchronized (outStreamMgr) {
            try {
                this.wait(this._cancelCtx._timeout);
            }
            catch (InterruptedException ie) {
                Debug.println(this, "Interrupted: " + ie);
            }
        }
        this._cancelledCtx = null;
        return true;
    }

    public boolean doCancelRequest(StreamContext ctx, StreamContext cancelCtx, boolean cancelAll) throws SQLException {
        Debug.println(this, "doCancelRequest: CANCELLED = " + ctx + ", CANCELLING = " + cancelCtx);
        cancelCtx.setState(4);
        Object object = this;
        synchronized (object) {
            boolean saveSerialize = this._serialize;
            try {
                this._serialize = false;
                this.getSendLock(cancelCtx);
                this.beginRequest(cancelCtx);
                Object var8_9 = null;
                this._serialize = saveSerialize;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this._serialize = saveSerialize;
                throw throwable;
            }
        }
        if (cancelAll) {
            object = this._requestList;
            synchronized (object) {
                StreamContext pc = this._inMgr.currentContext();
                if (pc != null) {
                    pc.cancelled();
                }
                this._cancelCtx = cancelCtx;
                this._cancelledCtx = null;
                this._requestList.reset();
                try {
                    while (true) {
                        if ((pc = (StreamContext)this._requestList.next()) == cancelCtx) {
                            continue;
                        }
                        pc.cancelled();
                        this._requestList.removeElement(pc);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                }
            }
        }
        if (!this.cancelBySpec(ctx, cancelCtx)) {
            if (ctx._state == 6) {
                object = this;
                synchronized (object) {
                    if (this._cancelledCtx != null) {
                        try {
                            this.wait(cancelCtx._timeout);
                        }
                        catch (InterruptedException ie) {
                            Debug.println(this, "Interrupted: " + ie);
                        }
                    }
                }
                this._cancelledCtx = null;
            }
            return false;
        }
        return true;
    }

    protected SyncObj dump() {
        SyncObj ret = null;
        return ret;
    }

    public void endRequest(StreamContext pc) {
        if (this._cancelCtx != null) {
            Debug.assert(this, pc == this._cancelCtx);
            this._cancelCtx = null;
            this._cancelledCtx = null;
        }
        pc._request.giveToNext();
        Debug.println(this, "Send Ownership RELEASED. " + pc._request.whoAmI() + ", context= " + pc);
    }

    protected StreamContext getNextContext() {
        StreamContext pc = (StreamContext)this._requestList.popNoEx();
        if (this._cancelledCtx == pc) {
            OutStreamMgr outStreamMgr = this;
            synchronized (outStreamMgr) {
                this.notify();
                this._cancelledCtx = null;
            }
        }
        return pc;
    }

    public boolean getSendLock(StreamContext context) throws SQLException {
        Debug.println(this, "getSendLock() " + context._request.whoAmI() + ", context = " + context);
        boolean first = false;
        switch (context._request.giveToMe(context._timeout)) {
            case 13: {
                first = true;
            }
            case 12: {
                Debug.println(this, "getSendLock permission for " + context._request.whoAmI() + ", context= " + context);
                break;
            }
            case 14: {
                ErrorMessage.raiseError("JZ0T4", Integer.toString(context._timeout));
            }
            default: {
                Debug.assert(this, false);
                ErrorMessage.raiseError("JZ0T4", Integer.toString(context._timeout));
            }
        }
        return first;
    }

    protected SyncQueue getWaitQueue() {
        return this._waitList;
    }

    protected StreamContext peekNextContext() throws EmptyStackException {
        return (StreamContext)this._requestList.peek();
    }

    public void queueRequest(StreamContext pc) {
        Debug.println(this, "queueRequest() " + pc._request.whoAmI() + ", context = " + pc);
        this._requestList.push(pc);
    }

    protected void setSerialize(boolean b) {
        this._serialize = b;
    }
}

