/*
 * Decompiled with CFR 0.152.
 */
package com.eg.webservice;

import com.eg.Base64Coder;
import com.eg.EgSSL;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import com.eg.webservice.EgWebServiceAuthenticator;
import com.eg.webservice.util.EgSOAPUtil;
import com.eg.webservice.util.EgWSDLUtil;
import com.ibm.wsdl.MessageImpl;
import com.ibm.wsdl.PartImpl;
import com.ibm.wsdl.extensions.schema.SchemaImportImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EgWebServiceBase {
    private String wsdlUrl;
    private String userName;
    private String passWord;
    private ArrayList operations;
    private QName portType;
    private HashMap services;
    private Document dom;
    private Definition defn;
    private HashMap userDefinedDataTypes;
    private String targetNamespace;
    private String prefix;
    private Types types;
    private int responseCode = 0;
    private HttpURLConnection connection = null;

    public EgWebServiceBase() {
    }

    public EgWebServiceBase(String wsdlUrl, String userName, String passWord) {
        this.wsdlUrl = wsdlUrl;
        this.userName = userName;
        this.passWord = passWord;
        this.operations = new ArrayList();
        this.services = new HashMap();
        this.userDefinedDataTypes = new HashMap();
        boolean gotDocument = this.getWSDLDocument();
        boolean gotDefinition = false;
        gotDefinition = gotDocument ? this.createDefinition() : this.createDefinition(true);
        if (gotDefinition) {
            this.getOperations();
        }
    }

    private boolean getWSDLDocument() {
        boolean flag = false;
        if (this.connect()) {
            try {
                try {
                    InputStream inStream = this.connection.getInputStream();
                    InputSource in = new InputSource(inStream);
                    in.setSystemId(this.wsdlUrl.toString());
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    dbf.setValidating(false);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    this.dom = db.parse(in);
                    flag = true;
                }
                catch (Exception e) {
                    flag = false;
                    this.disconnect();
                }
            }
            finally {
                this.disconnect();
            }
        } else {
            this.disconnect();
            flag = false;
        }
        return flag;
    }

    private boolean connect() {
        if (this.userName != null && this.userName.length() > 0 && !this.userName.equalsIgnoreCase("none") && this.passWord != null && this.passWord.length() > 0 && !this.passWord.equalsIgnoreCase("none")) {
            Authenticator.setDefault(new EgWebServiceAuthenticator(this.userName, this.passWord));
        }
        boolean flag = false;
        URL urldata = null;
        try {
            urldata = new URL(this.wsdlUrl);
            String protocol = urldata.getProtocol();
            protocol = protocol.toLowerCase();
            this.responseCode = 0;
            if (protocol.equals("https")) {
                EgSSL e = EgSSL.getInstance();
                EgSSL.enableSSL();
                SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object sock = null;
                MyX509TrustManager tm = new MyX509TrustManager();
                KeyManager[] km = null;
                TrustManager[] tma = new TrustManager[]{tm};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(km, tma, new SecureRandom());
                SSLSocketFactory sf1 = sc.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sf1);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
            }
        }
        catch (KeyManagementException e1) {
            e1.printStackTrace();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        try {
            this.connection = (HttpURLConnection)urldata.openConnection();
            this.connection.setRequestMethod("POST");
            this.connection.setDoOutput(true);
            this.connection.setDoInput(true);
            this.connection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            this.connection.setRequestProperty("Content-length", "0");
            this.connection.setConnectTimeout(60000);
            this.connection.connect();
            this.responseCode = this.connection.getResponseCode();
            flag = true;
        }
        catch (ConnectException ce) {
            this.responseCode = 503;
            flag = false;
        }
        catch (FileNotFoundException fe) {
            this.responseCode = 404;
            flag = false;
        }
        catch (Exception e) {
            this.responseCode = 500;
            flag = false;
        }
        return flag;
    }

    private void disconnect() {
        try {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean createDefinition(boolean result) {
        boolean flag = false;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            this.defn = reader.readWSDL(null, this.wsdlUrl);
            flag = true;
        }
        catch (WSDLException e) {
            System.out.println("Cannot Create Definitions..." + e.getMessage());
            e.printStackTrace();
        }
        return flag;
    }

    private boolean createDefinition() {
        boolean flag = false;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            this.defn = reader.readWSDL(this.wsdlUrl, this.dom.getDocumentElement());
            flag = true;
        }
        catch (WSDLException e) {
            System.out.println(" Cann't Create Definitions..");
            e.printStackTrace();
        }
        return flag;
    }

    private void getOperations() {
        this.targetNamespace = this.defn.getTargetNamespace();
        this.prefix = this.defn.getPrefix("http://www.w3.org/2001/XMLSchema");
        this.getAllServices();
        this.getAllTypes();
        this.getAllOperations();
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public HashMap getWsdlServices() {
        return this.services;
    }

    public ArrayList getWsdlOperations() {
        return this.operations;
    }

    public HashMap getAllServices() {
        this.services = EgWSDLUtil.getAllServices(this.defn);
        return this.services;
    }

    public Types getAllTypes() {
        this.types = EgWSDLUtil.getAllTypes(this.defn);
        return this.types;
    }

    public ArrayList getAllOperations() {
        Set keySet = this.services.keySet();
        Iterator keys = this.services.keySet().iterator();
        while (keys.hasNext()) {
            HashMap operation;
            String keyName = (String)keys.next();
            HashMap serviceInfo = (HashMap)this.services.get(keyName);
            ArrayList innerList = (ArrayList)serviceInfo.get(keyName);
            if (innerList == null) continue;
            int k = 0;
            while (k < innerList.size()) {
                ArrayList operationList;
                HashMap innerMap = (HashMap)innerList.get(k);
                QName binding = (QName)innerMap.get("Binding");
                if (binding != null && (operationList = EgWSDLUtil.getAllOperations(this.defn, binding)) != null) {
                    int j = 0;
                    while (j < operationList.size()) {
                        Object operationObject = operationList.get(j);
                        if (!this.operations.contains(operationObject)) {
                            this.operations.add(operationObject);
                        }
                        ++j;
                    }
                }
                ++k;
            }
            ArrayList allNodeList = this.getAllElementValues();
            Iterator itr = ((AbstractList)this.operations).iterator();
            while (itr.hasNext()) {
                operation = (HashMap)itr.next();
                operation = this.populateInputs(operation);
            }
            itr = ((AbstractList)this.operations).iterator();
            while (itr.hasNext()) {
                operation = (HashMap)itr.next();
                operation = this.getInputMap(operation, allNodeList);
            }
            serviceInfo.put("Operations", this.operations);
        }
        return this.operations;
    }

    private HashMap populateInputs(HashMap operation) {
        QName portTypeKey = (QName)operation.get("PortType");
        PortType port = this.defn.getPortType(portTypeKey);
        List portOperations = port.getOperations();
        Map wsdlMessage = EgWSDLUtil.getAllMessages(this.defn);
        String operationName = (String)operation.get("OperationName");
        int i = 0;
        while (i < portOperations.size()) {
            Operation portOperation = (Operation)portOperations.get(i);
            if (portOperation.getName().equals(operationName) && portOperation.getInput().getMessage() != null) {
                Iterator keys;
                Map parts = portOperation.getInput().getMessage().getParts();
                QName headerName = (QName)operation.get("soapheader");
                if (headerName != null) {
                    MessageImpl messimpl = (MessageImpl)wsdlMessage.get(headerName);
                    Map messagePart = messimpl.getParts();
                    Iterator partkeys = messagePart.keySet().iterator();
                    while (partkeys.hasNext()) {
                        PartImpl im = (PartImpl)messagePart.get(partkeys.next());
                        try {
                            operation.put("HeaderInputType", im.getElementName().getLocalPart());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if ((keys = parts.keySet().iterator()).hasNext()) {
                    PartImpl part = (PartImpl)parts.get(keys.next());
                    QName elementQName = part.getElementName();
                    if (elementQName != null) {
                        operation.put("InputType", part.getElementName().getLocalPart());
                    } else {
                        operation.put("input", parts);
                        operation.put("InputType", operationName);
                    }
                }
            }
            ++i;
        }
        return operation;
    }

    public ArrayList getAllElementValues() {
        ArrayList arr = new ArrayList();
        if (this.types != null) {
            List childElements = this.types.getExtensibilityElements();
            Iterator keys = childElements.iterator();
            while (keys.hasNext()) {
                try {
                    Schema schema = (Schema)keys.next();
                    ArrayList schemaImport = new ArrayList();
                    arr.addAll(this.getallNodeValues(schema, schemaImport));
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return arr;
    }

    private ArrayList getallNodeValues(Schema schema, ArrayList schemaLoc) {
        ArrayList<NodeList> allMainNodeLists = new ArrayList<NodeList>();
        Element schemaElement = schema.getElement();
        String prefix = schema.getElement().getPrefix();
        if (prefix != null) {
            allMainNodeLists.add(schemaElement.getElementsByTagName(String.valueOf(prefix) + ":element"));
            allMainNodeLists.add(schemaElement.getElementsByTagName(String.valueOf(prefix) + ":complexType"));
            allMainNodeLists.add(schemaElement.getElementsByTagName(String.valueOf(prefix) + ":simpleType"));
        } else {
            allMainNodeLists.add(schemaElement.getElementsByTagName("element"));
            allMainNodeLists.add(schemaElement.getElementsByTagName("complexType"));
            allMainNodeLists.add(schemaElement.getElementsByTagName("simpleType"));
        }
        Map schemaImports = schema.getImports();
        if (!schemaImports.isEmpty()) {
            Iterator schemakeys = schemaImports.keySet().iterator();
            while (schemakeys.hasNext()) {
                List schemaValues = (List)schemaImports.get(schemakeys.next());
                Iterator itr = schemaValues.iterator();
                while (itr.hasNext()) {
                    Object schemaKeyValues = itr.next();
                    SchemaImportImpl schemaImpl = (SchemaImportImpl)schemaKeyValues;
                    String schemaLocation = schemaImpl.getSchemaLocationURI();
                    if (schemaLocation == null || schemaLoc.contains(schemaLocation)) continue;
                    schemaLoc.add(schemaLocation);
                    Schema schemaRef = schemaImpl.getReferencedSchema();
                    allMainNodeLists.addAll(this.getallNodeValues(schemaRef, schemaLoc));
                }
            }
        }
        return allMainNodeLists;
    }

    private HashMap getInputMap(HashMap operation, ArrayList nodeListArray) {
        return EgWSDLUtil.getInputMap(operation, nodeListArray);
    }

    public String getSOAPRequest(HashMap operation, Hashtable params) {
        return EgSOAPUtil.getSOAPRequest(operation, this.prefix, this.targetNamespace, params);
    }

    public String getSOAPRequest(HashMap operation) {
        return EgSOAPUtil.getSOAPRequest(operation, this.prefix, this.targetNamespace);
    }

    public static void main(String[] args) {
        int argsLen = args.length;
        String testUrl = "http://webservices.daehosting.com/services/TemperatureConversions.wso?WSDL";
        String userName = "None";
        String passWord = "None";
        if (argsLen > 0) {
            testUrl = args[0];
            if (argsLen == 3) {
                userName = args[1];
                passWord = args[2];
            }
        }
        if (argsLen == 0) {
            System.out.println("=====================================================================================");
            System.out.println("                         eG Web Service Monitring                                    ");
            System.out.println("=====================================================================================");
            System.out.println("USAGE :");
            System.out.println("         java EgWebServiceBase  <<WSDL_URL>>  <<USER_NAME>>  <<PASS_WORD>>");
            System.out.println("  (e.g) ");
            System.out.println("         java EgWebServiceBase " + testUrl);
            System.out.println("=====================================================================================");
        }
        EgWebServiceBase wsclient = new EgWebServiceBase(testUrl, userName, passWord);
        ArrayList operationArrList = wsclient.getWsdlOperations();
        if (wsclient.getWsdlOperations() != null && wsclient.getWsdlOperations().size() > 0) {
            int k = 0;
            while (k < operationArrList.size()) {
                HashMap operation = (HashMap)operationArrList.get(k);
                String SOAPReq = wsclient.getSOAPRequest(operation);
                String operationName = (String)operation.get("OperationName");
                if (operation.containsKey("Input")) {
                    try {
                        HashMap inputHashTable = (HashMap)operation.get("Input");
                        Set keys = inputHashTable.keySet();
                        Iterator thisItr = keys.iterator();
                        while (thisItr.hasNext()) {
                            String string = (String)thisItr.next();
                        }
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                } else {
                    System.out.println(" This Operation doesn't have any inputs");
                }
                System.out.print("\n operationName : " + operationName);
                String soapActionUrl = (String)operation.get("SOAPAction");
                if (soapActionUrl != null && soapActionUrl.length() > 0) {
                    System.out.println("\t SOAP Action URL : " + soapActionUrl);
                } else {
                    System.out.println(" \t SOAP Action URL : " + soapActionUrl);
                }
                System.out.println("==========================================================================");
                System.out.println(SOAPReq);
                System.out.println("\n\n");
                ++k;
            }
        }
    }

    public static String invokeOperation(String xmlInput, String SOAPActionUrl, String targetURL, String userName, String passWord) {
        String responseString = null;
        String cause = "";
        try {
            SOAPConnectionFactory conFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = conFactory.createConnection();
            MessageFactory msgFactory = MessageFactory.newInstance();
            SOAPMessage message = msgFactory.createMessage();
            SOAPPart soapPart = message.getSOAPPart();
            MimeHeaders headers = message.getMimeHeaders();
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            if (SOAPActionUrl != null && SOAPActionUrl.length() > 0) {
                headers.addHeader("SOAPAction", SOAPActionUrl);
            }
            if (userName != null && userName.length() > 0 && passWord != null && passWord.length() > 0 && !userName.equalsIgnoreCase("none") && !passWord.equalsIgnoreCase("none")) {
                String authorization = Base64Coder.encodeString((String)(String.valueOf(userName) + ":" + passWord));
                headers.addHeader("Authorization", "Basic " + authorization);
            }
            byte[] buffer = xmlInput.getBytes();
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
            StreamSource source = new StreamSource(stream);
            soapPart.setContent((Source)source);
            message.saveChanges();
            URL endpoint = new URL(targetURL);
            ByteArrayOutputStream msgStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)msgStream);
            SOAPMessage response = connection.call(message, (Object)endpoint);
            Source responseContent = response.getSOAPPart().getContent();
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult streamResult = new StreamResult(sw);
            transformer.transform(responseContent, streamResult);
            responseString = sw.toString();
            connection.close();
        }
        catch (Exception e) {
            System.out.println("Exception Occured while invoking Operation ... ");
            cause = "<Error>" + e.getMessage();
        }
        if (responseString == null) {
            responseString = cause;
        }
        return responseString;
    }
}

